<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Services\Cachable\ModelCaching\Traits\Cachable;

class Settings extends Model {
    use Cachable;
    protected $table = "settings";
    protected $fillable = [
        'min_rga', 
        'min_ega', 
        'rga', 
        'ega', 
        'rss', 
        'ess', 
        'dss', 
        'scs', 
        'egi', 
        'dsi', 
        'egg', 
        'dgg', 
        'title',
        'site_name',
        'site_desc',
        'address',
        'email',
        'support_email',
        'recovery_email',
        'mobile',
        'livechat',
        'recaptcha',
        'email_template',
        'default_font',
        'analytic_snippet',
        'admin_url',
        'registration',
        'email_notify',
        'language',
        'maintenance',
        'career_url',
        'NOCAPTCHA_SECRET',
        'NOCAPTCHA_SITEKEY',
        'timezone',
        'otp',
        'xperiod',
        'terms',
        'privacy',
        'about',
        'google_sl',
        'google_ci',
        'google_cs',
        'facebook_sl',
        'facebook_ci',
        'facebook_cs',
        'email_verify',
        'phone_verify',
        'routing_type',
        'payout',
        'min_pl',
        'max_pl',
        'min_account',
        'max_account',
        'fiat_pc',
        'percent_pc',
        'pct',
        'money_transfer',
        'min_tl',
        'max_tl',
        'fiat_tc',
        'percent_tc',
        'tct',
        'twilio_number',
        'twilio_account_sid',
        'twilio_auth_token',
        'referral',
        'referral_bonus',
        'dp_bank_name',
        'bk_routing_code',
        'bk_acct_no',
        'bk_acct_name',
        'bk_status',
        'currency_format',
        'loan',
        'buy_now_pay_later',
        'savings',
        'mutual_fund',
        'project_investment',
    ];
}
