/*!
 * Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2022 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();
  var STYLE_TO_PREFIX = {
    'solid': 'fas',
    'regular': 'far',
    'light': 'fal',
    'thin': 'fat',
    'duotone': 'fad',
    'brands': 'fab',
    'kit': 'fak'
  };
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var DUOTONE_CLASSES = {
    GROUP: 'duotone-group',
    SWAP_OPACITY: 'swap-opacity',
    PRIMARY: 'primary',
    SECONDARY: 'secondary'
  };
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Object.keys(STYLE_TO_PREFIX)), ['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', 'beat', 'border', 'fade', 'beat-fade', 'bounce', 'flip-both', 'flip-horizontal', 'flip-vertical', 'flip', 'fw', 'inverse', 'layers-counter', 'layers-text', 'layers', 'li', 'pull-left', 'pull-right', 'pulse', 'rotate-180', 'rotate-270', 'rotate-90', 'rotate-by', 'shake', 'spin-pulse', 'spin-reverse', 'spin', 'stack-1x', 'stack-2x', 'stack', 'ul', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function (n) {
    return "".concat(n, "x");
  })).concat(oneToTwenty.map(function (n) {
    return "w-".concat(n);
  }));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M160 32.01c-88.22 0-160 71.78-160 160v127.1c0 88.22 71.78 160 160 160s160-71.78 160-160V192C320 103.8 248.2 32.01 160 32.01zM288 320c0 70.59-57.41 128-128 128s-128-57.41-128-128V192c0-70.59 57.41-128 128-128s128 57.41 128 128V320z"],
    "1": [256, 512, [], "31", "M256 464c0 8.844-7.156 16-16 16h-224C7.156 480 0 472.8 0 464S7.156 448 16 448h96V78.72L57.17 117.1C49.95 122.2 39.95 120.4 34.89 113.2C29.83 105.9 31.58 95.97 38.83 90.91l80-55.1c4.891-3.438 11.28-3.875 16.56-1.094C140.7 36.57 144 42.04 144 48.01V448h96C248.8 448 256 455.2 256 464z"],
    "2": [320, 512, [], "32", "M320 463.1C320 472.8 312.8 480 304 480H16c-6.607 0-12.53-4.064-14.92-10.22s-.7344-13.16 4.156-17.63l213.2-194.2c45.7-40.07 51.02-107.7 12.28-154.2C211.5 80.66 184.4 66.66 154.4 64.29c-29.75-2.221-58.89 7.25-81.53 27.03L40.86 119.4C34.22 125.1 24.13 124.5 18.28 117.9C12.47 111.2 13.14 101.1 19.8 95.29l32.05-28.04C81 41.72 118.6 29.66 156.9 32.38c38.64 3.064 73.58 21.13 98.39 50.88c49.94 59.95 43.09 147.2-15.55 198.6l-182.4 166.1H304C312.8 447.1 320 455.2 320 463.1z"],
    "3": [320, 512, [], "33", "M320 352c0 70.59-57.42 128-128 128H93.09c-41.94 0-79.02-26.72-92.27-66.5c-2.797-8.375 1.734-17.44 10.11-20.25c8.422-2.812 17.44 1.75 20.23 10.12C40.08 430.1 64.95 448 93.09 448H192c52.94 0 96-43.06 96-96s-43.06-96-96-96H80C73.41 256 67.5 251.1 65.09 245.8c-2.391-6.125-.7813-13.09 4.047-17.56L247.1 64H16C7.156 64 0 56.84 0 48S7.156 32 16 32h272c6.594 0 12.5 4.031 14.91 10.19c2.391 6.125 .7813 13.09-4.047 17.56L120.9 224H192C262.6 224 320 281.4 320 352z"],
    "4": [384, 512, [], "34", "M384 336c0 8.843-7.156 15.1-15.1 15.1l-47.1-.005l.0006 111.1c0 8.843-7.156 15.1-15.1 15.1s-15.1-7.156-15.1-15.1v-111.1H16c-5.547 0-10.69-2.875-13.61-7.593C-.5267 339.7-.7923 333.8 1.692 328.9l143.1-287.1c3.969-7.875 13.55-11.16 21.47-7.156c7.906 3.969 11.11 13.56 7.156 21.47l-132.4 264.8h246.1V144c0-8.843 7.156-15.1 15.1-15.1s15.1 7.156 15.1 15.1v175.1h47.1C376.8 320 384 327.2 384 336z"],
    "5": [320, 512, [], "35", "M320 352c0 70.59-57.42 128-128 128H94.7c-42.66 0-80.39-27.19-93.88-67.66c-2.797-8.375 1.734-17.44 10.11-20.25c8.484-2.844 17.45 1.75 20.23 10.12C40.31 429.6 65.84 448 94.7 448H192c52.94 0 96-43.06 96-96s-43.06-96-96-96H16C11.08 256 6.422 253.7 3.391 249.8s-4.109-8.938-2.906-13.72l48-192C50.27 37 56.66 32.01 64 32.01L272 32C280.8 32 288 39.16 288 48S280.8 64 272 64H76.5l-40 160H192C262.6 224 320 281.4 320 352z"],
    "6": [320, 512, [], "36", "M0 320c0 88.22 71.78 160 160 160s160-71.78 160-160S248.2 160 160 160C147.5 160 135.4 161.8 123.7 164.5l96.17-105.8c5.938-6.531 5.469-16.66-1.094-22.59C215.7 33.38 211.8 32.01 208 32.01c-4.344 0-8.688 1.74-11.84 5.24C51.7 196.1 0 238.6 0 320zM288 320c0 70.59-57.41 128-128 128s-128-57.41-128-128s57.41-128 128-128S288 249.4 288 320z"],
    "7": [320, 512, [], "37", "M317.6 56.38l-256 416C58.6 477.3 53.35 480 48 480c-2.875 0-5.781-.75-8.375-2.375c-7.531-4.625-9.875-14.5-5.25-22L275.4 64H16C7.156 64 0 56.84 0 48S7.156 32 16 32h288c5.781 0 11.13 3.125 13.97 8.188C320.8 45.25 320.7 51.44 317.6 56.38z"],
    "8": [320, 512, [], "38", "M250.7 251.7C282.8 230.1 304 193.5 304 152C304 85.84 250.2 32 184 32h-48C69.84 32 16 85.84 16 152c0 41.48 21.19 78.09 53.29 99.65C28.5 270.8 0 312 0 360C0 426.2 53.84 480 120 480h80c66.16 0 120-53.84 120-120C320 312 291.5 270.8 250.7 251.7zM48 152C48 103.5 87.47 64 136 64h48c48.53 0 88 39.47 88 88S232.5 240 184 240h-48C87.47 240 48 200.5 48 152zM200 448h-80C71.47 448 32 408.5 32 360S71.47 272 120 272h80c48.53 0 88 39.47 88 88S248.5 448 200 448z"],
    "9": [320, 512, [], "39", "M320 192c0-88.22-71.78-160-160-160s-160 71.78-160 160S71.78 352 160 352c12.54 0 24.61-1.797 36.33-4.539l-96.17 105.8c-5.938 6.531-5.469 16.66 1.094 22.59C104.3 478.6 108.2 480 112 480c4.344 0 8.688-1.76 11.84-5.26C268.3 315.9 320 273.4 320 192zM32 192c0-70.59 57.41-128 128-128s128 57.41 128 128s-57.41 128-128 128S32 262.6 32 192z"],
    "00": [640, 512, [], "e467", "M288 176V336C288 415.5 223.5 480 144 480C64.47 480 0 415.5 0 336V176C0 96.47 64.47 32 144 32C223.5 32 288 96.47 288 176zM32 336C32 397.9 82.14 448 144 448C205.9 448 256 397.9 256 336V176C256 114.1 205.9 64 144 64C82.14 64 32 114.1 32 176V336zM640 176V336C640 415.5 575.5 480 496 480C416.5 480 352 415.5 352 336V176C352 96.47 416.5 32 496 32C575.5 32 640 96.47 640 176zM384 336C384 397.9 434.1 448 496 448C557.9 448 608 397.9 608 336V176C608 114.1 557.9 64 496 64C434.1 64 384 114.1 384 176V336z"],
    "360-degrees": [640, 512, [], "e2dc", "M496 64c-44.12 0-79.1 35.89-79.1 80v224c0 44.11 35.88 80 79.1 80s79.1-35.89 79.1-80v-224C576 99.89 540.1 64 496 64zM544 368c0 26.47-21.53 48-47.1 48c-26.47 0-47.1-21.53-47.1-48v-224c0-26.47 21.53-48 47.1-48c26.47 0 47.1 21.53 47.1 48V368zM304 192C285.9 192 269.4 198.3 256 208.4V204.6c0-46.78 29.53-89.05 73.44-105.2l12.06-4.422c8.312-3.031 12.56-12.22 9.531-20.52c-3.031-8.312-12.31-12.56-20.53-9.516L318.4 69.41C261.9 90.11 224 144.4 224 204.6L224 368c0 44.11 35.88 80 79.1 80s79.1-35.89 79.1-80l.0001-96C384 227.9 348.1 192 304 192zM352 368c0 26.47-21.53 48-47.1 48c-26.47 0-47.1-21.53-47.1-48v-96c0-26.47 21.53-48 47.1-48c26.47 0 48 21.53 48 48V368zM608 0c-17.67 0-31.1 14.33-31.1 32c0 17.67 14.33 32 31.1 32C625.7 64 640 49.67 640 32C640 14.33 625.7 0 608 0zM81.44 208l95.03-117.1C180.3 85.23 181.1 78.66 178.4 73.09C175.8 67.53 170.2 64 164 64H16C7.161 64 .0047 71.16 .0047 80S7.161 96 16 96h114.6L35.54 213.1c-3.844 4.797-4.625 11.38-1.969 16.94S41.85 240 48 240h32.72c43.72 0 79.28 35.56 79.28 79.28v17.44C160 380.4 124.4 416 80.72 416c-21.53 0-41.47-10.64-50.81-27.11c-4.375-7.703-14.16-10.38-21.81-6.016c-7.687 4.375-10.37 14.14-5.1 21.83C17.25 431.4 47.38 448 80.72 448c61.37 0 111.3-49.92 111.3-111.3V319.3C192 258.2 142.5 208.4 81.44 208z"],
    "a": [384, 512, [97], "41", "M382.7 457.7L206.7 40.92c-4.1-11.9-24.47-11.9-29.47 0L1.267 457.7c-3.437 8.141 .3594 17.53 8.5 21.01c8.078 3.319 17.52-.3757 20.97-8.548l36.48-86.39h249.6l36.48 86.39C355.8 476.3 361.8 480 367.1 480c2.078 0 4.203-.407 6.234-1.252C382.4 475.3 386.2 465.9 382.7 457.7zM80.75 351.7L192 88.3l111.2 263.5H80.75z"],
    "abacus": [576, 512, [129518], "f640", "M512 32H64c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64v-320C576 60.65 547.3 32 512 32zM512 64c17.64 0 32 14.36 32 32v96h-96l0-31.1L464 160C472.8 160 480 152.8 480 144s-7.156-15.1-16-15.1L448 128V64H512zM416 64v64l-16 .0002c-8.844 0-16 7.156-16 15.1S391.2 160 400 160l15.1 .0004L416 192h-128l0-31.1L304 160C312.8 160 320 152.8 320 144s-7.156-15.1-16-15.1L288 128V64H416zM256 64v64L240 128C231.2 128 224 135.2 224 144S231.2 160 240 160l15.1 .0004L256 192H160l0-31.1L176 160C184.8 160 192 152.8 192 144S184.8 128 176 128L160 128V64H256zM32 96c0-17.64 14.36-32 32-32h64v64L112 128C103.2 128 96 135.2 96 144S103.2 160 112 160l15.1 .0004L128 192H32V96zM64 448c-17.64 0-32-14.36-32-32V224h96v64L112 288C103.2 288 96 295.2 96 304S103.2 320 112 320l15.1 .0004v32L112 352C103.2 352 96 359.2 96 368s7.156 16 16 16L128 384v64H64zM160 448v-64l16 .0002c8.844 0 16-7.156 16-16S184.8 352 176 352l-15.1 .0004v-32L176 320C184.8 320 192 312.8 192 304S184.8 288 176 288L160 288V224h96v64L240 288C231.2 288 224 295.2 224 304S231.2 320 240 320l15.1 .0004v32L240 352C231.2 352 224 359.2 224 368s7.156 16 16 16L256 384v64H160zM288 448v-64l16 .0002c8.844 0 16-7.156 16-16S312.8 352 304 352l-15.1 .0004v-32L304 320c8.844 0 16-7.156 16-16s-7.156-15.1-16-15.1L288 288V224h128l0 128L400 352c-8.844 0-16 7.156-16 16s7.156 16 16 16L416 384v64H288zM544 416c0 17.64-14.36 32-32 32h-64v-64l16 .0002c8.844 0 16-7.156 16-16S472.8 352 464 352l-15.1 .0004L448 224h96V416z"],
    "accent-grave": [192, 512, [], "60", "M40.3 90.61l67.69 115.4c6.688 11.43 18.84 18.03 31.51 18.03c4.164 0 8.381-.7115 12.48-2.2c16.59-6.018 26.48-22.99 23.49-40.31l-22.57-131.7c-3.045-17.81-13.79-33.2-29.45-42.25c-8.891-5.154-18.84-7.542-28.8-7.544c-.0039 0 .002 0 0 0c-25.06 0-50.23 15.13-58.1 39.39C29.5 56.36 31.18 75.03 40.3 90.61zM65.73 50.31C69.51 39.86 81.94 32 94.65 32c4.77 .002 9.062 1.088 12.76 3.229c7.449 4.307 12.52 11.57 13.96 19.96l22.57 131.7c.3594 2.076-.8457 4.092-2.861 4.822c-.457 .0449-.8828 .0684-1.283 .0684c-2.074 0-3.387-.625-4.18-1.98L67.9 74.42C63.63 67.11 62.83 58.31 65.73 50.31z"],
    "acorn": [448, 512, [], "f6ae", "M352 64.04l-106.6-.0063c4.447-13.69 11.63-26.44 21.9-36.72c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0C228.4 21 217.2 41.76 211.9 64.03L96 64.04c-53 0-95.1 42.97-95.1 95.97L0 176c0 17.62 14.38 32 32 32V224c0 98 55.38 187.8 143.1 231.5L224 480l48.88-24.5C360.6 411.8 416 322 416 224V208c17.62 0 32-14.38 32-32l-.001-16.01C447.1 107 405 64.04 352 64.04zM384 224c0 86.5-48 164.3-125.4 202.9L224 444.3l-34.63-17.38C112 388.3 64 310.5 64 224V208h320V224zM416 176H32V160c0-35.25 28.75-64 64-64h256c35.25 0 64 28.75 64 64V176z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M272 288h-64C163.8 288 128 323.8 128 368C128 376.8 135.2 384 144 384C152.8 384 160 376.8 160 368C160 341.5 181.5 320 208 320h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16c8.837 0 16-7.164 16-16C352 323.8 316.2 288 272 288zM496 192H480v96h16C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S204.7 256 240 256zM240 160c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S222.4 160 240 160zM496 320H480v96h16c8.837 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 64H480v96h16C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM384 0H96C60.65 0 32 28.65 32 64v384c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H96c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32V448z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M480 288h-128c-8.836 0-16 7.164-16 16S343.2 320 352 320h128c8.836 0 16-7.164 16-16S488.8 288 480 288zM192 256c35.35 0 64-28.65 64-64S227.3 128 192 128S128 156.7 128 192S156.7 256 192 256zM192 160c17.64 0 32 14.36 32 32S209.6 224 192 224S160 209.6 160 192S174.4 160 192 160zM224 288H160c-44.18 0-80 35.82-80 80C80 376.8 87.16 384 96 384s16-7.164 16-16C112 341.5 133.5 320 160 320h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16C304 323.8 268.2 288 224 288zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM480 224h-128c-8.836 0-16 7.164-16 16S343.2 256 352 256h128c8.836 0 16-7.164 16-16S488.8 224 480 224zM480 160h-128c-8.836 0-16 7.164-16 16S343.2 192 352 192h128c8.836 0 16-7.164 16-16S488.8 160 480 160z"],
    "air-conditioner": [576, 512, [], "f8f4", "M224 416c0 35.3-28.7 64-64 64c-26.47 0-48-21.53-48-48S133.5 384 160 384c8.836 0 16-7.164 16-16S168.8 352 160 352c-44.11 0-80 35.89-80 79.1S115.9 512 160 512c52.94 0 96-43.06 96-96V288H224V416zM416 320c-8.836 0-16 7.164-16 15.1S407.2 352 416 352c26.47 0 48 21.53 48 48S442.5 448 416 448c-35.3 0-64-28.7-64-64V288h-32v96c0 52.94 43.06 96 96 96c44.11 0 80-35.89 80-80S460.1 320 416 320zM512 .0002H64c-35.2 0-64 28.8-64 64V192c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64V64C576 28.8 547.2 .0002 512 .0002zM544 192c0 17.67-14.33 32-32 32H64C46.33 224 32 209.7 32 192V64c0-17.67 14.33-32 32-32h448c17.67 0 32 14.33 32 32V192zM464 128h-352C103.2 128 96 135.2 96 144S103.2 160 112 160h352C472.8 160 480 152.8 480 144S472.8 128 464 128z"],
    "airplay": [576, 512, [], "e089", "M496 32h-416C35.88 32 0 67.88 0 112v224C0 380.1 35.88 416 80 416C88.84 416 96 408.8 96 400S88.84 384 80 384C53.53 384 32 362.5 32 336v-224C32 85.53 53.53 64 80 64h416C522.5 64 544 85.53 544 112v224c0 26.47-21.53 48-48 48c-8.844 0-16 7.156-16 16s7.156 16 16 16c44.13 0 80-35.88 80-80v-224C576 67.88 540.1 32 496 32zM310.6 297.4c-12.5-12.5-32.86-12.5-45.36 0l-127.1 128C117.3 445.5 131.7 480 160 480h255.9c28.37 0 42.73-34.5 22.62-54.63L310.6 297.4zM160 448l127.1-128L415.1 448H160z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M92.19 0C116.4 0 138.4 9.345 154.9 24.59C161.4 30.6 161.7 40.73 155.7 47.2C149.7 53.68 139.6 54.06 133.1 48.05C122.4 38.08 108 32 92.19 32C58.95 32 32 58.95 32 92.19C32 104.1 35.44 115.2 41.38 124.5C46.13 131.9 43.94 141.8 36.49 146.6C29.03 151.3 19.14 149.1 14.4 141.7C5.28 127.4 0 110.4 0 92.19C0 41.28 41.28 .0003 92.19 .0003L92.19 0zM357.1 24.59C373.6 9.345 395.6 0 419.8 0C470.7 0 512 41.28 512 92.19C512 110.4 506.7 127.4 497.6 141.7C492.9 149.1 482.1 151.3 475.5 146.6C468.1 141.8 465.9 131.9 470.6 124.5C476.6 115.2 480 104.1 480 92.19C480 58.95 453 32 419.8 32C403.1 32 389.6 38.08 378.9 48.05C372.4 54.06 362.3 53.68 356.3 47.2C350.3 40.73 350.6 30.6 357.1 24.59L357.1 24.59zM272 296L329.6 339.2C336.7 344.5 338.1 354.5 332.8 361.6C327.5 368.7 317.5 370.1 310.4 364.8L246.4 316.8C242.4 313.8 239.1 309 239.1 304V176C239.1 167.2 247.2 160 255.1 160C264.8 160 272 167.2 272 176V296zM36.69 507.3C30.44 501.1 30.44 490.9 36.69 484.7L86.7 434.7C52.62 395.4 32 344.1 32 287.1C32 164.3 132.3 63.1 256 63.1C379.7 63.1 480 164.3 480 287.1C480 344.1 459.4 395.4 425.3 434.7L475.3 484.7C481.6 490.9 481.6 501.1 475.3 507.3C469.1 513.6 458.9 513.6 452.7 507.3L402.7 457.3C363.4 491.4 312.1 512 256 512C199.9 512 148.6 491.4 109.3 457.3L59.31 507.3C53.07 513.6 42.93 513.6 36.69 507.3V507.3zM255.1 480C362 480 448 394 448 288C448 181.1 362 96 255.1 96C149.1 96 63.1 181.1 63.1 288C63.1 394 149.1 480 255.1 480z"],
    "alarm-exclamation": [512, 512, [], "f843", "M92.19 0C116.4 0 138.4 9.345 154.9 24.59C161.4 30.6 161.7 40.73 155.7 47.2C149.7 53.68 139.6 54.06 133.1 48.05C122.4 38.08 108 32 92.19 32C58.95 32 32 58.95 32 92.19C32 104.1 35.44 115.2 41.38 124.5C46.13 131.9 43.94 141.8 36.49 146.6C29.03 151.3 19.14 149.1 14.4 141.7C5.28 127.4 0 110.4 0 92.19C0 41.28 41.28 .0003 92.19 .0003L92.19 0zM357.1 24.59C373.6 9.345 395.6 0 419.8 0C470.7 0 512 41.28 512 92.19C512 110.4 506.7 127.4 497.6 141.7C492.9 149.1 482.1 151.3 475.5 146.6C468.1 141.8 465.9 131.9 470.6 124.5C476.6 115.2 480 104.1 480 92.19C480 58.95 453 32 419.8 32C403.1 32 389.6 38.08 378.9 48.05C372.4 54.06 362.3 53.68 356.3 47.2C350.3 40.73 350.6 30.6 357.1 24.59L357.1 24.59zM255.1 160C264.8 160 272 167.2 272 176V320C272 328.8 264.8 336 255.1 336C247.2 336 239.1 328.8 239.1 320V176C239.1 167.2 247.2 160 255.1 160zM280 384C280 397.3 269.3 408 255.1 408C242.7 408 231.1 397.3 231.1 384C231.1 370.7 242.7 360 255.1 360C269.3 360 280 370.7 280 384zM36.69 507.3C30.44 501.1 30.44 490.9 36.69 484.7L86.7 434.7C52.62 395.4 32 344.1 32 287.1C32 164.3 132.3 63.1 256 63.1C379.7 63.1 480 164.3 480 287.1C480 344.1 459.4 395.4 425.3 434.7L475.3 484.7C481.6 490.9 481.6 501.1 475.3 507.3C469.1 513.6 458.9 513.6 452.7 507.3L402.7 457.3C363.4 491.4 312.1 512 256 512C199.9 512 148.6 491.4 109.3 457.3L59.31 507.3C53.07 513.6 42.93 513.6 36.69 507.3V507.3zM255.1 480C362 480 448 394 448 288C448 181.1 362 96 255.1 96C149.1 96 63.1 181.1 63.1 288C63.1 394 149.1 480 255.1 480z"],
    "alarm-plus": [512, 512, [], "f844", "M92.19 0C116.4 0 138.4 9.345 154.9 24.59C161.4 30.6 161.7 40.73 155.7 47.2C149.7 53.68 139.6 54.06 133.1 48.05C122.4 38.08 108 32 92.19 32C58.95 32 32 58.95 32 92.19C32 104.1 35.44 115.2 41.38 124.5C46.13 131.9 43.94 141.8 36.49 146.6C29.03 151.3 19.14 149.1 14.4 141.7C5.28 127.4 0 110.4 0 92.19C0 41.28 41.28 .0003 92.19 .0003L92.19 0zM357.1 24.59C373.6 9.345 395.6 0 419.8 0C470.7 0 512 41.28 512 92.19C512 110.4 506.7 127.4 497.6 141.7C492.9 149.1 482.1 151.3 475.5 146.6C468.1 141.8 465.9 131.9 470.6 124.5C476.6 115.2 480 104.1 480 92.19C480 58.95 453 32 419.8 32C403.1 32 389.6 38.08 378.9 48.05C372.4 54.06 362.3 53.68 356.3 47.2C350.3 40.73 350.6 30.6 357.1 24.59L357.1 24.59zM255.1 176C264.8 176 272 183.2 272 192V272H352C360.8 272 368 279.2 368 288C368 296.8 360.8 304 352 304H272V384C272 392.8 264.8 400 255.1 400C247.2 400 239.1 392.8 239.1 384V304H159.1C151.2 304 143.1 296.8 143.1 288C143.1 279.2 151.2 272 159.1 272H239.1V192C239.1 183.2 247.2 176 255.1 176zM36.69 507.3C30.44 501.1 30.44 490.9 36.69 484.7L86.7 434.7C52.62 395.4 32 344.1 32 287.1C32 164.3 132.3 63.1 256 63.1C379.7 63.1 480 164.3 480 287.1C480 344.1 459.4 395.4 425.3 434.7L475.3 484.7C481.6 490.9 481.6 501.1 475.3 507.3C469.1 513.6 458.9 513.6 452.7 507.3L402.7 457.3C363.4 491.4 312.1 512 256 512C199.9 512 148.6 491.4 109.3 457.3L59.31 507.3C53.07 513.6 42.93 513.6 36.69 507.3V507.3zM255.1 480C362 480 448 394 448 288C448 181.1 362 96 255.1 96C149.1 96 63.1 181.1 63.1 288C63.1 394 149.1 480 255.1 480z"],
    "alarm-snooze": [512, 512, [], "f845", "M92.19 0C116.4 0 138.4 9.345 154.9 24.59C161.4 30.6 161.7 40.73 155.7 47.2C149.7 53.68 139.6 54.06 133.1 48.05C122.4 38.08 108 32 92.19 32C58.95 32 32 58.95 32 92.19C32 104.1 35.44 115.2 41.38 124.5C46.13 131.9 43.94 141.8 36.49 146.6C29.03 151.3 19.14 149.1 14.4 141.7C5.28 127.4 0 110.4 0 92.19C0 41.28 41.28 .0003 92.19 .0003L92.19 0zM357.1 24.59C373.6 9.345 395.6 0 419.8 0C470.7 0 512 41.28 512 92.19C512 110.4 506.7 127.4 497.6 141.7C492.9 149.1 482.1 151.3 475.5 146.6C468.1 141.8 465.9 131.9 470.6 124.5C476.6 115.2 480 104.1 480 92.19C480 58.95 453 32 419.8 32C403.1 32 389.6 38.08 378.9 48.05C372.4 54.06 362.3 53.68 356.3 47.2C350.3 40.73 350.6 30.6 357.1 24.59L357.1 24.59zM320 192C326.2 192 331.8 195.5 334.4 201.1C337.1 206.6 336.3 213.2 332.5 217.1L225.3 352H320C328.8 352 336 359.2 336 368C336 376.8 328.8 384 320 384H191.1C185.8 384 180.2 380.5 177.6 374.9C174.9 369.4 175.7 362.8 179.5 358L286.7 224H191.1C183.2 224 175.1 216.8 175.1 208C175.1 199.2 183.2 192 191.1 192H320zM36.69 507.3C30.44 501.1 30.44 490.9 36.69 484.7L86.7 434.7C52.62 395.4 32 344.1 32 287.1C32 164.3 132.3 63.1 256 63.1C379.7 63.1 480 164.3 480 287.1C480 344.1 459.4 395.4 425.3 434.7L475.3 484.7C481.6 490.9 481.6 501.1 475.3 507.3C469.1 513.6 458.9 513.6 452.7 507.3L402.7 457.3C363.4 491.4 312.1 512 256 512C199.9 512 148.6 491.4 109.3 457.3L59.31 507.3C53.07 513.6 42.93 513.6 36.69 507.3V507.3zM255.1 480C362 480 448 394 448 288C448 181.1 362 96 255.1 96C149.1 96 63.1 181.1 63.1 288C63.1 394 149.1 480 255.1 480z"],
    "album": [448, 512, [128189], "f89f", "M200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256zM64 256C64 167.6 135.6 96 224 96C312.4 96 384 167.6 384 256C384 344.4 312.4 416 224 416C135.6 416 64 344.4 64 256zM224 384C294.7 384 352 326.7 352 256C352 185.3 294.7 128 224 128C153.3 128 96 185.3 96 256C96 326.7 153.3 384 224 384zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V96C416 78.33 401.7 64 384 64z"],
    "album-circle-plus": [576, 512, [], "e48c", "M384 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H275.2C281 459.4 288.1 470.2 296.2 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V192.7C442.7 192.2 437.4 192 432 192C426.6 192 421.3 192.2 416 192.7V96C416 78.33 401.7 64 384 64V64zM224 96C293.3 96 352.3 140 374.5 201.6C364.3 205.1 354.5 209.6 345.2 214.8C328.1 164.3 280.3 128 224 128C153.3 128 96 185.3 96 256C96 326.7 153.3 384 224 384C235.2 384 246 382.6 256.4 379.9C257.1 390.7 258.8 401.3 261.4 411.6C249.4 414.5 236.9 416 223.1 416C135.6 416 63.1 344.4 63.1 256C63.1 167.6 135.6 96 223.1 96L224 96zM200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256zM448 351.1H496C504.8 351.1 512 359.2 512 367.1C512 376.8 504.8 383.1 496 383.1H448V431.1C448 440.8 440.8 447.1 432 447.1C423.2 447.1 416 440.8 416 431.1V383.1H368C359.2 383.1 352 376.8 352 367.1C352 359.2 359.2 351.1 368 351.1H416V303.1C416 295.2 423.2 287.1 432 287.1C440.8 287.1 448 295.2 448 303.1V351.1zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256z"],
    "album-circle-user": [576, 512, [], "e48d", "M384 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H275.2C281 459.4 288.1 470.2 296.2 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V192.7C442.7 192.2 437.4 192 432 192C426.6 192 421.3 192.2 416 192.7V96C416 78.33 401.7 64 384 64V64zM224 96C293.3 96 352.3 140 374.5 201.6C364.3 205.1 354.5 209.6 345.2 214.8C328.1 164.3 280.3 128 224 128C153.3 128 96 185.3 96 256C96 326.7 153.3 384 224 384C235.2 384 246 382.6 256.4 379.9C257.1 390.7 258.8 401.3 261.4 411.6C249.4 414.5 236.9 416 223.1 416C135.6 416 63.1 344.4 63.1 256C63.1 167.6 135.6 96 223.1 96L224 96zM200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256zM376 344C376 313.1 401.1 288 432 288C462.9 288 488 313.1 488 344C488 374.9 462.9 400 432 400C401.1 400 376 374.9 376 344zM432 368C445.3 368 456 357.3 456 344C456 330.7 445.3 320 432 320C418.7 320 408 330.7 408 344C408 357.3 418.7 368 432 368zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM460.2 448H403.8C391.4 448 379.9 453.5 372 462.6C389.3 473.6 409.9 480 432 480C454.1 480 474.7 473.6 491.1 462.6C484.1 453.5 472.6 448 460.2 448H460.2zM544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 396.2 330.5 422.1 347.7 441.8C361.6 425.6 381.9 416 403.8 416H460.2C482.1 416 502.4 425.6 516.3 441.8C533.5 422.1 544 396.2 544 368H544z"],
    "album-collection": [512, 512, [], "f8a0", "M32 16C32 7.164 39.16 0 48 0H464C472.8 0 480 7.164 480 16C480 24.84 472.8 32 464 32H48C39.16 32 32 24.84 32 16zM16 80C16 71.16 23.16 64 32 64H480C488.8 64 496 71.16 496 80C496 88.84 488.8 96 480 96H32C23.16 96 16 88.84 16 80zM232 324C232 312.1 242.7 304 256 304C269.3 304 280 312.1 280 324C280 335 269.3 344 256 344C242.7 344 232 335 232 324zM96 320C96 249.3 167.6 192 256 192C344.4 192 416 249.3 416 320C416 390.7 344.4 448 256 448C167.6 448 96 390.7 96 320zM256 416C333.7 416 384 366.7 384 320C384 273.3 333.7 224 256 224C178.3 224 128 273.3 128 320C128 366.7 178.3 416 256 416zM452.2 128C485.1 128 510.1 156.3 507.1 189.1L483.2 461.1C480.6 489.9 456.4 512 427.5 512H84.53C55.57 512 31.38 489.9 28.76 461.1L4.031 189.1C1.05 156.3 26.87 128 59.8 128H452.2zM60.63 458.2C61.75 470.5 72.12 480 84.53 480H427.5C439.9 480 450.2 470.5 451.4 458.2L476.1 186.2C477.4 172.1 466.3 160 452.2 160H59.8C45.69 160 34.62 172.1 35.9 186.2L60.63 458.2z"],
    "album-collection-circle-plus": [640, 512, [], "e48e", "M32 16C32 7.164 39.16 0 48 0H464C472.8 0 480 7.164 480 16C480 24.84 472.8 32 464 32H48C39.16 32 32 24.84 32 16zM16 80C16 71.16 23.16 64 32 64H480C488.8 64 496 71.16 496 80C496 88.84 488.8 96 480 96H32C23.16 96 16 88.84 16 80zM452.2 128C485.1 128 510.1 156.3 507.1 189.1L507.7 192.4C503.8 192.1 499.9 192 496 192C489.1 192 482.2 192.4 475.5 193.2L476.1 186.2C477.4 172.1 466.3 160 452.2 160H59.8C45.69 160 34.62 172.1 35.9 186.2L60.63 458.2C61.75 470.5 72.12 480 84.53 480H360.2C370.3 492.1 381.9 502.9 394.8 512H84.53C55.57 512 31.38 489.9 28.76 461.1L4.031 189.1C1.05 156.3 26.87 128 59.8 128L452.2 128zM256 192C304.1 192 348.8 209.6 378.1 237.3C370.2 244.5 362.9 252.4 356.3 260.9C334 239.3 299.3 223.1 256 223.1C178.3 223.1 128 273.3 128 319.1C128 366.7 178.3 416 256 416C281.7 416 304.4 410.6 323.2 401.7C325.3 412.4 328.3 422.7 332.2 432.6C309.6 442.4 283.6 448 256 448C167.6 448 96 390.7 96 319.1C96 249.3 167.6 191.1 256 191.1V192zM232 324C232 312.1 242.7 304 256 304C269.3 304 280 312.1 280 324C280 335 269.3 344 256 344C242.7 344 232 335 232 324zM512 351.1H560C568.8 351.1 576 359.2 576 367.1C576 376.8 568.8 383.1 560 383.1H512V431.1C512 440.8 504.8 447.1 496 447.1C487.2 447.1 480 440.8 480 431.1V383.1H432C423.2 383.1 416 376.8 416 367.1C416 359.2 423.2 351.1 432 351.1H480V303.1C480 295.2 487.2 287.1 496 287.1C504.8 287.1 512 295.2 512 303.1V351.1zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "album-collection-circle-user": [640, 512, [], "e48f", "M32 16C32 7.164 39.16 0 48 0H464C472.8 0 480 7.164 480 16C480 24.84 472.8 32 464 32H48C39.16 32 32 24.84 32 16zM16 80C16 71.16 23.16 64 32 64H480C488.8 64 496 71.16 496 80C496 88.84 488.8 96 480 96H32C23.16 96 16 88.84 16 80zM452.2 128C485.1 128 510.1 156.3 507.1 189.1L507.7 192.4C503.8 192.1 499.9 192 496 192C489.1 192 482.2 192.4 475.5 193.2L476.1 186.2C477.4 172.1 466.3 160 452.2 160H59.8C45.69 160 34.62 172.1 35.9 186.2L60.63 458.2C61.75 470.5 72.12 480 84.53 480H360.2C370.3 492.1 381.9 502.9 394.8 512H84.53C55.57 512 31.38 489.9 28.76 461.1L4.031 189.1C1.05 156.3 26.87 128 59.8 128L452.2 128zM256 192C304.1 192 348.8 209.6 378.1 237.3C370.2 244.5 362.9 252.4 356.3 260.9C334 239.3 299.3 223.1 256 223.1C178.3 223.1 128 273.3 128 319.1C128 366.7 178.3 416 256 416C281.7 416 304.4 410.6 323.2 401.7C325.3 412.4 328.3 422.7 332.2 432.6C309.6 442.4 283.6 448 256 448C167.6 448 96 390.7 96 319.1C96 249.3 167.6 191.1 256 191.1V192zM232 324C232 312.1 242.7 304 256 304C269.3 304 280 312.1 280 324C280 335 269.3 344 256 344C242.7 344 232 335 232 324zM440 344C440 313.1 465.1 288 496 288C526.9 288 552 313.1 552 344C552 374.9 526.9 400 496 400C465.1 400 440 374.9 440 344zM496 368C509.3 368 520 357.3 520 344C520 330.7 509.3 320 496 320C482.7 320 472 330.7 472 344C472 357.3 482.7 368 496 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM524.2 448H467.8C455.4 448 443.9 453.5 436 462.6C453.3 473.6 473.9 480 496 480C518.1 480 538.7 473.6 555.1 462.6C548.2 453.5 536.6 448 524.2 448H524.2zM608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 396.2 394.5 422.1 411.7 441.8C425.6 425.6 445.9 416 467.8 416H524.2C546.1 416 566.4 425.6 580.3 441.8C597.5 422.1 608 396.2 608 368H608z"],
    "alicorn": [640, 512, [], "f6b0", "M632 64h-97c5.721-10.11 8.626-22.03 8.212-34.2C542.7 13.03 528 0 511.3 0l-111.3 .0003c-69.13 0-125.4 55.25-127.6 123.9C236.8 114.8 209.3 89.25 190.9 47.25c-4-9.125-13-15.12-23-15.25c-10.5 .25-18.88 5.375-23.13 14.38C133.6 70 128 95.13 128 121.1c0 75.38 56.5 143.6 132.9 161.9c4.377 1 8.877-2 9.752-6.5l2.875-15.62c.875-4.25-1.875-8.125-6-9.25c-61.75-15.12-107.5-70-107.5-130.5c0-16.38 2.75-32.25 8-47.38c29.38 56.5 76.13 86.25 136 86.25v-32c0-53.02 42.98-96 96-96h111.3c0 13.25-8.125 24.62-19.63 29.5l20.38 24.75v93.88c0 6.875-4.375 13-10.88 15.12l-25.5 8.75c-9.25 3.25-16.12-2.75-18.5-6.25l-25.13-37.75l-48-16v100.3c0 26.62-12.63 50.12-32 65.5v154.3c0 8.837-7.163 16-16 16h-32c-8.837 0-16-7.163-16-16V318.8L183.6 295.5l-32.13 89.5l18.97 75.08c2.554 10.11-5.087 19.92-15.51 19.92H130.6c-7.396 0-13.83-5.069-15.56-12.26l-18.18-75.61c-1.29-5.366-1.146-10.98 .4179-16.27l27.58-93.35c-17.38-12.12-28.88-32.25-28.88-55.12c0-15.88 5.625-30.12 14.88-41.63c-5-10.88-9-22.12-11.5-33.75c-8 6.875-15.13 15-20.75 24.12C35.13 176.9 0 212.3 0 256v47.1c0 8.801 7.2 16 16 16S32 312.8 32 304v-48c0-21.5 14.25-39.5 33.75-45.62c-1 5.625-1.75 11.12-1.75 17c0 24.25 8.875 47.37 24.5 65.25l-21.93 74.42c-3.123 10.6-3.408 21.83-.8246 32.58l18.17 75.59c5.186 21.57 24.48 36.78 46.67 36.78h24.35c31.28 0 54.21-29.44 46.53-59.77l-16.59-65.6l19.25-53.75l51.88 11.5v119.6c0 26.4 21.6 48 47.1 48l32.01-.0002c26.4 0 48.03-21.6 48.03-48l-.0277-140.2c20.5-21.5 32-49.75 32-79.5v-50.5l14.5 21.75c19.13 28.62 50 20.62 55.5 18.75l25.5-8.625c19.43-6.57 32.5-24.79 32.5-45.3V115.4l92.38-36.75C643 74.25 639.9 64 632 64zM464 96c0-8.875-7.125-16-16-16s-16 7.125-16 16s7.127 16 16 16S464 104.9 464 96z"],
    "alien": [448, 512, [128125], "f8f5", "M224 .0001c-123.8 0-224 87.99-224 232.5c0 111.7 134.2 224.5 194.9 269.9c17.25 12.87 41 12.87 58.25 0C313.8 456.1 448 344.2 448 232.5C448 87.99 347.8 .0001 224 .0001zM233.1 476.6c-5.874 4.5-14.12 4.5-20 0C171.2 444.7 32 332.1 32 232.5C32 114.4 111 31.1 224 31.1s192 82.37 192 200.5C416 332.1 276.8 444.7 233.1 476.6zM368 211.1H320c-44.13 0-80 35.87-80 79.1v11.1c0 8.874 7.125 15.1 16 15.1h48c44.13 0 80-35.87 80-79.1V227.1C384 219.1 376.9 211.1 368 211.1zM304 287.1h-31.88C274.2 263.1 295 243.1 320 243.1h31.88C349.8 268.9 329 287.1 304 287.1zM128 211.1H80c-8.875 0-16 7.125-16 15.1v11.1c0 44.12 35.88 79.1 80 79.1H192c8.875 0 16-7.125 16-15.1V291.1C208 247.9 172.1 211.1 128 211.1zM144 287.1c-25 0-45.75-19.12-47.88-43.1H128c25 0 45.75 19.12 47.88 43.1H144z"],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", "M192 320h32V224H192V320zM352 320h32V224h-32V320zM544 112h-32c-17.62 0-32 14.38-32 32V160l-64 .0002V128h32c17.62 0 32-14.38 32-32V64c0-17.62-14.38-31.1-32-31.1L416 32c-17.62 0-32 14.38-32 32L352 64c-17.62 0-32 14.38-32 32v32H256V96c0-17.62-14.38-32-32-32L192 64C192 46.38 177.6 32 160 32L128 32C110.4 32 96 46.38 96 64v32c0 17.62 14.38 32 32 32h32v32L96 160V144c0-17.62-14.38-32-32-32H32c-17.62 0-32 14.38-32 32V288c0 17.62 14.38 32 32 32h32v32c0 17.62 14.38 32 32 32l32 .0002V448c0 17.62 14.38 32 32 32l80 .0002c17.62 0 32-14.38 32-32v-32c0-17.62-14.38-32-32-32h96c-17.62 0-32 14.38-32 32v32c0 17.62 14.38 32 32 32L416 480c17.62 0 32-14.38 32-32v-63.1L480 384c17.62 0 32-14.38 32-32v-32h32c17.62 0 32-14.38 32-32V144C576 126.4 561.6 112 544 112zM416 64h32v32l-32-.0002V64zM128 96V64h32v32L128 96zM240 448H160v-64l32 .0002v32h48V448zM416 448h-80v-31.1H384v-32L416 384V448zM544 288h-64v64H96V288H32V144l32 .0002V256h32V192h96V96h32v64h128V96h32v96h96v64h32V144L544 144V288z"],
    "align-center": [448, 512, [], "f037", "M336 48C344.8 48 352 55.16 352 64C352 72.84 344.8 80 336 80H112C103.2 80 96 72.84 96 64C96 55.16 103.2 48 112 48H336zM432 176C440.8 176 448 183.2 448 192C448 200.8 440.8 208 432 208H16C7.164 208 0 200.8 0 192C0 183.2 7.164 176 16 176H432zM96 320C96 311.2 103.2 304 112 304H336C344.8 304 352 311.2 352 320C352 328.8 344.8 336 336 336H112C103.2 336 96 328.8 96 320zM432 432C440.8 432 448 439.2 448 448C448 456.8 440.8 464 432 464H16C7.164 464 0 456.8 0 448C0 439.2 7.164 432 16 432H432z"],
    "align-justify": [448, 512, [], "f039", "M432 48C440.8 48 448 55.16 448 64C448 72.84 440.8 80 432 80H16C7.164 80 0 72.84 0 64C0 55.16 7.164 48 16 48H432zM0 192C0 183.2 7.164 176 16 176H432C440.8 176 448 183.2 448 192C448 200.8 440.8 208 432 208H16C7.164 208 0 200.8 0 192zM432 304C440.8 304 448 311.2 448 320C448 328.8 440.8 336 432 336H16C7.164 336 0 328.8 0 320C0 311.2 7.164 304 16 304H432zM432 432C440.8 432 448 439.2 448 448C448 456.8 440.8 464 432 464H16C7.164 464 0 456.8 0 448C0 439.2 7.164 432 16 432H432z"],
    "align-left": [448, 512, [], "f036", "M272 48C280.8 48 288 55.16 288 64C288 72.84 280.8 80 272 80H16C7.164 80 0 72.84 0 64C0 55.16 7.164 48 16 48H272zM432 176C440.8 176 448 183.2 448 192C448 200.8 440.8 208 432 208H16C7.164 208 0 200.8 0 192C0 183.2 7.164 176 16 176H432zM0 320C0 311.2 7.164 304 16 304H272C280.8 304 288 311.2 288 320C288 328.8 280.8 336 272 336H16C7.164 336 0 328.8 0 320zM432 432C440.8 432 448 439.2 448 448C448 456.8 440.8 464 432 464H16C7.164 464 0 456.8 0 448C0 439.2 7.164 432 16 432H432z"],
    "align-right": [448, 512, [], "f038", "M432 48C440.8 48 448 55.16 448 64C448 72.84 440.8 80 432 80H176C167.2 80 160 72.84 160 64C160 55.16 167.2 48 176 48H432zM432 176C440.8 176 448 183.2 448 192C448 200.8 440.8 208 432 208H16C7.164 208 0 200.8 0 192C0 183.2 7.164 176 16 176H432zM432 336H176C167.2 336 160 328.8 160 320C160 311.2 167.2 304 176 304H432C440.8 304 448 311.2 448 320C448 328.8 440.8 336 432 336zM432 432C440.8 432 448 439.2 448 448C448 456.8 440.8 464 432 464H16C7.164 464 0 456.8 0 448C0 439.2 7.164 432 16 432H432z"],
    "align-slash": [640, 512, [], "f846", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM528 336H524.6L484.1 303.1H528C536.8 303.1 544 311.2 544 319.1C544 328.8 536.8 336 528 336zM528 207.1H362.5L321.1 175.1H528C536.8 175.1 544 183.2 544 191.1C544 200.8 536.8 207.1 528 207.1zM111.1 207.1C103.2 207.1 95.1 200.8 95.1 191.1C95.1 183.2 103.2 175.1 111.1 175.1H115.4L155.9 207.1H111.1zM544 63.1C544 72.84 536.8 79.1 528 79.1H200.4L159.8 47.1H528C536.8 47.1 544 55.16 544 63.1zM111.1 336C103.2 336 95.1 328.8 95.1 319.1C95.1 311.2 103.2 303.1 111.1 303.1H277.5L318 336H111.1zM439.6 432L480.2 464H111.1C103.2 464 95.1 456.8 95.1 448C95.1 439.2 103.2 432 111.1 432H439.6z"],
    "alt": [640, 512, [], "e08a", "M416 432c0 8.838 7.164 16 16 16h192c8.836 0 16-7.162 16-16c0-8.836-7.164-16-16-16h-192C423.2 416 416 423.2 416 432zM640 80C640 71.16 632.8 64 624 64h-129.7c-24.09 0-46.69 10.69-61.94 29.34l-249.6 305.1C173.7 409.6 160.1 416 145.7 416H16C7.156 416 0 423.2 0 432S7.156 448 16 448h129.7c24.09 0 46.69-10.69 61.94-29.34l249.6-305.1C466.3 102.4 479.9 96 494.3 96H624C632.8 96 640 88.84 640 80z"],
    "amp-guitar": [512, 512, [], "f8a1", "M416 352c8.875 0 16-7.125 16-16S424.9 320 416 320s-16 7.125-16 16S407.1 352 416 352zM352 352c8.875 0 16-7.125 16-16S360.9 320 352 320s-16 7.125-16 16S343.1 352 352 352zM384 400c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S375.1 400 384 400zM288 352c8.875 0 16-7.125 16-16S296.9 320 288 320s-16 7.125-16 16S279.1 352 288 352zM320 400c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S311.1 400 320 400zM160 416c-8.875 0-16 7.125-16 16S151.1 448 160 448s16-7.125 16-16S168.9 416 160 416zM416 416c-8.875 0-16 7.125-16 16S407.1 448 416 448s16-7.125 16-16S424.9 416 416 416zM224 416c-8.875 0-16 7.125-16 16S215.1 448 224 448s16-7.125 16-16S232.9 416 224 416zM256 400c8.875 0 16-7.125 16-16s-7.125-16-16-16S240 375.1 240 384S247.1 400 256 400zM288 416c-8.875 0-16 7.125-16 16S279.1 448 288 448s16-7.125 16-16S296.9 416 288 416zM352 416c-8.875 0-16 7.125-16 16S343.1 448 352 448s16-7.125 16-16S360.9 416 352 416zM224 352c8.875 0 16-7.125 16-16S232.9 320 224 320s-16 7.125-16 16S215.1 352 224 352zM464 64h-77.25C357.9 36.13 310.3 0 256 0S154.1 36.13 125.3 64H48C21.5 64 0 85.5 0 112v352C0 490.5 21.5 512 48 512h416c26.5 0 48-21.5 48-48v-352C512 85.5 490.5 64 464 64zM256 32c30.12 0 58.63 14.88 81.63 32H174.4C197.4 46.88 225.9 32 256 32zM480 464c0 8.875-7.125 16-16 16h-416C39.13 480 32 472.9 32 464V288h448V464zM480 256H32V112C32 103.1 39.13 96 48 96h416C472.9 96 480 103.1 480 112V256zM96 352c8.875 0 16-7.125 16-16S104.9 320 96 320s-16 7.125-16 16S87.13 352 96 352zM96 448c8.875 0 16-7.125 16-16S104.9 416 96 416s-16 7.125-16 16S87.13 448 96 448zM160 352c8.875 0 16-7.125 16-16S168.9 320 160 320s-16 7.125-16 16S151.1 352 160 352zM192 400c8.875 0 16-7.125 16-16S200.9 368 192 368S176 375.1 176 384S183.1 400 192 400zM128 400c8.875 0 16-7.125 16-16S136.9 368 128 368S112 375.1 112 384S119.1 400 128 400zM96 152c-13.25 0-24 10.75-24 24S82.75 200 96 200c13.26 0 24-10.75 24-24S109.3 152 96 152zM192 152c-13.25 0-24 10.75-24 24S178.7 200 192 200c13.26 0 24-10.75 24-24S205.3 152 192 152zM320 152c-13.25 0-24 10.75-24 24S306.7 200 320 200c13.26 0 24-10.75 24-24S333.3 152 320 152zM416 152c-13.25 0-24 10.75-24 24S402.7 200 416 200c13.26 0 24-10.75 24-24S429.3 152 416 152z"],
    "ampersand": [384, 512, [], "26", "M379.5 452.9l-71.4-74.19l72.99-104.5c5.062-7.234 3.281-17.22-3.969-22.28c-7.156-5.016-17.19-3.312-22.28 3.969l-69.36 99.32L170.4 235.6l69.87-55.36c20.16-15.88 31.72-39.55 31.72-64.94C271.1 69.38 233.9 32 187.1 32H132.9C86.09 32 47.1 69.38 47.1 115.3c0 24.81 9.437 48.55 26.69 67l48.22 50.09L38.72 299.1C14.12 318.5 0 347.4 0 378.3C0 434.4 46.48 480 103.7 480h66.61c41.1 0 81.25-20.27 104.1-54.23l14.17-20.3l67.01 69.63C359.6 478.4 363.8 480 367.1 480c3.1 0 7.1-1.484 11.09-4.469C385.5 469.4 385.6 459.3 379.5 452.9zM97.9 160.3c-11.56-12.33-17.91-28.31-17.91-44.97C79.1 87.02 103.7 64 132.9 64h54.12c29.19 0 52.94 23.02 52.94 51.31c0 15.52-7.125 30.03-19.56 39.83L148.1 212.5L97.9 160.3zM249 407.5C231.3 432.8 201.9 448 170.3 448H103.7c-39.56 0-71.75-31.25-71.75-69.67c0-21.08 9.656-40.8 26.56-54.11l86.62-68.64l121.6 126.4L249 407.5z"],
    "anchor": [576, 512, [9875], "f13d", "M368 80C368 118.7 340.5 151 303.9 158.4C303.1 158.9 304 159.5 304 160V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H304V480H336C415.5 480 480 415.5 480 336V310.6L443.3 347.3C437.1 353.6 426.9 353.6 420.7 347.3C414.4 341.1 414.4 330.9 420.7 324.7L484.7 260.7C490.9 254.4 501.1 254.4 507.3 260.7L571.3 324.7C577.6 330.9 577.6 341.1 571.3 347.3C565.1 353.6 554.9 353.6 548.7 347.3L512 310.6V336C512 433.2 433.2 512 336 512H240C142.8 512 63.1 433.2 63.1 336V310.6L27.31 347.3C21.07 353.6 10.94 353.6 4.686 347.3C-1.562 341.1-1.562 330.9 4.686 324.7L68.69 260.7C74.93 254.4 85.06 254.4 91.31 260.7L155.3 324.7C161.6 330.9 161.6 341.1 155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3L95.1 310.6V336C95.1 415.5 160.5 480 239.1 480H272V224H207.1C199.2 224 191.1 216.8 191.1 208C191.1 199.2 199.2 192 207.1 192H272V160C272 159.5 272 158.9 272.1 158.4C235.5 151 207.1 118.7 207.1 80C207.1 35.82 243.8 0 287.1 0C332.2 0 368 35.82 368 80H368zM288 128C314.5 128 336 106.5 336 80C336 53.49 314.5 32 288 32C261.5 32 240 53.49 240 80C240 106.5 261.5 128 288 128z"],
    "anchor-circle-check": [640, 512, [], "e4aa", "M368 80C368 118.7 340.5 151 303.9 158.4C303.1 158.9 304 159.5 304 160V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H304V480H336C343.7 480 351.4 479.4 358.8 478.2C366.7 488.1 375.6 497 385.5 504.1C369.8 509.5 353.2 512 336 512H239.1C142.8 512 63.1 433.2 63.1 336V310.6L27.31 347.3C21.07 353.6 10.93 353.6 4.686 347.3C-1.562 341.1-1.562 330.9 4.686 324.7L68.69 260.7C74.93 254.4 85.06 254.4 91.31 260.7L155.3 324.7C161.6 330.9 161.6 341.1 155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3L95.1 310.6V336C95.1 415.5 160.5 480 239.1 480H272V224H207.1C199.2 224 191.1 216.8 191.1 208C191.1 199.2 199.2 192 207.1 192H272V160C272 159.5 272 158.9 272.1 158.4C235.5 151 207.1 118.7 207.1 80C207.1 35.82 243.8 0 287.1 0C332.2 0 368 35.82 368 80H368zM288 128C314.5 128 336 106.5 336 80C336 53.49 314.5 32 288 32C261.5 32 239.1 53.49 239.1 80C239.1 106.5 261.5 128 288 128zM540.7 324.7C546.9 318.4 557.1 318.4 563.3 324.7C569.6 330.9 569.6 341.1 563.3 347.3L491.3 419.3C485.1 425.6 474.9 425.6 468.7 419.3L428.7 379.3C422.4 373.1 422.4 362.9 428.7 356.7C434.9 350.4 445.1 350.4 451.3 356.7L480 385.4L540.7 324.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M368 80C368 118.7 340.5 151 303.9 158.4C303.1 158.9 304 159.5 304 160V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H304V480H336C343.7 480 351.4 479.4 358.8 478.2C366.7 488.1 375.6 497 385.5 504.1C369.8 509.5 353.2 512 336 512H239.1C142.8 512 63.1 433.2 63.1 336V310.6L27.31 347.3C21.07 353.6 10.93 353.6 4.686 347.3C-1.562 341.1-1.562 330.9 4.686 324.7L68.69 260.7C74.93 254.4 85.06 254.4 91.31 260.7L155.3 324.7C161.6 330.9 161.6 341.1 155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3L95.1 310.6V336C95.1 415.5 160.5 480 239.1 480H272V224H207.1C199.2 224 191.1 216.8 191.1 208C191.1 199.2 199.2 192 207.1 192H272V160C272 159.5 272 158.9 272.1 158.4C235.5 151 207.1 118.7 207.1 80C207.1 35.82 243.8 0 287.1 0C332.2 0 368 35.82 368 80H368zM288 128C314.5 128 336 106.5 336 80C336 53.49 314.5 32 288 32C261.5 32 239.1 53.49 239.1 80C239.1 106.5 261.5 128 288 128zM472 424C472 410.7 482.7 400 496 400C509.3 400 520 410.7 520 424C520 437.3 509.3 448 496 448C482.7 448 472 437.3 472 424zM495.1 288C504.8 288 511.1 295.2 511.1 304V368C511.1 376.8 504.8 384 495.1 384C487.2 384 479.1 376.8 479.1 368V304C479.1 295.2 487.2 288 495.1 288zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "anchor-circle-xmark": [640, 512, [], "e4ac", "M368 80C368 118.7 340.5 151 303.9 158.4C303.1 158.9 304 159.5 304 160V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H304V480H336C343.7 480 351.4 479.4 358.8 478.2C366.7 488.1 375.6 497 385.5 504.1C369.8 509.5 353.2 512 336 512H239.1C142.8 512 63.1 433.2 63.1 336V310.6L27.31 347.3C21.07 353.6 10.93 353.6 4.686 347.3C-1.562 341.1-1.562 330.9 4.686 324.7L68.69 260.7C74.93 254.4 85.06 254.4 91.31 260.7L155.3 324.7C161.6 330.9 161.6 341.1 155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3L95.1 310.6V336C95.1 415.5 160.5 480 239.1 480H272V224H207.1C199.2 224 191.1 216.8 191.1 208C191.1 199.2 199.2 192 207.1 192H272V160C272 159.5 272 158.9 272.1 158.4C235.5 151 207.1 118.7 207.1 80C207.1 35.82 243.8 0 287.1 0C332.2 0 368 35.82 368 80H368zM288 128C314.5 128 336 106.5 336 80C336 53.49 314.5 32 288 32C261.5 32 239.1 53.49 239.1 80C239.1 106.5 261.5 128 288 128zM518.6 368L555.3 404.7C561.6 410.9 561.6 421.1 555.3 427.3C549.1 433.6 538.9 433.6 532.7 427.3L496 390.6L459.3 427.3C453.1 433.6 442.9 433.6 436.7 427.3C430.4 421.1 430.4 410.9 436.7 404.7L473.4 368L436.7 331.3C430.4 325.1 430.4 314.9 436.7 308.7C442.9 302.4 453.1 302.4 459.3 308.7L496 345.4L532.7 308.7C538.9 302.4 549.1 302.4 555.3 308.7C561.6 314.9 561.6 325.1 555.3 331.3L518.6 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "anchor-lock": [640, 512, [], "e4ad", "M368 80C368 118.7 340.5 151 303.9 158.4C303.1 158.9 304 159.5 304 160V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H304V480H336C352.8 480 368.1 477.1 384 471.8V480C384 488.5 385.7 496.6 388.6 503.1C372 509.2 354.3 512 336 512H239.1C142.8 512 63.1 433.2 63.1 336V310.6L27.31 347.3C21.07 353.6 10.93 353.6 4.686 347.3C-1.562 341.1-1.562 330.9 4.686 324.7L68.69 260.7C74.93 254.4 85.06 254.4 91.31 260.7L155.3 324.7C161.6 330.9 161.6 341.1 155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3L95.1 310.6V336C95.1 415.5 160.5 480 239.1 480H272V224H207.1C199.2 224 191.1 216.8 191.1 208C191.1 199.2 199.2 192 207.1 192H272V160C272 159.5 272 158.9 272.1 158.4C235.5 151 207.1 118.7 207.1 80C207.1 35.82 243.8 0 287.1 0C332.2 0 368 35.82 368 80H368zM288 128C314.5 128 336 106.5 336 80C336 53.49 314.5 32 288 32C261.5 32 239.1 53.49 239.1 80C239.1 106.5 261.5 128 288 128zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 224C501.5 224 480 245.5 480 272V320H576V272C576 245.5 554.5 224 528 224zM448 352V480H608V352H448z"],
    "angel": [640, 512, [], "f779", "M240 144c0 44.25 35.75 80 79.1 80s79.1-35.75 79.1-80S364.3 64 320 64S240 99.75 240 144zM367.1 144c0 26.5-21.5 48-48 48s-48-21.5-48-48s21.5-48 48-48S367.1 117.5 367.1 144zM604.5 464.6l-38.25-78.62c-7.502-15.75-7.502-34.38 0-50.13c16.75-34.13 25.63-36.5 25.63-71.75c0-46.88-43.13-88-92.38-88c-23 0-44.5 9.125-60.76 25.62l-67.51 68.13C355.1 261 338.4 256.1 320 256.1S284.1 261 268.7 269.8l-67.51-68C185.1 185.3 163.5 176 140.5 176c-49.26 0-92.38 41.13-92.38 88c0 35.38 9.002 37.88 25.63 71.75c7.502 15.75 7.502 34.5 0 50.13l-38.13 78.75C23.83 488.5 42.96 512 64.58 512H575.4C597.6 512 615.9 487.9 604.5 464.6zM64.58 480l37.88-80.13c11.88-24.5 11.88-53.63 0-78.13C84.59 285 80.21 289.9 80.21 264c0-29.25 28.75-56 60.38-56c14.13 0 27.63 5.75 37.75 16.25l65.13 65.63C237.2 296.8 231.8 304.7 227.4 313.2L144.1 480H64.58zM179.8 480l76.13-152.4C268.2 303.3 292.7 288 319.1 288c27.25 0 51.75 15.25 64.01 39.63L460.3 480H179.8zM495.9 479.9L412.6 313.2c-4.377-8.625-9.872-16.5-16.12-23.5l65.13-65.63c10.13-10.38 23.63-16.25 37.75-16.25c31.63 0 60.38 26.75 60.38 56c0 26-4.5 21-22.38 57.88c-11.88 24.5-11.88 53.5 0 78l37.88 80.13H495.9zM217.6 123.3c6.234-6.266 6.331-16.41 .0652-22.64C211.3 94.38 208 88.05 208 81.81C208 58.3 255.9 32 320 32s112 26.3 112 49.81c0 6.234-3.203 12.56-9.5 18.83c-6.266 6.234-6.297 16.38-.063 22.64C425.6 126.4 429.7 128 433.8 128c4.078 0 8.156-1.547 11.28-4.656C457.5 111 464 96.66 464 81.81C464 35.94 400.8 0 320 0S176 35.94 176 81.81c0 14.84 6.547 29.2 18.94 41.53C201.2 129.6 211.4 129.6 217.6 123.3z"],
    "angle": [448, 512, [], "e08c", "M41.89 448H432C440.8 448 448 455.2 448 464C448 472.8 440.8 480 432 480H16C10.46 480 5.305 477.1 2.39 472.4C-.5254 467.7-.7907 461.8 1.689 456.8L209.7 40.84C213.6 32.94 223.3 29.74 231.2 33.69C239.1 37.64 242.3 47.25 238.3 55.15L41.89 448zM294.1 238.9C300.7 246.1 298.7 256.6 290.9 261.5C283.7 266 274.3 264.2 269 257.6C254.8 239.9 238.6 223.8 220.8 209.7C214.6 204.8 212.5 196.3 216 189.2C220.4 180.4 231.6 177.5 239.4 183.6C259.1 199.8 278.7 218.3 294.1 238.9V238.9zM309.5 323.7C306.1 316.1 308.6 307.1 315.6 302.7C323.5 297.6 334.1 300.5 338 309.1C349.6 334.5 358.1 361.7 363 390.1C364.7 399.6 357.2 408 347.5 408C339.4 408 332.7 401.1 331.2 394C326.8 369.4 319.5 345.9 309.5 323.7L309.5 323.7z"],
    "angle-90": [448, 512, [], "e08d", "M267.3 268.4c3.156 4.109 7.922 6.281 12.73 6.281c3.391 0 6.797-1.078 9.703-3.281c7.016-5.375 8.359-15.41 3-22.44c-17.69-23.14-38.39-43.86-61.56-61.61c-7-5.359-17.05-4.016-22.44 2.969C203.4 197.4 204.7 207.4 211.7 212.8C232.7 228.8 251.4 247.5 267.3 268.4zM324.5 402.4C325.7 410.3 332.5 416 340.3 416c.8125 0 1.625-.0625 2.453-.1875c8.734-1.344 14.72-9.531 13.38-18.25c-3.844-24.94-10.61-49.44-20.11-72.88c-3.328-8.188-12.7-12.25-20.84-8.812c-8.188 3.312-12.12 12.62-8.812 20.81C314.1 357.8 321 379.1 324.5 402.4zM432 448H32V48C32 39.16 24.84 32 16 32S0 39.16 0 48v416C0 472.8 7.156 480 16 480h416c8.844 0 16-7.156 16-16S440.8 448 432 448zM77.56 155.5c22.48 3.469 44.59 9.562 65.72 18.14c1.969 .7969 4 1.172 6.016 1.172c6.312 0 12.3-3.766 14.83-9.984C167.4 156.6 163.5 147.3 155.3 143.1c-23.42-9.5-47.94-16.27-72.88-20.11C73.7 122.6 65.55 128.5 64.19 137.2C62.84 145.1 68.83 154.1 77.56 155.5z"],
    "angle-down": [384, 512, [8964], "f107", "M362.7 203.9l-159.1 144c-6.125 5.469-15.31 5.469-21.44 0L21.29 203.9C14.73 197.1 14.2 187.9 20.1 181.3C26.38 174.4 36.5 174.5 42.73 180.1L192 314.5l149.3-134.4c6.594-5.877 16.69-5.361 22.62 1.188C369.8 187.9 369.3 197.1 362.7 203.9z"],
    "angle-left": [256, 512, [8249], "f104", "M203.9 405.3c5.877 6.594 5.361 16.69-1.188 22.62c-6.562 5.906-16.69 5.375-22.59-1.188L36.1 266.7c-5.469-6.125-5.469-15.31 0-21.44l144-159.1c5.906-6.562 16.03-7.094 22.59-1.188c6.918 6.271 6.783 16.39 1.188 22.62L69.53 256L203.9 405.3z"],
    "angle-right": [256, 512, [8250], "f105", "M219.9 266.7L75.89 426.7c-5.906 6.562-16.03 7.094-22.59 1.188c-6.918-6.271-6.783-16.39-1.188-22.62L186.5 256L52.11 106.7C46.23 100.1 46.75 90.04 53.29 84.1C59.86 78.2 69.98 78.73 75.89 85.29l144 159.1C225.4 251.4 225.4 260.6 219.9 266.7z"],
    "angle-up": [384, 512, [8963], "f106", "M363.9 330.7c-6.271 6.918-16.39 6.783-22.62 1.188L192 197.5l-149.3 134.4c-6.594 5.877-16.69 5.361-22.62-1.188C14.2 324.1 14.73 314 21.29 308.1l159.1-144c6.125-5.469 15.31-5.469 21.44 0l159.1 144C369.3 314 369.8 324.1 363.9 330.7z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M181.3 251.9c6.125 5.469 15.31 5.469 21.44 0l159.1-144c6.562-5.906 7.094-16.03 1.188-22.59c-5.938-6.549-16.03-7.064-22.62-1.188L192 218.5L42.73 84.11C36.5 78.51 26.38 78.38 20.1 85.29C14.2 91.86 14.73 101.1 21.29 107.9L181.3 251.9zM341.3 276.1L192 410.5L42.73 276.1C36.5 270.5 26.38 270.4 20.1 277.3C14.2 283.9 14.73 293.1 21.29 299.9l159.1 144c6.125 5.469 15.31 5.469 21.44 0l159.1-144c6.562-5.906 7.094-16.03 1.188-22.59C357.1 270.7 347.9 270.2 341.3 276.1z"],
    "angles-left": [448, 512, [171, "angle-double-left"], "f100", "M202.7 84.1C196.1 78.2 186 78.73 180.1 85.29L36.1 245.3c-5.469 6.125-5.469 15.31 0 21.44l144 159.1c5.906 6.562 16.03 7.094 22.59 1.188c6.549-5.938 7.064-16.03 1.188-22.62L69.53 256l134.4-149.3C209.5 100.5 209.6 90.38 202.7 84.1zM261.5 256l134.4-149.3c5.596-6.23 5.73-16.35-1.188-22.62c-6.562-5.906-16.69-5.375-22.59 1.188l-144 159.1c-5.469 6.125-5.469 15.31 0 21.44l144 159.1c5.906 6.562 16.03 7.094 22.59 1.188c6.549-5.938 7.064-16.03 1.188-22.62L261.5 256z"],
    "angles-right": [448, 512, [187, "angle-double-right"], "f101", "M75.89 85.29C69.98 78.73 59.86 78.2 53.29 84.1C46.75 90.04 46.23 100.1 52.11 106.7L186.5 256l-134.4 149.3c-5.596 6.23-5.73 16.35 1.188 22.62c6.562 5.906 16.69 5.375 22.59-1.188l144-159.1c5.469-6.125 5.469-15.31 0-21.44L75.89 85.29zM411.9 245.3L267.9 85.29c-5.906-6.562-16.03-7.094-22.59-1.188c-6.549 5.938-7.064 16.03-1.188 22.62L378.5 256l-134.4 149.3c-5.596 6.23-5.73 16.35 1.188 22.62c6.562 5.906 16.69 5.375 22.59-1.188l144-159.1C417.4 260.6 417.4 251.4 411.9 245.3z"],
    "angles-up": [384, 512, ["angle-double-up"], "f102", "M42.73 235.9L192 101.5l149.3 134.4c6.23 5.596 16.35 5.73 22.62-1.188c5.906-6.562 5.375-16.69-1.188-22.59l-159.1-144c-6.125-5.469-15.31-5.469-21.44 0L21.29 212.1C14.73 218 14.2 228.1 20.1 234.7C26.04 241.3 36.13 241.8 42.73 235.9zM202.7 260.1c-6.125-5.469-15.31-5.469-21.44 0L21.29 404.1c-6.562 5.906-7.094 16.03-1.188 22.59c5.938 6.549 16.03 7.064 22.62 1.188L192 293.5l149.3 134.4c6.23 5.596 16.35 5.73 22.62-1.188c5.906-6.562 5.375-16.69-1.188-22.59L202.7 260.1z"],
    "ankh": [320, 512, [9765], "f644", "M304 288h-88.63C252.3 252 288 191.6 288 137.1C288 53 230.8 0 160 0S32 53 32 137.1C32 191.6 67.75 252 104.6 288H16C7.199 288 0 295.2 0 304S7.199 320 16 320h128v176c0 8.801 7.199 16 16 16s16-7.199 16-16V320h128c8.801 0 16-7.199 16-16S312.8 288 304 288zM160.3 288C139.4 286.1 64 208.9 64 137.1C64 75.25 103.5 32 160 32s96 43.25 96 105.1C256 208.9 180.8 286.1 160.3 288z"],
    "apartment": [576, 512, [], "e468", "M384 264C384 277.3 373.3 288 360 288H216C202.7 288 192 277.3 192 264V216C192 202.7 202.7 192 216 192H360C373.3 192 384 202.7 384 216V264zM352 256V224H304V256H352zM272 256V224H224V256H272zM440 448C426.7 448 416 437.3 416 424V376C416 362.7 426.7 352 440 352H488C501.3 352 512 362.7 512 376V424C512 437.3 501.3 448 488 448H440zM448 384V416H480V384H448zM160 360C160 373.3 149.3 384 136 384H88C74.75 384 64 373.3 64 360V312C64 298.7 74.75 288 88 288H136C149.3 288 160 298.7 160 312V360zM128 352V320H96V352H128zM440 320C426.7 320 416 309.3 416 296V248C416 234.7 426.7 224 440 224H488C501.3 224 512 234.7 512 248V296C512 309.3 501.3 320 488 320H440zM448 256V288H480V256H448zM160 232C160 245.3 149.3 256 136 256H88C74.75 256 64 245.3 64 232V184C64 170.7 74.75 160 88 160H136C149.3 160 160 170.7 160 184V232zM128 224V192H96V224H128zM216 160C202.7 160 192 149.3 192 136V88C192 74.75 202.7 64 216 64H360C373.3 64 384 74.75 384 88V136C384 149.3 373.3 160 360 160H216zM304 96V128H352V96H304zM224 96V128H272V96H224zM64 512C28.65 512 0 483.3 0 448V160C0 124.7 28.65 96 64 96H128V64C128 28.65 156.7 0 192 0H384C419.3 0 448 28.65 448 64V160H512C547.3 160 576 188.7 576 224V448C576 483.3 547.3 512 512 512H64zM64 128C46.33 128 32 142.3 32 160V448C32 465.7 46.33 480 64 480H224V416C224 380.7 252.7 352 288 352C323.3 352 352 380.7 352 416V480H512C529.7 480 544 465.7 544 448V224C544 206.3 529.7 192 512 192H416V64C416 46.33 401.7 32 384 32H192C174.3 32 160 46.33 160 64V128H64zM320 416C320 398.3 305.7 384 288 384C270.3 384 256 398.3 256 416V480H320V416z"],
    "aperture": [512, 512, [], "e2df", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM458.1 160H237.5l70.27-121.7C374.3 54.12 429.3 99.59 458.1 160zM292.9 320H219.1L182.1 256L219.1 192h73.89l36.95 64L292.9 320zM256 32c6.059 0 12.01 .4336 17.95 .9082L163.6 223.1L93.41 102.4C134.3 59.15 191.1 32 256 32zM71.76 128.9L182.1 320h-140.7C35.37 299.7 32 278.2 32 256C32 208.8 46.75 165 71.76 128.9zM53.92 352h220.5l-70.27 121.7C137.7 457.9 82.74 412.4 53.92 352zM256 480c-6.059 0-12.01-.4336-17.95-.9082l110.3-191.1l70.22 121.6C377.7 452.8 320 480 256 480zM440.2 383.1L329.9 192h140.7C476.6 212.3 480 233.8 480 256C480 303.2 465.3 346.1 440.2 383.1z"],
    "apostrophe": [192, 512, [], "27", "M112 32C67.82 32 32 67.82 32 112C32 156.2 67.82 192 112 192c18.1 0 34.6-6.232 48-16.36V208C160 252.1 124.1 288 80 288C71.16 288 64 295.2 64 304S71.16 320 80 320c61.75 0 112-50.25 112-112v-96C192 67.82 156.2 32 112 32zM112 160C85.53 160 64 138.5 64 112S85.53 64 112 64S160 85.53 160 112S138.5 160 112 160z"],
    "apple-core": [384, 512, [], "e08f", "M174.6 127.4c0 0 5.344 .6855 13.75 .6855c18.09 0 51.75-3.326 74-25.57c31.44-31.31 25.22-85.48 24.94-87.78c-.875-7.264-6.656-13.01-13.94-13.93c0 0-5.674-.791-14.45-.791c-18.6 0-51.15 3.547-73.3 25.68c-31.44 31.31-25.22 85.48-24.94 87.78C161.6 120.7 167.3 126.5 174.6 127.4zM208.2 48.31c13.16-13.15 35.66-15.76 47.75-16.15c-.5 14.83-3.1 35.56-16.19 47.71c-13.16 13.15-35.66 15.76-47.75 16.15C192.5 81.2 196 60.46 208.2 48.31zM287.1 304c0-62.43 32.67-117.2 81.69-148.4c-13.6-13.4-30.41-22.82-50.56-26.38c-34.91-5.984-96.57 13.61-127.1 30.83c-30.33-17.09-91.64-36.77-127.3-30.83c-20.08 3.559-36.85 12.98-50.42 26.38C63.34 186.8 95.1 241.6 95.1 304c0 61.17-31.16 114.1-78.52 146.5C43.08 486.3 79.22 512 128.4 512c27.58 0 35.23-17.87 63.63-17.87C220.5 494.1 227.1 512 255.6 512c49.16 0 85.3-25.66 110.9-61.5C319.2 418.1 287.1 365.2 287.1 304zM255.6 480c-16.01 0-27.36-17.87-63.63-17.87C155.7 462.1 144.3 480 128.4 480c-24.79 0-46.26-8.33-65.01-25.33C104.3 415.7 128 361.6 128 304c0-54.23-20.84-105.1-57.37-143.3C114.3 154.1 179.3 192.1 191.1 192.1c12.36 0 79.14-38.33 121.4-31.39C276.8 198.9 256 249.8 256 304c0 57.56 23.66 111.7 64.64 150.7C301.9 471.7 280.4 480 255.6 480z"],
    "apple-whole": [448, 512, [127823, 127822, "apple-alt"], "f5d1", "M206.6 127.4c0 0 5.344 .6855 13.75 .6855c18.09 0 51.75-3.326 74-25.57c31.44-31.31 25.22-85.48 24.94-87.78c-.875-7.264-6.656-13.01-13.94-13.93c0 0-55.16-7.688-87.75 24.88c-31.44 31.31-25.22 85.48-24.94 87.78C193.6 120.7 199.3 126.5 206.6 127.4zM240.2 48.31c13.16-13.15 35.66-15.76 47.75-16.15c-.5 14.83-4 35.56-16.19 47.71c-13.16 13.15-35.66 15.76-47.75 16.15C224.5 81.2 228 60.46 240.2 48.31zM351 129.1c-4.375-.75-9.161-1.036-14.41-1.036c-36.13 0-87.12 17.58-112.6 31.95c-25.5-14.37-76.51-31.95-112.6-31.95c-5.25 0-10.12 .375-14.62 1.125c-81.13 14.37-107.4 124.5-93 205.6C17.99 415.9 64.99 512 160.4 512c12.12 0 24.12-4.625 34.5-10.37c9.002-4.998 19.13-7.498 29.13-7.498c10.12 0 20.12 2.5 29.12 7.498C263.5 507.4 275.5 512 287.6 512c95.38 0 142.4-96.11 156.6-177.2C458.6 253.7 432.4 143.5 351 129.1zM412.7 329.3c-4.426 25.17-31.24 150.8-125.1 150.8c-16.01 0-27.36-17.87-63.63-17.87c-36.33 0-47.68 17.87-63.63 17.87c-93.87 0-120.7-125.6-125.1-150.8c-6.557-36.99-3.15-78.46 9.113-110.9C53.1 195.1 70.25 166.4 102 160.8c29.9-4.979 86.47 16.02 106.3 27.18c4.877 2.75 10.3 4.125 15.71 4.125s10.84-1.375 15.71-4.125c19.05-10.73 76.64-32.22 105.8-27.23c32.2 5.688 49.37 34.44 58.1 57.56C415.9 250.7 419.3 292.2 412.7 329.3z"],
    "archway": [512, 512, [], "f557", "M0 48C0 39.16 7.164 32 16 32H496C504.8 32 512 39.16 512 48C512 56.84 504.8 64 496 64H480V448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H352V352C352 298.1 309 256 256 256C202.1 256 160 298.1 160 352V480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H32V64H16C7.164 64 0 56.84 0 48zM64 128H448V64H64V128zM64 160V448H128V352C128 281.3 185.3 224 256 224C326.7 224 384 281.3 384 352V448H448V160H64z"],
    "arrow-down": [384, 512, [8595], "f063", "M378.8 309.8l-176 165.9C199.7 478.6 195.9 480 192 480s-7.719-1.426-10.77-4.31l-176-165.9C-1.297 303.6-1.781 293.1 4.156 286.3c5.953-6.838 16.09-7.259 22.61-1.134L176 425.9V48.59c0-9.171 7.156-16.59 15.1-16.59S208 39.42 208 48.59v377.3l149.2-140.7c6.516-6.125 16.66-5.704 22.61 1.134C385.8 293.1 385.3 303.6 378.8 309.8z"],
    "arrow-down-1-9": [512, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M336 224l96-.0039c8.844 0 16-7.152 16-15.1S440.8 192 432 192h-32V48C400 39.16 392.8 32 384 32h-32c-8.844 0-16 7.156-16 16S343.2 64 352 64h16v128h-32C327.2 192 320 199.2 320 208S327.2 224 336 224zM384 256c-44.13 0-80 35.88-80 80S339.9 416 384 416c16.73 0 32.25-5.199 45.11-14.01C421.3 428.5 396.1 448 368 448c-8.844 0-16 7.156-16 16s7.156 16 16 16c52.94 0 96-43.06 96-96v-48C464 291.9 428.1 256 384 256zM384 384c-26.47 0-48-21.53-48-48S357.5 288 384 288s48 21.53 48 48S410.5 384 384 384zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-9-1": [512, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M432 448h-32V304C400 295.2 392.8 288 384 288h-32c-8.844 0-16 7.156-16 16S343.2 320 352 320h16v128h-32c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c8.844 0 16-7.156 16-16S440.8 448 432 448zM384 32c-44.13 0-80 35.88-80 80S339.9 192 384 192c16.73 0 32.25-5.199 45.11-14.01C421.3 204.5 396.1 224 368 224C359.2 224 352 231.2 352 240S359.2 256 368 256c52.94 0 96-43.06 96-96V112C464 67.88 428.1 32 384 32zM384 160c-26.47 0-48-21.53-48-48S357.5 64 384 64s48 21.53 48 48S410.5 160 384 160zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-a-z": [512, 512, ["sort-alpha-asc", "sort-alpha-down"], "f15d", "M478.3 200.8l-79.1-160c-5.438-10.81-23.19-10.81-28.62 0l-79.1 160c-3.953 7.906-.75 17.5 7.156 21.47c7.906 4 17.52 .7187 21.47-7.156L329.9 192h108.2l11.58 23.16c3.096 6.156 12.08 11.88 21.47 7.156C479.1 218.3 482.3 208.8 478.3 200.8zM345.9 160l38.11-76.22L422.1 160H345.9zM447.1 448h-94.7l107.2-134c3.844-4.812 4.578-11.38 1.922-16.94C459.7 291.5 454.2 288 447.1 288H319.1c-8.844 0-16 7.156-16 16s7.156 16 16 16h94.7l-107.2 134c-3.844 4.812-4.578 11.38-1.922 16.94C308.2 476.5 313.8 480 319.1 480h127.1c8.844 0 15.1-7.156 15.1-16S456.8 448 447.1 448zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-16-16-16S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-arrow-up": [448, 512, ["sort-alt"], "f883", "M224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352zM427.3 132.7l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L304 86.63V464c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l68.69 68.69C407.8 158.4 411.9 160 416 160s8.188-1.562 11.31-4.688C433.6 149.1 433.6 138.9 427.3 132.7z"],
    "arrow-down-big-small": [512, 512, ["sort-size-down"], "f88c", "M399.1 320H336c-26.4 0-48 21.6-48 48v64c0 26.4 21.6 48 48 48h63.1c26.4 0 48-21.6 48-48v-64C447.1 341.6 426.4 320 399.1 320zM415.1 432c0 8.672-7.326 16-16 16H336c-8.674 0-16-7.328-16-16v-64c0-8.672 7.326-16 16-16h63.1c8.674 0 16 7.328 16 16V432zM464 32h-128C309.5 32 288 53.49 288 80v128C288 234.5 309.5 256 336 256h128C490.5 256 512 234.5 512 208v-128C512 53.49 490.5 32 464 32zM480 208C480 216.8 472.8 224 464 224h-128C327.2 224 320 216.8 320 208v-128C320 71.18 327.2 64 336 64h128C472.8 64 480 71.18 480 80V208zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-from-dotted-line": [448, 512, [], "e090", "M320 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S306.7 87.1 320 87.1zM224 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S210.7 87.1 224 87.1zM416 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S402.7 87.1 416 87.1zM128 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S114.7 87.1 128 87.1zM32 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S18.74 87.1 32 87.1zM212.7 475.3C215.8 478.4 219.9 479.1 224 479.1s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 425.4V159.1c0-8.844-7.156-16-16-16s-16 7.156-16 16v265.4L91.31 308.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L212.7 475.3z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M324.7 308.7L208 425.4V128c0-8.844-7.156-16-16-16S176 119.2 176 128v297.4L59.31 308.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C183.8 478.4 187.9 480 192 480s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62S330.9 302.4 324.7 308.7zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "arrow-down-left": [320, 512, [], "e091", "M315.3 122.6L54.43 383.4L240 384C248.9 384 256 391.2 256 400C255.1 408.9 248.8 416 240 416l-224-.6562C7.141 415.3 0 408.2 0 399.3V176C0 167.2 7.156 160 16 160S32 167.2 32 176v184.6l260.7-260.7c6.25-6.25 16.38-6.25 22.62 0S321.6 116.3 315.3 122.6z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M208 288h-160C39.16 288 32 295.2 32 304S39.16 320 48 320h121.4l-148.7 148.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L192 342.6V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-160C224 295.2 216.8 288 208 288zM491.3 20.69c-6.25-6.25-16.38-6.25-22.62 0L320 169.4V48C320 39.16 312.8 32 304 32S288 39.16 288 48v160C288 216.8 295.2 224 304 224h160C472.8 224 480 216.8 480 208S472.8 192 464 192h-121.4l148.7-148.7C497.6 37.06 497.6 26.94 491.3 20.69z"],
    "arrow-down-long": [320, 512, ["long-arrow-down"], "f175", "M315.3 363.3l-144 144C168.2 510.4 164.1 512 160 512s-8.188-1.562-11.31-4.688l-144-144c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L144 457.4V16C144 7.156 151.2 0 160 0s16 7.156 16 16v441.4l116.7-116.7c6.25-6.25 16.38-6.25 22.62 0S321.6 357.1 315.3 363.3z"],
    "arrow-down-right": [320, 512, [], "e093", "M320 176v223.3c0 8.812-7.141 15.97-15.95 16l-224 .6562C71.23 416 64.03 408.9 64 400c-.0313-8.812 7.109-16 15.95-16.03l185.6-.5547L4.688 122.6c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L288 360.6V176C288 167.2 295.2 160 304 160S320 167.2 320 176z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M304 208h128C440.8 208 448 200.8 448 192s-7.156-16-16-16h-128c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208zM304 336h192c8.844 0 16-7.156 16-16s-7.156-16-16-16h-192c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336zM304 80h64c8.844 0 16-7.156 16-16S376.8 48 368 48h-64c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80zM560 432h-256c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h256c8.844 0 16-7.156 16-16S568.8 432 560 432zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M336 192h63.1c26.4 0 48-21.6 48-48v-64c0-26.4-21.6-48-48-48H336C309.6 32 288 53.6 288 80v64C288 170.4 309.6 192 336 192zM320 80C320 71.33 327.3 64 336 64h63.1c8.674 0 16 7.328 16 16v64c0 8.672-7.326 16-16 16H336C327.3 160 320 152.7 320 144V80zM464 256h-128C309.5 256 288 277.5 288 304v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 277.5 490.5 256 464 256zM480 432c0 8.824-7.178 16-16 16h-128c-8.822 0-16-7.176-16-16v-128C320 295.2 327.2 288 336 288h128C472.8 288 480 295.2 480 304V432zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-square-triangle": [512, 512, ["sort-shapes-down-alt"], "f889", "M336 223.1l96 .0059c26.51 0 48-21.49 48-48.01V80c0-26.51-21.49-48-48-48h-96c-26.51 0-48 21.49-48 48v95.99C288 202.5 309.5 223.1 336 223.1zM320 80c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16v95.99c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16V80zM492.1 438.9l-83.13-137.1c-5.562-9.188-15.28-13.76-24.97-13.76s-19.34 4.573-24.91 13.76l-83.25 137.1c-11 18.25 2.75 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM307.8 448l76.29-125.6l76.18 125.6H307.8zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-15.1-16-15.1S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-to-arc": [512, 512, [], "e4ae", "M256 480C379.7 480 480 379.7 480 256C480 247.2 487.2 240 496 240C504.8 240 512 247.2 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 247.2 7.164 240 16 240C24.84 240 32 247.2 32 256C32 379.7 132.3 480 256 480zM267.1 346.6C264.9 350 260.6 352 256 352C251.4 352 247.1 350 244 346.6L116 202.6C110.2 196 110.8 185.9 117.4 180C123.1 174.2 134.1 174.8 139.1 181.4L240 293.9V16C240 7.164 247.2 0 256 0C264.8 0 272 7.164 272 16V293.9L372 181.4C377.9 174.8 388 174.2 394.6 180C401.2 185.9 401.8 196 395.1 202.6L267.1 346.6z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M224 352c4.094 0 8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 297.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v281.4L91.31 180.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C215.8 350.4 219.9 352 224 352zM448 432v-96c0-8.844-7.156-16-16-16S416 327.2 416 336v96c0 26.47-21.53 48-48 48h-288C53.53 480 32 458.5 32 432v-96C32 327.2 24.84 320 16 320S0 327.2 0 336v96C0 476.1 35.88 512 80 512h288C412.1 512 448 476.1 448 432z"],
    "arrow-down-to-dotted-line": [448, 512, [], "e095", "M128 424c-13.26 0-24 10.75-24 24S114.7 472 128 472S152 461.3 152 448S141.3 424 128 424zM224 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S237.3 424 224 424zM32 424c-13.26 0-24 10.75-24 24S18.74 472 32 472S56 461.3 56 448S45.26 424 32 424zM320 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S333.3 424 320 424zM416 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S429.3 424 416 424zM212.7 363.3C215.8 366.4 219.9 367.1 224 367.1s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 313.4V47.1c0-8.844-7.156-16-16-16s-16 7.156-16 16v265.4L91.31 196.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L212.7 363.3z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M180.7 395.3C183.8 398.4 187.9 400 192 400s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L208 345.4V48C208 39.16 200.8 32 192 32S176 39.16 176 48v297.4L59.31 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L180.7 395.3zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M432 128h-64C359.2 128 352 135.2 352 144S359.2 160 368 160h64C440.8 160 448 167.2 448 176v288c0 8.812-7.188 16-16 16h-352C71.19 480 64 472.8 64 464v-288C64 167.2 71.19 160 80 160h64C152.8 160 160 152.8 160 144S152.8 128 144 128h-64C53.53 128 32 149.5 32 176v288C32 490.5 53.53 512 80 512h352c26.47 0 48-21.53 48-48v-288C480 149.5 458.5 128 432 128zM148.7 260.7c-6.25 6.25-6.25 16.38 0 22.62l96 96C247.8 382.4 251.9 384 256 384s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L272 329.4V16C272 7.156 264.8 0 256 0S240 7.156 240 16v313.4L171.3 260.7C165.1 254.4 154.9 254.4 148.7 260.7z"],
    "arrow-down-triangle-square": [512, 512, ["sort-shapes-down"], "f888", "M432 288l-96-.0107c-26.51 0-48 21.49-48 48v95.99c0 26.51 21.49 48 48 48l96 .0098c26.51 0 48-21.5 48-48.01v-95.99C480 309.5 458.5 288 432 288zM448 431.1c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16v-95.99c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16V431.1zM492.1 182.9l-83.13-137.1C403.4 36.58 393.7 31.99 384 31.99s-19.34 4.591-24.91 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM307.8 192l76.29-125.6L460.2 192H307.8zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-15.1-16-15.1S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-up-across-line": [576, 512, [], "e4af", "M52.69 411.3C46.44 405.1 46.44 394.9 52.69 388.7C58.93 382.4 69.06 382.4 75.31 388.7L144 457.4V272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H400V54.63L331.3 123.3C325.1 129.6 314.9 129.6 308.7 123.3C302.4 117.1 302.4 106.9 308.7 100.7L404.7 4.686C410.9-1.562 421.1-1.562 427.3 4.686L523.3 100.7C529.6 106.9 529.6 117.1 523.3 123.3C517.1 129.6 506.9 129.6 500.7 123.3L432 54.63V240H560C568.8 240 576 247.2 576 256C576 264.8 568.8 272 560 272H175.1V457.4L244.7 388.7C250.9 382.4 261.1 382.4 267.3 388.7C273.6 394.9 273.6 405.1 267.3 411.3L171.3 507.3C165.1 513.6 154.9 513.6 148.7 507.3L52.69 411.3zM143.1 47.1C143.1 39.16 151.2 31.1 159.1 31.1C168.8 31.1 175.1 39.16 175.1 47.1V192H143.1V47.1zM432 320V464C432 472.8 424.8 480 416 480C407.2 480 400 472.8 400 464V320H432z"],
    "arrow-down-up-lock": [640, 512, [], "e4b0", "M116.7 507.3L20.69 411.3C14.44 405.1 14.44 394.9 20.69 388.7C26.93 382.4 37.06 382.4 43.31 388.7L112 457.4V272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H304V54.63L235.3 123.3C229.1 129.6 218.9 129.6 212.7 123.3C206.4 117.1 206.4 106.9 212.7 100.7L308.7 4.686C314.9-1.562 325.1-1.562 331.3 4.686L427.3 100.7C433.6 106.9 433.6 117.1 427.3 123.3C421.1 129.6 410.9 129.6 404.7 123.3L336 54.63V240H420.6C417.6 250.1 416 260.9 416 272H143.1V457.4L212.7 388.7C218.9 382.4 229.1 382.4 235.3 388.7C241.6 394.9 241.6 405.1 235.3 411.3L139.3 507.3C133.1 513.6 122.9 513.6 116.7 507.3V507.3zM111.1 200V47.1C111.1 39.16 119.2 31.1 127.1 31.1C136.8 31.1 143.1 39.16 143.1 47.1V200H111.1zM336 312V464C336 472.8 328.8 480 319.1 480C311.2 480 303.1 472.8 303.1 464V312H336zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 224C501.5 224 480 245.5 480 272V320H576V272C576 245.5 554.5 224 528 224zM448 352V480H608V352H448z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M368 432h-64c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h64c8.844 0 16-7.156 16-16S376.8 432 368 432zM432 304h-128c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336h128c8.844 0 16-7.156 16-16S440.8 304 432 304zM496 176h-192c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208h192C504.8 208 512 200.8 512 192S504.8 176 496 176zM560 48h-256c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80h256C568.8 80 576 72.84 576 64S568.8 48 560 48zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-z-a": [512, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M478.3 456.8l-79.99-159.1c-5.438-10.81-23.19-10.81-28.62 0l-79.99 159.1c-3.953 7.906-.75 17.5 7.156 21.47c7.906 4 17.51 .7187 21.47-7.156l11.58-23.16h108.2l11.58 23.16c3.094 6.156 12.08 11.88 21.47 7.156C479.1 474.3 482.3 464.7 478.3 456.8zM345.9 415.1L384 339.7l38.11 76.21H345.9zM320 63.1h94.7l-107.2 133.1c-3.842 4.812-4.576 11.38-1.92 16.94c2.67 5.531 8.261 9.078 14.42 9.078h127.1c8.844 0 15.1-7.172 15.1-16.02s-7.154-15.1-15.1-15.1h-94.7l107.2-133.1c3.842-4.812 4.576-11.37 1.92-16.93C459.7 35.53 454.2 32 447.1 32h-127.1c-8.844 0-15.1 7.156-15.1 16C304 56.84 311.2 63.1 320 63.1zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-16-16-16S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-left": [448, 512, [8592], "f060", "M448 256C448 264.8 440.6 272 431.4 272H54.11l140.7 149.3c6.157 6.531 5.655 16.66-1.118 22.59C190.5 446.6 186.5 448 182.5 448c-4.505 0-9.009-1.75-12.28-5.25l-165.9-176c-5.752-6.094-5.752-15.41 0-21.5l165.9-176c6.19-6.562 16.69-7 23.45-1.094c6.773 5.938 7.275 16.06 1.118 22.59L54.11 240h377.3C440.6 240 448 247.2 448 256z"],
    "arrow-left-from-line": [448, 512, [8612, "arrow-from-right"], "f344", "M352 240H54.63l116.7-116.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-144 144C1.563 247.8 0 251.9 0 256s1.562 8.188 4.688 11.31l144 144c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L54.63 272H352c8.844 0 16-7.156 16-16S360.8 240 352 240zM432 64C423.2 64 416 71.16 416 80v352c0 8.844 7.156 16 16 16s16-7.156 16-16v-352C448 71.16 440.8 64 432 64z"],
    "arrow-left-long": [512, 512, ["long-arrow-left"], "f177", "M148.7 411.3l-144-144C1.563 264.2 0 260.1 0 256s1.562-8.188 4.688-11.31l144-144c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 240H496C504.8 240 512 247.2 512 256s-7.156 16-16 16H54.63l116.7 116.7c6.25 6.25 6.25 16.38 0 22.62S154.9 417.6 148.7 411.3z"],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", "M0 80C0 71.16 7.164 64 16 64C24.84 64 32 71.16 32 80V432C32 440.8 24.84 448 16 448C7.164 448 0 440.8 0 432V80zM100.7 244.7L244.7 100.7C250.9 94.44 261.1 94.44 267.3 100.7C273.6 106.9 273.6 117.1 267.3 123.3L150.6 239.1H624C632.8 239.1 640 247.2 640 255.1C640 264.8 632.8 271.1 624 271.1H150.6L267.3 388.7C273.6 394.9 273.6 405.1 267.3 411.3C261.1 417.6 250.9 417.6 244.7 411.3L100.7 267.3C97.56 264.2 96 260.1 96 255.1C96 251.9 97.56 247.8 100.7 244.7V244.7z"],
    "arrow-left-to-line": [448, 512, [8676, "arrow-to-left"], "f33e", "M432 240H134.6l116.7-116.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-144 144C81.56 247.8 80 251.9 80 256s1.562 8.188 4.688 11.31l144 144c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L134.6 272H432C440.8 272 448 264.8 448 256S440.8 240 432 240zM16 64C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432v-352C32 71.16 24.84 64 16 64z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M311.9 277.1L39.87 37.99C35.41 34.05 29.75 32 24.01 32C20.67 32 17.31 32.69 14.12 34.11C5.531 37.98 0 46.58 0 56.02v367.1c0 10.06 6.281 19.06 15.72 22.53c2.703 .9844 5.5 1.469 8.281 1.469c6.906 0 13.64-2.985 18.28-8.453l90.18-106.1l60.91 137.1C196 476.5 201.9 480 208 480c2.156 0 4.375-.4375 6.484-1.375c8.078-3.594 11.7-13.05 8.125-21.13l-61.11-137.5l134.5 0c9.984 0 18.92-6.172 22.45-15.52C321.1 295.1 319.4 284.6 311.9 277.1zM129.1 287.1L32 402.2V73.71l242.8 214.3H129.1z"],
    "arrow-right": [448, 512, [8594], "f061", "M443.7 266.8l-165.9 176C274.5 446.3 269.1 448 265.5 448c-3.986 0-7.988-1.375-11.16-4.156c-6.773-5.938-7.275-16.06-1.118-22.59L393.9 272H16.59c-9.171 0-16.59-7.155-16.59-15.1S7.421 240 16.59 240h377.3l-140.7-149.3c-6.157-6.531-5.655-16.66 1.118-22.59c6.789-5.906 17.27-5.469 23.45 1.094l165.9 176C449.4 251.3 449.4 260.7 443.7 266.8z"],
    "arrow-right-arrow-left": [512, 512, [8644, "exchange"], "f0ec", "M16 160h441.4l-100.7 100.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l128-128C510.4 152.2 512 148.1 512 144s-1.562-8.188-4.688-11.31l-128-128c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L457.4 128H16C7.156 128 0 135.2 0 144S7.156 160 16 160zM496 352H54.63l100.7-100.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-128 128C1.563 359.8 0 363.9 0 368s1.562 8.188 4.688 11.31l128 128c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L54.63 384H496c8.844 0 16-7.156 16-16S504.8 352 496 352z"],
    "arrow-right-from-arc": [512, 512, [], "e4b1", "M256 480C264.8 480 272 487.2 272 496C272 504.8 264.8 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C264.8 0 272 7.164 272 16C272 24.84 264.8 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480zM506.6 244C510 247.1 512 251.4 512 256C512 260.6 510 264.9 506.6 267.1L362.6 395.1C356 401.8 345.9 401.2 340 394.6C334.2 388 334.8 377.9 341.4 372L453.9 271.1H175.1C167.2 271.1 159.1 264.8 159.1 255.1C159.1 247.2 167.2 239.1 175.1 239.1H453.9L341.4 139.1C334.8 134.1 334.2 123.1 340 117.4C345.9 110.8 356 110.2 362.6 116L506.6 244z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M507.3 244.7l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L457.4 240H176C167.2 240 160 247.2 160 256s7.156 16 16 16h281.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C510.4 264.2 512 260.1 512 256S510.4 247.8 507.3 244.7zM176 448h-96C53.53 448 32 426.5 32 400v-288C32 85.53 53.53 64 80 64h96C184.8 64 192 56.84 192 48S184.8 32 176 32h-96C35.88 32 0 67.88 0 112v288C0 444.1 35.88 480 80 480h96C184.8 480 192 472.8 192 464S184.8 448 176 448z"],
    "arrow-right-from-line": [448, 512, [8614, "arrow-from-left"], "f343", "M443.3 244.7l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L393.4 240H96C87.16 240 80 247.2 80 256S87.16 272 96 272h297.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C446.4 264.2 448 260.1 448 256S446.4 247.8 443.3 244.7zM16 64C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432v-352C32 71.16 24.84 64 16 64z"],
    "arrow-right-long": [512, 512, ["long-arrow-right"], "f178", "M363.3 100.7l144 144C510.4 247.8 512 251.9 512 255.1s-1.562 8.188-4.688 11.31l-144 144c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l116.7-116.7H16c-8.844 0-16-7.156-16-15.1c0-8.844 7.156-16 16-16h441.4l-116.7-116.7c-6.25-6.25-6.25-16.38 0-22.62S357.1 94.44 363.3 100.7z"],
    "arrow-right-long-to-line": [640, 512, [], "e3d5", "M640 432C640 440.8 632.8 448 624 448C615.2 448 608 440.8 608 432V80C608 71.16 615.2 64 624 64C632.8 64 640 71.16 640 80V432zM544 256C544 260.1 542.4 264.2 539.3 267.3L395.3 411.3C389.1 417.6 378.9 417.6 372.7 411.3C366.4 405.1 366.4 394.9 372.7 388.7L489.4 272H16C7.156 272 0 264.8 0 256C0 247.2 7.156 240 16 240H489.4L372.7 123.3C366.4 117.1 366.4 106.9 372.7 100.7C378.9 94.44 389.1 94.44 395.3 100.7L539.3 244.7C542.4 247.8 544 251.9 544 256V256z"],
    "arrow-right-to-arc": [512, 512, [], "e4b2", "M480 256C480 132.3 379.7 32 256 32C247.2 32 240 24.84 240 16C240 7.164 247.2 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C247.2 512 240 504.8 240 496C240 487.2 247.2 480 256 480C379.7 480 480 379.7 480 256zM346.6 244C350 247.1 352 251.4 352 256C352 260.6 350 264.9 346.6 267.1L202.6 395.1C196 401.8 185.9 401.2 180 394.6C174.2 388 174.8 377.9 181.4 372L293.9 271.1H16C7.164 271.1 0 264.8 0 255.1C0 247.2 7.164 239.1 16 239.1H293.9L181.4 139.1C174.8 134.1 174.2 123.1 180 117.4C185.9 110.8 196 110.2 202.6 116L346.6 244z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 256c0-4.094-1.562-8.188-4.688-11.31l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L297.4 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h281.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C350.4 264.2 352 260.1 352 256zM432 32h-96C327.2 32 320 39.16 320 48S327.2 64 336 64h96C458.5 64 480 85.53 480 112v288c0 26.47-21.53 48-48 48h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c44.13 0 80-35.88 80-80v-288C512 67.88 476.1 32 432 32z"],
    "arrow-right-to-city": [640, 512, [], "e4b3", "M320 496C320 504.8 312.8 512 304 512C295.2 512 288 504.8 288 496V48C288 21.49 309.5 0 336 0H464C490.5 0 512 21.49 512 48V192H544V112C544 103.2 551.2 96 560 96C568.8 96 576 103.2 576 112V192H592C618.5 192 640 213.5 640 240V496C640 504.8 632.8 512 624 512C615.2 512 608 504.8 608 496V240C608 231.2 600.8 224 592 224H480V48C480 39.16 472.8 32 464 32H336C327.2 32 320 39.16 320 48V496zM352 96C352 78.33 366.3 64 384 64H416C433.7 64 448 78.33 448 96V128C448 145.7 433.7 160 416 160H384C366.3 160 352 145.7 352 128V96zM416 96H384V128H416V96zM544 256C561.7 256 576 270.3 576 288V320C576 337.7 561.7 352 544 352H512C494.3 352 480 337.7 480 320V288C480 270.3 494.3 256 512 256H544zM512 320H544V288H512V320zM480 416C480 398.3 494.3 384 512 384H544C561.7 384 576 398.3 576 416V448C576 465.7 561.7 480 544 480H512C494.3 480 480 465.7 480 448V416zM544 416H512V448H544V416zM416 192C433.7 192 448 206.3 448 224V256C448 273.7 433.7 288 416 288H384C366.3 288 352 273.7 352 256V224C352 206.3 366.3 192 384 192H416zM384 256H416V224H384V256zM352 352C352 334.3 366.3 320 384 320H416C433.7 320 448 334.3 448 352V384C448 401.7 433.7 416 416 416H384C366.3 416 352 401.7 352 384V352zM416 352H384V384H416V352zM251.3 244.7C257.6 250.9 257.6 261.1 251.3 267.3L155.3 363.3C149.1 369.6 138.9 369.6 132.7 363.3C126.4 357.1 126.4 346.9 132.7 340.7L201.4 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H201.4L132.7 171.3C126.4 165.1 126.4 154.9 132.7 148.7C138.9 142.4 149.1 142.4 155.3 148.7L251.3 244.7z"],
    "arrow-right-to-line": [448, 512, [8677, "arrow-to-right"], "f340", "M432 64C423.2 64 416 71.16 416 80v352c0 8.844 7.156 16 16 16s16-7.156 16-16v-352C448 71.16 440.8 64 432 64zM219.3 100.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L313.4 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h297.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C366.4 264.2 368 260.1 368 256s-1.562-8.188-4.688-11.31L219.3 100.7z"],
    "arrow-rotate-left": [512, 512, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M480 256c0 123.5-100.4 223.9-223.9 223.9c-69.41 0-133.9-31.3-176.7-86.05c-5.438-6.938-4.203-17 2.75-22.44c6.984-5.531 17.03-4.25 22.47 2.75C141.3 421.1 196.5 448 256 448c105.9 0 192-86.13 192-192s-86.13-192-192-192C187.1 64 124.5 100.7 90.15 160H176C184.8 160 192 167.2 192 176S184.8 192 176 192h-128C39.16 192 32 184.8 32 176v-128C32 39.16 39.16 32 48 32S64 39.16 64 48v93.56C104.4 73.87 176.6 32.11 256.1 32.11C379.6 32.11 480 132.5 480 256z"],
    "arrow-rotate-right": [512, 512, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M255.9 32.11c79.47 0 151.8 41.76 192.1 109.4V48C448 39.16 455.2 32 464 32S480 39.16 480 48v128C480 184.8 472.8 192 464 192h-128C327.2 192 320 184.8 320 176S327.2 160 336 160h85.85C387.5 100.7 324.9 64 256 64C150.1 64 64 150.1 64 256s86.13 192 192 192c59.48 0 114.7-26.91 151.3-73.84c5.438-7 15.48-8.281 22.47-2.75c6.953 5.438 8.187 15.5 2.75 22.44c-42.8 54.75-107.3 86.05-176.7 86.05C132.4 479.9 32 379.5 32 256S132.4 32.11 255.9 32.11z"],
    "arrow-trend-down": [576, 512, [], "e097", "M384 384H521.4L320 182.6L203.3 299.3C197.1 305.6 186.9 305.6 180.7 299.3L4.686 123.3C-1.562 117.1-1.562 106.9 4.686 100.7C10.93 94.44 21.06 94.44 27.31 100.7L192 265.4L308.7 148.7C314.9 142.4 325.1 142.4 331.3 148.7L544 361.4V224C544 215.2 551.2 208 560 208C568.8 208 576 215.2 576 224V400C576 408.8 568.8 416 560 416H384C375.2 416 368 408.8 368 400C368 391.2 375.2 384 384 384L384 384z"],
    "arrow-trend-up": [576, 512, [], "e098", "M368 112C368 103.2 375.2 96 384 96H560C568.8 96 576 103.2 576 112V288C576 296.8 568.8 304 560 304C551.2 304 544 296.8 544 288V150.6L331.3 363.3C325.1 369.6 314.9 369.6 308.7 363.3L192 246.6L27.31 411.3C21.07 417.6 10.94 417.6 4.686 411.3C-1.562 405.1-1.562 394.9 4.686 388.7L180.7 212.7C186.9 206.4 197.1 206.4 203.3 212.7L320 329.4L521.4 128H384C375.2 128 368 120.8 368 112L368 112z"],
    "arrow-turn-down": [384, 512, ["level-down"], "f149", "M347.3 363.3l-144 144C200.2 510.4 196.1 512 191.1 512s-8.187-1.562-11.31-4.688l-144-144c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L176 457.4V80C176 53.53 154.5 32 128 32H16C7.156 32 0 24.84 0 16S7.156 0 16 0l112 0C172.1 0 208 35.88 208 80v377.4l116.7-116.7c6.25-6.25 16.38-6.25 22.62 0S353.6 357.1 347.3 363.3z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M148.7 443.3l-144-144C1.563 296.2 0 292.1 0 288s1.562-8.188 4.688-11.31l144-144c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 272H432C458.5 272 480 250.5 480 224V48C480 39.16 487.2 32 496 32S512 39.16 512 48v175.1C512 268.1 476.1 304 432 304H54.63l116.7 116.7c6.25 6.25 6.25 16.38 0 22.62S154.9 449.6 148.7 443.3z"],
    "arrow-turn-down-right": [512, 512, [], "e3d6", "M340.7 443.3C334.4 437.1 334.4 426.9 340.7 420.7L457.4 304H80C35.87 304 0 268.1 0 223.1V48C0 39.16 7.156 32 16 32C24.84 32 32 39.16 32 48V224C32 250.5 53.53 272 80 272H457.4L340.7 155.3C334.4 149.1 334.4 138.9 340.7 132.7C346.9 126.4 357.1 126.4 363.3 132.7L507.3 276.7C510.4 279.8 512 283.9 512 288C512 292.1 510.4 296.2 507.3 299.3L363.3 443.3C357.1 449.6 346.9 449.6 340.7 443.3V443.3z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M347.3 171.3c-6.25 6.25-16.38 6.25-22.62 0L208 54.63V432c0 44.13-35.89 80-80 80H16C7.156 512 0 504.8 0 496S7.156 480 16 480H128c26.47 0 48-21.53 48-48V54.63L59.31 171.3c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l144-144C183.8 1.562 187.9 0 192 0c4.094 0 8.188 1.562 11.31 4.688l144 144C353.6 154.9 353.6 165.1 347.3 171.3z"],
    "arrow-up": [384, 512, [8593], "f062", "M379.8 225.7C376.7 229.3 372.3 231.1 368 231.1c-3.844 0-7.703-1.426-10.77-4.31L208 86.12v377.3c0 9.171-7.156 16.59-15.1 16.59S176 472.6 176 463.4V86.12l-149.2 140.7C20.25 232.1 10.14 232.5 4.156 225.7C-1.781 218.9-1.297 208.4 5.234 202.2l176-165.9c6.094-5.768 15.44-5.768 21.53 0l176 165.9C385.3 208.4 385.8 218.9 379.8 225.7z"],
    "arrow-up-1-9": [512, 512, ["sort-numeric-up"], "f163", "M384 256c-44.13 0-80 35.88-80 80S339.9 416 384 416c16.73 0 32.25-5.199 45.11-14.01C421.3 428.5 396.1 448 368 448c-8.844 0-16 7.156-16 16s7.156 16 16 16c52.94 0 96-43.06 96-96v-48C464 291.9 428.1 256 384 256zM384 384c-26.47 0-48-21.53-48-48S357.5 288 384 288s48 21.53 48 48S410.5 384 384 384zM336 224l96-.0039c8.844 0 16-7.152 16-15.1S440.8 192 432 192h-32V48C400 39.16 392.8 32 384 32h-32c-8.844 0-16 7.156-16 16S343.2 64 352 64h16v128h-32C327.2 192 320 199.2 320 208S327.2 224 336 224zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 15.1 16 15.1S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-9-1": [512, 512, ["sort-numeric-up-alt"], "f887", "M432 448h-32V304C400 295.2 392.8 288 384 288h-32c-8.844 0-16 7.156-16 16S343.2 320 352 320h16v128h-32c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c8.844 0 16-7.156 16-16S440.8 448 432 448zM384 32c-44.13 0-80 35.88-80 80S339.9 192 384 192c16.73 0 32.25-5.199 45.11-14.01C421.3 204.5 396.1 224 368 224C359.2 224 352 231.2 352 240S359.2 256 368 256c52.94 0 96-43.06 96-96V112C464 67.88 428.1 32 384 32zM384 160c-26.47 0-48-21.53-48-48S357.5 64 384 64s48 21.53 48 48S410.5 160 384 160zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 15.1 16 15.1S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-a-z": [512, 512, ["sort-alpha-up"], "f15e", "M478.3 200.4l-79.1-160.3c-5.438-10.84-23.19-10.84-28.62 0l-79.1 160.3c-3.953 7.922-.75 17.53 7.156 21.51c7.906 4.004 17.52 .7187 21.47-7.172l11.58-23.19h108.2l11.58 23.19c3.096 6.168 12.08 11.91 21.47 7.172C479.1 217.9 482.3 208.3 478.3 200.4zM345.9 159.5l38.11-76.34l38.11 76.34H345.9zM447.1 447.9h-94.7l107.2-134.2c3.844-4.82 4.578-11.39 1.922-16.96c-2.672-5.543-8.262-8.867-14.42-8.867H319.1c-8.844 0-16 6.957-16 15.82s7.156 16.02 16 16.02h94.7l-107.2 134.2c-3.844 4.82-4.578 11.39-1.922 16.96C308.2 476.5 313.8 480 319.1 480h127.1c8.844 0 15.1-7.168 15.1-16.03C463.1 455.1 456.8 447.9 447.1 447.9zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.156 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-arrow-down": [448, 512, ["sort-up-down"], "e099", "M224 160c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160zM427.3 356.7C424.2 353.6 420.1 352 416 352s-8.188 1.562-11.31 4.688L336 425.4V48C336 39.16 328.8 32 320 32s-16 7.156-16 16v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96C433.6 373.1 433.6 362.9 427.3 356.7z"],
    "arrow-up-big-small": [512, 512, ["sort-size-up"], "f88e", "M399.1 320H336c-26.4 0-48 21.6-48 48v64c0 26.4 21.6 48 48 48h63.1c26.4 0 48-21.6 48-48v-64C447.1 341.6 426.4 320 399.1 320zM415.1 432c0 8.672-7.326 16-16 16H336c-8.672 0-16-7.328-16-16v-64c0-8.672 7.328-16 16-16h63.1c8.674 0 16 7.328 16 16V432zM464 32h-128C309.5 32 288 53.49 288 80v128C288 234.5 309.5 256 336 256h128C490.5 256 512 234.5 512 208v-128C512 53.49 490.5 32 464 32zM480 208C480 216.8 472.8 224 464 224h-128C327.2 224 320 216.8 320 208v-128C320 71.18 327.2 64 336 64h128C472.8 64 480 71.18 480 80V208zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-from-arc": [512, 512, [], "e4b4", "M480 256C480 247.2 487.2 240 496 240C504.8 240 512 247.2 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 247.2 7.164 240 16 240C24.84 240 32 247.2 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256zM244 5.37C247.1 1.955 251.4 0 255.1 0C260.6 0 264.9 1.954 267.1 5.37L395.1 149.4C401.8 155.1 401.2 166.1 394.6 171.1C388 177.8 377.9 177.2 372 170.6L272 58.08V336C272 344.8 264.8 352 255.1 352C247.2 352 239.1 344.8 239.1 336V58.08L139.1 170.6C134.1 177.2 123.1 177.8 117.4 171.1C110.8 166.1 110.2 155.1 116 149.4L244 5.37z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M212.7 4.688l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 54.63V336c0 8.844 7.156 16 16 16s16-7.156 16-16V54.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62l-144-144C232.2 1.562 228.1 0 224 0S215.8 1.562 212.7 4.688zM416 336v96c0 26.47-21.53 48-48 48h-288C53.53 480 32 458.5 32 432v-96C32 327.2 24.84 320 16 320S0 327.2 0 336v96C0 476.1 35.88 512 80 512h288c44.13 0 80-35.88 80-80v-96c0-8.844-7.156-16-16-16S416 327.2 416 336z"],
    "arrow-up-from-dotted-line": [448, 512, [], "e09b", "M128 424c-13.26 0-24 10.75-24 24S114.7 472 128 472S152 461.3 152 448S141.3 424 128 424zM224 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S237.3 424 224 424zM32 424c-13.26 0-24 10.75-24 24S18.74 472 32 472S56 461.3 56 448S45.26 424 32 424zM320 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S333.3 424 320 424zM416 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S429.3 424 416 424zM235.3 36.69C232.2 33.56 228.1 32 224 32S215.8 33.56 212.7 36.69l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 86.63V352c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L235.3 36.69z"],
    "arrow-up-from-ground-water": [576, 512, [], "e4b5", "M272 336V54.63L203.3 123.3C197.1 129.6 186.9 129.6 180.7 123.3C174.4 117.1 174.4 106.9 180.7 100.7L276.7 4.686C282.9-1.562 293.1-1.562 299.3 4.686L395.3 100.7C401.6 106.9 401.6 117.1 395.3 123.3C389.1 129.6 378.9 129.6 372.7 123.3L304 54.63V336C304 344.8 296.8 352 287.1 352C279.2 352 271.1 344.8 271.1 336H272zM64 191.1H192V223.1H64C46.33 223.1 32 238.3 32 255.1V413.3C27.21 415.4 22.32 416.1 17.49 418.1C11.19 419.6 5.326 421.9 0 425V255.1C0 220.7 28.65 191.1 64 191.1V191.1zM558.5 418.1C553.7 416.1 548.8 415.4 544 413.3V255.1C544 238.3 529.7 223.1 512 223.1H384V191.1H512C547.3 191.1 576 220.7 576 255.1V425C570.7 421.9 564.8 419.6 558.5 418.1V418.1zM250.1 458.8C259.9 452.1 268.2 444.8 276.1 436.9C282.6 430.4 293.3 430.4 299.8 436.9C307.8 444.8 315.1 452.1 325.8 458.8C342.3 470 363.1 479.1 383.1 479.1C404.9 479.1 425.6 470 442.2 458.8C451.9 452.1 460.2 444.8 468.1 436.9C474.6 430.4 485.3 430.4 491.8 436.9C499.8 444.8 507.1 452.1 517.8 458.8C530.6 467.5 545.9 475.4 561.9 478.6C569.6 480.1 576 486.4 576 494.2C576 504 567.1 512.1 558.3 510.4C535.2 506.5 514.7 495.4 499.8 485.2C491.8 479.8 485.1 474.4 479.1 469.1C474.8 474.4 468.1 479.8 460.2 485.2C441.5 497.9 414.3 511.1 383.1 511.1C353.7 511.1 326.4 497.9 307.8 485.2C299.8 479.8 293.1 474.4 287.1 469.1C282.8 474.4 276.1 479.8 268.2 485.2C249.5 497.9 222.3 511.1 191.1 511.1C161.7 511.1 134.4 497.9 115.8 485.2C107.8 479.8 101.1 474.4 95.96 469.1C90.82 474.4 84.12 479.8 76.19 485.2C61.25 495.4 40.81 506.5 17.69 510.4C8.016 512.1 .0003 504 .0003 494.2C.0003 486.4 6.421 480.1 14.13 478.6C30.07 475.4 45.38 467.5 58.16 458.8C67.94 452.1 76.16 444.8 84.07 436.9C90.64 430.4 101.3 430.4 107.8 436.9C115.8 444.8 124.1 452.2 133.8 458.8C150.3 470 171.1 479.1 191.1 479.1C212.9 479.1 233.6 470 250.1 458.8H250.1z"],
    "arrow-up-from-line": [384, 512, [8613, "arrow-from-bottom"], "f342", "M59.31 203.3L176 86.63V384c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62l-144-144C200.2 33.56 196.1 32 192 32S183.8 33.56 180.7 36.69l-144 144c-6.25 6.25-6.25 16.38 0 22.62S53.06 209.6 59.31 203.3zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M432 160h-32C391.2 160 384 167.2 384 176S391.2 192 400 192h32C440.8 192 448 199.2 448 208v256c0 8.812-7.188 16-16 16h-352C71.19 480 64 472.8 64 464v-256C64 199.2 71.19 192 80 192h32C120.8 192 128 184.8 128 176S120.8 160 112 160h-32C53.53 160 32 181.5 32 208v256C32 490.5 53.53 512 80 512h352c26.47 0 48-21.53 48-48v-256C480 181.5 458.5 160 432 160zM160 128c4.094 0 8.188-1.562 11.31-4.688L240 54.63V336c0 8.844 7.156 16.02 16 16.02S272 344.8 272 336V54.63l68.69 68.69C343.8 126.4 347.9 128 352 128c9.139 0 16-7.473 16-16c0-4.094-1.562-8.188-4.688-11.31l-96-96C264.2 1.562 260.1-.0002 256-.0002S247.8 1.562 244.7 4.688l-96 96C145.6 103.8 144 107.9 144 112C144 120.5 150.9 128 160 128z"],
    "arrow-up-from-water-pump": [576, 512, [], "e4b6", "M288 48V256H432V54.63L363.3 123.3C357.1 129.6 346.9 129.6 340.7 123.3C334.4 117.1 334.4 106.9 340.7 100.7L436.7 4.687C442.9-1.562 453.1-1.562 459.3 4.687L555.3 100.7C561.6 106.9 561.6 117.1 555.3 123.3C549.1 129.6 538.9 129.6 532.7 123.3L464 54.63V256H512C547.3 256 576 284.7 576 320V425C570.7 421.9 564.8 419.6 558.5 418.1C553.7 416.1 548.8 415.4 544 413.3V320C544 302.3 529.7 288 512 288H64C46.33 288 32 302.3 32 320V413.3C27.21 415.4 22.32 416.1 17.49 418.1C11.19 419.6 5.326 421.9 0 425V320C0 284.7 28.65 256 64 256V48C64 21.49 85.49 0 112 0H240C266.5 0 288 21.49 288 48L288 48zM96 48V256H256V48C256 39.16 248.8 32 240 32H112C103.2 32 96 39.16 96 48zM250.1 458.8C259.9 452.1 268.2 444.8 276.1 436.9C282.6 430.4 293.3 430.4 299.8 436.9C307.8 444.8 315.1 452.1 325.8 458.8C342.3 470 363.1 479.1 383.1 479.1C404.9 479.1 425.6 470 442.2 458.8C451.9 452.1 460.2 444.8 468.1 436.9C474.6 430.4 485.3 430.4 491.8 436.9C499.8 444.8 507.1 452.1 517.8 458.8C530.6 467.5 545.9 475.4 561.9 478.6C569.6 480.1 576 486.4 576 494.2C576 504 567.1 512.1 558.3 510.4C535.2 506.5 514.7 495.4 499.8 485.2C491.8 479.8 485.1 474.4 479.1 469.1C474.8 474.4 468.1 479.8 460.2 485.2C441.5 497.9 414.3 511.1 383.1 511.1C353.7 511.1 326.4 497.9 307.8 485.2C299.8 479.8 293.1 474.4 287.1 469.1C282.8 474.4 276.1 479.8 268.2 485.2C249.5 497.9 222.3 511.1 191.1 511.1C161.7 511.1 134.4 497.9 115.8 485.2C107.8 479.8 101.1 474.4 95.96 469.1C90.82 474.4 84.12 479.8 76.19 485.2C61.25 495.4 40.81 506.5 17.69 510.4C8.016 512.1 .0006 504 .0006 494.2C.0006 486.4 6.422 480.1 14.13 478.6C30.07 475.4 45.38 467.5 58.16 458.8C67.94 452.1 76.16 444.8 84.07 436.9C90.64 430.4 101.3 430.4 107.8 436.9C115.8 444.8 124.1 452.2 133.8 458.8C150.3 470 171.1 479.1 191.1 479.1C212.9 479.1 233.6 470 250.1 458.8H250.1z"],
    "arrow-up-left": [320, 512, [], "e09d", "M315.3 411.3C312.2 414.4 308.1 416 304 416s-8.188-1.562-11.31-4.688L32 150.6v184.6c0 8.844-7.156 16-16 16s-16-7.156-16-16V111.9c0-8.812 7.141-15.97 15.95-16c0 0 224-.6562 224-.6562c8.812 0 15.97 7.125 16 15.97c.0313 8.812-7.109 16-15.95 16.03l-185.6 .5547l260.9 260.9C321.6 394.9 321.6 405.1 315.3 411.3z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M320 336c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L54.63 32H176C184.8 32 192 24.84 192 16S184.8 0 176 0h-160C7.156 0 0 7.156 0 16v160C0 184.8 7.156 192 16 192S32 184.8 32 176V54.63l276.7 276.7C311.8 334.4 315.9 336 320 336zM288 64c-23.5 0-46.69 3.625-68.91 10.81C210.7 77.5 206.1 86.53 208.8 94.94S220.5 108 228.9 105.3C247.1 99.13 267.8 96 288 96c105.9 0 192 86.13 192 192s-86.13 192-192 192s-192-86.13-192-192c0-20.16 3.125-40.03 9.25-59.09C107.1 220.5 103.3 211.5 94.94 208.8C86.63 206.1 77.53 210.7 74.81 219.1C67.63 241.3 64 264.5 64 288c0 123.5 100.5 224 224 224s224-100.5 224-224S411.5 64 288 64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M4.688 148.7l144-144C151.8 1.562 155.9 0 160 0s8.188 1.562 11.31 4.688l144 144c6.25 6.25 6.25 16.38 0 22.62s-16.38 6.25-22.62 0L176 54.63V496c0 8.844-7.156 16-16 16s-16-7.156-16-16V54.63L27.31 171.3c-6.25 6.25-16.38 6.25-22.62 0S-1.563 154.9 4.688 148.7z"],
    "arrow-up-right": [320, 512, [], "e09f", "M320 111.9v223.3c0 8.844-7.156 16-16 16s-16-7.156-16-16V150.6l-260.7 260.7C24.19 414.4 20.09 416 16 416s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62l260.9-260.9l-185.6-.5547C71.11 127.2 63.97 120 64 111.2c.0313-8.844 7.188-15.97 16-15.97l224 .6562C312.9 95.94 320 103.1 320 111.9z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M496 0h-160C327.2 0 320 7.156 320 16S327.2 32 336 32h121.4l-164.7 164.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L480 54.63V176C480 184.8 487.2 192 496 192S512 184.8 512 176v-160C512 7.156 504.8 0 496 0zM196.7 292.7L32 457.4V336C32 327.2 24.84 320 16 320S0 327.2 0 336v160C0 504.8 7.156 512 16 512h160C184.8 512 192 504.8 192 496S184.8 480 176 480H54.63l164.7-164.7c6.25-6.25 6.25-16.38 0-22.62S202.9 286.4 196.7 292.7z"],
    "arrow-up-right-dots": [576, 512, [], "e4b7", "M304 0C312.8 0 320 7.164 320 16V176C320 184.8 312.8 192 304 192C295.2 192 288 184.8 288 176V54.63L27.31 315.3C21.07 321.6 10.94 321.6 4.686 315.3C-1.562 309.1-1.562 298.9 4.686 292.7L265.4 32H144C135.2 32 128 24.84 128 16C128 7.164 135.2 0 144 0H304zM480 80C480 53.49 501.5 32 528 32C554.5 32 576 53.49 576 80C576 106.5 554.5 128 528 128C501.5 128 480 106.5 480 80zM528 96C536.8 96 544 88.84 544 80C544 71.16 536.8 64 528 64C519.2 64 512 71.16 512 80C512 88.84 519.2 96 528 96zM352 208C352 181.5 373.5 160 400 160C426.5 160 448 181.5 448 208C448 234.5 426.5 256 400 256C373.5 256 352 234.5 352 208zM400 224C408.8 224 416 216.8 416 208C416 199.2 408.8 192 400 192C391.2 192 384 199.2 384 208C384 216.8 391.2 224 400 224zM448 336C448 362.5 426.5 384 400 384C373.5 384 352 362.5 352 336C352 309.5 373.5 288 400 288C426.5 288 448 309.5 448 336zM400 320C391.2 320 384 327.2 384 336C384 344.8 391.2 352 400 352C408.8 352 416 344.8 416 336C416 327.2 408.8 320 400 320zM352 464C352 437.5 373.5 416 400 416C426.5 416 448 437.5 448 464C448 490.5 426.5 512 400 512C373.5 512 352 490.5 352 464zM400 480C408.8 480 416 472.8 416 464C416 455.2 408.8 448 400 448C391.2 448 384 455.2 384 464C384 472.8 391.2 480 400 480zM480 464C480 437.5 501.5 416 528 416C554.5 416 576 437.5 576 464C576 490.5 554.5 512 528 512C501.5 512 480 490.5 480 464zM528 480C536.8 480 544 472.8 544 464C544 455.2 536.8 448 528 448C519.2 448 512 455.2 512 464C512 472.8 519.2 480 528 480zM320 336C320 362.5 298.5 384 272 384C245.5 384 224 362.5 224 336C224 309.5 245.5 288 272 288C298.5 288 320 309.5 320 336zM272 320C263.2 320 256 327.2 256 336C256 344.8 263.2 352 272 352C280.8 352 288 344.8 288 336C288 327.2 280.8 320 272 320zM224 464C224 437.5 245.5 416 272 416C298.5 416 320 437.5 320 464C320 490.5 298.5 512 272 512C245.5 512 224 490.5 224 464zM272 480C280.8 480 288 472.8 288 464C288 455.2 280.8 448 272 448C263.2 448 256 455.2 256 464C256 472.8 263.2 480 272 480zM192 464C192 490.5 170.5 512 144 512C117.5 512 96 490.5 96 464C96 437.5 117.5 416 144 416C170.5 416 192 437.5 192 464zM144 448C135.2 448 128 455.2 128 464C128 472.8 135.2 480 144 480C152.8 480 160 472.8 160 464C160 455.2 152.8 448 144 448zM480 336C480 309.5 501.5 288 528 288C554.5 288 576 309.5 576 336C576 362.5 554.5 384 528 384C501.5 384 480 362.5 480 336zM528 352C536.8 352 544 344.8 544 336C544 327.2 536.8 320 528 320C519.2 320 512 327.2 512 336C512 344.8 519.2 352 528 352zM576 208C576 234.5 554.5 256 528 256C501.5 256 480 234.5 480 208C480 181.5 501.5 160 528 160C554.5 160 576 181.5 576 208zM528 192C519.2 192 512 199.2 512 208C512 216.8 519.2 224 528 224C536.8 224 544 216.8 544 208C544 199.2 536.8 192 528 192z"],
    "arrow-up-right-from-square": [448, 512, ["external-link"], "f08e", "M272 64C263.2 64 256 56.84 256 48C256 39.16 263.2 32 272 32H432C440.8 32 448 39.16 448 48V208C448 216.8 440.8 224 432 224C423.2 224 416 216.8 416 208V86.63L187.3 315.3C181.1 321.6 170.9 321.6 164.7 315.3C158.4 309.1 158.4 298.9 164.7 292.7L393.4 64H272zM0 112C0 85.49 21.49 64 48 64H176C184.8 64 192 71.16 192 80C192 88.84 184.8 96 176 96H48C39.16 96 32 103.2 32 112V432C32 440.8 39.16 448 48 448H368C376.8 448 384 440.8 384 432V304C384 295.2 391.2 288 400 288C408.8 288 416 295.2 416 304V432C416 458.5 394.5 480 368 480H48C21.49 480 0 458.5 0 432V112z"],
    "arrow-up-short-wide": [576, 512, ["sort-amount-up-alt"], "f885", "M304 336h192c8.844 0 16-7.156 16-16s-7.156-16-16-16h-192c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336zM304 208h128C440.8 208 448 200.8 448 192s-7.156-16-16-16h-128c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208zM304 80h64c8.844 0 16-7.156 16-16S376.8 48 368 48h-64c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80zM560 432h-256c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h256c8.844 0 16-7.156 16-16S568.8 432 560 432zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M336 192h63.1c26.4 0 48-21.6 48-48v-64c0-26.4-21.6-48-48-48H336C309.6 32 288 53.6 288 80v64C288 170.4 309.6 192 336 192zM320 80C320 71.33 327.3 64 336 64h63.1c8.674 0 16 7.328 16 16v64c0 8.672-7.326 16-16 16H336C327.3 160 320 152.7 320 144V80zM464 256h-128C309.5 256 288 277.5 288 304v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 277.5 490.5 256 464 256zM480 432c0 8.824-7.178 16-16 16h-128c-8.822 0-16-7.176-16-16v-128C320 295.2 327.2 288 336 288h128C472.8 288 480 295.2 480 304V432zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M336 223.1l96 .0059c26.51 0 48-21.49 48-48.01V80c0-26.51-21.49-48-48-48h-96c-26.51 0-48 21.49-48 48v95.99C288 202.5 309.5 223.1 336 223.1zM320 80c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16v95.99c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16V80zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69zM492.1 438.9l-83.13-137.1c-5.562-9.188-15.28-13.76-24.97-13.76s-19.34 4.573-24.91 13.76l-83.25 137.1c-11 18.25 2.75 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM307.8 448l76.29-125.6l76.18 125.6H307.8z"],
    "arrow-up-to-dotted-line": [448, 512, [], "e0a1", "M320 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S306.7 87.1 320 87.1zM224 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S210.7 87.1 224 87.1zM416 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S402.7 87.1 416 87.1zM128 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S114.7 87.1 128 87.1zM32 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S18.74 87.1 32 87.1zM235.3 148.7C232.2 145.6 228.1 144 224 144S215.8 145.6 212.7 148.7l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 198.6V464c0 8.844 7.156 16 16 16s16-7.156 16-16V198.6l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L235.3 148.7z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M203.3 116.7C200.2 113.6 196.1 112 192 112S183.8 113.6 180.7 116.7l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L176 166.6V464c0 8.844 7.156 16 16 16s16-7.156 16-16V166.6l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L203.3 116.7zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M492.1 182.9l-83.13-137.1C403.4 36.58 393.7 31.99 384 31.99s-19.34 4.591-24.91 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM307.8 192l76.29-125.6L460.2 192H307.8zM432 288l-96-.0107c-26.51 0-48 21.49-48 48v95.99c0 26.51 21.49 48 48 48l96 .0098c26.51 0 48-21.5 48-48.01v-95.99C480 309.5 458.5 288 432 288zM448 431.1c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16v-95.99c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16V431.1zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M368 432h-64c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h64c8.844 0 16-7.156 16-16S376.8 432 368 432zM432 304h-128c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336h128c8.844 0 16-7.156 16-16S440.8 304 432 304zM560 48h-256c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80h256C568.8 80 576 72.84 576 64S568.8 48 560 48zM496 176h-192c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208h192C504.8 208 512 200.8 512 192S504.8 176 496 176zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M478.3 456.8l-79.99-159.1c-5.438-10.81-23.19-10.81-28.62 0l-79.99 159.1c-3.953 7.902-.75 17.5 7.156 21.46c7.906 4 17.51 .7187 21.47-7.152l11.58-23.15h108.2l11.58 23.15c3.094 6.152 12.08 11.88 21.47 7.152C479.1 474.3 482.3 464.7 478.3 456.8zM345.9 415.9L384 339.7l38.11 76.21H345.9zM320 63.1h94.7l-107.2 133.1c-3.842 4.812-4.576 11.38-1.92 16.94c2.67 5.531 8.261 9.078 14.42 9.078h127.1c8.844 0 15.1-7.172 15.1-16.02s-7.154-16-15.1-16h-94.7l107.2-133.1c3.842-4.812 4.576-11.37 1.92-16.93C459.7 35.53 454.2 32 447.1 32h-127.1c-8.844 0-15.1 7.156-15.1 16C304 56.84 311.2 63.1 320 63.1zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrows-cross": [448, 512, [], "e0a2", "M429.3 288.4C421.5 289.7 416 297.1 416 305v120.5L291.9 301.4c-6.248-6.25-16.38-6.352-22.63-.1016s-6.246 16.48 .002 22.73l124.1 124.1H272.8c-7.969 0-15.35 5.453-16.62 13.32C254.6 471.5 262.3 480.2 272 480.2h160c8.836 0 16-7.164 16-16v-160C448 294.5 439.4 286.8 429.3 288.4zM156.1 210.9C162.4 217.2 172.5 217.1 178.8 210.8s6.247-16.28-.001-22.53L27.91 37.48c-5.635-5.637-14.71-7-21.17-2.34C-1.5 41.08-2.184 52.64 4.688 59.51L156.1 210.9zM432 32h-160C263.2 32 256 39.16 256 48S263.2 64 272 64h121.4L4.688 452.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L416 86.63V208C416 216.8 423.2 224 432 224S448 216.8 448 208v-160C448 39.16 440.8 32 432 32z"],
    "arrows-down-to-line": [576, 512, [], "e4b8", "M560 448C568.8 448 576 455.2 576 464C576 472.8 568.8 480 560 480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H560zM459.3 395.3C453.1 401.6 442.9 401.6 436.7 395.3L324.7 283.3C318.4 277.1 318.4 266.9 324.7 260.7C330.9 254.4 341.1 254.4 347.3 260.7L432 345.4V48C432 39.16 439.2 32 448 32C456.8 32 464 39.16 464 48V345.4L548.7 260.7C554.9 254.4 565.1 254.4 571.3 260.7C577.6 266.9 577.6 277.1 571.3 283.3L459.3 395.3zM251.3 283.3L139.3 395.3C133.1 401.6 122.9 401.6 116.7 395.3L4.686 283.3C-1.562 277.1-1.562 266.9 4.686 260.7C10.93 254.4 21.06 254.4 27.31 260.7L111.1 345.4V48C111.1 39.16 119.2 32 127.1 32C136.8 32 143.1 39.16 143.1 48V345.4L228.7 260.7C234.9 254.4 245.1 254.4 251.3 260.7C257.6 266.9 257.6 277.1 251.3 283.3z"],
    "arrows-down-to-people": [640, 512, [], "e4b9", "M128 16C128 7.164 135.2 0 144 0C152.8 0 160 7.164 160 16V145.4L196.7 108.7C202.9 102.4 213.1 102.4 219.3 108.7C225.6 114.9 225.6 125.1 219.3 131.3L155.3 195.3C149.1 201.6 138.9 201.6 132.7 195.3L68.69 131.3C62.44 125.1 62.44 114.9 68.69 108.7C74.93 102.4 85.07 102.4 91.31 108.7L128 145.4L128 16zM443.3 108.7L480 145.4V16C480 7.164 487.2 0 496 0C504.8 0 512 7.164 512 16V145.4L548.7 108.7C554.9 102.4 565.1 102.4 571.3 108.7C577.6 114.9 577.6 125.1 571.3 131.3L507.3 195.3C501.1 201.6 490.9 201.6 484.7 195.3L420.7 131.3C414.4 125.1 414.4 114.9 420.7 108.7C426.9 102.4 437.1 102.4 443.3 108.7H443.3zM368 192C368 218.5 346.5 240 320 240C293.5 240 272 218.5 272 192C272 165.5 293.5 144 320 144C346.5 144 368 165.5 368 192zM320 176C311.2 176 304 183.2 304 192C304 200.8 311.2 208 320 208C328.8 208 336 200.8 336 192C336 183.2 328.8 176 320 176zM418.4 384.4L376 315.5V400C376 417.7 361.7 432 344 432H296C278.3 432 264 417.7 264 400V315.5L221.6 384.4C221.5 384.7 221.3 384.9 221.1 385.2C222.3 386.8 223.3 388.4 224.4 390.1L269.6 463.6C274.3 471.1 271.9 480.1 264.4 485.6C256.9 490.3 247 487.9 242.4 480.4L200 411.5V480C200 497.7 185.7 512 168 512H120C102.3 512 88 497.7 88 480V411.5L45.63 480.4C40.1 487.9 31.14 490.3 23.62 485.6C16.09 480.1 13.74 471.1 18.38 463.6L63.63 390.1C78.19 366.4 103.1 352 131.8 352H156.2C170.9 352 184.9 355.1 197.1 363.2L239.6 294.1C254.2 270.4 279.1 256 307.8 256H332.2C360 256 385.8 270.4 400.4 294.1L442.9 363.2C455.1 355.1 469.2 352 483.8 352H508.2C536 352 561.8 366.4 576.4 390.1L621.6 463.6C626.3 471.1 623.9 480.1 616.4 485.6C608.9 490.3 599 487.9 594.4 480.4L552 411.5V480C552 497.7 537.7 512 520 512H472C454.3 512 440 497.7 440 480V411.5L397.6 480.4C392.1 487.9 383.1 490.3 375.6 485.6C368.1 480.1 365.7 471.1 370.4 463.6L415.6 390.1C416.7 388.4 417.8 386.8 418.9 385.2C418.7 384.9 418.5 384.7 418.4 384.4H418.4zM344 400V289.5C340.2 288.5 336.3 288 332.2 288H307.8C303.7 288 299.8 288.5 296 289.5V400H344zM120 385.5V480H168V385.5C164.2 384.5 160.3 384 156.2 384H131.8C127.7 384 123.8 384.5 120 385.5zM520 480V385.5C516.2 384.5 512.3 384 508.2 384H483.8C479.8 384 475.8 384.5 472 385.5V480H520zM96 288C96 261.5 117.5 240 144 240C170.5 240 192 261.5 192 288C192 314.5 170.5 336 144 336C117.5 336 96 314.5 96 288zM144 304C152.8 304 160 296.8 160 288C160 279.2 152.8 272 144 272C135.2 272 128 279.2 128 288C128 296.8 135.2 304 144 304zM544 288C544 314.5 522.5 336 496 336C469.5 336 448 314.5 448 288C448 261.5 469.5 240 496 240C522.5 240 544 261.5 544 288zM496 272C487.2 272 480 279.2 480 288C480 296.8 487.2 304 496 304C504.8 304 512 296.8 512 288C512 279.2 504.8 272 496 272V272z"],
    "arrows-from-dotted-line": [448, 512, [], "e0a3", "M32 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C56 242.7 45.26 231.1 32 231.1zM200 255.1c0 13.25 10.74 24 24 24s24-10.75 24-24c0-13.26-10.74-24-24-24S200 242.7 200 255.1zM152 255.1c0-13.26-10.74-24-24-24S104 242.7 104 255.1c0 13.25 10.74 24 24 24S152 269.2 152 255.1zM416 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C440 242.7 429.3 231.1 416 231.1zM320 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C344 242.7 333.3 231.1 320 231.1zM144 111.1c4.094 0 8.188-1.563 11.31-4.688L208 54.61v121.4c0 8.844 7.156 15.1 16 15.1s16-7.151 16-15.1V54.61l52.69 52.69C295.8 110.4 299.9 111.1 304 111.1c9.139 0 16-7.48 16-16.01c0-4.094-1.562-8.181-4.688-11.31L235.3 4.69C231.3 .6451 226.5 0 223.1 0S216.7 .6451 212.7 4.69L132.7 84.67C129.6 87.8 128 91.89 128 95.98C128 104.5 134.9 111.1 144 111.1zM304 399.1c-4.094 0-8.188 1.563-11.31 4.688L240 457.4v-121.4c0-8.844-7.156-16-16-16s-16 7.16-16 16v121.4L155.3 404.7C152.2 401.6 148.1 399.1 144 399.1c-9.139 0-16 7.471-16 15.1c0 4.094 1.562 8.19 4.688 11.31l79.98 79.98C214.4 509 218.3 512 224 512s9.609-2.98 11.33-4.707l79.98-79.98C318.4 424.2 320 420.1 320 415.1C320 407.5 313.1 399.1 304 399.1z"],
    "arrows-from-line": [448, 512, [], "e0a4", "M144 111.1c4.094 0 8.188-1.562 11.31-4.688L208 54.61v121.4c0 8.844 7.156 15.1 16 15.1s16-7.152 16-15.1V54.61l52.69 52.69C295.8 110.4 299.9 111.1 304 111.1c9.139 0 16-7.478 16-16.01c0-4.094-1.562-8.182-4.688-11.31L235.3 4.688C231.3 .6445 226.5 0 223.1 0S216.7 .6445 212.7 4.688L132.7 84.67C129.6 87.8 128 91.89 128 95.98C128 104.5 134.9 111.1 144 111.1zM304 399.1c-4.094 0-8.188 1.562-11.31 4.688L240 457.4v-121.4c0-8.844-7.156-16-16-16s-16 7.159-16 16v121.4l-52.69-52.69C152.2 401.6 148.1 399.1 144 399.1c-9.139 0-16 7.471-16 15.1c0 4.094 1.562 8.189 4.688 11.31l79.98 79.98C214.4 509 218.3 512 224 512s9.609-2.98 11.33-4.707l79.98-79.98C318.4 424.2 320 420.1 320 415.1C320 407.5 313.1 399.1 304 399.1zM432 240h-416C7.156 240 0 247.1 0 255.1S7.156 272 16 272h416c8.844 0 16-7.165 16-16.01S440.8 240 432 240z"],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", "M507.3 267.3l-112 112C392.2 382.4 388.1 384 384 384s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62L457.4 272H54.63l84.69 84.69c6.25 6.25 6.25 16.38 0 22.62C136.2 382.4 132.1 384 128 384s-8.188-1.562-11.31-4.688l-112-112c-6.25-6.25-6.25-16.38 0-22.62l112-112c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 240h402.8l-84.69-84.69c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l112 112C513.6 250.9 513.6 261.1 507.3 267.3z"],
    "arrows-left-right-to-line": [640, 512, [], "e4ba", "M16 64C24.84 64 32 71.16 32 80V432C32 440.8 24.84 448 16 448C7.164 448 0 440.8 0 432V80C0 71.16 7.164 64 16 64zM219.3 148.7C225.6 154.9 225.6 165.1 219.3 171.3L150.6 240H489.4L420.7 171.3C414.4 165.1 414.4 154.9 420.7 148.7C426.9 142.4 437.1 142.4 443.3 148.7L539.3 244.7C545.6 250.9 545.6 261.1 539.3 267.3L443.3 363.3C437.1 369.6 426.9 369.6 420.7 363.3C414.4 357.1 414.4 346.9 420.7 340.7L489.4 272H150.6L219.3 340.7C225.6 346.9 225.6 357.1 219.3 363.3C213.1 369.6 202.9 369.6 196.7 363.3L100.7 267.3C94.44 261.1 94.44 250.9 100.7 244.7L196.7 148.7C202.9 142.4 213.1 142.4 219.3 148.7H219.3zM640 432C640 440.8 632.8 448 624 448C615.2 448 608 440.8 608 432V80C608 71.16 615.2 64 624 64C632.8 64 640 71.16 640 80V432z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M416 176V86.63L246.6 256L416 425.4V336c0-8.844 7.156-16 16-16s16 7.156 16 16v128c0 8.844-7.156 16-16 16h-128c-8.844 0-16-7.156-16-16s7.156-16 16-16h89.38L224 278.6L54.63 448H144C152.8 448 160 455.2 160 464S152.8 480 144 480h-128C7.156 480 0 472.8 0 464v-128C0 327.2 7.156 320 16 320S32 327.2 32 336v89.38L201.4 256L32 86.63V176C32 184.8 24.84 192 16 192S0 184.8 0 176v-128C0 39.16 7.156 32 16 32h128C152.8 32 160 39.16 160 48S152.8 64 144 64H54.63L224 233.4L393.4 64H304C295.2 64 288 56.84 288 48S295.2 32 304 32h128C440.8 32 448 39.16 448 48v128C448 184.8 440.8 192 432 192S416 184.8 416 176z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M208 288h-160C39.16 288 32 295.2 32 304S39.16 320 48 320h121.4l-148.7 148.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L192 342.6V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-160C224 295.2 216.8 288 208 288zM304 224h160C472.8 224 480 216.8 480 208S472.8 192 464 192h-121.4l148.7-148.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L320 169.4V48C320 39.16 312.8 32 304 32S288 39.16 288 48v160C288 216.8 295.2 224 304 224zM342.6 320H464c8.844 0 16-7.156 16-16S472.8 288 464 288h-160C295.2 288 288 295.2 288 304v160c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l148.7 148.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L342.6 320zM208 32C199.2 32 192 39.16 192 48v121.4L43.31 20.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L169.4 192H48C39.16 192 32 199.2 32 208S39.16 224 48 224h160C216.8 224 224 216.8 224 208v-160C224 39.16 216.8 32 208 32z"],
    "arrows-repeat": [512, 512, ["repeat-alt"], "f364", "M176 112h211.8l-62.05 51.72c-6.781 5.656-7.703 15.75-2.047 22.53C326.9 190 331.4 192 336 192c3.609 0 7.234-1.219 10.23-3.719l96-80C445.9 105.3 448 100.7 448 95.1s-2.109-9.248-5.75-12.28l-96-80c-6.797-5.688-16.89-4.719-22.55 2.031c-5.656 6.781-4.734 16.88 2.047 22.53L387.8 80H176C78.95 80 0 158.1 0 255.1C0 264.8 7.156 272 16 272S32.01 264.8 32.01 256C32.01 176.6 96.59 112 176 112zM496 240c-8.844 0-16.01 7.156-16.01 16c0 79.41-64.59 144-143.1 144H124.2l62.05-51.72c6.781-5.656 7.703-15.75 2.047-22.53C182.7 319 172.6 318.1 165.8 323.7l-96 80C66.11 406.8 64 411.2 64 415.1s2.109 9.25 5.75 12.28l96 80C168.8 510.8 172.4 512 175.1 512c4.594 0 9.141-1.969 12.31-5.75c5.656-6.781 4.734-16.88-2.047-22.53L124.2 432H336c97.05 0 176-78.97 176-176C512 247.2 504.8 240 496 240z"],
    "arrows-repeat-1": [512, 512, ["repeat-1-alt"], "f366", "M176 112h211.8l-62.05 51.72c-3.794 3.164-5.754 7.718-5.754 12.3C319.1 186.8 329.3 192 336 192c3.609 0 7.234-1.219 10.23-3.719l96-80C445.9 105.3 448 100.7 448 95.1s-2.109-9.248-5.75-12.28l-96-80c-2.99-2.502-6.619-3.716-10.23-3.716c-6.754 0-16.03 5.286-16.03 15.98c0 4.585 1.96 9.139 5.754 12.3L387.8 80H176C78.95 80 0 158.1 0 255.1C0 264.8 7.156 272 16 272S32.01 264.8 32.01 256C32.01 176.6 96.59 112 176 112zM272 320c8.844 0 16-7.156 16-16v-96C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208S231.2 224 240 224H256v80C256 312.8 263.2 320 272 320zM496 240c-8.844 0-16.01 7.156-16.01 16c0 79.41-64.59 144-143.1 144H124.2l62.05-51.72c3.794-3.164 5.754-7.718 5.754-12.3c0-10.72-9.208-15.96-15.1-15.96c-3.611 0-7.249 1.212-10.26 3.703l-96 80C66.11 406.8 64 411.3 64 416s2.109 9.25 5.75 12.28l96 80C168.8 510.8 172.4 512 175.1 512c6.715 0 16.02-5.265 16.02-15.98c0-4.585-1.96-9.139-5.754-12.3L124.2 432H336c97.05 0 176-78.97 176-176C512 247.2 504.8 240 496 240z"],
    "arrows-retweet": [640, 512, ["retweet-alt"], "f361", "M336 368h-192V118.6l84.69 84.69C231.8 206.4 235.9 208 240 208s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-112-112c-6.25-6.25-16.38-6.25-22.62 0l-112 112c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 118.6V384c0 8.844 7.156 16 16 16h208c8.844 0 16-7.156 16-16S344.8 368 336 368zM635.3 308.7c-6.25-6.25-16.38-6.25-22.62 0L528 393.4V128c0-8.844-7.156-16-16-16H304C295.2 112 288 119.2 288 128s7.156 16 16 16h192v249.4l-84.69-84.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l112 112C503.8 446.4 507.9 448 512 448s8.187-1.562 11.31-4.688l112-112C641.6 325.1 641.6 314.9 635.3 308.7z"],
    "arrows-rotate": [512, 512, [128472, "refresh", "sync"], "f021", "M464 32C455.2 32 448 39.16 448 48v129.3C416.2 99.72 340.6 48 256 48c-102 0-188.3 72.91-205.1 173.3C49.42 230.1 55.3 238.3 64.02 239.8C64.91 239.9 65.8 240 66.67 240c7.672 0 14.45-5.531 15.77-13.34C96.69 141.7 169.7 80 256 80c72.49 0 137.3 44.88 163.6 112H304C295.2 192 288 199.2 288 208S295.2 224 304 224h160C472.8 224 480 216.8 480 208v-160C480 39.16 472.8 32 464 32zM447.1 272.2c-8.766-1.562-16.97 4.406-18.42 13.12C415.3 370.3 342.3 432 255.1 432c-72.49 0-137.3-44.88-163.6-112H208C216.8 320 224 312.8 224 304S216.8 288 208 288h-160C39.16 288 32 295.2 32 304v160C32 472.8 39.16 480 48 480S64 472.8 64 464v-129.3C95.84 412.3 171.4 464 256 464c101.1 0 188.3-72.91 205.1-173.3C462.6 281.9 456.7 273.7 447.1 272.2z"],
    "arrows-spin": [512, 512, [], "e4bb", "M257.1 79.53C245.8 79.53 234.7 80.6 223.1 82.65V50.16C234.8 48.43 245.9 47.53 257.1 47.53C310.9 47.53 359.9 67.94 396.8 101.4L423.9 74.35C439 59.23 464.9 69.93 464.9 91.32V177.4C464.9 186.2 457.7 193.4 448.9 193.4H362.8C341.5 193.4 330.8 167.5 345.9 152.4L374.2 124.1C343.1 96.37 302.1 79.53 257.1 79.53V79.53zM432.9 161.4V110.6L382.2 161.4H432.9zM81.14 255.5C81.14 266.6 82.16 277.5 84.13 288H51.66C49.1 277.4 49.14 266.6 49.14 255.5C49.14 202.6 68.93 154.2 101.5 117.5L74.34 90.35C59.22 75.23 69.93 49.38 91.31 49.38H177.4C186.2 49.38 193.4 56.54 193.4 65.38V151.4C193.4 172.8 167.5 183.5 152.4 168.4L124.2 140.2C97.37 171.1 81.14 211.4 81.14 255.5H81.14zM161.4 81.38H110.6L161.4 132.1V81.38zM433.1 255.5C433.1 244.8 432.2 234.2 430.3 224H462.8C464.3 234.3 465.1 244.8 465.1 255.5C465.1 309.3 444.7 358.3 411.2 395.2L439.9 423.9C455 439.1 444.3 464.9 422.1 464.9H336.9C328.1 464.9 320.9 457.7 320.9 448.9V362.8C320.9 341.5 346.8 330.8 361.9 345.9L388.6 372.6C416.3 341.5 433.1 300.5 433.1 255.5H433.1zM403.6 432.9L352.9 382.2V432.9H403.6zM288 461.3C277.9 462.8 267.6 463.5 257.1 463.5C204.2 463.5 155.8 443.7 119.1 411.2L90.34 439.9C75.22 455.1 49.37 444.3 49.37 422.1V336.9C49.37 328.1 56.54 320.9 65.37 320.9H151.4C172.8 320.9 183.5 346.8 168.4 361.9L141.8 388.5C172.7 415.3 213 431.5 257.1 431.5C267.7 431.5 277.1 430.6 288 428.8V461.3zM81.37 403.7L132.1 352.9H81.37V403.7z"],
    "arrows-split-up-and-left": [512, 512, [], "e4bc", "M235.3 123.3C229.1 129.6 218.9 129.6 212.7 123.3C206.4 117.1 206.4 106.9 212.7 100.7L308.7 4.686C314.9-1.562 325.1-1.562 331.3 4.686L427.3 100.7C433.6 106.9 433.6 117.1 427.3 123.3C421.1 129.6 410.9 129.6 404.7 123.3L336 54.63V400C336 444.2 371.8 480 416 480H496C504.8 480 512 487.2 512 496C512 504.8 504.8 512 496 512H416C354.1 512 304 461.9 304 400V384C304 339.8 268.2 304 224 304H54.63L123.3 372.7C129.6 378.9 129.6 389.1 123.3 395.3C117.1 401.6 106.9 401.6 100.7 395.3L4.686 299.3C1.686 296.3 0 292.2 0 288C0 283.8 1.686 279.7 4.686 276.7L100.7 180.7C106.9 174.4 117.1 174.4 123.3 180.7C129.6 186.9 129.6 197.1 123.3 203.3L54.63 272H224C255.3 272 283.7 284.9 304 305.6V54.63L235.3 123.3z"],
    "arrows-to-circle": [640, 512, [], "e4bd", "M160 137.4V80C160 71.16 167.2 64 176 64C184.8 64 192 71.16 192 80V176C192 184.8 184.8 192 176 192H80C71.16 192 64 184.8 64 176C64 167.2 71.16 160 80 160H137.4L4.686 27.31C-1.562 21.07-1.562 10.93 4.686 4.686C10.93-1.562 21.07-1.562 27.31 4.686L160 137.4zM224 256C224 202.1 266.1 160 320 160C373 160 416 202.1 416 256C416 309 373 352 320 352C266.1 352 224 309 224 256zM320 320C355.3 320 384 291.3 384 256C384 220.7 355.3 192 320 192C284.7 192 256 220.7 256 256C256 291.3 284.7 320 320 320zM480 80V137.4L612.7 4.686C618.9-1.562 629.1-1.562 635.3 4.686C641.6 10.93 641.6 21.07 635.3 27.31L502.6 160H560C568.8 160 576 167.2 576 176C576 184.8 568.8 192 560 192H464C455.2 192 448 184.8 448 176V80C448 71.16 455.2 64 464 64C472.8 64 480 71.16 480 80V80zM160 432V374.6L27.31 507.3C21.07 513.6 10.93 513.6 4.686 507.3C-1.562 501.1-1.562 490.9 4.686 484.7L137.4 352H80C71.16 352 64 344.8 64 336C64 327.2 71.16 320 80 320H176C184.8 320 192 327.2 192 336V432C192 440.8 184.8 448 176 448C167.2 448 160 440.8 160 432zM464 448C455.2 448 448 440.8 448 432V336C448 327.2 455.2 320 464 320H560C568.8 320 576 327.2 576 336C576 344.8 568.8 352 560 352H502.6L635.3 484.7C641.6 490.9 641.6 501.1 635.3 507.3C629.1 513.6 618.9 513.6 612.7 507.3L480 374.6V432C480 440.8 472.8 448 464 448V448z"],
    "arrows-to-dot": [512, 512, [], "e4be", "M272 137.4L324.7 84.69C330.9 78.44 341.1 78.44 347.3 84.69C353.6 90.93 353.6 101.1 347.3 107.3L267.3 187.3C261.1 193.6 250.9 193.6 244.7 187.3L164.7 107.3C158.4 101.1 158.4 90.93 164.7 84.69C170.9 78.44 181.1 78.44 187.3 84.69L240 137.4V16C240 7.164 247.2 0 256 0C264.8 0 272 7.164 272 16L272 137.4zM288 256C288 273.7 273.7 288 256 288C238.3 288 224 273.7 224 256C224 238.3 238.3 224 256 224C273.7 224 288 238.3 288 256zM324.7 427.3L272 374.6V496C272 504.8 264.8 512 256 512C247.2 512 240 504.8 240 496V374.6L187.3 427.3C181.1 433.6 170.9 433.6 164.7 427.3C158.4 421.1 158.4 410.9 164.7 404.7L244.7 324.7C250.9 318.4 261.1 318.4 267.3 324.7L347.3 404.7C353.6 410.9 353.6 421.1 347.3 427.3C341.1 433.6 330.9 433.6 324.7 427.3L324.7 427.3zM84.69 164.7C90.94 158.4 101.1 158.4 107.3 164.7L187.3 244.7C193.6 250.9 193.6 261.1 187.3 267.3L107.3 347.3C101.1 353.6 90.94 353.6 84.69 347.3C78.44 341.1 78.44 330.9 84.69 324.7L137.4 271.1H16C7.165 271.1 .0019 264.8 .0019 255.1C.0019 247.2 7.165 239.1 16 239.1H137.4L84.69 187.3C78.44 181.1 78.44 170.9 84.69 164.7L84.69 164.7zM427.3 187.3L374.6 239.1H496C504.8 239.1 512 247.2 512 255.1C512 264.8 504.8 271.1 496 271.1H374.6L427.3 324.7C433.6 330.9 433.6 341.1 427.3 347.3C421.1 353.6 410.9 353.6 404.7 347.3L324.7 267.3C318.4 261.1 318.4 250.9 324.7 244.7L404.7 164.7C410.9 158.4 421.1 158.4 427.3 164.7C433.6 170.9 433.6 181.1 427.3 187.3L427.3 187.3z"],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", "M200 256c0 13.25 10.74 24 24 24S248 269.3 248 256c0-13.26-10.74-24-24-24S200 242.7 200 256zM152 256c0-13.26-10.74-24-24-24S104 242.7 104 256c0 13.25 10.74 24 24 24S152 269.3 152 256zM32 232C18.74 232 8 242.7 8 256c0 13.25 10.74 24 24 24S56 269.3 56 256C56 242.7 45.26 232 32 232zM416 232c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM320 232c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM212.7 187.3C214.4 189 218.3 192 224 192s9.609-2.98 11.33-4.707l79.98-79.98C318.4 104.2 320 100.1 320 96c0-8.527-6.865-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L240 137.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v121.4L155.3 84.69C152.2 81.56 148.1 80 144 80C134.9 80 128 87.47 128 96c0 4.094 1.562 8.188 4.688 11.31L212.7 187.3zM235.3 324.7C231.3 320.7 226.5 320 224 320s-7.298 .6529-11.33 4.697l-79.98 79.98C129.6 407.8 128 411.9 128 416c0 8.527 6.865 16 16 16c4.094 0 8.188-1.562 11.31-4.688L208 374.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l52.69 52.69C295.8 430.4 299.9 432 304 432c9.139 0 16-7.473 16-16c0-4.094-1.562-8.188-4.688-11.31L235.3 324.7z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M127.1 105.4V48C127.1 39.16 135.2 32 143.1 32C152.8 32 159.1 39.16 159.1 48V144C159.1 152.8 152.8 160 143.1 160H47.1C39.16 160 31.1 152.8 31.1 144C31.1 135.2 39.16 128 47.1 128H105.4L20.68 43.31C14.44 37.07 14.44 26.93 20.68 20.69C26.93 14.44 37.06 14.44 43.31 20.69L127.1 105.4zM596.7 20.69C602.9 14.44 613.1 14.44 619.3 20.69C625.6 26.93 625.6 37.07 619.3 43.31L534.6 128H591.1C600.8 128 607.1 135.2 607.1 144C607.1 152.8 600.8 160 591.1 160H495.1C487.2 160 479.1 152.8 479.1 144V48C479.1 39.16 487.2 32 495.1 32C504.8 32 511.1 39.16 511.1 48V105.4L596.7 20.69zM400 256C400 300.2 364.2 336 319.1 336C275.8 336 239.1 300.2 239.1 256C239.1 211.8 275.8 176 319.1 176C364.2 176 400 211.8 400 256zM319.1 208C293.5 208 271.1 229.5 271.1 256C271.1 282.5 293.5 304 319.1 304C346.5 304 368 282.5 368 256C368 229.5 346.5 208 319.1 208zM506.5 243.9C510.3 251.6 510.3 260.4 506.5 268.1C481.4 318.4 417.3 400 319.1 400C222.7 400 158.6 318.4 133.5 268.1C129.7 260.4 129.7 251.6 133.5 243.9C158.6 193.6 222.7 112 319.1 112C417.3 112 481.4 193.6 506.5 243.9V243.9zM476.7 256C452.6 209 397.3 144 319.1 144C242.7 144 187.4 209 163.3 256C187.4 302.1 242.7 368 319.1 368C397.3 368 452.6 302.1 476.7 256zM596.7 491.3L511.1 406.6V464C511.1 472.8 504.8 480 495.1 480C487.2 480 479.1 472.8 479.1 464V368C479.1 359.2 487.2 352 495.1 352H591.1C600.8 352 607.1 359.2 607.1 368C607.1 376.8 600.8 384 591.1 384H534.6L619.3 468.7C625.6 474.9 625.6 485.1 619.3 491.3C613.1 497.6 602.9 497.6 596.7 491.3V491.3zM105.4 384H47.1C39.16 384 31.1 376.8 31.1 368C31.1 359.2 39.16 352 47.1 352H143.1C152.8 352 159.1 359.2 159.1 368V464C159.1 472.8 152.8 480 143.1 480C135.2 480 127.1 472.8 127.1 464V406.6L43.31 491.3C37.06 497.6 26.93 497.6 20.68 491.3C14.44 485.1 14.44 474.9 20.68 468.7L105.4 384z"],
    "arrows-to-line": [448, 512, [], "e0a7", "M235.3 324.7C231.3 320.7 226.5 320 224 320s-7.299 .6547-11.33 4.698l-79.98 79.98C129.6 407.8 128 411.9 128 416c0 8.523 6.865 16 16 16c4.094 0 8.188-1.562 11.31-4.688L208 374.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l52.69 52.69C295.8 430.4 299.9 432 304 432c9.139 0 16-7.477 16-16c0-4.094-1.562-8.188-4.688-11.31L235.3 324.7zM212.7 187.3C214.4 189 218.3 192 224 192s9.609-2.98 11.33-4.707l79.98-79.98C318.4 104.2 320 100.1 320 96c0-8.527-6.865-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L240 137.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v121.4L155.3 84.69C152.2 81.56 148.1 80 144 80C134.9 80 128 87.47 128 96c0 4.094 1.562 8.188 4.688 11.31L212.7 187.3zM432 240h-416C7.156 240 0 247.1 0 255.1S7.156 272 16 272h416c8.844 0 16-7.165 16-16.01S440.8 240 432 240z"],
    "arrows-turn-right": [448, 512, [], "e4c0", "M291.1 5.464C297.8-1.186 307.9-1.86 314.5 3.959L442.5 115.1C446 118.1 448 123.4 448 128C448 132.6 446 137 442.5 140L314.5 252C307.9 257.9 297.8 257.2 291.1 250.5C286.1 243.9 286.8 233.8 293.5 227.1L389.4 143.1H112C67.82 143.1 32 179.8 32 223.1V271.1C32 280.8 24.84 287.1 16 287.1C7.164 287.1 .0006 280.8 .0006 271.1V223.1C.0006 162.1 50.14 111.1 112 111.1H389.4L293.5 28.04C286.8 22.22 286.1 12.11 291.1 5.464V5.464zM195.1 261.5C201.8 254.8 211.9 254.1 218.5 259.1L346.5 371.1C350 374.1 352 379.4 352 384C352 388.6 350 393 346.5 396L218.5 508C211.9 513.9 201.8 513.2 195.1 506.5C190.1 499.9 190.8 489.8 197.5 483.1L293.4 400H80C53.49 400 32 421.5 32 448V496C32 504.8 24.84 512 16 512C7.164 512 0 504.8 0 496V448C0 403.8 35.82 368 80 368H293.4L197.5 284C190.8 278.2 190.1 268.1 195.1 261.5L195.1 261.5z"],
    "arrows-turn-to-dots": [512, 512, [], "e4c1", "M260.7 36.69C266.9 30.44 277.1 30.44 283.3 36.69C289.6 42.93 289.6 53.06 283.3 59.31L230.6 112H432C476.2 112 512 147.8 512 192V240C512 248.8 504.8 256 496 256C487.2 256 480 248.8 480 240V192C480 165.5 458.5 144 432 144H230.6L283.3 196.7C289.6 202.9 289.6 213.1 283.3 219.3C277.1 225.6 266.9 225.6 260.7 219.3L180.7 139.3C174.4 133.1 174.4 122.9 180.7 116.7L260.7 36.69zM331.3 372.7C337.6 378.9 337.6 389.1 331.3 395.3L251.3 475.3C245.1 481.6 234.9 481.6 228.7 475.3C222.4 469.1 222.4 458.9 228.7 452.7L281.4 400H80C53.49 400 32 421.5 32 448V496C32 504.8 24.84 512 16 512C7.164 512 0 504.8 0 496V448C0 403.8 35.82 368 80 368H281.4L228.7 315.3C222.4 309.1 222.4 298.9 228.7 292.7C234.9 286.4 245.1 286.4 251.3 292.7L331.3 372.7zM384 384C384 348.7 412.7 320 448 320C483.3 320 512 348.7 512 384C512 419.3 483.3 448 448 448C412.7 448 384 419.3 384 384zM448 416C465.7 416 480 401.7 480 384C480 366.3 465.7 352 448 352C430.3 352 416 366.3 416 384C416 401.7 430.3 416 448 416zM0 127.1C0 92.65 28.65 63.1 64 63.1C99.35 63.1 128 92.65 128 127.1C128 163.3 99.35 191.1 64 191.1C28.65 191.1 0 163.3 0 127.1zM64 159.1C81.67 159.1 96 145.7 96 127.1C96 110.3 81.67 95.1 64 95.1C46.33 95.1 32 110.3 32 127.1C32 145.7 46.33 159.1 64 159.1z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M139.3 4.688l112 112C254.4 119.8 256 123.9 256 128s-1.562 8.188-4.688 11.31c-6.25 6.25-16.38 6.25-22.62 0L144 54.63v402.8l84.69-84.69c6.25-6.25 16.38-6.25 22.62 0C254.4 375.8 256 379.9 256 384s-1.562 8.188-4.688 11.31l-112 112c-6.25 6.25-16.38 6.25-22.62 0l-112-112c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L112 457.4V54.63L27.31 139.3c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l112-112C122.9-1.562 133.1-1.562 139.3 4.688z"],
    "arrows-up-down-left-right": [512, 512, ["arrows"], "f047", "M512 255.1c0 4.094-1.562 8.222-4.688 11.35l-80 80C424.2 350.4 420.1 352 416 352c-9.139 0-16-7.473-16-16c0-4.094 1.562-8.188 4.688-11.31L457.4 272H272v185.4l52.69-52.69C327.8 401.6 331.9 400 336 400c9.139 0 16 7.473 16 16c0 4.094-1.562 8.188-4.688 11.31l-80 80C264.2 510.4 260.1 512 256 512s-8.188-1.562-11.31-4.688l-80-80C161.6 424.2 160 420.1 160 416c0-8.527 6.865-16 16-16c4.094 0 8.188 1.562 11.31 4.688L240 457.4V272H54.63l52.69 52.69C110.4 327.8 112 331.9 112 336C112 344.5 105.1 352 96 352c-4.094 0-8.188-1.562-11.31-4.688l-80-80C1.563 264.2 0 260.1 0 255.1s1.562-8.153 4.688-11.28l80-80C87.81 161.6 91.91 160 96 160c9.139 0 16 7.473 16 16c0 4.094-1.562 8.188-4.688 11.31L54.63 240H240V54.63L187.3 107.3C184.2 110.4 180.1 112 176 112C166.9 112 160 104.5 160 96c0-4.094 1.562-8.188 4.688-11.31l80-80C247.8 1.562 251.9 0 256 0s8.188 1.562 11.31 4.688l80 80C350.4 87.81 352 91.91 352 96c0 8.527-6.865 16-16 16c-4.094 0-8.188-1.562-11.31-4.688L272 54.63V240h185.4l-52.69-52.69C401.6 184.2 400 180.1 400 176C400 167.5 406.9 160 416 160c4.094 0 8.188 1.562 11.31 4.688l80 80C510.4 247.8 512 251.9 512 255.1z"],
    "arrows-up-to-line": [576, 512, [], "e4c2", "M16 64C7.164 64 0 56.84 0 48C0 39.16 7.164 32 16 32H560C568.8 32 576 39.16 576 48C576 56.84 568.8 64 560 64H16zM116.7 116.7C122.9 110.4 133.1 110.4 139.3 116.7L251.3 228.7C257.6 234.9 257.6 245.1 251.3 251.3C245.1 257.6 234.9 257.6 228.7 251.3L144 166.6V464C144 472.8 136.8 480 128 480C119.2 480 112 472.8 112 464V166.6L27.31 251.3C21.07 257.6 10.94 257.6 4.686 251.3C-1.562 245.1-1.562 234.9 4.686 228.7L116.7 116.7zM324.7 228.7L436.7 116.7C442.9 110.4 453.1 110.4 459.3 116.7L571.3 228.7C577.6 234.9 577.6 245.1 571.3 251.3C565.1 257.6 554.9 257.6 548.7 251.3L464 166.6V464C464 472.8 456.8 480 448 480C439.2 480 432 472.8 432 464V166.6L347.3 251.3C341.1 257.6 330.9 257.6 324.7 251.3C318.4 245.1 318.4 234.9 324.7 228.7V228.7z"],
    "asterisk": [448, 512, [10033, 61545], "2a", "M413.8 368.1C410.8 373.2 405.5 376 399.1 376c-2.766 0-5.562-.7187-8.125-2.219L240 284V464c0 8.844-7.156 16-15.1 16S208 472.8 208 464V284l-151.9 89.73C53.58 375.3 50.79 376 48.02 376c-5.469 0-10.8-2.812-13.8-7.859c-4.484-7.609-1.969-17.42 5.641-21.92L192.5 256L39.86 165.8c-7.609-4.5-10.12-14.31-5.641-21.92c4.531-7.578 14.31-10.06 21.92-5.641L208 227.1V48C208 39.16 215.2 32 224 32S240 39.16 240 48v179.1l151.9-89.73c7.641-4.422 17.42-1.938 21.92 5.641c4.484 7.609 1.969 17.42-5.641 21.92L255.5 256l152.7 90.22C415.7 350.7 418.3 360.5 413.8 368.1z"],
    "at": [512, 512, [61946], "40", "M259.7 16.03C116.5 13.94 2.766 140.5 17.25 283.1c11.96 117.8 102.2 205.2 221.5 212.8c9.275 .5957 17.18-6.739 17.18-16.04c0-8.395-6.552-15.39-14.92-15.92c-106.1-6.828-185.7-86.38-192.7-192.5c-7.852-119.6 82.95-220.8 202.6-223.4c118.1-2.607 212.1 89.77 212.1 208.2V278.7c0 26.43-17.55 50.57-43.34 56.27c-36.37 8.039-68.67-19.59-68.67-54.64v-120.1c0-8.846-7.168-16.02-16.01-16.02c-8.838 0-16.02 7.165-16.02 16.01v17.88c-24.95-25.56-61.83-39.39-101.6-31.85C173.5 154.7 137.8 190.7 129.8 235.6c-12.72 70.86 41.68 132.8 110.2 132.8c37.39 0 70.32-18.63 90.68-46.9c16.48 30.84 50.34 51.03 88.7 46.15c44.44-5.656 76.63-45.58 76.63-90.42V256.3C495.1 122.8 392.5 17.96 259.7 16.03zM239.9 336.3c-44.13 0-80.02-35.93-80.02-80.09S195.8 176.2 239.9 176.2s80.02 35.93 80.02 80.09S284.1 336.3 239.9 336.3z"],
    "atom": [512, 512, [9883], "f5d2", "M444.9 256c15.5-20.25 26.56-40.63 31.68-60c6-22.62 4-43.38-6-60.25c-18.25-30.5-60.38-42.88-113.5-38.38C333.9 37.75 297.6 0 256 0S178.1 37.75 155 97.38c-53.25-4.5-95.38 7.875-113.5 38.38C31.38 152.6 29.38 173.4 35.38 196C40.5 215.4 51.56 235.8 67.06 256C51.56 276.3 40.5 296.6 35.38 316c-6 22.62-4 43.38 6 60.25c15.88 26.5 49.63 39.5 93.13 39.5c6.375 0 13.5-1.25 20.25-1.75C177.1 473.9 214.3 512 256 512s77.1-38.13 101.3-97.1c6.75 .4997 13.88 1.75 20.25 1.75c43.5 0 77.25-13 93-39.5c10.12-16.88 12.12-37.63 6.125-60.25C471.5 296.6 460.4 276.3 444.9 256zM68.88 359.8c-5.5-9.25-6.375-21.25-2.625-35.5C69.1 310.5 77.88 295.9 88.63 281c13.5 13.88 28 26.62 43.25 38.38c2.625 21.62 6.875 43 12.62 64C106.8 385.3 79.13 376.9 68.88 359.8zM128.4 274.8C121.6 268.5 115.3 262.3 109.3 256c6-6.25 12.38-12.5 19.12-18.75C128.3 243.5 128 249.6 128 256S128.3 268.5 128.4 274.8zM131.9 192.5C116.6 204.3 102.1 217.1 88.63 231C77.88 216.1 69.1 201.4 66.25 187.8C62.5 173.5 63.38 161.5 68.88 152.3c9.25-15.5 32.75-24 65.25-24c3.25 0 6.875 .25 10.38 .375C138.8 149.6 134.5 171 131.9 192.5zM343.8 167c-8.375-5.25-16.88-10.5-25.88-15.5C311.5 147.9 305 144.6 298.6 141.4c12-3.625 24.25-6.5 36.5-8.875C337.1 142 341.9 157.4 343.8 167zM256 32c24.12 0 49.5 26 68.25 70C300.9 106.8 278.1 113.5 256 122.3C233.9 113.5 211.1 106.8 187.8 102C206.5 58 231.9 32 256 32zM176.9 132.5c12.25 2.375 24.5 5.25 36.5 8.875C207 144.6 200.5 148 194.1 151.5c-9 5-17.5 10.25-25.88 15.5C170.1 157.4 173.1 142 176.9 132.5zM168.3 345c8.375 5.25 16.88 10.5 25.88 15.5c6.75 3.75 13.38 6.5 20.12 9.875c-12.25 3.75-24.75 6.75-37.38 9.125C173.4 368.1 170.6 356.6 168.3 345zM256 480c-24.12 0-49.75-26.25-68.38-70.5C211 404.8 233.9 398 256 389.3c22.12 8.75 45 15.5 68.38 20.25C305.8 453.8 280.1 480 256 480zM335.1 379.5c-12.62-2.375-25-5.375-37.25-9.125c6.625-3.375 13.38-6.125 20-9.875c9-5 17.5-10.25 25.88-15.5C341.4 357.1 338.4 368.6 335.1 379.5zM349.9 302c-15.25 11.12-31.12 21.37-47.5 30.5c-15.12 8.375-30.5 16-46.38 22.62c-15.88-6.625-31.25-14.25-46.38-22.62c-16.38-9.125-32.25-19.38-47.5-30.38C160.8 287.4 160 272 160 256s.7443-31.38 2.119-45.1c15.25-11.13 31.12-21.38 47.5-30.5C224.8 171 240.1 163.5 256 156.8C271.9 163.5 287.3 171 302.4 179.5c16.38 9.125 32.25 19.38 47.5 30.38C351.3 224.6 351.1 240 351.1 256S351.3 287.4 349.9 302zM377.1 128.3c32.38 0 55.88 8.5 65.13 24c5.5 9.25 6.375 21.25 2.625 35.5c-3.75 13.62-11.62 28.38-22.38 43.25c-13.5-13.88-28-26.75-43.25-38.38c-2.625-21.62-6.875-43-12.62-63.88C371 128.5 374.6 128.3 377.1 128.3zM383.6 237.3C390.4 243.5 396.8 249.8 402.8 256c-6 6.25-12.38 12.5-19.12 18.75C383.8 268.5 384 262.4 384 256S383.8 243.5 383.6 237.3zM443.1 359.8c-10.25 17.12-37.88 25.5-75.63 23.62c5.75-21 10-42.38 12.62-64c15.25-11.62 29.75-24.5 43.25-38.38c10.75 14.88 18.62 29.5 22.38 43.25C449.5 338.5 448.6 350.5 443.1 359.8zM256 232C242.8 232 232 242.8 232 256S242.8 280 256 280S280 269.3 280 256S269.3 232 256 232z"],
    "atom-simple": [448, 512, ["atom-alt"], "f5d3", "M426.9 53.49c-26.75-26.63-73.37-28.63-131.4-5.377c-23.25 9.252-47.37 22.63-71.5 38.5c-24.12-15.88-48.25-29.25-71.37-38.5C94.51 24.87 47.88 26.87 21.13 53.49c-38.37 38.25-22.75 118 32.75 202.5c-55.5 84.5-71.12 164.3-32.75 202.5C35.51 472.9 55.63 480 80.13 480c21.12 0 45.62-5.375 72.5-16c23.12-9.25 47.25-22.75 71.37-38.63C248.1 441.3 272.3 454.8 295.5 464c26.75 10.62 51.13 16 72.37 16c24.5 0 44.62-7.125 58.1-21.5c38.38-38.25 22.75-118-32.87-202.5C449.6 171.5 465.2 91.74 426.9 53.49zM307.4 77.74c44.75-17.75 79.1-18.38 96.87-1.625c22.87 22.88 12.87 82.38-30 151.6c-17.38-23-36.37-44.63-56.87-65c-20.38-20.12-42.12-38.88-65.12-56C271 95.12 289.5 84.87 307.4 77.74zM43.76 76.12c8.25-8.125 20.62-12.12 36.5-12.12c16.75 0 37.37 4.625 60.37 13.75c17.88 7.125 36.5 17.38 55.12 29c-46.25 34.38-87.25 75.13-121.1 121C30.88 158.5 20.88 99.12 43.76 76.12zM140.6 434.3c-44.62 17.88-79.87 18.38-96.87 1.625c-22.88-22.88-12.88-82.38 29.1-151.6c17.38 23 36.38 44.63 56.87 65c20.38 20.12 42.13 38.88 65.12 56.13C177.1 416.9 158.5 427.1 140.6 434.3zM153.3 326.6c-22-21.88-42.25-45.5-60.37-70.63c18.12-25.12 38.37-48.75 60.37-70.63c21.88-21.88 45.62-42 70.75-60.13c25.12 18.12 48.75 38.25 70.75 60.13c22 21.88 42.25 45.5 60.37 70.63c-18.12 25.12-38.37 48.75-60.37 70.63c-21.1 21.88-45.62 42-70.75 60.13C198.9 368.6 175.3 348.5 153.3 326.6zM404.2 435.9c-16.88 16.75-52.25 16.25-96.87-1.625c-17.87-7.125-36.5-17.38-55.12-28.88c23-17.25 44.75-36 65.12-56.13c20.5-20.38 39.5-42 56.87-65C417.1 353.5 427.1 412.1 404.2 435.9zM224 232c-13.25 0-24 10.72-24 24.06C199.9 269.3 210.8 280 224 280c6.375 0 12.5-2.494 17-6.982S248 262.4 248 256.1C248 242.8 237.3 232 224 232z"],
    "audio-description": [576, 512, [], "f29e", "M206.3 168.8c-5.438-10.84-23.19-10.84-28.62 0l-80 160c-3.953 7.906-.75 17.52 7.156 21.47c7.922 3.906 17.5 .7344 21.47-7.156L145.9 304H238.1l19.58 39.16C260.5 348.8 266.1 352 272 352c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L206.3 168.8zM161.9 272L192 211.8L222.1 272H161.9zM384 160h-64c-8.844 0-16 7.156-16 16v160c0 8.844 7.156 16 16 16h64c52.94 0 96-43.06 96-96S436.9 160 384 160zM384 320h-48V192H384c35.3 0 64 28.7 64 64S419.3 320 384 320zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416z"],
    "audio-description-slash": [640, 512, [], "e0a8", "M493.9 311.7c11.3-15.74 18.13-34.89 18.13-55.71c0-52.94-43.06-96-96-96L352 160c-8.844 0-16 7.156-16 16v11.07l32 25.26V192H416c35.3 0 64 28.7 64 64c0 13.34-4.119 25.71-11.12 35.98L493.9 311.7zM544 64c17.64 0 32 14.36 32 32v280.5l32 25.26l.0001-305.8c0-35.35-28.65-64-64-64L139.6 32l40.53 32H544zM180.4 227.4l-50.74 101.5c-3.953 7.906-.75 17.52 7.156 21.47c7.922 3.906 17.5 .7344 21.47-7.156L177.9 304H270.1l19.58 39.16C292.5 348.8 298.1 352 304 352c2.406 0 4.844-.5469 7.141-1.688c5.18-2.59 8.064-7.652 8.518-13.03L236.1 272H193.9l12.2-24.39L180.4 227.4zM96 448c-17.64 0-32-14.36-32-32V135.4L32 110.2l0 305.8c0 35.35 28.65 64 64 64L500.4 480l-40.53-32H96zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "austral-sign": [448, 512, [], "e0a9", "M315.8 224H432C440.8 224 448 231.2 448 240C448 248.8 440.8 256 432 256H329.4L356.4 320H432C440.8 320 448 327.2 448 336C448 344.8 440.8 352 432 352H369.1L414.7 457.8C418.2 465.9 414.4 475.3 406.2 478.7C398.1 482.2 388.7 478.4 385.3 470.2L335.2 352H112.8L62.74 470.2C59.29 478.4 49.9 482.2 41.77 478.7C33.63 475.3 29.82 465.9 33.26 457.8L78.01 352H16C7.164 352 0 344.8 0 336C0 327.2 7.164 320 16 320H91.55L118.6 256H16C7.164 256 0 248.8 0 240C0 231.2 7.164 224 16 224H132.2L209.3 41.77C211.8 35.85 217.6 32 224 32C230.4 32 236.2 35.85 238.7 41.77L315.8 224zM281.1 224L223.1 89.06L166.9 224H281.1zM153.4 256L126.3 320H321.7L294.6 256H153.4z"],
    "avocado": [512, 512, [], "e0aa", "M512 142.3c0-72.05-56.44-142.3-140.5-142.3c-39.21 0-78.71 15.73-108.1 45.17C232.4 76.31 192.1 97.3 150.6 108.9C115.4 118.6 .0005 170.8 .0005 306.7c0 113.8 92.76 205.3 205.1 205.3c52.37 0 104.7-20.04 144.7-60.13c67.65-67.87 42.56-130 115.1-203.7l4.357-4.371C498 215.8 512 179.1 512 142.3zM479.1 142.3c0 29.51-11.7 58.04-32.57 78.98l-4.357 4.371c-32.82 32.93-57.16 76.5-72.33 129.5C356.6 404.6 304.3 480 205.1 480c-75.36 0-173-60.5-173-173.3c0-80.95 55.22-147.2 127.1-166.9C287.8 104.5 283.4 32 371.5 32C439.4 32 479.1 89.86 479.1 142.3zM247 176c-68.1 0-134.9 65.3-134.9 135.4c0 59.15 44.98 88.59 88.34 88.59c.0313 0 0 0 0 0c69 0 134.9-65.3 134.9-135.4C335.3 205.4 290.4 176 247 176zM303.6 264.7c0 50.51-49.57 102.7-103.7 102.7c-43.79 0-56.09-33.89-56.09-56.1C143.8 260.2 194.8 208 247 208C281.5 208 303.6 231.7 303.6 264.7z"],
    "award": [384, 512, [], "f559", "M288 358.3c13.98-8.088 17.53-30.04 28.88-41.39c11.35-11.35 33.3-14.88 41.39-28.87c7.98-13.79 .1658-34.54 4.373-50.29C366.7 222.5 383.1 208.5 383.1 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.612-36.5-4.365-50.29c-8.086-13.98-30.03-17.52-41.38-28.87c-11.35-11.35-14.89-33.3-28.87-41.39c-13.76-7.963-34.61-.1852-50.29-4.375C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34C130.5 25.54 109.7 17.74 95.98 25.7C82 33.79 78.46 55.74 67.11 67.08C55.77 78.43 33.81 81.97 25.72 95.95C17.74 109.7 25.56 130.5 21.35 146.2C17.27 161.5 .0008 175.5 .0008 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.615 36.5 4.361 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.89 33.3 28.88 41.4c13.74 7.951 34.61 .1699 50.28 4.369C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34C253.5 358.5 274.2 366.3 288 358.3zM191.1 351.5c-8.029-4.002-20.8-15.34-37.48-19.79c-16.71-4.477-33.04-1.301-42.29-1.717c-4.953-7.838-10.39-23.65-22.51-35.76c-12.11-12.12-27.85-17.5-35.77-22.52C53.59 262.5 56.7 246.1 52.26 229.5c-4.465-16.71-15.77-29.39-19.79-37.48c3.996-8.025 15.33-20.77 19.8-37.5c4.434-16.6 1.33-32.88 1.697-42.27c7.854-4.971 23.63-10.37 35.78-22.52C101.8 77.68 107.3 61.72 112.3 53.95C121.4 53.58 137.9 56.69 154.5 52.25c16.74-4.475 29.33-15.74 37.48-19.79c8.027 3.992 20.77 15.33 37.49 19.8c16.74 4.471 33.01 1.295 42.28 1.711c4.84 7.65 10.45 23.71 22.51 35.76c12.03 12.04 28 17.61 35.77 22.52c.3555 9.273-2.752 25.64 1.693 42.28c4.469 16.71 15.77 29.38 19.79 37.47c-3.977 8-15.32 20.78-19.8 37.5c-4.404 16.49-1.34 32.1-1.695 42.27c-7.857 4.969-23.64 10.38-35.78 22.52c-12.03 12.03-17.59 27.99-22.5 35.75c-9.195 .4141-25.54-2.775-42.28 1.703C212.8 336.2 200.1 347.5 191.1 351.5zM279.1 192c0-48.7-39.39-88-87.1-88S104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192zM192 248C161.1 248 136 222.9 136 192c0-30.88 25.12-56 55.1-56S247.1 161.1 247.1 192C247.1 222.9 222.9 248 192 248zM357.4 370.1c-3.25-8.219-12.58-12.2-20.76-8.984c-8.203 3.25-12.23 12.55-8.984 20.77l24.22 61.25l-47.48-6.562l-24.64 42.28l-24.92-61.2c-3.328-8.203-12.72-12.14-20.84-8.781c-8.188 3.328-12.12 12.66-8.781 20.84l24.9 61.19C255.2 503.4 266.6 511.4 281.4 512c12.83 0 24.38-7.125 30.12-18.59l10.42-20.64l21.51 4.312c12.12 2.547 24.69-1.906 32.67-11.5c7.953-9.547 10.03-22.66 5.453-34.22L357.4 370.1zM150 408.9c-8.139-3.375-17.53 .5938-20.84 8.781l-24.92 61.2l-24.64-42.28l-47.44 6.547l24.17-61.23c3.25-8.219-.7813-17.52-8.984-20.77C39.14 357.9 29.86 361.9 26.61 370.1l-24.22 61.25c-4.578 11.56-2.5 24.67 5.453 34.22c8.016 9.625 20.52 14 32.61 11.52l21.58-4.328l10.41 20.62c5.766 11.45 17.27 18.58 31.42 18.58c13.42-.5313 24.98-8.609 30.03-21.05l24.92-61.2C162.2 421.5 158.2 412.2 150 408.9z"],
    "award-simple": [384, 512, [], "e0ab", "M192 104C143.4 104 104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192C279.1 143.3 240.6 104 192 104zM192 248C161.1 248 136 222.9 136 192c0-30.88 25.12-56 55.1-56S247.1 161.1 247.1 192C247.1 222.9 222.9 248 192 248zM384 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.608-36.5-4.369-50.29c-8.086-13.98-30.03-17.52-41.37-28.87c-11.35-11.35-14.88-33.29-28.87-41.39c-13.76-7.963-34.62-.1888-50.29-4.378C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34C130.5 25.54 109.7 17.74 95.98 25.71C81.1 33.79 78.46 55.74 67.11 67.08C55.77 78.43 33.82 81.96 25.73 95.95C17.74 109.7 25.55 130.5 21.35 146.2C17.27 161.5 0 175.5 0 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.612 36.5 4.365 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.88 33.29 28.86 41.39c13.74 7.951 34.62 .1803 50.29 4.38C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34c15.72-4.207 36.5 3.603 50.29-4.368c13.98-8.088 17.52-30.03 28.87-41.38c11.35-11.35 33.29-14.88 41.39-28.86c7.981-13.79 .1698-34.54 4.377-50.29C366.7 222.5 384 208.5 384 192zM331.7 229.5c-4.404 16.49-1.34 32.1-1.695 42.27c-7.858 4.969-23.64 10.38-35.78 22.52c-12.03 12.03-17.59 27.99-22.5 35.75c-9.195 .4141-25.54-2.775-42.28 1.703c-16.71 4.467-29.4 15.76-37.48 19.79c-8.029-4.002-20.8-15.34-37.48-19.79c-16.71-4.477-33.04-1.301-42.29-1.717C107.3 322.2 101.8 306.4 89.71 294.3C77.6 282.1 61.86 276.8 53.94 271.7C53.59 262.5 56.7 246.1 52.25 229.5c-4.465-16.71-15.77-29.39-19.8-37.48c3.996-8.025 15.33-20.77 19.8-37.5c4.434-16.6 1.33-32.88 1.697-42.27c7.854-4.971 23.64-10.37 35.78-22.52C101.8 77.68 107.3 61.72 112.2 53.95c9.194-.377 25.64 2.738 42.28-1.701c16.74-4.475 29.33-15.74 37.48-19.79c8.027 3.992 20.77 15.33 37.49 19.8c16.74 4.471 33.01 1.295 42.28 1.711c4.84 7.65 10.45 23.71 22.51 35.76c12.03 12.04 28 17.61 35.77 22.52c.3555 9.273-2.752 25.64 1.693 42.28c4.469 16.71 15.77 29.38 19.79 37.47C347.6 200 336.2 212.8 331.7 229.5zM303.7 399.7c-1.813-8.656-10.16-14.23-18.94-12.39c-8.625 1.797-14.19 10.27-12.38 18.92l17.47 73.84l-90.66-45.33c-4.5-2.25-9.813-2.25-14.31 0l-88.88 46.72l15.69-75.23c1.813-8.656-3.75-17.12-12.38-18.92c-8.688-1.844-17.16 3.734-18.94 12.39l-15.69 75.25c-2.438 11.64 1.938 23.38 11.34 30.62c9.438 7.234 21.84 8.438 32.5 3.125L192 466.1l83.5 41.75C279.9 510.9 284.6 512 289.3 512c6.625 0 13.16-2.172 18.69-6.406c9.406-7.25 13.78-18.98 11.34-30.64L303.7 399.7z"],
    "axe": [640, 512, [129683], "f6b2", "M65.1 480L32 446L255 223L232.4 200.4l-223 223c-12.5 12.5-12.5 32.88 0 45.38l33.88 33.88C49.5 508.9 57.75 512 65.1 512c8.125 0 16.38-3.125 22.63-9.375l223-223L289 257L65.1 480zM525.7 160L478.5 112.8l24.12-24.12c12.5-12.5 12.5-32.88 0-45.38l-33.88-33.88C462.5 3.125 454.3 0 445.1 0c-8.125 0-16.37 3.125-22.62 9.375L399.3 33.5l-24.13-24.12c-6.25-6.25-14.5-9.375-22.63-9.375c-8.25 0-16.38 3.125-22.63 9.375L233.4 105.9C220.9 118.4 220.9 138.6 233.4 151.1l150.6 150.6L384 416l31.1-.0032C539.7 416 640 315.8 640 192V160L525.7 160zM445.1 32L480 66l-24.12 24.12l-34-34L445.1 32zM416 384V288.5l-160-160L352.5 32l160 160H608C608 297.9 521.9 384 416 384z"],
    "axe-battle": [512, 512, [], "f6b3", "M101 13.61C99.03 5.105 92.19 0 85.06 0C81.31 0 77.38 1.479 74.25 4.729C28.63 50.85 0 117.6 0 192s28.62 141.1 74.25 187.3C77.38 382.5 81.31 384 85.06 384c7.125 0 13.97-5.105 15.97-13.61C114.4 314.8 156.3 272.9 208 265.5V233.3C117.1 246.1 85.63 318.5 78.63 335.5C48.75 295.9 32 244.9 32 192s16.75-103.9 46.63-143.5C85.63 65.5 117.1 137.9 208 150.8V118.5C156.3 111.1 114.4 69.23 101 13.61zM512 160.9c-6.75-61.75-35.13-116.6-74.25-156.1C434.6 1.5 430.8 0 427 0c-7.125 0-14 5.125-16 13.62C397.6 69.25 355.8 111.1 304 118.5v32.25c90.88-12.88 122.4-85.25 129.4-102.3c21.75 28.88 36.62 63.75 43 101.4L435.4 192l41 42.13c-6.375 37.63-21.25 72.5-43 101.5C426.4 318.5 394.9 246.1 304 233.3V265.5c51.75 7.375 93.63 49.25 107 104.9c2 8.5 8.727 13.63 15.85 13.63c3.75 0 7.773-1.502 10.9-4.752C476.9 339.8 505.3 284.9 512 223.1L480 192L512 160.9zM256 32c-8.836 0-16 7.161-16 15.1v448C240 504.8 247.2 512 256 512s16-7.164 16-15.1V48C272 39.16 264.8 32 256 32z"],
    "b": [320, 512, [98], "42", "M241.9 234.1C269.7 213.7 288 181.1 288 144C288 82.25 237.8 32 176 32h-160C7.156 32 0 39.16 0 48v416C0 472.8 7.156 480 16 480l176 .0098c70.58 0 128-57.42 128-128C320 299.1 287.7 253.6 241.9 234.1zM32 64h144C220.1 64 256 99.89 256 144S220.1 224 176 224H32V64zM192 448H32V256h160c52.94 0 96 43.06 96 96S244.9 448 192 448z"],
    "baby": [448, 512, [], "f77c", "M406.2 160.2c-17.5-25.25-52.13-32-77.88-14.5l-36.38 25c-32.88 22.66-87.05 33.63-135.8 0l-36.38-25c-25.75-17.5-60.38-10.75-77.88 14.5c-17.5 25.5-11 60.5 14.5 78l36.38 24.88c10.88 7.5 22.75 14.12 35.38 19.75v22.62l-54.25 56.25c-19.25 17.75-23.5 46.38-10 69.25l38.25 56.13C112.3 502.5 129.9 512 148.7 512c10 0 19.78-2.75 28.4-7.75c13-7.75 52.25-40.5 2-96.5l18.38-11.62c17.5 6.072 40.47 4.379 53.09 0l18.38 11.62c-50.25 56-11 88.75 2 96.5C279.5 509.3 289.3 512 299.3 512c18.75 0 36.33-9.5 46.58-24.88l38.25-56.13c13.5-22.88 9.25-51.5-10-69.25l-54.25-56.25V282.9c12.63-5.625 24.5-12.25 35.38-19.75l36.38-24.88C417.2 220.7 423.7 185.7 406.2 160.2zM169.3 443.7c6.625 11.5 2.875 26.13-8.5 33c-10.77 6.254-25.8 3.496-33-8.5l-36.5-53.5c-6-10.12-3.75-23.25 5.5-30.75l38.75-41.25c.75 .875 27.55 28.51 36.88 37.88l-29.38 27.62L169.3 443.7zM252 358.6c-13.07 13.07-43.34 12.75-56.09 0l-35.88-35.88V303.1h127.8v18.75L252 358.6zM351.2 383.1c9.25 7.5 11.5 20.62 5.5 30.75l-36.5 53.5c-7.262 12.1-22.32 14.7-33 8.5c-11.38-6.875-15.13-21.5-8.5-33l26.25-35.5l-29.38-27.62c9.328-9.361 36.13-37 36.88-37.88L351.2 383.1zM373.5 211.7l-36.38 25c-12.48 8.521-25.78 15.4-39.57 20.83c-5.889 2.318-9.678 8.094-9.678 14.42H160.1c0-6.33-3.789-12.11-9.68-14.42c-13.79-5.43-27.09-12.3-39.57-20.83l-36.38-25c-26.38-18.12 1.25-57.25 27.25-39.5l36.25 24.88c1.762 1.207 83.97 60.38 172.1 0l36.25-24.88C372.3 154.5 399.9 193.6 373.5 211.7zM224 159.1c44.21-.043 79.99-35.78 79.99-79.1c0-44.22-35.78-79.96-79.99-79.1C179.8 .043 144 35.77 144 79.1C144 124.2 179.8 159.1 224 159.1zM224 32c26.46 .043 47.92 21.52 47.92 47.99c0 26.47-21.46 47.95-47.92 47.99C197.5 127.9 176.1 106.5 176.1 79.99C176.1 53.52 197.5 32.04 224 32z"],
    "baby-carriage": [512, 512, ["carriage-baby"], "f77d", "M.6624 223.1C.4243 221.1 .2502 218.3 .1405 215.4C.0467 212.9 0 210.5 0 208V192H.1405C2.742 117.9 41.34 52.95 98.99 14.1C112.2 5.175 129.8 9.784 138.9 22.92L256 192L416 192V144C416 117.5 437.5 96 464 96H496C504.8 96 512 103.2 512 112C512 120.8 504.8 128 496 128H464C455.2 128 448 135.2 448 144V216H447.8C447.7 218.7 447.6 221.3 447.3 224C445.5 246.2 439.8 268 430.5 288.5C419.1 313.1 402.3 336.9 381.4 356C360.5 375.2 335.8 390.3 308.8 400.5C281.9 410.8 253 416 224 416C194.1 416 166.1 410.8 139.2 400.5C112.2 390.3 87.52 375.2 66.61 356C45.7 336.9 28.94 313.1 17.45 288.5C8.178 268 2.506 246.2 .6627 223.1H.6624zM217.1 192L113.7 42.8C66.27 76.16 34.68 130.4 32.16 192H217.1zM46.61 275.4C56.26 296.7 70.41 316.1 88.24 332.5C106.1 348.8 127.2 361.8 150.5 370.6C173.8 379.4 198.8 384 223.1 384C249.2 384 274.2 379.4 297.5 370.6C320.8 361.8 341.9 348.8 359.8 332.5C377.6 316.1 391.7 296.7 401.4 275.4C408.8 258.9 413.4 241.6 415.2 224H256C255.9 224 255.9 224 255.8 224H32.79C34.55 241.6 39.2 258.9 46.62 275.4H46.61zM31.1 464C31.1 437.5 53.49 416 79.1 416C106.5 416 127.1 437.5 127.1 464C127.1 490.5 106.5 512 79.1 512C53.49 512 31.1 490.5 31.1 464zM79.1 480C88.84 480 95.1 472.8 95.1 464C95.1 455.2 88.84 448 79.1 448C71.16 448 63.1 455.2 63.1 464C63.1 472.8 71.16 480 79.1 480zM416 464C416 490.5 394.5 512 368 512C341.5 512 320 490.5 320 464C320 437.5 341.5 416 368 416C394.5 416 416 437.5 416 464zM368 448C359.2 448 352 455.2 352 464C352 472.8 359.2 480 368 480C376.8 480 384 472.8 384 464C384 455.2 376.8 448 368 448z"],
    "backpack": [448, 512, [127890], "f5d4", "M320 64h-16V48C304 21.5 282.5 0 256 0H192C165.5 0 144 21.5 144 48V64H128C57.25 64 0 121.2 0 192v256c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V192C448 121.2 390.8 64 320 64zM176 48C176 39.12 183.2 32 192 32h64c8.75 0 16 7.125 16 16V64h-96V48zM336 480h-224v-96h224V480zM336 352h-224v-32c0-17.62 14.38-32 32-32h160c17.62 0 32 14.38 32 32V352zM416 448c0 17.62-14.38 32-32 32h-16v-160c0-35.25-28.75-64-64-64h-160c-35.25 0-64 28.75-64 64v160H64c-17.62 0-32-14.38-32-32V192c0-53 43-96 96-96h192c53 0 96 43 96 96V448zM304 160H143.1C135.2 160 128 167.2 128 175.1C128 184.8 135.2 192 143.1 192h160C312.8 192 320 184.8 320 176C320 167.2 312.8 160 304 160z"],
    "backward": [512, 512, [9194], "f04a", "M481.4 64c-6.75 0-13.41 2.344-18.91 6.875l-152.6 125.3c-6.812 5.609-7.812 15.69-2.219 22.52c5.656 6.828 15.75 7.797 22.53 2.203L480 95.59v320.8l-149.8-125.3c-6.781-5.594-16.88-4.625-22.53 2.203c-5.594 6.828-4.594 16.91 2.219 22.52l152.6 125.3C467.1 445.7 474.6 448 481.4 448C497.5 448 512 434.6 512 415.1V96.03C512 77.44 497.5 64 481.4 64zM225.4 64C218.6 64 211.1 66.34 206.5 70.88L11.69 230.8C4.25 236.9 0 246.1 0 256s4.25 19.06 11.69 25.16l194.8 159.1C211.1 445.7 218.6 448 225.4 448c10.35 0 30.6-8.122 30.6-32.03v-319.9C255.1 72.12 235.7 64 225.4 64zM224 416.4L32.52 256L224 95.59V416.4z"],
    "backward-fast": [512, 512, [9198, "fast-backward"], "f049", "M225.4 64C218.6 64 211.1 66.34 206.5 70.88L32 214.2V80C32 71.16 24.84 64 16 64S0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432V297.8l174.5 143.3C211.1 445.7 218.6 448 225.4 448C235.7 448 256 439.9 256 415.1V96.03C256 72.13 235.7 64 225.4 64zM224 416.4L32.52 256L224 95.59V416.4zM481.4 64c-6.75 0-13.41 2.344-18.91 6.875l-152.6 125.3c-6.812 5.609-7.812 15.69-2.219 22.52c5.656 6.828 15.75 7.797 22.53 2.203L480 95.59v320.8l-149.8-125.3c-6.781-5.594-16.88-4.625-22.53 2.203c-5.594 6.828-4.594 16.91 2.219 22.52l152.6 125.3C467.1 445.7 474.6 448 481.4 448C497.5 448 512 434.6 512 415.1V96.03C512 77.44 497.5 64 481.4 64z"],
    "backward-step": [320, 512, ["step-backward"], "f048", "M257.4 64c-6.75 0-13.41 2.344-18.91 6.875L64 214.2V80C64 71.16 56.84 64 48 64S32 71.16 32 80v352C32 440.8 39.16 448 48 448S64 440.8 64 432V297.8l174.5 143.3C243.1 445.7 250.6 448 257.4 448C267.7 448 288 439.9 288 415.1V96.03C288 72.13 267.7 64 257.4 64zM256 416.4L64.52 256L256 95.59V416.4z"],
    "bacon": [576, 512, [129363], "f7e5", "M564.7 99.68l-77.83-86.8C479.4 4.459 469 0 458.5 0c-5.193 0-10.42 1.1-15.34 3.36l-92.75 42.99c-51.13 23.69-93.34 64.03-122.1 116.6L207.7 200.7c-27.11 49.56-66.8 87.5-114.8 109.8l-68.88 31.94c-11.86 5.486-20.28 16.52-23.09 30.23c-2.938 14.35 .9063 29.18 10.31 39.65l77.83 86.8C96.64 507.5 106.1 512 117.5 512c5.188 0 10.41-1.11 15.33-3.375l92.75-42.99c51.13-23.69 93.34-64.03 122.1-116.6l20.66-37.76c27.11-49.56 66.8-87.5 114.8-109.8l68.88-31.94c11.86-5.484 20.28-16.52 23.09-30.23C577.1 124.1 574.1 110.1 564.7 99.68zM35.08 390.9c-5.148-5.736-3.506-16.71 2.441-19.46l68.88-31.95c54.22-25.16 98.95-67.84 129.4-123.4l20.66-37.76c25.47-46.56 62.64-82.15 107.5-102.9l92.64-42.95c.1719-.0781 3.387-1.691 6.514 1.799l30.39 33.89L408.2 107.6c-52.66 24.41-96.13 65.91-125.7 119.1L261.9 265.4C235.6 313.4 197.2 350.2 150.7 371.7l-93.88 43.5L35.08 390.9zM538.5 140.5l-68.88 31.95c-54.22 25.16-98.95 67.84-129.4 123.4l-20.66 37.76c-25.47 46.56-62.64 82.15-107.5 102.9L119.4 479.6c-2.572 1.188-5.051-.2168-6.48-1.812l-33.74-37.62l84.99-39.39c52.7-24.42 96.19-65.92 125.8-120l20.66-37.75c26.28-48.03 64.7-84.8 111.1-106.3l94.08-43.63l25.12 28.02C546.1 126.8 544.4 137.8 538.5 140.5z"],
    "bacteria": [640, 512, [], "e059", "M208 128c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C224 135.2 216.8 128 208 128zM128 200C114.7 200 104 210.7 104 224S114.7 248 128 248c13.25 0 24-10.75 24-24S141.3 200 128 200zM615.7 230.8l11.58-3.425c9.439-2.781 14.81-12.65 12-22.04c-3.041-10.21-13.57-14.52-22.14-11.95l-11.27 3.33c-8.088-15.15-20.68-27.55-36.4-35.43l2.888-11.06c2.469-9.477-3.248-19.15-12.77-21.62c-10.36-2.639-19.46 4.048-21.72 12.71l-2.865 10.97c-1.027-.0371-2.073-.2574-3.096-.2574c-16.64 0-32.32 5.173-45.66 13.89L477.6 157.1c-3.777-3.873-15.44-9.779-25.19-.3691c-7.062 6.822-7.225 18.04-.3711 25.07l9.14 9.373c-5.854 9.221-10.17 19.6-12.08 31.05c-.8887 5.328-2.244 10.49-3.801 15.56L436.2 233.5c-8.855-4.139-19.48-.4082-23.69 8.508c-4.186 8.854-.3599 19.42 8.546 23.58l8.797 4.115c-14.92 22.07-34.42 33.57-34.83 33.83l-3.922-8.855c-3.922-8.822-14.33-13.05-23.49-9.074c-9 3.959-13.08 14.42-9.115 23.39l4.041 9.127c-4.078 1.135-8.14 2.324-12.38 3.031c-12.6 2.098-23.91 7.092-33.76 13.9l-9.996-9.012C299.5 319.7 288.1 319.7 281.3 327.3c-6.611 7.262-6.055 18.47 1.24 25.04l9.713 8.756c-8.49 14.18-12.74 30.77-11.64 48.17l-11.86 3.512c-9.428 2.793-14.8 12.66-11.99 22.05c2.783 9.385 12.69 14.71 22.15 11.94l11.34-3.359c8.287 15.49 20.99 27.86 36.38 35.57l-2.839 10.85c-2.48 9.479 3.224 19.16 12.75 21.62c9.566 2.482 19.25-3.221 21.72-12.69l2.82-10.78c5.508 .1875 11.11-.1523 16.75-1.102c11.37-1.893 22.23-5.074 33.1-8.24l3.379 9.455c3.305 9.223 13.5 14.11 22.75 10.76c9.266-3.277 14.1-13.41 10.81-22.65l-3.498-9.792c15.41-6.654 30.08-14.46 43.95-23.57l6.321 8.429c5.891 7.838 17.05 9.443 24.93 3.602c7.885-5.863 9.496-16.97 3.617-24.82l-6.457-8.611c12.66-10.78 24.33-22.54 34.96-35.33l8.816 6.413c7.932 5.795 19.08 4.076 24.89-3.855c5.811-7.906 4.07-19-3.874-24.77l-8.885-6.465c8.893-13.88 16.54-28.52 22.99-43.91l10.47 3.59c9.334 3.188 19.44-1.719 22.64-10.99c3.213-9.258-1.739-19.35-11.04-22.53l-10.33-3.541c2.791-9.961 5.793-19.84 7.521-30.21C615.9 243.4 616.1 237 615.7 230.8zM583.3 244.5c-18 108-102.7 192.7-210.8 210.8c-2.855 .4805-5.754 .7246-8.617 .7246c-25.04 0-47.03-18.69-51.16-43.48c-2.285-13.7 .9043-27.47 8.977-38.77s20.06-18.78 33.77-21.06c64.21-10.71 114.5-61.04 125.3-125.3c4.195-25.18 25.72-43.46 51.18-43.46c25.96 0 39.44 17.62 42.42 21.79C582.4 217.1 585.6 230.8 583.3 244.5zM416 360c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24c13.25 0 24-10.75 24-24C440 370.7 429.3 360 416 360zM272.3 226.4c9-3.957 13.08-14.42 9.115-23.39L277.4 193.9c4.078-1.135 8.14-2.324 12.38-3.031c12.6-2.098 23.91-7.094 33.76-13.9l9.996 9.012c6.969 6.303 18.28 6.326 25.15-1.236c6.609-7.26 6.053-18.47-1.24-25.04l-9.713-8.756c8.49-14.18 12.74-30.77 11.64-48.18l11.86-3.511c9.428-2.793 14.8-12.66 11.99-22.05c-2.781-9.385-12.69-14.71-22.15-11.94l-11.34 3.357C341.5 53.13 328.8 40.76 313.4 33.05l2.838-10.85c2.482-9.477-3.223-19.16-12.74-21.62C293.9-1.901 284.2 3.801 281.8 13.27l-2.82 10.78C273.4 23.86 267.8 24.2 262.2 25.15C250.8 27.04 239.1 30.22 229.1 33.39L225.7 23.93c-3.305-9.225-13.5-14.11-22.75-10.76c-9.266 3.279-14.1 13.41-10.81 22.65l3.498 9.793C180.2 52.27 165.6 60.07 151.7 69.19L145.4 60.76C139.5 52.92 128.3 51.32 120.5 57.16C112.6 63.02 110.1 74.13 116.8 81.98l6.457 8.611c-12.66 10.78-24.33 22.54-34.96 35.33L79.52 119.5C71.59 113.7 60.44 115.4 54.63 123.4C48.82 131.3 50.56 142.4 58.51 148.1l8.885 6.465C58.5 168.5 50.86 183.1 44.41 198.5L33.93 194.9c-9.334-3.186-19.44 1.721-22.64 10.99C8.086 215.2 13.04 225.3 22.34 228.4l10.33 3.541C29.88 241.9 26.88 251.8 25.15 262.2C24.07 268.6 23.94 274.1 24.33 281.2L12.75 284.7C3.309 287.4-2.061 297.3 .7441 306.7c3.041 10.21 13.57 14.52 22.14 11.95l11.27-3.33c8.086 15.15 20.68 27.55 36.39 35.43l-2.887 11.06c-1.865 7.158 1.902 22.19 17.26 22.19c7.92 0 15.14-5.287 17.23-13.28l2.863-10.97c1.027 .0371 2.074 .2577 3.098 .2577c16.64 0 32.32-5.174 45.66-13.89l8.59 8.809c3.777 3.873 15.44 9.779 25.19 .3691c7.062-6.822 7.225-18.04 .3711-25.07l-9.14-9.373C184.6 311.6 188.9 301.3 190.9 289.8c.8887-5.332 2.244-10.5 3.801-15.56L203.8 278.5C212.6 282.6 223.2 278.9 227.4 269.1C231.6 261.1 227.8 250.6 218.9 246.4L210.1 242.3C225 220.2 244.5 208.7 244.9 208.5l3.922 8.856C252.8 226.2 263.3 230.3 272.3 226.4zM159.3 284.5c-4.193 25.19-25.72 43.46-51.18 43.46c-2.875 0-5.773-.2422-8.656-.7266c-13.7-2.279-25.69-9.758-33.76-21.06S54.43 281.2 56.71 267.5c18-108 102.7-192.7 210.8-210.7c42.96-7.229 58.13 32.87 59.78 42.75c2.283 13.7-.9043 27.47-8.977 38.77s-20.06 18.78-33.77 21.06C220.3 169.1 169.1 220.3 159.3 284.5z"],
    "bacterium": [576, 512, [], "e05a", "M544 100.3c-2.299-7.684-10.94-13.66-20.29-10.86l-22.39 6.625c-18.12-39.6-54.76-53.83-55.48-54.16l5.707-21.75C454.3 9.85 446.4 0 435.8 0c-7.27-.002-13.83 4.824-15.73 12.06l-5.557 21.27c-3.264-.3477-8.205-1.344-15.68-1.344c-4.568 0-10.08 .373-16.74 1.49c-16.67 2.773-32.86 6.854-48.72 11.67l-6.332-17.71c-3.062-8.504-12.45-12.84-20.75-9.809c-8.678 3.066-12.88 12.34-9.934 20.63l6.312 17.6C276.4 66.32 251.7 79.58 228.7 95.24L217.5 80.31C212.1 73.18 201.9 71.71 194.7 77.04c-7.273 5.369-8.58 15.5-3.295 22.57L202.6 114.6C180.9 132.2 161.3 152.2 143.9 174.1L128.5 162.9c-7.217-5.281-17.45-3.764-22.78 3.516C100.4 173.6 101.1 183.7 109.2 188.9l15.57 11.31C109.5 223.3 96.62 248 86.48 274.2L67.82 267.8C56.22 263.9 48.83 272.9 47.11 277.8c-2.908 8.404 1.539 17.56 10.08 20.5L76.11 304.8c-4.275 14.6-8.013 29.46-10.56 44.73c-2.016 12.07-1.476 23.87 .292 35.34l-22.21 6.566c-8.699 2.541-13.49 11.57-10.97 20.04c2.734 9.152 12.75 13.11 20.24 10.9l22.07-6.512c11.32 23.78 30.98 43.01 55.73 54.02l-5.752 21.92C122.2 502.3 130.4 512 140.5 512c7.201 0 14.11-4.916 16-12.06l5.527-21.12c4.791 .6152 9.479 1.193 14.21 1.193c23.07 0 44.85-7.467 63.08-19.93l14.1 14.45c3.426 3.514 14.51 8.586 23.05 .3242c6.441-6.199 6.602-16.41 .3242-22.81l-13.45-13.79c11.77-14.54 20.19-32.11 23.49-51.86c1.475-8.83 3.736-17.37 6.574-25.64l14.66 6.852c7.887 3.691 17.98 .0352 21.68-7.758c3.777-7.945 .3945-17.62-7.816-21.46l-14.67-6.855c14.55-24.65 35.3-45.05 60.4-58.95l6.613 14.95c3.521 7.869 13.35 11.71 21.53 8.26c8.316-3.695 11.87-13.25 8.301-21.29l-6.535-14.73c6.965-2.17 14.04-4.1 21.39-5.322c21.3-3.541 39.96-13.12 55.1-26.35l14.95 13.46c6.736 6.082 17.51 4.953 23.02-1.113c6.031-6.619 5.523-16.77-1.131-22.78l-15.83-14.26c13.91-22.06 20.46-48.82 16.17-76.54l21.85-6.455C541.7 117.9 546.6 108.1 544 100.3zM413.7 222.9c-80.29 13.36-145.1 78.13-158.5 158.3c-8.223 49.3-61.6 81.74-111.5 59.57c-17.58-7.82-31.73-21.5-39.83-38.52c-32.75-68.82 61.06-300.1 283.5-337.1c10.5-1.762 62.82-3.686 84.81 44.37C506.1 183.4 435.9 219.2 413.7 222.9zM192 272c-26.55 0-48.01 21.49-48.01 48s21.47 48 48.01 48s48.01-21.49 48.01-48S218.6 272 192 272zM192.2 336c-8.834 0-16.02-7.178-16.02-16S183.4 304 192.2 304S208.2 311.2 208.2 320S201.1 336 192.2 336zM272.3 184c-13.27 0-24.26 10.75-24.26 24S259.1 232 272.3 232c13.28 0 24.04-10.75 24.04-24S285.6 184 272.3 184z"],
    "badge": [512, 512, [], "f335", "M168.9 45.63C187.1 18.08 219.9 0 256 0C292.1 0 324 18.08 343.1 45.63C376.1 39.67 411.5 49.43 437 74.98C462.6 100.5 472.3 135.9 466.4 168.9C493.9 187.1 512 219.9 512 256C512 292.1 493.9 324 466.4 343.1C472.3 376.1 462.6 411.5 437 437C411.5 462.6 376.1 472.3 343.1 466.4C324 493.9 292.1 512 256 512C219.9 512 187.1 493.9 168.9 466.4C135.9 472.3 100.5 462.6 74.98 437C49.43 411.5 39.67 376.1 45.63 343.1C18.08 324 0 292.1 0 256C0 219.9 18.08 187.1 45.63 168.9C39.67 135.9 49.43 100.5 74.98 74.98C100.5 49.43 135.9 39.67 168.9 45.63L168.9 45.63zM256 32C227.7 32 203 47.93 190.6 71.4L184.4 83.08L171.7 79.2C146.3 71.4 117.6 77.57 97.61 97.61C77.57 117.6 71.4 146.3 79.2 171.7L83.08 184.4L71.4 190.6C47.93 203 32 227.7 32 255.1C32 284.3 47.93 308.1 71.4 321.4L83.08 327.6L79.2 340.3C71.4 365.7 77.57 394.4 97.61 414.4C117.6 434.4 146.3 440.6 171.7 432.8L184.4 428.9L190.6 440.6C203 464.1 227.7 480 256 480C284.3 480 308.1 464.1 321.4 440.6L327.6 428.9L340.3 432.8C365.7 440.6 394.3 434.4 414.4 414.4C434.4 394.4 440.6 365.7 432.8 340.3L428.9 327.6L440.6 321.4C464.1 308.1 480 284.3 480 255.1C480 227.7 464.1 203 440.6 190.6L428.9 184.4L432.8 171.7C440.6 146.3 434.4 117.6 414.4 97.61C394.4 77.56 365.7 71.4 340.3 79.2L327.6 83.08L321.4 71.4C308.1 47.93 284.3 31.1 256 31.1V32z"],
    "badge-check": [512, 512, [], "f336", "M235.3 331.3C229.1 337.6 218.9 337.6 212.7 331.3L156.7 275.3C150.4 269.1 150.4 258.9 156.7 252.7C162.9 246.4 173.1 246.4 179.3 252.7L224 297.4L324.7 196.7C330.9 190.4 341.1 190.4 347.3 196.7C353.6 202.9 353.6 213.1 347.3 219.3L235.3 331.3zM343.1 45.63C376.1 39.67 411.5 49.43 437 74.98C462.6 100.5 472.3 135.9 466.4 168.9C493.9 187.1 512 219.9 512 255.1C512 292.1 493.9 324 466.4 343.1C472.3 376.1 462.6 411.5 437 437C411.5 462.6 376.1 472.3 343.1 466.4C324 493.9 292.1 512 256 512C219.9 512 187.1 493.9 168.9 466.4C135.9 472.3 100.5 462.6 74.98 437C49.43 411.5 39.67 376.1 45.63 343.1C18.08 324 0 292.1 0 255.1C0 219.9 18.08 187.1 45.63 168.9C39.67 135.9 49.43 100.5 74.98 74.98C100.5 49.43 135.9 39.67 168.9 45.63C187.1 18.08 219.9 0 255.1 0C292.1 0 324 18.08 343.1 45.63L343.1 45.63zM184.4 83.08L171.7 79.2C146.3 71.4 117.6 77.57 97.61 97.61C77.57 117.6 71.4 146.3 79.2 171.7L83.08 184.4L71.4 190.6C47.93 203 32 227.7 32 255.1C32 284.3 47.93 308.1 71.4 321.4L83.08 327.6L79.2 340.3C71.4 365.7 77.57 394.3 97.61 414.4C117.6 434.4 146.3 440.6 171.7 432.8L184.4 428.9L190.6 440.6C203 464.1 227.7 480 256 480C284.3 480 308.1 464.1 321.4 440.6L327.6 428.9L340.3 432.8C365.7 440.6 394.3 434.4 414.4 414.4C434.4 394.3 440.6 365.7 432.8 340.3L428.9 327.6L440.6 321.4C464.1 308.1 480 284.3 480 255.1C480 227.7 464.1 203 440.6 190.6L428.9 184.4L432.8 171.7C440.6 146.3 434.4 117.6 414.4 97.6C394.4 77.56 365.7 71.4 340.3 79.2L327.6 83.08L321.4 71.4C308.1 47.93 284.3 31.1 256 31.1C227.7 31.1 203 47.93 190.6 71.4L184.4 83.08z"],
    "badge-dollar": [512, 512, [], "f645", "M272.9 161.5L272.1 161.6C278.4 162.4 294.9 165.6 301 167.2C309.5 169.5 314.6 178.2 312.4 186.8C310.1 195.3 301.3 200.4 292.8 198.1C288.2 196.9 272.9 193.9 268 193.2C253.5 190.9 241.1 192.7 232.7 196.5C224.3 200.3 220.8 205.4 220 210.1C219.2 214.9 219.9 217.7 220.7 219.4C221.6 221.3 223.3 223.4 226.8 225.8C234.6 231.1 246.4 234.7 261.7 239.4L262.2 239.5C275.1 243.6 293.1 248.8 305.7 257.1C312.5 262.9 318.6 269.4 322.4 278.2C326.3 287 327.1 296.8 325.3 307.3C322.1 326.1 309.7 338.9 293.8 345.7C287.4 348.5 280.3 350.3 272.9 351.2V362.7C272.9 371.5 265.7 378.7 256.9 378.7C248.1 378.7 240.9 371.5 240.9 362.7V350.5L240.8 350.4L240.7 350.4C230.5 348.8 214 343.1 203.7 339.6C201.7 338.9 199.9 338.3 198.5 337.8C190.1 335.1 185.6 325.1 188.4 317.6C191.2 309.2 200.2 304.7 208.6 307.5C210.7 308.2 212.1 308.1 215.4 309.8C225.9 313.4 238.6 317.7 245.8 318.8C260.8 321.2 273 319.8 281.2 316.3C288.9 313 292.7 308.2 293.8 301.9C294.7 296.4 294 293.1 293.1 290.9C292.1 288.7 290.3 286.4 286.9 283.9C279.3 278.4 267.7 274.6 252.5 269.1L250.3 269.3C237 265.3 220.9 260.5 208.9 252.3C202.1 247.7 195.8 241.6 191.8 233.1C187.7 224.5 186.7 214.9 188.5 204.7C191.5 186.9 204.2 174.3 219.5 167.4C226 164.4 233.2 162.4 240.9 161.2V149.3C240.9 140.5 248.1 133.3 256.9 133.3C265.7 133.3 272.9 140.5 272.9 149.3L272.9 161.5zM343.1 45.63C376.1 39.67 411.5 49.43 437 74.98C462.6 100.5 472.3 135.9 466.4 168.9C493.9 187.1 512 219.9 512 255.1C512 292.1 493.9 324 466.4 343.1C472.3 376.1 462.6 411.5 437 437C411.5 462.6 376.1 472.3 343.1 466.4C324 493.9 292.1 512 256 512C219.9 512 187.1 493.9 168.9 466.4C135.9 472.3 100.5 462.6 74.98 437C49.43 411.5 39.67 376.1 45.63 343.1C18.08 324 0 292.1 0 255.1C0 219.9 18.08 187.1 45.63 168.9C39.67 135.9 49.43 100.5 74.98 74.98C100.5 49.43 135.9 39.67 168.9 45.63C187.1 18.08 219.9 0 255.1 0C292.1 0 324 18.08 343.1 45.63L343.1 45.63zM184.4 83.08L171.7 79.2C146.3 71.4 117.6 77.57 97.61 97.61C77.57 117.6 71.4 146.3 79.2 171.7L83.08 184.4L71.4 190.6C47.93 203 32 227.7 32 255.1C32 284.3 47.93 308.1 71.4 321.4L83.08 327.6L79.2 340.3C71.4 365.7 77.57 394.3 97.61 414.4C117.6 434.4 146.3 440.6 171.7 432.8L184.4 428.9L190.6 440.6C203 464.1 227.7 480 256 480C284.3 480 308.1 464.1 321.4 440.6L327.6 428.9L340.3 432.8C365.7 440.6 394.3 434.4 414.4 414.4C434.4 394.3 440.6 365.7 432.8 340.3L428.9 327.6L440.6 321.4C464.1 308.1 480 284.3 480 255.1C480 227.7 464.1 203 440.6 190.6L428.9 184.4L432.8 171.7C440.6 146.3 434.4 117.6 414.4 97.6C394.4 77.56 365.7 71.4 340.3 79.2L327.6 83.08L321.4 71.4C308.1 47.93 284.3 31.1 256 31.1C227.7 31.1 203 47.93 190.6 71.4L184.4 83.08z"],
    "badge-percent": [512, 512, [], "f646", "M347.3 164.7C353.6 170.9 353.6 181.1 347.3 187.3L187.3 347.3C181.1 353.6 170.9 353.6 164.7 347.3C158.4 341.1 158.4 330.9 164.7 324.7L324.7 164.7C330.9 158.4 341.1 158.4 347.3 164.7zM168 191.1C168 178.7 178.7 167.1 192 167.1C205.3 167.1 216 178.7 216 191.1C216 205.3 205.3 215.1 192 215.1C178.7 215.1 168 205.3 168 191.1zM296 319.1C296 306.7 306.7 295.1 320 295.1C333.3 295.1 344 306.7 344 319.1C344 333.3 333.3 344 320 344C306.7 344 296 333.3 296 319.1zM343.1 45.63C376.1 39.67 411.5 49.43 437 74.98C462.6 100.5 472.3 135.9 466.4 168.9C493.9 187.1 512 219.9 512 255.1C512 292.1 493.9 324 466.4 343.1C472.3 376.1 462.6 411.5 437 437C411.5 462.6 376.1 472.3 343.1 466.4C324 493.9 292.1 512 256 512C219.9 512 187.1 493.9 168.9 466.4C135.9 472.3 100.5 462.6 74.98 437C49.43 411.5 39.67 376.1 45.63 343.1C18.08 324 0 292.1 0 255.1C0 219.9 18.08 187.1 45.63 168.9C39.67 135.9 49.43 100.5 74.98 74.98C100.5 49.43 135.9 39.67 168.9 45.63C187.1 18.08 219.9 0 255.1 0C292.1 0 324 18.08 343.1 45.63L343.1 45.63zM184.4 83.08L171.7 79.2C146.3 71.4 117.6 77.57 97.61 97.61C77.57 117.6 71.4 146.3 79.2 171.7L83.08 184.4L71.4 190.6C47.93 203 32 227.7 32 255.1C32 284.3 47.93 308.1 71.4 321.4L83.08 327.6L79.2 340.3C71.4 365.7 77.57 394.3 97.61 414.4C117.6 434.4 146.3 440.6 171.7 432.8L184.4 428.9L190.6 440.6C203 464.1 227.7 480 256 480C284.3 480 308.1 464.1 321.4 440.6L327.6 428.9L340.3 432.8C365.7 440.6 394.3 434.4 414.4 414.4C434.4 394.3 440.6 365.7 432.8 340.3L428.9 327.6L440.6 321.4C464.1 308.1 480 284.3 480 255.1C480 227.7 464.1 203 440.6 190.6L428.9 184.4L432.8 171.7C440.6 146.3 434.4 117.6 414.4 97.6C394.4 77.56 365.7 71.4 340.3 79.2L327.6 83.08L321.4 71.4C308.1 47.93 284.3 31.1 256 31.1C227.7 31.1 203 47.93 190.6 71.4L184.4 83.08z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M420.3 283.7c-.748 0-1.5 .0176-2.256 .0488L401.3 256l16.67-27.78c.7559 .0332 1.508 .0488 2.256 .0488c34.11 0 61.87-27.75 61.87-61.87s-27.75-61.87-61.87-61.87c-21.78 0-41.71 11.61-52.76 29.87h-39.13l-22.08-36.79c7.451-10.39 11.56-22.86 11.56-35.74C317.9 27.75 290.1 0 256 0S194.1 27.75 194.1 61.87c0 12.88 4.109 25.35 11.56 35.74L183.6 134.4H144.5C133.4 116.1 113.5 104.5 91.73 104.5c-34.12 0-61.87 27.75-61.87 61.87s27.75 61.87 61.87 61.87c.7461 0 1.498-.0156 2.254-.0488L110.7 256L93.99 283.8C93.23 283.8 92.48 283.7 91.73 283.7c-34.12 0-61.87 27.75-61.87 61.87s27.75 61.87 61.87 61.87c21.78 0 41.71-11.62 52.76-29.87h39.13l22.08 36.79c-7.453 10.39-11.56 22.86-11.56 35.74C194.1 484.2 221.9 512 256 512s61.87-27.75 61.87-61.87c0-12.88-4.107-25.35-11.56-35.74l22.08-36.79h39.13c11.05 18.25 30.98 29.87 52.76 29.87c34.11 0 61.87-27.75 61.87-61.87S454.4 283.7 420.3 283.7zM420.3 375.5c-10.26 0-19.99-5.535-25.38-14.44l-9.34-15.42h-75.28l-42.21 70.36l12.25 17.09c3.639 5.074 5.562 10.98 5.562 17.09C285.9 466.6 272.5 480 256 480s-29.87-13.4-29.87-29.87c0-6.104 1.924-12.01 5.564-17.09l12.25-17.09l-42.22-70.36h-75.28l-9.34 15.43c-5.393 8.908-15.12 14.44-25.38 14.44c-16.47 0-29.87-13.4-29.87-29.87c0-16.46 13.38-29.85 30.77-29.85l19.02 .7793L147.1 256L121.4 211.8L110.8 195.4L91.73 196.3c-16.47 0-29.87-13.4-29.87-29.87c0-16.47 13.4-29.87 29.87-29.87c10.26 0 19.99 5.533 25.38 14.44l9.34 15.43h75.28l42.22-70.36L231.7 78.96C228.1 73.88 226.1 67.97 226.1 61.87C226.1 45.4 239.5 32 256 32s29.87 13.4 29.87 29.87c0 6.105-1.924 12.02-5.562 17.09l-12.25 17.08l42.21 70.36h75.28L394.9 150.1c5.391-8.906 15.12-14.44 25.38-14.44c16.47 0 29.87 13.4 29.87 29.87c0 16.46-13.38 29.85-30.68 29.85l-19.08-.8398L364 256l26.55 44.25l10.72 16.27l18.98-.7793c16.47 0 29.87 13.4 29.87 29.87S436.7 375.5 420.3 375.5zM256 184C216.3 184 184 216.3 184 256s32.3 72 72 72S328 295.7 328 256S295.7 184 256 184zM256 296C233.9 296 216 278.1 216 256c0-22.06 17.94-40 40-40S296 233.9 296 256C296 278.1 278.1 296 256 296z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M622.3 142.5L619.5 140.1c-20.62-11.25-40.59-24.05-59.56-37.9c-59.03-43.12-93.54-39.07-94.44-39.07c-19.12 0-38.13 5.255-55.5 15.26c-17.12 9.75-36 16.75-54.1 16.75H128c-70.69 0-128 57.32-128 128v15.95c0 8.875 7.125 16 16 16h20c2.625 11.25 9.875 46.61 54.13 79.74l-23.75 52.38c-3.125 7.625-3.125 16.13-.125 23.75l25.25 58.01C93.88 476 99.88 480 106.4 480H158.3c23.29 0 38.78-24.08 29.12-45.27l-12.18-26.74l33-56.01h73.63l20.55 102.3C305.4 469.2 318.6 480 333.8 480h46.63c20.19 0 35.33-18.46 31.38-38.26l-23.06-115.8c45.25-30.5 101.2-61.14 152.4-75.64L560 287.1l22.74-45.54C636.1 238.1 640 178.5 640 175.3C640 161.3 633.1 148.7 622.3 142.5zM128 128.1h227c22.75 0 46.63-7.125 70.1-21.12C438.4 99.86 452 96.11 465.5 96.11c3.875 0 26.38-1.627 70.5 29.25c4.875 3.375 10.12 7 15.62 10.75H460c-30.88 0-60.25 9.627-91.5 20.88L267.8 202.9C258.1 206.2 247.9 208.1 237.5 208.1H192c-45.13 0-78.88-41.13-79.88-78.38C117.4 128.9 122.6 128.1 128 128.1zM353.1 311.2l27.38 136.8h-46.75L308.1 319.1H189.9l-50.63 86.13l19 41.88h-41L96 400.2l33.13-75.38L109.3 310.1c-20.12-15.12-34.88-30.62-42-61.38L61.38 224.1H32c0-36 20.12-67 49.38-83.38C88.13 194.9 136.6 240.1 192 240.1l45.47-.0433c14.12 0 28.03-2.399 42.28-7.524L380.5 186.6c27.25-9.752 53.75-18.5 79.5-18.5h20.38C477.8 171.5 476 175.5 476 180.1c0 11 9 20 20 20s20-9 20-20c0-4.625-1.75-8.625-4.375-12h90.88C605.1 170.1 608 170.6 608 174.1C602.8 248.7 586.6 154.2 353.1 311.2z"],
    "badminton": [640, 512, [], "e33a", "M623.2 490.9l-8.979-26.94h-33.75l12.35 37.07c2.25 6.688 8.5 10.94 15.19 10.94c8.98 0 16-7.32 16-16.02C624 494.3 623.7 492.6 623.2 490.9zM511.1 399.1l-.0023 48.03h96l.0027-48.03c0-26.51-21.49-48.01-48-48.01S511.1 373.5 511.1 399.1zM575.1 399.1v16h-32v-16c0-8.822 7.178-16 16-16S575.1 391.2 575.1 399.1zM576 151.4C576 74.02 519.3 0 417.1 0c-92.11 0-225.1 81.34-225.1 217c0 33.22 9.797 64.11 28.62 89.83l-80.06 62.9l-2.926-3.66c-6.209-7.852-15.38-12.07-24.7-12.07c-7.26 0-14.46 2.328-20.27 6.941l-74.56 59.47C6.191 429.9 0 443.9 0 458c0 10.5 3.418 21.07 10.47 29.9l4.75 5.969c15.17 19.03 36.68 18.09 37.66 18.09c10.81 0 21.22-3.625 29.81-10.47l74.56-59.44c.5117-.4082 12.06-8.791 12.06-25.15c0-7.201-2.418-14.13-6.963-19.85l-1.842-2.305l81.77-64.24c42.87 37.45 93.6 38.24 107.7 38.24C445.6 368.8 576 285.3 576 151.4zM62.75 476.5c-2.967 2.363-6.803 3.469-10.34 3.469c-.3223 0-7.146 .2324-12.19-6.031l-4.752-5.969c-2.348-2.945-3.488-6.473-3.488-9.977c0-4.705 2.061-9.369 6.021-12.52l74.56-59.44l24.75 31L62.75 476.5zM350 336.8c-46.95 0-126.1-27.61-126.1-119.6C223.1 94.81 346.7 32 417.1 32h2.062c74.67 .9648 123.1 52.39 123.1 119.6C544 259.8 436.7 336.8 350 336.8zM544 495.1c0 8.844 7.153 16 15.1 16s16-7.159 16-16l-.0029-32h-32L544 495.1zM496.8 490.9c-.5547 1.672-.8185 3.371-.8185 5.043c0 8.688 7.01 16.02 16 16.02c6.688 0 12.94-4.251 15.19-10.94l12.35-37.07h-33.75L496.8 490.9z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M128 128V96C128 42.98 170.1 0 224 0C277 0 320 42.98 320 96V128H400C426.5 128 448 149.5 448 176V416C448 469 405 512 352 512H96C42.98 512 0 469 0 416V176C0 149.5 21.49 128 48 128H128zM160 128H288V96C288 60.65 259.3 32 224 32C188.7 32 160 60.65 160 96V128zM48 160C39.16 160 32 167.2 32 176V416C32 451.3 60.65 480 96 480H352C387.3 480 416 451.3 416 416V176C416 167.2 408.8 160 400 160H320V240C320 248.8 312.8 256 304 256C295.2 256 288 248.8 288 240V160H160V240C160 248.8 152.8 256 144 256C135.2 256 128 248.8 128 240V160H48z"],
    "bagel": [640, 512, [129391], "e3d7", "M465 111.7c7.062 2.203 14.31 2.703 20.72 3.141c6 .4062 12.78 .8594 15.5 2.766c2.656 1.859 5.062 7.531 7.375 13.02c2.438 5.781 5.188 12.34 9.594 18.12c4.344 5.75 9.938 10.2 14.84 14.14c4.594 3.641 9.75 7.781 10.75 10.7c.8438 2.531-.7813 8.797-2.062 13.84C540.1 193.6 538.3 200.5 538.3 208c0 7.438 1.812 14.41 3.406 20.56C543 233.6 544.6 239.9 543.8 242.4c-1 2.984-6.188 7.125-10.78 10.78c-4.906 3.922-10.47 8.359-14.81 14.08c-4.406 5.812-7.156 12.36-9.594 18.14c-2.312 5.5-4.719 11.17-7.344 13.02c-2.75 1.906-9.531 2.375-15.53 2.781c-6.406 .4375-13.69 .9375-20.72 3.141c-8.438 2.641-13.12 11.61-10.5 20.05c2.156 6.844 8.469 11.22 15.28 11.22c1.594 0 3.188-.2344 4.781-.7344c3.406-1.062 8.25-1.391 13.34-1.75c10.12-.6875 21.62-1.469 31.69-8.469c10.22-7.156 14.78-18.06 18.47-26.83c1.875-4.422 3.625-8.609 5.625-11.2c1.906-2.547 5.5-5.406 9.281-8.438c7.625-6.062 17.09-13.62 21.12-25.5c3.906-11.58 .9687-22.97-1.406-32.13C571.5 215.8 570.3 211.4 570.3 208c0-3.391 1.156-7.859 2.375-12.58c2.375-9.156 5.312-20.55 1.406-32.16c-4.031-11.8-13.5-19.34-21.09-25.41c-3.781-3.031-7.375-5.906-9.344-8.484c-1.969-2.594-3.719-6.781-5.594-11.2c-3.688-8.75-8.25-19.66-18.5-26.83c-10.03-7-21.53-7.781-31.66-8.469c-5.094-.3438-9.907-.6719-13.34-1.734c-3.094-.9687-6.969-3.328-11.09-5.828C455.1 70.28 444.8 64 432 64s-23.12 6.281-31.47 11.31c-4.125 2.5-8 4.859-11.06 5.812c-3.438 1.062-8.25 1.391-13.31 1.75c-3.469 .2344-6.906 .4844-10.25 .9219c-8.75 1.156-14.94 9.188-13.78 17.95s9.188 14.81 17.97 13.77c2.688-.3438 5.469-.5313 8.25-.7187c6.375-.4375 13.62-.9375 20.66-3.125c6.781-2.125 12.81-5.766 18.09-8.984C422.5 99.41 428.2 96 432 96s9.469 3.406 14.91 6.688C452.2 105.9 458.2 109.5 465 111.7zM208 224C163.9 224 128 259.9 128 304C128 348.1 163.9 384 208 384S288 348.1 288 304C288 259.9 252.1 224 208 224zM208 352C181.5 352 160 330.5 160 304S181.5 256 208 256S256 277.5 256 304S234.5 352 208 352zM208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304S322.9 96 208 96zM208 480C110.1 480 32 401 32 304S110.1 128 208 128S384 206.1 384 304S305 480 208 480zM432 0c-50.72 0-99.59 18.47-137.6 52C287.8 57.86 287.2 67.97 293 74.59C298.8 81.23 308.9 81.84 315.6 76C347.7 47.63 389.1 32 432 32C529.1 32 608 110.1 608 208c0 90.89-70.84 167.9-161.3 175.4c-8.812 .7344-15.34 8.469-14.62 17.27c.6875 8.359 7.688 14.69 15.91 14.69c.4687 0 .9062-.0156 1.344-.0469C556.3 406.5 640 315.4 640 208C640 93.31 546.7 0 432 0zM144 208C152.8 208 160 200.8 160 192c0-8.838-7.164-16-16-16S128 183.2 128 192C128 200.8 135.2 208 144 208zM80 256C71.16 256 64 263.2 64 272C64 280.8 71.16 288 80 288S96 280.8 96 272C96 263.2 88.84 256 80 256zM240 416C231.2 416 224 423.2 224 432C224 440.8 231.2 448 240 448S256 440.8 256 432C256 423.2 248.8 416 240 416zM304 384C295.2 384 288 391.2 288 400C288 408.8 295.2 416 304 416s16-7.164 16-16C320 391.2 312.8 384 304 384zM320 224C311.2 224 304 231.2 304 240C304 248.8 311.2 256 320 256s16-7.164 16-16C336 231.2 328.8 224 320 224zM112 384C103.2 384 96 391.2 96 400C96 408.8 103.2 416 112 416S128 408.8 128 400C128 391.2 120.8 384 112 384z"],
    "bags-shopping": [576, 512, [128717], "f847", "M128 96C128 42.98 170.1 0 224 0C277 0 320 42.98 320 96V160H384C419.3 160 448 188.7 448 224H416C416 206.3 401.7 192 384 192H64C46.33 192 32 206.3 32 224V416C32 433.7 46.33 448 64 448H160V480H64C28.65 480 0 451.3 0 416V224C0 188.7 28.65 160 64 160H128V96zM160 160H288V96C288 60.65 259.3 32 224 32C188.7 32 160 60.65 160 96V160zM320 352C320 387.3 348.7 416 384 416C419.3 416 448 387.3 448 352V336C448 327.2 455.2 320 464 320C472.8 320 480 327.2 480 336V352C480 405 437 448 384 448C330.1 448 288 405 288 352V336C288 327.2 295.2 320 304 320C312.8 320 320 327.2 320 336V352zM192 320C192 284.7 220.7 256 256 256H512C547.3 256 576 284.7 576 320V448C576 483.3 547.3 512 512 512H256C220.7 512 192 483.3 192 448V320zM256 288C238.3 288 224 302.3 224 320V448C224 465.7 238.3 480 256 480H512C529.7 480 544 465.7 544 448V320C544 302.3 529.7 288 512 288H256z"],
    "baguette": [640, 512, [129366], "e3d8", "M622 49.6c-13.4-20.16-33.4-35.27-56.29-42.54C550.8 2.303 534.7 0 518.2 0c-36.6 0-74.87 11.38-105.9 32.65L80.88 259.7c-44.86 30.74-76.46 83.44-80.53 134.3c-1.979 24.08 4.307 48.37 17.61 68.4c13.4 20.16 33.41 35.27 56.29 42.54C89.24 509.7 105.4 512 121.8 512c36.58 0 74.82-11.41 105.9-32.68l331.4-227.1c44.87-30.74 76.46-83.44 80.53-134.3C641.6 93.92 635.3 69.63 622 49.6zM541 225.9L209.6 452.9C184.5 470.1 152.5 480 121.8 480c-13.52 0-26.27-1.877-37.91-5.582c-15.98-5.074-29.94-15.64-39.31-29.74c-9.371-14.12-13.77-31.2-12.37-48.16c3.273-40.95 30.08-85.33 66.71-110.4l21.66-14.84l60.05 60.05C183.8 334.4 187.9 336 192 336s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L147.5 252.9l87.09-59.66l58.12 58.12C295.8 254.4 299.9 256 304 256s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-53.89-53.89l87.09-59.66l56.18 56.18C407.8 174.4 411.9 176 416 176s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-51.95-51.95l55.02-37.7C455.5 41.86 487.5 32 518.2 32c13.51 0 26.24 1.869 37.85 5.553c15.98 5.074 29.95 15.64 39.31 29.74c9.369 14.12 13.76 31.2 12.37 48.16C604.5 156.4 577.7 200.8 541 225.9z"],
    "bahai": [512, 512, [], "f666", "M511.5 217.2c-2.547-14.44-13.52-25.11-27.94-27.17l-82.93-11.59l31.65-78.91c5.422-13.59 1.5-28.97-9.75-38.28c-11.22-9.25-26.4-10.19-38.67-2.359l-70.61 44.98l-25.67-80.63C283 9.109 270.7 0 255.1 0S228.1 9.109 224.5 23.22L198.8 103.8l-70.65-45c-12.28-7.797-27.48-6.812-38.72 2.5C78.07 70.78 74.28 85.75 79.78 99.53l31.64 78.88L28.48 190C14.11 192.1 3.154 202.7 .5605 217.1c-2.609 14.5 4.031 28.39 17 35.44l74.09 39.73l-56.36 63.17c-8.875 10.02-10.98 23.81-5.5 35.98c5.375 11.97 17.16 19.69 30.02 19.69c2.125 0 4.484-.3125 7.139-.8281L148.7 392.5l-3.109 84.77c-.3906 9.219 2.828 17.88 9.076 24.41c13.31 13.91 37.95 13.09 50.2-2.734l51.19-66.78l51.19 66.64C313.5 507.2 322.1 512 333.2 512c9.062 0 17.86-3.766 24.14-10.33c6.25-6.531 9.467-15.19 9.078-24.28l-3.016-84.89l81.62 17.77c14.25 3.109 28.19-3.078 35.54-15.73c7.344-12.59 5.75-28.33-3.922-39.16l-56.34-63.14l74.09-39.83C507.3 245.5 514 231.7 511.5 217.2zM387.3 273.7c-9.211 4.973-11.16 17.14-4.359 24.75l68.9 80.58l-101.7-22.14c-10.22-2.23-19.78 5.824-19.39 16.2l1.953 106.4l-63.1-83.33c-6.43-8.352-19.01-8.307-25.39 .0156l-65.78 82.41l3.875-105.5c.377-9.986-8.607-18.42-19.39-16.23l-102.8 19.84L129.1 298.4c6.902-7.729 4.717-19.88-4.375-24.75L32.01 224l104.1-16.73c10.3-1.42 16.5-12.21 12.62-21.8l-37.73-99.61l88.14 56.14c8.695 5.58 20.61 1.472 23.84-8.641l34.08-100.4l31.98 100.4c3.254 10.16 15.19 14.19 23.84 8.641l89.67-54.38L363.3 185.5c-3.9 9.65 2.395 20.39 12.62 21.8L479.1 224L387.3 273.7z"],
    "baht-sign": [320, 512, [], "e0ac", "M160 16V64H184C241.4 64 288 110.6 288 168C288 199.3 274.1 227.4 252.2 246.5C291.8 261.2 320 299.3 320 344C320 401.4 273.4 448 216 448H160V496C160 504.8 152.8 512 144 512C135.2 512 128 504.8 128 496V448H41.74C18.69 448 0 429.3 0 406.3V101.6C0 80.82 16.82 64 37.57 64H128V16C128 7.164 135.2 0 144 0C152.8 0 160 7.164 160 16V16zM128 96H37.57C34.49 96 32 98.49 32 101.6V240H128V96zM184 240C223.8 240 256 207.8 256 168C256 128.2 223.8 96 184 96H160V240H184zM128 272H32V406.3C32 411.6 36.36 416 41.74 416H128V272zM216 416C255.8 416 288 383.8 288 344C288 304.2 255.8 272 216 272H160V416H216z"],
    "ball-pile": [576, 512, [], "f77e", "M480 320c-10.41 0-20.3 2.081-29.68 5.174C468.5 307.7 480 283.3 480 256c0-53-43-96-96-96c-10.41 0-20.3 2.081-29.68 5.174C372.6 147.7 384 123.2 384 96c0-53-43-96-96-96S192 43 192 96c0 27.19 11.4 51.67 29.68 69.17C212.3 162.1 202.5 160 192 160C139 160 96 203 96 256c0 27.19 11.4 51.67 29.68 69.17C116.3 322.1 106.5 320 96 320c-53 0-96 43-96 96s43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C171.7 349.9 181.5 352 192 352s20.3-2.081 29.68-5.174C203.4 364.3 192 388.8 192 416c0 53 43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C363.7 349.9 373.5 352 384 352s20.3-2.081 29.68-5.174C395.4 364.3 384 388.8 384 416c0 53 43 96 96 96s96-43 96-96S533 320 480 320zM288 32c35.31 0 64 28.69 64 64s-28.69 64-64 64S224 131.3 224 96S252.7 32 288 32zM317.7 325.2C308.3 322.1 298.4 320 288 320s-20.3 2.081-29.68 5.174C276.5 307.7 288 283.3 288 256S276.6 204.3 258.3 186.8C267.7 189.9 277.5 192 288 192s20.3-2.081 29.68-5.174C299.4 204.3 288 228.8 288 256S299.4 307.7 317.7 325.2zM96 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S131.3 480 96 480zM192 320c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S227.3 320 192 320zM288 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S323.3 480 288 480zM384 320c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S419.3 320 384 320zM480 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S515.3 480 480 480z"],
    "balloon": [384, 512, [], "e2e3", "M176 80c-52.94 0-96 43.06-96 96C80 184.8 87.16 192 96 192s16-7.156 16-16c0-35.28 28.72-64 64-64C184.8 112 192 104.8 192 96S184.8 80 176 80zM384 187.4C384 84.09 297.9 0 192 0S0 84.09 0 187.4c0 81.31 98.06 189.1 157.2 228.8l-42.9 71.49c-2.969 4.938-3.031 11.09-.2187 16.09C116.9 508.9 122.3 512 128 512h128c5.75 0 11.09-3.094 13.94-8.125c2.812-5 2.75-11.16-.2187-16.09l-42.9-71.49C285.9 376.5 384 268.7 384 187.4zM227.8 480h-71.5l28.8-48h13.9L227.8 480zM192.6 400C169.7 396.2 32 272.9 32 187.4C32 101.7 103.8 32 192 32s160 69.72 160 155.4C352 272.9 214.4 396.2 192.6 400z"],
    "balloons": [640, 512, [], "e2e4", "M160 80C115.9 80 80 115.9 80 160c0 8.844 7.156 16 16 16S112 168.8 112 160c0-26.47 21.53-48 48-48c8.844 0 16-7.156 16-16S168.8 80 160 80zM160 0C71.78 0 0 74.84 0 166.8c0 69.53 76.04 164.7 126.8 201.5l-35.69 54.92c-3.219 4.906-3.469 11.19-.6562 16.34S98.66 448 104.5 448h110.9c5.875 0 11.25-3.219 14.06-8.375s2.562-11.44-.6562-16.34l-35.69-54.92C243.1 331.5 320 236.4 320 166.8C320 74.84 248.2 0 160 0zM133.1 416l20.8-32h10.4l20.8 32H133.1zM161.4 352H161C139.3 346.2 32 239.5 32 166.8C32 92.5 89.41 32 160 32s128 60.5 128 134.8C288 239.5 180.7 346.2 161.4 352zM432 224c0-26.47 21.53-48 48-48c8.844 0 16-7.156 16-16S488.8 144 480 144c-44.13 0-80 35.88-80 80c0 8.844 7.156 16 16 16S432 232.8 432 224zM640 230.8C640 138.8 568.2 64 480 64c-39.56 0-77.53 15.19-106.9 42.72c-6.438 6.062-6.781 16.19-.75 22.62c6.094 6.531 16.19 6.75 22.62 .75C418.4 108.1 448.6 96 480 96c70.59 0 128 60.5 128 134.8C608 303.4 500.9 410 481.5 416h-.5098c-14.75-3.977-84.6-66.21-115.9-134.7c-3.688-8.062-13.28-11.5-21.22-7.906C335.9 277.1 332.3 286.6 336 294.7c23.8 52.07 74.26 109.1 111.1 137.3l-35.94 55.3c-3.219 4.906-3.469 11.19-.6562 16.34S418.7 512 424.5 512h110.9c5.875 0 11.25-3.219 14.06-8.375s2.562-11.44-.6562-16.34l-35.69-54.92C563.1 395.5 640 300.4 640 230.8zM453.1 480l20.8-32h10.4l20.8 32H453.1z"],
    "ballot": [448, 512, [], "f732", "M96 232C82.75 232 72 242.7 72 256c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 242.7 109.3 232 96 232zM96 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 370.7 109.3 360 96 360zM96 104C82.75 104 72 114.7 72 128c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 114.7 109.3 104 96 104zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V448zM352 368H176C167.2 368 160 375.2 160 384s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 368 352 368zM352 112H176C167.2 112 160 119.2 160 128s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 112 352 112zM352 240H176C167.2 240 160 247.2 160 256s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 240 352 240z"],
    "ballot-check": [448, 512, [], "f733", "M96 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 370.7 109.3 360 96 360zM352 368H176C167.2 368 160 375.2 160 384s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 368 352 368zM101.3 288c4.094 0 8.188-1.562 11.31-4.688l58.67-58.67c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L101.3 249.4L83.31 231.4c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l29.33 29.33C93.14 286.4 97.23 288 101.3 288zM96 152c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C82.75 104 72 114.7 72 128C72 141.3 82.75 152 96 152zM352 240H208C199.2 240 192 247.2 192 256s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 240 352 240zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V448zM352 112H176C167.2 112 160 119.2 160 128s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 112 352 112z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM86.7 109.3C52.62 148.6 32 199.9 32 256C32 379.7 132.3 480 256 480C312.1 480 363.4 459.4 402.7 425.3L86.7 109.3zM480 256C480 132.3 379.7 32 256 32C199.9 32 148.6 52.62 109.3 86.7L425.3 402.7C459.4 363.4 480 312.1 480 255.1V256z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M175.1 265.9V243.9L207.1 275.9V279.7C208 279.9 208 280.1 207.1 280.3V303.1C207.1 330.5 229.5 352 255.1 352C264.1 352 271.8 349.1 278.5 346.4L301.8 369.6C288.8 378.7 273 384 255.1 384C230.8 384 208.3 372.3 193.6 354.1L152.9 381.3C145.5 386.2 135.6 384.2 130.7 376.9C125.8 369.5 127.8 359.6 135.1 354.7L178.9 325.5C177 318.7 175.1 311.4 175.1 303.1V298.1L129.1 303.9C121.2 304.1 113.2 298.8 112.1 289.1C111 281.2 117.2 273.2 126 272.1L175.1 265.9zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C312.1 480 363.4 459.4 402.7 425.3L86.7 109.3C52.62 148.6 32 199.9 32 256C32 379.7 132.3 480 256 480H256zM335.5 312.9L425.3 402.7C459.4 363.4 480 312.1 480 255.1C480 132.3 379.7 31.1 255.1 31.1C199.9 31.1 148.6 52.62 109.3 86.7L188.2 165.5C202.3 142.1 227.4 127.1 255.1 127.1C281.2 127.1 303.7 139.7 318.3 157.9L359.1 130.7C366.5 125.8 376.4 127.8 381.3 135.1C386.2 142.5 384.2 152.4 376.9 157.3L333.1 186.5C334.1 193.3 335.1 200.6 335.1 207.1V211.5L380.1 200.5C388.7 198.3 397.4 203.5 399.5 212.1C401.7 220.7 396.5 229.4 387.9 231.5L335.1 244.5V265.9L385.1 272.1C394.8 273.2 400.1 281.2 399.9 289.1C398.8 298.8 390.8 304.1 382 303.9L335.1 298.1V303.1C335.1 307 335.8 309.1 335.5 312.9H335.5zM303.1 281.4V207.1C303.1 181.5 282.5 159.1 255.1 159.1C236.2 159.1 219.1 172 211.8 189.2L303.1 281.4z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M176 257.9L238.1 320H208V368C208 376.8 200.8 384 192 384C183.2 384 176 376.8 176 368V257.9zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C312.1 480 363.4 459.4 402.7 425.3L86.7 109.3C52.62 148.6 32 199.9 32 256C32 379.7 132.3 480 256 480H256zM331.1 309.4L425.3 402.7C459.4 363.4 480 312.1 480 255.1C480 132.3 379.7 31.1 256 31.1C199.9 31.1 148.6 52.62 109.3 86.7L176 153.4V151.1C176 138.7 186.7 127.1 200 127.1H288C341 127.1 384 170.1 384 223.1C384 261.2 362.9 293.4 331.1 309.4V309.4zM307.6 284.1C333.3 276.7 352 252.5 352 224C352 188.7 323.3 160 288 160H208V185.4L307.6 284.1z"],
    "ban-smoking": [512, 512, [128685, "smoking-ban"], "f54d", "M256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-56 20.81-107.1 54.91-146.5L201.4 224H128C110.3 224 96 238.3 96 256v32c0 17.66 14.34 32 32 32h169.4l105.1 105.1C363.1 459.2 312 480 256 480zM233.4 256l32 32H128V256H233.4zM425.1 402.5L341.5 318.9C347.6 316.6 352 310.9 352 304C352 295.2 344.8 288 336 288h-25.38l-32-32H336C344.8 256 352 248.8 352 240S344.8 224 336 224H246.6L109.5 86.91C148.9 52.81 199.1 32 256 32c123.5 0 224 100.5 224 224C480 312 459.2 363.1 425.1 402.5zM400 224C391.2 224 384 231.2 384 240v64c0 8.844 7.156 16 16 16S416 312.8 416 304v-64C416 231.2 408.8 224 400 224zM398.9 193.1c8.844 0 16-7.156 16-16c0-35.28-31.44-64-70.06-64h-34.75c-11.41 0-22.16-4.281-29.44-11.78c-5.746-5.902-8.807-13.33-8.592-20.89l.0918-2.795l-.5859-.0195C270.4 70.14 264.3 64.22 256.5 64h-.4518C247.4 64 240.3 70.88 240 79.56c-.4375 16.31 5.844 31.97 17.66 44.09c13.28 13.66 32.38 21.47 52.38 21.47h34.75c21 0 38.06 14.34 38.06 32C382.9 185.1 390 193.1 398.9 193.1z"],
    "banana": [576, 512, [], "e2e5", "M294.3 250.7c0 6.924 5.461 15.93 15.98 15.93c6.325 0 12.32-3.75 14.84-9.933c13.12-32.17 17.34-58.39 18.59-68.4c1.713-13.05 2.567-26.03 2.567-38.91c0-57.82-15.57-86.7-15.57-96.62c0-15.91 15.81-20.93 21.96-20.93c23.52 0 95.3 86.48 95.3 192.5c0 17.94-1.663 27.62-1.663 30.59c0 2.745 2.245 15.94 16.03 15.94c16.44 0 17.64-15.75 17.64-46.62c0-116.7-78.95-224.3-127.5-224.3c-27.97 0-53.75 22.8-53.75 52.9c0 20.25 15.47 39.6 15.47 96.45c0 11.66-.7781 23.45-2.339 35.34C307.6 220.2 294.3 243.5 294.3 250.7zM576 398.5c0-2.57-.6256-5.176-1.944-7.593l-23.28-42.77c-19.29-35.48-54.23-55.88-90.83-55.88c-12.37 0-24.93 2.329-37.14 7.192l-81.59 32.45L299.2 288.4C279.3 267.7 252.5 256.8 225.5 256.8c-14.7 0-29.47 3.234-43.25 9.887L137 288.5c-5.718 2.759-9.038 8.442-9.038 14.36c0 8.409 6.817 15.95 16.02 15.95c2.34 0 4.714-.517 6.955-1.607l45.22-21.84c9.313-4.5 19.08-6.652 28.77-6.652c13.13 0 26.12 3.953 37.64 11.37C218.5 355.5 118.1 388.3 45.91 388.3C20.59 388.3 0 408.1 0 434.4v29.56c0 25.42 20.69 46.09 46.12 46.09h55.75c40.35 0 285.8 34.48 361.2-185.6c23.98 1.236 46.71 15.16 59.58 38.81l23.28 42.77c1.616 2.96 6.915 8.465 14.09 8.465C567.7 414.5 576 408.2 576 398.5zM91.03 478.2H46.12c-7.781 0-14.12-6.382-14.12-14.21v-29.56c0-7.845 6.25-14.23 13.91-14.23c82.34 0 190.5-36.75 240.7-98.92l39.06 40.46c3.068 3.184 7.256 4.877 11.53 4.877c1.995 0 4.009-.3685 5.937-1.126l82.47-32.81C352.3 506.5 154.3 478.1 91.03 478.2z"],
    "bandage": [640, 512, [129657, "band-aid"], "f462", "M248 208C248 194.7 258.7 184 272 184C285.3 184 296 194.7 296 208C296 221.3 285.3 232 272 232C258.7 232 248 221.3 248 208zM392 208C392 221.3 381.3 232 368 232C354.7 232 344 221.3 344 208C344 194.7 354.7 184 368 184C381.3 184 392 194.7 392 208zM248 304C248 290.7 258.7 280 272 280C285.3 280 296 290.7 296 304C296 317.3 285.3 328 272 328C258.7 328 248 317.3 248 304zM392 304C392 317.3 381.3 328 368 328C354.7 328 344 317.3 344 304C344 290.7 354.7 280 368 280C381.3 280 392 290.7 392 304zM560 96C604.2 96 640 131.8 640 176V336C640 380.2 604.2 416 560 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H560zM480 384H560C586.5 384 608 362.5 608 336V176C608 149.5 586.5 128 560 128H480V384zM448 128H192V384H448V128zM160 384V128H80C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H160z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M57.92 33.11C97.96 38.12 128 72.15 128 112.5V191.1H176C184.8 191.1 192 199.2 192 207.1C192 216.8 184.8 223.1 176 223.1H128V399.1C128 426.5 149.5 447.1 176 447.1H208C287.5 447.1 352 383.5 352 303.1V271.1C352 245.5 330.5 223.1 304 223.1H272C263.2 223.1 256 216.8 256 207.1C256 199.2 263.2 191.1 272 191.1H304C348.2 191.1 384 227.8 384 271.1V303.1C384 401.2 305.2 479.1 208 479.1H176C131.8 479.1 96 444.2 96 399.1V223.1H48C39.17 223.1 32 216.8 32 207.1C32 199.2 39.17 191.1 48 191.1H96V112.5C96 88.29 77.98 67.87 53.96 64.87L46.02 63.87C37.25 62.78 31.03 54.78 32.13 46.01C33.22 37.24 41.22 31.03 49.99 32.12L57.92 33.11z"],
    "banjo": [512, 512, [129685], "f8a3", "M147.3 316.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l48 48C175.8 390.4 179.9 392 184 392s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L147.3 316.7zM501.3 37.47l-26.71-26.7C467.7 3.871 458.3 0 448.5 0c-9.83 0-19.09 3.844-26.23 11l-41.08 44.2c-3.021 3.252-5.084 7.279-5.955 11.63l-11.82 59.09L298.3 191C273.2 170.3 242.2 156.9 208 153.6V144C208 135.2 200.8 128 192 128S176 135.2 176 144v9.619C141.8 156.9 110.8 170.3 85.67 191L78.88 184.2c-6.25-6.25-16.38-6.25-22.62 0c-6.25 6.25-6.25 16.38 0 22.62l6.789 6.789C42.27 238.8 28.91 269.8 25.62 304H16C7.156 304 0 311.2 0 320s7.156 16 16 16h9.617c3.297 34.22 16.66 65.22 37.42 90.35l-6.789 6.789c-6.25 6.25-6.25 16.38 0 22.62c6.246 6.246 16.37 6.254 22.62 0l6.791-6.791C110.8 469.7 141.8 483.1 176 486.4V496c0 8.844 7.161 16 16 16S208 504.8 208 496v-9.619c34.21-3.297 65.21-16.65 90.33-37.41l6.791 6.791c6.246 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62l-6.789-6.789C341.7 401.2 355.1 370.2 358.4 336H368c8.844 0 16.01-7.156 16.01-16S376.8 304 368 304h-9.617c-3.297-34.22-16.66-65.22-37.42-90.35l65.16-65.15l59.04-11.8c4.354-.8711 8.381-2.934 11.63-5.957l44.47-41.33C515.6 75.09 515.6 51.78 501.3 37.47zM328 320c0 74.98-61 136-136 136S56 394.1 56 320S117 184 192 184S328 245 328 320zM479.5 65.97L436.7 105.8l-38.07 7.611l7.613-38.05l38.75-41.72c2.926-2.934 5.998-1.178 6.975-.2012l26.7 26.7C480.4 61.87 480.3 65.07 479.5 65.97z"],
    "barcode": [512, 512, [], "f02a", "M0 48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V464C32 472.8 24.84 480 16 480C7.164 480 0 472.8 0 464V48zM64 48C64 39.16 71.16 32 80 32C88.84 32 96 39.16 96 48V464C96 472.8 88.84 480 80 480C71.16 480 64 472.8 64 464V48zM160 48V464C160 472.8 152.8 480 144 480C135.2 480 128 472.8 128 464V48C128 39.16 135.2 32 144 32C152.8 32 160 39.16 160 48zM224 48C224 39.16 231.2 32 240 32C248.8 32 256 39.16 256 48V464C256 472.8 248.8 480 240 480C231.2 480 224 472.8 224 464V48zM320 48V464C320 472.8 312.8 480 304 480C295.2 480 288 472.8 288 464V48C288 39.16 295.2 32 304 32C312.8 32 320 39.16 320 48zM384 48C384 39.16 391.2 32 400 32C408.8 32 416 39.16 416 48V464C416 472.8 408.8 480 400 480C391.2 480 384 472.8 384 464V48zM512 48V464C512 472.8 504.8 480 496 480C487.2 480 480 472.8 480 464V48C480 39.16 487.2 32 496 32C504.8 32 512 39.16 512 48z"],
    "barcode-read": [576, 512, [], "f464", "M48 32C39.16 32 32 39.16 32 48V144C32 152.8 24.84 160 16 160C7.164 160 0 152.8 0 144V48C0 21.49 21.49 0 48 0H144C152.8 0 160 7.164 160 16C160 24.84 152.8 32 144 32H48zM160 144V368C160 376.8 152.8 384 144 384C135.2 384 128 376.8 128 368V144C128 135.2 135.2 128 144 128C152.8 128 160 135.2 160 144zM192 144C192 135.2 199.2 128 208 128C216.8 128 224 135.2 224 144V368C224 376.8 216.8 384 208 384C199.2 384 192 376.8 192 368V144zM416 144C416 135.2 423.2 128 432 128C440.8 128 448 135.2 448 144V368C448 376.8 440.8 384 432 384C423.2 384 416 376.8 416 368V144zM288 144V368C288 376.8 280.8 384 272 384C263.2 384 256 376.8 256 368V144C256 135.2 263.2 128 272 128C280.8 128 288 135.2 288 144zM336 144C336 135.2 343.2 128 352 128C360.8 128 368 135.2 368 144V368C368 376.8 360.8 384 352 384C343.2 384 336 376.8 336 368V144zM544 48C544 39.16 536.8 32 528 32H432C423.2 32 416 24.84 416 16C416 7.164 423.2 0 432 0H528C554.5 0 576 21.49 576 48V144C576 152.8 568.8 160 560 160C551.2 160 544 152.8 544 144V48zM144 480C152.8 480 160 487.2 160 496C160 504.8 152.8 512 144 512H48C21.49 512 0 490.5 0 464V368C0 359.2 7.164 352 16 352C24.84 352 32 359.2 32 368V464C32 472.8 39.16 480 48 480H144zM544 368C544 359.2 551.2 352 560 352C568.8 352 576 359.2 576 368V464C576 490.5 554.5 512 528 512H432C423.2 512 416 504.8 416 496C416 487.2 423.2 480 432 480H528C536.8 480 544 472.8 544 464V368z"],
    "barcode-scan": [640, 512, [], "f465", "M64 48C64 39.16 71.16 32 80 32C88.84 32 96 39.16 96 48V192H64V48zM64 464V320H96V464C96 472.8 88.84 480 80 480C71.16 480 64 472.8 64 464zM144 480C135.2 480 128 472.8 128 464V320H160V464C160 472.8 152.8 480 144 480zM144 32C152.8 32 160 39.16 160 48V192H128V48C128 39.16 135.2 32 144 32zM192 464V320H224V464C224 472.8 216.8 480 208 480C199.2 480 192 472.8 192 464zM208 32C216.8 32 224 39.16 224 48V192H192V48C192 39.16 199.2 32 208 32zM288 464V320H320V464C320 472.8 312.8 480 304 480C295.2 480 288 472.8 288 464zM304 32C312.8 32 320 39.16 320 48V192H288V48C288 39.16 295.2 32 304 32zM352 464V320H384V464C384 472.8 376.8 480 368 480C359.2 480 352 472.8 352 464zM368 32C376.8 32 384 39.16 384 48V192H352V48C352 39.16 359.2 32 368 32zM448 464V320H480V464C480 472.8 472.8 480 464 480C455.2 480 448 472.8 448 464zM464 32C472.8 32 480 39.16 480 48V192H448V48C448 39.16 455.2 32 464 32zM544 464V320H576V464C576 472.8 568.8 480 560 480C551.2 480 544 472.8 544 464zM560 32C568.8 32 576 39.16 576 48V192H544V48C544 39.16 551.2 32 560 32zM16 240H624C632.8 240 640 247.2 640 256C640 264.8 632.8 272 624 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M0 80C0 71.16 7.164 64 16 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H16C7.164 96 0 88.84 0 80zM0 240C0 231.2 7.164 224 16 224H432C440.8 224 448 231.2 448 240C448 248.8 440.8 256 432 256H16C7.164 256 0 248.8 0 240zM432 416H16C7.164 416 0 408.8 0 400C0 391.2 7.164 384 16 384H432C440.8 384 448 391.2 448 400C448 408.8 440.8 416 432 416z"],
    "bars-filter": [448, 512, [], "e0ad", "M0 80C0 71.16 7.164 64 16 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H16C7.164 96 0 88.84 0 80zM64 240C64 231.2 71.16 224 80 224H368C376.8 224 384 231.2 384 240C384 248.8 376.8 256 368 256H80C71.16 256 64 248.8 64 240zM272 416H176C167.2 416 160 408.8 160 400C160 391.2 167.2 384 176 384H272C280.8 384 288 391.2 288 400C288 408.8 280.8 416 272 416z"],
    "bars-progress": [512, 512, ["tasks-alt"], "f828", "M464 64C490.5 64 512 85.49 512 112V176C512 202.5 490.5 224 464 224H48C21.49 224 0 202.5 0 176V112C0 85.49 21.49 64 48 64H464zM464 96H320V192H464C472.8 192 480 184.8 480 176V112C480 103.2 472.8 96 464 96zM32 112V176C32 184.8 39.16 192 48 192H288V96H48C39.16 96 32 103.2 32 112zM464 288C490.5 288 512 309.5 512 336V400C512 426.5 490.5 448 464 448H48C21.49 448 0 426.5 0 400V336C0 309.5 21.49 288 48 288H464zM464 320H192V416H464C472.8 416 480 408.8 480 400V336C480 327.2 472.8 320 464 320zM32 336V400C32 408.8 39.16 416 48 416H160V320H48C39.16 320 32 327.2 32 336z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 80C0 71.16 7.164 64 16 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H16C7.164 96 0 88.84 0 80zM0 240C0 231.2 7.164 224 16 224H304C312.8 224 320 231.2 320 240C320 248.8 312.8 256 304 256H16C7.164 256 0 248.8 0 240zM176 416H16C7.164 416 0 408.8 0 400C0 391.2 7.164 384 16 384H176C184.8 384 192 391.2 192 400C192 408.8 184.8 416 176 416z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 80C0 71.16 7.164 64 16 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H16C7.164 96 0 88.84 0 80zM64 240C64 231.2 71.16 224 80 224H496C504.8 224 512 231.2 512 240C512 248.8 504.8 256 496 256H80C71.16 256 64 248.8 64 240zM432 416H16C7.164 416 0 408.8 0 400C0 391.2 7.164 384 16 384H432C440.8 384 448 391.2 448 400C448 408.8 440.8 416 432 416z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM455.2 296.8c7.027-.7109 14.03-.7422 21.01-.4687c-16.68 91.2-88.66 163.2-179.9 179.8C296.3 474.8 296 473.5 296 472.2c0-4.812 .1875-9.562 .5938-14.34c.75-8.812-5.781-16.56-14.59-17.28c-8.687-.5938-16.53 5.781-17.28 14.59C264.3 460.8 264 466.5 264 472.2c0 2.488 .4121 4.914 .5645 7.379C261.7 479.7 258.9 480 256 480c-123.5 0-224-100.5-224-224c0-2.883 .3242-5.688 .4336-8.547c2.58 .1562 5.117 .5781 7.723 .5781c6.281 0 12.5-.2813 18.75-.8438c8.812-.8125 15.28-8.625 14.47-17.41C72.53 220.1 64.5 214.7 55.97 215.3C49.22 215.9 42.51 215.1 35.82 215.7C52.48 124.5 124.5 52.48 215.7 35.82c.0566 1.352 .3066 2.668 .3066 4.023c0 5.125-.2187 10.22-.6562 15.31C214.6 63.97 221.2 71.69 229.1 72.44C230.4 72.47 230.9 72.5 231.3 72.5c8.219 0 15.22-6.312 15.91-14.66c.5-5.969 .7813-12 .7813-18c0-2.5-.4121-4.938-.5645-7.414C250.3 32.32 253.1 32 256 32c123.5 0 224 100.5 224 224c0 2.93-.3281 5.777-.4395 8.68c-9.139-.4844-18.31-.6094-27.53 .2578c-8.781 .875-15.22 8.688-14.38 17.5C438.5 291.2 446.6 297.6 455.2 296.8zM220.9 106.3C212.9 102.7 203.4 106.1 199.7 114.1c-12.94 28-33.25 52.25-58.75 70.03C132.7 189.9 123.9 195 114.8 199.3C106.8 203.1 103.4 212.7 107.2 220.7c2.75 5.781 8.5 9.156 14.47 9.156c2.312 0 4.625-.5 6.844-1.531c10.72-5.062 21.09-11.09 30.78-17.88c30.12-21.06 54.13-49.69 69.47-82.84C232.4 119.5 228.1 110 220.9 106.3zM382.6 284.2c-10.34 4.906-20.38 10.78-29.91 17.47c-30.34 21.25-54.5 50.22-69.84 83.75c-3.656 8.031-.125 17.53 7.906 21.22c2.156 .9687 4.406 1.438 6.656 1.438c6.062 0 11.88-3.469 14.56-9.344c12.97-28.34 33.41-52.88 59.09-70.88c8.062-5.656 16.56-10.62 25.28-14.78c8-3.812 11.38-13.34 7.562-21.31C400.1 283.7 390.5 280.3 382.6 284.2z"],
    "baseball-bat-ball": [640, 512, [], "f432", "M627.3 60.18l-23.63-32.5c-22.63-31.12-64.75-35.87-93.63-14.87L307.8 159.7c-45.63 33.12-87.37 71.25-124.4 113.7c-29 33.37-72.53 78.59-130.3 120.6l-21.63 15.75c-.25-.375-11.25-17.5-25.5-6.248c-6.875 5.498-8 15.62-2.5 22.5l64 79.99c5.25 6.5 15.25 8.25 22.5 2.5c.5-.375 12.88-9.498 .125-25.5l18.12-13.25c66.01-47.87 122.4-72.46 155.2-86.46c51.88-21.1 101.2-49.88 146.9-82.1l202.3-146.7C642.3 131.8 648.9 90.05 627.3 60.18zM70.12 458l-18.62-23.25c28.88-20.87 71.75-50.62 125-106.2l32.25 44.37C140.6 405.8 99.25 436.8 70.12 458zM593.7 127.7c-247 179.1-243.1 182.5-359.9 233.7L195 308.3c84.88-94.99 86.51-90.12 333.8-269.5c14.88-10.75 37-8.75 49 7.623l23.5 32.5C612.8 94.54 609.3 116.3 593.7 127.7zM496.1 352C451.1 352 416 387.9 416 432c0 44.13 35.97 80 80.09 80s79.91-35.88 79.91-80C576 387.9 540.2 352 496.1 352zM496 480c-26.5 0-48-21.5-48-48c0-26.5 21.5-47.1 48-47.1c26.5 0 48 21.5 48 47.1C544 458.5 522.5 480 496 480z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M224 400C224 408.8 216.8 416 208 416C199.2 416 192 408.8 192 400V304C192 295.2 199.2 288 208 288C216.8 288 224 295.2 224 304V400zM288 288C296.8 288 304 295.2 304 304V400C304 408.8 296.8 416 288 416C279.2 416 272 408.8 272 400V304C272 295.2 279.2 288 288 288zM384 400C384 408.8 376.8 416 368 416C359.2 416 352 408.8 352 400V304C352 295.2 359.2 288 368 288C376.8 288 384 295.2 384 304V400zM349.8 7.943L457.2 192H560C568.8 192 576 199.2 576 208C576 216.8 568.8 224 560 224H536L476.1 463.5C468.1 492 443.4 512 414 512H161.1C132.6 512 107 492 99.88 463.5L40 224H16C7.164 224 0 216.8 0 208C0 199.2 7.164 192 16 192H118.8L226.2 7.943C230.6 .3098 240.4-2.268 248.1 2.184C255.7 6.637 258.3 16.43 253.8 24.07L155.9 192H420.1L322.2 24.07C317.7 16.43 320.3 6.637 327.9 2.184C335.6-2.268 345.4 .3098 349.8 7.943V7.943zM130.9 455.8C134.5 470 147.3 480 161.1 480H414C428.7 480 441.5 470 445.1 455.8L503 224H72.98L130.9 455.8z"],
    "basket-shopping-simple": [576, 512, ["shopping-basket-alt"], "e0af", "M192 296C192 309.3 181.3 320 168 320C154.7 320 144 309.3 144 296C144 282.7 154.7 272 168 272C181.3 272 192 282.7 192 296zM384 296C384 282.7 394.7 272 408 272C421.3 272 432 282.7 432 296C432 309.3 421.3 320 408 320C394.7 320 384 309.3 384 296zM322.2 24.07C317.7 16.43 320.3 6.637 327.9 2.184C335.6-2.268 345.4 .3098 349.8 7.943L457.2 192H560C568.8 192 576 199.2 576 208C576 216.8 568.8 224 560 224H536L476.1 463.5C468.1 492 443.4 512 414 512H161.1C132.6 512 107 492 99.88 463.5L40 224H16C7.164 224 0 216.8 0 208C0 199.2 7.164 192 16 192H118.8L226.2 7.943C230.6 .3098 240.4-2.268 248.1 2.184C255.7 6.637 258.3 16.43 253.8 24.07L155.9 192H420.1L322.2 24.07zM503 224H72.98L130.9 455.8C134.5 470 147.3 480 161.1 480H414C428.7 480 441.5 470 445.1 455.8L503 224z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM480 256c0 .9766-.1348 1.922-.1465 2.896C469.4 257.1 458.7 256 448 256c-47.19 0-90.39 17.18-123.9 45.52L278.6 256l146.5-146.5C459.2 148.8 480 199.1 480 256zM288 448c0-38.34 14.12-73.1 36.69-100.7l77.78 77.78c-31.03 26.91-69.46 45.33-111.8 51.95C288.9 467.5 288 457.7 288 448zM402.5 86.91L256 233.4L210.5 187.9C238.8 154.4 256 111.2 256 64c0-10.68-1.139-21.36-2.896-31.85C254.1 32.13 255 32 256 32C312 32 363.2 52.81 402.5 86.91zM109.5 86.91c31.03-26.91 69.46-45.33 111.8-51.95C223.1 44.49 224 54.26 224 64c0 38.34-14.12 73.1-36.69 100.7L109.5 86.91zM86.91 109.5l77.78 77.78C137.1 209.9 102.3 224 64 224C54.26 224 44.49 223.1 34.96 221.4C41.58 178.1 59.1 140.6 86.91 109.5zM32 256c0-.9766 .1348-1.922 .1465-2.896C42.64 254.9 53.32 256 64 256c47.19 0 90.39-17.18 123.9-45.52L233.4 256l-146.5 146.5C52.81 363.2 32 312 32 256zM109.5 425.1L256 278.6l45.52 45.52C273.2 357.6 256 400.8 256 448c0 10.68 1.139 21.36 2.896 31.85C257.9 479.9 256.1 480 256 480C199.1 480 148.8 459.2 109.5 425.1zM425.1 402.5l-77.78-77.78C374.9 302.1 409.7 288 448 288c9.742 0 19.51 .8926 29.04 2.635C470.4 333 452 371.4 425.1 402.5z"],
    "basketball-hoop": [640, 512, [], "f435", "M631.5 175.8C572.6 71.38 455.4 0 320 0S67.37 71.38 8.504 175.8C2.955 185.7 0 196.8 0 208.1v118c0 25.43 15.05 48.44 38.35 58.63l67.03 29.32c11.29 4.939 23.7-4.207 22.31-16.46c-.6406-5.674-4.256-10.58-9.486-12.86l-67.03-29.32C39.53 350.4 32 338.9 32 326.1V208.1c0-5.664 1.189-10.8 3.439-14.86C90.61 93.79 199.6 32 320 32s229.4 61.79 284.6 161.2C606.8 197.3 608 202.4 608 208.1v118c0 12.71-7.525 24.22-19.17 29.32l-67.03 29.32c-5.23 2.287-8.846 7.189-9.486 12.86c-1.383 12.25 11.02 21.39 22.31 16.46l67.03-29.32C624.9 374.6 640 351.6 640 326.1V208.1C640 196.8 637 185.7 631.5 175.8zM464 208C472.8 208 480 200.8 480 192V160c0-17.67-14.33-32-32-32H192C174.3 128 160 142.3 160 160v32c0 8.836 7.164 16 16 16C184.8 208 192 200.8 192 192V160h256v32C448 200.8 455.2 208 464 208zM528 256c0-8.836-7.162-16-16-16H128C119.2 240 112 247.2 112 256S119.2 272 128 272h18.6l25.49 225.8c.6562 5.875 4.531 10.86 10 13.04c1.9 .7441 3.914 1.121 5.902 1.121c3.732 0 7.412-1.301 10.35-3.809l55.11-46.8l56.29 46.91C312.7 510.8 316.4 512 320 512s7.281-1.234 10.25-3.703l56.29-46.91l55.11 46.8C444.6 510.7 448.3 512 452 512c1.999 0 4-.375 5.906-1.125c5.469-2.172 9.344-7.162 10-13.04L493.4 272H512C520.8 272 528 264.8 528 256zM439.5 464.4l-32.22-27.36c-5.971-5.07-13.34-7.607-20.71-7.607c-7.273 0-14.55 2.469-20.49 7.416L320 475.2l-46.06-38.38c-5.938-4.947-13.21-7.416-20.49-7.416c-7.371 0-14.74 2.539-20.71 7.607l-32.22 27.36L178.8 272h282.4L439.5 464.4zM240 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C216 333.3 226.7 344 240 344zM256 384c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C266.7 360 256 370.7 256 384zM336 384c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C346.7 360 336 370.7 336 384zM400 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C376 333.3 386.7 344 400 344zM320 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C296 333.3 306.7 344 320 344z"],
    "bat": [640, 512, [], "f6b5", "M638.6 287.2L568.2 129.8c-5.375-12.38-17.75-19.5-30.62-19.5c-5.75 0-11.75 1.5-17.12 4.625l-104.9 60.37L383.1 64L333.9 112H306.1L255.1 64L224.4 175.2L119.5 114.9c-5.375-3.125-11.37-4.625-17.12-4.625c-12.88 0-25.25 7.125-30.62 19.5L1.375 287.2C-4.25 300 8.375 313.1 22 308.8L38.5 303.5c6.75-2.25 13.87-3.375 20.1-3.375c21.88 0 42.87 10.38 55.5 28.5L153.4 384l12.37-11.88c13-12.5 30.12-18.75 46.1-18.75c20.12 0 40.25 8.75 53.37 25.62L319.1 448l53.87-69c13.25-16.88 33.25-25.62 53.37-25.62c16.88 0 33.1 6.25 46.1 18.75L486.6 384l38.37-55.38c12.62-18.12 33.62-28.5 55.5-28.5c7 0 14.12 1.125 20.1 3.375l16.5 5.25C631.6 313.1 644.2 300 638.6 287.2zM580.5 268.1c-33.5 0-64.63 16-83.25 42.75l-17.25 25c-15.75-9.375-33.88-14.38-52.75-14.38c-31.87 0-61 14-80 38.38l-27.25 34.75l-27.25-34.75c-19-24.38-48.13-38.38-80-38.38c-18.88 0-37 5-52.75 14.38l-17.25-25C124.1 284.1 92.1 268.1 59.5 268.1c-4.625 0-9.25 .375-13.75 1L102.4 142.2L245.7 225L271.9 124.9L292.9 144h54.25l21-19.12l26.12 100.1l143.4-82.75l56.63 126.9C589.7 268.5 585.1 268.1 580.5 268.1z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M464 320c-8.844 0-16 7.156-16 16v32c0 44.11-35.89 80-80 80h-224C99.89 448 64 412.1 64 368v-32C64 327.2 56.84 320 48 320S32 327.2 32 336v32c0 30.4 12.27 57.93 32 78.13V496C64 504.8 71.16 512 80 512C88.84 512 96 504.8 96 496v-27.23C110.6 475.8 126.8 480 144 480h224c17.24 0 33.39-4.242 48-11.23V496c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16v-49.87c19.73-20.2 32-47.74 32-78.13v-32C480 327.2 472.8 320 464 320zM496 256H64V61.25C64 45.13 77.13 32 93.25 32C100.1 32 108.5 35.13 113.9 40.56l25.32 25.32C121.6 93.88 124.8 131.3 149.2 155.7l12.88 12.88C158.9 174.6 159.6 182.2 164.7 187.3C167.8 190.4 171.9 192 176 192s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62c-5.104-5.104-12.69-5.811-18.74-2.582L251.7 53.22C237.5 39.07 218.1 32 200.5 32C187 32 173.6 35.83 161.9 43.26L136.6 17.94C125 6.375 109.6 0 93.25 0C59.48 0 32 27.47 32 61.25v194.8L16 256C7.164 256 0 263.2 0 272S7.164 288 16 288h480C504.8 288 512 280.8 512 272S504.8 256 496 256zM171.8 75.85C179.5 68.21 189.6 64 200.5 64s20.96 4.207 28.61 11.85l12.23 12.23L184.1 145.3L171.8 133.1C156.1 117.3 156.1 91.62 171.8 75.85z"],
    "battery-bolt": [576, 512, [], "f376", "M355.8 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H244.2L280.2 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H368C368 116.7 364 105.3 355.9 96.11L355.8 96zM283.8 96L247.8 128H80C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H159.1C159.1 395.3 163.1 406.7 172.1 415.9L172.2 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H283.8zM560 192C568.8 192 576 199.2 576 208V304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192zM218.1 240H352C358.6 240 364.6 244.1 366.1 250.3C369.3 256.5 367.6 263.5 362.6 267.1L218.6 395.1C212 401.8 201.9 401.2 196 394.6C190.2 388 190.8 377.9 197.4 372L309.9 271.1H176C169.4 271.1 163.4 267.9 161 261.7C158.7 255.5 160.4 248.5 165.4 244L309.4 116C315.1 110.2 326.1 110.8 331.1 117.4C337.8 123.1 337.2 134.1 330.6 139.1L218.1 240z"],
    "battery-empty": [576, 512, ["battery-0"], "f244", "M432 96C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H432zM32 336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80C53.49 128 32 149.5 32 176V336zM560 192C568.8 192 576 199.2 576 208V304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M208 128H80C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H208.5C209.1 396 214.8 407 222 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H208L208 128zM336 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H321.1C329.2 407 334 396 335.5 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H336L336 96zM560 192C568.8 192 576 199.2 576 208V304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192zM296 376C296 389.3 285.3 400 272 400C258.7 400 248 389.3 248 376C248 362.7 258.7 352 272 352C285.3 352 296 362.7 296 376zM288 304C288 312.8 280.8 320 272 320C263.2 320 256 312.8 256 304V112C256 103.2 263.2 96 272 96C280.8 96 288 103.2 288 112V304z"],
    "battery-full": [576, 512, [128267, "battery", "battery-5"], "f240", "M64 208C64 181.5 85.49 160 112 160H400C426.5 160 448 181.5 448 208V304C448 330.5 426.5 352 400 352H112C85.49 352 64 330.5 64 304V208zM96 208V304C96 312.8 103.2 320 112 320H400C408.8 320 416 312.8 416 304V208C416 199.2 408.8 192 400 192H112C103.2 192 96 199.2 96 208zM0 176C0 131.8 35.82 96 80 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176zM80 128C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80zM576 304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192C568.8 192 576 199.2 576 208V304z"],
    "battery-half": [576, 512, ["battery-3"], "f242", "M64 208C64 181.5 85.49 160 112 160H240C266.5 160 288 181.5 288 208V304C288 330.5 266.5 352 240 352H112C85.49 352 64 330.5 64 304V208zM96 208V304C96 312.8 103.2 320 112 320H240C248.8 320 256 312.8 256 304V208C256 199.2 248.8 192 240 192H112C103.2 192 96 199.2 96 208zM0 176C0 131.8 35.82 96 80 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176zM80 128C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80zM576 304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192C568.8 192 576 199.2 576 208V304z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M64 208C64 181.5 85.49 160 112 160C138.5 160 160 181.5 160 208V304C160 330.5 138.5 352 112 352C85.49 352 64 330.5 64 304V208zM112 192C103.2 192 96 199.2 96 208V304C96 312.8 103.2 320 112 320C120.8 320 128 312.8 128 304V208C128 199.2 120.8 192 112 192zM0 176C0 131.8 35.82 96 80 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176zM80 128C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80zM576 304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192C568.8 192 576 199.2 576 208V304z"],
    "battery-quarter": [576, 512, ["battery-2"], "f243", "M64 208C64 181.5 85.49 160 112 160H144C170.5 160 192 181.5 192 208V304C192 330.5 170.5 352 144 352H112C85.49 352 64 330.5 64 304V208zM96 208V304C96 312.8 103.2 320 112 320H144C152.8 320 160 312.8 160 304V208C160 199.2 152.8 192 144 192H112C103.2 192 96 199.2 96 208zM0 176C0 131.8 35.82 96 80 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176zM80 128C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80zM576 304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192C568.8 192 576 199.2 576 208V304z"],
    "battery-slash": [640, 512, [], "f377", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM544 336C544 340.9 543.6 345.7 542.7 350.3L512 326V176C512 149.5 490.5 128 464 128H261.2L220.6 96H464C508.2 96 544 131.8 544 176V336zM50.53 124.8L75.66 144.6C68.39 153.1 64 164 64 176V336C64 362.5 85.49 384 112 384H378.8L419.4 416H112C67.82 416 32 380.2 32 336V176C32 156.5 38.96 138.7 50.53 124.8V124.8zM592 192C600.8 192 608 199.2 608 208V304C608 312.8 600.8 320 592 320C583.2 320 576 312.8 576 304V208C576 199.2 583.2 192 592 192V192z"],
    "battery-three-quarters": [576, 512, ["battery-4"], "f241", "M64 208C64 181.5 85.49 160 112 160H304C330.5 160 352 181.5 352 208V304C352 330.5 330.5 352 304 352H112C85.49 352 64 330.5 64 304V208zM96 208V304C96 312.8 103.2 320 112 320H304C312.8 320 320 312.8 320 304V208C320 199.2 312.8 192 304 192H112C103.2 192 96 199.2 96 208zM0 176C0 131.8 35.82 96 80 96H432C476.2 96 512 131.8 512 176V336C512 380.2 476.2 416 432 416H80C35.82 416 0 380.2 0 336V176zM80 128C53.49 128 32 149.5 32 176V336C32 362.5 53.49 384 80 384H432C458.5 384 480 362.5 480 336V176C480 149.5 458.5 128 432 128H80zM576 304C576 312.8 568.8 320 560 320C551.2 320 544 312.8 544 304V208C544 199.2 551.2 192 560 192C568.8 192 576 199.2 576 208V304z"],
    "bed": [640, 512, [128716], "f236", "M528 128h-256C263.2 128 256 135.2 256 144V320H32V48C32 39.2 24.8 32 16 32S0 39.2 0 48v416C0 472.8 7.199 480 16 480S32 472.8 32 464V416h576v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-224C640 178.1 589.9 128 528 128zM608 384H32v-32h576V384zM608 320H288V160h240C572.1 160 608 195.9 608 240V320zM144 288C188.1 288 224 252.1 224 208S188.1 128 144 128S64 163.9 64 208S99.88 288 144 288zM144 160C170.5 160 192 181.5 192 208S170.5 256 144 256S96 234.5 96 208S117.5 160 144 160z"],
    "bed-bunk": [576, 512, [], "f8f8", "M128 128c35.38 0 64-28.62 64-64S163.4 0 128 0S64 28.62 64 64S92.63 128 128 128zM128 32c17.62 0 32 14.38 32 32S145.6 96 128 96S96 81.63 96 64S110.4 32 128 32zM128 384c35.38 0 64-28.62 64-64S163.4 256 128 256s-64 28.62-64 64S92.63 384 128 384zM128 288c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S110.4 288 128 288zM464 0h-224C231.2 0 224 7.164 224 16V160H32V16C32 7.199 24.8 0 16 0S0 7.199 0 16v480C0 504.8 7.199 512 16 512S32 504.8 32 496V448h512v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-384C576 50.14 525.9 0 464 0zM544 416H256V288h208c44.13 0 80 35.88 80 80V416zM544 289.8C523 268.1 494.1 256 464 256h-224C231.1 256 224 263.1 224 272V416H32V192h512V289.8zM544 160H256V32h208C508.1 32 544 67.88 544 112V160z"],
    "bed-empty": [640, 512, [128719], "f8f9", "M528 192H32V48C32 39.2 24.8 32 16 32S0 39.2 0 48v416C0 472.8 7.199 480 16 480S32 472.8 32 464V416h576v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-160C640 242.1 589.9 192 528 192zM608 384H32v-32h576V384zM608 320H32V224h496C572.1 224 608 259.9 608 304V320z"],
    "bed-front": [512, 512, ["bed-alt"], "f8f7", "M480 240.4V96c0-35.3-28.72-64-64-64H96C60.72 32 32 60.7 32 96v144.4C12.69 255 0 277.1 0 304v160C0 472.8 7.156 480 16 480S32 472.8 32 464V416h448v48c0 8.844 7.156 16 16 16s16-7.156 16-16v-160C512 277.1 499.3 255 480 240.4zM432 224h-160V192c0-17.64 14.34-32 32-32H416c17.66 0 32 14.36 32 32v33.62C442.8 224.6 437.5 224 432 224zM96 64h320c17.66 0 32 14.36 32 32v40.9C438.5 131.4 427.7 128 416 128h-112c-19.2 0-36.26 8.678-48 22.12C244.3 136.7 227.2 128 208 128H96C84.29 128 73.45 131.4 64 136.9V96C64 78.36 78.34 64 96 64zM64 192c0-17.64 14.34-32 32-32h112c17.66 0 32 14.36 32 32v32h-160C74.52 224 69.17 224.6 64 225.6V192zM480 384H32V304C32 277.5 53.53 256 80 256h352C458.5 256 480 277.5 480 304V384z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M207.1 96.01l133.1 .0091l43.71 87.14C388.4 188.6 393.1 192 400 192h.6719c6.281-.2813 11.84-4.219 14.19-10.06l50.77-126.9l16.06 32.13C484.4 92.56 489.9 96.01 496 96.01h128c8.844 0 16-7.156 16-16S632.8 64 624 64h-118.1l-27.58-55.16C475.5 3.219 470.2-.5 463.3 0c-6.281 .2813-11.84 4.219-14.19 10.06l-50.77 126.9l-32.06-64.13C363.6 67.44 358.1 64 352 64L208 64C199.2 64 192 71.17 192 80.01S199.2 96.01 207.1 96.01zM144 320C188.1 320 224 284.1 224 240S188.1 160 144 160S64 195.9 64 240S99.88 320 144 320zM144 192C170.5 192 192 213.5 192 240S170.5 288 144 288S96 266.5 96 240S117.5 192 144 192zM528 160H480c-8.836 0-16 7.162-16 16C464 184.8 471.2 192 480 192h48C572.2 192 608 227.8 608 272V352L288 352V192h32c8.836 0 16-7.164 16-16C336 167.2 328.8 160 320 160H272C263.2 160 256 167.2 256 176V352H32V80.97c0-7.979-5.4-15.42-13.27-16.74C8.74 62.55 0 70.31 0 80v415c0 7.979 5.4 15.42 13.27 16.74C23.26 513.4 32 505.7 32 496V448h576v47.03c0 7.979 5.4 15.42 13.27 16.74C631.3 513.4 640 505.7 640 496v-224C640 210.1 589.9 160 528 160zM608 416H32v-32h576V416z"],
    "bee": [576, 512, [], "e0b2", "M448 95.1c-27.7 0-55.36 9.455-80.73 22.73C367.5 116.5 368 114.3 368 111.1c0-20.4-7.832-38.84-20.4-52.97l31.11-31.11c5.635-5.635 7.001-14.71 2.341-21.17c-5.94-8.239-17.5-8.923-24.37-2.051l-34.99 34.99C311.4 34.88 300.1 31.1 288 31.1S264.6 34.88 254.3 39.68L219.9 5.286C214.3-.349 205.2-1.715 198.7 2.945C190.5 8.884 189.8 20.44 196.7 27.31L228.4 58.99C215.8 73.12 208 91.6 208 111.1c0 2.293 .4883 4.483 .6777 6.727C183.3 105.5 155.7 95.1 128 95.1C57.34 95.1 0 146.1 0 207.1c0 50.96 39.05 93.63 92.31 107.1C102.3 317.6 112 309.9 112 299.6c0-7.354-5.111-13.57-12.23-15.39C60.6 274.2 32 243.9 32 207.1C32 163.9 75.04 128 127.1 128c34.99 0 72.8 20.26 104.4 43.5c-50.07 21.58-85.17 71.31-85.15 129.3C147.2 406.4 288 512 288 512s140.8-105.6 140.8-211.2c.0195-57.99-35.07-107.7-85.14-129.3C375.3 148.3 413 128 448 128c52.9 0 96 35.87 96 80.04c0 35.89-28.59 66.14-67.77 76.19C469.1 286.1 464 292.3 464 299.6c0 10.3 9.703 17.94 19.69 15.42C536.1 301.6 576 258.1 576 208C576 146.2 518.7 95.99 448 95.1zM336 112c0 26.47-21.51 47.99-47.97 47.99S240 138.5 240 112S261.5 64 288 64S336 85.53 336 112zM234.1 416c-8.516-10.15-16.43-20.95-23.77-32h155.4c-7.336 11.05-15.25 21.85-23.77 32H234.1zM192.1 352c-4.891-10.68-8.402-21.37-10.51-32h212.8c-2.105 10.63-5.617 21.32-10.51 32H192.1zM395.6 288H180.4c1.305-11.16 4.076-21.91 8.646-32h197.8C391.5 266.1 394.2 276.8 395.6 288zM263.7 448h48.52C303.8 456.4 295.4 464.3 288 470.7C280.6 464.3 272.2 456.4 263.7 448zM365 223.9H210.1c.041-.041-.041 .041 0 0C231.5 203.4 258.9 192 287.9 192S344.5 203.4 365 223.9C365.1 223.1 364.1 223.9 365 223.9z"],
    "beer-mug": [512, 512, ["beer-foam"], "e0b3", "M256 208v192c0 8.844 7.156 16 16 16s16-7.156 16-16v-192C288 199.2 280.8 192 272 192S256 199.2 256 208zM115.2 133.3c13.07-8.768 28.93-3.621 38.31 5.164C167.8 151.8 186.9 160 207.1 160s40.23-8.188 54.49-21.54c9.393-8.793 25.28-13.91 38.31-5.164C310.9 140 322.9 144 335.1 144c39.88 0 71.24-36.47 62.54-77.88c-4.861-23.15-23.39-42.46-46.36-48.12C346.7 16.64 341.3 16 335.1 16c-11.1 0-23.17 3.338-32.71 9.117c-13.17 7.979-29.32 7.166-40.82-3.598C248.2 8.178 229.1 0 207.1 0S167.8 8.178 153.5 21.52C142 32.29 125.9 33.09 112.7 25.12C103.2 19.34 91.1 16 80 16c-5.25 0-10.68 .6426-16.18 1.998c-22.96 5.658-41.5 24.97-46.36 48.12C8.761 107.5 40.12 144 79.1 144C93.06 144 105.1 140 115.2 133.3zM48.78 72.69C53.18 51.75 77.84 41.4 96.14 52.49C106.9 59 119 62.45 131.2 62.45c16.4 0 32.09-6.236 44.19-17.56c18.36-17.18 46.85-17.19 65.21-.002c12.1 11.32 27.79 17.56 44.19 17.56c12.19 0 24.32-3.443 35.07-9.959c18.27-11.06 42.95-.7773 47.36 20.21c2.85 13.56-2.758 23.01-6.354 27.44c-23.71 29.21-45.94-3.365-75.1-3.365c-16.26 0-32.71 6.678-45.15 18.33c-18.38 17.21-46.87 17.2-65.23-.002C162.9 103.5 146.5 96.77 130.2 96.77c-11.8 0-23.16 3.439-32.86 9.947C74.22 122.3 42.63 101.9 48.78 72.69zM192 208v192C192 408.8 199.2 416 208 416S224 408.8 224 400v-192C224 199.2 216.8 192 207.1 192S192 199.2 192 208zM432 160h-64C359.2 160 352 167.2 352 176V416c0 35.35-28.65 64-64 64H128c-35.35 0-64-28.65-64-64V176C64 167.2 56.84 160 48 160S32 167.2 32 176V416c0 53.02 42.98 96 96 96h160c43.12 0 79.16-28.62 91.29-67.75L467.8 400C494.9 386.4 512 358.8 512 328.5V240C512 195.8 476.2 160 432 160zM480 328.5c0 18.3-10.16 34.73-26.53 42.92L384 406.1V192h48C458.5 192 480 213.5 480 240V328.5zM128 208v192C128 408.8 135.2 416 144 416S160 408.8 160 400v-192C160 199.2 152.8 192 144 192S128 199.2 128 208z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M144 128C135.2 128 128 135.2 128 144v224C128 376.8 135.2 384 144 384S160 376.8 160 368v-224C160 135.2 152.8 128 144 128zM272 128C263.2 128 256 135.2 256 144v224c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C288 135.2 280.8 128 272 128zM208 128C199.2 128 192 135.2 192 144v224C192 376.8 199.2 384 208 384S224 376.8 224 368v-224C224 135.2 216.8 128 208 128zM432 96H384V80C384 53.49 362.5 32 336 32h-256C53.49 32 32 53.49 32 80V384c0 53.02 42.98 96 96 96h160c53.02 0 96-43.06 96-96.08V377.9L467.8 336C495.1 322.4 512 294.1 512 264.5V176C512 131.9 476.1 96 432 96zM352 384c0 35.29-28.71 64-64 64H128c-35.29 0-64-28.71-64-64V80C64 71.18 71.18 64 80 64h256C344.8 64 352 71.18 352 80V384zM480 264.5c0 18.3-10.16 34.73-26.53 42.92L384 342.1V128h48C458.5 128 480 149.5 480 176V264.5z"],
    "bell": [448, 512, [61602, 128276], "f0f3", "M207.1 16C207.1 7.164 215.2 0 223.1 0C232.8 0 240 7.164 240 16V32.79C320.9 40.82 384 109 384 192V221.1C384 264.8 401.4 306.7 432.3 337.7L435 340.4C443.3 348.7 448 359.1 448 371.7C448 396.2 428.2 416 403.7 416H44.28C19.83 416 0 396.2 0 371.7C0 359.1 4.666 348.7 12.97 340.4L15.72 337.7C46.63 306.7 64 264.8 64 221.1V192C64 109 127.1 40.82 208 32.79L207.1 16zM223.1 64C153.3 64 95.1 121.3 95.1 192V221.1C95.1 273.3 75.26 323.4 38.35 360.3L35.6 363C33.29 365.3 31.1 368.5 31.1 371.7C31.1 378.5 37.5 384 44.28 384H403.7C410.5 384 416 378.5 416 371.7C416 368.5 414.7 365.3 412.4 363L409.7 360.3C372.7 323.4 352 273.3 352 221.1V192C352 121.3 294.7 64 223.1 64H223.1zM223.1 480C237.9 480 249.8 471.1 254.2 458.7C257.1 450.3 266.3 445.1 274.6 448.9C282.9 451.9 287.3 461 284.4 469.3C275.6 494.2 251.9 512 223.1 512C196.1 512 172.4 494.2 163.6 469.3C160.7 461 165.1 451.9 173.4 448.9C181.7 445.1 190.9 450.3 193.8 458.7C198.2 471.1 210.1 480 223.1 480z"],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", "M48 384C56.84 384 64 376.8 64 368c0-105.9 86.13-192 192-192s192 86.13 192 192c0 8.844 7.156 16 16 16s16-7.156 16-16c0-118.1-91.97-214.9-208-223.2V96h32C312.8 96 320 88.84 320 80S312.8 64 304 64h-96C199.2 64 192 71.16 192 80S199.2 96 208 96h32v48.81C123.1 153.1 32 249.9 32 368C32 376.8 39.16 384 48 384zM496 416h-480C7.156 416 0 423.2 0 432S7.156 448 16 448h480c8.844 0 16-7.156 16-16S504.8 416 496 416z"],
    "bell-exclamation": [448, 512, [], "f848", "M248 304C248 317.3 237.3 328 223.1 328C210.7 328 199.1 317.3 199.1 304C199.1 290.7 210.7 280 223.1 280C237.3 280 248 290.7 248 304zM240 240C240 248.8 232.8 256 223.1 256C215.2 256 207.1 248.8 207.1 240V128C207.1 119.2 215.2 112 223.1 112C232.8 112 240 119.2 240 128V240zM207.1 16C207.1 7.164 215.2 0 223.1 0C232.8 0 240 7.164 240 16V32.79C320.9 40.82 384 109 384 192V221.1C384 264.8 401.4 306.7 432.3 337.7L435 340.4C443.3 348.7 448 359.1 448 371.7C448 396.2 428.2 416 403.7 416H44.28C19.83 416 0 396.2 0 371.7C0 359.1 4.666 348.7 12.97 340.4L15.72 337.7C46.63 306.7 64 264.8 64 221.1V192C64 109 127.1 40.82 208 32.79L207.1 16zM223.1 64C153.3 64 95.1 121.3 95.1 192V221.1C95.1 273.3 75.26 323.4 38.35 360.3L35.6 363C33.29 365.3 31.1 368.5 31.1 371.7C31.1 378.5 37.5 384 44.28 384H403.7C410.5 384 416 378.5 416 371.7C416 368.5 414.7 365.3 412.4 363L409.7 360.3C372.7 323.4 352 273.3 352 221.1V192C352 121.3 294.7 64 223.1 64H223.1zM223.1 480C237.9 480 249.8 471.1 254.2 458.7C257.1 450.3 266.3 445.1 274.6 448.9C282.9 451.9 287.3 461 284.4 469.3C275.6 494.2 251.9 512 223.1 512C196.1 512 172.4 494.2 163.6 469.3C160.7 461 165.1 451.9 173.4 448.9C181.7 445.1 190.9 450.3 193.8 458.7C198.2 471.1 210.1 480 223.1 480z"],
    "bell-on": [640, 512, [128365], "f8fa", "M606.3 8.844C610.3 16.75 607.1 26.36 599.2 30.31L535.2 62.31C527.3 66.26 517.6 63.06 513.7 55.15C509.7 47.25 512.9 37.64 520.8 33.69L584.8 1.689C592.7-2.263 602.4 .9405 606.3 8.844V8.844zM304 15.1C304 7.163 311.2-.0003 320-.0003C328.8-.0003 336 7.163 336 15.1V32.79C416.9 40.82 480 109 480 191.1V221.1C480 264.8 497.4 306.7 528.3 337.7L531 340.4C539.3 348.7 544 359.1 544 371.7C544 396.2 524.2 416 499.7 416H140.3C115.8 416 96 396.2 96 371.7C96 359.1 100.7 348.7 108.1 340.4L111.7 337.7C142.6 306.7 160 264.8 160 221.1V191.1C160 109 223.1 40.82 304 32.79L304 15.1zM320 63.1C249.3 63.1 192 121.3 192 191.1V221.1C192 273.3 171.3 323.4 134.3 360.3L131.6 363C129.3 365.3 128 368.5 128 371.7C128 378.5 133.5 384 140.3 384H499.7C506.5 384 512 378.5 512 371.7C512 368.5 510.7 365.3 508.4 363L505.7 360.3C468.7 323.4 448 273.3 448 221.1V191.1C448 121.3 390.7 63.1 319.1 63.1H320zM320 480C333.9 480 345.8 471.1 350.2 458.7C353.1 450.3 362.3 445.1 370.6 448.9C378.9 451.9 383.3 461 380.4 469.3C371.6 494.2 347.9 512 320 512C292.1 512 268.4 494.2 259.6 469.3C256.7 461 261.1 451.9 269.4 448.9C277.7 445.1 286.9 450.3 289.8 458.7C294.2 471.1 306.1 480 320 480zM0 175.1C0 167.2 7.164 159.1 16 159.1H96C104.8 159.1 112 167.2 112 175.1C112 184.8 104.8 191.1 96 191.1H16C7.164 191.1 0 184.8 0 175.1zM624 159.1C632.8 159.1 640 167.2 640 175.1C640 184.8 632.8 191.1 624 191.1H544C535.2 191.1 528 184.8 528 175.1C528 167.2 535.2 159.1 544 159.1H624zM40.84 30.31C32.94 26.36 29.74 16.75 33.69 8.844C37.64 .9405 47.25-2.263 55.16 1.689L119.2 33.69C127.1 37.64 130.3 47.25 126.3 55.15C122.4 63.06 112.7 66.26 104.8 62.31L40.84 30.31z"],
    "bell-plus": [448, 512, [], "f849", "M223.1 160C232.8 160 240 167.2 240 176V224H288C296.8 224 304 231.2 304 240C304 248.8 296.8 256 288 256H240V304C240 312.8 232.8 320 223.1 320C215.2 320 207.1 312.8 207.1 304V256H159.1C151.2 256 143.1 248.8 143.1 240C143.1 231.2 151.2 224 159.1 224H207.1V176C207.1 167.2 215.2 160 223.1 160zM207.1 16C207.1 7.164 215.2 0 223.1 0C232.8 0 240 7.164 240 16V32.79C320.9 40.82 384 109 384 192V221.1C384 264.8 401.4 306.7 432.3 337.7L435 340.4C443.3 348.7 448 359.1 448 371.7C448 396.2 428.2 416 403.7 416H44.28C19.83 416 0 396.2 0 371.7C0 359.1 4.666 348.7 12.97 340.4L15.72 337.7C46.63 306.7 64 264.8 64 221.1V192C64 109 127.1 40.82 208 32.79L207.1 16zM223.1 64C153.3 64 95.1 121.3 95.1 192V221.1C95.1 273.3 75.26 323.4 38.35 360.3L35.6 363C33.29 365.3 31.1 368.5 31.1 371.7C31.1 378.5 37.5 384 44.28 384H403.7C410.5 384 416 378.5 416 371.7C416 368.5 414.7 365.3 412.4 363L409.7 360.3C372.7 323.4 352 273.3 352 221.1V192C352 121.3 294.7 64 223.1 64H223.1zM223.1 480C237.9 480 249.8 471.1 254.2 458.7C257.1 450.3 266.3 445.1 274.6 448.9C282.9 451.9 287.3 461 284.4 469.3C275.6 494.2 251.9 512 223.1 512C196.1 512 172.4 494.2 163.6 469.3C160.7 461 165.1 451.9 173.4 448.9C181.7 445.1 190.9 450.3 193.8 458.7C198.2 471.1 210.1 480 223.1 480z"],
    "bell-school": [512, 512, [], "f5d5", "M288 208C288 252.2 252.2 288 208 288C163.8 288 128 252.2 128 208C128 163.8 163.8 128 208 128C252.2 128 288 163.8 288 208zM208 160C181.5 160 160 181.5 160 208C160 234.5 181.5 256 208 256C234.5 256 256 234.5 256 208C256 181.5 234.5 160 208 160zM128 512C92.65 512 64 483.3 64 448V358.1C24.55 320.2 0 266.1 0 208C0 93.12 93.12 0 208 0C322.9 0 416 93.12 416 208C416 266.1 391.4 320.2 352 358.1V448C352 459.7 348.9 470.6 343.4 480H416C433.7 480 448 465.7 448 448V445.3C429.4 438.7 416 420.9 416 400C416 373.5 437.5 352 464 352C490.5 352 512 373.5 512 400C512 420.9 498.6 438.7 480 445.3V448C480 483.3 451.3 512 416 512H128zM208 384C305.2 384 384 305.2 384 208C384 110.8 305.2 32 208 32C110.8 32 32 110.8 32 208C32 305.2 110.8 384 208 384zM96 383.3V448C96 465.7 110.3 480 128 480H288C305.7 480 320 465.7 320 448V383.3C287.7 404 249.2 416 208 416C166.8 416 128.3 404 96 383.3zM464 416C472.8 416 480 408.8 480 400C480 391.2 472.8 384 464 384C455.2 384 448 391.2 448 400C448 408.8 455.2 416 464 416z"],
    "bell-school-slash": [640, 512, [], "f5d6", "M480 208C480 236.4 474.3 263.5 463.1 288.1L437.7 267.4C444.4 248.8 447.1 228.8 447.1 208C447.1 110.8 369.2 32 271.1 32C236.5 32 203.4 42.52 175.8 60.6L149.5 39.87C183.9 14.8 226.2 0 271.1 0C386.9 0 479.1 93.12 479.1 208H480zM271.1 384C301.4 384 329.2 376.8 353.5 364L380.6 385.4C349 404.8 311.8 416 271.1 416C230.8 416 192.3 404 159.1 383.3V448C159.1 465.7 174.3 480 191.1 480H352C369.7 480 384 465.7 384 448V388.1L416 413.3V448C416 459.7 412.9 470.6 407.4 480H480C485.6 480 490.9 478.6 495.4 476L521.6 496.7C510.4 506.2 495.9 512 480 512H191.1C156.7 512 127.1 483.3 127.1 448V358.1C88.55 320.2 63.1 266.1 63.1 208C63.1 185.5 67.58 163.8 74.2 143.5L101.3 164.9C97.84 178.7 95.1 193.1 95.1 208C95.1 305.2 174.8 384 271.1 384H271.1zM271.1 128C313.3 128 347.2 159.2 351.5 199.4L261.9 128.6C265.2 128.2 268.6 128 271.1 128H271.1zM633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.087C8.918-.849 18.98-2.033 25.91 3.443L633.9 483.4z"],
    "bell-slash": [640, 512, [61943, 128277], "f1f6", "M378.8 384L419.4 416H140.3C115.8 416 95.1 396.2 95.1 371.7C95.1 359.1 100.7 348.7 108.1 340.4L111.7 337.7C142.6 306.7 159.1 264.8 159.1 221.1V211.2L191.4 236C187.9 282.8 167.7 326.9 134.3 360.3L131.6 363C129.3 365.3 127.1 368.5 127.1 371.7C127.1 378.5 133.5 384 140.3 384H378.8zM303.1 16C303.1 7.164 311.2 0 319.1 0C328.8 0 336 7.164 336 16V32.79C416.9 40.82 480 109 480 192V221.1C480 264.8 497.4 306.7 528.3 337.7L531 340.4C531.8 341.2 532.6 342 533.3 342.9L458.2 283.5C451.5 263.6 448 242.5 448 221.1V191.1C448 121.3 390.7 63.1 319.1 63.1C284.2 63.1 251.9 78.68 228.6 102.3L203.4 82.42C229.2 55.03 264.5 36.71 303.1 32.79L303.1 16zM319.1 480C333.9 480 345.8 471.1 350.2 458.7C353.1 450.3 362.3 445.1 370.6 448.9C378.9 451.9 383.3 461 380.4 469.3C371.6 494.2 347.9 512 319.1 512C292.1 512 268.4 494.2 259.6 469.3C256.7 461 261.1 451.9 269.4 448.9C277.7 445.1 286.9 450.3 289.8 458.7C294.2 471.1 306.1 480 319.1 480zM633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.087C8.918-.849 18.98-2.033 25.91 3.443L633.9 483.4z"],
    "bells": [640, 512, [], "f77f", "M282.6 40.08C287.4 41.82 292.1 43.82 296.5 46.04C286.3 52.77 276.9 60.51 268.6 69.07C217.4 52.23 161.6 78.99 142.9 129.1L128.2 169.1C111.7 215.2 80.92 253.9 40.58 280.4L32.41 285.8L258.4 368C257.5 377.4 255.7 386.6 253.1 395.8L251.9 399.7L21.4 315.8C10.03 311.7 1.976 301.5 .5931 289.5C-.7903 277.5 4.729 265.7 14.86 259L23.04 253.7C57.61 230.1 83.95 197.8 98.16 159L112.8 119C137.1 50.44 213.1 15.09 282.6 40.08V40.08zM519.3 140.5L538 191.7C552 229.9 577.8 262.7 611.6 285.3L625.4 294.5C635.4 301.2 640.8 312.1 639.4 324.9C637.9 336.9 629.9 346.1 618.6 351.1L321.1 459.4C309.8 463.5 297.1 460.9 288.3 452.7C279.5 444.5 276 432 279.3 420.5L283.9 404.6C295.1 365.6 293.6 323.1 279.6 285.8L260.8 234.6C234.7 163.3 271.4 84.41 342.8 58.43C414.1 32.46 493.2 69.21 519.3 140.5H519.3zM309.7 274.8C326 319.4 327.7 367.9 314.7 413.5L310.1 429.3L607.6 321.1L593.8 311.9C554.4 285.4 524.3 247.2 507.1 202.6L489.2 151.5C469.2 96.75 408.5 68.55 353.8 88.48C299 108.4 270.9 168.9 290.9 223.6L309.7 274.8zM434.8 437.6C441.5 431.8 451.6 432.5 457.4 439.2C466 449.2 480.3 453.1 493.3 448C506.2 442.9 514 430.3 513.5 417.1C513.2 408.3 520.1 400.9 528.1 400.5C537.8 400.2 545.2 407.1 545.5 415.1C546.4 442.3 530.9 467.6 504.1 477.8C479 487.1 450.5 480.1 433.2 460.2C427.4 453.5 428.1 443.4 434.8 437.6H434.8zM179.9 406.7C185.7 400 195.8 399.3 202.5 405.1C209.1 410.9 209.8 420.1 204.1 427.6C186.8 447.5 158.2 455.5 132.3 445.2C106.3 435 90.8 409.8 91.73 383.4C92.04 374.6 99.45 367.7 108.3 368C117.1 368.3 124 375.7 123.7 384.6C123.2 397.8 131 410.4 143.1 415.5C156.9 420.6 171.2 416.6 179.9 406.7H179.9z"],
    "bench-tree": [640, 512, [], "e2e7", "M368 368H320V320c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32H64C46.33 192 32 206.3 32 224v64c0 17.67 14.33 32 32 32v48H16C7.156 368 0 375.2 0 384s7.156 16 16 16H32v96C32 504.8 39.16 512 48 512S64 504.8 64 496v-96h256v96c0 8.844 7.156 16 16 16s16-7.156 16-16v-96h16c8.844 0 16-7.156 16-16S376.8 368 368 368zM288 368H96V320h192V368zM64 288V224h256v64H64zM606.5 111.1C607.3 106.2 608 101.2 608 96c0-53.02-42.98-96-96-96s-96 42.98-96 96c0 5.174 .7363 10.15 1.523 15.11C397.3 125.6 384 149.2 384 176C384 220.2 419.8 256 464 256h32v232c0 8.844 7.156 16 16 16s16-7.156 16-16V256h32C604.2 256 640 220.2 640 176C640 149.2 626.7 125.6 606.5 111.1zM560 224h-32V96c0-8.844-7.156-16-16-16S496 87.16 496 96v128h-32C437.5 224 416 202.5 416 176c0-15.52 7.355-29.69 20.18-38.9c9.836-7.059 14.85-19.06 12.95-31.02C448.5 102.2 448 98.77 448 96c0-35.29 28.71-64 64-64s64 28.71 64 64c0 2.766-.5098 6.203-1.127 10.08c-1.9 11.96 3.109 23.96 12.95 31.02C600.6 146.3 608 160.5 608 176C608 202.5 586.5 224 560 224z"],
    "bezier-curve": [640, 512, [], "f55b", "M544 320L560 320C586.5 320 608 341.5 608 368V432C608 458.5 586.5 480 560 480H496C469.5 480 448 458.5 448 432V368C448 341.5 469.5 320 496 320L512 320C512 242.5 466.1 175.7 399.1 145.4C399.2 171.3 378 192 352 192H288C261.1 192 240.8 171.3 240 145.4C173.9 175.7 128 242.5 128 320L144 320C170.5 320 192 341.5 192 368V432C192 458.5 170.5 480 144 480H80C53.49 480 32 458.5 32 432V368C32 341.5 53.49 320 80 320L96 320C96 238.5 139.5 167.2 204.6 128H125.1C118.9 155.6 93.82 176 64 176C28.65 176 0 147.3 0 112C0 76.65 28.65 48 64 48C93.82 48 118.9 68.4 125.1 96H240V80C240 53.49 261.5 32 288 32H352C378.5 32 400 53.49 400 80V96H514C521.1 68.4 546.2 48 576 48C611.3 48 640 76.65 640 112C640 147.3 611.3 176 576 176C546.2 176 521.1 155.6 514 128H435.4C500.5 167.2 544 238.5 544 320zM352 64H288C279.2 64 272 71.16 272 80V144C272 152.8 279.2 160 288 160H352C360.8 160 368 152.8 368 144V80C368 71.16 360.8 64 352 64zM496 352C487.2 352 480 359.2 480 368V432C480 440.8 487.2 448 496 448H560C568.8 448 576 440.8 576 432V368C576 359.2 568.8 352 560 352H496zM80 352C71.16 352 64 359.2 64 368V432C64 440.8 71.16 448 80 448H144C152.8 448 160 440.8 160 432V368C160 359.2 152.8 352 144 352H80zM64 80C46.33 80 32 94.33 32 112C32 129.7 46.33 144 64 144C81.67 144 96 129.7 96 112C96 94.33 81.67 80 64 80zM576 80C558.3 80 544 94.33 544 112C544 129.7 558.3 144 576 144C593.7 144 608 129.7 608 112C608 94.33 593.7 80 576 80z"],
    "bicycle": [640, 512, [128690], "f206", "M347.2 32C356.1 32 364.3 36.94 368.4 44.82L466.1 232.1C480.1 226.9 496.2 224 512 224C582.7 224 640 281.3 640 352C640 422.7 582.7 480 512 480C441.3 480 384 422.7 384 352C384 308.6 405.6 270.2 438.7 247.1L417.5 206.7L334 359.7C331.2 364.8 325.9 368 320 368H255C247.1 431.1 193.3 480 128 480C57.31 480 0 422.7 0 352C0 281.3 57.31 223.1 128 223.1C142.9 223.1 157.2 226.5 170.5 231.2L197 178.2L166.9 128H112C103.2 128 96 120.8 96 112C96 103.2 103.2 96 112 96H176C181.6 96 186.8 98.95 189.7 103.8L223.5 160H392.9L342.3 64H304C295.2 64 288 56.84 288 48C288 39.16 295.2 32 304 32H347.2zM416 352C416 405 458.1 448 512 448C565 448 608 405 608 352C608 298.1 565 256 512 256C501.5 256 491.5 257.7 482.1 260.8L526.2 344.5C530.3 352.4 527.3 362 519.5 366.2C511.6 370.3 501.1 367.3 497.8 359.5L453.8 275.7C430.8 293.2 416 320.9 416 352V352zM156 260.2C147.2 257.5 137.8 256 127.1 256C74.98 256 31.1 298.1 31.1 352C31.1 405 74.98 448 127.1 448C175.6 448 215.1 413.4 222.7 368H133.2C118.9 368 109.6 352.1 116 340.2L156 260.2zM291.7 336L216.5 210.7L153.9 336H291.7zM242.7 192L319.3 319.8L389 192H242.7z"],
    "binary": [384, 512, [], "e33b", "M320 192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H240C231.2 224 224 216.8 224 208C224 199.2 231.2 192 240 192H288V38.2L261.1 47.18C252.7 49.97 243.6 45.44 240.8 37.06C238 28.68 242.6 19.62 250.9 16.82L298.9 .8212C303.8-.8051 309.2 .0128 313.4 3.02C317.5 6.028 320 10.86 320 16V192zM96 480H144C152.8 480 160 487.2 160 496C160 504.8 152.8 512 144 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H64V326.2L37.06 335.2C28.68 337.1 19.62 333.4 16.82 325.1C14.03 316.7 18.56 307.6 26.94 304.8L74.94 288.8C79.82 287.2 85.18 288 89.36 291C93.53 294 95.1 298.9 95.1 304L96 480zM0 80C0 35.82 35.82 .0004 80 .0004H112C156.2 .0004 192 35.82 192 80V144C192 188.2 156.2 224 112 224H80C35.82 224 0 188.2 0 144V80zM80 32C53.49 32 32 53.49 32 80V144C32 170.5 53.49 192 80 192H112C138.5 192 160 170.5 160 144V80C160 53.49 138.5 32 112 32H80zM304 288C348.2 288 384 323.8 384 368V432C384 476.2 348.2 512 304 512H272C227.8 512 192 476.2 192 432V368C192 323.8 227.8 288 272 288H304zM224 432C224 458.5 245.5 480 272 480H304C330.5 480 352 458.5 352 432V368C352 341.5 330.5 320 304 320H272C245.5 320 224 341.5 224 368V432z"],
    "binary-circle-check": [640, 512, [], "e33c", "M320 192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H240C231.2 224 224 216.8 224 208C224 199.2 231.2 192 240 192H288V38.2L261.1 47.18C252.7 49.97 243.6 45.44 240.8 37.06C238 28.68 242.6 19.62 250.9 16.82L298.9 .8212C303.8-.8051 309.2 .0128 313.4 3.02C317.5 6.028 320 10.86 320 16V192zM96 480H144C152.8 480 160 487.2 160 496C160 504.8 152.8 512 144 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H64V326.2L37.06 335.2C28.68 337.1 19.62 333.4 16.82 325.1C14.03 316.7 18.56 307.6 26.94 304.8L74.94 288.8C79.82 287.2 85.18 288 89.36 291C93.53 294 95.1 298.9 95.1 304L96 480zM0 80C0 35.82 35.82 .0004 80 .0004H112C156.2 .0004 192 35.82 192 80V144C192 188.2 156.2 224 112 224H80C35.82 224 0 188.2 0 144V80zM80 32C53.49 32 32 53.49 32 80V144C32 170.5 53.49 192 80 192H112C138.5 192 160 170.5 160 144V80C160 53.49 138.5 32 112 32H80zM304 288C312.5 288 320.8 289.3 328.5 291.8C324.1 301.5 320.5 311.6 317.8 322C313.4 320.7 308.8 320 304 320H272C245.5 320 224 341.5 224 368V432C224 458.5 245.5 480 272 480H304C317.1 480 330.5 474 339.3 464.5C344.1 473.7 351.5 482.4 358.6 490.4C344.3 503.8 325.1 512 304 512H272C227.8 512 192 476.2 192 432V368C192 323.8 227.8 288 272 288H304zM563.3 324.7C569.6 330.9 569.6 341.1 563.3 347.3L491.3 419.3C485.1 425.6 474.9 425.6 468.7 419.3L428.7 379.3C422.4 373.1 422.4 362.9 428.7 356.7C434.9 350.4 445.1 350.4 451.3 356.7L480 385.4L540.7 324.7C546.9 318.4 557.1 318.4 563.3 324.7H563.3zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "binary-lock": [640, 512, [], "e33d", "M313.4 3.021C317.5 6.028 320 10.86 320 16V192H368C376.8 192 384 199.2 384 208C384 216.8 376.8 224 368 224H240C231.2 224 224 216.8 224 208C224 199.2 231.2 192 240 192H288V38.2L261.1 47.18C252.7 49.97 243.6 45.44 240.8 37.06C238 28.68 242.6 19.62 250.9 16.82L298.9 .8212C303.8-.8051 309.2 .0128 313.4 3.02V3.021zM89.36 291C93.53 294 96 298.9 96 304V480H144C152.8 480 160 487.2 160 496C160 504.8 152.8 512 144 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H64V326.2L37.06 335.2C28.68 337.1 19.62 333.4 16.82 325.1C14.03 316.7 18.56 307.6 26.94 304.8L74.94 288.8C79.82 287.2 85.18 288 89.36 291H89.36zM112 .0004C156.2 .0004 192 35.82 192 80V144C192 188.2 156.2 224 112 224H80C35.82 224 0 188.2 0 144V80C0 35.82 35.82 .0004 80 .0004H112zM32 144C32 170.5 53.49 192 80 192H112C138.5 192 160 170.5 160 144V80C160 53.49 138.5 32 112 32H80C53.49 32 32 53.49 32 80V144zM192 368C192 323.8 227.8 288 272 288H304C348.2 288 384 323.8 384 368V432C384 476.2 348.2 512 304 512H272C227.8 512 192 476.2 192 432V368zM272 320C245.5 320 224 341.5 224 368V432C224 458.5 245.5 480 272 480H304C330.5 480 352 458.5 352 432V368C352 341.5 330.5 320 304 320H272zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 224C501.5 224 480 245.5 480 272V320H576V272C576 245.5 554.5 224 528 224zM448 352V480H608V352H448z"],
    "binary-slash": [640, 512, [], "e33e", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM448 192H496C504.8 192 512 199.2 512 208C512 216.8 504.8 224 496 224H382.8L353.6 200.1C356.2 195.7 361.7 192 368 192H416V38.2L389.1 47.18C380.7 49.97 371.6 45.44 368.8 37.06C366 28.68 370.6 19.62 378.9 16.82L426.9 .8214C431.8-.8048 437.2 .0131 441.4 3.02C445.5 6.028 448 10.86 448 16L448 192zM319.1 144C319.1 153.4 318.4 162.4 315.4 170.8L287.7 148.1C287.9 147.4 288 145.7 288 144V80C288 53.49 266.5 32 240 32H208C191 32 176.1 40.82 167.6 54.12L142.4 34.23C156.8 13.54 180.8 .0006 208 .0006H240C284.2 .0006 320 35.82 320 80L319.1 144zM319.1 368C319.1 358.6 321.6 349.6 324.6 341.2L352.3 363C352.1 364.6 352 366.3 352 368V432C352 458.5 373.5 480 400 480H432C448.1 480 463.9 471.2 472.4 457.9L497.6 477.8C483.2 498.5 459.2 512 432 512H400C355.8 512 319.1 476.2 319.1 432V368zM223.1 480H271.1C280.8 480 287.1 487.2 287.1 496C287.1 504.8 280.8 512 271.1 512H143.1C135.2 512 127.1 504.8 127.1 496C127.1 487.2 135.2 480 143.1 480H191.1V326.2L165.1 335.2C156.7 337.1 147.6 333.4 144.8 325.1C142 316.7 146.6 307.6 154.9 304.8L202.9 288.8C207.8 287.2 213.2 288 217.4 291C221.5 294 223.1 298.9 223.1 304L223.1 480z"],
    "binoculars": [512, 512, [], "f1e5", "M112 64h96C216.8 64 224 56.84 224 48S216.8 32 208 32h-96C103.2 32 96 39.16 96 48S103.2 64 112 64zM304 64h96C408.8 64 416 56.84 416 48S408.8 32 400 32h-96C295.2 32 288 39.16 288 48S295.2 64 304 64zM511.6 404c-3.375-129.8-61-182.1-63.5-276c-.5-17.62-14.46-32-32.08-32H95.96c-17.62 0-31.58 14.38-32.08 32c-2.5 93.88-60.13 146.3-63.5 276L0 432C0 458.5 21.5 480 48 480h128C202.5 480 224 458.5 224 432V288h64v144c0 26.5 21.5 48 48 48h128c26.5 0 48-21.5 48-48L511.6 404zM192 432C192 440.8 184.8 448 176 448h-128c-8.822 0-16-7.178-16-15.57l.3672-27.6c1.686-64.81 17.99-108.7 33.76-151C80.11 216.2 94.57 177.3 95.88 128H192V432zM288 256H224V128h64V256zM464 448h-128c-8.822 0-16-7.178-16-16V128h96.13l.0098 .6924c1.291 48.45 15.76 87.49 29.74 125.1c15.77 42.39 32.07 86.23 33.75 150.6L480 432C480 440.8 472.8 448 464 448z"],
    "biohazard": [576, 512, [9763], "f780", "M288 248c-13.31 0-24 10.69-24 24c0 13.22 10.69 24 24 24s24-10.78 24-24C312 258.7 301.3 248 288 248zM288.2 95.99c17.62 0 34.75 2.75 50.87 7.623c6.5-8.498 11.12-18.37 13.12-29.37C331.9 67.75 310.3 63.94 288.1 63.94c-22.37 0-43.9 3.809-64.15 10.31c1.875 10.1 6.625 20.99 13.12 29.49C253.3 98.74 270.3 95.99 288.2 95.99zM407.4 401c5.5 9.123 12.88 17.12 22.5 22.74c32.75-30.49 55.37-71.36 63.12-117.3c-9.375-5.123-19.75-7.998-30.25-7.998c-.25 0-.5 .125-.875 .125C455.8 338.7 436 374.5 407.4 401zM574.8 276.6c-13.88-40.36-41.25-74.11-77.24-95.35c-12.25-7.123-25.62-12.75-40.12-16.62c3.5-13.87 5.25-27.37 5.25-40.86c0-42.11-15.12-83.1-42.37-115.5c-7.375-8.498-19.75-10.87-29.75-5.123c-9.748 5.623-14.12 17.37-10.62 27.87c3.748 11.25 5.498 21.49 5.498 31.12c0 54.61-43.62 99.22-97.24 99.22c-53.75 0-97.37-44.49-97.37-99.22c0-9.623 1.875-19.87 5.5-30.99c3.5-10.75-1-22.49-10.75-27.99c-9.748-5.623-22.25-3.5-29.62 5.123c-27.37 32.37-42.5 73.35-42.5 115.5c0 13.5 1.75 26.99 5.25 40.86C104.2 168.6 90.79 174.2 78.54 181.2c-35.1 21.12-63.37 54.98-77.24 95.35c-3.625 10.62 .5 22.12 10.25 28.12c9.75 5.75 22.25 3.75 29.75-4.873c7.625-8.748 15.37-15.5 23.5-20.24C87.17 266.4 113.2 262.9 138 269.7c25.25 6.748 46.37 23.12 59.5 46.11c26.87 47.49 10.87 108.3-35.75 135.8C153.7 456.4 144.2 459.9 132.8 462.3c-10.1 2.375-18.75 12.12-18.62 23.37s8.125 20.99 19.12 23.12C144.3 510.9 155.3 512 166.3 512c30.5 0 60.5-7.998 86.99-23.62c12.5-7.246 23.1-16.49 34.62-27.24c10.75 10.87 22.37 19.1 34.75 27.24c35.1 21.24 78.62 28.49 119.9 20.37c11.12-2.123 18.87-11.62 19.12-23.12c.125-11.25-7.873-20.99-18.75-23.37c-11.38-2.373-20.75-5.873-28.1-10.62c-46.62-27.49-62.62-88.35-35.62-135.8c12.1-22.99 34.12-39.36 59.49-46.11c24.87-6.748 50.87-3.25 73.12 9.871c8.25 4.748 15.88 11.37 23.62 20.24c7.5 8.623 20 10.5 29.75 4.748C574.3 298.7 578.3 287.2 574.8 276.6zM429.6 238.7c-33.75 8.998-61.75 30.87-78.99 61.36c-35.62 62.61-14.38 142.1 47.12 179.1c.25 0 .375 .125 .5 .125c-20.87-1.625-41.12-7.998-59.37-18.62c-14.12-8.373-26.1-19.75-38.37-33.87l-12.5-15.37l-12.5 15.49c-11.38 14.12-24.25 25.49-38.37 33.74c-18.25 10.75-38.5 16.99-59.37 18.74c.125-.125 .375-.25 .5-.25c61.49-36.12 82.74-116.5 47.25-178.9C208.3 269.7 180.2 247.8 146.4 238.8c-11-2.998-22.12-4.373-33.12-4.373c-22.37 0-44.37 5.873-64.12 17.37c11.87-17.49 27.37-32.12 45.62-42.86C108.7 200.8 123.9 195.3 141.7 192.2l18.5-3.125L154 171.2C148.3 154.6 145.4 139.1 145.4 123.7c0-20.99 4.625-41.86 13.37-60.86c.375 71.98 58.12 130.5 129.2 130.5c70.99 0 128.9-58.48 129.2-130.5c8.75 18.99 13.38 39.86 13.38 60.86c0 15.25-2.875 30.74-8.5 47.49l-6.125 17.74l18.5 3.25c17.75 3 32.1 8.498 46.87 16.62c18.25 10.75 33.75 25.37 45.62 42.86C497.3 234.6 462.8 229.8 429.6 238.7zM168.8 400.8c-28.5-26.37-48.25-62.11-54.5-102.3c-.375 0-.75-.25-1.125-.25c-10.37 0-20.75 3-29.1 7.998c7.625 45.99 30.37 86.85 62.1 117.3C155.8 417.9 163.3 409.9 168.8 400.8z"],
    "bird": [512, 512, [], "e469", "M304 120C304 106.7 314.7 96 328 96C341.3 96 352 106.7 352 120C352 133.3 341.3 144 328 144C314.7 144 304 133.3 304 120zM28.44 160H192C209.7 160 224 145.7 224 128V104C224 46.56 270.6 0 328 0C372.3 0 410.2 27.75 425.2 66.84L504.2 114.3C509.1 117.2 512 122.4 512 128C512 133.6 509.1 138.8 504.2 141.7L432 185.1V200C432 288.6 378.6 364.8 302.3 398.1L350.1 488.5C354.3 496.3 351.3 506 343.5 510.1C335.7 514.3 325.1 511.3 321.9 503.5L271.7 408.7C253.9 413.5 235.3 416 216 416H215.8L254.1 488.5C258.3 496.3 255.3 506 247.5 510.1C239.7 514.3 229.1 511.3 225.9 503.5L177.8 412.6C76.7 394.6 0 306.2 0 200V188.4C0 172.7 12.74 160 28.44 160L28.44 160zM32 192V200C32 301.6 114.4 384 216 384C317.6 384 400 301.6 400 200V104C400 64.24 367.8 32 328 32C288.2 32 256 64.24 256 104V128C256 163.3 227.3 192 192 192H32zM432 108.3V147.7L464.9 128L432 108.3z"],
    "bitcoin-sign": [320, 512, [], "e0b4", "M64 16C64 7.164 71.16 0 80 0C88.84 0 96 7.164 96 16V64H160V16C160 7.164 167.2 0 176 0C184.8 0 192 7.164 192 16V64.3C245.7 68.39 288 113.3 288 168C288 199.3 274.1 227.4 252.2 246.5C291.8 261.2 320 299.3 320 344C320 401.4 273.4 448 216 448H192V496C192 504.8 184.8 512 176 512C167.2 512 160 504.8 160 496V448H96V496C96 504.8 88.84 512 80 512C71.16 512 64 504.8 64 496V448H41.74C18.69 448 0 429.3 0 406.3V101.6C0 80.82 16.82 64 37.57 64H64V16zM216 416C255.8 416 288 383.8 288 344C288 304.2 255.8 272 216 272H32V406.3C32 411.6 36.36 416 41.74 416H216zM37.57 96C34.49 96 32 98.49 32 101.6V240H184C223.8 240 256 207.8 256 168C256 128.2 223.8 96 184 96H37.57z"],
    "blanket": [448, 512, [], "f498", "M392 368H96c-8.844 0-16 7.156-16 16s7.156 16 16 16h296c30.88 0 56-25.12 56-56V112C448 67.89 412.1 32 368 32h-288C35.88 32 0 67.89 0 112V384c0 52.94 43.06 96 96 96h336c8.844 0 16-7.156 16-16S440.8 448 432 448H96c-35.28 0-64-28.7-64-64s28.72-64 64-64h296c13.22 0 24 10.77 24 24S405.2 368 392 368zM392 288H96C71.32 288 49.02 297.6 32 312.1V112C32 85.53 53.53 64 80 64h288C394.5 64 416 85.53 416 112v181.6C408.7 290.1 400.6 288 392 288z"],
    "blanket-fire": [640, 512, [], "e3da", "M272 224h-160C80.64 224 52.48 236.9 32 257.6V80C32 53.5 53.44 32 80 32h296C398.1 32 416 49.92 416 72c0 8.832 7.039 16 16 16S448 80.83 448 72C448 32.22 415.7 0 376 0H80C35.84 0 0 35.81 0 80v256C0 397.9 50.24 448 112 448H256c8.961 0 16-7.168 16-16S264.1 416 256 416H112C67.84 416 32 380.2 32 336S67.84 256 112 256h160C280.1 256 288 248.8 288 240S280.1 224 272 224zM613.4 240.6c-16.32-32.35-39.36-66.43-66.56-92.22c-6.078-5.824-15.68-5.857-21.76-.0332C514.6 158.3 504.6 170.7 496 181.9c-19.2-23.58-39.36-45.41-61.12-65.6c-6.078-5.695-15.68-5.727-21.76-.0313c-36.48 33.73-67.52 72.06-89.6 108.8C302.1 261.4 288 298 288 328C288 427.7 365.4 512 464 512c97.6 0 176-84.19 176-184C640 305.1 629.4 272.5 613.4 240.6zM464 480c-79.36 0-144-68.22-144-152c0-21.44 10.56-52.03 31.04-86.5C369.3 211.1 394.2 179.2 424 150.1c21.12 20.71 40.96 43.14 59.2 67.52C486.1 221.6 490.9 223.9 495.7 224c5.121 .0645 9.922-2.176 12.8-6.049C512 213.8 515.2 209.5 518.4 205.3C524.2 197.6 529.9 190 536 183C555.2 204 572.2 229.8 584.1 254.9C600 285.4 608 312.6 608 328C608 411.7 542.4 480 464 480zM112 320C103 320 96 327.2 96 336S103 352 112 352h128C248.1 352 256 344.8 256 336S248.1 320 240 320H112zM548.2 313.5c-1.922-3.84-4.48-8.928-8.32-14.11c-2.879-3.873-7.359-6.24-12.16-6.369c-5.121-.1602-9.602 1.889-12.8 5.568l-23.36 27.17l-17.28-22.27c-15.04-19.04-30.72-38.91-32.64-41.47C438.4 258.2 433.9 256 429.1 256s-9.602 2.176-12.48 5.92c-15.04 18.4-26.88 33.79-35.2 47.9C373.1 324.3 368 338.3 368 353.1c0 28.67 10.56 52.58 28.8 69.18C414.7 439.6 439 448 464.1 448c21.44 0 40.32-5.984 57.92-17.7l.3203-.1934c37.12-26.11 46.4-77.15 24.96-116.5V313.5zM504.1 403.8C492.5 412 479.7 416 464.1 416c-19.2 0-35.2-6.145-46.4-16.45C407.4 389.4 400 374.3 400 353.1c0-8.289 2.559-16.74 8.961-28.06c4.801-8.096 11.2-17.15 19.84-28.16l20.16 25.5l20.48 25.95l6.398 8.479l1.922 2.336l.6367 .6406v.1914c2.883 3.777 7.363 6.018 12.16 6.145c4.801 .0957 9.602-1.951 12.48-5.6l20.8-24.13C532.8 361.1 525.1 389.6 504.1 403.8z"],
    "blender": [512, 512, [], "f517", "M288 400c-13.25 0-24 10.75-24 24S274.8 448 288 448s24-10.75 24-24S301.3 400 288 400zM470.6 0H48C21.49 0 0 21.49 0 48v160C0 234.5 21.49 256 48 256h102.3l7.5 86.5C121.8 356.4 96 391.1 96 432L96 480c0 17.6 14.4 32 32 32h320c17.6 0 32-14.4 32-32L480 432c0-39.38-23.75-73.13-57.75-88l79.29-303.9C506.8 19.8 491.5 0 470.6 0zM48 224C39.25 224 32 216.9 32 208v-160C32 39.13 39.25 32 48 32h82.75L147.5 224H48zM448 432V480H128v-48c0-35.25 28.75-64 64-64h192C419.3 368 448 396.8 448 432zM453.9 96H304C295.2 96 288 103.2 288 111.1S295.2 128 304 128h141.5l-16.62 64H304C295.2 192 288 199.2 288 207.1S295.2 224 304 224h116.5l-29.25 112H189.4L162.9 32h307.8L453.9 96z"],
    "blender-phone": [576, 512, [], "f6b6", "M534.6 0H226.9C208.1 0 193.4 16.07 195 34.77l26.73 307.7c-36 13.88-61.75 48.63-61.75 89.5l.0088 47.1c0 17.6 14.4 31.1 31.1 31.1L511.1 512c17.6 0 32-14.4 32-31.1L543.1 432c0-39.38-23.75-73.13-57.75-88l79.29-303.9C570.8 19.8 555.5 0 534.6 0zM511.1 432V480h-320v-48c0-35.25 28.75-63.1 64-63.1h192C483.2 368 511.1 396.8 511.1 432zM517.9 96l-149.9 .0049c-8.801 0-16 7.199-16 16s7.199 15.1 16 15.1L509.5 128l-16.62 64l-124.9 .0039c-8.801 0-16 7.198-16 15.1s7.199 16 16 16L484.5 224l-29.25 112H253.4L226.9 32h307.8L517.9 96zM176.4 317.1l-23.62-58c-5.125-12.75-18-20.88-32.13-19.38l-28.5 2.875C82.37 209.6 82.37 174.5 91.99 141.5l28.62 2.875c13.75 1.375 27-6.625 32.13-19.38l23.75-58c5.625-14.12 .375-30.12-12.62-38l-36-22.12c-19.5-11.88-45-8-60.63 9.5c-90.5 101.3-89.5 253.4 2.125 353.6C77.62 379.1 90.37 384 103.1 384c8.625 0 17.25-2.25 24.62-6.75l36.13-22.12C176.9 347.1 182.1 331.1 176.4 317.1zM110.1 350c-5.25 3.25-14.38 2.5-18-1.5C12.37 260.3 11.62 126.6 91.12 37.63C94.49 34 98.99 32 103.4 32c2.75 0 5.375 .75 7.75 2.125L146.7 55l-23 57.5L70.12 107.3L65.87 118.9c-17.38 47.13-17.38 99.13 0 146.4l4.25 11.62l53-5.75l23.38 57.13L110.1 350zM351.1 400c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.2 400 351.1 400z"],
    "blinds": [512, 512, [], "f8fb", "M495.1 0H16c-8.836 0-15.1 7.164-15.1 16l.0065 64c0 8.836 7.162 16 15.1 16h111.1v96H36.51l11.03-44.12C50.06 137.8 42.42 128 32.01 128C24.67 128 18.26 133 16.48 140.1l-15.97 63.1C-2.021 213.7 5.16 224 16.01 224h111.1v35C114.4 263.8 103.8 274.4 99.01 288h-62.5l3.029-12.12C42.06 265.8 34.42 256 24.01 256C16.66 256 10.26 261 8.484 268.1L.5098 300.1C-2.021 309.7 5.16 320 16.01 320h82.1c9.051 25.92 38.62 39.8 65.6 27.54c10.08-4.58 18.35-12.85 22.93-22.93c12.26-26.99-1.611-56.56-27.54-65.61V96h335.1c8.836 0 16-7.164 16-16l.0052-64C511.1 7.164 504.8 0 495.1 0zM144 320c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S152.9 320 144 320zM479.1 64H32.01V32h447.1V64zM503.5 460.1C501.7 453 495.3 448 487.1 448c-10.41 0-18.05 9.783-15.52 19.88L475.5 480H36.51l3.029-12.12C42.06 457.8 34.42 448 24.01 448c-7.348 0-13.75 5.004-15.53 12.13l-7.975 31.99C-2.021 501.7 5.16 512 16.01 512h479.1c10.86 0 18.03-10.27 15.5-19.88L503.5 460.1zM503.5 364.1C501.7 357 495.3 352 487.1 352c-10.41 0-18.05 9.783-15.52 19.88L475.5 384H36.51l3.029-12.12C42.06 361.8 34.42 352 24.01 352c-7.348 0-13.75 5.004-15.53 12.13l-7.975 31.99C-2.021 405.7 5.155 416 16 416H495.1c10.86 0 18.02-10.27 15.49-19.88L503.5 364.1zM495.5 140.1C493.7 133 487.3 128 479.1 128c-10.41 0-18.05 9.783-15.53 19.88L475.5 192H192L192 224h303.1c10.86 0 18.03-10.27 15.5-19.88L495.5 140.1zM503.5 268.1C501.7 261 495.3 256 487.1 256c-10.41 0-18.05 9.783-15.53 19.88L475.5 288H222.4c2.125 10.5 2.125 21.5 0 32h273.6c10.86 0 18.03-10.27 15.5-19.88L503.5 268.1z"],
    "blinds-open": [512, 512, [], "f8fc", "M496 480h-480C7.125 480 0 487.1 0 496S7.125 512 16 512h480c8.875 0 16-7.125 16-16S504.9 480 496 480zM16 352h64.38c-7.25-9.375-12.25-20.38-14.75-32H16C7.125 320 0 327.1 0 336S7.125 352 16 352zM496 320H222.4c-2.5 11.62-7.5 22.62-14.75 32H496c8.875 0 16-7.125 16-16S504.9 320 496 320zM496 0h-480C7.125 0 0 7.125 0 16v64C0 88.88 7.125 96 16 96H128v64H16C7.125 160 0 167.1 0 176S7.125 192 16 192H128v67C105.1 266.8 92.75 289.2 96.75 312.2C100.6 335.4 120.6 352.1 144 352.1s43.38-16.75 47.25-39.88C195.2 289.2 181.1 266.8 160 259V96h336C504.9 96 512 88.88 512 80v-64C512 7.125 504.9 0 496 0zM144 320C135.1 320 128 312.9 128 304S135.1 288 144 288S160 295.1 160 304S152.9 320 144 320zM480 64H32V32h448V64zM496 160H192v32h304C504.9 192 512 184.9 512 176S504.9 160 496 160z"],
    "blinds-raised": [512, 512, [], "f8fd", "M495.1 0H16c-8.836 0-15.1 7.163-15.1 15.99l.0065 63.97c0 8.832 7.162 15.99 15.1 15.99h111.1L128 159.9l-91.49 .0573l3.029-12.11c2.525-10.1-5.118-19.84-15.53-19.84c-7.348 0-13.75 4.969-15.52 12.1L.5098 172c-2.531 9.615 4.65 19.87 15.5 19.87h111.1v63.97H36.51l3.029-12.11C42.06 233.7 34.42 223.9 24.01 223.9c-7.348 0-13.75 5-15.53 12.13L.5098 267.1C-2.021 277.6 5.16 287.9 16.01 287.9h111.1l-.0026 130.9c-21.1 7.746-35.25 30.25-31.25 53.24C100.6 495.1 120.6 512 144 512s43.38-16.87 47.25-39.98c4-22.99-9.25-45.48-31.25-53.22V95.95h335.1c8.836 0 16-7.16 16-15.99l.0052-63.97C511.1 7.163 504.8 0 495.1 0zM144 479.8c-8.875 0-16-7.121-16-15.99s7.125-15.99 16-15.99s16 7.121 16 15.99S152.9 479.8 144 479.8zM479.1 63.97H32.01V31.98h447.1V63.97zM503.5 236C501.7 228.9 495.3 223.9 487.1 223.9c-10.41 0-18.05 9.779-15.52 19.88l3.027 12.11H192l-.001 32.05l303.1-.0703c10.86 0 18.03-10.26 15.5-19.87L503.5 236zM503.5 140.1c-1.777-7.127-8.177-12.1-15.52-12.1c-10.41 0-18.05 9.748-15.53 19.84l3.027 12.11H192L192 191.1l303.1-.0469c10.86 0 18.03-10.26 15.5-19.87L503.5 140.1z"],
    "block": [448, 512, [], "e46a", "M112 120C112 133.3 101.3 144 88 144C74.75 144 64 133.3 64 120C64 106.7 74.75 96 88 96C101.3 96 112 106.7 112 120zM336 120C336 106.7 346.7 96 360 96C373.3 96 384 106.7 384 120C384 133.3 373.3 144 360 144C346.7 144 336 133.3 336 120zM112 392C112 405.3 101.3 416 88 416C74.75 416 64 405.3 64 392C64 378.7 74.75 368 88 368C101.3 368 112 378.7 112 392zM336 392C336 378.7 346.7 368 360 368C373.3 368 384 378.7 384 392C384 405.3 373.3 416 360 416C346.7 416 336 405.3 336 392zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V96C416 78.33 401.7 64 384 64z"],
    "block-brick": [448, 512, ["wall-brick"], "e3db", "M0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM136 128H312V64H136V128zM104 64H64C46.33 64 32 78.33 32 96V128H104V64zM32 160V240H208V160H32zM104 352V272H32V352H104zM32 384V416C32 433.7 46.33 448 64 448H208V384H32zM136 352H312V272H136V352zM416 352V272H344V352H416zM416 384H240V448H384C401.7 448 416 433.7 416 416V384zM240 160V240H416V160H240zM416 128V96C416 78.33 401.7 64 384 64H344V128H416z"],
    "block-brick-fire": [640, 512, ["firewall"], "e3dc", "M168 352H288C288.1 362.9 289.1 373.6 290.1 384H272V448H314.4C321 459.4 328.8 470.2 337.6 480H96C60.65 480 32 451.3 32 416V96C32 60.65 60.65 32 96 32H416C451.3 32 480 60.65 480 96V144.6C478.3 143 476.7 141.5 474.1 139.1C467.2 133 457.7 129.1 448 128.2V96C448 78.33 433.7 64 416 64H376V160H272V240H326.9C326.3 240.9 325.7 241.8 325.2 242.7C319.3 252.2 313.8 261.1 308.1 272H168V352zM168 128H344V64H168V128zM136 64H96C78.33 64 64 78.33 64 96V128H136V64zM64 160V240H240V160H64zM136 352V272H64V352H136zM64 384V416C64 433.7 78.33 448 96 448H240V384H64zM445.1 256C449.9 256 454.5 258.2 457.5 262C459.6 264.6 475.1 284.4 490.1 303.5L507.6 325.8L530.9 298.6C534 294.9 538.7 292.9 543.5 293C548.4 293.2 552.9 295.5 555.8 299.4C559.7 304.6 562.2 309.7 564.1 313.5L564.2 313.6C585.5 352.1 576.5 404 539.2 430.1L538.9 430.3C521.3 442 502.3 448 480.1 448C455.1 448 430.8 439.6 412.8 423.2C394.7 406.6 384 382.7 384 354C384 338.3 389 324.3 397.4 309.8C405.6 295.7 417.7 280.3 432.6 261.9C435.6 258.2 440.2 255.1 445.1 255.1V256zM539.8 337.3L519.1 361.4C516 365.1 511.4 367.1 506.6 366.1C501.9 366.9 497.4 364.6 494.4 360.9L444.9 297.8C436.3 308.8 429.8 317.8 425.1 325.9C418.5 337.2 416 345.7 416 354C416 374.3 423.3 389.4 434.4 399.6C445.7 409.9 461.9 416 481 416C495.7 416 508.6 412 520.1 403.8C541.1 389.6 548.8 361.1 539.8 337.3H539.8zM487.5 197.1C494.9 205 502.1 213.1 509 221.5C515.5 213.4 522.6 204.7 530.3 197C531.1 195.3 533.7 193.6 535.5 191.1C541.1 186.9 549.9 186.9 555.5 192C580.2 214.7 601.1 244.7 615.8 273.2C630.4 301.2 640 329.9 640 350.1C640 437.9 568.7 512 480 512C390.3 512 319.1 437.8 319.1 350.1C319.1 323.7 332.7 291.5 352.4 259.5C372.4 227.2 400.5 193.4 433.8 163.7C439.4 158.7 447.1 158.8 453.5 163.8C465.3 174.4 476.7 185.5 487.5 197.1V197.1zM509.4 253.5C499.8 253.6 490.6 249.4 484.4 241.1C471.6 226.5 457.1 211.9 443.6 198.2C417.6 223.2 395.6 250.5 379.6 276.3C361 306.4 352 332.5 352 350.1C352 420.9 408.7 480 480 480C550.4 480 608 420.8 608 350.1C608 337.7 601.2 314.5 587.4 287.9C576.5 266.8 562.1 245.3 545.6 227.4C541.8 231.8 537.1 236.5 534.1 241.4C528.1 248.9 519 253.4 509.4 253.5V253.5zM507 351L494.4 360.9z"],
    "block-question": [448, 512, [], "e3dd", "M192 160C174.3 160 160 174.3 160 192V200C160 208.8 152.8 216 144 216C135.2 216 128 208.8 128 200V192C128 156.7 156.7 128 192 128H256C291.3 128 320 156.7 320 192V196.8C320 219.3 308.2 240.1 288.9 251.7L240 281.1V296C240 304.8 232.8 312 224 312C215.2 312 208 304.8 208 296V272C208 266.4 210.9 261.2 215.8 258.3L272.5 224.3C282.1 218.5 287.1 208.1 287.1 196.8V192C287.1 174.3 273.7 160 255.1 160H192zM200 368C200 354.7 210.7 344 224 344C237.3 344 248 354.7 248 368C248 381.3 237.3 392 224 392C210.7 392 200 381.3 200 368zM112 120C112 133.3 101.3 144 88 144C74.75 144 64 133.3 64 120C64 106.7 74.75 96 88 96C101.3 96 112 106.7 112 120zM336 120C336 106.7 346.7 96 360 96C373.3 96 384 106.7 384 120C384 133.3 373.3 144 360 144C346.7 144 336 133.3 336 120zM112 392C112 405.3 101.3 416 88 416C74.75 416 64 405.3 64 392C64 378.7 74.75 368 88 368C101.3 368 112 378.7 112 392zM336 392C336 378.7 346.7 368 360 368C373.3 368 384 378.7 384 392C384 405.3 373.3 416 360 416C346.7 416 336 405.3 336 392zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V96C416 78.33 401.7 64 384 64z"],
    "block-quote": [448, 512, [], "e0b5", "M432 80C440.8 80 448 87.16 448 96C448 104.8 440.8 112 432 112H16C7.164 112 0 104.8 0 96C0 87.16 7.164 80 16 80H432zM432 240C440.8 240 448 247.2 448 256C448 264.8 440.8 272 432 272H144C135.2 272 128 264.8 128 256C128 247.2 135.2 240 144 240H432zM128 416C128 407.2 135.2 400 144 400H432C440.8 400 448 407.2 448 416C448 424.8 440.8 432 432 432H144C135.2 432 128 424.8 128 416zM0 240C0 231.2 7.164 224 16 224C24.84 224 32 231.2 32 240V432C32 440.8 24.84 448 16 448C7.164 448 0 440.8 0 432V240z"],
    "blog": [512, 512, [], "f781", "M160 224C151.2 224 144 231.2 144 240S151.2 256 160 256c52.94 0 96 43.06 96 96s-43.06 96-96 96s-96-43.06-96-96V112C64 103.2 56.84 96 48 96S32 103.2 32 112V352c0 70.58 57.41 128 128 128s128-57.42 128-128S230.6 224 160 224zM208 32C199.2 32 192 39.16 192 48S199.2 64 208 64C340.3 64 448 171.7 448 304c0 8.844 7.156 16 16 16S480 312.8 480 304C480 154 357.1 32 208 32zM208 128C199.2 128 192 135.2 192 144S199.2 160 208 160C287.4 160 352 224.6 352 304c0 8.844 7.156 16 16 16S384 312.8 384 304C384 206.1 305 128 208 128z"],
    "blueberries": [512, 512, [], "e2e8", "M176 160C78.8 160 0 238.8 0 336C0 433.2 78.8 512 176 512s176-78.8 176-176C352 238.8 273.2 160 176 160zM176 480C96.6 480 32 415.4 32 336S96.6 192 176 192S320 256.6 320 336S255.4 480 176 480zM336 0c-67.97 0-128.7 38.02-158.4 99.2C173.8 107.1 177.1 116.7 185 120.6c7.969 3.844 17.53 .5469 21.41-7.406C230.7 63.11 280.4 32 336 32C415.4 32 480 96.59 480 176c0 54.78-31.88 105.7-81.19 129.6c-7.938 3.859-11.25 13.44-7.406 21.38C394.2 332.7 399.9 336 405.8 336c2.344 0 4.75-.5156 7-1.609C473.1 305.1 512 242.1 512 176C512 78.95 433 0 336 0zM208 272h-32v-32C176 231.2 168.8 224 160 224S144 231.2 144 240v32h-32C103.2 272 96 279.2 96 288s7.156 16 16 16h32v32C144 344.8 151.2 352 160 352s16-7.156 16-16v-32h32C216.8 304 224 296.8 224 288S216.8 272 208 272zM416 128c0-8.844-7.156-16-16-16h-32v-32C368 71.16 360.8 64 352 64s-16 7.156-16 16v32h-32C295.2 112 288 119.2 288 128s7.156 16 16 16h32v32C336 184.8 343.2 192 352 192s16-7.156 16-16v-32h32C408.8 144 416 136.8 416 128z"],
    "bluetooth": [320, 512, [], "f293", "M184.1 255.1l129.3-107.7C317.9 145.2 320 140.7 320 135.1s-2.094-9.25-5.75-12.28l-144-120c-4.781-4.008-11.44-4.789-17.03-2.219c-5.625 2.656-9.221 8.281-9.221 14.5V221.8L26.24 123.7C19.49 118.1 9.4 118.1 3.713 125.7C-1.943 132.5-1.037 142.6 5.744 148.3l129.3 107.7l-129.3 107.7c-6.781 5.656-7.688 15.75-2.031 22.53s15.75 7.656 22.53 2.031l117.8-98.13V496c0 6.219 3.596 11.84 9.221 14.5C155.4 511.5 157.7 512 160 512c3.688 0 7.31-1.25 10.25-3.719l144-120C317.9 385.2 320 380.7 320 375.1s-2.094-9.25-5.75-12.28L184.1 255.1zM175.1 50.14l103 85.84L175.1 221.8V50.14zM175.1 461.8V290.1l103 85.84L175.1 461.8z"],
    "bold": [384, 512, [], "f032", "M314.7 251.7C346.8 230.1 368 193.5 368 152C368 85.84 314.2 32 248 32H16C7.156 32 0 39.16 0 48S7.156 64 16 64H32v384H16C7.156 448 0 455.2 0 464S7.156 480 16 480h248c66.17 0 120-53.84 120-120C384 312 355.5 270.8 314.7 251.7zM64 64h184c48.53 0 88 39.47 88 88S296.5 240 248 240H64V64zM264 448H64V272h200c48.53 0 88 39.47 88 88S312.5 448 264 448z"],
    "bolt": [384, 512, [9889, "zap"], "f0e7", "M274.8 6.288C279.4 2.237 285.3 0 291.4 0C308.6 0 320.6 17.05 314.8 33.27L246.7 224H356.1C371.9 224 384 236.1 384 251C384 258.8 380.7 266.2 374.9 271.3L109.1 505.8C104.6 509.8 98.7 512 92.63 512C75.41 512 63.39 494.9 69.18 478.7L137.3 288H25.81C11.56 288 0 276.4 0 262.2C0 254.8 3.153 247.8 8.664 242.9L274.8 6.288zM275.4 48.65L42.08 256H160C165.2 256 170.1 258.5 173.1 262.8C176.1 267 176.8 272.5 175.1 277.4L108.6 463.6L343.8 256H224C218.8 256 213.9 253.5 210.9 249.2C207.9 244.1 207.2 239.5 208.9 234.6L275.4 48.65z"],
    "bolt-auto": [576, 512, [], "e0b6", "M314.8 33.27L246.7 224H356.1C371.9 224 384 236.1 384 251C384 258.8 380.7 266.2 374.9 271.3L109.1 505.8C104.6 509.8 98.7 512 92.63 512C75.41 512 63.39 494.9 69.18 478.7L137.3 288H25.81C11.56 288 0 276.4 0 262.2C0 254.8 3.153 247.8 8.664 242.9L274.8 6.288C279.4 2.237 285.3 0 291.4 0C308.6 0 320.6 17.05 314.8 33.27H314.8zM160 256C165.2 256 170.1 258.5 173.1 262.8C176.1 267 176.8 272.5 175.1 277.4L108.6 463.6L343.8 256H224C218.8 256 213.9 253.5 210.9 249.2C207.9 244.1 207.2 239.5 208.9 234.6L275.3 48.65L42.08 256L160 256zM464 288C470.1 288 475.6 291.4 478.3 296.8L574.3 488.8C578.3 496.7 575.1 506.4 567.2 510.3C559.3 514.3 549.6 511.1 545.7 503.2L526.1 464H401.9L382.3 503.2C378.4 511.1 368.7 514.3 360.8 510.3C352.9 506.4 349.7 496.7 353.7 488.8L449.7 296.8C452.4 291.4 457.9 288 464 288V288zM417.9 432H510.1L464 339.8L417.9 432z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M379.8 197.6c5.031-7.344 5.563-16.88 1.406-24.75C377.1 164.9 368.9 160 360 160h-156.6l50.84-127.1c2.969-7.375 2.062-15.78-2.406-22.38S239.1 0 232 0h-176C43.97 0 33.81 8.906 32.22 20.84l-32 240C-.7179 267.7 1.376 274.6 5.938 279.8C10.5 285 17.09 288 24 288h146.3l-41.78 194.1c-2.406 11.22 3.469 22.56 14 27.09C145.6 511.4 148.8 512 152 512c7.719 0 15.22-3.75 19.81-10.44L379.8 197.6zM190.1 256H33.15l29.87-224h157.2L164.9 170.1C160.7 180.6 168.5 192 179.8 192h165l-176.5 257.1l37.43-174.6C207.9 265.4 200.3 256 190.1 256z"],
    "bolt-slash": [640, 512, [], "e0b8", "M351.4 362.3L376.9 382.4L237.1 505.8C232.6 509.8 226.7 512 220.6 512C203.4 512 191.4 494.9 197.2 478.7L263.5 292.1L290 313.9L236.6 463.6L351.4 362.3zM216.7 256L257.2 288H153.8C139.6 288 128 276.4 128 262.2C128 254.8 131.2 247.8 136.7 242.9L166.5 216.4L192 236.5L170.1 256H216.7zM289.2 150.1L263.7 129.1L402.8 6.288C407.4 2.237 413.3 0 419.4 0C436.6 0 448.6 17.05 442.8 33.27L376.5 219L349.1 198.1L403.4 48.65L289.2 150.1zM512 251C512 258.8 508.7 266.2 502.9 271.3L474.4 296.4L448.9 276.2L471.8 256H423.3L382.8 224H484.1C499.9 224 512 236.1 512 251zM633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.087C8.918-.849 18.98-2.033 25.91 3.443L633.9 483.4z"],
    "bomb": [512, 512, [128163], "f1e2", "M448 0C456.8 0 464 7.164 464 16V48H496C504.8 48 512 55.16 512 64C512 72.84 504.8 80 496 80H464V112C464 120.8 456.8 128 448 128C439.2 128 432 120.8 432 112V80H400C391.2 80 384 72.84 384 64C384 55.16 391.2 48 400 48H432V16C432 7.164 439.2 0 448 0zM95.1 304C95.1 312.8 88.84 320 79.1 320C71.16 320 63.1 312.8 63.1 304V296C63.1 220.9 124.9 160 199.1 160H207.1C216.8 160 223.1 167.2 223.1 176C223.1 184.8 216.8 192 207.1 192H199.1C142.6 192 95.1 238.6 95.1 296V304zM278.5 108.3L289.4 97.37C301.9 84.88 322.1 84.88 334.6 97.37L363.3 126.1L380.7 108.7C386.9 102.4 397.1 102.4 403.3 108.7C409.6 114.9 409.6 125.1 403.3 131.3L385.9 148.7L414.6 177.4C427.1 189.9 427.1 210.1 414.6 222.6L403.8 233.5C411.7 255.5 416 279.3 416 304C416 418.9 322.9 512 208 512C93.12 512 0 418.9 0 304C0 189.1 93.12 96 208 96C232.7 96 256.5 100.3 278.5 108.3L278.5 108.3zM301.1 130.9C292.4 139.6 279.3 142.6 267.7 138.4C249.1 131.7 228.1 128 207.1 128C110.8 128 31.1 206.8 31.1 304C31.1 401.2 110.8 480 207.1 480C305.2 480 384 401.2 384 304C384 283 380.3 262.9 373.6 244.3C369.4 232.7 372.4 219.6 381.1 210.9L392 200L312 120L301.1 130.9z"],
    "bone": [576, 512, [129460], "f5d7", "M536.5 256C565.4 238.3 576 211.6 576 179C576 133.3 537.1 96 491.3 96c-36.5 0-68.88 22.75-80.5 56.63C403.3 175.3 403.6 176 392 176h-208c-11.62 0-11.25-.75-18.75-23.38C153.6 118.8 121.3 96 84.75 96C37.1 96 0 133.3 0 179C0 211.6 10.63 238.3 39.5 256C10.63 273.8 0 300.4 0 333C0 378.8 37.1 416 84.75 416c36.5 0 68.88-22.75 80.5-56.63C172.8 336.8 172.4 336 184 336h208c11.62 0 11.25 .75 18.75 23.38C422.4 393.3 454.8 416 491.3 416C537.1 416 576 378.8 576 333C576 300.4 565.4 273.8 536.5 256zM491.3 384c-22.88 0-43-13.1-50.25-35C432.1 322.4 424.5 304 392 304h-208c-32.5 0-40.13 18.38-49 45C127.8 370 107.6 384 84.75 384C55.75 384 32 361.1 32 333c0-23.38 6.875-41.5 29-52.25C70.63 276.1 76.5 266.5 76.5 256S70.63 236 61 231.4C38.88 220.6 32 202.4 32 179C32 150.9 55.75 128 84.75 128c22.88 0 43 14 50.25 35C143.9 189.6 151.5 208 184 208h208c32.5 0 40.13-18.38 49-45C448.3 142 468.4 128 491.3 128C520.3 128 544 150.9 544 179c0 23.38-6.875 41.5-29 52.25C505.4 235.9 499.5 245.5 499.5 256s5.875 20 15.5 24.62C537.1 291.4 544 309.6 544 333C544 361.1 520.3 384 491.3 384z"],
    "bone-break": [640, 512, [], "f5d8", "M278.3 358.6l-69.71 19.13c-31.73 7.084-35.22 26.88-38.14 55.1c-2.551 22.31-19.18 40.51-41.52 45.5c-28.32 6.32-56.44-11.08-62.51-38.84c-5.041-23.07-2.236-42.46 17.05-57.89c8.402-6.664 12.06-17.44 9.799-27.81c-2.264-10.36-10.05-18.46-20.45-20.93c-23.92-5.789-34.57-22.3-39.61-45.38C27.11 259.7 45.37 231.1 73.68 225.7c22.34-4.984 45.01 4.447 56.62 23.6C144.7 273.6 156.1 290.1 187.8 282.1L273.8 263.8c8.629-1.926 14.08-10.56 12.17-19.28c-1.904-8.723-10.45-14.23-19.07-12.31L180.9 251.4C169.6 253.9 169.8 253.1 157.6 232.4C138.9 201.5 102.4 186.1 66.78 194.1c-45.65 10.19-74.72 55.24-64.86 100.4c7.033 32.2 23.15 56.17 55.17 67.39c-24.37 23.81-29 52.41-21.97 84.61c9.865 45.16 55 73.64 100.7 63.46c35.64-7.955 62.35-37.47 66.4-73.44c2.443-23.97 1.916-24.62 13.27-27.16l69.85-19.16c8.686-1.939 14.17-10.53 12.27-19.23C295.7 362.2 286.1 356.7 278.3 358.6zM573.2 194.1c-35.64-7.953-72.16 7.443-90.82 38.35c-12.2 20.7-11.1 21.52-23.35 18.99L373.1 232.2c-8.629-1.926-17.17 3.584-19.07 12.3c-1.904 8.723 3.545 17.36 12.17 19.28l85.93 19.18c31.74 7.084 43.14-9.393 57.55-33.74c11.61-19.15 34.28-28.58 56.62-23.59c28.32 6.32 46.58 34.08 40.51 61.84c-5.039 23.07-15.66 39.46-39.58 45.25c-10.39 2.465-18.21 10.69-20.47 21.05c-2.264 10.36 1.426 21.02 9.826 27.69c19.29 15.43 22.06 34.94 17.03 58.02c-6.064 27.76-34.19 45.16-62.51 38.84c-22.34-4.986-38.97-23.19-41.52-45.5c-2.926-28.22-6.408-48.02-38.14-55.1l-69.71-19.13c-8.74-1.951-17.4 3.576-19.31 12.33c-1.898 8.693 3.586 17.29 12.27 19.23l69.85 19.16c11.35 2.533 10.82 3.191 13.27 27.16c4.047 35.97 30.75 65.48 66.4 73.44c45.65 10.19 90.79-18.3 100.7-63.46c7.035-32.2 2.4-60.8-21.97-84.61c32.02-11.23 48.14-35.19 55.17-67.39C647.9 249.3 618.9 204.3 573.2 194.1zM319.1 0C311.2 0 304 7.156 304 16v96c0 8.844 7.154 15.1 15.1 15.1S336 120.8 336 112v-96C336 7.156 328.8 0 319.1 0zM228.7 155.3C231.8 158.4 235.9 160 240 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-64-64c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L228.7 155.3zM400 160c4.094 0 8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62C391.8 158.4 395.9 160 400 160z"],
    "bong": [512, 512, [], "f55c", "M475.3 228.7l-64-64c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L409.4 208L364 253.4c-12.88-13.88-27.49-26-43.99-35.5L320 80C320 71.16 312.8 64 304 64S288 71.16 288 80v156.4l16 9.25C333.9 262.9 356.8 289.3 370.3 320h-292.5C91.25 289.3 114.1 262.9 144 245.6L160 236.4V80C160 71.16 152.8 64 144 64S128 71.16 128 80l.0045 137.9C70.63 251.1 32 313 32 384c0 43.07 14.29 82.87 38.35 114.9C75.73 506 87.33 512 96.28 512h255.4c9.023 0 20.65-6.02 26.07-13.24C401.7 466.8 416 427 416 384c0-39-12.01-75.13-32.01-105.4l48-48l20.69 20.69c6.246 6.246 16.37 6.254 22.62 0C481.6 245.1 481.6 234.9 475.3 228.7zM351.8 480H96.88C75.38 451.9 64 419.3 64 384c0-10.88 1.5-21.5 3.625-32h312.8C382.5 362.5 384 373.1 384 384C384 419.3 372.6 452.8 351.8 480zM111.1 32h224.1c8.775 0 15.97-7.21 15.97-15.99S344.8 0 336 0L111.1 .1667c-8.775 0-15.99 7.21-15.99 15.99S103.2 32 111.1 32z"],
    "book": [448, 512, [128212], "f02d", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM32 80C32 53.49 53.49 32 80 32H96v352H64c-11.71 0-22.55 3.389-32 8.9V80zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H128V32h272C408.8 32 416 39.17 416 48v320C416 376.8 408.8 384 400 384zM352 128H192C183.2 128 176 135.2 176 144S183.2 160 192 160h160c8.844 0 16-7.156 16-16S360.8 128 352 128zM352 224H192C183.2 224 176 231.2 176 240S183.2 256 192 256h160c8.844 0 16-7.156 16-16S360.8 224 352 224z"],
    "book-arrow-right": [640, 512, [], "e0b9", "M432 272C423.2 272 416 279.2 416 288v80c0 8.836-7.164 16-16 16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48V128c0 8.836 7.164 16 16 16S448 136.8 448 128V48C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h367.2c7.969 0 15.35-5.455 16.62-13.32C449.4 488.6 441.7 480 432 480H416v-66.95c18.59-6.627 32-24.22 32-45.05V288C448 279.2 440.8 272 432 272zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM635.3 196.7l-96-96c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L585.4 192H272C263.2 192 256 199.2 256 208S263.2 224 272 224h313.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62C519.8 318.4 523.9 320 528 320s8.188-1.562 11.31-4.688l96-96C641.6 213.1 641.6 202.9 635.3 196.7z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M347.3 251.3C350.4 248.2 352 244.1 352 240s-1.562-8.188-4.688-11.31l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L224 182.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l68.69 68.69C330.9 257.6 341.1 257.6 347.3 251.3zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h112C184.8 512 192 504.8 192 496C192 487.2 184.8 480 176 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h112C184.8 416 192 408.8 192 400C192 391.2 184.8 384 176 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320c0 8.836-7.164 16-16 16h-96c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H384v64h-80c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16h128c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M224 80c-70.75 0-128 57.25-128 128s57.25 128 128 128s128-57.25 128-128S294.8 80 224 80zM129.6 224h39.13c1.5 27 6.5 51.38 14.12 70.38C155.3 281.1 134.9 255.3 129.6 224zM168.8 192H129.6c5.25-31.25 25.62-57.13 53.25-70.38C175.3 140.6 170.3 165 168.8 192zM224 302.8C216.3 295.3 203.3 268.3 200.6 224h46.75C244.8 268.3 231.8 295.3 224 302.8zM200.5 192C203.3 147.8 216.3 120.8 224 113.3C231.8 120.8 244.8 147.8 247.4 192H200.5zM265.1 294.4C272.8 275.4 277.8 251 279.3 224h39.13C313.1 255.3 292.8 281.1 265.1 294.4zM279.3 192c-1.5-27-6.5-51.38-14.12-70.38c27.62 13.25 48 39.13 53.25 70.38H279.3zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-bible": [448, 512, ["bible"], "f647", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM304 144h-64v-64c0-8.844-7.156-15.1-16-15.1S208 71.16 208 80v64h-64C135.2 144 128 151.2 128 160s7.156 16 16 16h64v128c0 8.844 7.156 16 16 16S240 312.8 240 304v-128h64C312.8 176 320 168.8 320 160S312.8 144 304 144z"],
    "book-blank": [448, 512, [128215, 128216, 128217, 128213, "book-alt"], "f5d9", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM32 80C32 53.49 53.49 32 80 32H96v352H64c-11.71 0-22.55 3.389-32 8.9V80zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H128V32h272C408.8 32 416 39.17 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-bookmark": [448, 512, [], "e0bb", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM320 32v174.7L265.1 163.5C263.1 161.2 259.5 160 256 160s-7.062 1.172-10 3.5L192 206.7V32H320zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32H160v208c0 6.156 3.531 11.75 9.062 14.42c5.562 2.672 12.09 1.891 16.94-1.922L256 196.5l69.1 56.02C328.9 254.8 332.4 256 336 256c2.344 0 4.719-.5156 6.938-1.578C348.5 251.8 352 246.2 352 240V32h48C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-circle-arrow-right": [640, 512, [], "e0bc", "M336 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h240c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v128C416 184.8 423.2 192 432 192S448 184.8 448 176v-128C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h272c8.836 0 16-7.164 16-16C352 487.2 344.8 480 336 480zM496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM496 480c-61.76 0-112-50.24-112-112S434.2 256 496 256S608 306.2 608 368S557.8 480 496 480zM571.3 356.7l-56-56c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L521.4 352H432c-8.836 0-15.1 7.164-15.1 16S423.2 384 432 384h89.38l-28.69 28.69c-6.25 6.25-6.25 16.38 0 22.62C495.8 438.4 499.9 440 504 440s8.188-1.562 11.31-4.688l56-56C577.6 373.1 577.6 362.9 571.3 356.7z"],
    "book-circle-arrow-up": [640, 512, [], "e0bd", "M336 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h240c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v128C416 184.8 423.2 192 432 192S448 184.8 448 176v-128C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h272c8.836 0 16-7.164 16-16C352 487.2 344.8 480 336 480zM496 224C416.5 224 352 288.5 352 367.1C352 447.5 416.5 512 496 512s144-64.46 144-144C640 288.5 575.5 224 496 224zM496 480c-61.76 0-112-50.24-112-112C384 306.2 434.2 256 496 256S608 306.2 608 367.1C608 429.8 557.8 480 496 480zM507.3 292.7c-6.25-6.25-16.38-6.25-22.62 0l-56 56c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L480 342.6V432c0 8.836 7.164 15.1 16 15.1S512 440.8 512 432v-89.38l28.69 28.69c6.25 6.25 16.38 6.25 22.62 0C566.4 368.2 568 364.1 568 360s-1.562-8.188-4.688-11.31L507.3 292.7z"],
    "book-copy": [576, 512, [], "e0be", "M576 272v-224C576 21.49 554.5 0 528 0h-256C227.8 0 192 35.82 192 80V352c0 35.35 28.66 64 64 64h304c8.844 0 16-7.156 16-16S568.8 384 560 384H544V317.1C562.6 310.4 576 292.8 576 272zM512 384H256c-17.64 0-32-14.36-32-32s14.36-32 32-32h256V384zM528 288H256C244.3 288 233.5 291.4 224 296.9V80C224 53.49 245.5 32 272 32h256C536.8 32 544 39.16 544 48v224C544 280.8 536.8 288 528 288zM368 480H352v-16c0-8.838-7.164-16-16-16S320 455.2 320 464V480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h80C152.8 416 160 408.8 160 400C160 391.2 152.8 384 144 384H64c-11.71 0-22.55 3.389-32 8.9V176C32 149.5 53.49 128 80 128h64C152.8 128 160 120.8 160 112C160 103.2 152.8 96 144 96h-64C35.82 96 0 131.8 0 176V448c0 35.35 28.66 64 64 64h304c8.844 0 16-7.156 16-16S376.8 480 368 480z"],
    "book-font": [448, 512, [], "e0bf", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM238.3 104.8c-5.438-10.84-23.19-10.84-28.62 0l-96 192C109.7 304.8 112.9 314.4 120.8 318.3c7.906 3.906 17.52 .75 21.47-7.156L169.9 256h108.2l27.58 55.16C308.5 316.8 314.1 320 320 320c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L238.3 104.8zM185.9 224L224 147.8L262.1 224H185.9z"],
    "book-heart": [448, 512, [], "f499", "M224.1 139.8c-42.63-43-76.38-26.12-90.25-14.5c-27.5 23-28.88 64.13-4.25 89l84.5 85.63c5.5 5.5 14.25 5.5 19.75 0l84.75-85.63c24.62-24.88 23.12-66-4.375-89C300.3 113.6 266.6 96.75 224.1 139.8zM295.1 191.8l-72 72.63L152.2 191.8c-10.38-10.38-12.38-30 2-42c13.75-11.5 31.25-3.375 38.5 3.75l31.38 31.75l31.38-31.75c7.125-7.25 24.62-15.25 38.38-3.75C308.2 161.8 306.2 181.4 295.1 191.8zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-journal-whills": [448, 512, ["journal-whills"], "f66a", "M308 85.25c-4.75-2.625-10.62-1.75-14.5 2.125c-3.75 4-4.375 10-1.5 14.63c16.25 25.87 10.38 59.87-13.5 78.87c-2.5 2.25-4 5.25-4.375 8.625c-.25 3.25 1 6.5 3.25 9c13 13.38 17.75 32.63 12.5 50.5S270.1 280.6 252 284.9V259.3l6.25 6.375c3.125 3.125 8.25 3.125 11.38 0s3.125-8.125 0-11.25L259.3 244H272c4.375 0 8-3.625 8-8s-3.625-8-8-8h-12.75l10.38-10.38c3.125-3.125 3.125-8.125 0-11.25s-8.125-3.125-11.25 0L252 212.8V84c0-6.625-5.375-12-12-12s-12 5.375-12 12v128.8L221.6 206.4c-3.125-3.125-8.125-3.125-11.25 0s-3.125 8.125 0 11.25L220.6 228H208c-4.375 0-8 3.625-8 8s3.625 8 8 8h12.62L210.4 254.4c-3.125 3.125-3.125 8.125 0 11.25s8.125 3.125 11.25 0L228 259.3v25.62C209.9 280.6 195.4 267 190.1 249.1S189.6 211.9 202.5 198.5C204.9 196 206.1 192.8 205.9 189.5C205.6 186.1 204.1 183 201.5 180.9c-24-19-29.75-53-13.5-78.87c1.125-1.875 1.75-4.125 1.75-6.25c-.125-3.125-1.25-6-3.375-8.375C182.6 83.5 176.8 82.63 171.9 85.25C127.5 110.1 100 156.8 100 207c0 77.13 62.88 140 140 140s140-62.88 140-140C380 156.8 352.4 110.1 308 85.25zM330.4 197.6c3.125 3.125 8.125 3.125 11.25 0l12.25-12.25C355.3 192.5 356 199.8 356 207c0 4.75-.875 9.375-1.5 14.12l-23.88 20.88c-2.125 1.875-3.125 4.75-2.5 7.625c.5 2.75 2.5 5 5.25 6c2.75 .875 5.75 .25 7.875-1.625L348.1 248C331.4 291.8 289.5 323 240 323S148.5 291.8 131.9 248l6.875 6c3.249 2.875 8.375 2.625 11.25-.7501C151.4 251.6 152.1 249.6 152 247.5S150.9 243.4 149.3 242L125.5 221.1C124.9 216.4 124 211.8 124 207c0-7.25 .625-14.5 1.999-21.62l12.38 12.25c3.125 3.125 8.125 3.125 11.25 0s3.125-8.25 0-11.38L131.3 167.9C136.5 153.4 144.5 140.1 155 128.8c-.125 1.625-.25 3.375-.25 5C154.9 155.1 163 175.6 177.5 191.3c-21.88 31.62-16.75 74.63 12 100.1c28.88 25.62 72.13 25.62 101 0c28.75-25.5 33.88-68.5 11.88-100.1c14.62-15.62 22.75-36.13 22.75-57.5c0-1.625 0-3.375-.125-5C335.4 140 343.5 153.4 348.8 167.9l-18.44 18.38C327.3 189.4 327.3 194.5 330.4 197.6zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-medical": [448, 512, [], "f7e6", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.34 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.391-32 8.898V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM320 159.1h-48V111.1c0-8.836-7.164-16-16-16L224 96C215.2 96 208 103.2 208 111.1V160H160C151.2 160 144 167.2 144 175.1V208c0 8.836 7.164 15.1 16 15.1l48-.002v48C208 280.8 215.2 288 224 288l32-.0031c8.836 0 16-7.163 16-15.1v-48l48-.002c8.836 0 16-7.16 16-15.1V175.1C336 167.2 328.8 159.1 320 159.1z"],
    "book-open": [576, 512, [128366, 128214], "f518", "M540.9 56.77c-45.95-16.66-90.23-24.09-129.1-24.75C351.1 32.96 309.1 49.47 288 59.74C266.9 49.47 223.9 32.94 164.8 32C124.8 31.95 80.4 40.35 35.1 56.77C14.18 64.33 0 84.41 0 106.7v302.9c0 14.66 6.875 28.06 18.89 36.8c11.81 8.531 26.64 10.98 40.73 6.781c118.9-36.34 209.3 19.05 214.3 22.19C277.8 477.6 281.2 480 287.1 480c6.52 0 10.12-2.373 14.07-4.578c10.78-6.688 98.3-57.66 214.3-22.27c14.11 4.25 28.86 1.75 40.75-6.812C569.1 437.6 576 424.2 576 409.6V106.7C576 84.42 561.8 64.35 540.9 56.77zM272 438.1c-24.95-12.03-71.01-29.37-130.5-29.37c-27.83 0-58.5 3.812-91.19 13.77c-4.406 1.344-9 .5938-12.69-2.047C34.02 417.8 32 413.1 32 409.6V106.7c0-8.859 5.562-16.83 13.86-19.83C87.66 71.7 127.9 63.95 164.5 64C216.3 64.81 254.2 79.26 272 87.66V438.1zM544 409.6c0 4.375-2.016 8.234-5.594 10.84c-3.766 2.703-8.297 3.422-12.69 2.125C424.1 391.6 341.3 420.4 304 438.3V87.66C321.8 79.26 359.7 64.81 411.4 64c35.31-.0625 76.34 7.484 118.8 22.88C538.4 89.88 544 97.84 544 106.7V409.6z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M89.06 398.1l217.1 48.4C310.7 447.5 315.3 448 320 448s9.312-.5098 13.88-1.529l217.1-48.4C565.6 394.8 576 381.8 576 366.7V39.47c0-22.15-17.99-39.46-39.31-39.46C536.2 .0127 535.9 0 535.6 0C532.7 0 522.6 1.673 320 33.13C117.1 1.63 107.4 .002 104.4 .002c-.3574 0-.6172 .0107-1.105 .0107C81.99 .0107 64 17.32 64 39.47V366.7C64 381.8 74.42 394.8 89.06 398.1zM336 63.1c0 0 195.4-30.39 200.6-31.07C540.1 32.03 544 34.91 544 39.56l-.0234 327.3L336 413.2V63.1zM96 39.56c0-2.623 1.203-4.367 2.211-5.369c.7383-.7344 2.248-1.922 5.264-2.148C108.8 32.74 304 63.1 304 63.1v350.1L96 366.7V39.56zM624 32C615.2 32 608 39.16 608 48v335.6c0 22.88-16.3 42.69-38.73 47.09L320 479.7l-249.3-48.97C48.3 426.3 32 406.5 32 383.6V48C32 39.16 24.84 32 16 32S0 39.16 0 48v335.6c0 38.13 27.16 71.14 64.58 78.5l252.3 49.58C317.9 511.9 318.1 512 320 512s2.062-.0938 3.078-.2969l252.4-49.58C612.8 454.8 640 421.8 640 383.6V48C640 39.16 632.8 32 624 32z"],
    "book-open-reader": [512, 512, ["book-reader"], "f5da", "M459.9 192c-.625 0-1.375 0-2 .125C408 194.9 317.4 205.1 256 239.6c-61.38-34.5-152-44.75-201.9-47.5C53.5 192 52.75 192 52.12 192C31.75 192 0 206.4 0 242.2v177.1C0 447 21.25 469 48.38 470.4c34.38 1.875 120.5 9.125 177 37.5C229.1 510.2 235 511.5 240 511.9l32 .0208c5-.375 9.1-1.688 14.62-4.062c56.5-28.38 142.6-35.63 177-37.5C490.8 469 512 447 512 420.2V242.2C512 206.4 480.3 192 459.9 192zM239.9 479.3C239.8 479.2 240 479.4 239.9 479.3c-59.63-30-144.6-38.44-189.9-40.81C39.88 437.9 32 429.9 32 420.2V242.2c0-6.125 1.75-10 5.875-13.25C42.38 225.6 48.38 224 52.38 224C89.38 226.1 181.6 234.6 240 267.4L239.9 479.3zM480 420.2c0 9.625-7.875 17.63-18 18.25c-45.25 2.375-130.2 10.81-189.9 40.81c-.125 .125 .125 0 0 0L272 267.4C330.4 234.6 422.6 226.1 459.5 224h.375C460.1 224 480 224.5 480 242.2V420.2zM256 192c53 0 96-43 96-96s-43-96-96-96S160 43 160 96S203 192 256 192zM256 32c35.25 0 64 28.75 64 64s-28.75 64-64 64S192 131.2 192 96S220.8 32 256 32z"],
    "book-quran": [448, 512, ["quran"], "f687", "M368 0h-320C21.49 0 0 21.49 0 48v320c0 20.83 13.42 38.43 32 45.05V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512H384c35.35 0 64-28.66 64-64V80C448 35.82 412.2 0 368 0zM384 480H64v-64h320c17.64 0 32 14.36 32 32S401.6 480 384 480zM416 392.9C406.5 387.4 395.7 384 384 384H48C39.16 384 32 376.8 32 368v-320C32 39.16 39.16 32 48 32h320C394.5 32 416 53.49 416 80V392.9zM354.3 179.1L331.5 175.9l-10.12-20.62c-5.375-10.88-23.25-10.88-28.62 0L282.5 175.9l-22.62 3.25C253.8 180 248.8 184.3 246.9 190C245 195.9 246.6 202.3 251 206.5l16.38 16L263.5 245.1c-1 6 1.5 12 6.375 15.62c5 3.625 11.5 4 16.88 1.25L307 251.3L327.4 262c5.375 2.75 11.88 2.375 16.88-1.25c4.875-3.625 7.375-9.625 6.375-15.62L346.8 222.5l16.38-16c4.375-4.25 6-10.62 4.125-16.5C365.4 184.3 360.3 180 354.3 179.1zM323 213.5l3.75 22L307 225.1L287.3 235.5l3.875-22L275 197.9l22.12-3.25l9.875-20l10 20l22 3.25L323 213.5zM284.3 293.9L280.1 294c-45.63 0-82.88-37.13-82.88-82.88c0-45.63 37.25-82.75 82.88-82.75l4.125 .125c9 0 16.62-6.375 18.38-15c1.875-9.125-3.125-18.12-11.75-21.38C276.4 86.75 261.4 84 246.3 84c-70.13 0-127.1 57-127.1 127.1s57 127.3 127.1 127.3c15 0 30-2.75 44-8c7.625-2.5 12.88-9.75 12.75-17.75C303 302.3 294.6 293.9 284.3 293.9zM143 211.3c0-57 46.38-103.3 103.3-103.3c1.875 0 3.625 0 5.5 .125c-45.25 12.5-78.5 54-78.5 103.1c0 49 33.25 90.5 78.5 103C193 317.9 143 269.9 143 211.3z"],
    "book-section": [448, 512, ["book-law"], "e0c1", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM298.5 254.3c10.71-7.951 17.9-18.6 20.41-31.65c9.469-49.48-39.33-62.25-74.95-71.47l-8.359-2.047C195.5 138.5 189.9 130.6 192.5 117.1c3.656-19.06 34.5-23.61 61.53-19.75c7.75 1.109 17.03 3.391 29.16 7.188c8.406 2.641 17.41-2.047 20.06-10.48c2.625-8.438-2.062-17.41-10.5-20.05c-13.81-4.328-24.69-6.984-34.22-8.344c-52.63-7.484-90.78 10.39-97.47 45.44C156.4 135.9 166.7 151.4 181.5 161.7c-10.73 7.955-17.92 18.61-20.43 31.68c-9.344 48.89 39.88 61.97 66.28 69L236 264.6c41.5 10.75 54.75 17.2 51.47 34.31c-3.656 19.06-34.38 23.66-61.63 19.75C213.1 317.1 199.9 312.5 187.5 308.4L180.9 306.3C172.5 303.6 163.5 308.2 160.8 316.7c-2.688 8.422 1.969 17.42 10.38 20.11l6.469 2.109c13.69 4.453 29.19 9.5 43.84 11.5c7.938 1.125 15.5 1.656 22.72 1.656c40.59 0 69.06-17.34 74.75-47.09C323.6 280.3 313.9 264.8 298.5 254.3zM287.5 216.6c-2.766 14.45-20.55 18.9-31.04 20.3c-4.223-1.166-20.84-5.506-20.84-5.506C195.5 220.8 189.9 212.9 192.5 199.4C195.3 184.9 213.2 180.4 223.7 179.1c1.215 .3281 12.25 3.105 12.25 3.105C277.5 192.9 290.8 199.5 287.5 216.6z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M248 160c8.75 0 16-7.25 16-16S256.8 128 248 128s-16 7.25-16 16S239.3 160 248 160zM200 160c8.75 0 16-7.25 16-16S208.8 128 200 128s-16 7.25-16 16S191.3 160 200 160zM160 203.4V216C160 229.3 170.8 240 184 240h80C277.3 240 288 229.3 288 216V203.4C308.4 188.3 319.1 167 319.1 144C319.1 99.88 276.9 64 224 64S128 99.88 128 144C128 167 139.6 188.3 160 203.4zM224 96c35.25 0 63.99 21.5 63.99 48c0 14.25-8.736 27.88-24.24 37.25L256 185.9V208H191.1L192 185.9L184.3 181.3C168.9 171.9 159.1 158.3 159.1 144C159.1 117.5 188.8 96 224 96zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM351.1 250.6c-2.953-8.328-12.19-12.72-20.44-9.688L224 279L117.4 240.9C109 237.9 99.89 242.3 96.94 250.6C93.95 258.9 98.3 268.1 106.6 271.1L176.4 296l-69.82 24.94c-8.328 2.969-12.67 12.12-9.688 20.44C99.27 347.9 105.4 352 112 352c1.781 0 3.609-.2969 5.375-.9375L224 312.1l106.6 38.08C332.4 351.7 334.2 352 336 352c6.578 0 12.73-4.078 15.06-10.62c2.984-8.312-1.359-17.47-9.688-20.44L271.6 296l69.82-24.94C349.7 268.1 354 258.9 351.1 250.6z"],
    "book-sparkles": [448, 512, ["book-spells"], "f6b8", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM352 224h-48V176c0-8.844-7.155-15.1-15.1-15.1S272 167.2 272 176V224H224C215.2 224 208 231.1 208 239.1S215.2 255.1 224 255.1L272 256v48c0 8.844 7.155 15.1 15.1 15.1S304 312.8 304 304V256L352 255.1c8.844 0 16-7.152 16-15.1S360.8 224 352 224zM223.1 128c0-8.844-7.148-16-15.99-16h-32l-.0039-32C175.1 71.16 168.8 64 160 64S144 71.16 144 80v32h-32C103.2 112 96 119.2 96 128s7.156 16 16 16h32v32C144 184.8 151.2 192 160 192s15.1-7.156 15.1-16L176 144h32C216.8 144 223.1 136.8 223.1 128z"],
    "book-tanakh": [448, 512, ["tanakh"], "f827", "M368 0h-320C21.49 0 0 21.49 0 48v320c0 20.83 13.42 38.43 32 45.05V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512H384c35.35 0 64-28.66 64-64V80C448 35.82 412.2 0 368 0zM384 480H64v-64h320c17.64 0 32 14.36 32 32S401.6 480 384 480zM416 392.9C406.5 387.4 395.7 384 384 384H48C39.16 384 32 376.8 32 368v-320C32 39.16 39.16 32 48 32h320C394.5 32 416 53.49 416 80V392.9zM314.6 208l27.62-46.38c3.749-6.125 3.749-13.88 .25-20.12c-3.5-6.25-10.25-10.12-17.38-10.12h-56.38L241 85.13C237.4 79.13 231.1 74.75 224 75.5c-7.125 0-13.62 3.75-17.25 9.75L179.1 131.5H122.9C115.6 131.4 109 135.3 105.4 141.6c-3.625 6.125-3.5 13.88 .25 20L133.4 208L105.8 254.4C101.1 260.5 101.1 268.3 105.5 274.5C109 280.8 115.8 284.6 122.9 284.6h56.38L207 330.9c3.5 6 10 9.625 17 9.625c7.125 0 13.62-3.75 17.25-9.75l27.62-46.25h56.25c7.25 .125 13.88-3.75 17.5-10.12c3.625-6.125 3.5-13.88-.25-20L314.6 208zM317.1 155.4l-17.37 29.25l-17.5-29.12L317.1 155.4zM224 103.4l16.75 28.12H207.1L224 103.4zM129.1 155.5h34.88l-17.5 29.12L129.1 155.5zM129.1 260.5L147.5 231.4L165 260.5H129.1zM224 312.6L207.3 284.5h33.5L224 312.6zM255.1 260.5H192.9L161.4 208l31.5-52.5h62.25L286.6 208L255.1 260.5zM283.1 260.5l17.5-29.12l17.37 29.12H283.1z"],
    "book-user": [448, 512, [], "f7e7", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM256 240H192c-44.18 0-80 35.82-80 80c0 8.836 7.164 16 16 16s16-7.164 16-16c0-26.51 21.49-48 48-48h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16C336 275.8 300.2 240 256 240zM224 208c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S188.7 208 224 208zM224 112c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S206.4 112 224 112z"],
    "bookmark": [384, 512, [61591, 128278], "f02e", "M320 0H64C28.72 0 0 28.7 0 64v431.1c0 5.844 3.188 11.23 8.312 14.04c5.125 2.781 11.34 2.562 16.28-.5313L192 402.1l167.4 106.5C362 511.2 365 512 368 512c2.656 0 5.281-.6562 7.688-1.969C380.8 507.2 384 501.8 384 495.1V64C384 28.7 355.3 0 320 0zM352 466.9l-151.4-96.36C197.1 368.8 195 368 192 368s-5.969 .8281-8.594 2.5L32 466.9V64c0-17.64 14.34-32 32-32h256c17.66 0 32 14.36 32 32V466.9z"],
    "bookmark-slash": [640, 512, [], "e0c2", "M192 32h256c17.66 0 32 14.36 32 32v236.8l32 25.26V64c0-35.3-28.72-64-64-64H192C169 0 148.1 12.28 137.7 30.53l25.45 20.09C168.3 39.7 179.2 32 192 32zM320 368c-3 0-5.969 .8281-8.594 2.5L160 466.9V211.2L128 185.9v310c0 5.844 3.188 11.23 8.312 14.04c5.125 2.781 11.34 2.562 16.28-.5313L320 402.1l167.4 106.5C490 511.2 493 512 496 512c2.656 0 5.281-.6562 7.688-1.969C508.8 507.2 512 501.8 512 496v-3.877l-183.4-121.6C325.1 368.8 323 368 320 368zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.939-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "books": [512, 512, [128218], "f5db", "M510.4 435.4l-107.7-399.9C396.9 14.07 377.5 0 356.4 0c-4.111 0-8.296 .5313-12.46 1.641l-61.82 16.48c-1.281 .3438-2.375 .9922-3.592 1.445C269.7 7.758 255.8 0 240 0h-64c-12.35 0-23.49 4.797-32 12.46C135.5 4.797 124.3 0 112 0h-64C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h64c12.35 0 23.49-4.797 32-12.46C152.5 507.2 163.7 512 176 512h64c26.51 0 48-21.49 48-48V224.7l67.8 251.9C361.6 497.9 380.9 512 402.1 512c4.111 0 8.293-.5313 12.46-1.641l61.82-16.48C502 487 517.2 460.8 510.4 435.4zM32 48C32 39.18 39.18 32 48 32h64C120.8 32 128 39.18 128 48l.0011 48L32 96V48zM32 128l96 .0014v255.1L32 384V128zM112 480h-64C39.18 480 32 472.8 32 464V416l96 0L128 464C128 472.8 120.8 480 112 480zM256 464c0 8.824-7.178 16-16 16h-64C167.2 480 160 472.8 160 464l.0011-47.1L256 416V464zM256 384l-95.1 .0002V128L256 128V384zM256 96L160 96L160 48C160 39.18 167.2 32 176 32h64C248.8 32 256 39.18 256 48V96zM288 101.6V50.29c.834-.3906 1.322-.9727 2.322-1.242l61.82-16.48C353.5 32.19 354.1 32 356.4 32c7.225 0 13.57 4.828 15.43 11.74l12.4 46.07l-92.71 24.73L288 101.6zM366 391.4l-66.26-246.1l92.71-24.73l66.26 246.1L366 391.4zM477.9 455.5c-1.23 2.133-4.133 5.934-9.729 7.43l-61.82 16.48C404.1 479.8 403.5 480 402.1 480c-7.227 0-13.57-4.828-15.43-11.74l-12.4-46.07l92.71-24.73l12.44 46.22C480.9 449.1 479.1 453.4 477.9 455.5z"],
    "books-medical": [576, 512, [], "f7e8", "M63.1 336c0 8.836 7.164 16 15.1 16h31.1c8.836 0 16-7.164 16-16L127.1 288h47.1c8.836 0 16-7.165 16-16v-32c0-8.836-7.165-15.1-16-15.1H127.1l.0006-47.1c0-8.836-7.165-15.1-16-15.1H79.1c-8.836 0-15.1 7.163-15.1 15.1L63.1 224H16c-8.836 0-16 7.163-16 15.1v32c0 8.836 7.164 16 16 16h47.1L63.1 336zM574.4 435.4l-107.7-399.9C460.9 14.07 441.5 0 420.4 0c-4.111 0-8.296 .5313-12.46 1.641l-61.82 16.48c-1.281 .3438-2.375 .9922-3.592 1.445C333.7 7.758 319.8 0 304 0h-64c-12.35 0-23.49 4.797-32 12.46C199.5 4.797 188.3 0 176 0h-64C85.49 0 64 21.49 64 48v64C64 120.8 71.16 128 80 128h112L192 176C192 184.8 199.2 192 208 192S224 184.8 224 176L224 128H320v256H224L224 336C224 327.2 216.8 320 208 320S192 327.2 192 336L192 384H80C71.16 384 64 391.2 64 400v64C64 490.5 85.49 512 112 512h64c12.35 0 23.49-4.797 32-12.46C216.5 507.2 227.7 512 240 512h64c26.51 0 48-21.49 48-48V224.7l67.8 251.9C425.6 497.9 444.9 512 466.1 512c4.111 0 8.293-.5313 12.46-1.641l61.91-16.51C566.1 487 581.2 460.8 574.4 435.4zM192 96H96V48C96 39.18 103.2 32 112 32h64C184.8 32 192 39.18 192 48L192 96zM192 464C192 472.8 184.8 480 176 480h-64C103.2 480 96 472.8 96 464V416h96L192 464zM320 464c0 8.824-7.178 16-16 16h-64C231.2 480 224 472.8 224 464L224 416H320V464zM320 96H224L224 48C224 39.18 231.2 32 240 32h64C312.8 32 320 39.18 320 48V96zM352 101.6V50.29c.834-.3906 1.322-.9727 2.322-1.242l61.82-16.48C417.5 32.19 418.1 32 420.4 32c7.225 0 13.57 4.828 15.43 11.74l12.4 46.07l-92.71 24.73L352 101.6zM430 391.4l-66.26-246.1l92.71-24.73l66.26 246.1L430 391.4zM541.9 455.5c-1.23 2.133-4.133 5.934-9.729 7.43l-61.82 16.48C468.1 479.8 467.5 480 466.1 480c-7.227 0-13.57-4.828-15.43-11.74l-12.4-46.07l92.71-24.73l12.44 46.22C544.9 449.1 543.1 453.4 541.9 455.5z"],
    "boombox": [640, 512, [128254], "f8a5", "M576 160V80C576 35.89 540.1 0 496 0h-352C99.88 0 64 35.89 64 80V160C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V224C640 188.7 611.3 160 576 160zM96 80C96 53.53 117.5 32 144 32h352C522.5 32 544 53.53 544 80V160H96V80zM608 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V224c0-17.64 14.36-32 32-32h512c17.64 0 32 14.36 32 32V448zM176 224C114.1 224 64 274.1 64 336S114.1 448 176 448S288 397.9 288 336S237.9 224 176 224zM176 416C131.9 416 96 380.1 96 336S131.9 256 176 256S256 291.9 256 336S220.1 416 176 416zM464 224C402.1 224 352 274.1 352 336s50.14 112 112 112s112-50.14 112-112S525.9 224 464 224zM464 416c-44.11 0-80-35.89-80-80S419.9 256 464 256S544 291.9 544 336S508.1 416 464 416zM240 96h-32C199.2 96 192 103.2 192 112S199.2 128 208 128h32C248.8 128 256 120.8 256 112S248.8 96 240 96zM432 96h-32C391.2 96 384 103.2 384 112S391.2 128 400 128h32C440.8 128 448 120.8 448 112S440.8 96 432 96zM336 96h-32C295.2 96 288 103.2 288 112S295.2 128 304 128h32C344.8 128 352 120.8 352 112S344.8 96 336 96z"],
    "boot": [512, 512, [129406], "f782", "M415 247.8L352 232V192c0-17.67-14.33-32-32-32H240C231.2 160 224 167.2 224 176S231.2 192 240 192H320v32H240C231.2 224 224 231.2 224 240S231.2 256 240 256H320l87.25 22.75C450.1 289.5 480 327.8 480 371.9V384H32V128h320c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32v434.7c0 8.5 3.322 16.49 9.322 22.49l13.43 13.39C28.75 508.6 36.75 512 45.25 512h37.49c8.488 0 16.63-3.373 22.63-9.375L128 480l22.62 22.62C156.6 508.6 164.8 512 173.3 512h37.49c8.373 0 16.41-3.314 22.34-9.219L256 480l22.62 22.62C284.6 508.6 292.8 512 301.3 512h37.27c8.516 0 16.69-3.371 22.72-9.375L384 480l22.62 22.62C412.6 508.6 420.8 512 429.3 512h37.49c8.5 0 16.5-3.375 22.5-9.375l13.38-13.29C508.6 483.3 512 475.2 512 466.7v-94.76C512 313.2 472 262 415 247.8zM32 32h320v64H32V32zM480 466.8L466.8 480h-37.5l-22.62-22.62C400.6 451.4 392.5 448 384 448s-16.62 3.375-22.62 9.375L338.8 480h-37.5l-22.62-22.62C272.6 451.4 264.5 448 256 448s-16.62 3.375-22.62 9.375L210.8 480h-37.5l-22.62-22.62C144.6 451.4 136.5 448 128 448s-16.62 3.375-22.62 9.375L82.75 480h-37.5L32 466.8V416h448V466.8z"],
    "boot-heeled": [512, 512, [], "e33f", "M480 480v-56.45c0-24.24-13.7-46.4-35.38-57.24l-121.2-60.62c-21.68-10.84-35.38-33-35.38-57.24V32c0-17.67-14.33-32-32-32h-192C44.76 0 29.86 16.87 32.25 35.97l24.44 161.5c4.816 38.53 .9414 77.66-11.34 114.5c-8.84 26.52-13.35 54.29-13.35 82.24V496c0 8.844 7.156 16 16 16h96c8.844 0 16-7.156 16-16v-39.5l109 48.56C279.3 509.7 290.3 512 301.6 512h178.4c8.844 0 16-7.156 16-16S488.8 480 480 480zM128 480h-64v-32h64V480zM301.6 480c-6.812 0-13.38-1.406-19.56-4.156l-125.9-56.09C150.3 417.3 143.1 416 137.5 416H64.01v-21.8c0-24.56 3.938-48.82 11.7-72.12c13.71-41.12 18.11-85.58 12.73-128.6L64.01 32h64v208c0 8.844 7.156 16 16 16s16-7.156 16-16V32h96v216.4c0 36.6 20.33 69.5 53.07 85.87l121.2 60.62c10.91 5.455 17.69 16.42 17.69 28.62V480H301.6z"],
    "booth-curtain": [512, 512, [], "f734", "M0 32v464C0 504.8 7.2 512 15.1 512S32 504.8 32 496V32h64L95.1 381.5c0 35.29 27.49 65.79 62.78 66.47C178.5 448.4 196 439.5 208 425.9C219.8 439.2 236.8 448 256 448s36.25-8.75 48-22.12C315.8 439.2 332.8 448 352 448s36.25-8.75 48-22.12C411.8 439.2 428.8 448 448 448c11.75 0 22.5-3.375 32-8.875v56.88C480 504.8 487.2 512 496 512s16-7.2 16-16V32c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32zM416 32h64v352c0 17.75-14.25 32-32 32c-17.75 0-32-14.25-32-32V32zM320 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32zM224 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32zM128 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32z"],
    "border-all": [448, 512, [], "f84c", "M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 64H240V240H416V96C416 78.33 401.7 64 384 64zM416 272H240V448H384C401.7 448 416 433.7 416 416V272zM208 240V64H64C46.33 64 32 78.33 32 96V240H208zM32 272V416C32 433.7 46.33 448 64 448H208V272H32z"],
    "border-bottom": [448, 512, [], "f84d", "M448 464C448 472.8 440.8 480 432 480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H432C440.8 448 448 455.2 448 464zM440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352zM32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328zM248 352C248 365.3 237.3 376 224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352zM416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136zM56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160zM224 136C237.3 136 248 146.7 248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136zM440 256C440 269.3 429.3 280 416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232C429.3 232 440 242.7 440 256zM32 232C45.25 232 56 242.7 56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256C8 242.7 18.75 232 32 232zM248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256zM416 40C429.3 40 440 50.75 440 64C440 77.25 429.3 88 416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40zM56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64zM224 40C237.3 40 248 50.75 248 64C248 77.25 237.3 88 224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40zM344 256C344 269.3 333.3 280 320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232C333.3 232 344 242.7 344 256zM320 40C333.3 40 344 50.75 344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40zM152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64zM128 232C141.3 232 152 242.7 152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256C104 242.7 114.7 232 128 232z"],
    "border-bottom-right": [448, 512, ["border-style-alt"], "f854", "M448 416C448 451.3 419.3 480 384 480H32C23.16 480 16 472.8 16 464C16 455.2 23.16 448 32 448H384C401.7 448 416 433.7 416 416V64C416 55.16 423.2 48 432 48C440.8 48 448 55.16 448 64V416zM296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64zM104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64zM224 40C237.3 40 248 50.75 248 64C248 77.25 237.3 88 224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40zM8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64zM32 232C45.25 232 56 242.7 56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256C8 242.7 18.75 232 32 232zM8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160zM32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328z"],
    "border-center-h": [448, 512, [], "f89c", "M432 240C440.8 240 448 247.2 448 256C448 264.8 440.8 272 432 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H432zM32 88C18.75 88 8 77.25 8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64C56 77.25 45.25 88 32 88zM32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448C56 461.3 45.25 472 32 472zM128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64C152 77.25 141.3 88 128 88zM128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472zM344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448zM320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64C344 77.25 333.3 88 320 88zM248 448C248 461.3 237.3 472 224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448zM224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40C237.3 40 248 50.75 248 64C248 77.25 237.3 88 224 88zM440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448zM440 64C440 77.25 429.3 88 416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40C429.3 40 440 50.75 440 64zM248 352C248 365.3 237.3 376 224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352zM416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352C440 365.3 429.3 376 416 376zM56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328C45.25 328 56 338.7 56 352zM416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184zM56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160zM224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136C237.3 136 248 146.7 248 160C248 173.3 237.3 184 224 184z"],
    "border-center-v": [448, 512, [], "f89d", "M208 48C208 39.16 215.2 32 224 32C232.8 32 240 39.16 240 48V464C240 472.8 232.8 480 224 480C215.2 480 208 472.8 208 464V48zM56 448C56 461.3 45.25 472 32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448zM440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448zM56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328C45.25 328 56 338.7 56 352zM440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352zM416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136zM56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160zM416 232C429.3 232 440 242.7 440 256C440 269.3 429.3 280 416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232zM56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256C8 242.7 18.75 232 32 232C45.25 232 56 242.7 56 256zM416 40C429.3 40 440 50.75 440 64C440 77.25 429.3 88 416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40zM32 40C45.25 40 56 50.75 56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64C8 50.75 18.75 40 32 40zM320 232C333.3 232 344 242.7 344 256C344 269.3 333.3 280 320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232zM344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64zM320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448C296 434.7 306.7 424 320 424zM152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64zM128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424zM152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256z"],
    "border-inner": [448, 512, [], "f84e", "M224 480C215.2 480 208 472.8 208 464V272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H208V48C208 39.16 215.2 32 224 32C232.8 32 240 39.16 240 48V240H432C440.8 240 448 247.2 448 256C448 264.8 440.8 272 432 272H240V464C240 472.8 232.8 480 224 480zM8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448C56 461.3 45.25 472 32 472C18.75 472 8 461.3 8 448zM392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448zM8 352C8 338.7 18.75 328 32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352zM392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352zM440 160C440 173.3 429.3 184 416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160zM8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160zM440 64C440 77.25 429.3 88 416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40C429.3 40 440 50.75 440 64zM56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64zM344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64zM296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448zM152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64zM104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472C114.7 472 104 461.3 104 448z"],
    "border-left": [448, 512, [], "f84f", "M16 480C7.164 480 0 472.8 0 464V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V464C32 472.8 24.84 480 16 480zM128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472zM152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64zM128 280C114.7 280 104 269.3 104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256C152 269.3 141.3 280 128 280zM344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448zM320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64C344 77.25 333.3 88 320 88zM344 256C344 269.3 333.3 280 320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232C333.3 232 344 242.7 344 256zM224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448C248 461.3 237.3 472 224 472zM248 64C248 77.25 237.3 88 224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40C237.3 40 248 50.75 248 64zM224 280C210.7 280 200 269.3 200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280zM440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448zM416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40C429.3 40 440 50.75 440 64C440 77.25 429.3 88 416 88zM440 256C440 269.3 429.3 280 416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232C429.3 232 440 242.7 440 256zM224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352C248 365.3 237.3 376 224 376zM440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352zM416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184zM248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136C237.3 136 248 146.7 248 160z"],
    "border-none": [448, 512, [], "f850", "M56 448C56 461.3 45.25 472 32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448zM128 88C114.7 88 104 77.25 104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64C152 77.25 141.3 88 128 88zM128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472zM152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256zM320 472C306.7 472 296 461.3 296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472zM344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40C333.3 40 344 50.75 344 64zM320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232C333.3 232 344 242.7 344 256C344 269.3 333.3 280 320 280zM248 448C248 461.3 237.3 472 224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448zM224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40C237.3 40 248 50.75 248 64C248 77.25 237.3 88 224 88zM248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256zM416 472C402.7 472 392 461.3 392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448C440 461.3 429.3 472 416 472zM416 88C402.7 88 392 77.25 392 64C392 50.75 402.7 40 416 40C429.3 40 440 50.75 440 64C440 77.25 429.3 88 416 88zM56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64zM416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232C429.3 232 440 242.7 440 256C440 269.3 429.3 280 416 280zM56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256C8 242.7 18.75 232 32 232C45.25 232 56 242.7 56 256zM224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352C248 365.3 237.3 376 224 376zM440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352zM32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376zM440 160C440 173.3 429.3 184 416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160zM32 184C18.75 184 8 173.3 8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160C56 173.3 45.25 184 32 184zM248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136C237.3 136 248 146.7 248 160z"],
    "border-outer": [448, 512, [], "f851", "M248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136C237.3 136 248 146.7 248 160zM104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256zM248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256zM296 256C296 242.7 306.7 232 320 232C333.3 232 344 242.7 344 256C344 269.3 333.3 280 320 280C306.7 280 296 269.3 296 256zM248 352C248 365.3 237.3 376 224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352zM0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM32 96V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V96C416 78.33 401.7 64 384 64H64C46.33 64 32 78.33 32 96z"],
    "border-right": [448, 512, [], "f852", "M432 32C440.8 32 448 39.16 448 48V464C448 472.8 440.8 480 432 480C423.2 480 416 472.8 416 464V48C416 39.16 423.2 32 432 32zM320 40C333.3 40 344 50.75 344 64C344 77.25 333.3 88 320 88C306.7 88 296 77.25 296 64C296 50.75 306.7 40 320 40zM296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448zM320 232C333.3 232 344 242.7 344 256C344 269.3 333.3 280 320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232zM104 64C104 50.75 114.7 40 128 40C141.3 40 152 50.75 152 64C152 77.25 141.3 88 128 88C114.7 88 104 77.25 104 64zM128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424zM104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256zM224 40C237.3 40 248 50.75 248 64C248 77.25 237.3 88 224 88C210.7 88 200 77.25 200 64C200 50.75 210.7 40 224 40zM200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448C248 461.3 237.3 472 224 472C210.7 472 200 461.3 200 448zM224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256C200 242.7 210.7 232 224 232zM8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64zM32 424C45.25 424 56 434.7 56 448C56 461.3 45.25 472 32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424zM8 256C8 242.7 18.75 232 32 232C45.25 232 56 242.7 56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256zM224 136C237.3 136 248 146.7 248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160C200 146.7 210.7 136 224 136zM8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160zM32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328zM200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352C248 365.3 237.3 376 224 376C210.7 376 200 365.3 200 352z"],
    "border-top": [448, 512, [], "f855", "M0 48C0 39.16 7.164 32 16 32H432C440.8 32 448 39.16 448 48C448 56.84 440.8 64 432 64H16C7.164 64 0 56.84 0 48zM8 160C8 146.7 18.75 136 32 136C45.25 136 56 146.7 56 160C56 173.3 45.25 184 32 184C18.75 184 8 173.3 8 160zM416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184zM200 160C200 146.7 210.7 136 224 136C237.3 136 248 146.7 248 160C248 173.3 237.3 184 224 184C210.7 184 200 173.3 200 160zM32 376C18.75 376 8 365.3 8 352C8 338.7 18.75 328 32 328C45.25 328 56 338.7 56 352C56 365.3 45.25 376 32 376zM392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352zM224 376C210.7 376 200 365.3 200 352C200 338.7 210.7 328 224 328C237.3 328 248 338.7 248 352C248 365.3 237.3 376 224 376zM8 256C8 242.7 18.75 232 32 232C45.25 232 56 242.7 56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256zM416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232C429.3 232 440 242.7 440 256C440 269.3 429.3 280 416 280zM200 256C200 242.7 210.7 232 224 232C237.3 232 248 242.7 248 256C248 269.3 237.3 280 224 280C210.7 280 200 269.3 200 256zM32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448C56 461.3 45.25 472 32 472zM392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448zM224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448C248 461.3 237.3 472 224 472zM104 256C104 242.7 114.7 232 128 232C141.3 232 152 242.7 152 256C152 269.3 141.3 280 128 280C114.7 280 104 269.3 104 256zM128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472zM296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448zM320 280C306.7 280 296 269.3 296 256C296 242.7 306.7 232 320 232C333.3 232 344 242.7 344 256C344 269.3 333.3 280 320 280z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M0 96C0 60.65 28.65 32 64 32H416C424.8 32 432 39.16 432 48C432 56.84 424.8 64 416 64H64C46.33 64 32 78.33 32 96V448C32 456.8 24.84 464 16 464C7.164 464 0 456.8 0 448V96zM152 448C152 461.3 141.3 472 128 472C114.7 472 104 461.3 104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448zM344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448zM224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448C248 461.3 237.3 472 224 472zM440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448C392 434.7 402.7 424 416 424C429.3 424 440 434.7 440 448zM416 280C402.7 280 392 269.3 392 256C392 242.7 402.7 232 416 232C429.3 232 440 242.7 440 256C440 269.3 429.3 280 416 280zM440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352zM416 184C402.7 184 392 173.3 392 160C392 146.7 402.7 136 416 136C429.3 136 440 146.7 440 160C440 173.3 429.3 184 416 184z"],
    "bore-hole": [512, 512, [], "e4c3", "M272 258C299.6 265.1 320 290.2 320 320C320 355.3 291.3 384 256 384C220.7 384 192 355.3 192 320C192 290.2 212.4 265.1 240 258V16C240 7.164 247.2 0 256 0C264.8 0 272 7.164 272 16V258zM256 352C273.7 352 288 337.7 288 320C288 302.3 273.7 288 256 288C238.3 288 224 302.3 224 320C224 337.7 238.3 352 256 352zM160 128V320C160 373 202.1 416 256 416C309 416 352 373 352 320V128H448C483.3 128 512 156.7 512 192V448C512 483.3 483.3 512 448 512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128H160zM448 160H384V320C384 390.7 326.7 448 256 448C185.3 448 128 390.7 128 320V160H64C46.33 160 32 174.3 32 192V448C32 465.7 46.33 480 64 480H448C465.7 480 480 465.7 480 448V192C480 174.3 465.7 160 448 160z"],
    "bottle-droplet": [320, 512, [], "e4c4", "M96 336.1C96 311.4 119.9 277.9 138.4 255.7C146.3 246.3 153.2 238.1 156.1 235.1C158.9 233.1 160 232 160 232C160 232 161.1 233.1 163 235.1C166.8 238.1 173.7 246.3 181.6 255.7C200.1 277.9 224 311.4 224 336.1C224 379 195.3 400 160 400C124.7 400 96 371.8 96 336.1L96 336.1zM185.5 317.4C180.7 307.9 173.9 297.8 166.5 288.1C164.4 285.3 162.2 282.5 160 279.8C157.8 282.5 155.6 285.3 153.5 288.1C146.1 297.8 139.3 307.9 134.5 317.4C129.4 327.4 128 333.9 128 336.1C128 353.6 141.8 368 160 368C171.5 368 179.3 364.6 183.8 360.5C187.7 356.9 192 350.3 192 336.1C192 333.9 190.6 327.4 185.5 317.4zM72 16C71.1 7.168 79.16 .0038 87.1 .0038L232 0C240.8-.0003 248 7.163 248 15.1C248 24.84 240.8 32 232 32L224 32V145.1C262.3 167.3 288 208.6 288 256V448C288 483.3 259.3 512 224 512H96C60.65 512 32 483.3 32 448V256C32 208.6 57.74 167.3 96 145.1V32L88 32C79.16 32 72 24.84 72 16V16zM192 32L128 32V163.6L112 172.8C83.25 189.5 64 220.5 64 255.1V448C64 465.7 78.33 480 96 480H224C241.7 480 256 465.7 256 448V255.1C256 220.5 236.8 189.5 207.1 172.8L192 163.6V32z"],
    "bottle-water": [320, 512, [], "e4c5", "M96 240C96 231.2 103.2 224 112 224H208C216.8 224 224 231.2 224 240C224 248.8 216.8 256 208 256H112C103.2 256 96 248.8 96 240zM208 352C216.8 352 224 359.2 224 368C224 376.8 216.8 384 208 384H112C103.2 384 96 376.8 96 368C96 359.2 103.2 352 112 352H208zM96 102.3V24C96 10.75 106.7 0 120 0H200C213.3 0 224 10.75 224 24V102.3C230.4 104.7 236.6 107.8 242.4 111.5L255.9 120.1C275.9 132.9 288 154.9 288 178.6C288 189.5 285.5 199.8 280.1 209C285.5 218.4 288 228.9 288 240C288 251.5 285.3 262.4 280.5 272C285.3 281.6 288 292.5 288 304C288 315.5 285.3 326.4 280.5 336C285.3 345.6 288 356.5 288 368C288 381.1 284.5 393.4 278.4 404C284.5 414.6 288 426.9 288 440C288 479.8 255.8 512 216 512H104C64.24 512 32 479.8 32 440C32 426.9 35.51 414.6 41.64 404C35.51 393.4 32 381.1 32 368C32 356.5 34.7 345.6 39.49 336C34.7 326.4 32 315.5 32 304C32 292.5 34.7 281.6 39.49 272C34.7 262.4 32 251.5 32 240C32 228.9 34.52 218.4 39 209C34.52 199.8 32 189.5 32 178.6C32 154.9 44.1 132.9 64.08 120.1L77.63 111.5C83.45 107.8 89.61 104.7 96 102.3H96zM192 96V32H128V96H192zM130.7 128C117.1 128 105.5 131.6 94.84 138.5L81.29 147.1C70.52 153.1 64 165.8 64 178.6C64 183.9 65.09 188.9 67.07 193.5C69.7 199.5 73.89 204.8 79.14 208.7C73.68 213 69.37 218.7 66.77 225.3C64.98 229.9 64 234.8 64 240C64 244.1 64.91 249.7 66.56 254.1C69.27 261.3 73.97 267.5 79.1 272C73.97 276.5 69.27 282.7 66.56 289.9C64.91 294.3 64 299 64 304C64 308.1 64.91 313.7 66.56 318.1C69.27 325.3 73.97 331.5 79.1 336C73.97 340.5 69.27 346.7 66.56 353.9C64.91 358.3 64 363 64 368C64 371.9 64.55 375.6 65.56 379.1C68.73 390.1 76.45 399.1 86.54 404C76.45 408.9 68.73 417.9 65.56 428.9C64.55 432.4 64 436.1 64 440C64 462.1 81.91 480 104 480H216C238.1 480 256 462.1 256 440C256 436.1 255.5 432.4 254.4 428.9C251.3 417.9 243.6 408.9 233.5 404C243.6 399.1 251.3 390.1 254.4 379.1C255.5 375.6 256 371.9 256 368C256 363 255.1 358.3 253.4 353.9C250.7 346.7 246 340.5 240 336C246 331.5 250.7 325.3 253.4 318.1C255.1 313.7 256 308.1 256 303.1C256 299 255.1 294.3 253.4 289.9C250.7 282.7 246 276.5 240 271.1C246 267.5 250.7 261.3 253.4 254.1C255.1 249.7 256 244.1 256 239.1C256 234.8 255 229.9 253.2 225.3C250.6 218.7 246.3 213 240.9 208.7C246.1 204.8 250.3 199.5 252.9 193.5C254.9 188.9 256 183.9 256 178.6C256 165.8 249.5 153.1 238.7 147.1L225.2 138.5C214.5 131.6 202 128 189.3 128H130.7z"],
    "bow-arrow": [512, 512, [127993], "f6b9", "M496.3-.0002c-1 0-2.053 .165-3.053 .29l-128.6 25.75c-12.25 2.5-16.88 17.59-8 26.47l40.12 40.12L144.3 345l-53.62-24.08C83.35 318.5 75.23 320.4 69.73 325.9l-63.75 63.82c-10.75 10.75-6.376 29.12 8.126 33.1l55.62 18.5L88.22 497.9c2.998 9 11.28 14.12 19.65 14.12c5.125 0 10.35-1.874 14.47-5.997l63.62-63.74c5.502-5.5 7.376-13.62 5.001-20.1l-23.1-53.62l252.4-252.4l40.13 40.09c3.125 3.125 7.129 4.639 11.01 4.639c6.998 0 13.87-4.764 15.49-12.64l25.72-128.6C513.6 8.913 505.9-.0002 496.3-.0002zM112.7 470.3L94.97 417l-53.25-17.75l44.87-45l49.13 22l21.1 48.1L112.7 470.3zM460.6 111.3L400.7 51.5l74.75-15L460.6 111.3zM148.7 267.3C151.8 270.4 155.9 272 160 272s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L63.58 136.1c73.23-51.43 171.8-54.54 247.9-6.502c7.375 4.688 17.38 2.516 22.06-4.984C338.3 118 336 108.1 328.5 103.4c-88.5-55.89-203.9-51.54-288.1 10.46L27.25 100.7c-6.25-6.25-16.31-6.302-22.56-.0524S-1.542 117 4.708 123.3L148.7 267.3zM408.6 183.5c-4.781-7.5-14.75-9.672-22.06-4.984c-7.5 4.719-9.719 14.61-5 22.08c48.06 76.04 44.97 174.6-6.494 247.9l-107.7-107.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C391.8 510.4 395.9 512 400 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-13.17-13.17C460.1 387.3 464.5 271.1 408.6 183.5z"],
    "bowl-chopsticks": [512, 512, [], "e2e9", "M479.1 223.1H32c-17.62 0-31.1 14.56-31.1 32.19c0 94.76 51.5 176.9 128 221.3l-.0033 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0033-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM367.9 449.8c-9.869 5.725-15.94 16.27-15.94 27.68v2.5H160v-2.5c0-11.41-6.074-21.96-15.94-27.68c-69.12-40.09-112.1-114.4-112.1-193.8h447.1C479.1 335.4 437.1 409.7 367.9 449.8zM15.97 128c1.062 0 2.125-.0938 3.156-.3125l479.1-96.01c8.687-1.734 14.31-10.16 12.56-18.83c-1.75-8.688-10.59-14.31-18.81-12.55L12.88 96.33C4.194 98.07-1.431 106.5 .319 115.2C1.85 122.8 8.506 128 15.97 128zM15.97 191.1c.375 0 .7187-.0156 1.094-.0313l479.1-32c8.812-.5938 15.5-8.219 14.91-17.03c-.5938-8.829-8.375-15.2-17.03-14.91L14.94 160C6.131 160.6-.5559 168.2 .0378 177C.6003 185.5 7.631 191.1 15.97 191.1z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M511.7 12.87c-1.75-8.688-10.59-14.31-18.81-12.55L208 57.3v32.63l291.1-58.23C507.8 29.97 513.4 21.54 511.7 12.87zM479.1 223.1L176 224V32c0-8.838-7.164-16-16-16S144 23.16 144 32v192h-32V48C112 39.16 104.8 32 96 32C87.16 32 80 39.16 80 48v34.9L12.88 96.33C4.193 98.06-1.432 106.5 .3184 115.2c1.531 7.609 8.188 12.86 15.66 12.86c1.062 0 2.125-.0938 3.156-.3125L80 115.5V155.7L14.94 160C6.131 160.6-.5566 168.2 .0371 177c.5625 8.455 7.594 14.94 15.94 14.94c.375 0 .7187-.0156 1.094-.0313L80 187.7v36.23L32 223.1c-17.62 0-31.1 14.56-31.1 32.19c0 94.76 51.5 176.9 128 221.3l-.0035 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0035-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM367.9 449.8c-9.869 5.725-15.94 16.27-15.94 27.68v2.5H160v-2.5c0-11.41-6.074-21.96-15.94-27.68c-69.12-40.1-112.1-114.4-112.1-193.8h447.1C479.1 335.4 437.1 409.7 367.9 449.8zM511.1 142.9c-.5938-8.828-8.375-15.2-17.03-14.91L208 147.1v32.08L497.1 159.9C505.9 159.3 512.6 151.7 511.1 142.9z"],
    "bowl-food": [576, 512, [], "e4c6", "M221.3 106.6C217.1 107.8 212.5 107.2 208.7 104.1C199.2 99.28 187.1 96 176 96C145.1 96 119.2 117.1 113.3 147.2C111.7 154.8 104.1 160.2 97.2 160C96.8 160 96.4 160 96 160C69.49 160 48 181.5 48 208C48 216.8 40.84 224 32 224C23.16 224 16 216.8 16 208C16 167.5 46.13 133.1 85.22 128.7C98.19 91.06 133.9 64 176 64C188.4 64 200.2 66.34 211 70.6C228.5 47.19 256.5 32 288 32C319.5 32 347.5 47.19 364.1 70.6C375.8 66.34 387.7 64 400 64C442.1 64 477.8 91.06 490.8 128.7C529.9 133.1 560 167.5 560 208C560 216.8 552.8 224 544 224C535.2 224 528 216.8 528 208C528 181.5 506.5 160 480 160C479.6 160 479.2 160 478.8 160C471 160.2 464.3 154.8 462.7 147.2C456.8 117.1 430.1 96 400 96C388 96 376.8 99.28 367.3 104.1C363.5 107.2 358.9 107.8 354.7 106.6C350.5 105.4 346.9 102.5 344.9 98.61C334.2 78.01 312.7 64 287.1 64C263.3 64 241.8 78.01 231.1 98.61C229.1 102.5 225.5 105.4 221.3 106.6H221.3zM532.6 256C547.7 256 560 268.3 560 283.4C560 356.3 512.6 418.2 446.9 439.8C447.6 442.4 448 445.2 448 448C448 465.7 433.7 480 416 480H160C142.3 480 128 465.7 128 448C128 445.2 128.4 442.4 129.1 439.8C63.4 418.2 16 356.3 16 283.4C16 268.3 28.28 256 43.43 256H532.6zM416 447.1C411.7 431.6 420.8 414.7 436.9 409.4C488.5 392.4 526 344.7 527.9 288H48.08C49.1 344.7 87.52 392.4 139.1 409.4C155.2 414.7 164.3 431.6 159.1 447.1H416z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M168.8 94.31C183.1 101.5 192 115.8 192 131.8V144C192 152.8 199.2 160 208 160S224 152.8 224 144V131.8c0-28.16-15.66-53.48-40.84-66.09C168.9 58.55 160 44.19 160 28.22V16C160 7.156 152.8 0 144 0S128 7.156 128 16v12.22C128 56.38 143.7 81.7 168.8 94.31zM296.8 94.31C311.1 101.5 320 115.8 320 131.8V144C320 152.8 327.2 160 336 160S352 152.8 352 144V131.8c0-28.16-15.66-53.48-40.84-66.09C296.9 58.55 288 44.19 288 28.22V16C288 7.156 280.8 0 272 0S256 7.156 256 16v12.22C256 56.38 271.7 81.7 296.8 94.31zM480 192H32c-17.62 0-32 14.37-32 31.1c0 94.75 51.5 177.1 128 221.5v34.5c0 17.62 14.38 31.1 32 31.1h192c17.62 0 32-14.37 32-31.1v-34.5c76.5-44.38 128-126.7 128-221.5C512 206.4 497.6 192 480 192zM352 427v53H160v-53c-132.4-76.63-128-185.8-128-203h448C480 241.5 483.4 350.9 352 427z"],
    "bowl-rice": [576, 512, [], "e2eb", "M208 96C208 87.16 215.2 80 224 80H256C264.8 80 272 87.16 272 96C272 104.8 264.8 112 256 112H224C215.2 112 208 104.8 208 96zM112 160C112 151.2 119.2 144 128 144H160C168.8 144 176 151.2 176 160C176 168.8 168.8 176 160 176H128C119.2 176 112 168.8 112 160zM16 224C16 215.2 23.16 208 32 208H64C72.84 208 80 215.2 80 224C80 232.8 72.84 240 64 240H32C23.16 240 16 232.8 16 224zM16 315.4C16 300.3 28.28 288 43.43 288H532.6C547.7 288 560 300.3 560 315.4C560 388.3 512.6 450.2 446.9 471.8C447.6 474.4 448 477.2 448 480C448 497.7 433.7 512 416 512H160C142.3 512 128 497.7 128 480C128 477.2 128.4 474.4 129.1 471.8C63.4 450.2 16 388.3 16 315.4H16zM139.1 441.4C155.2 446.7 164.3 463.6 159.1 479.1L416 480C411.7 463.6 420.8 446.7 436.9 441.4C488.5 424.4 526 376.7 527.9 320H48.08C49.1 376.7 87.52 424.4 139.1 441.4V441.4zM256 208C264.8 208 272 215.2 272 224C272 232.8 264.8 240 256 240H224C215.2 240 208 232.8 208 224C208 215.2 215.2 208 224 208H256zM400 224C400 215.2 407.2 208 416 208H448C456.8 208 464 215.2 464 224C464 232.8 456.8 240 448 240H416C407.2 240 400 232.8 400 224zM544 208C552.8 208 560 215.2 560 224C560 232.8 552.8 240 544 240H512C503.2 240 496 232.8 496 224C496 215.2 503.2 208 512 208H544zM304 224C304 215.2 311.2 208 320 208H352C360.8 208 368 215.2 368 224C368 232.8 360.8 240 352 240H320C311.2 240 304 232.8 304 224zM160 208C168.8 208 176 215.2 176 224C176 232.8 168.8 240 160 240H128C119.2 240 112 232.8 112 224C112 215.2 119.2 208 128 208H160zM352 144C360.8 144 368 151.2 368 160C368 168.8 360.8 176 352 176H320C311.2 176 304 168.8 304 160C304 151.2 311.2 144 320 144H352zM400 160C400 151.2 407.2 144 416 144H448C456.8 144 464 151.2 464 160C464 168.8 456.8 176 448 176H416C407.2 176 400 168.8 400 160zM256 144C264.8 144 272 151.2 272 160C272 168.8 264.8 176 256 176H224C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144H256zM352 80C360.8 80 368 87.16 368 96C368 104.8 360.8 112 352 112H320C311.2 112 304 104.8 304 96C304 87.16 311.2 80 320 80H352z"],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M42.41 222.6C40.4 221.7 38.6 220.4 37.12 218.8C35.64 217.2 34.5 215.3 33.79 213.2C33.07 211.1 32.79 208.9 32.96 206.8C37.25 158.1 59.25 114.6 94.64 82.21C130 49.85 176.2 31.91 224.2 31.91C272.1 31.91 318.4 49.85 353.8 82.21C389.1 114.6 411.1 158.1 415.4 206.8C415.8 210.1 414.4 215.2 411.7 218.4C408.9 221.7 404.1 223.7 400.7 224C396.5 224.4 392.3 223 389 220.3C385.8 217.5 383.8 213.6 383.4 209.3C379.8 169.6 361.4 132.7 331.9 105.8C302.5 78.9 263.1 63.99 224.1 63.99C184.2 63.99 145.7 78.9 116.3 105.8C86.79 132.7 68.42 169.6 64.77 209.3C64.43 213.3 62.6 217.1 59.63 219.8C56.67 222.5 52.79 224 48.77 223.1C46.58 223.1 44.41 223.5 42.41 222.6zM394.9 375.6C365.4 401.7 327.4 416.1 288 416L347.9 485.3C349.1 487.6 351.3 490.4 351.8 493.5C352.3 496.5 351.9 499.7 350.6 502.5C349.4 505.3 347.3 507.7 344.7 509.4C342.1 511.1 339.1 512 336 512H112C108.9 512 105.9 511.1 103.3 509.4C100.7 507.7 98.62 505.3 97.36 502.5C96.1 499.7 95.69 496.5 96.17 493.5C96.66 490.4 98.02 487.6 100.1 485.3L160 416C120.6 416.1 82.61 401.7 53.12 375.6C23.64 349.5 4.739 313.5 .0026 274.4C-.312 272.1-.1338 269.8 .5251 267.6C1.184 265.4 2.309 263.3 3.824 261.6C5.339 259.8 7.209 258.4 9.309 257.5C11.41 256.5 13.69 256 16 255.1H432C434.3 256 436.6 256.5 438.7 257.5C440.8 258.4 442.7 259.8 444.2 261.6C445.7 263.3 446.8 265.4 447.5 267.6C448.1 269.8 448.3 272.1 448 274.4C443.3 313.5 424.4 349.5 394.9 375.6zM245.7 416H202.3L147 480H300.1L245.7 416zM366.8 357.3C389.3 339.9 405.5 315.5 412.8 287.1H35.2C42.49 315.5 58.69 339.9 81.26 357.2C103.8 374.6 131.5 384 160 384H288C316.5 384 344.2 374.6 366.8 357.3z"],
    "bowl-scoops": [448, 512, [127813], "e3df", "M394.9 375.6C365.4 401.7 327.4 416.1 288 416L347.9 485.3C349.1 487.6 351.3 490.4 351.8 493.5C352.3 496.6 351.9 499.7 350.6 502.5C349.4 505.3 347.3 507.7 344.7 509.4C342.1 511.1 339.1 512 336 512H112C108.9 512 105.9 511.1 103.3 509.4C100.7 507.7 98.62 505.3 97.36 502.5C96.1 499.7 95.69 496.6 96.17 493.5C96.66 490.4 98.02 487.6 100.1 485.3L160 416C120.6 416.1 82.61 401.7 53.12 375.6C23.64 349.5 4.739 313.5 .0026 274.4C-.312 272.1-.1338 269.8 .5251 267.6C1.184 265.4 2.309 263.3 3.824 261.6C5.339 259.8 7.209 258.4 9.309 257.5C11.41 256.5 13.69 256 16 256H432C434.3 256 436.6 256.5 438.7 257.5C440.8 258.4 442.7 259.8 444.2 261.6C445.7 263.3 446.8 265.4 447.5 267.6C448.1 269.8 448.3 272.1 448 274.4C443.3 313.5 424.4 349.5 394.9 375.6zM245.7 416H202.3L147 480H300.1L245.7 416zM366.8 357.3C389.3 339.9 405.5 315.5 412.8 288H35.2C42.49 315.5 58.69 339.9 81.26 357.2C103.8 374.6 131.5 384 160 384H288C316.5 384 344.2 374.6 366.8 357.3zM9.356 222.6C7.27 221.6 5.413 220.2 3.911 218.5C2.409 216.7 1.297 214.7 .6499 212.5C.0032 210.3-.1629 207.1 .1629 205.7C3.999 180.1 15.48 156.3 33.09 137.3C50.71 118.4 73.64 105.2 98.88 99.46C105.4 71.28 121.2 46.14 143.9 28.12C166.5 10.11 194.6 .2876 223.5 .2579C252.4 .2281 280.5 9.992 303.1 27.96C325.8 45.93 341.7 71.04 348.3 99.2C373.7 104.8 396.9 117.9 414.7 136.9C432.5 155.1 444.1 179.1 448 205.7C448.3 208 448.2 210.3 447.5 212.6C446.8 214.8 445.7 216.8 444.2 218.5C442.7 220.3 440.8 221.7 438.7 222.6C436.6 223.5 434.3 224 432 224C428.2 224.1 424.5 222.8 421.6 220.3C418.7 217.9 416.8 214.5 416.2 210.8C412.9 187.8 401.4 166.8 383.8 151.6C366.3 136.4 343.8 128.1 320.6 128.1C297.4 128.1 274.1 136.4 257.4 151.6C239.9 166.8 228.4 187.8 225.1 210.8C224.5 214.5 222.5 217.9 219.6 220.3C216.7 222.7 213.1 224 209.3 224C206.1 224 204.7 223.5 202.6 222.6C200.4 221.6 198.6 220.3 197 218.5C195.5 216.8 194.4 214.7 193.7 212.5C193.1 210.2 192.9 207.9 193.3 205.6C195.4 192.5 199.5 179.8 205.4 167.1C194.2 152.4 178.6 140.5 160.5 133.9C142.5 127.3 122.9 126.2 104.3 130.8C85.63 135.4 68.78 145.5 55.9 159.7C43.02 173.1 34.7 191.7 32 210.8C31.35 214.5 29.38 217.9 26.45 220.3C23.51 222.8 19.81 224.1 16 224C13.71 224 11.44 223.5 9.357 222.6L9.356 222.6zM168.6 49.77C152.4 61.31 140.2 77.6 133.7 96.39C150.1 97.18 167.9 101.4 183.4 108.9C198.1 116.4 212.9 126.9 224.3 139.9C235.7 126.9 249.6 116.4 265.1 108.1C280.7 101.5 297.6 97.32 314.8 96.58C308.3 77.7 296 61.34 279.7 49.76C263.5 38.19 243.1 31.98 224 32C204.1 32.02 184.8 38.23 168.6 49.77z"],
    "bowl-soft-serve": [512, 512, [], "e46b", "M288 0C358.7 0 416 57.31 416 128C416 139.7 413.2 150.7 408.3 160.4C448.6 164.6 480 198.6 480 240C480 284.2 444.2 320 400 320H112C67.82 320 32 284.2 32 240C32 199.1 62.68 165.4 102.3 160.6C98.25 151.9 96 142.2 96 132C96 94.44 126.4 64 164 64H241.3C249.4 64 256 57.42 256 49.3C256 46.39 255.1 43.56 253.5 41.14L242.7 24.88C239.4 19.97 239.1 13.65 241.9 8.45C244.7 3.248 250.1 0 256 0L288 0zM241.3 96H164C144.1 96 128 112.1 128 132C128 143.3 133.2 153.4 141.4 160H168C176.8 160 184 167.2 184 176C184 184.8 176.8 192 168 192H112C85.49 192 64 213.5 64 240C64 266.5 85.49 288 112 288H400C426.5 288 448 266.5 448 240C448 213.5 426.5 192 400 192H280C271.2 192 264 184.8 264 176C264 167.2 271.2 160 280 160H368C377.7 152.7 384 141.1 384 128C384 74.98 341 32 288 32H284.7C286.9 37.48 288 43.34 288 49.3C288 75.09 267.1 96 241.3 96zM64 344C64 383.8 96.24 416 136 416H208C213.5 416 218.7 418.9 221.6 423.6C224.5 428.3 224.8 434.2 222.3 439.2L201.9 480H310.1L289.7 439.2C287.2 434.2 287.5 428.3 290.4 423.6C293.3 418.9 298.5 416 304 416H376C415.8 416 448 383.8 448 344V336C448 327.2 455.2 320 464 320C472.8 320 480 327.2 480 336V344C480 401.4 433.4 448 376 448H329.9L350.3 488.8C352.8 493.8 352.5 499.7 349.6 504.4C346.7 509.1 341.5 512 336 512H176C170.5 512 165.3 509.1 162.4 504.4C159.5 499.7 159.2 493.8 161.7 488.8L182.1 448H136C78.56 448 32 401.4 32 344V336C32 327.2 39.16 320 48 320C56.84 320 64 327.2 64 336L64 344z"],
    "bowl-spoon": [512, 512, [129379], "e3e0", "M479.1 223.1H32c-17.62 0-32 14.39-32 32.19c0 95.69 51.5 179 127.1 223.8c0 17.67 14.33 32 32 32h191.1c17.67 0 32-14.33 32-32c76.5-44.81 127.1-128.1 127.1-223.8C511.1 238.4 497.6 223.1 479.1 223.1zM479.1 256.2c0 80.49-42.98 155.7-112.2 196.2C358 458.1 351.1 468.6 351.1 480H160c0-11.36-6.023-21.87-15.83-27.61c-69.19-40.53-112.2-115.7-112.2-196.4h447.1V256.2zM127 192C189.9 192 217.8 157.4 222.9 112H496C504.8 112 512 104.8 512 96s-7.156-16-16-16H222.9C217.8 34.64 189.9 0 127 0C56.88 0 0 42.98 0 96S56.88 192 127 192zM127 32C154.9 32 192 38.63 192 96S154.9 160 127 160C75.52 160 32 130.7 32 96S75.52 32 127 32z"],
    "bowling-ball": [512, 512, [], "f436", "M239.1 184c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C263.1 194.7 253.2 184 239.1 184zM239.1 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C263.1 98.74 253.2 88 239.1 88zM143.1 152c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C167.1 162.7 157.2 152 143.1 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M119.1 224C106.7 224 96 234.7 96 248S106.7 272 119.1 272C133.3 272 144 261.3 144 248S133.3 224 119.1 224zM200 240C186.7 240 176 250.7 176 264S186.7 288 200 288S224 277.3 224 264S213.3 240 200 240zM200 160C186.7 160 176 170.7 176 184S186.7 208 200 208S224 197.3 224 184S213.3 160 200 160zM208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304S322.9 96 208 96zM208 480C110.1 480 32 401 32 304S110.1 128 208 128S384 206.1 384 304S305 480 208 480zM549 264.7c-12.53-29.3-24.38-56.98-24.38-83.7c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.53-83.47-74.75-83.55c-37.06 0-74.56 28.7-74.56 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 2.57-.5781 5.188-.7871 7.773c8.775 16.01 15.58 33.2 20.54 51.17C444.6 224.3 448.9 208.3 450.3 192h43.4c2.551 29.34 14.14 57.78 25.93 85.33C532.2 306.6 544 334.3 544 361c0 45.33-18.06 81.2-33.38 111.6C508.3 477.2 503.8 480 498.8 480h-53.63c-4.938 0-9.438-2.828-12.34-8.562c-6.547-12.91-13.64-27.48-19.67-43.44c-6.564 10.84-13.82 21.2-21.97 30.83c4.604 10.18 9.348 19.65 13.73 28.3C412.8 502.5 428.2 512 445.2 512h53.63c17.06 0 32.53-9.562 41.16-26.56C555.2 455.3 576 413.1 576 361C576 327.8 562.3 295.7 549 264.7zM495.5 160h-46.97c-6.131-24.69-19.17-44.08-19.17-76.45C429.3 47.94 450.7 32 471.1 32c21.25 .0469 42.69 16 42.69 51.55C514.7 116.1 501.8 134.8 495.5 160z"],
    "bowling-pins": [512, 512, [], "f437", "M461 264.7c-12.53-29.3-24.38-56.98-24.38-83.7c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.49-83.47-74.71-83.55c-37.06 0-74.61 28.7-74.61 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 26.72-11.84 54.41-24.38 83.7C293.7 295.7 280 327.8 280 361c0 53.2 21 94.63 36.97 126.1C324.8 502.5 340.2 512 357.2 512h53.63c17.06 0 32.53-9.562 41.16-26.56c15.19-30.17 36-71.48 36-124.4C488 327.8 474.3 295.7 461 264.7zM383.1 32c21.25 .0469 42.69 16 42.69 51.55c0 32.52-12.91 51.22-19.17 76.45h-46.97c-6.13-24.69-19.17-44.08-19.17-76.45C341.3 47.94 362.7 32 383.1 32zM422.6 472.6C420.3 477.2 415.8 480 410.8 480h-53.63c-4.938 0-9.438-2.828-12.34-8.562C330.2 442.5 312 406.6 312 361c0-26.72 11.84-54.39 24.38-83.69C348.2 249.8 359.8 221.3 362.3 192h43.4c2.551 29.35 14.14 57.78 25.93 85.33C444.2 306.6 456 334.3 456 361C456 406.3 437.9 442.2 422.6 472.6zM180.7 181c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.49-83.47-74.71-83.55c-37.06 0-74.61 28.7-74.61 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 26.72-11.84 54.41-24.38 83.7C37.72 295.7 24 327.8 24 361c0 53.2 21 94.63 36.97 126.1C68.75 502.5 84.19 512 101.2 512h53.63C171.9 512 187.4 502.4 196 485.4c15.19-30.17 36-71.48 36-124.4c0-33.27-13.72-65.3-26.97-96.28C192.5 235.4 180.7 207.8 180.7 181zM127.1 32c21.25 .0469 42.69 16 42.69 51.55c0 32.52-12.91 51.22-19.17 76.45H104.5C98.39 135.3 85.34 115.9 85.34 83.55C85.34 47.94 106.7 32 127.1 32zM166.6 472.6C164.3 477.2 159.8 480 154.8 480H101.2c-4.938 0-9.438-2.828-12.34-8.562C74.22 442.5 56 406.6 56 361c0-26.72 11.84-54.39 24.38-83.69C92.16 249.8 103.8 221.3 106.3 192h43.4c2.551 29.35 14.14 57.78 25.93 85.33C188.2 306.6 200 334.3 200 361C200 406.3 181.9 442.2 166.6 472.6z"],
    "box": [448, 512, [128230], "f466", "M342.4 32C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4zM342.4 64H240V160H405.9L371.7 83C366.5 71.45 355.1 64 342.4 64V64zM416 192H32V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V192zM42.13 160H208V64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160z"],
    "box-archive": [512, 512, ["archive"], "f187", "M464 32h-416C21.49 32 0 53.49 0 80v64C0 152.8 7.25 160 16 160H32v256c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V160h16C504.8 160 512 152.8 512 144V80C512 53.49 490.5 32 464 32zM448 416c0 17.6-14.4 32-32 32H96c-17.6 0-32-14.4-32-32V160h384V416zM480 128H32V80C32 71.25 39.25 64 48 64h416C472.8 64 480 71.25 480 80V128zM176 256h160C344.8 256 352 248.8 352 240S344.8 224 336 224h-160C167.2 224 160 231.2 160 240S167.2 256 176 256z"],
    "box-ballot": [576, 512, [128499], "f735", "M528 160h-32C487.2 160 480 167.2 480 176S487.2 192 496 192h32C536.8 192 544 199.2 544 208V320H32V208C32 199.2 39.19 192 48 192h32C88.84 192 96 184.8 96 176S88.84 160 80 160h-32C21.53 160 0 181.5 0 208v256C0 490.5 21.53 512 48 512h480c26.47 0 48-21.53 48-48v-256C576 181.5 554.5 160 528 160zM544 464c0 8.828-7.188 16-16 16h-480C39.19 480 32 472.8 32 464V352h512V464zM144 256h288C440.8 256 448 248.8 448 240v-192C448 21.53 426.5 0 400 0h-224C149.5 0 128 21.53 128 48v192C128 248.8 135.2 256 144 256zM160 48C160 39.17 167.2 32 176 32h224C408.8 32 416 39.17 416 48V224H160V48z"],
    "box-check": [448, 512, [], "f467", "M203.3 379.3C197.1 385.6 186.9 385.6 180.7 379.3L124.7 323.3C118.4 317.1 118.4 306.9 124.7 300.7C130.9 294.4 141.1 294.4 147.3 300.7L192 345.4L292.7 244.7C298.9 238.4 309.1 238.4 315.3 244.7C321.6 250.9 321.6 261.1 315.3 267.3L203.3 379.3zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM240 160H405.9L371.7 83C366.5 71.45 355.1 64 342.4 64H240V160zM32 192V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V192H32zM208 64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160H208L208 64z"],
    "box-circle-check": [576, 512, [], "e0c4", "M32 192V416C32 433.7 46.33 448 64 448H275.2C281 459.4 288.1 470.2 296.2 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V192H32zM240 160H405.9L371.7 83C366.5 71.45 355.1 64 342.4 64H240V160zM208 64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160H208L208 64zM499.3 324.7C505.6 330.9 505.6 341.1 499.3 347.3L427.3 419.3C421.1 425.6 410.9 425.6 404.7 419.3L364.7 379.3C358.4 373.1 358.4 362.9 364.7 356.7C370.9 350.4 381.1 350.4 387.3 356.7L416 385.4L476.7 324.7C482.9 318.4 493.1 318.4 499.3 324.7H499.3zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M240 233.6C245.9 234.6 258.1 237.2 264.1 238.5C272.7 240.8 277.7 249.6 275.5 258.1C273.2 266.7 264.4 271.7 255.9 269.5C251.9 268.4 238.2 265.7 233.8 265C220.9 263 210.1 264.6 202.9 267.9C195.7 271.2 192.1 275.4 192.4 278.1C191.7 283.1 192.3 285.2 192.9 286.4C193.5 287.8 194.8 289.5 197.8 291.5C204.6 296.1 214.9 299.3 228.8 303.5L229.4 303.7C241.7 307.4 257.3 312.1 268.9 320.5C275.1 325 280.9 331.1 284.5 339.3C288.1 347.6 288.8 356.8 287.2 366.5C284.1 383.1 272.6 395.9 257.9 402.2C252.3 404.6 246.3 406.2 240 407.1V416C240 424.8 232.8 432 224 432C215.2 432 208 424.8 208 416V406.4C198.6 404.6 184.4 399.8 175.6 396.7C173.8 396.1 172.2 395.6 170.9 395.2C162.6 392.4 158 383.3 160.8 374.9C163.6 366.6 172.7 362 181.1 364.8C182.1 365.5 185.1 366.2 187.2 366.9C196.7 370.1 207.9 373.9 214.3 374.1C227.6 377 238.3 375.8 245.3 372.8C251.8 370 254.7 366.1 255.6 361C256.4 356.4 255.8 353.7 255.1 352.1C254.4 350.4 252.9 348.5 250 346.4C243.5 341.6 233.3 338.3 219.6 334.1L217.5 333.5C205.7 329.9 190.9 325.5 179.9 317.1C173.6 313.8 167.7 308 163.9 300.1C160.1 292 159.2 283 160.8 273.5C163.7 256.8 175.6 245.2 189.7 238.8C195.3 236.2 201.5 234.4 208 233.3V223.1C208 215.2 215.2 207.1 224 207.1C232.8 207.1 240 215.2 240 223.1L240 233.6zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM240 160H405.9L371.7 83C366.5 71.45 355.1 64 342.4 64H240V160zM32 192V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V192H32zM208 64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160H208L208 64z"],
    "box-heart": [448, 512, [], "f49d", "M224 244.8L226.1 241.8C253.7 215.1 297.1 215.1 323.9 241.8C350.6 268.6 350.6 311.1 323.9 338.7L246.6 416C234.1 428.5 213.9 428.5 201.4 416L124.1 338.7C97.35 311.1 97.35 268.6 124.1 241.8C150.9 215.1 194.3 215.1 221 241.8L224 244.8zM146.7 316.1L224 393.4L301.3 316.1C315.5 301.9 315.5 278.7 301.3 264.5C286.1 250.2 263.9 250.2 249.6 264.5L224 290.1L198.4 264.5C184.1 250.2 161 250.2 146.7 264.5C132.5 278.7 132.5 301.9 146.7 316.1L146.7 316.1zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM240 160H405.9L371.7 83C366.5 71.45 355.1 64 342.4 64H240V160zM32 192V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V192H32zM208 64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160H208L208 64z"],
    "box-open": [640, 512, [], "f49e", "M320 77.23L559.6 49.48C573.7 47.85 587.2 55.65 592.7 68.66L624.7 143.3C634.6 166.2 621.3 192.4 596.1 198L437.8 234.8C418.8 239.1 399.2 231.7 387.9 215.9L320 120.9L252.1 215.9C240.8 231.7 221.2 239.1 202.3 234.8L43.04 198C18.75 192.4 5.449 166.2 15.27 143.3L47.26 68.66C52.84 55.65 66.3 47.85 80.36 49.48L320 77.23zM44.68 155.9C42.72 160.5 45.38 165.7 50.24 166.9L209.4 203.6C215.7 205.1 222.3 202.6 226.1 197.3L291.2 106.1L76.68 81.27L44.68 155.9zM413.9 197.3C417.7 202.6 424.3 205.1 430.6 203.6L589.8 166.9C594.6 165.7 597.3 160.5 595.3 155.9L563.3 81.27L348.8 106.1L413.9 197.3zM544 236.7L576 227.6V378.5C576 400.5 561 419.7 539.6 425.1L331.6 477.1C324 479 316 479 308.4 477.1L100.4 425.1C78.99 419.7 64 400.5 64 378.5V227.6L96 236.7V378.5C96 385.9 100.1 392.3 108.1 394L304 443V207.1C304 199.2 311.2 191.1 320 191.1C328.8 191.1 336 199.2 336 207.1V443L531.9 394C539 392.3 544 385.9 544 378.5L544 236.7z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M255.1 32C202.1 32 159.1 74.98 159.1 128C159.1 136.8 152.8 144 143.1 144C135.2 144 127.1 136.8 127.1 128C127.1 57.31 185.3 0 255.1 0C326.7 0 384 57.31 384 128C384 136.8 376.8 144 368 144C359.2 144 352 136.8 352 128C352 74.98 309 32 255.1 32zM320 189.2L559.6 161.5C573.7 159.9 587.2 167.7 592.7 180.7L624.7 255.3C634.6 278.2 621.2 304.4 596.1 310L437.7 346.8C418.8 351.2 399.2 343.7 387.9 327.9L319.1 232.9L252.1 327.9C240.8 343.7 221.2 351.1 202.2 346.8L43.04 310C18.75 304.4 5.447 278.2 15.27 255.3L47.26 180.7C52.84 167.7 66.29 159.9 80.35 161.5L320 189.2zM44.68 267.9C42.72 272.5 45.38 277.7 50.23 278.9L209.4 315.6C215.7 317.1 222.3 314.6 226.1 309.3L291.2 218.1L76.67 193.3L44.68 267.9zM413.9 309.3C417.7 314.6 424.2 317.1 430.6 315.6L589.8 278.9C594.6 277.7 597.3 272.5 595.3 267.9L563.3 193.3L348.8 218.1L413.9 309.3zM576 339.6V410.5C576 432.5 561 451.7 539.6 457.1L331.6 509.1C323.1 511 316 511 308.4 509.1L100.4 457.1C78.99 451.7 63.1 432.5 63.1 410.5V339.6L95.1 348.7V410.5C95.1 417.9 100.1 424.3 108.1 426L303.1 475V336C303.1 327.2 311.2 319.1 319.1 319.1C328.8 319.1 336 327.2 336 336V475L531.9 426C539 424.3 543.1 417.9 543.1 410.5V348.7L576 339.6zM463.2 133.1C460.4 141.4 451.3 145.1 442.9 143.2C434.6 140.4 430 131.3 432.8 122.9L464.8 26.94C467.6 18.56 476.7 14.03 485.1 16.82C493.4 19.62 497.1 28.68 495.2 37.06L463.2 133.1z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M342.4 32C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4zM405.9 160L371.7 83C366.5 71.45 355.1 64 342.4 64H270L288 160H405.9zM255.4 160L237.4 64H210.6L192.6 160H255.4zM256 192H192V256H256V192zM160 192H32V416C32 433.7 46.33 448 64 448H384C401.7 448 416 433.7 416 416V192H288V256C288 273.7 273.7 288 256 288H192C174.3 288 160 273.7 160 256V192zM160 160L178 64H105.6C92.95 64 81.49 71.45 76.35 83L42.13 160H160z"],
    "box-tissue": [512, 512, [], "e05b", "M144 320h224c10.33 0 19.48-6.578 22.84-16.62l55.94-175.8c2.422-7.297 1.188-15.38-3.312-21.61C438.1 99.72 431.7 96 424 96h-85.41c-19.92 0-37.53-12.69-43.83-31.59C281.9 25.89 246 0 205.4 0H88C80.67 0 73.84 3.281 69.28 8.984c-4.594 5.719-6.312 13.11-4.766 19.98l56.05 272.2C123 312.3 132.7 320 144 320zM205.4 32c26.81 0 50.53 17.09 59 42.52C275.1 106.5 304.9 128 338.6 128h74.47l-50.91 160H150.5L97.81 32H205.4zM464 224H448c-8.844 0-16 7.156-16 16S439.2 256 448 256h16C472.8 256 480 263.2 480 272V384H32V272C32 263.2 39.19 256 48 256H64c8.844 0 16-7.156 16-16S72.84 224 64 224H48C21.53 224 0 245.5 0 272v192C0 490.5 21.53 512 48 512h416c26.47 0 48-21.53 48-48v-192C512 245.5 490.5 224 464 224zM480 464c0 8.828-7.188 16-16 16h-416C39.19 480 32 472.8 32 464V416h448V464z"],
    "boxes-packing": [640, 512, [], "e4c7", "M592 32H304C295.2 32 288 39.16 288 48V128H256V48C256 21.49 277.5 0 304 0H592C618.5 0 640 21.49 640 48V464C640 490.5 618.5 512 592 512H381.3C383 506.1 384 501.6 384 496V480H592C600.8 480 608 472.8 608 464V48C608 39.16 600.8 32 592 32zM555.3 316.7C561.6 322.9 561.6 333.1 555.3 339.3C549.1 345.6 538.9 345.6 532.7 339.3L496 302.6V432C496 440.8 488.8 448 480 448C471.2 448 464 440.8 464 432V302.6L427.3 339.3C421.1 345.6 410.9 345.6 404.7 339.3C398.4 333.1 398.4 322.9 404.7 316.7L468.7 252.7C474.9 246.4 485.1 246.4 491.3 252.7L555.3 316.7zM240 320C248.8 320 256 327.2 256 336C256 344.8 248.8 352 240 352H144C135.2 352 128 344.8 128 336C128 327.2 135.2 320 144 320H240zM0 192C0 174.3 14.33 160 32 160H352C369.7 160 384 174.3 384 192V256C384 273.7 369.7 288 352 288V480C352 497.7 337.7 512 320 512H64C46.33 512 32 497.7 32 480V288C14.33 288 0 273.7 0 256V192zM352 192H32V256H352V192zM64 480H320V288H64V480z"],
    "boxes-stacked": [576, 512, [62625, "boxes", "boxes-alt"], "f468", "M416 56V168C416 198.9 390.9 224 360 224H216C185.1 224 160 198.9 160 168V56C160 25.07 185.1 0 216 0H360C390.9 0 416 25.07 416 56zM360 32H336V80C336 97.67 321.7 112 304 112H272C254.3 112 240 97.67 240 80V32H216C202.7 32 192 42.75 192 56V168C192 181.3 202.7 192 216 192H360C373.3 192 384 181.3 384 168V56C384 42.75 373.3 32 360 32zM272 80H304V32H272V80zM200 288C230.9 288 256 313.1 256 344V456C256 486.9 230.9 512 200 512H56C25.07 512 0 486.9 0 456V344C0 313.1 25.07 288 56 288H200zM176 368C176 385.7 161.7 400 144 400H112C94.33 400 80 385.7 80 368V320H56C42.75 320 32 330.7 32 344V456C32 469.3 42.75 480 56 480H200C213.3 480 224 469.3 224 456V344C224 330.7 213.3 320 200 320H176V368zM144 320H112V368H144V320zM520 288C550.9 288 576 313.1 576 344V456C576 486.9 550.9 512 520 512H376C345.1 512 320 486.9 320 456V344C320 313.1 345.1 288 376 288H520zM496 368C496 385.7 481.7 400 464 400H432C414.3 400 400 385.7 400 368V320H376C362.7 320 352 330.7 352 344V456C352 469.3 362.7 480 376 480H520C533.3 480 544 469.3 544 456V344C544 330.7 533.3 320 520 320H496V368zM464 320H432V368H464V320z"],
    "boxing-glove": [512, 512, [129354, "glove-boxing"], "f438", "M416 129.6L415.1 96c0-52.94-43.06-96-95.1-96H127.1C75.06 0 32.01 43.06 32.01 96L32 288c0 27.41 11.56 52.87 31.1 71.14L64 448c0 35.3 28.7 64 64 64h192c35.3 0 64-28.7 64-64v-57.38l63.19-63.19C468.3 306.3 480 278.2 480 248.2V208C480 169.4 452.5 137.1 416 129.6zM448 248.2c0 21.38-8.328 41.47-23.44 56.58L352 377.4V448c0 17.64-14.36 32-32 32H128c-17.64 0-32-14.36-32-32v-104.3l-6.359-4.797C73.34 326.6 64 308 64 288V96c0-35.3 28.7-64 64-64h192c35.3 0 64 28.7 64 64v32h-16c-38.63 0-70.95 27.53-78.38 64H217.7C183.1 192 149.6 181.9 120.9 162.7C113.5 157.8 103.6 159.8 98.69 167.1C93.78 174.5 95.78 184.4 103.1 189.3C137.2 212 176.8 224 217.7 224h71.93C297.1 260.5 329.4 288 368 288C376.8 288 384 280.8 384 272S376.8 256 368 256C341.5 256 320 234.5 320 208S341.5 160 368 160h32C426.5 160 448 181.5 448 208V248.2zM285.3 343.1c-4.922-7.375-14.81-9.328-22.19-4.438L224 364.8l-39.13-26.08c-7.391-4.891-17.31-2.938-22.19 4.438c-4.906 7.359-2.922 17.28 4.438 22.19L195.2 384l-28.03 18.69c-7.359 4.906-9.344 14.83-4.438 22.19c3.356 5.043 12.79 10.66 22.19 4.438L224 403.2l39.13 26.08c9.385 6.221 18.78 .6881 22.19-4.438c4.906-7.359 2.922-17.28-4.438-22.19L252.8 384l28.03-18.69C288.2 360.4 290.2 350.5 285.3 343.1z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M96 152.5V112C96 85.53 117.5 64 144 64h64C216.8 64 224 56.82 224 48S216.8 32 208 32h-64C99.89 32 64 67.89 64 112v40.45c0 38.03-21.13 72.22-55.16 89.23C3.383 244.4 0 249.9 0 256s3.383 11.56 8.828 14.3C42.87 287.3 64 321.5 64 359.5V400c0 44.11 35.89 80 80 80h64c8.822 0 16-7.178 16-16S216.8 448 208 448h-64C117.5 448 96 426.5 96 400v-40.45C96 318.7 77.43 280.8 45.79 256C77.43 231.2 96 193.3 96 152.5z"],
    "bracket-curly-right": [256, 512, [], "7d", "M210.2 256C178.6 280.8 160 318.7 160 359.5V400c0 26.47-21.53 48-48 48h-64C39.18 448 32 455.2 32 464S39.18 480 48 480h64c44.11 0 80-35.89 80-80v-40.45c0-38.03 21.13-72.22 55.17-89.24C252.6 267.6 256 262.1 256 256s-3.383-11.56-8.844-14.31C213.1 224.7 192 190.5 192 152.5V112C192 67.89 156.1 32 112 32h-64C39.18 32 32 39.18 32 48S39.18 64 48 64h64C138.5 64 160 85.53 160 112v40.45C160 193.3 178.6 231.2 210.2 256z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M121.4 451.1c7.126 5.188 8.72 15.19 3.532 22.31c-3.157 4.313-8.032 6.625-12.97 6.625c-3.25 0-6.501-1-9.345-3.031c-4.188-3.031-102.6-75.81-102.6-220.1s98.45-217.9 102.6-220.1c7.126-5.125 17.1-3.625 22.31 3.594c5.188 7.125 3.594 17.13-3.532 22.31c-3.657 2.688-89.42 66.78-89.42 195.1S117.8 448.4 121.4 451.1z"],
    "bracket-round-right": [192, 512, [], "29", "M159.1 255.1c0-128.3-85.76-192.4-89.42-195.1C63.46 55.75 61.86 45.75 67.05 38.62c5.219-7.219 15.19-8.719 22.31-3.594C93.55 38.06 192 110.8 192 256s-98.45 217.9-102.6 220.1C86.52 479 83.27 480 80.02 480c-4.938 0-9.813-2.313-12.97-6.625c-5.188-7.125-3.594-17.13 3.532-22.31C74.24 448.4 159.1 384.3 159.1 255.1z"],
    "bracket-square": [192, 512, ["bracket", "bracket-left"], "5b", "M48 64h96C152.8 64 160 56.82 160 48S152.8 32 144 32h-96C21.53 32 0 53.53 0 80v352C0 458.5 21.53 480 48 480h96c8.822 0 16-7.178 16-16S152.8 448 144 448h-96C39.18 448 32 440.8 32 432v-352C32 71.18 39.18 64 48 64z"],
    "bracket-square-right": [192, 512, [], "5d", "M160 80v352c0 8.822-7.178 16-16 16h-96C39.18 448 32 455.2 32 464S39.18 480 48 480h96c26.47 0 48-21.53 48-48v-352C192 53.53 170.5 32 144 32h-96C39.18 32 32 39.18 32 48S39.18 64 48 64h96C152.8 64 160 71.18 160 80z"],
    "brackets-curly": [576, 512, [], "f7ea", "M96 152.5V112C96 85.53 117.5 64 144 64h64C216.8 64 224 56.82 224 48S216.8 32 208 32h-64C99.89 32 64 67.89 64 112v40.45c0 38.03-21.13 72.22-55.16 89.23C3.383 244.4 0 249.9 0 256s3.383 11.56 8.828 14.3C42.87 287.3 64 321.5 64 359.5V400C64 444.1 99.89 480 144 480h64C216.8 480 224 472.8 224 464S216.8 448 208 448h-64C117.5 448 96 426.5 96 400v-40.45C96 318.7 77.43 280.8 45.79 256C77.43 231.2 96 193.3 96 152.5zM567.2 241.7C533.1 224.7 512 190.5 512 152.5V112C512 67.89 476.1 32 432 32h-64C359.2 32 352 39.18 352 48S359.2 64 368 64h64C458.5 64 480 85.53 480 112v40.45C480 193.3 498.6 231.2 530.2 256C498.6 280.8 480 318.7 480 359.5V400c0 26.47-21.53 48-48 48h-64c-8.822 0-16 7.178-16 16s7.178 16 16 16h64c44.11 0 80-35.89 80-80v-40.45c0-38.03 21.13-72.22 55.16-89.23C572.6 267.6 576 262.1 576 256S572.6 244.4 567.2 241.7z"],
    "brackets-round": [512, 512, ["parentheses"], "e0c5", "M121.4 60.93c7.125-5.188 8.719-15.19 3.531-22.31C119.7 31.4 109.8 29.9 102.6 35.03C98.44 38.06 0 110.8 0 256s98.44 217.9 102.6 220.1c2.844 2.031 6.094 3.031 9.344 3.031c4.938 0 9.812-2.313 12.97-6.625c5.188-7.125 3.594-17.13-3.531-22.31C117.8 448.4 32 384.3 32 255.1S117.8 63.62 121.4 60.93zM409.4 35.03c-7.156-5.094-17.06-3.563-22.31 3.594c-5.188 7.125-3.594 17.13 3.531 22.31C394.3 63.62 480 127.7 480 255.1s-85.75 192.4-89.41 195.1c-7.125 5.188-8.719 15.19-3.531 22.31c3.156 4.344 8.031 6.625 12.97 6.625c3.25 0 6.5-1 9.344-3.031C413.6 473.9 512 401.2 512 256S413.6 38.06 409.4 35.03z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M400 32h-96C295.2 32 288 39.18 288 48S295.2 64 304 64h96C408.8 64 416 71.18 416 80v352c0 8.822-7.178 16-16 16h-96c-8.822 0-16 7.178-16 16s7.178 16 16 16h96c26.47 0 48-21.53 48-48v-352C448 53.53 426.5 32 400 32zM48 64h96C152.8 64 160 56.82 160 48S152.8 32 144 32h-96C21.53 32 0 53.53 0 80v352C0 458.5 21.53 480 48 480h96C152.8 480 160 472.8 160 464S152.8 448 144 448h-96C39.18 448 32 440.8 32 432v-352C32 71.18 39.18 64 48 64z"],
    "braille": [640, 512, [], "f2a1", "M48 96C48 87.16 55.16 80 64 80C72.84 80 80 87.16 80 96C80 104.8 72.84 112 64 112C55.16 112 48 104.8 48 96zM0 96C0 60.65 28.65 32 64 32C99.35 32 128 60.65 128 96C128 131.3 99.35 160 64 160C28.65 160 0 131.3 0 96zM64 128C81.67 128 96 113.7 96 96C96 78.33 81.67 64 64 64C46.33 64 32 78.33 32 96C32 113.7 46.33 128 64 128zM160 256C160 220.7 188.7 192 224 192C259.3 192 288 220.7 288 256C288 291.3 259.3 320 224 320C188.7 320 160 291.3 160 256zM224 288C241.7 288 256 273.7 256 256C256 238.3 241.7 224 224 224C206.3 224 192 238.3 192 256C192 273.7 206.3 288 224 288zM128 416C128 451.3 99.35 480 64 480C28.65 480 0 451.3 0 416C0 380.7 28.65 352 64 352C99.35 352 128 380.7 128 416zM64 384C46.33 384 32 398.3 32 416C32 433.7 46.33 448 64 448C81.67 448 96 433.7 96 416C96 398.3 81.67 384 64 384zM288 416C288 451.3 259.3 480 224 480C188.7 480 160 451.3 160 416C160 380.7 188.7 352 224 352C259.3 352 288 380.7 288 416zM224 384C206.3 384 192 398.3 192 416C192 433.7 206.3 448 224 448C241.7 448 256 433.7 256 416C256 398.3 241.7 384 224 384zM80 256C80 264.8 72.84 272 64 272C55.16 272 48 264.8 48 256C48 247.2 55.16 240 64 240C72.84 240 80 247.2 80 256zM128 256C128 291.3 99.35 320 64 320C28.65 320 0 291.3 0 256C0 220.7 28.65 192 64 192C99.35 192 128 220.7 128 256zM64 224C46.33 224 32 238.3 32 256C32 273.7 46.33 288 64 288C81.67 288 96 273.7 96 256C96 238.3 81.67 224 64 224zM240 96C240 104.8 232.8 112 224 112C215.2 112 208 104.8 208 96C208 87.16 215.2 80 224 80C232.8 80 240 87.16 240 96zM288 96C288 131.3 259.3 160 224 160C188.7 160 160 131.3 160 96C160 60.65 188.7 32 224 32C259.3 32 288 60.65 288 96zM224 64C206.3 64 192 78.33 192 96C192 113.7 206.3 128 224 128C241.7 128 256 113.7 256 96C256 78.33 241.7 64 224 64zM400 96C400 87.16 407.2 80 416 80C424.8 80 432 87.16 432 96C432 104.8 424.8 112 416 112C407.2 112 400 104.8 400 96zM352 96C352 60.65 380.7 32 416 32C451.3 32 480 60.65 480 96C480 131.3 451.3 160 416 160C380.7 160 352 131.3 352 96zM416 128C433.7 128 448 113.7 448 96C448 78.33 433.7 64 416 64C398.3 64 384 78.33 384 96C384 113.7 398.3 128 416 128zM640 96C640 131.3 611.3 160 576 160C540.7 160 512 131.3 512 96C512 60.65 540.7 32 576 32C611.3 32 640 60.65 640 96zM576 64C558.3 64 544 78.33 544 96C544 113.7 558.3 128 576 128C593.7 128 608 113.7 608 96C608 78.33 593.7 64 576 64zM512 256C512 220.7 540.7 192 576 192C611.3 192 640 220.7 640 256C640 291.3 611.3 320 576 320C540.7 320 512 291.3 512 256zM576 288C593.7 288 608 273.7 608 256C608 238.3 593.7 224 576 224C558.3 224 544 238.3 544 256C544 273.7 558.3 288 576 288zM640 416C640 451.3 611.3 480 576 480C540.7 480 512 451.3 512 416C512 380.7 540.7 352 576 352C611.3 352 640 380.7 640 416zM576 384C558.3 384 544 398.3 544 416C544 433.7 558.3 448 576 448C593.7 448 608 433.7 608 416C608 398.3 593.7 384 576 384zM352 256C352 220.7 380.7 192 416 192C451.3 192 480 220.7 480 256C480 291.3 451.3 320 416 320C380.7 320 352 291.3 352 256zM416 288C433.7 288 448 273.7 448 256C448 238.3 433.7 224 416 224C398.3 224 384 238.3 384 256C384 273.7 398.3 288 416 288zM480 416C480 451.3 451.3 480 416 480C380.7 480 352 451.3 352 416C352 380.7 380.7 352 416 352C451.3 352 480 380.7 480 416zM416 384C398.3 384 384 398.3 384 416C384 433.7 398.3 448 416 448C433.7 448 448 433.7 448 416C448 398.3 433.7 384 416 384z"],
    "brain": [512, 512, [129504], "f5dc", "M256 480C241.4 499.4 218.2 512 192 512C162.4 512 136.5 495.9 122.7 471.1C121.8 471.1 120.9 472 120 472C71.4 472 32 432.6 32 384C32 376.4 32.97 369 34.79 361.1C13.56 344.4 0 317.8 0 288C0 262.9 9.646 240 25.4 222.1C24.48 218.1 24 213.1 24 208C24 178.4 40.12 152.5 64.04 138.7C64.01 137.8 64 136.9 64 136C64 102.4 84.73 73.63 114.1 61.79C122.3 26.37 154.1 0 192 0C218.2 0 241.4 12.57 256 31.99C270.6 12.57 293.8 0 320 0C357.9 0 389.7 26.37 397.9 61.79C427.3 73.63 448 102.4 448 136C448 136.9 447.1 137.8 447.1 138.7C471.9 152.5 488 178.4 488 208C488 213.1 487.5 218.1 486.6 222.1C502.4 240 512 262.9 512 288C512 317.8 498.4 344.4 477.2 361.1C479 369 480 376.4 480 384C480 432.6 440.6 472 392 472C391.1 472 390.2 471.1 389.3 471.1C375.5 495.9 349.6 512 320 512C293.8 512 270.6 499.4 256 480zM143.2 86.69L132.2 89.46C111.4 94.71 96 113.6 96 136C96 139.1 96.3 142.2 96.87 145.2L99.41 158.3L86.87 163.1C68.79 170 55.1 187.6 55.1 208C55.1 213.2 56.84 218.3 58.37 222.1L61.65 232.1L53.74 239.9C40.38 251.7 31.1 268.9 31.1 288C31.1 310.9 44.01 331 62.16 342.3L73.75 349.6L68.42 362.2C65.58 368.8 63.1 376.2 63.1 384C63.1 414.9 89.07 440 119.1 440C123.3 440 126.5 439.7 129.5 439.2L142.5 436.1L147.2 449.2C154.1 467.3 171.6 480 191.1 480C218.5 480 239.1 458.5 239.1 432V80C239.1 53.49 218.5 32 191.1 32C167 32 146.5 51.08 144.2 75.44L143.2 86.69zM272 432C272 458.5 293.5 480 320 480C340.4 480 357.9 467.2 364.8 449.2L369.5 436.1L382.5 439.2C385.5 439.7 388.7 440 392 440C422.9 440 448 414.9 448 384C448 376.2 446.4 368.8 443.6 362.2L438.2 349.6L449.8 342.3C467.1 331 480 310.9 480 287.1C480 268.9 471.6 251.7 458.3 239.9L450.3 232.1L453.6 222.1C455.2 218.3 456 213.2 456 207.1C456 187.6 443.2 170 425.1 163.1L412.6 158.3L415.1 145.2C415.7 142.2 416 139.1 416 135.1C416 113.6 400.6 94.71 379.8 89.46L368.8 86.69L367.8 75.44C365.5 51.08 344.1 31.1 319.1 31.1C293.5 31.1 271.1 53.49 271.1 79.1L272 432z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M223.5 32.2C251.8 33.68 272.9 59.02 272.9 87.29v201.8c0 8.873 7.191 16.06 16.06 16.06s16.06-7.191 16.06-16.06V87.29c0-28.27 21.17-53.61 49.4-55.09c30.11-1.576 55.01 22.37 55.01 52.13c0 1.555-.3242 3.02-.457 4.539c23.26 5.484 40.62 26.25 40.62 51.18c0 7.609-1.684 14.8-4.584 21.33c20.03 2.893 36.27 17.07 42.16 35.91c2.113 6.768 8.123 11.53 15.21 11.53c10.7 0 18.49-10.38 15.36-20.61c-5.963-19.5-18.78-36.24-36.03-46.92c.0059-.4082 .0078-.8203 .0078-1.232c0-30.85-16.42-58.3-41.97-73.15C431.7 28.73 397.8 0 357.3 0c-28.04 0-52.93 13.76-68.27 34.87C273.7 13.76 248.8 0 220.7 0C180.2 0 146.3 28.73 138.2 66.9c-23.53 13.68-39.32 38.05-41.67 65.92c-24.5 14.97-40.46 41.96-40.46 71.98c0 6.32 .709 12.57 2.096 18.66C41.63 241.1 32 264.5 32 289.1c0 28.71 12.55 55.09 33.51 73.03c-.918 5.057-1.385 10.18-1.385 15.31c0 48.27 38.91 87.63 87.02 88.34c9.809 22.39 29.54 39.48 53.6 45.68c10.12 2.605 20.01-5.16 20.01-15.61c0-7.609-5.473-13.69-12.81-15.71c-20.4-5.609-35.38-24.29-35.38-46.47c0-2.035 .3535-3.975 .5996-5.943c-12.89 6.348-28.23 8.463-44.86 2.086c-15.72-6.031-28.37-19.25-33.39-35.32c-5.348-17.1-2.199-33.02 5.518-45.86c-23.6-9.506-40.3-32.53-40.3-59.53c0-23.97 13.28-44.62 32.72-55.66C91.42 225.2 88.22 215.4 88.22 204.8c0-25.38 18.13-46.49 42.14-51.19c-1.166-4.354-1.984-8.844-1.984-13.56c0-24.93 17.36-45.7 40.61-51.18C168.9 87.35 168.5 85.88 168.5 84.33C168.5 54.57 193.4 30.62 223.5 32.2zM603.3 340.7l-96-96c-6.25-6.25-16.38-6.25-22.63 0s-6.25 16.38 0 22.62L553.4 336H352c-44.11 0-80 35.88-80 80l-.002 79.9C271.1 504.7 279.2 512 288 512s16-7.156 16-16V416c0-26.47 21.53-48 48-48h201.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62C487.8 462.4 491.9 464 495.1 464s8.053-1.514 11.18-4.639l96.14-96.05C609.6 357.1 609.6 346.9 603.3 340.7z"],
    "brain-circuit": [512, 512, [], "e0c6", "M122.7 471.1C121.8 471.1 120.9 472 120 472C71.4 472 32 432.6 32 384C32 376.4 32.97 369 34.79 361.1C13.56 344.4 0 317.8 0 288C0 262.9 9.646 240 25.4 222.1C24.48 218.1 24 213.1 24 208C24 178.4 40.12 152.5 64.04 138.7C64.01 137.8 64 136.9 64 136C64 102.4 84.73 73.63 114.1 61.79C122.3 26.37 154.1 0 192 0C218.2 0 241.4 12.57 256 31.99C270.6 12.57 293.8 0 320 0C357.9 0 389.7 26.37 397.9 61.79C427.3 73.63 448 102.4 448 136C448 136.9 447.1 137.8 447.1 138.7C471.9 152.5 488 178.4 488 208C488 213.1 487.5 218.1 486.6 222.1C502.4 240 512 262.9 512 288C512 317.8 498.4 344.4 477.2 361.1C479 369 480 376.4 480 384C480 432.6 440.6 472 392 472C391.1 472 390.2 471.1 389.3 471.1C375.5 495.9 349.6 512 320 512C293.8 512 270.6 499.4 256 480C241.4 499.4 218.2 512 192 512C162.4 512 136.5 495.9 122.7 471.1zM192 32C167 32 146.5 51.08 144.2 75.44L143.2 86.69L132.2 89.46C111.4 94.71 96 113.6 96 136C96 139.1 96.3 142.2 96.87 145.2L99.41 158.3L86.87 163.1C68.79 170 55.1 187.6 55.1 208C55.1 213.2 56.84 218.3 58.37 222.1L61.65 232.1L53.74 239.9C40.38 251.7 31.1 268.9 31.1 288C31.1 310.9 44.01 331 62.16 342.3L73.75 349.6L68.42 362.2C65.58 368.8 63.1 376.2 63.1 384C63.1 414.9 89.07 440 119.1 440C123.3 440 126.5 439.7 129.5 439.2L142.5 436.1L147.2 449.2C154.1 467.3 171.6 480 191.1 480C218.5 480 239.1 458.5 239.1 432V304H191.1C184.7 304 178.5 308.9 176.6 315.6C190.4 321.9 199.1 335.8 199.1 352C199.1 374.1 182.1 392 159.1 392C137.9 392 119.1 374.1 119.1 352C119.1 335.5 129.1 321.3 144.2 315.2C146.6 290.1 167.1 272 191.1 272H239.1V160H212.7C206.5 174.1 192.4 184 175.1 184C153.9 184 135.1 166.1 135.1 144C135.1 121.9 153.9 104 175.1 104C192.4 104 206.5 113.9 212.7 128H239.1V80C239.1 53.49 218.5 32 191.1 32L192 32zM272 352H331.3C337.5 337.9 351.6 328 368 328C390.1 328 408 345.9 408 368C408 390.1 390.1 408 368 408C351.6 408 337.5 398.1 331.3 384H272V432C272 458.5 293.5 480 320 480C340.4 480 357.9 467.2 364.8 449.2L369.5 436.1L382.5 439.2C385.5 439.7 388.7 440 392 440C422.9 440 448 414.9 448 384C448 376.2 446.4 368.8 443.6 362.2L438.2 349.6L449.8 342.3C467.1 331 480 310.9 480 287.1C480 268.9 471.6 251.7 458.3 239.9L450.3 232.1L453.6 222.1C455.2 218.3 456 213.2 456 207.1C456 187.6 443.2 170 425.1 163.1L412.6 158.3L415.1 145.2C415.7 142.2 416 139.1 416 135.1C416 113.6 400.6 94.71 379.8 89.46L368.8 86.69L367.8 75.44C365.5 51.08 344.1 31.1 320 31.1C293.5 31.1 272 53.49 272 79.1V127.1H320C346.5 127.1 368 149.5 368 175.1V187.3C382.1 193.5 392 207.6 392 223.1C392 246.1 374.1 263.1 352 263.1C329.9 263.1 312 246.1 312 223.1C312 207.6 321.9 193.5 336 187.3V175.1C336 167.2 328.8 159.1 320 159.1H272L272 352zM176 160C184.8 160 192 152.8 192 144C192 135.2 184.8 128 176 128C167.2 128 160 135.2 160 144C160 152.8 167.2 160 176 160zM160 368C168.8 368 176 360.8 176 352C176 343.2 168.8 336 160 336C151.2 336 144 343.2 144 352C144 360.8 151.2 368 160 368zM368 224C368 215.2 360.8 208 352 208C343.2 208 336 215.2 336 224C336 232.8 343.2 240 352 240C360.8 240 368 232.8 368 224zM368 384C376.8 384 384 376.8 384 368C384 359.2 376.8 352 368 352C359.2 352 352 359.2 352 368C352 376.8 359.2 384 368 384z"],
    "brake-warning": [640, 512, [], "e0c7", "M336 272C336 280.8 328.8 288 319.1 288C311.2 288 303.1 280.8 303.1 272V144C303.1 135.2 311.2 128 319.1 128C328.8 128 336 135.2 336 144V272zM295.1 352C295.1 338.7 306.7 328 319.1 328C333.3 328 344 338.7 344 352C344 365.3 333.3 376 319.1 376C306.7 376 295.1 365.3 295.1 352zM95.1 256C95.1 132.3 196.3 32 319.1 32C443.7 32 544 132.3 544 256C544 379.7 443.7 480 319.1 480C196.3 480 95.1 379.7 95.1 256zM319.1 448C426 448 512 362 512 256C512 149.1 426 64 319.1 64C213.1 64 127.1 149.1 127.1 256C127.1 362 213.1 448 319.1 448zM31.1 256C31.1 313.3 48.69 366.6 77.46 411.4C82.24 418.8 80.08 428.7 72.64 433.5C65.21 438.3 55.31 436.1 50.54 428.7C18.55 378.8 0 319.6 0 256C0 192.4 18.55 133.2 50.54 83.34C55.31 75.9 65.21 73.74 72.64 78.52C80.08 83.29 82.24 93.19 77.46 100.6C48.69 145.4 31.1 198.7 31.1 256zM640 256C640 319.6 621.4 378.8 589.5 428.7C584.7 436.1 574.8 438.3 567.4 433.5C559.9 428.7 557.8 418.8 562.5 411.4C591.3 366.6 608 313.3 608 256C608 198.7 591.3 145.4 562.5 100.6C557.8 93.19 559.9 83.29 567.4 78.52C574.8 73.74 584.7 75.9 589.5 83.34C621.4 133.2 640 192.4 640 256V256z"],
    "brazilian-real-sign": [512, 512, [], "e46c", "M400 0C408.8 0 416 7.164 416 16V64.53C432.8 65.89 449.3 69.9 464.9 76.43L478.2 82.01C486.3 85.42 490.2 94.8 486.8 102.9C483.3 111.1 473.1 114.9 465.8 111.5L452.5 105.9C436.9 99.38 420 95.1 403 95.1H387.3C350.1 95.1 320 126.1 320 163.3C320 191.9 338.1 217.4 365.1 226.9L445.4 254.9C485.3 268.8 512 306.5 512 348.7C512 402.4 469.3 446.2 416 447.9V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V447.5C361.9 445.8 340.5 438.1 321.4 427.6L295.8 412.2C288.2 407.7 285.7 397.8 290.3 390.3C294.8 382.7 304.6 380.2 312.2 384.7L337.9 400.1C355.2 410.5 375.1 416 395.4 416H412.7C449.9 416 480 385.9 480 348.7C480 320.1 461.9 294.6 434.9 285.1L354.6 257.1C314.7 243.2 288 205.5 288 163.3C288 109.6 330.7 65.8 384 64.05V16C384 7.164 391.2 0 400 0L400 0zM.0003 80C.0003 53.49 21.49 32 48 32H112C191.5 32 256 96.47 256 176C256 241.6 212.1 296.1 152.1 314.3L206.1 458.3C210.1 466.6 205.1 475.8 197.7 478.1C189.4 482.1 180.2 477.1 177 469.7L119.9 319.8C117.3 319.9 114.7 320 112 320H32V464C32 472.8 24.84 480 16 480C7.164 480 0 472.8 0 464L.0003 80zM32 288H112C173.9 288 224 237.9 224 176C224 114.1 173.9 64 112 64H48C39.16 64 32 71.16 32 80V288z"],
    "bread-loaf": [640, 512, [127838], "f7eb", "M400 32h-160C107.5 32 0 103.6 0 192c0 35.38 30.88 64 64 64v192c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32V256c33.13 0 64-28.62 64-64C640 103.6 532.5 32 400 32zM384 240V448H96V240C96 231.2 88.84 224 80 224H64C48.5 224 32 209.6 32 192c0-69.38 95.25-128 208-128S448 122.6 448 192c0 17.62-12.5 32-28 32H400C391.2 224 384 231.2 384 240zM544 448h-128V256h128V448zM580 224h-108.4C477.1 214.3 480 203.3 480 192c0-52.38-38-98.88-96.5-128H400C512.8 64 608 122.6 608 192C608 209.6 595.5 224 580 224z"],
    "bread-slice": [512, 512, [], "f7ec", "M256 32C102.9 32 0 115.2 0 192.1c0 34.84 26.67 60.29 64 62.59v178.4C64 459.4 84.63 480 109.1 480h292C427.4 480 448 459.4 448 434V255.6c37.33-2.293 64-27.75 64-62.59C512 115.2 409.1 32 256 32zM442.7 224C427.9 224 416 235.9 416 250.7v183.3C416 441.7 409.7 448 401.1 448h-292C102.3 448 96 441.7 96 434v-183.3C96 235.9 84.07 224 69.34 224C47 224 32 211.5 32 192.1C32 140.3 111.8 64 256 64s224 76.25 224 128.1C480 211.5 465 224 442.7 224z"],
    "bread-slice-butter": [512, 512, [], "e3e1", "M512 192.1C511.8 209.7 504.1 225.8 492.1 237.5C480.1 249.2 464.8 255.7 448 255.6V433.1C447.1 446.2 443.1 457.9 434.5 466.5C425.9 475.1 414.2 479.1 401.1 480H109.1C97.79 479.1 86.1 475.1 77.48 466.5C68.86 457.9 64.01 446.2 64 433.1V255.6C47.22 255.7 31.05 249.2 19.04 237.5C7.044 225.8 .1939 209.7 0 192.1C0 115.2 102.9 32 256 32C409.1 32 512 115.2 512 192.1zM480 192.1C480 140.3 400.2 64 256 64C111.8 64 32 140.3 32 192.1C32 211.5 47.01 224 69.34 224C76.41 224 83.19 226.8 88.19 231.8C93.19 236.8 96 243.6 96 250.7V433.1C96 437.7 97.47 441.3 100.1 443.9C102.7 446.5 106.3 447.1 109.1 448H401.1C403.8 448 405.6 447.6 407.3 446.9C409 446.2 410.6 445.2 411.9 443.9C413.2 442.6 414.2 441 414.9 439.3C415.6 437.6 416 435.8 416 433.1V250.7C416 243.6 418.8 236.8 423.8 231.8C428.8 226.8 435.6 224 442.7 224C464.1 224 480 211.5 480 192.1zM335.2 254C339.7 258.5 343.2 263.8 345.6 269.6C348 275.4 349.3 281.7 349.3 288C349.3 294.3 348 300.6 345.6 306.4C343.2 312.2 339.7 317.5 335.2 321.1L289.1 367.2C285.5 371.7 280.2 375.2 274.4 377.6C268.6 380 262.3 381.3 256 381.3C249.7 381.3 243.4 380 237.6 377.6C231.8 375.2 226.5 371.7 222 367.2L176.8 321.1C172.3 317.5 168.8 312.2 166.4 306.4C163.1 300.6 162.7 294.3 162.7 288C162.7 281.7 163.1 275.4 166.4 269.6C168.8 263.8 172.3 258.5 176.8 254L222 208.8C226.5 204.3 231.8 200.8 237.6 198.4C243.4 195.1 249.7 194.7 256 194.7C262.3 194.7 268.6 195.1 274.4 198.4C280.2 200.8 285.5 204.3 289.1 208.8L335.2 254zM316.1 294.1C316.9 292.2 317.3 290.1 317.3 288C317.3 285.9 316.9 283.8 316.1 281.9C315.2 279.9 314.1 278.2 312.6 276.7L267.3 231.4C265.8 229.9 264.1 228.8 262.1 227.9C260.2 227.1 258.1 226.7 256 226.7C253.9 226.7 251.8 227.1 249.9 227.9C247.9 228.8 246.2 229.9 244.7 231.4L199.4 276.7C197.9 278.2 196.8 279.9 195.9 281.9C195.1 283.8 194.7 285.9 194.7 288C194.7 290.1 195.1 292.2 195.9 294.1C196.8 296.1 197.9 297.8 199.4 299.3L244.7 344.6C246.2 346.1 247.9 347.2 249.9 348.1C251.8 348.9 253.9 349.3 256 349.3C258.1 349.3 260.2 348.9 262.1 348.1C264.1 347.2 265.8 346.1 267.3 344.6L312.6 299.3C314.1 297.8 315.2 296.1 316.1 294.1z"],
    "bridge": [576, 512, [], "e4c8", "M560 32C568.8 32 576 39.16 576 48C576 56.84 568.8 64 560 64H496V128H560C568.8 128 576 135.2 576 144C576 152.8 568.8 160 560 160H16C7.164 160 0 152.8 0 144C0 135.2 7.164 128 16 128H80V64H16C7.164 64 0 56.84 0 48C0 39.16 7.164 32 16 32H560zM464 64H368V128H464V64zM240 64V128H336V64H240zM208 64H112V128H208V64zM32 240C85.02 240 128 282.1 128 336V432C128 440.8 135.2 448 144 448H176C184.8 448 192 440.8 192 432V336C192 282.1 234.1 240 288 240C341 240 384 282.1 384 336V432C384 440.8 391.2 448 400 448H432C440.8 448 448 440.8 448 432V336C448 282.1 490.1 240 544 240H560C568.8 240 576 247.2 576 256C576 264.8 568.8 272 560 272H544C508.7 272 480 300.7 480 336V432C480 458.5 458.5 480 432 480H400C373.5 480 352 458.5 352 432V336C352 300.7 323.3 272 288 272C252.7 272 224 300.7 224 336V432C224 458.5 202.5 480 176 480H144C117.5 480 96 458.5 96 432V336C96 300.7 67.35 272 32 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H32z"],
    "bridge-circle-check": [640, 512, [], "e4c9", "M592 32C600.8 32 608 39.16 608 48C608 56.84 600.8 64 592 64H528V128H592C600.8 128 608 135.2 608 144C608 152.8 600.8 160 592 160H48C39.16 160 32 152.8 32 144C32 135.2 39.16 128 48 128H112V64H48C39.16 64 32 56.84 32 48C32 39.16 39.16 32 48 32H592zM496 64H400V128H496V64zM272 64V128H368V64H272zM240 64H144V128H240V64zM64 240C117 240 160 282.1 160 336V432C160 440.8 167.2 448 176 448H208C216.8 448 224 440.8 224 432V336C224 282.1 266.1 240 320 240C336.1 240 351.2 243.1 364.6 250.9C357.3 259 350.9 267.8 345.2 277.2C337.5 273.8 328.1 272 320 272C284.7 272 256 300.7 256 336V432C256 458.5 234.5 480 208 480H176C149.5 480 128 458.5 128 432V336C128 300.7 99.35 272 64 272H48C39.16 272 32 264.8 32 256C32 247.2 39.16 240 48 240H64zM540.7 324.7C546.9 318.4 557.1 318.4 563.3 324.7C569.6 330.9 569.6 341.1 563.3 347.3L491.3 419.3C485.1 425.6 474.9 425.6 468.7 419.3L428.7 379.3C422.4 373.1 422.4 362.9 428.7 356.7C434.9 350.4 445.1 350.4 451.3 356.7L480 385.4L540.7 324.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "bridge-circle-exclamation": [640, 512, [], "e4ca", "M592 32C600.8 32 608 39.16 608 48C608 56.84 600.8 64 592 64H528V128H592C600.8 128 608 135.2 608 144C608 152.8 600.8 160 592 160H48C39.16 160 32 152.8 32 144C32 135.2 39.16 128 48 128H112V64H48C39.16 64 32 56.84 32 48C32 39.16 39.16 32 48 32H592zM496 64H400V128H496V64zM272 64V128H368V64H272zM240 64H144V128H240V64zM64 240C117 240 160 282.1 160 336V432C160 440.8 167.2 448 176 448H208C216.8 448 224 440.8 224 432V336C224 282.1 266.1 240 320 240C336.1 240 351.2 243.1 364.6 250.9C357.3 259 350.9 267.8 345.2 277.2C337.5 273.8 328.1 272 320 272C284.7 272 256 300.7 256 336V432C256 458.5 234.5 480 208 480H176C149.5 480 128 458.5 128 432V336C128 300.7 99.35 272 64 272H48C39.16 272 32 264.8 32 256C32 247.2 39.16 240 48 240H64zM472 424C472 410.7 482.7 400 496 400C509.3 400 520 410.7 520 424C520 437.3 509.3 448 496 448C482.7 448 472 437.3 472 424zM495.1 288C504.8 288 511.1 295.2 511.1 304V368C511.1 376.8 504.8 384 495.1 384C487.2 384 479.1 376.8 479.1 368V304C479.1 295.2 487.2 288 495.1 288zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "bridge-circle-xmark": [640, 512, [], "e4cb", "M592 32C600.8 32 608 39.16 608 48C608 56.84 600.8 64 592 64H528V128H592C600.8 128 608 135.2 608 144C608 152.8 600.8 160 592 160H48C39.16 160 32 152.8 32 144C32 135.2 39.16 128 48 128H112V64H48C39.16 64 32 56.84 32 48C32 39.16 39.16 32 48 32H592zM496 64H400V128H496V64zM272 64V128H368V64H272zM240 64H144V128H240V64zM64 240C117 240 160 282.1 160 336V432C160 440.8 167.2 448 176 448H208C216.8 448 224 440.8 224 432V336C224 282.1 266.1 240 320 240C336.1 240 351.2 243.1 364.6 250.9C357.3 259 350.9 267.8 345.2 277.2C337.5 273.8 328.1 272 320 272C284.7 272 256 300.7 256 336V432C256 458.5 234.5 480 208 480H176C149.5 480 128 458.5 128 432V336C128 300.7 99.35 272 64 272H48C39.16 272 32 264.8 32 256C32 247.2 39.16 240 48 240H64zM518.6 368L555.3 404.7C561.6 410.9 561.6 421.1 555.3 427.3C549.1 433.6 538.9 433.6 532.7 427.3L496 390.6L459.3 427.3C453.1 433.6 442.9 433.6 436.7 427.3C430.4 421.1 430.4 410.9 436.7 404.7L473.4 368L436.7 331.3C430.4 325.1 430.4 314.9 436.7 308.7C442.9 302.4 453.1 302.4 459.3 308.7L496 345.4L532.7 308.7C538.9 302.4 549.1 302.4 555.3 308.7C561.6 314.9 561.6 325.1 555.3 331.3L518.6 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "bridge-lock": [640, 512, [], "e4cc", "M592 32C600.8 32 608 39.16 608 48C608 56.84 600.8 64 592 64H528V128H592C600.8 128 608 135.2 608 144C608 152.8 600.8 160 592 160H48C39.16 160 32 152.8 32 144C32 135.2 39.16 128 48 128H112V64H48C39.16 64 32 56.84 32 48C32 39.16 39.16 32 48 32H592zM496 64H400V128H496V64zM272 64V128H368V64H272zM240 64H144V128H240V64zM320 240C360.6 240 395.4 265.3 409.4 300.9C393.1 312.6 384 331.2 384 352V336C384 300.7 355.3 272 320 272C284.7 272 256 300.7 256 336V432C256 458.5 234.5 480 208 480H176C149.5 480 128 458.5 128 432V336C128 300.7 99.35 272 64 272H48C39.16 272 32 264.8 32 256C32 247.2 39.16 240 48 240H64C117 240 160 282.1 160 336V432C160 440.8 167.2 448 176 448H208C216.8 448 224 440.8 224 432V336C224 282.1 266.1 240 320 240zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 224C501.5 224 480 245.5 480 272V320H576V272C576 245.5 554.5 224 528 224zM448 352V480H608V352H448z"],
    "bridge-suspension": [640, 512, [], "e4cd", "M128 .0003C134.4 .0003 139.9 3.743 142.5 9.155L149.1 22.36C181.4 87.1 247.6 128 320 128C392.4 128 458.6 87.1 490.9 22.36L497.5 9.155C500.1 3.743 505.6 0 512 0C519.2 0 525.3 4.741 527.3 11.27C541.8 54.28 585.1 98.75 629.9 116.2C638.1 119.4 642.1 128.7 638.9 136.1C635.6 145.2 626.3 149.2 618.1 145.9C585.1 132.8 552.1 107.3 528 76.82V256H624C632.8 256 640 263.2 640 272C640 280.8 632.8 288 624 288H16C7.164 288 .0002 280.8 .0002 272C.0002 263.2 7.164 256 16 256H112V76.82C87.87 107.3 54.95 132.8 21.9 145.9C13.69 149.2 4.388 145.2 1.129 136.1C-2.131 128.7 1.885 119.4 10.1 116.2C54.01 98.75 98.23 54.28 112.7 11.27C114.7 4.742 120.8 .0003 128 .0003H128zM144 256H208V129.9C183.5 115.6 161.7 96.72 144 74.02V256zM240 256H304V159.4C281.8 157.8 260.3 152.1 240 145.2V256zM336 256H400V145.2C379.7 152.1 358.2 157.8 336 159.4V256zM432 256H496V74.02C478.3 96.72 456.5 115.6 432 129.9V256zM32 320C85.02 320 128 362.1 128 416V464C128 472.8 135.2 480 144 480H176C184.8 480 192 472.8 192 464V448C192 377.3 249.3 320 320 320C390.7 320 448 377.3 448 448V464C448 472.8 455.2 480 464 480H496C504.8 480 512 472.8 512 464V416C512 362.1 554.1 320 608 320H624C632.8 320 640 327.2 640 336C640 344.8 632.8 352 624 352H608C572.7 352 544 380.7 544 416V464C544 490.5 522.5 512 496 512H464C437.5 512 416 490.5 416 464V448C416 394.1 373 352 320 352C266.1 352 224 394.1 224 448V464C224 490.5 202.5 512 176 512H144C117.5 512 96 490.5 96 464V416C96 380.7 67.35 352 32 352H16C7.164 352 .0005 344.8 .0005 336C.0005 327.2 7.164 320 16 320H32z"],
    "bridge-water": [576, 512, [], "e4ce", "M544 96H32V176.1C85.34 177.9 128 221.8 128 275.6V361C118.1 355.3 107 352.4 96 352.5V275.6C96 238.2 65.75 208 28.44 208C12.74 208 0 195.3 0 179.6V96C0 78.33 14.33 64 32 64H544C561.7 64 576 78.33 576 96V179.6C576 195.3 563.3 208 547.6 208C510.2 208 480 238.2 480 275.6V352.5C468.1 352.5 457.9 355.3 448 361V275.6C448 221.8 490.7 177.9 544 176.1V96zM192 384.5V272C192 218.1 234.1 176 288 176C341 176 384 218.1 384 272V384.5C373.6 384.5 362.7 382.3 352 378.3V272C352 236.7 323.3 208 288 208C252.7 208 224 236.7 224 272V378.4C213.7 382.2 202.9 384.5 192 384.5V384.5zM250.1 426.8C259.9 420.1 268.2 412.8 276.1 404.9C282.6 398.4 293.3 398.4 299.8 404.9C307.8 412.8 315.1 420.1 325.8 426.8C342.3 438 363.1 447.1 383.1 447.1C404.9 447.1 425.6 438 442.2 426.8C451.9 420.1 460.2 412.8 468.1 404.9C474.6 398.4 485.3 398.4 491.8 404.9C499.8 412.8 507.1 420.1 517.8 426.8C530.6 435.5 545.9 443.4 561.9 446.6C569.6 448.1 576 454.4 576 462.2C576 472 567.1 480.1 558.3 478.4C535.2 474.5 514.7 463.4 499.8 453.2C491.8 447.8 485.1 442.4 479.1 437.1C474.8 442.4 468.1 447.8 460.2 453.2C441.5 465.9 414.3 479.1 383.1 479.1C353.7 479.1 326.4 465.9 307.8 453.2C299.8 447.8 293.1 442.4 287.1 437.1C282.8 442.4 276.1 447.8 268.2 453.2C249.5 465.9 222.3 479.1 191.1 479.1C161.7 479.1 134.4 465.9 115.8 453.2C107.8 447.8 101.1 442.4 95.96 437.1C90.82 442.4 84.12 447.8 76.19 453.2C61.25 463.4 40.81 474.5 17.69 478.4C8.016 480.1 .0003 472 .0003 462.2C.0003 454.4 6.421 448.1 14.13 446.6C30.07 443.4 45.38 435.5 58.16 426.8C67.94 420.1 76.16 412.8 84.07 404.9C90.64 398.4 101.3 398.4 107.8 404.9C115.8 412.8 124.1 420.2 133.8 426.8C150.3 438 171.1 447.1 191.1 447.1C212.9 447.1 233.6 438 250.1 426.8H250.1z"],
    "briefcase": [512, 512, [128188], "f0b1", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h144v64c0 8.844 7.156 16 16 16h128c8.844 0 16-7.156 16-16V288H480V416zM208 336V288h96v48H208zM480 256H32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V256z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416zM379.3 276.7l-79.98-79.98c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 272H144C135.2 272 128 279.2 128 288s7.156 16 16 16h185.4l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C279.8 382.4 283.9 384 288 384s8.188-1.562 11.31-4.688l79.98-79.98c1.484-1.48 2.662-3.254 3.477-5.223c1.617-3.91 1.617-8.309 0-12.22C381.1 279.9 380.8 278.1 379.3 276.7z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416z"],
    "briefcase-medical": [512, 512, [], "f469", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416zM336 256H288V208C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208V256H176C167.2 256 160 263.2 160 272v32C160 312.8 167.2 320 176 320H224v48C224 376.8 231.2 384 240 384h32c8.836 0 16-7.164 16-16V320h48c8.836 0 16-7.164 16-16v-32C352 263.2 344.8 256 336 256z"],
    "brightness": [512, 512, [], "e0c9", "M240 16C240 7.164 247.2 0 256 0C264.8 0 272 7.164 272 16V104C272 112.8 264.8 120 256 120C247.2 120 240 112.8 240 104V16zM160 256C160 202.1 202.1 160 256 160C309 160 352 202.1 352 256C352 309 309 352 256 352C202.1 352 160 309 160 256zM256 320C291.3 320 320 291.3 320 256C320 220.7 291.3 192 256 192C220.7 192 192 220.7 192 256C192 291.3 220.7 320 256 320zM256 512C247.2 512 240 504.8 240 496V416C240 407.2 247.2 400 256 400C264.8 400 272 407.2 272 416V496C272 504.8 264.8 512 256 512zM0 256C0 247.2 7.164 240 16 240H96C104.8 240 112 247.2 112 256C112 264.8 104.8 272 96 272H16C7.164 272 0 264.8 0 256zM496 240C504.8 240 512 247.2 512 256C512 264.8 504.8 272 496 272H408C399.2 272 392 264.8 392 256C392 247.2 399.2 240 408 240H496zM74.98 437C68.73 430.8 68.73 420.6 74.98 414.4L131.5 357.8C137.8 351.6 147.9 351.6 154.2 357.8C160.4 364.1 160.4 374.2 154.2 380.5L97.61 437C91.36 443.3 81.23 443.3 74.98 437V437zM414.4 74.98C420.6 68.73 430.8 68.73 437 74.98C443.3 81.23 443.3 91.36 437 97.61L374.8 159.8C368.5 166.1 358.4 166.1 352.2 159.8C345.9 153.6 345.9 143.5 352.2 137.2L414.4 74.98zM74.98 74.98C81.23 68.73 91.36 68.73 97.61 74.98L154.2 131.5C160.4 137.8 160.4 147.9 154.2 154.2C147.9 160.4 137.8 160.4 131.5 154.2L74.98 97.61C68.73 91.36 68.73 81.23 74.98 74.98V74.98zM437 414.4C443.3 420.6 443.3 430.8 437 437C430.8 443.3 420.6 443.3 414.4 437L352.2 374.8C345.9 368.5 345.9 358.4 352.2 352.2C358.4 345.9 368.5 345.9 374.8 352.2L437 414.4z"],
    "brightness-low": [448, 512, [], "e0ca", "M248 80C248 93.25 237.3 104 224 104C210.7 104 200 93.25 200 80C200 66.75 210.7 56 224 56C237.3 56 248 66.75 248 80zM128 256C128 202.1 170.1 160 224 160C277 160 320 202.1 320 256C320 309 277 352 224 352C170.1 352 128 309 128 256zM224 320C259.3 320 288 291.3 288 256C288 220.7 259.3 192 224 192C188.7 192 160 220.7 160 256C160 291.3 188.7 320 224 320zM200 432C200 418.7 210.7 408 224 408C237.3 408 248 418.7 248 432C248 445.3 237.3 456 224 456C210.7 456 200 445.3 200 432zM400 280C386.7 280 376 269.3 376 256C376 242.7 386.7 232 400 232C413.3 232 424 242.7 424 256C424 269.3 413.3 280 400 280zM48 232C61.25 232 72 242.7 72 256C72 269.3 61.25 280 48 280C34.75 280 24 269.3 24 256C24 242.7 34.75 232 48 232zM120 128C120 141.3 109.3 152 96 152C82.75 152 72 141.3 72 128C72 114.7 82.75 104 96 104C109.3 104 120 114.7 120 128zM352 408C338.7 408 328 397.3 328 384C328 370.7 338.7 360 352 360C365.3 360 376 370.7 376 384C376 397.3 365.3 408 352 408zM376 128C376 141.3 365.3 152 352 152C338.7 152 328 141.3 328 128C328 114.7 338.7 104 352 104C365.3 104 376 114.7 376 128zM96 360C109.3 360 120 370.7 120 384C120 397.3 109.3 408 96 408C82.75 408 72 397.3 72 384C72 370.7 82.75 360 96 360z"],
    "bring-forward": [512, 512, [], "f856", "M224 480H448C465.7 480 480 465.7 480 448V224C480 206.3 465.7 192 448 192H400C391.2 192 384 184.8 384 176C384 167.2 391.2 160 400 160H448C483.3 160 512 188.7 512 224V448C512 483.3 483.3 512 448 512H224C188.7 512 160 483.3 160 448V400C160 391.2 167.2 384 176 384C184.8 384 192 391.2 192 400V448C192 465.7 206.3 480 224 480zM288 256C288 273.7 273.7 288 256 288H96C78.33 288 64 273.7 64 256V96C64 78.33 78.33 64 96 64H256C273.7 64 288 78.33 288 96V256zM256 112C256 103.2 248.8 96 240 96H112C103.2 96 96 103.2 96 112V240C96 248.8 103.2 256 112 256H240C248.8 256 256 248.8 256 240V112zM64 352C28.65 352 0 323.3 0 288V64C0 28.65 28.65 0 64 0H288C323.3 0 352 28.65 352 64V288C352 323.3 323.3 352 288 352H64zM64 320H288C305.7 320 320 305.7 320 288V64C320 46.33 305.7 32 288 32H64C46.33 32 32 46.33 32 64V288C32 305.7 46.33 320 64 320z"],
    "bring-front": [640, 512, [], "f857", "M32 64V192C32 209.7 46.33 224 64 224H112C120.8 224 128 231.2 128 240C128 248.8 120.8 256 112 256H64C28.65 256 0 227.3 0 192V64C0 28.65 28.65 0 64 0H192C221.9 0 246.1 20.48 254 48.16C256.2 56.73 248.8 64 240 64C231.2 64 224.3 56.41 220.1 48.66C214.7 38.73 204.1 32 192 32H64C46.33 32 32 46.33 32 64zM448 512C418.1 512 393 491.5 385.1 463.8C383.8 455.3 391.2 448 400 448C408.8 448 415.7 455.6 419.9 463.3C425.3 473.3 435.9 480 448 480H576C593.7 480 608 465.7 608 448V320C608 302.3 593.7 288 576 288H528C519.2 288 512 280.8 512 272C512 263.2 519.2 256 528 256H576C611.3 256 640 284.7 640 320V448C640 483.3 611.3 512 576 512H448zM224 192C224 174.3 238.3 160 256 160H384C401.7 160 416 174.3 416 192V320C416 337.7 401.7 352 384 352H256C238.3 352 224 337.7 224 320V192zM256 304C256 312.8 263.2 320 272 320H368C376.8 320 384 312.8 384 304V208C384 199.2 376.8 192 368 192H272C263.2 192 256 199.2 256 208V304zM416 96C451.3 96 480 124.7 480 160V352C480 387.3 451.3 416 416 416H224C188.7 416 160 387.3 160 352V160C160 124.7 188.7 96 224 96H416zM416 128H224C206.3 128 192 142.3 192 160V352C192 369.7 206.3 384 224 384H416C433.7 384 448 369.7 448 352V160C448 142.3 433.7 128 416 128z"],
    "broccoli": [512, 512, [129382], "e3e2", "M448.6 154.3C450.8 147.2 452 139.8 452 132.4c0-40.91-34.09-74.17-76-74.17c-7.875 0-15.66 1.203-23.09 3.547C336.3 24.61 298.8 0 256 0S175.7 24.61 159.1 61.73C151.7 59.39 143.9 58.19 136 58.19c-41.91 0-76 33.27-76 74.17c0 7.484 1.156 14.86 3.438 21.92C25.28 170.4 0 206.1 0 248.7c0 56.36 46.64 102.2 104.3 103.1C185.9 454.1 162.1 512 192 512c8.148 0 16.01-6.535 16.01-15.1c0-7.568-16.31-75.65-63.87-144h50.39C244.5 421.9 236.2 442.7 256 442.7c19.8 0 11.48-20.85 61.47-90.72h50.37c-47.35 68.04-63.85 136.6-63.85 144C303.1 505.6 311.9 512 320 512c29.29 0 6.226-56.19 87.68-160.2C465.3 350.9 512 305.1 512 248.7C512 206.1 486.7 170.4 448.6 154.3zM256 390.6C248.1 375.8 240.4 363 233.2 352h45.51C271.6 363 263.9 375.8 256 390.6zM405.1 320h-2.029c-1.286-.331-2.572-.4908-3.846-.4908c-1.305 0-2.599 .1676-3.868 .4908H105.1C65.19 320 32 288 32 248.7C32 215.5 55.53 187.1 89.19 179.5c7.145-1.602 12.5-7.94 12.5-15.57c0-10.02-9.686-13.35-9.686-31.57c0-23.25 19.75-42.17 44-42.17c18.96 0 22.9 9.373 32.47 9.373c7.591 0 13.93-5.231 15.59-12.28C191.8 54.73 221.4 32 256 32s64.16 22.73 71.94 55.28c1.692 7.147 8.135 12.3 15.6 12.3c9.549 0 13.43-9.391 32.47-9.391c24.25 0 44 18.92 44 42.17c0 18.19-9.686 21.56-9.686 31.57c0 7.62 5.342 13.97 12.5 15.57C456.5 187.1 480 215.5 480 248.7C480 288 446.8 320 405.1 320z"],
    "broom": [640, 512, [129529], "f51a", "M636.5 5.99c-5.531-6.857-15.53-8.014-22.5-2.5l-232.1 185.6l-40.4-51.22c0-.0156 .0313 .0156 0 0C329.7 123 305.7 124.1 297.1 143.2L273.5 194.5C270.1 199.1 271.7 206.4 275.5 211.1l80.99 102.7c1.143 1.451 6.902 7.791 15.91 5.732l54.71-11.71c18.95-3.887 27.43-26.48 15.31-42.03l-40.65-51.54l232.3-185.8C640.9 22.95 641.1 12.89 636.5 5.99zM411.6 278.4L375.4 286.2l-68.78-87.21l15.59-33.88L411.6 278.4zM304.2 332.1C304.1 332.1 289.8 415.1 242.3 452.1c-35.5 27.6-148.6 29.29-207.2 27.1c1.375-6.982 3.188-15.7 5.406-25.55l81.21-94.08c14.36-16.65-3.072-40.96-23.37-33.71L78.22 333c12.15-26.58 22.69-38.97 30.09-44.73c47.62-37.04 132.9-32.21 133.9-32.15c21.71 .5098 22.61-30.62 2.031-31.93C240.1 223.1 145.1 218.5 88.69 263c-19.65 15.24-37.15 45.22-53.53 91.61c-4.457 12.59 7.736 24.9 20.47 20.4l15.12-5.389l-57.09 66.1c-1.688 1.969-2.875 4.328-3.469 6.857c-6.562 28.51-9.938 49.05-9.938 49.05c-1.994 11.84 8.104 18.12 14.75 18.56C21.44 510.6 44.72 512 74.97 512c60.68 0 149.5-5.42 187-34.66c57.4-44.75 73.18-136.1 73.81-139.9C339.2 316.6 307.8 311.1 304.2 332.1z"],
    "broom-ball": [640, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M495.1 351.1c-44.13 0-79.1 35.92-79.1 79.91s35.87 80.09 79.1 80.09s79.1-36.1 79.1-80.09S540.2 351.1 495.1 351.1zM496 479.5c-26.5 0-48-21.43-48-47.85s21.5-47.85 48-47.85s48 21.43 48 47.85S522.5 479.5 496 479.5zM304.2 332.1C304.1 332.1 289.8 415.1 242.3 452.1c-35.5 27.6-148.6 29.29-207.2 27.1c1.375-6.98 3.188-15.7 5.406-25.55l81.21-94.08c14.36-16.64-3.072-40.96-23.37-33.71l-20.12 7.168c12.15-26.58 22.69-38.97 30.09-44.73c47.62-37.03 132.9-32.21 133.9-32.14c21.71 .5117 22.61-30.61 2.031-31.93C240.1 224 145.1 218.5 88.69 263c-19.65 15.25-37.15 45.22-53.53 91.61c-4.457 12.59 7.736 24.89 20.47 20.4l15.12-5.387l-57.09 66.1c-1.688 1.969-2.875 4.328-3.469 6.859c-6.562 28.51-9.938 49.05-9.938 49.05c-1.994 11.84 8.104 18.12 14.75 18.55C21.44 510.6 44.72 512 74.97 512c60.68 0 149.5-5.422 187-34.66c57.4-44.75 73.18-136.1 73.81-139.9C339.2 316.6 307.8 311.1 304.2 332.1zM636.5 5.992c-5.531-6.859-15.53-8.016-22.5-2.5L381.9 189.1l-40.4-51.23c0-.0156 .0313 .0156 0 0c-11.8-14.84-35.84-12.91-44.47 5.359L273.5 194.5C270.1 199.1 271.7 206.4 275.5 211.1l80.99 102.7c1.143 1.453 6.902 7.789 15.91 5.734l54.71-11.72c18.95-3.883 27.43-26.48 15.31-42.03l-40.65-51.54l232.3-185.8C640.9 22.95 641.1 12.89 636.5 5.992zM411.6 278.4L375.4 286.2l-68.78-87.2l15.59-33.88L411.6 278.4z"],
    "browser": [512, 512, [128468], "f37e", "M0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM160 128H480V96C480 78.33 465.7 64 448 64H160V128zM128 64H64C46.33 64 32 78.33 32 96V128H128V64zM32 160V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V160H32z"],
    "browsers": [576, 512, [], "e0cb", "M512 0C547.3 0 576 28.65 576 64V352C576 387.3 547.3 416 512 416H160C124.7 416 96 387.3 96 352V64C96 28.65 124.7 0 160 0H512zM512 32H256V96H544V64C544 46.33 529.7 32 512 32zM128 64V96H224V32H160C142.3 32 128 46.33 128 64zM160 384H512C529.7 384 544 369.7 544 352V128H128V352C128 369.7 142.3 384 160 384zM32 384C32 437 74.98 480 128 480H464C472.8 480 480 487.2 480 496C480 504.8 472.8 512 464 512H128C57.31 512 0 454.7 0 384V112C0 103.2 7.164 96 16 96C24.84 96 32 103.2 32 112V384z"],
    "brush": [384, 512, [], "f55d", "M0 304V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V304C384 348.2 348.2 384 304 384H256V448C256 483.3 227.3 512 192 512C156.7 512 128 483.3 128 448V384H80C35.82 384 0 348.2 0 304zM304 352C330.5 352 352 330.5 352 304V288H32V304C32 330.5 53.49 352 80 352H160V448C160 465.7 174.3 480 192 480C209.7 480 224 465.7 224 448V352H304zM352 64C352 46.33 337.7 32 320 32H224V112C224 120.8 216.8 128 208 128C199.2 128 192 120.8 192 112V32H128V144C128 152.8 120.8 160 112 160C103.2 160 96 152.8 96 144V32H64C46.33 32 32 46.33 32 64V256H352V64z"],
    "bucket": [448, 512, [], "e4cf", "M80 160C71.16 160 64 152.8 64 144C64 64.47 128.5 0 208 0H240C319.5 0 384 64.47 384 144C384 152.8 376.8 160 368 160C359.2 160 352 152.8 352 144C352 82.14 301.9 32 240 32H208C146.1 32 96 82.14 96 144C96 152.8 88.84 160 80 160zM.0003 208C.0003 199.2 7.164 192 16 192H432C440.8 192 448 199.2 448 208C448 216.8 440.8 224 432 224H420L389.3 469.1C386.3 493.1 365.8 512 341.6 512H106.4C82.17 512 61.75 493.1 58.74 469.1L28 224H16C7.164 224 0 216.8 0 208H.0003zM90.5 465.1C91.5 473.1 98.3 480 106.4 480H341.6C349.7 480 356.5 473.1 357.5 465.1L387.8 224H60.25L90.5 465.1z"],
    "bug": [512, 512, [], "f188", "M160 96C160 42.98 202.1 0 256 0C309 0 352 42.98 352 96V99.56C352 115.3 339.3 128 323.6 128H188.4C172.7 128 160 115.3 160 99.56V96zM192 96H320C320 60.65 291.3 32 256 32C220.7 32 192 60.65 192 96zM36.69 100.7C42.93 94.44 53.07 94.44 59.31 100.7L138.6 180C155.8 167.4 177.1 160 200 160H312C334.9 160 356.2 167.4 373.4 180L452.7 100.7C458.9 94.44 469.1 94.44 475.3 100.7C481.6 106.9 481.6 117.1 475.3 123.3L395.1 202.6C408.6 219.8 416 241.1 416 264V272H496C504.8 272 512 279.2 512 288C512 296.8 504.8 304 496 304H416V320C416 350.2 407.6 378.4 393.1 402.5L475.3 484.7C481.6 490.9 481.6 501.1 475.3 507.3C469.1 513.6 458.9 513.6 452.7 507.3L373.7 428.4C344.5 460.1 302.6 480 256 480C209.4 480 167.5 460.1 138.3 428.4L59.31 507.3C53.07 513.6 42.94 513.6 36.69 507.3C30.44 501.1 30.44 490.9 36.69 484.7L118.9 402.5C104.4 378.4 96 350.2 96 319.1V303.1H16C7.164 303.1 0 296.8 0 287.1C0 279.2 7.164 271.1 16 271.1H96V263.1C96 241.1 103.4 219.8 116 202.6L36.69 123.3C30.44 117.1 30.44 106.9 36.69 100.7V100.7zM128 320C128 385.3 176.9 439.1 240 447V256C240 247.2 247.2 240 256 240C264.8 240 272 247.2 272 256V447C335.1 439.1 384 385.3 384 320V264C384 224.2 351.8 192 312 192H200C160.2 192 128 224.2 128 264V320z"],
    "bug-slash": [640, 512, [], "e490", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM560 304H484.1L448 275.5V264C448 224.2 415.8 192 376 192H342.2L301.7 160H376C398.9 160 420.2 167.4 437.4 180L516.7 100.7C522.9 94.44 533.1 94.44 539.3 100.7C545.6 106.9 545.6 117.1 539.3 123.3L459.1 202.6C472.6 219.8 480 241.1 480 264V272H560C568.8 272 576 279.2 576 288C576 296.8 568.8 304 560 304H560zM411.4 409.7L436.6 429.6C407.4 460.6 365.1 480 320 480C273.4 480 231.5 460.1 202.3 428.4L123.3 507.3C117.1 513.6 106.9 513.6 100.7 507.3C94.44 501.1 94.44 490.9 100.7 484.7L182.9 402.5C168.4 378.4 160 350.2 160 320V304H80C71.16 304 64 296.8 64 288C64 279.2 71.16 272 80 272H160V264C160 247.1 163.6 232.8 170.1 219.2L196.2 239.8C193.5 247.4 192 255.5 192 264V320C192 385.3 240.9 439.1 304 447V324.9L336 350.2V447C365.4 443.3 391.6 429.7 411.4 409.7V409.7zM224 96C224 42.98 266.1 .0006 320 .0006C373 .0006 416 42.98 416 96V99.56C416 115.3 403.3 128 387.6 128H261.2L224 98.67V96zM256 96H384C384 60.65 355.3 32 320 32C284.7 32 256 60.65 256 96z"],
    "bugs": [576, 512, [], "e4d0", "M187.4 136H218.9L224.3 108.9C226 100.2 234.5 94.58 243.1 96.31C251.8 98.05 257.4 106.5 255.7 115.1L247.7 155.1C246.2 162.6 239.6 168 232 168H192V217.8L237.1 232.8C242.8 234.7 246.1 239.7 247.8 245.7L255.8 301.7C257.1 310.5 251 318.6 242.3 319.8C233.5 321.1 225.4 315 224.2 306.3L217.6 260.1L186.6 249.7C176.7 272.3 154.2 288 128 288C101.8 288 79.3 272.3 69.39 249.7L38.44 260.1L31.84 306.3C30.59 315 22.49 321.1 13.74 319.8C4.993 318.6-1.086 310.5 .1642 301.7L8.164 245.7C9.021 239.7 13.19 234.7 18.94 232.8L64 217.8V168H24C16.38 168 9.81 162.6 8.314 155.1L.3139 115.1C-1.419 106.5 4.2 98.05 12.87 96.31C21.53 94.58 29.96 100.2 31.69 108.9L37.12 136H68.66C74.5 121.6 85.45 109.8 99.27 102.8L65.26 22.23C61.83 14.08 65.64 4.7 73.78 1.264C81.92-2.173 91.31 1.641 94.74 9.782L128 88.58L161.3 9.782C164.7 1.641 174.1-2.173 182.2 1.264C190.4 4.7 194.2 14.09 190.7 22.23L156.7 102.8C170.6 109.8 181.5 121.6 187.4 136L187.4 136zM160 224V160C160 142.3 145.7 128 128 128C110.3 128 96 142.3 96 160V224C96 241.7 110.3 256 128 256C145.7 256 160 241.7 160 224zM502.3 323.5L529.6 339.2L547.8 318.4C553.7 311.8 563.8 311.2 570.4 316.1C577.1 322.8 577.7 332.9 571.9 339.6L544.9 370.2C539.9 375.9 531.5 377.3 524.9 373.5L490.3 353.5L465.4 396.6L496.9 432.2C500.9 436.7 502 443.1 499.8 448.7L478.7 501.2C475.4 509.4 466.1 513.4 457.9 510.1C449.7 506.8 445.7 497.5 449 489.3L466.4 446L444.8 421.6C424.9 436.2 397.5 438.5 374.9 425.4C352.2 412.3 340.5 387.4 343.2 362.1L311.3 356.4L282.5 393.2C276.1 400.1 266.9 401.3 259.1 395.9C253 390.4 251.8 380.4 257.3 373.4L292.2 328.9C295.9 324.1 302.1 321.9 308 323.1L354.5 332.6L379.4 289.5L344.8 269.5C338.2 265.7 335.2 257.7 337.6 250.5L350.7 211.9C353.5 203.5 362.6 199 370.1 201.8C379.4 204.7 383.9 213.8 381 222.1L372.2 248.3L399.5 264.1C411.7 254.5 427.1 249.8 442.6 250.7L453.4 163.9C454.5 155.1 462.5 148.9 471.3 149.1C480 151.1 486.3 159.1 485.2 167.8L474.6 252.7L542.8 201.1C549.8 195.8 559.9 197.2 565.2 204.2C570.5 211.3 569.1 221.3 562.1 226.6L492.3 279.4C500.8 292.3 504.4 308 502.3 323.5L502.3 323.5zM434.6 386L466.6 330.6C475.4 315.3 470.2 295.7 454.9 286.9C439.6 278 419.1 283.3 411.1 298.6L379.1 354C370.3 369.3 375.6 388.9 390.9 397.7C406.2 406.6 425.7 401.3 434.6 386z"],
    "building": [384, 512, [61687, 127970], "f1ad", "M64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM64 512C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64zM32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416z"],
    "building-circle-arrow-right": [640, 512, [], "e4d1", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C332.1 480 342.6 473.3 348.1 463.4C354.1 472.7 361 481.5 368.7 489.5C356.1 503.3 339.5 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V232.2C371.9 242.3 361.1 253.9 352 266.8V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64V64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM492.7 300.7C498.9 294.4 509.1 294.4 515.3 300.7L571.3 356.7C577.6 362.9 577.6 373.1 571.3 379.3L515.3 435.3C509.1 441.6 498.9 441.6 492.7 435.3C486.4 429.1 486.4 418.9 492.7 412.7L521.4 384H432C423.2 384 416 376.8 416 368C416 359.2 423.2 352 432 352H521.4L492.7 323.3C486.4 317.1 486.4 306.9 492.7 300.7V300.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "building-circle-check": [640, 512, [], "e4d2", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C332.1 480 342.6 473.3 348.1 463.4C354.1 472.7 361 481.5 368.7 489.5C356.1 503.3 339.5 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V232.2C371.9 242.3 361.1 253.9 352 266.8V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64V64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM563.3 324.7C569.6 330.9 569.6 341.1 563.3 347.3L491.3 419.3C485.1 425.6 474.9 425.6 468.7 419.3L428.7 379.3C422.4 373.1 422.4 362.9 428.7 356.7C434.9 350.4 445.1 350.4 451.3 356.7L480 385.4L540.7 324.7C546.9 318.4 557.1 318.4 563.3 324.7H563.3zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "building-circle-exclamation": [640, 512, [], "e4d3", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C332.1 480 342.6 473.3 348.1 463.4C354.1 472.7 361 481.5 368.7 489.5C356.1 503.3 339.5 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V232.2C371.9 242.3 361.1 253.9 352 266.8V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64V64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM472 424C472 410.7 482.7 400 496 400C509.3 400 520 410.7 520 424C520 437.3 509.3 448 496 448C482.7 448 472 437.3 472 424zM495.1 288C504.8 288 511.1 295.2 511.1 304V368C511.1 376.8 504.8 384 495.1 384C487.2 384 479.1 376.8 479.1 368V304C479.1 295.2 487.2 288 495.1 288zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "building-circle-xmark": [640, 512, [], "e4d4", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C332.1 480 342.6 473.3 348.1 463.4C354.1 472.7 361 481.5 368.7 489.5C356.1 503.3 339.5 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V232.2C371.9 242.3 361.1 253.9 352 266.8V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64V64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM555.3 404.7C561.6 410.9 561.6 421.1 555.3 427.3C549.1 433.6 538.9 433.6 532.7 427.3L496 390.6L459.3 427.3C453.1 433.6 442.9 433.6 436.7 427.3C430.4 421.1 430.4 410.9 436.7 404.7L473.4 368L436.7 331.3C430.4 325.1 430.4 314.9 436.7 308.7C442.9 302.4 453.1 302.4 459.3 308.7L496 345.4L532.7 308.7C538.9 302.4 549.1 302.4 555.3 308.7C561.6 314.9 561.6 325.1 555.3 331.3L518.6 368L555.3 404.7zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "building-columns": [512, 512, ["bank", "institution", "museum", "university"], "f19c", "M496.2 133.7C505.1 139.3 512 149.6 512 160.8C512 178 498 192 480.8 192H31.16C13.95 192 .0003 178 .0003 160.8C.0003 149.6 6.035 139.3 15.8 133.7L248.1 2.08C253-.6932 258.1-.6932 263.9 2.08L496.2 133.7zM477.7 160L256 34.39L34.34 160H205.4C201.9 152.7 200 144.6 200 136C200 105.1 225.1 80 256 80C286.9 80 312 105.1 312 136C312 144.6 310.1 152.7 306.6 160H477.7zM256 160C269.3 160 280 149.3 280 136C280 122.7 269.3 112 256 112C242.7 112 232 122.7 232 136C232 149.3 242.7 160 256 160zM64 224H96V352H176V224H208V352H304V224H336V352H416V224H448V352C456.8 352 464 359.2 464 368C464 376.8 456.8 384 448 384H64C55.16 384 48 376.8 48 368C48 359.2 55.16 352 64 352V224zM472 416C480.8 416 488 423.2 488 432C488 440.8 480.8 448 472 448H40C31.16 448 24 440.8 24 432C24 423.2 31.16 416 40 416H472zM496 480C504.8 480 512 487.2 512 496C512 504.8 504.8 512 496 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H496z"],
    "building-flag": [640, 512, [], "e4d5", "M64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM64 512C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64zM32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM432 0C440.8 0 448 7.164 448 16V32H608C625.7 32 640 46.33 640 64V192C640 209.7 625.7 224 608 224H448V496C448 504.8 440.8 512 432 512C423.2 512 416 504.8 416 496V16C416 7.164 423.2 0 432 0zM448 192H608V64H448V192z"],
    "building-lock": [576, 512, [], "e4d6", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C320 491.4 323 502.2 328.3 511.5C325.6 511.8 322.8 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V193.6C364.2 213.8 352 241.5 352 272V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM464 192C508.2 192 544 227.8 544 272V320C561.7 320 576 334.3 576 352V480C576 497.7 561.7 512 544 512H384C366.3 512 352 497.7 352 480V352C352 334.3 366.3 320 384 320V272C384 227.8 419.8 192 464 192zM464 224C437.5 224 416 245.5 416 272V320H512V272C512 245.5 490.5 224 464 224zM544 352H384V480H544V352z"],
    "building-ngo": [384, 512, [], "e4d7", "M320 32H64C52.16 32 41.81 38.44 36.28 48H2.016C9.121 20.4 34.18 0 64 0H320C349.8 0 374.9 20.4 381.1 48H347.7C342.2 38.44 331.8 32 320 32zM0 240H32V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C337.7 480 352 465.7 352 448V240H384V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V240zM160 416V480H224V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416zM216 80C224.8 80 232 87.16 232 96C232 104.8 224.8 112 216 112H184V176H200V160C200 151.2 207.2 144 216 144C224.8 144 232 151.2 232 160V184C232 197.3 221.3 208 208 208H176C162.7 208 152 197.3 152 184V96C152 87.16 159.2 80 168 80H216zM256 128C256 101.5 277.5 80 304 80C330.5 80 352 101.5 352 128V160C352 186.5 330.5 208 304 208C277.5 208 256 186.5 256 160V128zM304 112C295.2 112 288 119.2 288 128V160C288 168.8 295.2 176 304 176C312.8 176 320 168.8 320 160V128C320 119.2 312.8 112 304 112zM96 139.2V96C96 87.16 103.2 80 112 80C120.8 80 128 87.16 128 96V192C128 199.1 123.4 205.3 116.6 207.3C109.9 209.4 102.6 206.7 98.69 200.9L64 148.8V192C64 200.8 56.84 208 48 208C39.16 208 32 200.8 32 192V96C32 88.95 36.62 82.73 43.36 80.69C50.11 78.64 57.4 81.26 61.31 87.12L96 139.2zM208 264C208 250.7 218.7 240 232 240H280C293.3 240 304 250.7 304 264V312C304 325.3 293.3 336 280 336H232C218.7 336 208 325.3 208 312V264zM240 272V304H272V272H240zM152 240C165.3 240 176 250.7 176 264V312C176 325.3 165.3 336 152 336H104C90.75 336 80 325.3 80 312V264C80 250.7 90.75 240 104 240H152zM144 304V272H112V304H144z"],
    "building-shield": [576, 512, [], "e4d8", "M320 32H63.1C46.33 32 31.1 46.33 31.1 64V448C31.1 465.7 46.33 480 63.1 480H127.1V416C127.1 380.7 156.7 352 191.1 352C227.3 352 255.1 380.7 255.1 416V480H320C321.3 480 322.6 479.9 323.9 479.8C331.8 488.4 340.5 496.7 350.2 504.4C341.2 509.3 330.9 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V207L352 219.8V64C352 46.33 337.7 32 320 32H320zM159.1 416V480H223.1V416C223.1 398.3 209.7 384 191.1 384C174.3 384 159.1 398.3 159.1 416zM255.1 256V320H247.1C234.7 320 223.1 309.3 223.1 296V248C223.1 234.7 234.7 224 247.1 224H296C304.2 224 311.4 228.1 315.7 234.3L301.6 240H272C263.2 240 256 247.2 256 256H255.1zM135.1 96C149.3 96 159.1 106.7 159.1 120V168C159.1 181.3 149.3 192 135.1 192H87.1C74.74 192 63.1 181.3 63.1 168V120C63.1 106.7 74.74 96 87.1 96H135.1zM127.1 160V128H95.1V160H127.1zM223.1 120C223.1 106.7 234.7 96 247.1 96H296C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H247.1C234.7 192 223.1 181.3 223.1 168V120zM255.1 128V160H287.1V128H255.1zM135.1 224C149.3 224 159.1 234.7 159.1 248V296C159.1 309.3 149.3 320 135.1 320H87.1C74.74 320 63.1 309.3 63.1 296V248C63.1 234.7 74.74 224 87.1 224H135.1zM127.1 288V256H95.1V288H127.1zM560.9 273.7C570 277.4 576 286.2 576 296C576 359.3 550.1 464.8 441.2 510.2C435.3 512.6 428.7 512.6 422.8 510.2C313.9 464.8 287.1 359.3 287.1 296C287.1 286.2 293.1 277.4 303.1 273.7L423.1 225.7C428.8 223.4 435.2 223.4 440.9 225.7L560.9 273.7zM416 471.4V263L320.1 301.4C321.4 354.3 342.6 430.9 416 471.4V471.4zM448 263V471.4C521.4 430.9 542.6 354.3 543.9 301.4L448 263z"],
    "building-un": [384, 512, [], "e4d9", "M296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM272 123.2V80C272 71.16 279.2 64 288 64C296.8 64 304 71.16 304 80V176C304 183.1 299.4 189.3 292.6 191.3C285.9 193.4 278.6 190.7 274.7 184.9L240 132.8V176C240 184.8 232.8 192 224 192C215.2 192 208 184.8 208 176V80C208 72.95 212.6 66.73 219.4 64.69C226.1 62.64 233.4 65.26 237.3 71.12L272 123.2zM112 144C112 152.8 119.2 160 128 160C136.8 160 144 152.8 144 144V80C144 71.16 151.2 64 160 64C168.8 64 176 71.16 176 80V144C176 170.5 154.5 192 128 192C101.5 192 80 170.5 80 144V80C80 71.16 87.16 64 96 64C104.8 64 112 71.16 112 80V144zM64 512C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64zM32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416z"],
    "building-user": [640, 512, [], "e4da", "M32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320.1C320.6 491.4 323.1 502.1 329.5 511.3C326.4 511.8 323.2 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V367.8C371.1 374.5 361.2 383.2 352 393.4V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64V64zM224 416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V480H224V416zM64 120C64 106.7 74.75 96 88 96H136C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120zM96 128V160H128V128H96zM296 96C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120C224 106.7 234.7 96 248 96H296zM288 160V128H256V160H288zM64 248C64 234.7 74.75 224 88 224H136C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248zM96 256V288H128V256H96zM296 224C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248C224 234.7 234.7 224 248 224H296zM288 288V256H256V288H288zM576 272C576 316.2 540.2 352 496 352C451.8 352 416 316.2 416 272C416 227.8 451.8 192 496 192C540.2 192 576 227.8 576 272zM496 224C469.5 224 448 245.5 448 272C448 298.5 469.5 320 496 320C522.5 320 544 298.5 544 272C544 245.5 522.5 224 496 224zM546.9 384C598.3 384 640 425.7 640 477.1C640 496.4 624.4 512 605.1 512H386.9C367.6 512 352 496.4 352 477.1C352 425.7 393.7 384 445.1 384H546.9zM386.9 480H605.1C606.7 480 608 478.7 608 477.1C608 443.4 580.6 416 546.9 416H445.1C411.4 416 384 443.4 384 477.1C384 478.7 385.3 480 386.9 480V480z"],
    "building-wheat": [640, 512, [], "e4db", "M136 96C149.3 96 160 106.7 160 120V168C160 181.3 149.3 192 136 192H88C74.75 192 64 181.3 64 168V120C64 106.7 74.75 96 88 96H136zM128 160V128H96V160H128zM224 120C224 106.7 234.7 96 248 96H296C309.3 96 320 106.7 320 120V168C320 181.3 309.3 192 296 192H248C234.7 192 224 181.3 224 168V120zM256 128V160H288V128H256zM136 224C149.3 224 160 234.7 160 248V296C160 309.3 149.3 320 136 320H88C74.75 320 64 309.3 64 296V248C64 234.7 74.75 224 88 224H136zM128 288V256H96V288H128zM224 248C224 234.7 234.7 224 248 224H296C309.3 224 320 234.7 320 248V296C320 309.3 309.3 320 296 320H248C234.7 320 224 309.3 224 296V248zM256 256V288H288V256H256zM0 448V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448zM320 32H64C46.33 32 32 46.33 32 64V448C32 465.7 46.33 480 64 480H128V416C128 380.7 156.7 352 192 352C227.3 352 256 380.7 256 416V480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32zM160 416V480H224V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416zM624 192C632.8 192 640 199.2 640 208V224C640 248.6 630.8 271 615.6 288H624C632.8 288 640 295.2 640 304V320C640 344.6 630.8 367 615.6 384H624C632.8 384 640 391.2 640 400V416C640 469 597 512 544 512H512C458.1 512 416 469 416 416V400C416 391.2 423.2 384 432 384H440.4C425.2 367 416 344.6 416 320V304C416 295.2 423.2 288 432 288H440.4C425.2 271 416 248.6 416 224V208C416 199.2 423.2 192 432 192H448C481.4 192 510.8 209 528 234.9C545.2 209 574.6 192 608 192H624zM544 288C579.3 288 608 259.3 608 224C572.7 224 544 252.7 544 288zM512 288C512 252.7 483.3 224 448 224C448 259.3 476.7 288 512 288zM519.6 320C522.6 323.4 525.4 327.1 528 330.9C530.6 327.1 533.4 323.4 536.4 320H519.6zM536.4 416H519.6C522.6 419.4 525.4 423.1 528 426.9C530.6 423.1 533.4 419.4 536.4 416H536.4zM608 320C572.7 320 544 348.7 544 383.1C579.3 383.1 608 355.3 608 320zM512 384C512 348.7 483.3 320 448 320C448 355.3 476.7 384 512 384zM544 480C579.3 480 608 451.3 608 416C572.7 416 544 444.7 544 480zM512 480C512 444.7 483.3 416 448 416C448 451.3 476.7 480 512 480zM528 32C536.8 32 544 39.16 544 48V160C544 168.8 536.8 176 528 176C519.2 176 512 168.8 512 160V48C512 39.16 519.2 32 528 32zM608 96V144C608 152.8 600.8 160 592 160C583.2 160 576 152.8 576 144V96C576 87.16 583.2 80 592 80C600.8 80 608 87.16 608 96zM448 144V96C448 87.16 455.2 80 464 80C472.8 80 480 87.16 480 96V144C480 152.8 472.8 160 464 160C455.2 160 448 152.8 448 144z"],
    "buildings": [512, 512, [], "e0cc", "M320 344C320 330.7 330.7 320 344 320H392C405.3 320 416 330.7 416 344V392C416 405.3 405.3 416 392 416H344C330.7 416 320 405.3 320 392V344zM384 384V352H352V384H384zM320 88C320 74.75 330.7 64 344 64H392C405.3 64 416 74.75 416 88V136C416 149.3 405.3 160 392 160H344C330.7 160 320 149.3 320 136V88zM352 96V128H384V96H352zM344 288C330.7 288 320 277.3 320 264V216C320 202.7 330.7 192 344 192H392C405.3 192 416 202.7 416 216V264C416 277.3 405.3 288 392 288H344zM352 224V256H384V224H352zM448 0C483.3 0 512 28.65 512 64V448C512 483.3 483.3 512 448 512H288C252.7 512 224 483.3 224 448V64C224 28.65 252.7 0 288 0H448zM448 32H288C270.3 32 256 46.33 256 64V448C256 465.7 270.3 480 288 480H448C465.7 480 480 465.7 480 448V64C480 46.33 465.7 32 448 32zM176 160H64C46.33 160 32 174.3 32 192V448C32 465.7 46.33 480 64 480H192C200.8 480 208 487.2 208 496C208 504.8 200.8 512 192 512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128H176C184.8 128 192 135.2 192 144C192 152.8 184.8 160 176 160zM136 320C149.3 320 160 330.7 160 344V392C160 405.3 149.3 416 136 416H88C74.75 416 64 405.3 64 392V344C64 330.7 74.75 320 88 320H136zM128 384V352H96V384H128zM136 192C149.3 192 160 202.7 160 216V264C160 277.3 149.3 288 136 288H88C74.75 288 64 277.3 64 264V216C64 202.7 74.75 192 88 192H136zM128 256V224H96V256H128z"],
    "bullhorn": [512, 512, [128363, 128226], "f0a1", "M378.1 16.72C403.8-9.531 448 8.069 448 44.23V435.8C448 471.9 403.8 489.5 378.1 463.3L355.1 438.1C311.8 392.4 254.1 363.3 192 355.4V456C192 486.9 166.9 512 136 512H120C89.07 512 64 486.9 64 456V352C28.65 352 0 323.3 0 287.1V191.1C0 156.7 28.65 127.1 64 127.1H143.6L172.8 126.4C242.1 122.5 307.4 92.28 355.1 41.86L378.1 16.72zM416 44.23C416 36.1 407.2 33.48 402.2 38.73L378.4 63.87C336.5 108 282.7 138.4 224 151.5V328.5C282.7 341.6 336.5 371.1 378.4 416.1L402.2 441.3C407.2 446.5 416 443 416 435.8L416 44.23zM192 323.1V156.9C186.2 157.5 180.4 158 174.5 158.3L144.4 159.1H64C46.33 159.1 32 174.3 32 191.1V287.1C32 305.7 46.33 319.1 64 319.1H144.4L174.5 321.7C180.4 321.1 186.2 322.5 192 323.1V323.1zM96 352V456C96 469.3 106.7 480 120 480H136C149.3 480 160 469.3 160 456V352.9L143.6 352H96zM496 191.1C504.8 191.1 512 199.2 512 207.1V271.1C512 280.8 504.8 287.1 496 287.1C487.2 287.1 480 280.8 480 271.1V207.1C480 199.2 487.2 191.1 496 191.1V191.1z"],
    "bullseye": [512, 512, [], "f140", "M192 256C192 220.7 220.7 192 256 192C291.3 192 320 220.7 320 256C320 291.3 291.3 320 256 320C220.7 320 192 291.3 192 256zM256 288C273.7 288 288 273.7 288 256C288 238.3 273.7 224 256 224C238.3 224 224 238.3 224 256C224 273.7 238.3 288 256 288zM96 256C96 167.6 167.6 96 256 96C344.4 96 416 167.6 416 256C416 344.4 344.4 416 256 416C167.6 416 96 344.4 96 256zM256 384C326.7 384 384 326.7 384 256C384 185.3 326.7 128 256 128C185.3 128 128 185.3 128 256C128 326.7 185.3 384 256 384zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "bullseye-arrow": [512, 512, [127919], "f648", "M300.9 32.58C299.8 33.64 298.6 34.73 297.5 35.84C284.1 33.32 270.2 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 241.8 478.7 227.9 476.2 214.5C477.3 213.4 478.4 212.2 479.4 211.1L502.2 185.7C508.6 208 512 231.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C280.4 0 303.1 3.406 326.3 9.768L300.9 32.58zM275.5 105.2L279.7 130.2C272 128.8 264.1 127.1 255.1 127.1C185.3 127.1 127.1 185.3 127.1 255.1C127.1 326.7 185.3 384 255.1 384C326.7 384 384 326.7 384 255.1C384 247.9 383.2 239.1 381.8 232.3L406.8 236.5C409.5 236.9 412.2 237.2 414.9 237.4C415.6 243.5 416 249.7 416 255.1C416 344.4 344.4 416 256 416C167.6 416 96 344.4 96 255.1C96 167.6 167.6 95.1 256 95.1C262.3 95.1 268.5 96.36 274.6 97.07C274.8 99.78 275.1 102.5 275.5 105.2H275.5zM341.5 193.1L267.3 267.3C261.1 273.6 250.9 273.6 244.7 267.3C238.4 261.1 238.4 250.9 244.7 244.7L318.9 170.5L307.1 100.1C304.4 83.79 310.2 67.26 322.6 56.3L371.1 12.37C385.1 .7184 405.9 6.611 410.9 23.42L428.8 83.15L488.6 101.1C505.4 106.1 511.3 126.9 499.6 140L455.7 189.4C444.7 201.8 428.2 207.6 411.9 204.9L341.5 193.1zM369.3 165.3L417.2 173.3C422.6 174.2 428.1 172.3 431.8 168.2L467.4 128.1L420.6 114.1L369.3 165.3zM397.9 91.44L383.9 44.62L343.8 80.22C339.7 83.87 337.8 89.38 338.7 94.8L346.7 142.7L397.9 91.44z"],
    "bullseye-pointer": [512, 512, [], "f649", "M256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 266.4 32.71 276.6 34.07 286.6L24.45 290.2C16.61 293 9.781 297.9 4.505 304.1C1.548 288.5 0 272.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C239.6 512 223.5 510.5 207.9 507.5C214.1 502.2 218.1 495.4 221.8 487.6L225.4 477.9C235.4 479.3 245.6 480 256 480V480zM260 383.9C328.9 381.8 384 325.3 384 256C384 185.3 326.7 128 256 128C186.7 128 130.2 183.1 128.1 251.1L96.18 263.7C96.06 261.2 95.1 258.6 95.1 255.1C95.1 167.6 167.6 95.1 255.1 95.1C344.4 95.1 416 167.6 416 255.1C416 344.4 344.4 416 255.1 416C253.4 416 250.8 415.9 248.3 415.8L260 383.9zM191.8 476.5C189.5 482.7 183.7 486.8 177.1 486.1C170.5 487.1 164.5 483.1 162 477.1L131.5 403.1L27.31 507.3C21.07 513.6 10.94 513.6 4.686 507.3C-1.562 501.1-1.562 490.9 4.686 484.7L108.9 380.5L34.95 349.1C28.85 347.5 24.92 341.5 25.04 334.9C25.17 328.3 29.32 322.5 35.51 320.2L250.5 240.1C256.3 238.8 262.9 240.3 267.3 244.7C271.7 249.1 273.2 255.7 271 261.5L191.8 476.5zM152 368.7L175.1 426.9L229 282.1L85.07 336L143.3 360C147.2 361.6 150.4 364.8 152 368.7L152 368.7z"],
    "burger": [512, 512, ["hamburger"], "f805", "M49.45 250.1C44.81 248.2 40.83 244.4 37.81 239.9C34.79 235.4 32.79 230.3 31.95 224.1C31.12 219.6 31.48 214.2 32.99 208.1C44.73 158.7 73.16 113.8 113.6 81.63C154.1 49.5 204.3 32.01 256 32.01C307.7 32.01 357.9 49.5 398.4 81.63C438.8 113.8 467.3 158.7 479 208.1C480.5 214.2 480.9 219.6 480 224.1C479.2 230.3 477.2 235.4 474.2 239.9C471.2 244.4 467.2 248.2 462.6 250.1C457.9 253.7 452.7 255.5 447.3 256H64.67C59.29 255.5 54.09 253.7 49.45 250.1zM133.6 106.3C98.73 133.9 74.3 172.5 64.29 215.8C63.87 217.3 63.82 218.8 64.14 220.3C64.46 221.8 65.13 223.2 66.11 224.4L447.3 224C447.8 221.3 447.1 218.5 447.7 215.8C437.7 172.5 413.3 133.9 378.5 106.3C343.6 78.75 300.4 63.82 256 64C211.6 63.82 168.4 78.75 133.6 106.3zM340.7 155.3C337.7 152.3 336 148.2 336 144C336 140.8 336.9 137.7 338.7 135.1C340.5 132.5 342.1 130.4 345.9 129.2C348.8 128 352 127.7 355.1 128.3C358.2 128.9 361.1 130.4 363.3 132.7C365.6 134.9 367.1 137.8 367.7 140.9C368.3 143.1 367.1 147.2 366.8 150.1C365.6 153 363.5 155.5 360.9 157.3C358.3 159.1 355.2 160 352 160C347.8 160 343.7 158.3 340.7 155.3V155.3zM244.7 123.3C241.7 120.3 240 116.2 240 112C240 108.8 240.9 105.7 242.7 103.1C244.5 100.5 246.1 98.43 249.9 97.22C252.8 96.01 256 95.69 259.1 96.31C262.2 96.93 265.1 98.45 267.3 100.7C269.6 102.9 271.1 105.8 271.7 108.9C272.3 111.1 271.1 115.2 270.8 118.1C269.6 121 267.5 123.5 264.9 125.3C262.3 127.1 259.2 128 256 128C251.8 128 247.7 126.3 244.7 123.3V123.3zM148.7 155.3C145.7 152.3 144 148.2 144 144C144 140.8 144.9 137.7 146.7 135.1C148.5 132.5 150.1 130.4 153.9 129.2C156.8 128 160 127.7 163.1 128.3C166.2 128.9 169.1 130.4 171.3 132.7C173.6 134.9 175.1 137.8 175.7 140.9C176.3 143.1 175.1 147.2 174.8 150.1C173.6 153 171.5 155.5 168.9 157.3C166.3 159.1 163.2 160 160 160C155.8 160 151.7 158.3 148.7 155.3L148.7 155.3zM475.3 356.7C478.3 359.7 480 363.8 480 368V416C480 432.1 473.3 449.3 461.3 461.3C449.3 473.3 432.1 480 416 480H96C79.03 480 62.75 473.3 50.75 461.3C38.74 449.3 32 432.1 32 416V368C32 363.8 33.69 359.7 36.69 356.7C39.69 353.7 43.76 352 48 352H464C468.2 352 472.3 353.7 475.3 356.7zM448 384H64V416C64 424.5 67.37 432.6 73.37 438.6C79.37 444.6 87.51 448 96 448H416C424.5 448 432.6 444.6 438.6 438.6C444.6 432.6 448 424.5 448 416V384zM491.3 292.7C494.3 295.7 496 299.8 496 304C496 308.2 494.3 312.3 491.3 315.3C488.3 318.3 484.2 320 480 320H32C27.76 320 23.69 318.3 20.69 315.3C17.69 312.3 16 308.2 16 304C16 299.8 17.69 295.7 20.69 292.7C23.69 289.7 27.76 288 32 288H480C484.2 288 488.3 289.7 491.3 292.7z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M244.7 123.3C241.7 120.3 240 116.2 240 112C240 108.8 240.9 105.7 242.7 103.1C244.5 100.5 246.1 98.43 249.9 97.22C252.8 96.01 256 95.69 259.1 96.31C262.2 96.93 265.1 98.45 267.3 100.7C269.6 102.9 271.1 105.8 271.7 108.9C272.3 111.1 271.1 115.2 270.8 118.1C269.6 121 267.5 123.5 264.9 125.3C262.3 127.1 259.2 128 256 128C251.8 128 247.7 126.3 244.7 123.3V123.3zM340.7 155.3C337.7 152.3 336 148.2 336 144C336 140.8 336.9 137.7 338.7 135.1C340.5 132.5 342.1 130.4 345.9 129.2C348.8 128 352 127.7 355.1 128.3C358.2 128.9 361.1 130.4 363.3 132.7C365.6 134.9 367.1 137.8 367.7 140.9C368.3 143.1 367.1 147.2 366.8 150.1C365.6 153 363.5 155.5 360.9 157.3C358.3 159.1 355.2 160 352 160C347.8 160 343.7 158.3 340.7 155.3V155.3zM148.7 155.3C145.7 152.3 144 148.2 144 144C144 140.8 144.9 137.7 146.7 135.1C148.5 132.5 150.1 130.4 153.9 129.2C156.8 128 160 127.7 163.1 128.3C166.2 128.9 169.1 130.4 171.3 132.7C173.6 134.9 175.1 137.8 175.7 140.9C176.3 143.1 175.1 147.2 174.8 150.1C173.6 153 171.5 155.5 168.9 157.3C166.3 159.1 163.2 160 160 160C155.8 160 151.7 158.3 148.7 155.3L148.7 155.3zM491.3 292.7C494.3 295.7 496 299.8 496 304C496 308.2 494.3 312.3 491.3 315.3C488.3 318.3 484.2 320 480 320H420.2L328.9 381.3C326.3 383.1 323.2 384 320 384C316.8 383.1 313.8 383.1 311.1 381.3L219.2 320H32C27.76 320 23.69 318.3 20.69 315.3C17.69 312.3 16 308.2 16 304C16 299.8 17.69 295.7 20.69 292.7C23.69 289.7 27.76 288 32 288H224C227.2 288 230.2 288.9 232.9 290.7L320 348.8L406.4 290.7C409 288.9 412.1 287.1 415.3 288H480C484.2 288 488.3 289.7 491.3 292.7zM475.3 356.7C478.3 359.7 480 363.8 480 368V416C480 432.1 473.3 449.3 461.3 461.3C449.3 473.3 432.1 480 416 480H96C79.03 480 62.75 473.3 50.75 461.3C38.74 449.3 32 432.1 32 416V368C32 363.8 33.69 359.7 36.69 356.7C39.69 353.7 43.76 352 48 352H209.5L257.5 384H64V416C64 424.5 67.37 432.6 73.37 438.6C79.37 444.6 87.51 448 96 448H416C424.5 448 432.6 444.6 438.6 438.6C444.6 432.6 448 424.5 448 416V384H382.3L429.1 352H464C468.2 352 472.3 353.7 475.3 356.7zM49.45 250.1C44.81 248.2 40.83 244.4 37.81 239.9C34.79 235.4 32.79 230.3 31.95 224.1C31.12 219.6 31.48 214.2 32.99 208.1C44.73 158.7 73.16 113.8 113.6 81.63C154.1 49.5 204.3 32.01 256 32.01C307.7 32.01 357.9 49.5 398.4 81.63C438.8 113.8 467.3 158.7 479 208.1C480.5 214.2 480.9 219.6 480 224.1C479.2 230.3 477.2 235.4 474.2 239.9C471.2 244.4 467.2 248.2 462.6 250.1C457.9 253.7 452.7 255.5 447.3 256H64.67C59.29 255.5 54.09 253.7 49.45 250.1zM133.6 106.3C98.73 133.9 74.3 172.5 64.29 215.8C63.87 217.3 63.82 218.8 64.14 220.3C64.46 221.8 65.13 223.2 66.11 224.4L447.3 224C447.8 221.3 447.1 218.5 447.7 215.8C437.7 172.5 413.3 133.9 378.5 106.3C343.6 78.75 300.4 63.82 256 64C211.6 63.82 168.4 78.75 133.6 106.3z"],
    "burger-fries": [640, 512, [], "e0cd", "M148.7 267.3C145.7 264.3 144 260.2 144 255.1V31.1C144 26.55 145.4 21.2 148.1 16.45C150.7 11.69 154.6 7.698 159.2 4.836C163.8 1.975 169.1 .3433 174.5 .0956C179.1-.1521 185.4 .9929 190.3 3.421L222.3 19.42C227.6 22.05 232.1 26.12 235.2 31.17C238.4 36.23 240 42.05 240 47.1V255.1C240 260.2 238.3 264.3 235.3 267.3C232.3 270.3 228.2 271.1 224 271.1C219.8 271.1 215.7 270.3 212.7 267.3C209.7 264.3 208 260.2 208 255.1V47.1L176 31.1V255.1C176 260.2 174.3 264.3 171.3 267.3C168.3 270.3 164.2 271.1 160 271.1C155.8 271.1 151.7 270.3 148.7 267.3V267.3zM85.69 204.3C82.8 201.9 80.85 198.5 80.2 194.8L56.2 58.78C55.62 55.54 56.06 52.19 57.46 49.21C58.86 46.23 61.14 43.75 64 42.11L104.1 19.2C107.7 17.31 111.1 16.92 115.9 18.11C119.9 19.29 123.2 21.95 125.3 25.54C127.3 29.13 127.9 33.37 126.9 37.37C125.9 41.37 123.3 44.82 119.8 47.01L89.6 64.32L111.6 189.2C112.3 193.4 111.4 197.7 109 201.1C106.6 204.6 102.9 206.1 98.79 207.8C97.87 207.9 96.94 208 96 207.1C92.23 208 88.58 206.7 85.69 204.3zM266.9 63.04C262.9 61.7 259.6 58.81 257.7 55.02C255.8 51.22 255.4 46.82 256.8 42.8C258.1 38.77 261 35.44 264.8 33.54C268.6 31.64 273 31.33 277 32.67L325 48.67C328.9 49.94 332.1 52.64 334.1 56.2C335.1 59.77 336.5 63.94 335.5 67.87L303.5 195.9C302.6 199.3 300.6 202.4 297.8 204.6C295 206.8 291.6 207.1 288 207.1C286.7 208 285.3 207.8 284 207.5C279.9 206.5 276.4 203.9 274.2 200.2C272 196.6 271.4 192.2 272.4 188.1L300.8 74.53L266.9 63.2L266.9 63.04zM359.5 157.5C357.7 156.4 356.2 154.1 354.9 153.2C353.7 151.5 352.9 149.6 352.4 147.5C351.9 145.5 351.9 143.4 352.2 141.3L360 95.1C360.3 93.84 360.1 91.76 362 89.87C363.1 87.99 364.6 86.35 366.3 85.05C368.1 83.75 370.1 82.82 372.2 82.32C374.3 81.81 376.5 81.74 378.6 82.11C380.8 82.48 382.8 83.28 384.6 84.47C386.4 85.65 388 87.2 389.2 89.01C390.4 90.81 391.2 92.85 391.6 94.99C392 97.12 391.1 99.32 391.5 101.4L383.7 146.7C383.1 150.4 381.2 153.8 378.3 156.2C375.4 158.7 371.8 159.1 368 159.1C367.1 160 366.2 159.9 365.3 159.8C363.2 159.4 361.3 158.7 359.5 157.5L359.5 157.5zM22.38 188.4C19.53 186.1 17.57 182.8 16.84 179.2L.3232 99.2C-.5254 95.04 .3127 90.71 2.653 87.17C4.994 83.63 8.645 81.17 12.8 80.32C16.96 79.47 21.29 80.31 24.83 82.65C28.37 84.99 30.83 88.64 31.68 92.8L48.16 172.8C48.58 174.9 48.59 176.1 48.2 179C47.8 181.1 46.99 183.1 45.83 184.8C44.68 186.6 43.18 188.1 41.44 189.3C39.7 190.4 37.74 191.3 35.68 191.7C34.63 191.9 33.56 191.1 32.48 191.1C28.8 191.1 25.23 190.7 22.38 188.4H22.38zM624 415.3C624 415.5 624 415.8 624 415.1V459.1C623.1 473.8 618.5 486.1 608.8 496.7C599 506.5 585.8 511.1 572 511.1H324C310.2 511.1 297 506.5 287.3 496.7C277.5 486.1 272 473.8 272 459.1V415.1C272 415.8 272.1 415.5 272.2 415.3C261.8 404.8 255.1 390.7 255.1 376C255.1 361.3 261.8 347.2 272.2 336.7C272.1 336.5 272 336.2 272 335.1V295.1C272.2 283.5 274.1 271.3 280.1 259.9C285.1 248.5 292.5 238.3 301.6 229.8C341.9 194.2 393.1 175.1 447.7 175.1H448.4C502.1 175.1 554.2 194.3 594.4 229.8C603.5 238.3 610.9 248.5 615.9 259.9C621 271.3 623.8 283.5 624 295.1V335.1C624 336.2 624 336.5 624 336.7C634.3 347.2 640.1 361.3 640 375.1C640.1 390.7 634.3 404.8 624 415.3H624zM304 320.8C306.6 320.3 309.3 320.1 312 319.1H584C586.7 320.1 589.4 320.3 592 320.8V295.1C591.8 287.7 589.8 279.6 586.4 272.1C582.9 264.6 577.1 257.9 571.8 252.4C537.5 222.1 493.6 207.2 448.4 207.1H447.7C402.5 207.2 358.5 222.1 324.2 252.4C318 257.9 313.1 264.6 309.6 272.1C306.2 279.6 304.2 287.7 304 295.1V320.8zM592 431.2C589.4 431.7 586.7 431.9 584 431.1H312C309.3 431.9 306.6 431.7 304 431.2V459.1C304 465.3 306.1 470.4 309.9 474.1C313.6 477.9 318.7 479.1 324 479.1H572C577.3 479.1 582.4 477.9 586.1 474.1C589.9 470.4 592 465.3 592 459.1V431.2zM600.1 392.1C605.5 388.5 608 382.4 608 375.1C608 369.6 605.5 363.5 600.1 359C596.5 354.5 590.4 351.1 584 351.1H312C305.6 351.1 299.5 354.5 295 359C290.5 363.5 288 369.6 288 375.1C288 382.4 290.5 388.5 295 392.1C299.5 397.5 305.6 399.1 312 399.1H584C590.4 399.1 596.5 397.5 600.1 392.1zM356.7 283.3C353.7 280.3 352 276.2 352 271.1C352 268.8 352.9 265.7 354.7 263.1C356.5 260.5 358.1 258.4 361.9 257.2C364.8 256 368 255.7 371.1 256.3C374.2 256.9 377.1 258.4 379.3 260.7C381.6 262.9 383.1 265.8 383.7 268.9C384.3 271.1 383.1 275.2 382.8 278.1C381.6 281 379.5 283.5 376.9 285.3C374.3 287.1 371.2 287.1 368 287.1C363.8 287.1 359.7 286.3 356.7 283.3zM436.7 267.3C433.7 264.3 432 260.2 432 255.1C432 252.8 432.9 249.7 434.7 247.1C436.5 244.5 438.1 242.4 441.9 241.2C444.8 240 448 239.7 451.1 240.3C454.2 240.9 457.1 242.4 459.3 244.7C461.6 246.9 463.1 249.8 463.7 252.9C464.3 255.1 463.1 259.2 462.8 262.1C461.6 265 459.5 267.5 456.9 269.3C454.3 271.1 451.2 271.1 448 271.1C443.8 271.1 439.7 270.3 436.7 267.3zM516.7 283.3C513.7 280.3 512 276.2 512 271.1C512 268.8 512.9 265.7 514.7 263.1C516.5 260.5 518.1 258.4 521.9 257.2C524.8 256 528 255.7 531.1 256.3C534.2 256.9 537.1 258.4 539.3 260.7C541.6 262.9 543.1 265.8 543.7 268.9C544.3 271.1 543.1 275.2 542.8 278.1C541.6 281 539.5 283.5 536.9 285.3C534.3 287.1 531.2 287.1 528 287.1C523.8 287.1 519.7 286.3 516.7 283.3H516.7zM251.3 484.7C254.3 487.7 256 491.8 256 495.1C256 500.2 254.3 504.3 251.3 507.3C248.3 510.3 244.2 511.1 240 511.1H80C76.43 511.1 72.97 510.8 70.16 508.6C67.34 506.4 65.35 503.3 64.48 499.9L.4835 243.9C-.0966 241.5-.1273 238.1 .3936 236.6C.9146 234.2 1.974 231.9 3.492 230C4.975 228.1 6.876 226.6 9.045 225.5C11.22 224.5 13.6 223.1 16 223.1H48C50.7 224.2 53.33 224.9 55.72 226.1C58.12 227.4 60.22 229.1 61.89 231.3L83.97 253.3C108.5 276.2 138.6 292 171.3 299.3C187.8 301.1 204.6 301.8 220.1 298.7C223.1 298.1 225.4 297.9 227.6 298.2C229.8 298.5 231.9 299.3 233.8 300.4C235.7 301.6 237.4 303.1 238.7 304.9C239.9 306.8 240.8 308.8 241.2 311C241.7 313.2 241.6 315.5 241.1 317.6C240.6 319.8 239.7 321.9 238.4 323.6C237 325.4 235.4 326.9 233.4 328C231.5 329.1 229.3 329.8 227.1 330C204.6 334.4 181.4 334.3 158.9 329.6C123.3 322.6 90.64 305.2 64.1 279.6L41.38 255.1H36.52L92.52 479.1H240C244.2 479.1 248.3 481.7 251.3 484.7H251.3z"],
    "burger-glass": [640, 512, [], "e0ce", "M235.3 484.7C238.3 487.7 239.1 491.8 239.1 496C239.1 500.2 238.3 504.3 235.3 507.3C232.3 510.3 228.2 512 223.1 512H82.65C71.4 511.9 60.57 507.7 52.26 500.1C43.96 492.5 38.78 482.1 37.73 470.8L.3493 50.62C-.3326 44.3 .3132 37.9 2.245 31.84C4.177 25.78 7.353 20.18 11.57 15.42C15.79 10.65 20.95 6.821 26.73 4.166C32.52 1.511 38.79 .0925 45.15 0H306.8C313.2 .0685 319.5 1.474 325.3 4.125C331.1 6.776 336.3 10.62 340.6 15.39C344.8 20.17 347.1 25.78 349.9 31.87C351.8 37.95 352.5 44.38 351.8 50.72L341.9 145.5C341.3 149.6 339.1 153.3 335.9 155.8C332.6 158.4 328.5 159.6 324.4 159.2C320.3 158.7 316.5 156.8 313.9 153.6C311.2 150.5 309.8 146.5 310 142.3L319.1 47.52C320.2 45.62 320.1 43.69 319.6 41.85C319 40.01 318.1 38.31 316.9 36.85C315.6 35.38 314.1 34.2 312.4 33.36C310.6 32.53 308.8 32.06 306.8 32H45.15C43.23 32.06 41.35 32.53 39.63 33.36C37.9 34.2 36.37 35.38 35.13 36.85C33.9 38.31 32.98 40.01 32.44 41.85C31.9 43.69 31.75 45.62 31.1 47.52L42.11 160H271.1C276.2 160 280.3 161.7 283.3 164.7C286.3 167.7 287.1 171.8 287.1 176C287.1 180.2 286.3 184.3 283.3 187.3C280.3 190.3 276.2 192 271.1 192H44.96L69.57 467.8C69.86 471.1 71.36 474.1 73.78 476.4C76.19 478.6 79.35 479.9 82.65 480H223.1C228.2 480 232.3 481.7 235.3 484.7L235.3 484.7zM516.7 283.3C513.7 280.3 511.1 276.2 511.1 271.1C511.1 268.8 512.9 265.7 514.7 263.1C516.5 260.5 518.1 258.4 521.9 257.2C524.8 256 528 255.7 531.1 256.3C534.2 256.9 537.1 258.4 539.3 260.7C541.5 262.9 543.1 265.8 543.7 268.9C544.3 271.1 543.1 275.2 542.8 278.1C541.6 281 539.5 283.5 536.9 285.3C534.3 287.1 531.2 287.1 527.1 287.1C523.8 287.1 519.7 286.3 516.7 283.3H516.7zM356.7 283.3C353.7 280.3 351.1 276.2 351.1 271.1C351.1 268.8 352.9 265.7 354.7 263.1C356.5 260.5 358.1 258.4 361.9 257.2C364.8 256 368 255.7 371.1 256.3C374.2 256.9 377.1 258.4 379.3 260.7C381.5 262.9 383.1 265.8 383.7 268.9C384.3 271.1 383.1 275.2 382.8 278.1C381.6 281 379.5 283.5 376.9 285.3C374.3 287.1 371.2 287.1 367.1 287.1C363.8 287.1 359.7 286.3 356.7 283.3zM436.7 267.3C433.7 264.3 431.1 260.2 431.1 255.1C431.1 252.8 432.9 249.7 434.7 247.1C436.5 244.5 438.1 242.4 441.9 241.2C444.8 240 448 239.7 451.1 240.3C454.2 240.9 457.1 242.4 459.3 244.7C461.5 246.9 463.1 249.8 463.7 252.9C464.3 255.1 463.1 259.2 462.8 262.1C461.6 265 459.5 267.5 456.9 269.3C454.3 271.1 451.2 271.1 447.1 271.1C443.8 271.1 439.7 270.3 436.7 267.3zM623.1 415.3C624 415.5 624 415.8 623.1 416V460C623.1 473.8 618.5 487 608.7 496.8C598.1 506.5 585.8 511.1 571.1 512H323.1C310.2 511.1 296.1 506.5 287.2 496.8C277.5 487 272 473.8 271.1 460V416C272 415.8 272.1 415.5 272.2 415.3C261.8 404.8 256 390.7 256 376C256 361.3 261.8 347.2 272.2 336.7C272.1 336.5 272 336.2 271.1 336V295.1C272.2 283.5 274.1 271.2 280.1 259.9C285.1 248.5 292.5 238.2 301.6 229.7C342.5 195.1 394.4 176.1 447.1 176.1C501.6 176.1 553.5 195.1 594.4 229.7C603.5 238.2 610.9 248.5 615.9 259.9C621 271.2 623.8 283.5 623.1 295.1V336C624 336.2 624 336.5 623.1 336.7C634.3 347.2 640.1 361.3 639.1 376C640.1 390.7 634.3 404.8 623.1 415.3zM303.1 320.8C306.6 320.3 309.3 320.1 311.1 319.1H583.1C586.7 320.1 589.4 320.3 591.1 320.8V295.1C591.8 287.7 589.8 279.6 586.4 272.1C582.9 264.6 577.1 257.9 571.8 252.4C510.4 191.1 380.1 195.6 324.2 252.4C318 257.9 313.1 264.6 309.6 272.1C306.1 279.6 304.2 287.7 303.1 295.1V320.8zM591.1 431.2C589.4 431.7 586.7 431.9 583.1 432H311.1C309.3 431.9 306.6 431.7 303.1 431.2V460C303.1 465.3 306.1 470.4 309.9 474.1C313.6 477.9 318.7 480 323.1 480H571.1C577.3 480 582.4 477.9 586.1 474.1C589.9 470.4 591.1 465.3 591.1 460V431.2zM600.1 392.1C605.5 388.5 607.1 382.4 607.1 376C607.1 369.6 605.5 363.5 600.1 359C596.5 354.5 590.4 352 583.1 352H311.1C305.6 352 299.5 354.5 295 359C290.5 363.5 287.1 369.6 287.1 376C287.1 382.4 290.5 388.5 295 392.1C299.5 397.5 305.6 400 311.1 400H583.1C590.4 400 596.5 397.5 600.1 392.1z"],
    "burger-lettuce": [512, 512, [], "e3e3", "M244.7 123.3C241.7 120.3 240 116.2 240 112C240 108.8 240.9 105.7 242.7 103.1C244.5 100.5 246.1 98.43 249.9 97.22C252.8 96.01 256 95.69 259.1 96.31C262.2 96.93 265.1 98.45 267.3 100.7C269.6 102.9 271.1 105.8 271.7 108.9C272.3 111.1 271.1 115.2 270.8 118.1C269.6 121 267.5 123.5 264.9 125.3C262.3 127.1 259.2 128 256 128C251.8 128 247.7 126.3 244.7 123.3V123.3zM340.7 155.3C337.7 152.3 336 148.2 336 144C336 140.8 336.9 137.7 338.7 135.1C340.5 132.5 342.1 130.4 345.9 129.2C348.8 128 352 127.7 355.1 128.3C358.2 128.9 361.1 130.4 363.3 132.7C365.6 134.9 367.1 137.8 367.7 140.9C368.3 143.1 367.1 147.2 366.8 150.1C365.6 153 363.5 155.5 360.9 157.3C358.3 159.1 355.2 160 352 160C347.8 160 343.7 158.3 340.7 155.3V155.3zM148.7 155.3C145.7 152.3 144 148.2 144 144C144 140.8 144.9 137.7 146.7 135.1C148.5 132.5 150.1 130.4 153.9 129.2C156.8 128 160 127.7 163.1 128.3C166.2 128.9 169.1 130.4 171.3 132.7C173.6 134.9 175.1 137.8 175.7 140.9C176.3 143.1 175.1 147.2 174.8 150.1C173.6 153 171.5 155.5 168.9 157.3C166.3 159.1 163.2 160 160 160C155.8 160 151.7 158.3 148.7 155.3L148.7 155.3zM49.45 250.1C44.81 248.2 40.83 244.4 37.81 239.9C34.79 235.4 32.79 230.3 31.95 224.1C31.12 219.6 31.48 214.2 32.99 208.1C44.73 158.7 73.16 113.8 113.6 81.63C154.1 49.5 204.3 32.01 256 32.01C307.7 32.01 357.9 49.5 398.4 81.63C438.8 113.8 467.3 158.7 479 208.1C480.5 214.2 480.9 219.6 480 224.1C479.2 230.3 477.2 235.4 474.2 239.9C471.2 244.4 467.2 248.2 462.6 250.1C457.9 253.7 452.7 255.5 447.3 256H64.67C59.29 255.5 54.09 253.7 49.45 250.1zM133.6 106.3C98.73 133.9 74.3 172.5 64.29 215.8C63.87 217.3 63.82 218.8 64.14 220.3C64.46 221.8 65.14 223.2 66.11 224.4L447.3 224C447.9 221.3 447.1 218.5 447.7 215.8C437.7 172.5 413.3 133.9 378.5 106.3C343.6 78.75 300.4 63.82 256 64C211.6 63.82 168.4 78.75 133.6 106.3zM475.3 356.7C478.3 359.7 480 363.8 480 368V416C480 432.1 473.3 449.3 461.3 461.3C449.3 473.3 432.1 480 416 480H96C79.03 480 62.75 473.3 50.75 461.3C38.74 449.3 32 432.1 32 416V368C32 363.8 33.69 359.7 36.69 356.7C39.69 353.7 43.76 352 48 352H464C468.2 352 472.3 353.7 475.3 356.7zM448 384H64V416C64 424.5 67.37 432.6 73.37 438.6C79.37 444.6 87.51 448 96 448H416C424.5 448 432.6 444.6 438.6 438.6C444.6 432.6 448 424.5 448 416V384zM86.42 336.1C67.28 336.1 48.78 329.3 34.27 316.8C30.9 314.2 28.7 310.4 28.14 306.2C27.58 301.1 28.72 297.7 31.3 294.4C33.88 290.1 37.69 288.8 41.9 288.2C46.1 287.7 50.36 288.8 53.73 291.4C62.68 299.5 74.33 304 86.42 304C98.5 304 110.2 299.5 119.1 291.4C133.6 278.9 152.1 272.1 171.2 272.1C190.3 272.1 208.8 278.9 223.3 291.4C232.3 299.5 243.9 304 256 304C268.1 304 279.7 299.5 288.7 291.4C303.2 278.9 321.7 272.1 340.8 272.1C359.9 272.1 378.4 278.9 392.9 291.4C401.9 299.5 413.5 304 425.6 304C437.7 304 449.3 299.5 458.3 291.4C459.9 290.1 461.8 289.2 463.9 288.6C465.9 288.1 468 287.1 470.1 288.2C472.2 288.5 474.2 289.2 476 290.2C477.8 291.3 479.4 292.7 480.7 294.4C481.1 296 482.9 297.9 483.5 299.1C484 302 484.1 304.1 483.9 306.2C483.6 308.3 482.9 310.3 481.8 312.1C480.8 313.9 479.4 315.5 477.7 316.8C463.2 329.3 444.7 336.1 425.6 336.1C406.5 336.1 387.1 329.3 373.5 316.8C364.5 308.7 352.9 304.2 340.8 304.2C328.7 304.2 317.1 308.7 308.1 316.8C293.6 329.3 275.1 336.1 256 336.1C236.9 336.1 218.4 329.3 203.9 316.8C194.9 308.7 183.3 304.2 171.2 304.2C159.1 304.2 147.5 308.7 138.6 316.8C124.1 329.3 105.6 336.1 86.42 336.1L86.42 336.1z"],
    "burger-soda": [640, 512, [], "f858", "M436.7 267.3C433.7 264.3 432 260.2 432 256C432 252.8 432.9 249.7 434.7 247.1C436.5 244.5 438.1 242.4 441.9 241.2C444.8 240 448 239.7 451.1 240.3C454.2 240.9 457.1 242.4 459.3 244.7C461.6 246.9 463.1 249.8 463.7 252.9C464.3 255.1 463.1 259.2 462.8 262.1C461.6 265 459.5 267.5 456.9 269.3C454.3 271.1 451.2 272 448 272C443.8 272 439.7 270.3 436.7 267.3zM516.7 283.3C513.7 280.3 512 276.2 512 272C512 268.8 512.9 265.7 514.7 263.1C516.5 260.5 518.1 258.4 521.9 257.2C524.8 256 528 255.7 531.1 256.3C534.2 256.9 537.1 258.4 539.3 260.7C541.6 262.9 543.1 265.8 543.7 268.9C544.3 271.1 543.1 275.2 542.8 278.1C541.6 281 539.5 283.5 536.9 285.3C534.3 287.1 531.2 288 528 288C523.8 288 519.7 286.3 516.7 283.3H516.7zM224 480C228.2 480 232.3 481.7 235.3 484.7C238.3 487.7 240 491.8 240 496C240 500.2 238.3 504.3 235.3 507.3C232.3 510.3 228.2 512 224 512H96C87.87 512.1 80.03 509 74.08 503.5C68.13 497.1 64.52 490.3 64 482.2L32 160H16C11.76 160 7.687 158.3 4.686 155.3C1.686 152.3 0 148.2 0 144C0 139.8 1.686 135.7 4.686 132.7C7.687 129.7 11.76 128 16 128H179.5L205.5 24.26C207.2 17.32 211.1 11.16 216.8 6.765C222.4 2.365 229.3-.0172 236.4 .0001H272C276.2 .0001 280.3 1.686 283.3 4.686C286.3 7.687 288 11.76 288 16C288 20.24 286.3 24.31 283.3 27.31C280.3 30.31 276.2 32 272 32H236.4L212.4 128H336C340.2 128 344.3 129.7 347.3 132.7C350.3 135.7 352 139.8 352 144C352 148.2 350.3 152.3 347.3 155.3C344.3 158.3 340.2 160 336 160H64L96 479.1L224.3 480H224zM356.7 283.3C353.7 280.3 352 276.2 352 272C352 268.8 352.9 265.7 354.7 263.1C356.5 260.5 358.1 258.4 361.9 257.2C364.8 256 368 255.7 371.1 256.3C374.2 256.9 377.1 258.4 379.3 260.7C381.6 262.9 383.1 265.8 383.7 268.9C384.3 271.1 383.1 275.2 382.8 278.1C381.6 281 379.5 283.5 376.9 285.3C374.3 287.1 371.2 288 368 288C363.8 288 359.7 286.3 356.7 283.3zM624 415.3C624 415.5 624 415.8 624 416V460C623.1 473.8 618.5 487 608.8 496.8C599 506.5 585.8 511.1 572 512H324C310.2 511.1 296.1 506.5 287.2 496.8C277.5 487 272 473.8 272 460V416C272 415.8 272.1 415.5 272.2 415.3C261.8 404.8 256 390.7 256 376C256 361.3 261.8 347.2 272.2 336.7C272.1 336.5 272 336.2 272 336V296C272.2 283.5 274.1 271.2 280.1 259.9C285.1 248.5 292.5 238.2 301.6 229.7C342.5 195.1 394.4 176.1 448 176.1C501.6 176.1 553.5 195.1 594.4 229.7C603.5 238.2 610.9 248.5 615.9 259.9C621 271.2 623.8 283.5 624 296V336C624 336.2 624 336.5 624 336.7C634.3 347.2 640.1 361.3 640 376C640.1 390.7 634.3 404.8 624 415.3zM304 320.8C306.6 320.3 309.3 320.1 312 320H584C586.7 320.1 589.4 320.3 592 320.8V296C591.8 287.7 589.8 279.6 586.4 272.1C582.9 264.6 577.1 257.9 571.8 252.4C510.4 191.1 380.1 195.6 324.2 252.4C318 257.9 313.1 264.6 309.6 272.1C306.1 279.6 304.2 287.7 304 296V320.8zM592 431.2C589.4 431.7 586.7 431.9 584 432H312C309.3 431.9 306.6 431.7 304 431.2V460C304 465.3 306.1 470.4 309.9 474.1C313.6 477.9 318.7 480 324 480H572C577.3 480 582.4 477.9 586.1 474.1C589.9 470.4 592 465.3 592 460V431.2zM600.1 392.1C605.5 388.5 608 382.4 608 376C608 369.6 605.5 363.5 600.1 359C596.5 354.5 590.4 352 584 352H312C305.6 352 299.5 354.5 295 359C290.5 363.5 288 369.6 288 376C288 382.4 290.5 388.5 295 392.1C299.5 397.5 305.6 400 312 400H584C590.4 400 596.5 397.5 600.1 392.1z"],
    "burrito": [512, 512, [127791], "f7ed", "M511.1 123c0-32.5-21.25-61.13-52.25-70.76c-6.25-20.38-21.05-37-40.55-45.75c-19.5-8.75-41.75-8.625-61.13 .25c-40.75-17.88-88.22 .7671-105.1 41.52L33.94 266.6c-45.25 45.25-45.25 118.8 0 164l47.5 47.5c45.25 45.25 118.7 45.25 163.9-.0011l218.3-218.1c40.75-17.75 59.39-65.26 41.52-106C509.7 144.3 511.1 133.7 511.1 123zM267.4 78.17c13.5 25.25 20.36 53.36 20.36 81.86c0 97-78.87 176-175.9 176c-25.75-.125-51.25-5.875-74.5-16.88C41.56 307.9 48.06 297.7 56.56 289.2L267.4 78.17zM222.8 455.4c-32.75 32.88-86 32.88-118.8 0l-47.5-47.5c-14.88-14.88-23.5-34.75-24.25-55.75c25.25 10.5 52.25 15.88 79.63 15.88c90.13 0 166.9-57.75 195.6-138.1c42.5-10.88 87.5-5.625 126.4 14.5L222.8 455.4zM479.1 186.1c0 15.38-7.375 28.63-18.38 37.63c-43.13-26.75-95.38-36.5-144.9-28.25c2.125-11.63 3.125-23.5 3.25-35.38c0-39.13-11.25-76.5-31.75-109.4c9-11.75 23-18.5 37.75-18.63c12.13 0 23.88 4.625 32.88 12.88c11.88-12.38 30-16.25 45.88-9.875c15.88 6.5 26.25 21.88 26.25 39c0 2.625-.25 5.25-.7501 7.75c12.25-2.375 25 .875 34.63 8.875c9.625 8 15.25 19.88 15.13 32.38c0 11.38-4.625 22.25-12.88 30.13C475.3 162.2 479.1 173.9 479.1 186.1z"],
    "burst": [512, 512, [], "e4dc", "M200.9 116.2L233.2 16.6C236.4 6.706 245.6 .001 256 .001C266.4 .001 275.6 6.706 278.8 16.6L313.3 123.1L383.8 97.45C392.6 94.26 402.4 96.43 408.1 103C415.6 109.6 417.7 119.4 414.6 128.2L388.9 198.7L495.4 233.2C505.3 236.4 512 245.6 512 256C512 266.4 505.3 275.6 495.4 278.8L392.3 312.2L445.2 412.8C450.1 422.1 448.4 433.5 440.1 440.1C433.5 448.4 422.1 450.1 412.8 445.2L312.2 392.3L278.8 495.4C275.6 505.3 266.4 512 256 512C245.6 512 236.4 505.3 233.2 495.4L199.8 392.3L99.17 445.2C89.87 450.1 78.46 448.4 71.03 440.1C63.6 433.5 61.87 422.1 66.76 412.8L119.7 312.2L16.6 278.8C6.705 275.6 .0003 266.4 .0003 256C.0003 245.6 6.705 236.4 16.6 233.2L116.2 200.9L4.208 37.57C-2.33 28.04-1.143 15.2 7.03 7.03C15.2-1.144 28.04-2.33 37.57 4.208L200.9 116.2zM146.5 211.2C143.3 220.8 135.7 228.2 126.1 231.3L49.96 256L129.5 281.8C138.5 284.7 145.8 291.4 149.3 300.2C152.9 308.9 152.4 318.8 147.1 327.1L107.1 404.9L184.9 364C193.2 359.6 203.1 359.1 211.8 362.7C220.6 366.2 227.3 373.5 230.2 382.5L256 462L281.8 382.5C284.7 373.5 291.4 366.2 300.2 362.7C308.9 359.1 318.8 359.6 327.1 364L404.9 404.9L364 327.1C359.6 318.8 359.1 308.9 362.7 300.2C366.2 291.4 373.5 284.7 382.5 281.8L462 256L379 229.1C370.8 226.4 363.9 220.5 360.1 212.7C356.3 204.9 355.8 195.9 358.8 187.7L378.6 133.4L324.3 153.2C316.1 156.2 307.1 155.7 299.3 151.9C291.5 148.1 285.6 141.2 282.9 132.1L256 49.96L231.3 126.1C228.2 135.7 220.8 143.3 211.2 146.5C201.7 149.8 191.1 148.3 182.8 142.6L54.87 54.87L142.6 182.8C148.3 191.1 149.8 201.7 146.5 211.2L146.5 211.2z"],
    "bus": [576, 512, [128653], "f207", "M336 64C344.8 64 352 71.16 352 80C352 88.84 344.8 96 336 96H240C231.2 96 224 88.84 224 80C224 71.16 231.2 64 240 64H336zM184 352C184 365.3 173.3 376 160 376C146.7 376 136 365.3 136 352C136 338.7 146.7 328 160 328C173.3 328 184 338.7 184 352zM392 352C392 338.7 402.7 328 416 328C429.3 328 440 338.7 440 352C440 365.3 429.3 376 416 376C402.7 376 392 365.3 392 352zM72.3 69.88C96.5 40.06 164.2 0 288 0C420.6 0 481.2 39.95 504.2 70.2C510.2 78.14 512 87.36 512 95.15V384C512 407.7 499.1 428.4 480 439.4V496C480 504.8 472.8 512 464 512C455.2 512 448 504.8 448 496V448H128V496C128 504.8 120.8 512 112 512C103.2 512 96 504.8 96 496V439.4C76.87 428.4 64 407.7 64 384V95.15C64 87.42 65.79 77.91 72.3 69.88V69.88zM288 32C170.1 32 113.2 70.22 97.15 90.05C96.77 90.51 96 91.94 96 95.15V128H480V95.15C480 92 479.2 90.3 478.7 89.53C463.9 70.12 414.8 32 288 32zM272 256V160H96V256H272zM304 256H480V160H304V256zM128 416H448C465.7 416 480 401.7 480 384V288H96V384C96 401.7 110.3 416 128 416zM32 240C32 248.8 24.84 256 16 256C7.164 256 0 248.8 0 240V144C0 135.2 7.164 128 16 128C24.84 128 32 135.2 32 144V240zM576 240C576 248.8 568.8 256 560 256C551.2 256 544 248.8 544 240V144C544 135.2 551.2 128 560 128C568.8 128 576 135.2 576 144V240z"],
    "bus-school": [512, 512, [], "f5dd", "M192 80C192 71.16 199.2 64 208 64H304C312.8 64 320 71.16 320 80C320 88.84 312.8 96 304 96H208C199.2 96 192 88.84 192 80zM104 352C104 338.7 114.7 328 128 328C141.3 328 152 338.7 152 352C152 365.3 141.3 376 128 376C114.7 376 104 365.3 104 352zM360 352C360 338.7 370.7 328 384 328C397.3 328 408 338.7 408 352C408 365.3 397.3 376 384 376C370.7 376 360 365.3 360 352zM480 336V392C480 414.3 466.9 433.6 448 442.6V496C448 504.8 440.8 512 432 512C423.2 512 416 504.8 416 496V448H96V496C96 504.8 88.84 512 80 512C71.16 512 64 504.8 64 496V442.6C45.08 433.6 32 414.3 32 392V336C32 307.6 44.36 282 64 264.4V84.26C64 76.59 65.76 66.87 72.62 58.79C94.5 33.02 152.4 0 256 0C366.9 0 419.2 32.88 439.9 59.11C446.2 67.13 448 76.53 448 84.26V264.4C467.6 282 480 307.6 480 336zM256 32C158.3 32 110.9 63.2 97.01 79.5C96.79 79.76 96 80.99 96 84.26V128H416V84.26C416 81.04 415.2 79.52 414.8 78.95C402.3 63.11 361.1 32 256 32V32zM128 240H240V160H96V245.5C106 241.9 116.8 240 128 240zM272 240H384C395.2 240 405.1 241.9 416 245.5V160H272V240zM64 392C64 405.3 74.75 416 88 416H424C437.3 416 448 405.3 448 392V336C448 300.7 419.3 272 384 272H128C92.65 272 64 300.7 64 336V392zM32 240C32 248.8 24.84 256 16 256C7.164 256 0 248.8 0 240V144C0 135.2 7.164 128 16 128C24.84 128 32 135.2 32 144V240zM512 240C512 248.8 504.8 256 496 256C487.2 256 480 248.8 480 240V144C480 135.2 487.2 128 496 128C504.8 128 512 135.2 512 144V240z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M72 352C72 338.7 82.75 328 96 328C109.3 328 120 338.7 120 352C120 365.3 109.3 376 96 376C82.75 376 72 365.3 72 352zM376 352C376 365.3 365.3 376 352 376C338.7 376 328 365.3 328 352C328 338.7 338.7 328 352 328C365.3 328 376 338.7 376 352zM440.2 70.2C446.2 78.14 448 87.36 448 95.15V384C448 407.7 435.1 428.4 416 439.4V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V448H64V496C64 504.8 56.84 512 48 512C39.16 512 32 504.8 32 496V439.4C12.87 428.4 0 407.7 0 384V95.15C0 87.42 1.788 77.91 8.304 69.88C32.5 40.06 100.2 0 224 0C356.6 0 417.2 39.95 440.2 70.2V70.2zM32 95.15V96H416V95.15C416 92 415.2 90.3 414.7 89.53C399.9 70.12 350.8 32 224 32C106.1 32 49.24 70.22 33.15 90.05C32.77 90.51 32 91.94 32 95.15zM32 128V256H416V128H32zM416 288H32V384C32 401.7 46.33 416 64 416H384C401.7 416 416 401.7 416 384V288z"],
    "business-time": [640, 512, ["briefcase-clock"], "f64a", "M496 224C416.4 224 352 288.4 352 368s64.38 144 144 144s144-64.38 144-144S575.6 224 496 224zM496 480c-61.75 0-112-50.25-112-112S434.3 256 496 256S608 306.3 608 368S557.8 480 496 480zM544 352h-32V304C512 295.2 504.8 288 496 288S480 295.2 480 304v64c0 8.836 7.164 16 16 16H544c8.836 0 16-7.164 16-16S552.8 352 544 352zM336 448H64c-17.67 0-32-14.33-32-32V288h144v64c0 8.836 7.164 16 16 16h112c8.836 0 16-7.164 16-16s-7.164-16-16-16h-96V288h128C344.8 288 352 280.8 352 272S344.8 256 336 256H32V160c0-17.67 14.33-32 32-32h384c17.67 0 32 14.33 32 32v16C480 184.8 487.2 192 496 192S512 184.8 512 176V160c0-35.35-28.65-64-64-64h-64V48C384 21.49 362.5 0 336 0h-160C149.5 0 128 21.49 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h272c8.836 0 16-7.164 16-16S344.8 448 336 448zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48z"],
    "butter": [640, 512, [129480], "e3e4", "M96 112C96 103.2 103.2 96 112 96H448v192h32V96h48C536.8 96 544 103.2 544 112V288h32V112C576 85.49 554.5 64 528 64h-416C85.49 64 64 85.49 64 112V288h32V112zM624 320h-608C7.156 320 0 327.2 0 336S7.156 352 16 352H32v48C32 426.5 53.53 448 80 448h480c26.47 0 48-21.53 48-48V352h16c8.844 0 16-7.156 16-16S632.8 320 624 320zM576 400c0 8.828-7.188 16-16 16h-480C71.19 416 64 408.8 64 400V352h512V400z"],
    "c": [384, 512, [99], "43", "M222.1 480c-138.3 0-222.1-116.4-222.1-223.1C.096 149.6 83.17 32 222.1 32C309.5 32 384 89.73 384 108.9c0 4.39-3.476 15.1-15.98 15.1C350.2 124.9 318.5 64 222.1 64C103.8 64 31.96 163.6 31.96 256c0 92.74 72.66 192 190.2 192c96.54 0 128.2-60.89 145.9-60.89C380.4 387.1 384 398.4 384 403.1C384 422.1 310.3 480 222.1 480z"],
    "cabin": [576, 512, [], "e46d", "M240 144C240 117.5 261.5 96 288 96C314.5 96 336 117.5 336 144C336 170.5 314.5 192 288 192C261.5 192 240 170.5 240 144zM288 128C279.2 128 272 135.2 272 144C272 152.8 279.2 160 288 160C296.8 160 304 152.8 304 144C304 135.2 296.8 128 288 128zM269.5 9.442C280.6 1.633 295.4 1.633 306.5 9.442L384 64.18V56C384 42.75 394.7 32 408 32H488C501.3 32 512 42.75 512 56V154.5L560.3 188.6C570.2 195.6 576 206.9 576 218.9C576 239.4 559.4 256 538.9 256H511.2C511.7 258.6 512 261.3 512 264V280C512 289 509 297.3 504 304C509 310.7 512 318.1 512 328V344C512 353 509 361.3 504 368C509 374.7 512 382.1 512 392V408C512 417 509 425.3 504 432C509 438.7 512 446.1 512 456V472C512 494.1 494.1 512 472 512H392C369.9 512 352 494.1 352 472V456C352 446.1 354.1 438.7 359.1 432C354.1 425.3 352 417 352 408V392C352 382.1 354.1 374.7 359.1 368C354.1 361.3 352 353 352 344V328C352 318.1 354.1 310.7 359.1 304C354.1 297.3 352 289 352 280V264C352 261.3 352.3 258.6 352.8 256H223.2C223.7 258.6 224 261.3 224 264V280C224 289 221 297.3 216 304C221 310.7 224 318.1 224 328V344C224 353 221 361.3 216 368C221 374.7 224 382.1 224 392V408C224 417 221 425.3 216 432C221 438.7 224 446.1 224 456V472C224 494.1 206.1 512 184 512H104C81.91 512 64 494.1 64 472V456C64 446.1 66.98 438.7 71.1 432C66.98 425.3 64 417 64 408V392C64 382.1 66.98 374.7 71.1 368C66.98 361.3 64 353 64 344V328C64 318.1 66.98 310.7 71.1 304C66.98 297.3 64 289 64 280V264C64 261.3 64.28 258.6 64.8 256H37.08C16.6 256 0 239.4 0 218.9C0 206.9 5.853 195.6 15.7 188.6L269.5 9.442zM392 416H472C476.4 416 480 412.4 480 408V392C480 387.6 476.4 384 472 384H392C387.6 384 384 387.6 384 392V408C384 412.4 387.6 416 392 416zM472 448H392C387.6 448 384 451.6 384 456V472C384 476.4 387.6 480 392 480H472C476.4 480 480 476.4 480 472V456C480 451.6 476.4 448 472 448zM480 328C480 323.6 476.4 320 472 320H392C387.6 320 384 323.6 384 328V344C384 348.4 387.6 352 392 352H472C476.4 352 480 348.4 480 344V328zM538.9 224C541.7 224 544 221.7 544 218.9C544 217.3 543.2 215.7 541.9 214.8L288 35.59L34.15 214.8C32.8 215.7 32 217.3 32 218.9C32 221.7 34.27 224 37.08 224L538.9 224zM392 256C387.6 256 384 259.6 384 264V280C384 284.4 387.6 288 392 288H472C476.4 288 480 284.4 480 280V264C480 259.6 476.4 256 472 256H392zM104 416H184C188.4 416 192 412.4 192 408V392C192 387.6 188.4 384 184 384H104C99.58 384 96 387.6 96 392V408C96 412.4 99.58 416 104 416zM184 448H104C99.58 448 96 451.6 96 456V472C96 476.4 99.58 480 104 480H184C188.4 480 192 476.4 192 472V456C192 451.6 188.4 448 184 448zM192 328C192 323.6 188.4 320 184 320H104C99.58 320 96 323.6 96 328V344C96 348.4 99.58 352 104 352H184C188.4 352 192 348.4 192 344V328zM104 256C99.58 256 96 259.6 96 264V280C96 284.4 99.58 288 104 288H184C188.4 288 192 284.4 192 280V264C192 259.6 188.4 256 184 256H104zM480 131.9V64H416V86.77L480 131.9z"],
    "cabinet-filing": [448, 512, [128452], "f64b", "M384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V272h384V448zM416 240H32V64c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V240zM304 96h-160C135.2 96 128 103.2 128 112v32C128 152.8 135.2 160 144 160S160 152.8 160 144V128h128v16C288 152.8 295.2 160 304 160S320 152.8 320 144v-32C320 103.2 312.8 96 304 96zM144 416C152.8 416 160 408.8 160 400V384h128v16c0 8.844 7.156 16 16 16s16-7.156 16-16v-32c0-8.844-7.156-16-16-16h-160C135.2 352 128 359.2 128 368v32C128 408.8 135.2 416 144 416z"],
    "cable-car": [512, 512, [], "e0cf", "M264 24C264 10.75 274.7 0 288 0C301.3 0 312 10.75 312 24C312 37.25 301.3 48 288 48C274.7 48 264 37.25 264 24zM216 56C216 69.25 205.3 80 192 80C178.7 80 168 69.25 168 56C168 42.75 178.7 32 192 32C205.3 32 216 42.75 216 56zM480 288V448C480 483.3 451.3 512 416 512H96C60.65 512 32 483.3 32 448V288C32 252.7 60.65 224 96 224H240V147.5L19.14 191.7C10.47 193.4 2.044 187.8 .311 179.1C-1.422 170.5 4.197 162 12.86 160.3L492.9 64.31C501.5 62.58 509.1 68.2 511.7 76.86C513.4 85.53 507.8 93.96 499.1 95.69L272 141.1V224H416C451.3 224 480 252.7 480 288V288zM320 256H192V352H320V256zM352 256V352H448V288C448 270.3 433.7 256 416 256H352zM448 384H64V448C64 465.7 78.33 480 96 480H416C433.7 480 448 465.7 448 448V384zM64 352H160V256H96C78.33 256 64 270.3 64 288V352z"],
    "cactus": [512, 512, [127797], "f8a7", "M272 352c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1s16-7.125 16-15.1S280.9 352 272 352zM492.1 221.3c-12.62-10.62-29.38-15.25-45.63-12.5C419 213.4 400 239.3 400 267.1V296c0 4.375-3.625 8-8 8H352V101.4c0-51.1-38.88-98.5-90.88-101.2C234.9-1.245 209.1 8.256 189.1 26.38C170.9 44.51 160 69.63 160 96v96H120c-4.375 0-8-3.625-8-8V155.1c0-27.88-19-53.75-46.5-58.38c-16.25-2.75-33 1.875-45.63 12.5S0 135.5 0 152v32c0 66.25 53.75 119.1 120 119.1L160 304V496C160 504.9 167.1 512 176 512h160c8.875 0 16-7.125 16-16v-79.1l40 .0004c66.25 0 120-53.75 120-120v-32C512 247.5 504.8 231.9 492.1 221.3zM160 272H120c-48.63 0-88-39.37-88-87.1v-32c0-13.25 10.75-24 24-24s24 10.75 24 24v32c0 22.12 17.88 40 40 40L160 224V272zM320 480H192V96c0-35.37 28.62-63.1 64-63.1s64 28.62 64 63.1V480zM480 296c0 48.63-39.38 88-88 88H352v-47.1l40 0c22.12 0 40-17.88 40-40v-32c0-13.25 10.75-23.1 24-23.1S480 250.8 480 264V296zM240 128c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S256 152.9 256 144S248.9 128 240 128z"],
    "cake-candles": [448, 512, [127874, "birthday-cake", "cake"], "f1fd", "M352 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C356.7 .9458 354.4 0 352 0s-4.719 .9458-6.25 2.836C341.5 8.166 304 55.65 304 79.86C304 106.3 325.5 127.9 352 127.9zM352 48.7C361.4 63.14 367.4 75.11 368 79.86c0 8.83-7.178 16.02-16 16.02s-16-7.186-16.02-15.49C336.6 75.29 342.6 63.18 352 48.7zM224 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C228.7 .9458 226.4 0 224 0S219.3 .9458 217.8 2.836C213.5 8.166 176 55.65 176 79.86C176 106.3 197.5 127.9 224 127.9zM224 48.7C233.4 63.14 239.4 75.11 240 79.86c0 8.83-7.178 16.02-16 16.02S208 88.69 207.1 80.38C208.6 75.29 214.6 63.18 224 48.7zM96 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C100.7 .9458 98.36 0 96 0S91.28 .9458 89.75 2.836C85.48 8.166 48 55.65 48 79.86C48 106.3 69.53 127.9 96 127.9zM96.01 48.7C105.4 63.14 111.4 75.11 112 79.86c0 8.83-7.178 16.02-16 16.02S80 88.69 79.98 80.38C80.55 75.29 86.59 63.18 96.01 48.7zM383.1 223.1L368 223.9V176c0-8.844-7.156-16.06-16-16.06S336 167.2 336 176v47.91h-96V176c0-8.844-7.156-16.06-16-16.06S208 167.2 208 176v47.91h-96V176c0-8.844-7.156-16.06-16-16.06S80 167.2 80 176v47.91L64 223.1c-35.35 0-64 28.65-64 63.1V464C0 490.5 21.49 512 48 512h352c26.51 0 48-21.49 48-48V287.1C448 252.6 419.4 223.1 383.1 223.1zM416 464c0 8.822-7.178 16-16 16h-352C39.18 480 32 472.8 32 464v-64.01c25.97 0 50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66s50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66s50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66V464zM416 367.1c-20.64 0-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C333 348.3 308.6 367.1 288 367.1s-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C205 348.3 180.6 367.1 160 367.1s-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C77.05 348.3 52.64 367.1 32 367.1V287.9c0-17.64 14.36-32 32-32h16V272c0 8.844 7.156 15.96 16 15.96S112 280.8 112 272V255.9h96V272c0 8.844 7.156 15.96 16 15.96S240 280.8 240 272V255.9h96V272c0 8.844 7.156 15.96 16 15.96S368 280.8 368 272V255.9h15.98C401.6 255.9 416 270.3 416 287.9V367.1z"],
    "cake-slice": [512, 512, [127856, "shortcake"], "e3e5", "M450.6 101.7C490 143.4 512 198.6 512 256V416C511.9 432.1 505.2 449.2 493.2 461.2C481.2 473.2 464.1 479.9 448 480H64C47.04 479.9 30.79 473.2 18.8 461.2C6.81 449.2 .0506 432.1 0 416V271.6C.0064 266.8 1.122 261.1 3.262 257.6C5.403 253.2 8.511 249.4 12.35 246.4L278.8 39.01C284.5 34.45 291.5 31.97 298.8 32H299.9C357.2 35.11 411.1 60.07 450.6 101.7zM480 384H32V416C32 424.5 35.37 432.6 41.37 438.6C47.37 444.6 55.51 448 64 448H448C456.5 448 464.6 444.6 470.6 438.6C476.6 432.6 480 424.5 480 416V384zM480 288H32V352H480V288zM480 256C480.1 206.9 461.3 159.6 427.6 123.9C393.9 88.18 347.8 66.74 298.7 64L52.06 256H480z"],
    "calculator": [384, 512, [128425], "f1ec", "M320 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h256c35.34 0 64-28.66 64-64V64C384 28.66 355.3 0 320 0zM352 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h320V448zM352 128H32V64c0-17.64 14.36-32 32-32h256c17.64 0 32 14.36 32 32V128zM80 432h128c8.844 0 16-7.156 16-16s-7.156-16-16-16h-128C71.16 400 64 407.2 64 416S71.16 432 80 432zM288 440c13.25 0 24-10.75 24-24s-10.75-24-24-24s-24 10.75-24 24S274.7 440 288 440zM288 344c13.25 0 24-10.75 24-24S301.3 296 288 296S264 306.7 264 320S274.7 344 288 344zM288 248c13.25 0 24-10.75 24-24S301.3 200 288 200S264 210.7 264 224S274.7 248 288 248zM192 344c13.25 0 24-10.75 24-24S205.3 296 192 296S168 306.7 168 320S178.7 344 192 344zM192 248c13.25 0 24-10.75 24-24S205.3 200 192 200S168 210.7 168 224S178.7 248 192 248zM96 344c13.25 0 24-10.75 24-24S109.3 296 96 296S72 306.7 72 320S82.75 344 96 344zM96 248c13.25 0 24-10.75 24-24S109.3 200 96 200S72 210.7 72 224S82.75 248 96 248z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M336 128H384v48c0 8.844 7.156 16.04 16 16.04S416 184.8 416 176V128h48C472.8 128 480 120.9 480 112S472.8 96 464 96H416V48c0-8.844-7.156-15.96-16-15.96S384 39.16 384 48V96h-48C327.2 96 320 103.2 320 112S327.2 128 336 128zM168.6 343.4c-6.254-6.254-16.37-6.254-22.63 0L112 377.4l-33.94-33.94c-6.254-6.254-16.37-6.254-22.63 0s-6.254 16.37 0 22.63L89.37 400l-33.94 33.94c-6.254 6.254-6.254 16.37 0 22.63s16.37 6.254 22.63 0L112 422.6l33.94 33.94c6.254 6.254 16.37 6.254 22.63 0s6.254-16.37 0-22.63L134.6 400l33.94-33.94C174.8 359.8 174.8 349.7 168.6 343.4zM48 128h128C184.8 128 192 120.8 192 112S184.8 96 176 96h-128C39.16 96 32 103.2 32 112S39.16 128 48 128zM496 240h-224v-224C272 7.156 264.8 0 256 0S240 7.156 240 16v224h-224C7.156 240 0 247.2 0 256s7.156 16 16 16h224v224c0 8.844 7.156 16 16 16s16-7.156 16-16v-224h224C504.8 272 512 264.8 512 256S504.8 240 496 240zM464 416h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S472.8 416 464 416zM464 352h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S472.8 352 464 352z"],
    "calendar": [448, 512, [128198, 128197], "f133", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M240 377.4L292.7 324.7C298.9 318.4 309.1 318.4 315.3 324.7C321.6 330.9 321.6 341.1 315.3 347.3L235.3 427.3C229.1 433.6 218.9 433.6 212.7 427.3L132.7 347.3C126.4 341.1 126.4 330.9 132.7 324.7C138.9 318.4 149.1 318.4 155.3 324.7L208 377.4V256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256L240 377.4zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M208 294.6L155.3 347.3C149.1 353.6 138.9 353.6 132.7 347.3C126.4 341.1 126.4 330.9 132.7 324.7L212.7 244.7C218.9 238.4 229.1 238.4 235.3 244.7L315.3 324.7C321.6 330.9 321.6 341.1 315.3 347.3C309.1 353.6 298.9 353.6 292.7 347.3L240 294.6V416C240 424.8 232.8 432 223.1 432C215.2 432 207.1 424.8 207.1 416L208 294.6zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-check": [448, 512, [], "f274", "M219.3 395.3C213.1 401.6 202.9 401.6 196.7 395.3L132.7 331.3C126.4 325.1 126.4 314.9 132.7 308.7C138.9 302.4 149.1 302.4 155.3 308.7L208 361.4L308.7 260.7C314.9 254.4 325.1 254.4 331.3 260.7C337.6 266.9 337.6 277.1 331.3 283.3L219.3 395.3zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H296.2C306.3 492.1 317.9 502.9 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96zM448 432C448 440.8 440.8 448 432 448C423.2 448 416 440.8 416 432C416 423.2 423.2 416 432 416C440.8 416 448 423.2 448 432zM447.1 384C447.1 392.8 440.8 400 431.1 400C423.2 400 415.1 392.8 415.1 384V304C415.1 295.2 423.2 288 431.1 288C440.8 288 447.1 295.2 447.1 304V384zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H296.2C306.3 492.1 317.9 502.9 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96zM368 383.1C359.2 383.1 352 376.8 352 367.1C352 359.2 359.2 351.1 368 351.1H496C504.8 351.1 512 359.2 512 367.1C512 376.8 504.8 383.1 496 383.1H368zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256z"],
    "calendar-circle-plus": [576, 512, [], "e470", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H296.2C306.3 492.1 317.9 502.9 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96zM432 287.1C440.8 287.1 448 295.2 448 303.1V351.1H496C504.8 351.1 512 359.2 512 367.1C512 376.8 504.8 383.1 496 383.1H448V431.1C448 440.8 440.8 447.1 432 447.1C423.2 447.1 416 440.8 416 431.1V383.1H368C359.2 383.1 352 376.8 352 367.1C352 359.2 359.2 351.1 368 351.1H416V303.1C416 295.2 423.2 287.1 432 287.1zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480z"],
    "calendar-circle-user": [576, 512, [], "e471", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H296.2C306.3 492.1 317.9 502.9 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96zM488 344C488 374.9 462.9 400 432 400C401.1 400 376 374.9 376 344C376 313.1 401.1 288 432 288C462.9 288 488 313.1 488 344zM432 320C418.7 320 408 330.7 408 344C408 357.3 418.7 368 432 368C445.3 368 456 357.3 456 344C456 330.7 445.3 320 432 320zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 480C454.1 480 474.7 473.6 491.1 462.6C484.1 453.5 472.6 448 460.2 448H403.8C391.4 448 379.9 453.5 372 462.6C389.3 473.6 409.9 480 432 480H432zM460.2 416C482.1 416 502.4 425.6 516.3 441.8C533.5 422.1 544 396.2 544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 396.2 330.5 422.1 347.7 441.8C361.6 425.6 381.9 416 403.8 416H460.2z"],
    "calendar-clock": [576, 512, ["calendar-time"], "e0d2", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192.7C442.7 192.2 437.4 192 432 192C426.6 192 421.3 192.2 416 192.7V192H32V448C32 465.7 46.33 480 64 480H296.2C306.3 492.1 317.9 502.9 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96zM431.1 288C440.8 288 447.1 295.2 447.1 304V352H480C488.8 352 496 359.2 496 368C496 376.8 488.8 384 480 384H431.1C423.2 384 415.1 376.8 415.1 368V304C415.1 295.2 423.2 288 431.1 288V288zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480z"],
    "calendar-day": [448, 512, [], "f783", "M64 264C64 241.9 81.91 224 104 224H184C206.1 224 224 241.9 224 264V344C224 366.1 206.1 384 184 384H104C81.91 384 64 366.1 64 344V264zM96 264V344C96 348.4 99.58 352 104 352H184C188.4 352 192 348.4 192 344V264C192 259.6 188.4 256 184 256H104C99.58 256 96 259.6 96 264zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H312V264H416V192zM416 296H312V376H416V296zM416 408H312V480H384C401.7 480 416 465.7 416 448V408zM280 376V296H168V376H280zM168 480H280V408H168V480zM136 376V296H32V376H136zM32 408V448C32 465.7 46.33 480 64 480H136V408H32zM32 264H136V192H32V264zM168 264H280V192H168V264zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-exclamation": [448, 512, [], "f334", "M248 416C248 429.3 237.3 440 224 440C210.7 440 200 429.3 200 416C200 402.7 210.7 392 224 392C237.3 392 248 402.7 248 416zM240 352C240 360.8 232.8 368 224 368C215.2 368 208 360.8 208 352V256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256V352zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-heart": [448, 512, [], "e0d3", "M224 263.9L231.6 256.1C256.6 230.3 298 230.3 323.1 256.1C347.2 280.9 347.2 320.3 323.1 345L246.9 423.4C234.4 436.3 213.6 436.3 201.1 423.4L124.9 345C100.8 320.3 100.8 280.9 124.9 256.1C149.1 230.3 191.4 230.3 216.4 256.1L224 263.9zM147.9 322.7L224 401L300.1 322.7C312.1 310.4 312.1 290.7 300.1 278.4C287.6 265.6 267 265.6 254.5 278.4L224 309.8L193.5 278.4C180.1 265.6 160.4 265.6 147.9 278.4C135.9 290.7 135.9 310.4 147.9 322.7zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-image": [448, 512, [], "e0d4", "M230 265.4C242.6 247.3 269.2 246.1 282.2 264.8L378.5 397.2C393.8 418.3 378.7 448 352.6 448H95.09C69.06 448 53.92 418.6 69.05 397.4L120 326.1C131.5 309.1 154.7 308.1 168.7 322L181.8 335.1L230 265.4zM352.6 416L256.3 283.6L197.2 369.1C194.5 373 190.2 375.5 185.4 375.9C180.7 376.4 176 374.7 172.7 371.3L146 344.7L95.09 416H352.6zM72 256C72 242.7 82.75 232 96 232C109.3 232 120 242.7 120 256C120 269.3 109.3 280 96 280C82.75 280 72 269.3 72 256zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-lines": [448, 512, ["calendar-note"], "e0d5", "M96 368C96 359.2 103.2 352 112 352H240C248.8 352 256 359.2 256 368C256 376.8 248.8 384 240 384H112C103.2 384 96 376.8 96 368zM336 256C344.8 256 352 263.2 352 272C352 280.8 344.8 288 336 288H112C103.2 288 96 280.8 96 272C96 263.2 103.2 256 112 256H336zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-lines-pen": [576, 512, [], "e472", "M128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H258.5L257.4 484.2C255.1 493.6 255.7 503.2 258.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128zM240 352C248.8 352 256 359.2 256 368C256 376.8 248.8 384 240 384H112C103.2 384 96 376.8 96 368C96 359.2 103.2 352 112 352H240zM96 272C96 263.2 103.2 256 112 256H336C344.8 256 352 263.2 352 272C352 280.8 344.8 288 336 288H112C103.2 288 96 280.8 96 272zM473.5 241.4C492.3 222.6 522.7 222.6 541.4 241.4L558.8 258.7C577.5 277.5 577.5 307.9 558.8 326.6L405.1 480.3C398.9 486.5 391.2 490.8 382.8 492.1L307.9 511.7C302.4 513 296.7 511.4 292.7 507.5C288.7 503.5 287.1 497.7 288.5 492.3L307.2 417.4C309.3 408.9 313.7 401.2 319.8 395.1L473.5 241.4zM518.8 264C512.5 257.8 502.4 257.8 496.2 264L471.3 288.8L511.3 328.8L536.2 303.1C542.4 297.7 542.4 287.6 536.2 281.4L518.8 264zM338.2 425.1L325.1 474.2L375 461.9C377.8 461.2 380.4 459.8 382.4 457.7L488.7 351.4L448.7 311.5L342.5 417.7C340.4 419.8 338.9 422.3 338.2 425.1H338.2z"],
    "calendar-minus": [448, 512, [], "f272", "M144 352C135.2 352 128 344.8 128 336C128 327.2 135.2 320 144 320H304C312.8 320 320 327.2 320 336C320 344.8 312.8 352 304 352H144zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-pen": [448, 512, ["calendar-edit"], "f333", "M250.4 235.3C269.1 216.6 299.5 216.6 318.2 235.3L324.7 241.8C343.4 260.5 343.4 290.9 324.7 309.6L201.6 432.7C197.4 436.9 192 439.9 186.2 441.2L136 452.7C118.8 456.7 103.3 441.2 107.3 423.1L118.8 373.8C120.1 367.1 123.1 362.6 127.3 358.4L250.4 235.3zM295.6 257.9C289.4 251.7 279.2 251.7 272.1 257.9L260.8 270.2L289.8 299.2L302.1 287C308.3 280.8 308.3 270.6 302.1 264.4L295.6 257.9zM267.2 321.8L238.2 292.8L149.1 380.1L141.3 418.7L179 410L267.2 321.8zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-plus": [448, 512, [], "f271", "M320 336C320 344.8 312.8 352 304 352H240V416C240 424.8 232.8 432 224 432C215.2 432 208 424.8 208 416V352H144C135.2 352 128 344.8 128 336C128 327.2 135.2 320 144 320H208V256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256V320H304C312.8 320 320 327.2 320 336zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-range": [448, 512, [], "e0d6", "M384 272C384 280.8 376.8 288 368 288H208C199.2 288 192 280.8 192 272C192 263.2 199.2 256 208 256H368C376.8 256 384 263.2 384 272zM80 416C71.16 416 64 408.8 64 400C64 391.2 71.16 384 80 384H240C248.8 384 256 391.2 256 400C256 408.8 248.8 416 240 416H80zM160 272C160 298.5 138.5 320 112 320C85.49 320 64 298.5 64 272C64 245.5 85.49 224 112 224C138.5 224 160 245.5 160 272zM96 272C96 280.8 103.2 288 112 288C120.8 288 128 280.8 128 272C128 263.2 120.8 256 112 256C103.2 256 96 263.2 96 272zM288 400C288 373.5 309.5 352 336 352C362.5 352 384 373.5 384 400C384 426.5 362.5 448 336 448C309.5 448 288 426.5 288 400zM352 400C352 391.2 344.8 384 336 384C327.2 384 320 391.2 320 400C320 408.8 327.2 416 336 416C344.8 416 352 408.8 352 400zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"],
    "calendar-star": [448, 512, [], "f736", "M267.5 276.1L316.8 283.2C336.5 286.1 344.3 310.3 330.1 324.2L294.5 358.9L302.9 407.9C306.2 427.5 285.6 442.5 268 433.2L223.1 410.1L179.1 433.2C162.4 442.5 141.8 427.5 145.1 407.9L153.5 358.9L117.9 324.2C103.7 310.3 111.5 286.1 131.2 283.2L180.5 276.1L202.5 231.5C211.3 213.6 236.7 213.6 245.5 231.5L267.5 276.1zM201.7 305.3L151.9 312.6L187.9 347.7L179.4 397.4L223.1 373.9L268.6 397.4L260.1 347.7L296.1 312.6L246.3 305.3L223.1 260.2L201.7 305.3zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-week": [448, 512, [], "f784", "M64 264C64 241.9 81.91 224 104 224H344C366.1 224 384 241.9 384 264V344C384 366.1 366.1 384 344 384H104C81.91 384 64 366.1 64 344V264zM96 264V344C96 348.4 99.58 352 104 352H344C348.4 352 352 348.4 352 344V264C352 259.6 348.4 256 344 256H104C99.58 256 96 259.6 96 264zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M246.6 336L299.3 388.7C305.6 394.9 305.6 405.1 299.3 411.3C293.1 417.6 282.9 417.6 276.7 411.3L224 358.6L171.3 411.3C165.1 417.6 154.9 417.6 148.7 411.3C142.4 405.1 142.4 394.9 148.7 388.7L201.4 336L148.7 283.3C142.4 277.1 142.4 266.9 148.7 260.7C154.9 254.4 165.1 254.4 171.3 260.7L224 313.4L276.7 260.7C282.9 254.4 293.1 254.4 299.3 260.7C305.6 266.9 305.6 277.1 299.3 283.3L246.6 336zM128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192H32V448zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128z"],
    "calendars": [512, 512, [], "e0d7", "M208 0C216.8 0 224 7.164 224 16V64H384V16C384 7.164 391.2 0 400 0C408.8 0 416 7.164 416 16V64H448C483.3 64 512 92.65 512 128V352C512 387.3 483.3 416 448 416H160C124.7 416 96 387.3 96 352V128C96 92.65 124.7 64 160 64H192V16C192 7.164 199.2 0 208 0zM128 128V160H480V128C480 110.3 465.7 96 448 96H160C142.3 96 128 110.3 128 128zM128 192V352C128 369.7 142.3 384 160 384H448C465.7 384 480 369.7 480 352V192H128zM32 384C32 437 74.98 480 128 480H368C376.8 480 384 487.2 384 496C384 504.8 376.8 512 368 512H128C57.31 512 0 454.7 0 384V208C0 199.2 7.164 192 16 192C24.84 192 32 199.2 32 208V384z"],
    "camcorder": [576, 512, [128249, "video-handheld"], "f8a8", "M304 223.1h-224c-8.844 0-16 7.156-16 16c0 8.842 7.156 15.1 16 15.1h224c8.844 0 16-7.158 16-15.1C320 231.2 312.8 223.1 304 223.1zM558.8 163.7c-10.59-5.484-23.35-4.74-33.13 2.12l-102.8 72.02c-7.25 5.062-9 15.05-3.938 22.28c5.062 7.25 15.02 8.984 22.28 3.938l102.8-71.97v255.9l-102.8-71.97c-7.266-5.047-17.22-3.312-22.28 3.938c-5.062 7.234-3.312 17.22 3.938 22.28l102.8 72C531.1 478.1 537.5 480 543.1 480c5.047 0 10.12-1.203 14.78-3.625c10.64-5.531 17.23-16.41 17.23-28.39V192C576 180.1 569.4 169.2 558.8 163.7zM320 159.1H96V111.1C96 85.53 117.5 63.1 144 63.1h160c8.844 0 16-7.156 16-16C320 39.16 312.8 32 304 32h-160C99.88 32 64 67.89 64 111.1l.0003 48c-35.35 0-64 28.66-64 64l-.0001 191.1c0 35.34 28.65 63.1 64 63.1l256-.0016c35.35 0 64-28.66 64-63.1V223.1C384 188.7 355.3 159.1 320 159.1zM352 415.1c0 17.64-14.36 31.1-32 31.1H64c-17.64 0-32-14.35-32-31.1V223.1c0-17.64 14.36-31.1 32-31.1h256c17.64 0 32 14.36 32 31.1V415.1z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M144 288C144 226.1 194.1 176 256 176C317.9 176 368 226.1 368 288C368 349.9 317.9 400 256 400C194.1 400 144 349.9 144 288zM256 208C211.8 208 176 243.8 176 288C176 332.2 211.8 368 256 368C300.2 368 336 332.2 336 288C336 243.8 300.2 208 256 208zM362.9 64.82L373.3 96H448C483.3 96 512 124.7 512 160V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V160C0 124.7 28.65 96 64 96H138.7L149.1 64.82C155.6 45.22 173.9 32 194.6 32H317.4C338.1 32 356.4 45.22 362.9 64.82H362.9zM64 128C46.33 128 32 142.3 32 160V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V160C480 142.3 465.7 128 448 128H350.3L332.6 74.94C330.4 68.41 324.3 64 317.4 64H194.6C187.7 64 181.6 68.41 179.4 74.94L161.7 128H64z"],
    "camera-cctv": [576, 512, ["cctv"], "f8ac", "M525.2 193.7c-1.238-16.59-12.17-31.34-28.48-37.77L150.3 3.617C143.9 1.076 138.4 0 132.8 0C113.7 0 99.74 12.27 93.61 22.78L6.082 176.1c-6.574 11.43-7.76 25.88-3.121 38.56c4.576 12.51 14.17 21.96 27.01 26.62l158.7 65.68l-39.77 109.1H32v-47.98c0-8.797-7.2-16.02-16-16.02C7.201 352 0 359.2 0 368v127.1C0 504.8 7.201 512 15.1 512C24.8 512 32 504.8 32 496v-47.98h128c6.625 0 12.62-4.123 15-10.37l43.23-118.4l71.9 29.76c4.391 1.822 10.23 3.072 16.21 3.072c8.779 0 17.31-2.543 24.67-7.354l173.2-108.1C518.1 227 526.9 210.7 525.2 193.7zM487.3 209.5L313.5 317.9c-2.426 1.586-6.576 3.016-11.12 1.5L40.88 211.2c-10-3.625-9.875-14.25-7-19.24l87.38-153.1c1.52-2.604 7.732-9.354 16.12-5.998L485 185.7C495.5 189.9 496.2 203.7 487.3 209.5zM566.6 274.9l-47.91-21.69c-8.1-3.688-17.54-.0625-21.2 7.969c-3.643 8.031-.0781 17.53 7.975 21.16l33.38 15.12l-28.74 64.09l-87.66-38.56c-8.131-3.5-17.54 .125-21.09 8.219c-3.564 8.094 .1113 17.53 8.209 21.09l102.1 44.92c2.094 .9062 4.403 1.364 6.546 1.364c6.129 0 11.96-3.531 14.62-9.469l41.79-93.14C578.2 287.1 574.6 278.6 566.6 274.9z"],
    "camera-movie": [576, 512, [127910, 127909], "f8a9", "M320 255.1L127.1 255.1c-.0332 0 .0332 0 0 0L16 256C7.164 256 0 263.2 0 272C0 280.8 7.164 288 16 288h56.87C67.38 297.4 64 308.3 64 319.1l.0002 128c0 35.34 28.65 63.1 64 63.1L320 511.1c35.35 0 64-28.65 64-63.1V319.1C384 284.6 355.3 255.1 320 255.1zM352 447.1c0 17.64-14.36 31.1-32 31.1H128c-17.64 0-32-14.35-32-31.1V319.1C96 302.4 110.3 288 127.9 288l48.09-.0059c.0215 0-.0215 0 0 0L320 287.1c17.64 0 32 14.36 32 31.1V447.1zM336 0c-41 0-76.48 22.27-96 55.14C220.5 22.27 185 0 144 0C82.14 0 32 50.14 32 112S82.14 224 144 224h192C397.9 224 448 173.9 448 112S397.9 0 336 0zM336 192h-192C99.89 192 64 156.1 64 112C64 67.89 99.89 32 144 32c28.21 0 53.81 14.76 68.48 39.48C218.3 81.19 228.7 87.14 240 87.14s21.75-5.953 27.52-15.66C282.2 46.76 307.8 32 336 32C380.1 32 416 67.89 416 112C416 156.1 380.1 192 336 192zM553.3 266.1c-14.28-8.844-31.73-9.656-46.72-2.125l-81.69 40.84c-7.906 3.969-11.11 13.56-7.156 21.47c3.953 7.875 13.59 11.12 21.47 7.156l81.67-40.84c7.203-3.625 13.28-.6875 15.59 .7187C538.7 295.6 544 299.8 544 307.8v152.4c0 8.031-5.297 12.19-7.578 13.59c-2.312 1.406-8.406 4.312-15.58 .7187l-81.69-40.84c-7.875-3.969-17.52-.7187-21.47 7.156c-3.953 7.906-.75 17.5 7.156 21.47l81.7 40.84c6.828 3.406 14.16 5.094 21.47 5.094c8.75 0 17.47-2.406 25.23-7.219C567.5 492.2 576 476.1 576 460.2V307.8C576 291 567.5 275.8 553.3 266.1zM144 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C168 98.74 157.3 88 144 88zM336 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C360 98.74 349.3 88 336 88z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M288 112c-44.11 0-80 35.88-80 80s35.89 80 80 80s80-35.88 80-80S332.1 112 288 112zM288 240C261.5 240 240 218.5 240 192S261.5 144 288 144s48 21.53 48 48S314.5 240 288 240zM561.1 318.5L512 256L512 96c0-35.35-28.65-64-64-64H128C92.65 32 64 60.65 64 96l.0001 160L14.03 318.5C4.947 329.8 0 343.9 0 358.5V416c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64v-57.55C576 343.9 571.1 329.8 561.1 318.5zM96 267.2V96c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32v171.2L522.2 320H53.78L96 267.2zM544 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32v-63.86l511.9-.0713c.0566 .0547-.0547-.0566 0 0L544 416zM464 384h-352C103.2 384 96 391.2 96 400C96 408.8 103.2 416 112 416h352c8.838 0 16-7.164 16-16C480 391.2 472.8 384 464 384zM416 104c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C440 114.7 429.3 104 416 104z"],
    "camera-retro": [512, 512, [128247], "f083", "M0 416V144C0 108.7 28.65 80 64 80H192L238.9 44.8C250 36.49 263.5 32 277.3 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416zM64 112C46.33 112 32 126.3 32 144V224H145.1C167.3 185.7 208.6 160 256 160C303.4 160 344.7 185.7 366.9 224H480V96C480 78.33 465.7 64 448 64H277.3C270.4 64 263.7 66.25 258.1 70.4L211.2 105.6C205.7 109.8 198.9 112 192 112H64zM32 256V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V256H379.1C382.6 266.2 384 276.1 384 288C384 358.7 326.7 416 256 416C185.3 416 128 358.7 128 288C128 276.1 129.4 266.2 132 256H32zM256 192C202.1 192 160 234.1 160 288C160 341 202.1 384 256 384C309 384 352 341 352 288C352 234.1 309 192 256 192zM64 48C64 39.16 71.16 32 80 32H144C152.8 32 160 39.16 160 48C160 56.84 152.8 64 144 64H80C71.16 64 64 56.84 64 48z"],
    "camera-rotate": [512, 512, [], "e0d8", "M352 176c-8.844 0-16 7.156-16 16v25.72C315.7 194.6 287.1 181 256 181c-33.16 0-63.91 15-84.34 41.14C166.2 229.1 167.5 239.2 174.4 244.6C181.4 250 191.4 248.8 196.9 241.9C224.1 205.9 283.9 205.4 313.3 240H288c-8.844 0-16 7.156-16 16s7.156 16 16 16h64c8.844 0 16-7.156 16-16V192C368 183.2 360.8 176 352 176zM315.1 334.1C287 370.1 228.1 370.6 198.8 336H224c8.844 0 16-7.156 16-16S232.8 304 224 304H160c-8.844 0-16 7.156-16 16v64c0 8.844 7.156 16 16 16s16-7.156 16-16v-25.72C196.3 381.4 224.9 395 256 395c33.16 0 63.91-15 84.34-41.14c5.438-6.969 4.203-17.03-2.75-22.47C330.6 325.9 320.6 327.2 315.1 334.1zM448 96h-72l-8.457-22.51C358.2 48.55 334.3 32 307.6 32H204.4C177.7 32 153.9 48.51 144.5 73.45L136 96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32V160c0-17.6 14.4-32 32-32h94.25l16.11-43.18C179 72.3 190.1 64 204.3 64h103.3c13.36 0 25.31 8.301 29.98 20.82L353.8 128H448c17.6 0 32 14.4 32 32V416z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M384 0h-320c-35.35 0-64 28.65-64 64v288c0 35.35 28.65 64 64 64h43.7l-36.26 43.5c-8.031 9.656-9.719 22.72-4.391 34.09C72.38 504.9 83.48 512 96.03 512h255.9c12.55 0 23.66-7.062 28.98-18.41c5.328-11.38 3.641-24.44-4.391-34.09L340.3 416h43.7c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM351.1 480H96.03l53.35-64h149.2L351.1 480zM416 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V352zM224 80c-70.69 0-127.1 57.31-127.1 128c0 70.69 57.31 128 127.1 128c70.69 0 128-57.31 128-128C352 137.3 294.7 80 224 80zM224 304c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96C320 260.9 276.9 304 224 304z"],
    "camera-slash": [640, 512, [], "e0d9", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM459.9 448L500.4 480H128C92.65 480 64 451.3 64 416V160C64 152.4 65.32 145.1 67.74 138.4L96 160.7V416C96 433.7 110.3 448 128 448L459.9 448zM258.6 32H381.4C402.1 32 420.4 45.22 426.9 64.82L437.3 96H512C547.3 96 576 124.7 576 160V376.6L544 351.3V160C544 142.3 529.7 128 512 128H414.3L396.6 74.94C394.4 68.41 388.3 64 381.4 64H258.6C251.7 64 245.6 68.41 243.4 74.94L233.1 105.9L206.4 84.78L213.1 64.82C219.6 45.22 237.9 32 258.6 32H258.6zM208 288C208 275.9 209.9 264.3 213.4 253.4L241 275.2C240.3 279.4 240 283.6 240 288C240 332.2 275.8 368 320 368C330.9 368 341.3 365.8 350.8 361.9L378.4 383.6C361.4 394 341.4 400 320 400C258.1 400 208 349.9 208 288V288zM428.5 260.1L321.1 176C373.3 176.9 416.3 212.4 428.5 260.1z"],
    "camera-viewfinder": [512, 512, ["screenshot"], "e0da", "M0 48C0 21.49 21.49 0 48 0H144C152.8 0 160 7.164 160 16C160 24.84 152.8 32 144 32H48C39.16 32 32 39.16 32 48V144C32 152.8 24.84 160 16 160C7.164 160 0 152.8 0 144V48zM320 256C320 291.3 291.3 320 256 320C220.7 320 192 291.3 192 256C192 220.7 220.7 192 256 192C291.3 192 320 220.7 320 256zM256 224C238.3 224 224 238.3 224 256C224 273.7 238.3 288 256 288C273.7 288 288 273.7 288 256C288 238.3 273.7 224 256 224zM325.8 111.6L332 128H360C390.9 128 416 153.1 416 184V328C416 358.9 390.9 384 360 384H152C121.1 384 96 358.9 96 328V184C96 153.1 121.1 128 152 128H180L186.2 111.6C189.7 102.2 198.6 96 208.6 96H303.4C313.4 96 322.3 102.2 325.8 111.6zM152 160C138.7 160 128 170.7 128 184V328C128 341.3 138.7 352 152 352H360C373.3 352 384 341.3 384 328V184C384 170.7 373.3 160 360 160H309.8L297.8 128H214.2L202.2 160H152zM464 0C490.5 0 512 21.49 512 48V144C512 152.8 504.8 160 496 160C487.2 160 480 152.8 480 144V48C480 39.16 472.8 32 464 32H368C359.2 32 352 24.84 352 16C352 7.164 359.2 0 368 0H464zM0 368C0 359.2 7.164 352 16 352C24.84 352 32 359.2 32 368V464C32 472.8 39.16 480 48 480H144C152.8 480 160 487.2 160 496C160 504.8 152.8 512 144 512H48C21.49 512 0 490.5 0 464V368zM368 512C359.2 512 352 504.8 352 496C352 487.2 359.2 480 368 480H464C472.8 480 480 472.8 480 464V368C480 359.2 487.2 352 496 352C504.8 352 512 359.2 512 368V464C512 490.5 490.5 512 464 512H368z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M390.7 437.8C387.6 434.1 383.1 432 378.4 432c-13.57 0-20.99 15.83-12.3 26.26L384.2 480h-319.9l18.12-21.74C91.13 447.8 83.72 432 70.14 432c-4.75 0-9.256 2.109-12.3 5.758l-17.14 20.56c-7.895 9.471-10.71 22.65-5.932 34.02c5.082 12.07 16.33 19.66 29.33 19.66L382.7 512c12.34 0 24.27-6.303 29.92-17.27c5.992-11.63 4.469-25.25-3.832-35.23L390.7 437.8zM224 448c123.7 0 224-100.3 224-223.1c0-123.7-100.3-224-224-224c-123.7 0-224 100.3-224 224C0 347.7 100.3 448 224 448zM224 32c105.9 0 192 86.13 192 192s-86.13 192-192 192s-192-86.13-192-192S118.1 32 224 32zM224 368c79.41 0 144-64.59 144-144S303.4 80 224 80S80 144.6 80 224S144.6 368 224 368zM224 112c61.75 0 112 50.25 112 112s-50.25 112-112 112S112 285.8 112 224S162.3 112 224 112z"],
    "camera-web-slash": [640, 512, ["webcam-slash"], "f833", "M452.9 279.3C460 262.3 464 243.6 464 224c0-79.41-64.59-144-144-144c-31.59 0-60.59 10.53-84.35 27.84L262 128.7C278.1 118.3 298.7 112 320 112c61.75 0 112 50.25 112 112c0 12-2.395 23.35-5.906 34.2L452.9 279.3zM103.7 166.8C98.83 185.1 95.1 204.2 95.1 223.1c0 123.7 100.3 224 224 224c38.39 0 74.5-9.686 106.1-26.7l-27.96-22.08C374.2 409.9 347.8 416 320 416c-105.9 0-192-86.13-192-192c0-12.09 1.256-23.88 3.404-35.35L103.7 166.8zM320 32c105.9 0 192 86.13 192 192c0 30.87-7.5 59.97-20.5 85.84l25.76 20.33c17.04-31.6 26.74-67.75 26.74-106.2c0-123.7-100.3-223.1-223.1-223.1c-57.21 0-109.2 21.63-148.8 56.93l25.5 20.13C230.1 48.99 273.1 32 320 32zM320 368c11.47 0 22.5-1.693 33.2-4.24l-35.45-27.98c-50.89-1.029-93.21-36.15-105.7-83.43L176 223.9c0 .0449 0-.0449 0 0C176 303.3 240.6 368 320 368zM495.1 480H160.3l18.12-21.74c8.691-10.43 1.277-26.26-12.3-26.26c-4.75 0-9.256 2.109-12.3 5.758l-17.14 20.56c-7.201 8.639-10.41 20.42-6.998 31.13c4.379 13.74 16.39 22.54 30.4 22.54l335.9 .0145C504.9 512 512 504.8 512 496C512 487.2 504.8 480 495.1 480zM633.9 483.4L25.92 3.424c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480c2.938 2.312 6.438 3.438 9.906 3.438c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "campfire": [512, 512, [], "f6ba", "M256 320c79.5 0 144-64.5 144-144c0-33.25-33.38-102-80-144c-13.38 12-25.5 24.75-36.13 37.5C266.4 46 244.6 22.25 220 0c-63.13 57-108 131.3-108 176C112 255.5 176.5 320 256 320zM220.2 44.38c14.12 14.38 27 29.38 38.13 44.25L282.4 121l26-31c3.5-4.25 7.25-8.375 11-12.38C350 114.5 368 159.3 368 176c0 61.75-50.25 112-112 112s-112-50.25-112-112C144 148.3 172 94.38 220.2 44.38zM501.5 480.1L302.5 408l199-72.97c8.281-3.062 12.55-12.25 9.5-20.53c-3.047-8.312-12.17-12.53-20.53-9.531L256 390.9L21.52 304.1c-8.297-3-17.48 1.219-20.53 9.531c-3.047 8.281 1.219 17.47 9.5 20.53L209.5 408l-199 72.97c-8.281 3.062-12.55 12.25-9.5 20.53C3.359 508 9.484 512 16 512c1.828 0 3.688-.3125 5.516-.9687L256 425.1l234.5 85.98C492.3 511.7 494.2 512 496 512c6.516 0 12.64-4 15.02-10.5C514.1 493.2 509.8 484 501.5 480.1z"],
    "campground": [576, 512, [9978], "f6bb", "M394.3 3.745C401.1 9.425 401.9 19.52 396.3 26.29L308.9 130.4L532.8 397.2C540 405.8 544 416.7 544 428V464C544 490.5 522.5 512 496 512H80C53.49 512 32 490.5 32 464V428C32 416.7 35.98 405.8 43.23 397.2L267.1 130.4L179.7 26.29C174.1 19.52 174.9 9.425 181.7 3.745C188.5-1.936 198.6-1.054 204.3 5.715L287.1 105.5L371.7 5.715C377.4-1.054 387.5-1.936 394.3 3.745H394.3zM64 428V464C64 472.8 71.16 480 80 480H129.9L275.4 294.1C278.4 290.3 283.1 288 288 288C292.9 288 297.6 290.3 300.6 294.1L446.1 480H496C504.8 480 512 472.8 512 464V428C512 424.2 510.7 420.6 508.3 417.7L288 155.3L67.74 417.7C65.33 420.6 64 424.2 64 428zM170.6 480H405.4L288 329.1L170.6 480z"],
    "can-food": [384, 512, [129387], "e3e6", "M192 0C106.7 0 16 28.03 16 80v358.9C16 479.3 94.8 512 192 512s176-32.75 176-73.14V80C368 28.03 277.3 0 192 0zM336 269.2c-15.1 11.41-38.93 20.82-68.03 26.97C257.8 263.7 227.8 240 192 240S126.2 263.7 116 296.2C86.93 290 63.1 280.6 47.1 269.2l-.002-141.9C81.94 148.7 138 160 192 160c53.99 0 110.1-11.26 144-32.67L336 269.2zM240 320c0 26.47-21.53 48-48 48S144 346.5 144 320S165.5 272 192 272S240 293.5 240 320zM192 32c87.91 0 144 28.42 144 48S279.9 128 192 128S48 99.58 48 80S104.1 32 192 32zM192 480c-95.15 0-142.1-31.33-144-41.14L47.1 306.6c17.72 9.166 39.67 16.44 64.82 21.49C116.1 368.4 150.7 400 192 400s75.04-31.62 79.18-71.87c25.15-5.051 47.11-12.33 64.83-21.5l.002 132.1C334.1 448.7 287.1 480 192 480z"],
    "candle-holder": [448, 512, [128367], "f6bc", "M160 191.1c45.88 0 77.1-32.62 77.1-79.25C237.1 82.75 205.4 37.88 160 0C114.4 38 81.1 82.88 81.1 112.8C81.1 159.4 114.1 191.1 160 191.1zM160 43.13c31.5 30.88 45.1 58.25 45.1 69.63C205.1 141.9 188.4 160 160 160S113.1 141.9 113.1 112.8C113.1 101.4 128.5 74 160 43.13zM371 385.3c-23.94 4.682-43.7 24.2-49.28 47.94C317.6 450.8 321.1 466.6 328.9 480H256V272C256 245.6 234.4 224 208 224h-96C85.6 224 64 245.6 64 272V480H16C7.199 480 0 487.2 0 496C0 504.8 7.182 512 15.98 512h364.5c32.18 0 61.96-22.19 66.76-54.01C453.9 413.8 415.5 376.6 371 385.3zM224 480H96V272C96 263.2 103.2 256 112 256H128v48C128 312.9 135.1 320 144 320S160 312.9 160 304V256h48C216.8 256 224 263.2 224 272V480zM384 480c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S401.6 480 384 480z"],
    "candy": [640, 512, [127852], "e3e7", "M636.5 273.1C639 277.1 640.3 281.1 639.1 285.1C639.7 289.2 637.9 292.1 634.9 295.7C631.9 298.5 628 300 624 300C623.2 299.1 622.5 299.9 621.7 299.8L520.8 285.4L621.3 320.9C624.9 322.1 627.9 324.6 629.8 327.9C631.7 331.1 632.4 334.1 631.8 338.7C631.2 342.4 629.2 345.8 626.3 348.2C623.4 350.7 619.8 352 616 352C614.2 352 612.4 351.7 610.7 351.1L503.3 313.2C491.2 352.3 466.8 386.5 433.8 410.8C400.8 435.1 360.1 448.2 319.1 448.2C279 448.2 239.2 435.1 206.2 410.8C173.2 386.5 148.8 352.3 136.7 313.2L29.34 351.1C27.62 351.7 25.82 352 23.1 352C20.22 352 16.55 350.7 13.66 348.2C10.77 345.8 8.831 342.4 8.195 338.7C7.558 334.1 8.262 331.1 10.18 327.9C12.1 324.6 15.12 322.1 18.69 320.9L119.2 285.4L18.27 299.8C17.52 299.9 16.76 299.1 15.1 300C11.95 300 8.051 298.5 5.086 295.7C2.122 292.1 .313 289.2 .025 285.1C-.2633 281.1 .9905 277.1 3.534 273.1C6.076 270.8 9.719 268.7 13.73 268.2L98.85 256L13.73 243.8C9.533 243.2 5.748 240.1 3.204 237.6C.6605 234.2-.4345 229.1 .1594 225.8C.8087 221.6 3.066 217.8 6.449 215.3C9.833 212.7 14.07 211.6 18.27 212.2L119.2 226.6L18.69 191.1C14.68 189.7 11.4 186.7 9.568 182.9C7.734 179.1 7.498 174.7 8.911 170.7C10.32 166.7 13.27 163.4 17.1 161.6C20.93 159.7 25.34 159.5 29.34 160.9L136.7 198.8C148.8 159.7 173.2 125.5 206.2 101.2C239.2 76.93 279 63.84 319.1 63.84C360.1 63.84 400.8 76.93 433.8 101.2C466.8 125.5 491.2 159.7 503.3 198.8L610.7 160.9C614.7 159.5 619.1 159.7 622.9 161.6C626.7 163.4 629.7 166.7 631.1 170.7C632.5 174.7 632.3 179.1 630.4 182.9C628.6 186.7 625.3 189.7 621.3 191.1L520.8 226.6L621.7 212.2C625.9 211.6 630.2 212.6 633.6 215.2C636.1 217.7 639.2 221.5 639.8 225.7C640.4 229.9 639.4 234.2 636.8 237.6C634.3 240.1 630.5 243.2 626.3 243.8L541.2 256L626.3 268.2C630.3 268.7 633.9 270.8 636.5 273.1H636.5zM449.6 162.7C429.9 135.6 402.2 115.3 370.3 104.8L471.1 306.4C476.8 290.2 479.8 273.2 480 256C479.9 222.5 469.3 189.8 449.6 162.7zM190.4 349.3C210.1 376.4 237.8 396.7 269.7 407.2L168.9 205.6C163.2 221.8 160.2 238.8 159.1 256C160.1 289.5 170.7 322.2 190.4 349.3zM319.1 416C339.4 415.9 358.6 412.2 376.7 405.1L234.7 121.2C215.3 133.4 198.8 149.6 186.2 168.7L309.3 414.9C312.9 415.2 316.4 416 319.1 416zM453.8 343.3L330.7 97.09C327.1 96.83 323.6 96 319.1 96C300.6 96.12 281.4 99.81 263.3 106.9L405.3 390.8C424.7 378.6 441.2 362.4 453.8 343.3z"],
    "candy-bar": [640, 512, [127851, "chocolate-bar"], "e3e8", "M589.3 82.75C601.3 94.75 608 111 608 128V384C608 400.1 601.3 417.3 589.3 429.3C577.3 441.3 560.1 448 544 448H32C15.03 448-1.252 441.3-13.25 429.3C-25.26 417.3-32 400.1-32 384V222.4C-13.93 218.7 2.31 208.9 13.97 194.6C25.64 180.3 32 162.4 32 144V128H48C66.44 128 84.32 121.6 98.61 109.1C112.9 98.31 122.7 82.07 126.4 64H544C560.1 64 577.3 70.74 589.3 82.75zM62.98 158.1C61.23 170.5 57.66 181.6 52.42 192H128V125.2C110.7 143.5 87.83 155.4 62.98 158.1zM0 320H128V224H29.25C20.71 232.6 10.83 239.8 0 245.2V320zM128 416V352H0V384C0 392.5 3.372 400.6 9.372 406.6C15.37 412.6 23.51 416 32 416H128zM288 352H160V416H288V352zM288 224H160V320H288V224zM288 96H160V192H288V96zM576 128C576 119.5 572.6 111.4 566.6 105.4C560.6 99.37 552.5 96 544 96H320V416H544C552.5 416 560.6 412.6 566.6 406.6C572.6 400.6 576 392.5 576 384V128z"],
    "candy-cane": [512, 512, [], "f786", "M497.5 91.1C469.6 33.12 411.8 0 352.4 0c-27.88 0-56.14 7.25-81.77 22.62L243.1 38.1C227.9 48.12 223 67.75 232.1 82.87l32.76 54.87c9.375 15.75 29.38 19.94 43.88 11.06l27.51-16.37c36-21.5 69.6 33.02 32.85 54.9L15.6 397.6c-15.25 9.125-20.13 28.62-11 43.87l32.76 54.87C43.35 506.4 53.97 512 64.85 512c5.625 0 11.27-1.507 16.39-4.507l347.4-206.5C500.2 258.1 533.2 167.5 497.5 91.1zM292.2 121.4l-32.75-54.88C291.7 47.25 312.6 32.12 351.1 32v64C328.3 96.25 314.7 108.1 292.2 121.4zM383.2 104h.75V36.12c36.75 9.125 67.75 34 84.63 69.5c3.375 7.125 6 14.62 7.875 22.25h-68.5c-.25-.25-.25-.5643-.375-.8143C401.7 117.2 393.2 109.4 383.2 104zM256.7 291.4l82.38-48.1l64.25 36.25l-82.25 49L256.7 291.4zM289.3 346.5l-87.5 52l-64.25-36.25l87.5-52L289.3 346.5zM64.72 480l-32.88-54.88l73.88-43.88l64.38 36.13L64.72 480zM432.7 258.5l-62-34.88l14.63-8.75C405.4 203 416.2 181.8 416.2 160h63C478.4 196.5 462.1 232.8 432.7 258.5z"],
    "candy-corn": [640, 512, [], "f6bd", "M479.1 0c-165.8 1.625-164.5 39.5-157.9 72.5c30.38 151.5 94.01 343.5 157.8 343.5c63.75-.125 127.6-191.9 158-343.5C644.5 39.5 645.8 1.625 479.1 0zM479.9 384c-12.75 0-39.25-37.13-67.38-108.8c43.75-3.75 91.13-3.75 135 0C519.3 346.9 492.8 384 479.9 384zM559 244.3c-50.88-5-107.3-5-158 0c-9.502-27.12-19-58-28-92.63c66.63-9.75 147.4-9.875 214 0C577.9 186.3 568.5 217.1 559 244.3zM606.6 66.13c-3.75 19-7.875 36.88-11.88 54.25c-71.38-10.88-158.1-10.88-229.5 0c-4-17.38-8.125-35.25-11.88-54.25c-2-9.877-1.5-12.38-1.25-13C352.2 52.88 364.1 33.13 479.1 32c115 1.125 127.8 20.88 127.9 21.12C608.1 53.75 608.6 56.25 606.6 66.13zM84.97 205.8c-116.1 118.5-88.35 144.4-60.47 162.1c128.6 85.63 309.5 176.4 354.5 131.3c44.88-45.25-45.39-225.9-131.1-354.6C229.2 117.5 203.4 89.77 84.97 205.8zM356.4 477.4c-9.002 9-54 1.625-124.5-29.12c28.25-33.63 61.88-67.13 95.38-95.5C357.1 423.4 365.4 468.4 356.4 477.4zM313.5 322.6c-39.5 32.5-79.38 72.25-111.8 111.8c-25.88-12.5-54.38-27.62-85.25-45.75c40.13-54 97.25-111.1 151.3-151.3C285.9 268.3 300.1 296.8 313.5 322.6zM88.98 372c-15.25-9.375-30.75-19.13-46.88-29.88c-8.375-5.625-9.875-7.75-10.12-8.375c0-.125-5-23.12 75.63-105.3c82.13-80.63 105.1-75.63 105.3-75.63C213.5 153.1 215.6 154.6 221.2 163C231.1 179.1 241.7 194.6 251.1 209.9C193.1 252.6 131.7 314 88.98 372z"],
    "cannabis": [576, 512, [], "f55f", "M288 224C279.2 224 272 231.2 272 240v256c0 8.799 7.199 16 16 16s16-7.201 16-16v-256C304 231.2 296.8 224 288 224zM526.4 323.4c-1.125-.5-19.5-9.75-47.88-17.75c48.25-64.25 63.88-129.8 64.63-133.1c2.5-10.62-.625-21.75-8.25-29.5C528.9 136.8 520.6 133.4 512 133.4c-2.125 0-4.375 .125-6.625 .625c-3.25 .75-66.25 14.38-130.6 56c-8.625-97.75-57.88-172.4-60.13-175.8C308.6 5.375 298.6 0 288 0S267.4 5.375 261.4 14.25c-2.25 3.375-51.5 78-60.13 175.8c-64.38-41.63-127.3-55.25-130.6-56C68.38 133.5 66.25 133.4 64 133.4c-8.5 0-16.75 3.375-22.88 9.625C33.5 150.8 30.22 161.8 32.72 172.5C33.47 175.8 49.25 241.4 97.5 305.6c-28.25 8-46.75 17.25-47.88 17.75C38.88 328.9 32 339.9 32 352c0 12 6.75 23.12 17.5 28.5c2.375 1.25 54.5 27.25 121 30c-2.875 6.75-4.25 11-4.375 11.5c-3.887 11.66-.8008 24.57 8.402 33.39c5.787 5.545 13.74 8.561 21.76 8.607c3.064 .0195 6.268-.3496 9.34-1.373C206.7 462.3 220.6 458 240 448.1v-35.84C215.3 426.2 196.5 432 196.5 432c3.693-11.25 8.465-21.41 13-29.89c5.832-10.9-2.039-24.05-14.39-23.68c-4.252 .127-8.74 .1934-13.48 .1934C116.6 378.6 64 352 64 352s26.18-13.17 64.32-21.01c11.97-2.461 17.17-16.95 9.062-26.09C90.2 251.7 67.51 180.5 64 165.4c62.67 13.18 113.3 45.53 142.4 67.82C216.9 241.3 232 233.7 232 220.4C232 219.8 232 219.2 232 218.6C232 115.6 288 32 288 32s56 83.63 56 186.6c0 .5215 0 1.039-.002 1.557c-.0371 13.32 15.09 20.94 25.65 12.82C398.5 210.8 448.9 178.6 512 165.4c-3.48 15.02-26.44 86.49-73.45 139.6c-8.084 9.125-2.891 23.58 9.053 26.04C485.8 338.8 512 352 512 352s-52.63 26.62-117.6 26.62c-4.785 0-9.312-.0684-13.6-.1973c-12.33-.373-20.24 12.76-14.4 23.62C371 410.7 375.9 420.9 379.5 432c0 0-18.85-5.807-43.5-18.86V449c19.42 9.031 33.29 13.29 34.38 13.62C373.4 463.6 376.5 464 379.5 464c8.5 0 16.88-3.375 23-9.75c8.25-8.5 11.12-21 7.375-32.25c-.125-.5-1.5-4.75-4.375-11.5c66.5-2.75 118.6-28.75 121-30C537.3 375.1 544 364 544 352C544 339.9 537.3 328.9 526.4 323.4z"],
    "capsules": [576, 512, [], "f46b", "M554.6 302.2l-131.7-181.2c-21.01-28.91-54.9-46.17-90.67-46.17c-23.76 0-46.51 7.398-65.77 21.39C244.1 112.4 230 135.6 224 160.6L223.9 143.9C223.9 82.19 173.7 32 111.1 32S-.0021 82.2-.0021 143.1L-.0028 368c0 61.76 50.24 112 112 112s112-50.24 112-112L224 214.4C227.4 227.8 233.1 240.8 241.7 252.6l131.7 181.2C394.4 462.7 428.3 480 464.1 480c23.76 0 46.5-7.398 65.77-21.4C579.8 422.3 590.9 352.1 554.6 302.2zM191.1 368c0 44.18-35.81 80-79.1 80c-44.18 0-79.1-35.82-79.1-80L32 272h160L191.1 368zM192 240H32l-.0003-96c0-44.18 35.82-80 79.1-80c44.18 0 79.1 35.82 79.1 80L192 240zM285.3 122.1c14.2-10.32 30.65-15.28 46.96-15.29c24.74 0 49.13 11.44 64.79 32.98l71.7 98.68l-15.27-20.1l-129.4 94.03L267.6 233.8C241.6 198.1 249.6 148 285.3 122.1zM511 432.7C496.8 443 480.4 448 464.1 448c-24.74 0-49.13-11.44-64.79-32.98L339.1 332.1l3.787 5.209l129.5-94.03l56.42 77.66C554.7 356.7 546.8 406.7 511 432.7z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M80 296C80 282.7 90.75 272 104 272C117.3 272 128 282.7 128 296C128 309.3 117.3 320 104 320C90.75 320 80 309.3 80 296zM432 296C432 309.3 421.3 320 408 320C394.7 320 384 309.3 384 296C384 282.7 394.7 272 408 272C421.3 272 432 282.7 432 296zM48.29 204.7L82.99 89.01C93.14 55.17 124.3 32 159.6 32H352.4C387.7 32 418.9 55.17 429 89.01L463.7 204.7C492.6 221.2 512 252.3 512 288V464C512 472.8 504.8 480 496 480C487.2 480 480 472.8 480 464V416H32V464C32 472.8 24.84 480 16 480C7.164 480 0 472.8 0 464V288C0 252.3 19.44 221.2 48.29 204.7zM85.33 192.6C88.83 192.2 92.39 192 96 192H416C419.6 192 423.2 192.2 426.7 192.6L398.4 98.21C392.3 77.9 373.6 64 352.4 64H159.6C138.4 64 119.7 77.9 113.6 98.21L85.33 192.6zM32 288V384H480V288C480 260.3 462.4 236.7 437.7 227.8L437.3 227.9L437.2 227.6C430.5 225.3 423.4 224 416 224H96C88.58 224 81.46 225.3 74.83 227.6L74.73 227.9L74.27 227.8C49.62 236.7 32 260.3 32 288V288z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M64 80C64 71.16 71.16 64 80 64H176C184.8 64 192 71.16 192 80C192 88.84 184.8 96 176 96H80C71.16 96 64 88.84 64 80zM320 80C320 71.16 327.2 64 336 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H336C327.2 96 320 88.84 320 80zM368 208C376.8 208 384 215.2 384 224V256H416C424.8 256 432 263.2 432 272C432 280.8 424.8 288 416 288H384V320C384 328.8 376.8 336 368 336C359.2 336 352 328.8 352 320V288H320C311.2 288 304 280.8 304 272C304 263.2 311.2 256 320 256H352V224C352 215.2 359.2 208 368 208zM192 256C200.8 256 208 263.2 208 272C208 280.8 200.8 288 192 288H96C87.16 288 80 280.8 80 272C80 263.2 87.16 256 96 256H192zM0 192C0 156.7 28.65 128 64 128H448C483.3 128 512 156.7 512 192V384C512 419.3 483.3 448 448 448H64C28.65 448 0 419.3 0 384V192zM32 192V384C32 401.7 46.33 416 64 416H448C465.7 416 480 401.7 480 384V192C480 174.3 465.7 160 448 160H64C46.33 160 32 174.3 32 192z"],
    "car-bolt": [512, 512, [], "e341", "M80 296C80 282.7 90.75 272 104 272C117.3 272 128 282.7 128 296C128 309.3 117.3 320 104 320C90.75 320 80 309.3 80 296zM432 296C432 309.3 421.3 320 408 320C394.7 320 384 309.3 384 296C384 282.7 394.7 272 408 272C421.3 272 432 282.7 432 296zM230.6 192H320C326.5 192 332.3 195.9 334.8 201.9C337.3 207.9 335.9 214.7 331.3 219.3L235.3 315.3C229.1 321.6 218.9 321.6 212.7 315.3C206.4 309.1 206.4 298.9 212.7 292.7L281.4 223.1H192C185.5 223.1 179.7 220.1 177.2 214.1C174.7 208.1 176.1 201.3 180.7 196.7L276.7 100.7C282.9 94.44 293.1 94.44 299.3 100.7C305.6 106.9 305.6 117.1 299.3 123.3L230.6 192zM48.29 204.7L82.99 89.01C93.14 55.17 124.3 32 159.6 32H352.4C387.7 32 418.9 55.17 429 89.01L463.7 204.7C492.6 221.2 512 252.3 512 288V464C512 472.8 504.8 480 496 480C487.2 480 480 472.8 480 464V416H32V464C32 472.8 24.84 480 16 480C7.164 480 0 472.8 0 464V288C0 252.3 19.44 221.2 48.29 204.7zM85.33 192.6C88.83 192.2 92.39 192 96 192H128V224H96C88.58 224 81.46 225.3 74.83 227.6L74.73 227.9L74.27 227.8C49.62 236.7 32 260.3 32 288V384H480V288C480 260.3 462.4 236.7 437.7 227.8L437.3 227.9L437.2 227.6C430.5 225.3 423.4 224 416 224H384V192H416C419.6 192 423.2 192.2 426.7 192.6L398.4 98.21C392.3 77.9 373.6 64 352.4 64H159.6C138.4 64 119.7 77.9 113.6 98.21L85.33 192.6z"],
    "car-building": [640, 512, [], "f859", "M32 64V416C32 433.7 46.33 448 64 448H224V480H64C28.65 480 0 451.3 0 416V64C0 28.65 28.65 0 64 0H288C323.3 0 352 28.65 352 64V148.2C340.3 151.8 329.4 157.6 320 165.2V64C320 46.33 305.7 32 288 32H64C46.33 32 32 46.33 32 64V64zM264 192C276.5 192 286.7 201.5 287.9 213.7L269.6 277.8C265.3 280.9 261.4 284.3 257.6 288H216C202.7 288 192 277.3 192 264V216C192 202.7 202.7 192 216 192H264zM224 224V256H256V224H224zM136 64C149.3 64 160 74.75 160 88V136C160 149.3 149.3 160 136 160H88C74.75 160 64 149.3 64 136V88C64 74.75 74.75 64 88 64H136zM128 128V96H96V128H128zM192 88C192 74.75 202.7 64 216 64H264C277.3 64 288 74.75 288 88V136C288 149.3 277.3 160 264 160H216C202.7 160 192 149.3 192 136V88zM224 96V128H256V96H224zM136 192C149.3 192 160 202.7 160 216V264C160 277.3 149.3 288 136 288H88C74.75 288 64 277.3 64 264V216C64 202.7 74.75 192 88 192H136zM128 256V224H96V256H128zM136 320C149.3 320 160 330.7 160 344V392C160 405.3 149.3 416 136 416H88C74.75 416 64 405.3 64 392V344C64 330.7 74.75 320 88 320H136zM128 384V352H96V384H128zM312 376C312 362.7 322.7 352 336 352C349.3 352 360 362.7 360 376C360 389.3 349.3 400 336 400C322.7 400 312 389.3 312 376zM584 376C584 389.3 573.3 400 560 400C546.7 400 536 389.3 536 376C536 362.7 546.7 352 560 352C573.3 352 584 362.7 584 376zM380.2 176H515.8C544.4 176 569.5 194.9 577.3 222.4L598.1 298.1C623.4 311.8 640 337.1 640 368V496C640 504.8 632.8 512 624 512C615.2 512 608 504.8 608 496V464H287.1V496C287.1 504.8 280.8 512 271.1 512C263.2 512 255.1 504.8 255.1 496V368C255.1 337.1 272.6 311.8 297 298.1L318.7 222.4C326.5 194.9 351.6 176 380.2 176H380.2zM380.2 208C365.9 208 353.4 217.5 349.4 231.2L333.2 288C334.1 288 335.1 288 336 288H560C560.9 288 561.9 288 562.8 288L546.6 231.2C542.6 217.5 530.1 208 515.8 208H380.2zM608 368C608 341.5 586.5 320 560 320H336C309.5 320 288 341.5 288 368V432H608V368z"],
    "car-bump": [640, 512, [], "f5e0", "M157.3 308.9C160.6 321.1 153.4 333.6 141.2 336.9C129 340.1 116.5 332.9 113.2 320.7C109.1 308.5 117.2 296 129.4 292.8C141.5 289.5 154.1 296.7 157.3 308.9zM392.5 245.9C389.2 233.7 396.5 221.2 408.6 217.9C420.8 214.7 433.3 221.9 436.6 234.1C439.8 246.2 432.6 258.8 420.4 262C408.3 265.3 395.8 258.1 392.5 245.9V245.9zM64.17 132.1C65.22 96.83 89.3 66.39 123.4 57.24L296 10.1C330.1 1.856 366.2 16.18 384.8 46.24L445.7 144.9C475.8 154.5 500.5 178.8 509.3 211.6L551.4 368.7C553.6 376.8 548.8 385.2 540.7 387.3C532.6 389.5 524.2 384.7 522 376.6L510.2 332.5L98.66 442.8L110.5 486.9C112.7 494.1 107.8 503.3 99.72 505.5C91.6 507.7 83.26 502.9 81.08 494.7L38.98 337.6C30.2 304.8 39.48 271.5 60.73 248.1L64.17 132.1zM131.7 88.15C111.2 93.64 96.78 111.9 96.15 133.1L93.44 224.7C97.73 222.8 102.2 221.3 106.9 220L391.7 143.7C396.4 142.4 401.1 141.6 405.7 141L357.5 63.05C346.4 45.02 324.8 36.42 304.3 41.91L131.7 88.15zM69.89 329.3L91.9 411.5L500.4 301.1L478.4 219.9C469.3 185.7 434.2 165.4 400 174.6L115.1 250.9C81 260.1 60.74 295.2 69.89 329.3H69.89zM445.7 511.8C436.1 510.6 430.9 502.5 432.2 493.7C438.4 449.8 476.2 416 521.9 416C567.6 416 605.4 449.8 611.7 493.7C612.9 502.5 606.8 510.6 598.1 511.8C589.3 513.1 581.2 507 579.1 498.3C575.9 469.8 551.5 448 521.9 448C492.4 448 467.9 469.8 463.8 498.3C462.6 507 454.5 513.1 445.7 511.8H445.7z"],
    "car-burst": [640, 512, ["car-crash"], "f5e1", "M222.6 87.16L288.9 70.78L265.7 109.5L217.5 121.4C210 123.2 202.3 119.5 199.1 112.6L176 62.31L152.9 112.6C149.7 119.5 141.1 123.2 134.5 121.4L80.86 108.1L105.7 157.5C109.2 164.4 107.3 172.7 101.2 177.4L57.36 211.1L111.5 222.4C118.1 223.1 124.3 230.7 124.2 238.4L123.2 293.6L155.9 266.6L144.1 310.5C143.3 313.4 142.8 316.3 142.5 319.2L116.8 340.5C111.1 344.5 105.3 345.3 99.64 342.6C94.01 339.9 90.47 334.1 90.58 327.9L91.96 251L16.73 235.3C10.61 233.1 5.803 229.3 4.413 223.2C3.022 217.1 5.306 210.7 10.26 206.9L71.21 160.1L36.62 91.44C33.81 85.86 34.5 79.15 38.4 74.27C42.29 69.38 48.68 67.21 54.75 68.71L129.4 87.16L161.5 17.32C164.1 11.64 169.7 8 175.1 8C182.2 8 187.9 11.64 190.5 17.32L222.6 87.16zM258.5 259.7C262.5 244.8 277.8 235.9 292.7 239.9C307.7 243.9 316.5 259.3 312.5 274.2C308.5 289.1 293.2 298 278.3 293.1C263.3 289.1 254.5 274.6 258.5 259.7zM564.9 341.8C560.9 356.8 545.5 365.6 530.6 361.6C515.7 357.6 506.8 342.3 510.8 327.3C514.8 312.4 530.2 303.5 545.1 307.5C560 311.5 568.9 326.9 564.9 341.8zM389.2 56.01L553.5 100.1C581.1 107.4 600.5 132.2 600.1 160.8L602.5 250.6C629.2 269.4 642.8 303.5 633.8 336.9L607.6 434.7C607.5 435.3 607.3 435.8 607.1 436.4L607.1 436.4L591.7 493.9C589.1 503.9 578.8 509.8 568.9 507.1C558.9 504.4 553 494.2 555.7 484.3L565.4 448.2L204.9 351.6L195.2 387.7C192.5 397.6 182.3 403.5 172.3 400.9C162.4 398.2 156.5 387.1 159.1 378L174 322.5L174.3 322.6C174.4 321.3 174.7 320 175 318.8L201.2 220.9C210.2 187.6 238.1 164.8 271.5 161.9L317.7 84.91C332.4 60.41 361.6 48.61 389.2 56L389.2 56.01zM380.9 86.92C367.1 83.22 352.5 89.12 345.2 101.4L306.2 166.3L570.2 236.1L568.1 161.3C568.7 147.1 559.1 134.7 545.3 130.1L380.9 86.92zM568.1 269.8L290.9 195.3C265.3 188.4 239 203.6 232.1 229.2L208 319.3L578.8 418.7L602.9 328.6C609.8 302.1 594.6 276.7 568.1 269.8L568.1 269.8z"],
    "car-bus": [640, 512, [], "f85a", "M32 256V352C32 369.7 46.33 384 64 384H224V416H64V464C64 472.8 56.84 480 48 480C39.16 480 32 472.8 32 464V407.4C12.87 396.4 0 375.7 0 352V110.2C0 88.95 4.48 62.07 25.97 45.04C54.78 22.22 107.5 0 192 0C276.5 0 329.2 22.22 358 45.04C379.5 62.07 384 88.94 384 110.2V144H380.2C370.5 144 360.1 145.5 352 148.2V128H208V224H284.9L275.8 256H32zM32.98 96H351C349.3 84.52 345.2 75.67 338.2 70.12C316.2 52.75 271 32 192 32C112.1 32 67.77 52.75 45.84 70.12C38.85 75.67 34.72 84.52 32.98 96V96zM32 128V224H176V128H32zM80 312C80 298.7 90.75 288 104 288C117.3 288 128 298.7 128 312C128 325.3 117.3 336 104 336C90.75 336 80 325.3 80 312zM312 376C312 362.7 322.7 352 336 352C349.3 352 360 362.7 360 376C360 389.3 349.3 400 336 400C322.7 400 312 389.3 312 376zM584 376C584 389.3 573.3 400 560 400C546.7 400 536 389.3 536 376C536 362.7 546.7 352 560 352C573.3 352 584 362.7 584 376zM380.2 176H515.8C544.4 176 569.5 194.9 577.3 222.4L598.1 298.1C623.4 311.8 640 337.1 640 368V496C640 504.8 632.8 512 624 512C615.2 512 608 504.8 608 496V464H287.1V496C287.1 504.8 280.8 512 271.1 512C263.2 512 255.1 504.8 255.1 496V368C255.1 337.1 272.6 311.8 297 298.1L318.7 222.4C326.5 194.9 351.6 176 380.2 176H380.2zM380.2 208C365.9 208 353.4 217.5 349.4 231.2L333.2 288C334.1 288 335.1 288 336 288H560C560.9 288 561.9 288 562.8 288L546.6 231.2C542.6 217.5 530.1 208 515.8 208H380.2zM608 368C608 341.5 586.5 320 560 320H336C309.5 320 288 341.5 288 368V432H608V368z"],
    "car-circle-bolt": [640, 512, [], "e342", "M32 288V384H320.7C321.7 394.1 323.7 405.7 326.6 416H32V464C32 472.8 24.84 480 16 480C7.164 480 0 472.8 0 464V288C0 252.3 19.44 221.2 48.29 204.7L82.99 89.01C93.14 55.17 124.3 32 159.6 32H352.4C387.7 32 418.9 55.17 429 89.01L460.1 195.5C436.7 200.4 414.3 210.3 394.8 224H96C88.58 224 81.46 225.3 74.83 227.6L74.73 227.9L74.27 227.8C49.62 236.7 32 260.3 32 288H32zM85.33 192.6C88.83 192.2 92.39 192 96 192H416C419.6 192 423.2 192.2 426.7 192.6L398.4 98.21C392.3 77.9 373.6 64 352.4 64H159.6C138.4 64 119.7 77.9 113.6 98.21L85.33 192.6zM80 296C80 282.7 90.75 272 104 272C117.3 272 128 282.7 128 296C128 309.3 117.3 320 104 320C90.75 320 80 309.3 80 296zM543.9 286.1C548.2 290.7 549.2 296.9 546.5 301.8L516.4 356H552C557.2 356 561.8 359.3 563.4 364.2C565 369.1 563.3 374.5 559.2 377.6L463.2 449.6C458.7 452.1 452.4 452.8 448.1 449C443.8 445.3 442.8 439.1 445.5 434.2L475.6 380H440C434.8 380 430.2 376.7 428.6 371.8C426.1 366.9 428.7 361.5 432.8 358.4L528.8 286.4C533.3 283 539.6 283.2 543.9 286.1V286.1zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "car-garage": [640, 512, [], "f5e2", "M632.5 194.5C640 199.2 642.2 209.1 637.5 216.5C632.8 224 622.9 226.2 615.5 221.5L320 34.92L24.55 221.5C17.07 226.2 7.193 224 2.474 216.5C-2.244 209.1-.0131 199.2 7.458 194.5L311.5 2.472C316.7-.8241 323.3-.8241 328.5 2.472L632.5 194.5zM184 376C184 362.7 194.7 352 208 352C221.3 352 232 362.7 232 376C232 389.3 221.3 400 208 400C194.7 400 184 389.3 184 376zM456 376C456 389.3 445.3 400 432 400C418.7 400 408 389.3 408 376C408 362.7 418.7 352 432 352C445.3 352 456 362.7 456 376zM252.2 176H387.8C416.4 176 441.5 194.9 449.3 222.4L470.1 298.1C495.4 311.8 512 337.1 512 368V496C512 504.8 504.8 512 496 512C487.2 512 480 504.8 480 496V464H160V496C160 504.8 152.8 512 144 512C135.2 512 128 504.8 128 496V368C128 337.1 144.6 311.8 169 298.1L190.7 222.4C198.5 194.9 223.6 176 252.2 176V176zM252.2 208C237.9 208 225.4 217.5 221.4 231.2L205.2 288C206.1 288 207.1 288 208 288H432C432.9 288 433.9 288 434.8 288L418.6 231.2C414.6 217.5 402.1 208 387.8 208H252.2zM480 368C480 341.5 458.5 320 432 320H208C181.5 320 160 341.5 160 368V432H480V368z"],
    "car-mirrors": [576, 512, [], "e343", "M160 296C160 309.3 149.3 320 136 320C122.7 320 112 309.3 112 296C112 282.7 122.7 272 136 272C149.3 272 160 282.7 160 296zM416 296C416 282.7 426.7 272 440 272C453.3 272 464 282.7 464 296C464 309.3 453.3 320 440 320C426.7 320 416 309.3 416 296zM56.44 224H32C23.16 224 16 216.8 16 208C16 199.2 23.16 192 32 192H84.1L114.1 89.01C125.1 55.17 156.3 32 191.6 32H384.4C419.7 32 450.9 55.17 461 89.01L491.9 192H544C552.8 192 560 199.2 560 208C560 216.8 552.8 224 544 224H519.6C534.8 240.1 544 263.4 544 288V464C544 472.8 536.8 480 528 480C519.2 480 512 472.8 512 464V416H64V464C64 472.8 56.84 480 48 480C39.16 480 32 472.8 32 464V288C32 263.4 41.24 240.1 56.44 224zM191.6 64C170.4 64 151.7 77.9 145.6 98.21L117.3 192.6C120.8 192.2 124.4 192 128 192H448C451.6 192 455.2 192.2 458.7 192.6L430.4 98.21C424.3 77.9 405.6 64 384.4 64H191.6zM106.7 227.9L106.3 227.8C81.62 236.7 64 260.3 64 288V384H512V288C512 260.3 494.4 236.7 469.7 227.8L469.3 227.9L469.2 227.6C462.5 225.3 455.4 224 448 224H128C120.6 224 113.5 225.3 106.8 227.6L106.7 227.9z"],
    "car-on": [448, 512, [], "e4dd", "M240 104C240 112.8 232.8 120 223.1 120C215.2 120 207.1 112.8 207.1 104V24C207.1 15.16 215.2 8 223.1 8C232.8 8 240 15.16 240 24V104zM87.1 376C87.1 362.7 98.75 352 111.1 352C125.3 352 135.1 362.7 135.1 376C135.1 389.3 125.3 400 111.1 400C98.75 400 87.1 389.3 87.1 376zM360 376C360 389.3 349.3 400 336 400C322.7 400 312 389.3 312 376C312 362.7 322.7 352 336 352C349.3 352 360 362.7 360 376zM156.2 176H291.8C320.4 176 345.5 194.9 353.3 222.4L374.1 298.1C399.4 311.8 416 337.1 416 368V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V464H63.1V496C63.1 504.8 56.84 512 47.1 512C39.16 512 31.1 504.8 31.1 496V368C31.1 337.1 48.56 311.8 73.04 298.1L94.67 222.4C102.5 194.9 127.6 176 156.2 176V176zM156.2 208C141.9 208 129.4 217.5 125.4 231.2L109.2 288C110.1 288 111.1 288 111.1 288H336C336.9 288 337.9 288 338.8 288L322.6 231.2C318.6 217.5 306.1 208 291.8 208H156.2zM384 368C384 341.5 362.5 320 336 320H111.1C85.49 320 63.1 341.5 63.1 368V432H384V368zM12.69 44.69C18.93 38.44 29.06 38.44 35.31 44.69L83.31 92.69C89.56 98.93 89.56 109.1 83.31 115.3C77.07 121.6 66.94 121.6 60.69 115.3L12.69 67.31C6.438 61.07 6.438 50.94 12.69 44.69V44.69zM412.7 44.69C418.9 38.44 429.1 38.44 435.3 44.69C441.6 50.93 441.6 61.07 435.3 67.31L387.3 115.3C381.1 121.6 370.9 121.6 364.7 115.3C358.4 109.1 358.4 98.94 364.7 92.69L412.7 44.69z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M82.99 89.01C93.14 55.17 124.3 32 159.6 32H352.4C387.7 32 418.9 55.17 429 89.01L463.7 204.7C492.6 221.2 512 252.3 512 288V352C512 375.7 499.1 396.4 480 407.4V464C480 472.8 472.8 480 464 480C455.2 480 448 472.8 448 464V416H64V464C64 472.8 56.84 480 48 480C39.16 480 32 472.8 32 464V407.4C12.87 396.4 0 375.7 0 352V288C0 252.3 19.44 221.2 48.29 204.7L82.99 89.01zM159.6 64C138.4 64 119.7 77.9 113.6 98.21L85.33 192.6C88.83 192.2 92.39 192 95.1 192H416C419.6 192 423.2 192.2 426.7 192.6L398.4 98.21C392.3 77.9 373.6 64 352.4 64H159.6zM74.73 227.9L74.27 227.8C49.62 236.7 31.1 260.3 31.1 288H79.1C88.84 288 95.1 295.2 95.1 304C95.1 312.8 88.84 320 79.1 320H31.1V352C31.1 369.7 46.33 384 63.1 384H159.1V352C159.1 334.3 174.3 320 191.1 320H320C337.7 320 352 334.3 352 352V384H448C465.7 384 480 369.7 480 352V320H432C423.2 320 416 312.8 416 304C416 295.2 423.2 288 432 288H480C480 260.3 462.4 236.7 437.7 227.8L437.3 227.9L437.2 227.6C430.5 225.3 423.4 224 416 224H95.1C88.58 224 81.46 225.3 74.83 227.6L74.73 227.9zM320 384V352H191.1V384H320z"],
    "car-side": [640, 512, [128663], "f5e4", "M640 320V368C640 385.7 625.7 400 608 400H574.7C567.1 445.4 527.6 480 480 480C432.4 480 392.9 445.4 385.3 400H254.7C247.1 445.4 207.6 480 160 480C112.4 480 72.94 445.4 65.33 400H32C14.33 400 0 385.7 0 368V256C0 224.5 22.78 198.3 52.78 192.1L97.05 82.29C109.2 51.92 138.6 32 171.3 32H353.2C377.5 32 400.5 43.05 415.7 62.02L519.9 192.2C586.9 196.3 640 251.1 640 320H640zM171.3 64C151.7 64 134.1 75.95 126.8 94.17L87.63 192H224V64H171.3zM256 192H478.7L390.7 82.01C381.6 70.63 367.8 64 353.2 64H256L256 192zM541.1 400C543.3 394.9 544 389.5 544 384C544 378.5 543.3 373.1 541.1 368C534.9 340.4 509.8 320 480 320C450.2 320 425.1 340.4 418 368C416.7 373.1 416 378.5 416 384C416 389.5 416.7 394.9 418 400C425.1 427.6 450.2 448 480 448C509.8 448 534.9 427.6 541.1 400zM385.3 368C392.9 322.6 432.4 288 480 288C527.6 288 567.1 322.6 574.7 368H608V320C608 266.1 565 224 512 224H64C46.33 224 32 238.3 32 256V368H65.33C72.94 322.6 112.4 288 160 288C207.6 288 247.1 322.6 254.7 368H385.3zM221.1 400C223.3 394.9 224 389.5 224 384C224 378.5 223.3 373.1 221.1 368C214.9 340.4 189.8 320 160 320C130.2 320 105.1 340.4 98.02 368C96.7 373.1 96 378.5 96 384C96 389.5 96.7 394.9 98.02 400C105.1 427.6 130.2 448 160 448C189.8 448 214.9 427.6 221.1 400z"],
    "car-side-bolt": [640, 512, [], "e344", "M278.6 192H368C374.5 192 380.3 195.9 382.8 201.9C385.3 207.9 383.9 214.7 379.3 219.3L283.3 315.3C277.1 321.6 266.9 321.6 260.7 315.3C254.4 309.1 254.4 298.9 260.7 292.7L329.4 223.1H240C233.5 223.1 227.7 220.1 225.2 214.1C222.7 208.1 224.1 201.3 228.7 196.7L324.7 100.7C330.9 94.44 341.1 94.44 347.3 100.7C353.6 106.9 353.6 117.1 347.3 123.3L278.6 192zM52.78 192.1L97.05 82.29C109.2 51.92 138.6 32 171.3 32H353.2C377.5 32 400.5 43.05 415.7 62.02L519.9 192.2C586.9 196.3 640 251.1 640 320V368C640 385.7 625.7 400 608 400H574.7C567.1 445.4 527.6 480 480 480C432.4 480 392.9 445.4 385.3 400H254.7C247.1 445.4 207.6 480 160 480C112.4 480 72.94 445.4 65.33 400H32C14.33 400 0 385.7 0 368V256C0 224.5 22.78 198.3 52.78 192.1H52.78zM87.63 192H160V224H64C46.33 224 32 238.3 32 256V368H65.33C72.94 322.6 112.4 288 160 288C207.6 288 247.1 322.6 254.7 368H385.3C392.9 322.6 432.4 288 480 288C527.6 288 567.1 322.6 574.7 368H608V320C608 266.1 565 224 512 224H448V192H478.7L390.7 82.01C381.6 70.63 367.8 64 353.2 64H171.3C151.7 64 134.1 75.95 126.8 94.17L87.63 192zM418 368C416.7 373.1 416 378.5 416 384C416 389.5 416.7 394.9 418 400C425.1 427.6 450.2 448 480 448C509.8 448 534.9 427.6 541.1 400C543.3 394.9 544 389.5 544 384C544 378.5 543.3 373.1 541.1 368C534.9 340.4 509.8 320 480 320C450.2 320 425.1 340.4 418 368V368zM98.02 400C105.1 427.6 130.2 448 160 448C189.8 448 214.9 427.6 221.1 400C223.3 394.9 224 389.5 224 384C224 378.5 223.3 373.1 221.1 368C214.9 340.4 189.8 320 160 320C130.2 320 105.1 340.4 98.02 368C96.7 373.1 96 378.5 96 384C96 389.5 96.7 394.9 98.02 400V400z"],
    "car-tilt": [640, 512, [], "f5e5", "M157.3 308.9C160.6 321.1 153.4 333.6 141.2 336.9C129 340.1 116.5 332.9 113.2 320.7C109.1 308.5 117.2 296 129.4 292.8C141.5 289.5 154.1 296.7 157.3 308.9zM392.5 245.9C389.2 233.7 396.5 221.2 408.6 217.9C420.8 214.7 433.3 221.9 436.6 234.1C439.8 246.2 432.6 258.8 420.4 262C408.3 265.3 395.8 258.1 392.5 245.9V245.9zM64.17 132.1C65.22 96.83 89.3 66.39 123.4 57.24L296 10.1C330.1 1.856 366.2 16.18 384.8 46.24L445.7 144.9C475.8 154.5 500.5 178.8 509.3 211.6L551.4 368.7C553.6 376.8 548.8 385.2 540.7 387.3C532.6 389.5 524.2 384.7 522 376.6L510.2 332.5L98.66 442.8L108.6 480H624C632.8 480 640 487.2 640 496C640 504.8 632.8 512 624 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H77.13L38.98 337.6C30.2 304.8 39.48 271.5 60.73 248.1L64.17 132.1zM131.7 88.15C111.2 93.64 96.78 111.9 96.15 133.1L93.44 224.7C97.73 222.8 102.2 221.3 106.9 220L391.7 143.7C396.4 142.4 401.1 141.6 405.7 141L357.5 63.05C346.4 45.02 324.8 36.42 304.3 41.91L131.7 88.15zM69.89 329.3L91.9 411.5L500.4 301.1L478.4 219.9C469.3 185.7 434.2 165.4 400 174.6L115.1 250.9C81 260.1 60.74 295.2 69.89 329.3L69.89 329.3z"],
    "car-tunnel": [512, 512, [], "e4de", "M256 32C132.3 32 32 132.3 32 256V496C32 504.8 24.84 512 16 512C7.164 512 0 504.8 0 496V256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256V496C512 504.8 504.8 512 496 512C487.2 512 480 504.8 480 496V256C480 132.3 379.7 32 256 32zM208 400C208 413.3 197.3 424 184 424C170.7 424 160 413.3 160 400C160 386.7 170.7 376 184 376C197.3 376 208 386.7 208 400zM304 400C304 386.7 314.7 376 328 376C341.3 376 352 386.7 352 400C352 413.3 341.3 424 328 424C314.7 424 304 413.3 304 400zM121.4 329.1L144.7 257.2C151.1 237.4 169.6 224 190.4 224H321.6C342.4 224 360.9 237.4 367.3 257.2L390.6 329.1C405.9 339.1 416 356.4 416 376V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V480H128V496C128 504.8 120.8 512 112 512C103.2 512 96 504.8 96 496V376C96 356.4 106.1 339.1 121.4 329.1V329.1zM158 320H353.1L336.8 267.1C334.7 260.5 328.6 256 321.6 256H190.4C183.4 256 177.3 260.5 175.2 267.1L158 320zM128 448H384V376C384 362.7 373.3 352 360 352H152C138.7 352 128 362.7 128 376V448z"],
    "car-wash": [448, 512, [], "f5e6", "M64 0C64 0 74.14 10.14 85.1 24.21C97.98 40.74 112 62.71 112 80C112 112 90.51 128 64 128C37.49 128 16 106.5 16 80C16 62.71 30.02 40.74 42.9 24.21C53.86 10.14 64 0 64 0V0zM76.26 92.46C77.42 91.39 80 88.43 80 80C80 79.25 79.47 75.5 75.88 68.31C72.88 62.31 68.7 55.8 64 49.36C59.3 55.8 55.12 62.31 52.12 68.31C48.53 75.5 48 79.25 48 80C48 88.84 55.16 96 64 96C70.1 96 74.67 93.93 76.26 92.46zM176 80C176 62.71 190 40.74 202.9 24.21C213.9 10.14 224 0 224 0C224 0 234.1 10.14 245.1 24.21C257.1 40.74 272 62.71 272 80C272 112 250.5 128 224 128C197.5 128 176 106.5 176 80zM235.9 68.31C232.9 62.31 228.7 55.8 224 49.36C219.3 55.8 215.1 62.31 212.1 68.31C208.5 75.5 208 79.25 208 80C208 88.84 215.2 96 224 96C230.1 96 234.7 93.93 236.3 92.46C237.4 91.39 240 88.43 240 80C240 79.25 239.5 75.5 235.9 68.31zM88 376C88 362.7 98.75 352 112 352C125.3 352 136 362.7 136 376C136 389.3 125.3 400 112 400C98.75 400 88 389.3 88 376zM360 376C360 389.3 349.3 400 336 400C322.7 400 312 389.3 312 376C312 362.7 322.7 352 336 352C349.3 352 360 362.7 360 376zM156.2 176H291.8C320.4 176 345.5 194.9 353.3 222.4L374.1 298.1C399.4 311.8 416 337.1 416 368V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V464H64V496C64 504.8 56.84 512 48 512C39.16 512 32 504.8 32 496V368C32 337.1 48.56 311.8 73.04 298.1L94.67 222.4C102.5 194.9 127.6 176 156.2 176V176zM156.2 208C141.9 208 129.4 217.5 125.4 231.2L109.2 288C110.1 288 111.1 288 112 288H336C336.9 288 337.9 288 338.8 288L322.6 231.2C318.6 217.5 306.1 208 291.8 208H156.2zM384 368C384 341.5 362.5 320 336 320H112C85.49 320 64 341.5 64 368V432H384V368zM336 80C336 62.71 350 40.74 362.9 24.21C373.9 10.14 384 0 384 0C384 0 394.1 10.14 405.1 24.21C417.1 40.74 432 62.71 432 80C432 112 410.5 128 384 128C357.5 128 336 106.5 336 80zM395.9 68.31C392.9 62.31 388.7 55.8 384 49.36C379.3 55.8 375.1 62.31 372.1 68.31C368.5 75.5 368 79.25 368 80C368 88.84 375.2 96 384 96C390.1 96 394.7 93.93 396.3 92.46C397.4 91.39 400 88.43 400 80C400 79.25 399.5 75.5 395.9 68.31z"],
    "car-wrench": [576, 512, ["car-mechanic"], "f5e3", "M32 96C32 47.4 71.4 8 120 8C150.9 8 178.1 23.94 193.8 48H382.2C397.9 23.94 425.1 8 456 8C504.6 8 544 47.4 544 96C544 144.6 504.6 184 456 184C425.1 184 397.9 168.1 382.2 144H193.8C178.1 168.1 150.9 184 120 184C71.4 184 32 144.6 32 96zM120 40C94.63 40 73.2 56.87 66.32 80H112C120.8 80 128 87.16 128 96C128 104.8 120.8 112 112 112H66.32C73.2 135.1 94.63 152 120 152C141.1 152 161 139.4 170.2 120.9L174.6 112H401.4L405.8 120.9C414.1 139.4 434 152 456 152C481.4 152 502.8 135.1 509.7 112H464C455.2 112 448 104.8 448 96C448 87.16 455.2 80 464 80H509.7C502.8 56.87 481.4 40 456 40C434 40 414.1 52.64 405.8 71.12L401.4 80H174.6L170.2 71.12C161 52.64 141.1 40 120 40V40zM152 376C152 362.7 162.7 352 176 352C189.3 352 200 362.7 200 376C200 389.3 189.3 400 176 400C162.7 400 152 389.3 152 376zM424 376C424 389.3 413.3 400 400 400C386.7 400 376 389.3 376 376C376 362.7 386.7 352 400 352C413.3 352 424 362.7 424 376zM220.2 176H355.8C384.4 176 409.5 194.9 417.3 222.4L438.1 298.1C463.4 311.8 480 337.1 480 368V496C480 504.8 472.8 512 464 512C455.2 512 448 504.8 448 496V464H128V496C128 504.8 120.8 512 112 512C103.2 512 96 504.8 96 496V368C96 337.1 112.6 311.8 137 298.1L158.7 222.4C166.5 194.9 191.6 176 220.2 176V176zM220.2 208C205.9 208 193.4 217.5 189.4 231.2L173.2 288C174.1 288 175.1 288 176 288H400C400.9 288 401.9 288 402.8 288L386.6 231.2C382.6 217.5 370.1 208 355.8 208H220.2zM448 368C448 341.5 426.5 320 400 320H176C149.5 320 128 341.5 128 368V432H448V368z"],
    "caravan": [640, 512, [], "f8ff", "M96 160C96 142.3 110.3 128 128 128H256C273.7 128 288 142.3 288 160V224C288 241.7 273.7 256 256 256H128C110.3 256 96 241.7 96 224V160zM128 224H256V160H128V224zM0 336V112C0 67.82 35.82 32 80 32H416C504.4 32 576 103.6 576 192V384H624C632.8 384 640 391.2 640 400C640 408.8 632.8 416 624 416H288C288 469 245 512 192 512C138.1 512 96 469 96 416H80C35.82 416 0 380.2 0 336zM416 64H80C53.49 64 32 85.49 32 112V336C32 362.5 53.49 384 80 384H101.5C114.6 346.7 150.2 320 192 320C233.8 320 269.4 346.7 282.5 384H320V168C320 145.9 337.9 128 360 128H440C462.1 128 480 145.9 480 168V384H544V192C544 121.3 486.7 64 416 64zM448 224V168C448 163.6 444.4 160 440 160H360C355.6 160 352 163.6 352 168V384H448V256H416C407.2 256 400 248.8 400 240C400 231.2 407.2 224 416 224H448zM192 480C227.3 480 256 451.3 256 416C256 380.7 227.3 352 192 352C156.7 352 128 380.7 128 416C128 451.3 156.7 480 192 480z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M256 128C273.7 128 288 142.3 288 160V224C288 241.7 273.7 256 256 256H128C110.3 256 96 241.7 96 224V160C96 142.3 110.3 128 128 128H256zM256 160H128V224H256V160zM320 160C320 142.3 334.3 128 352 128H416C433.7 128 448 142.3 448 160V224C448 241.7 433.7 256 416 256H352C334.3 256 320 241.7 320 224V160zM352 224H416V160H352V224zM96 416H80C35.82 416 0 380.2 0 336V112C0 67.82 35.82 32 80 32H416C504.4 32 576 103.6 576 192V384H624C632.8 384 640 391.2 640 400C640 408.8 632.8 416 624 416H288C288 469 245 512 192 512C138.1 512 96 469 96 416zM32 112V336C32 362.5 53.49 384 80 384H101.5C114.6 346.7 150.2 320 192 320C233.8 320 269.4 346.7 282.5 384H544V192C544 121.3 486.7 64 416 64H80C53.49 64 32 85.49 32 112zM192 352C156.7 352 128 380.7 128 416C128 451.3 156.7 480 192 480C227.3 480 256 451.3 256 416C256 380.7 227.3 352 192 352z"],
    "card-club": [384, 512, [], "e3e9", "M208 352H224C232.8 352 240 359.2 240 368C240 376.8 232.8 384 224 384H160C151.2 384 144 376.8 144 368C144 359.2 151.2 352 160 352H176V331.9C168.5 334.6 160.4 336 152 336C112.2 336 80 303.8 80 264C80 235.7 96.3 211.3 120 199.5C120.3 159.1 152.4 128 192 128C231.6 128 263.7 159.1 263.1 199.5C287.7 211.3 304 235.7 304 264C304 303.8 271.8 336 232 336C223.6 336 215.5 334.6 208 331.9V352zM152.6 207.2L155.2 221.5L141.2 225.5C124.3 230.2 112 245.7 112 264C112 286.1 129.9 304 152 304C163.2 304 173.3 299.4 180.6 291.1L192 280.3L203.4 291.1C210.7 299.4 220.8 304 232 304C254.1 304 272 286.1 272 264C272 245.7 259.7 230.2 242.8 225.5L228.8 221.5L231.4 207.2C231.8 204.9 232 202.5 232 200C232 177.9 214.1 160 192 160C169.9 160 152 177.9 152 200C152 202.5 152.2 204.9 152.6 207.2V207.2zM320 0C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320zM320 32H64C46.33 32 32 46.33 32 64V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32z"],
    "card-diamond": [384, 512, [], "e3ea", "M299.3 244.7C305.6 250.9 305.6 261.1 299.3 267.3L203.3 363.3C197.1 369.6 186.9 369.6 180.7 363.3L84.69 267.3C78.44 261.1 78.44 250.9 84.69 244.7L180.7 148.7C186.9 142.4 197.1 142.4 203.3 148.7L299.3 244.7zM265.4 256L192 182.6L118.6 256L192 329.4L265.4 256zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM32 64V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64z"],
    "card-heart": [384, 512, [], "e3eb", "M90.61 261.5C64.4 234.9 65.8 190.9 95.3 166.1C117.3 147.4 149.5 148 172.9 163.9C176.4 166.2 179.8 168.1 182.8 172.1L192.2 181.7L201.1 172.1C203.7 169.5 206.4 167.1 209.3 165C232.8 148.1 265.8 146.9 289.1 166.1C318.2 190.9 319.6 234.9 293.3 261.5L202.1 353.2C196.9 359.2 187.1 359.2 181.4 353.2L90.61 261.5zM268.6 190.6C256.5 180.9 237.1 181.7 224.1 194.3L192.8 228.2L160.1 194.5C146.8 181.4 126.9 181.2 116.1 190.4L115.9 190.6C100.9 203.2 100.2 225.6 113.4 239L192.2 318.6L270.5 239C283.8 225.6 283.1 203.3 268.6 190.6L268.6 190.6zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM32 64V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64z"],
    "card-spade": [384, 512, [], "e3ec", "M181 134.6C187.1 128.5 196.9 128.5 202.6 134.6L293.4 228.2C319.6 255.4 318.2 300.3 288.7 325.6C267.6 343.1 237.2 344.1 214 329.8C211.1 328.5 209.9 327.1 207.1 325.6V351.1H223.1C232.8 351.1 239.1 359.2 239.1 367.1C239.1 376.8 232.8 383.1 223.1 383.1H159.1C151.2 383.1 143.1 376.8 143.1 367.1C143.1 359.2 151.2 351.1 159.1 351.1H175.1V325.7C174.7 326.7 173.3 327.7 171.9 328.6C148.7 344.1 117.3 344.5 94.88 325.6C65.85 300.3 64.45 255.4 90.66 228.2L181 134.6zM113.7 250.4C100.1 264.5 100.8 288.1 115.7 301.3C127.6 311.1 146.7 310.4 159.7 297.5L191.2 262.7L224.1 297.3C237.4 310.7 257 310.8 267.7 301.5L267.9 301.3C283.2 288.2 283.1 264.6 270.4 250.5L191.8 169.5L113.7 250.4zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM32 64V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V64C352 46.33 337.7 32 320 32H64C46.33 32 32 46.33 32 64z"],
    "cards": [640, 512, [], "e3ed", "M300.4 312.6C308.1 308.2 317.9 310.8 322.3 318.5C326.7 326.1 324.1 335.9 316.4 340.3L268.2 368.2C260.6 372.6 250.8 369.1 246.4 362.3C241.1 354.7 244.6 344.9 252.2 340.4L300.4 312.6zM174.5 169.3C176.5 162.1 183.9 157.8 190.8 159.9L299.9 190.1C331.5 200 349.1 234.5 338.8 266.4C330.9 289.4 307.1 302.7 284.3 302C279.6 301.9 274.8 301.2 270.1 299.9L258.8 296.6L256.4 307.8C255.4 311.9 253.9 315.8 252.1 319.4C241.3 341.2 217.8 355.1 192.7 350.7C159.9 344.3 139.3 311 147.2 279.2L174.5 169.3zM178.2 286.9C174.7 301.1 184.1 316.2 198.6 319.2C209.4 320.1 221.6 313.8 225.3 300.4L234.8 256.1L278.9 269.1C292.1 272.9 305.3 265.2 308.5 255.1L308.6 255.8C313.6 241.5 305.2 225.8 291.1 221.7L200.8 196.1L178.2 286.9zM174.8 484.7C174.7 484.5 174.5 484.2 174.3 483.9L7.629 195.2C7.464 194.9 7.302 194.6 7.142 194.3C-7.774 167.8 1.408 134.1 27.85 118.8L220.7 7.468C247.3-7.906 281.4 1.218 296.8 27.85L463.8 317.1C479.1 343.6 470.1 377.5 443.8 392.1C443.6 393.1 443.3 393.2 443.1 393.4L250.8 504.4C250.6 504.5 250.4 504.6 250.1 504.8C223.8 519.7 190.3 510.8 174.8 484.7V484.7zM234.4 476.9C234.5 476.9 234.5 476.8 234.5 476.8L427.4 365.5C427.4 365.5 427.5 365.4 427.5 365.4C438.7 358.7 442.5 344.2 435.9 332.9L269.2 44.13C262.6 32.66 247.9 28.72 236.4 35.35L44.13 146.4C32.8 152.9 28.82 167.3 35.09 178.7C35.12 178.8 35.15 178.8 35.18 178.9L202.2 468.2C202.2 468.2 202.3 468.3 202.3 468.3C208.1 479.3 223.2 483.1 234.4 476.9V476.9zM360 512C346.4 512 333.8 507.1 324.1 498.1L357.3 479.8C358.2 479.9 359.1 480 360 480H584C597.3 480 608 469.3 608 456V119.1C608 106.7 597.3 95.1 584 95.1H373L354.7 64.25C356.5 64.08 358.2 63.1 360 63.1H584C614.9 63.1 640 89.07 640 119.1V456C640 486.9 614.9 512 584 512L360 512zM448.4 138.6C464.9 124.3 487.8 125.3 503.1 136.4C520.2 125.3 542.9 124.4 559.6 138.5L559.8 138.6C580.4 156.5 581.3 188.1 562.8 207.3L520.4 251.2C511.7 259.1 496.7 260.7 487.5 250.9L445.2 207.3C426.7 188.1 427.6 156.5 448.4 138.6L448.4 138.6zM469.3 162.9C462.6 168.6 462.3 178.9 468.2 185.1L504.1 222.1L539.8 185.1C545.7 178.9 545.4 168.6 538.9 162.9C533.9 158.7 525.6 158.9 519.9 164.6L504.4 181.7L488.2 164.7C482.4 158.8 473.9 158.9 469.4 162.8L469.3 162.9z"],
    "cards-blank": [640, 512, [], "e4df", "M174.8 484.7C174.7 484.5 174.5 484.2 174.3 483.9L7.629 195.2C7.464 194.9 7.302 194.6 7.142 194.3C-7.774 167.8 1.408 134.1 27.85 118.8L220.7 7.468C247.3-7.906 281.4 1.218 296.8 27.85L463.8 317.1C479.1 343.6 470.1 377.5 443.8 392.1C443.6 393.1 443.3 393.2 443.1 393.4L250.8 504.4C250.6 504.5 250.4 504.6 250.1 504.8C223.8 519.7 190.3 510.8 174.8 484.7V484.7zM234.4 476.9L234.5 476.8L427.4 365.5L427.5 365.4C438.7 358.7 442.5 344.2 435.9 332.9L269.2 44.13C262.6 32.66 247.9 28.72 236.4 35.35L44.13 146.4C32.8 152.9 28.82 167.3 35.09 178.7L35.18 178.9L202.2 468.2C202.2 468.2 202.3 468.3 202.3 468.3C208.1 479.3 223.2 483.1 234.4 476.9V476.9zM357.3 479.8C358.2 479.9 359.1 480 360 480H584C597.3 480 608 469.3 608 456V119.1C608 106.7 597.3 95.1 584 95.1H373L354.7 64.25C356.5 64.08 358.2 63.1 360 63.1H584C614.9 63.1 640 89.07 640 119.1V456C640 486.9 614.9 512 584 512H360C346.4 512 333.8 507.1 324.1 498.1L357.3 479.8z"],
    "caret-down": [320, 512, [], "f0d7", "M287.1 192H32c-28.37 0-42.74 34.5-22.62 54.63l127.1 128c12.5 12.5 32.75 12.5 45.25 0l127.1-128C330.7 226.5 316.5 192 287.1 192zM159.1 352L32.01 224h255.9L159.1 352z"],
    "caret-left": [256, 512, [], "f0d9", "M192 383.1v-255.1c0-28.37-34.5-42.74-54.63-22.62l-128 127.1c-12.5 12.5-12.5 32.75 0 45.25l128 127.1C157.5 426.7 192 412.5 192 383.1zM32 255.1l128-127.1v255.9L32 255.1z"],
    "caret-right": [256, 512, [], "f0da", "M64 128v255.1c0 28.37 34.5 42.74 54.63 22.62l128-127.1c12.5-12.5 12.5-32.75 0-45.25l-128-127.1C98.5 85.27 64 99.52 64 128zM224 256l-128 127.1V128L224 256z"],
    "caret-up": [320, 512, [], "f0d8", "M32.01 320h255.1c28.37 0 42.74-34.5 22.62-54.63l-127.1-128c-12.5-12.5-32.75-12.5-45.25 0l-127.1 128C-10.73 285.5 3.519 320 32.01 320zM160 160l127.1 128H32.04L160 160z"],
    "carrot": [512, 512, [129365], "f787", "M504.6 138.6c-22.87-27.63-53.37-43.38-86.36-44.75c-1.625-32.13-17.12-63.5-44.74-86.38c-16.33-13.55-34.16-5.465-40.74 0c-27.25 22.63-43.12 53-44.62 85.88c-.75 14.5 1.75 28.63 6.625 42.13c-13.37-4.377-26.85-7.327-40.35-7.327c-47.99 0-94.11 26.76-116.6 72.76l-135.4 277.5c-9.631 20.06 11.33 40.88 31.31 31.25l277.5-135.5c24.1-12.25 46.43-32.63 59.55-59.63c15.5-31.5 16.73-66.13 6.48-97.13c11.87 4.125 23.1 6.627 36.5 6.627c34.62 0 66.99-15.88 90.86-44.63C514.5 167.6 514.5 150.3 504.6 138.6zM342.1 300.6c-9.623 19.75-25.25 35.25-44.87 44.88l-124.6 60.75L139.2 372.8c-6.125-6.248-16.38-6.248-22.5 0c-6.248 6.125-6.248 16.38 0 22.5l25.54 25.67l-100.1 49l111.9-229.3l26.63 26.58c6.07 6.322 16.5 6.334 22.58 0c6.248-6.125 6.248-16.46 0-22.58l-34.18-34.08c17.19-31.22 49.39-50.54 85.32-50.54c14.87 0 29.25 3.25 42.74 9.875c23.37 11.38 40.99 31.38 49.49 56C355.1 250.7 353.5 277.1 342.1 300.6zM413.7 192.1c-21.5 0-42.99-8.875-60.49-26.5l-6.748-6.75c-37.24-37-35.37-92 6.623-126.8c33.12 27.5 41.49 67.63 25.25 101.6c11.25-5.373 22.1-8 34.87-8c24.12 0 48.37 11.13 66.74 33.25C461.7 181.1 437.7 192.1 413.7 192.1z"],
    "cars": [640, 512, [], "f85b", "M124.2 0H259.8C288.4 0 313.5 18.94 321.3 46.42L342.1 122.1C353 127.7 361.7 135.5 368.5 144.7C356.6 146.2 345.3 149.8 334.1 155.3C326.6 148.3 315.8 144 304 144H80C53.49 144 32 165.5 32 192V256H275.8L269.6 277.8C265.3 280.9 261.4 284.3 257.6 288H32V320C32 328.8 24.84 336 16 336C7.164 336 0 328.8 0 320V192C0 161.1 16.56 135.8 41.04 122.1L62.67 46.42C70.52 18.94 95.63 0 124.2 0V0zM124.2 32C109.9 32 97.36 41.47 93.44 55.21L77.2 112C78.13 112 79.06 112 80 112H304C304.9 112 305.9 112 306.8 112L290.6 55.21C286.6 41.47 274.1 32 259.8 32H124.2zM56 200C56 186.7 66.75 176 80 176C93.25 176 104 186.7 104 200C104 213.3 93.25 224 80 224C66.75 224 56 213.3 56 200zM312 376C312 362.7 322.7 352 336 352C349.3 352 360 362.7 360 376C360 389.3 349.3 400 336 400C322.7 400 312 389.3 312 376zM584 376C584 389.3 573.3 400 560 400C546.7 400 536 389.3 536 376C536 362.7 546.7 352 560 352C573.3 352 584 362.7 584 376zM380.2 176H515.8C544.4 176 569.5 194.9 577.3 222.4L598.1 298.1C623.4 311.8 640 337.1 640 368V496C640 504.8 632.8 512 624 512C615.2 512 608 504.8 608 496V464H287.1V496C287.1 504.8 280.8 512 271.1 512C263.2 512 255.1 504.8 255.1 496V368C255.1 337.1 272.6 311.8 297 298.1L318.7 222.4C326.5 194.9 351.6 176 380.2 176H380.2zM380.2 208C365.9 208 353.4 217.5 349.4 231.2L333.2 288C334.1 288 335.1 288 336 288H560C560.9 288 561.9 288 562.8 288L546.6 231.2C542.6 217.5 530.1 208 515.8 208H380.2zM608 368C608 341.5 586.5 320 560 320H336C309.5 320 288 341.5 288 368V432H608V368z"],
    "cart-arrow-down": [576, 512, [], "f218", "M100 32H287.1V64H107.3L150.1 256H487.8L541.8 64H384V32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 0 16 0H80C87.47 0 93.95 5.17 95.6 12.45L100 32zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456zM456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432zM352 153.4L388.7 116.7C394.9 110.4 405.1 110.4 411.3 116.7C417.6 122.9 417.6 133.1 411.3 139.3L347.3 203.3C341.1 209.6 330.9 209.6 324.7 203.3L260.7 139.3C254.4 133.1 254.4 122.9 260.7 116.7C266.9 110.4 277.1 110.4 283.3 116.7L320 153.4V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16L352 153.4z"],
    "cart-arrow-up": [576, 512, [], "e3ee", "M487.8 256L541.8 64H419.9L387.9 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 0 16 0H80C87.47 0 93.95 5.17 95.6 12.45L100 32H284.1L252.1 64H107.3L150.1 256H487.8zM128 456C128 425.1 153.1 400 184 400C214.9 400 240 425.1 240 456C240 486.9 214.9 512 184 512C153.1 512 128 486.9 128 456zM184 480C197.3 480 208 469.3 208 456C208 442.7 197.3 432 184 432C170.7 432 160 442.7 160 456C160 469.3 170.7 480 184 480zM512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456zM456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432zM320 86.63L283.3 123.3C277.1 129.6 266.9 129.6 260.7 123.3C254.4 117.1 254.4 106.9 260.7 100.7L324.7 36.69C330.9 30.44 341.1 30.44 347.3 36.69L411.3 100.7C417.6 106.9 417.6 117.1 411.3 123.3C405.1 129.6 394.9 129.6 388.7 123.3L352 86.63V208C352 216.8 344.8 224 336 224C327.2 224 320 216.8 320 208L320 86.63z"],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM563.3 364.7C569.6 370.9 569.6 381.1 563.3 387.3L507.3 443.3C501.1 449.6 490.9 449.6 484.7 443.3L428.7 387.3C422.4 381.1 422.4 370.9 428.7 364.7C434.9 358.4 445.1 358.4 451.3 364.7L480 393.4V304C480 295.2 487.2 288 496 288C504.8 288 512 295.2 512 304V393.4L540.7 364.7C546.9 358.4 557.1 358.4 563.3 364.7H563.3zM496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224zM384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368z"],
    "cart-circle-arrow-up": [640, 512, [], "e3f0", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM428.7 371.3C422.4 365.1 422.4 354.9 428.7 348.7L484.7 292.7C490.9 286.4 501.1 286.4 507.3 292.7L563.3 348.7C569.6 354.9 569.6 365.1 563.3 371.3C557.1 377.6 546.9 377.6 540.7 371.3L512 342.6V432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432V342.6L451.3 371.3C445.1 377.6 434.9 377.6 428.7 371.3H428.7zM496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512zM608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368z"],
    "cart-circle-check": [640, 512, [], "e3f1", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM563.3 324.7C569.6 330.9 569.6 341.1 563.3 347.3L491.3 419.3C485.1 425.6 474.9 425.6 468.7 419.3L428.7 379.3C422.4 373.1 422.4 362.9 428.7 356.7C434.9 350.4 445.1 350.4 451.3 356.7L480 385.4L540.7 324.7C546.9 318.4 557.1 318.4 563.3 324.7H563.3zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480z"],
    "cart-circle-exclamation": [640, 512, [], "e3f2", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM480 432C480 423.2 487.2 416 496 416C504.8 416 512 423.2 512 432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432zM495.1 288C504.8 288 511.1 295.2 511.1 304V384C511.1 392.8 504.8 400 495.1 400C487.2 400 479.1 392.8 479.1 384V304C479.1 295.2 487.2 288 495.1 288zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "cart-circle-plus": [640, 512, [], "e3f3", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM512 351.1H560C568.8 351.1 576 359.2 576 367.1C576 376.8 568.8 383.1 560 383.1H512V431.1C512 440.8 504.8 447.1 496 447.1C487.2 447.1 480 440.8 480 431.1V383.1H432C423.2 383.1 416 376.8 416 367.1C416 359.2 423.2 351.1 432 351.1H480V303.1C480 295.2 487.2 287.1 496 287.1C504.8 287.1 512 295.2 512 303.1V351.1zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "cart-circle-xmark": [640, 512, [], "e3f4", "M79.1 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C527.3 194.4 516.6 192.9 505.7 192.3L541.8 64H107.3L150.1 256H360.2C352.1 265.8 345 276.6 339.2 288H158.2L172.8 352H320.7C320.2 357.3 320 362.6 320 368C320 373.4 320.2 378.7 320.7 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 .0003 16 .0003L79.1 0zM127.1 456C127.1 425.1 153.1 400 183.1 400C214.9 400 239.1 425.1 239.1 456C239.1 486.9 214.9 512 183.1 512C153.1 512 127.1 486.9 127.1 456zM183.1 480C197.3 480 207.1 469.3 207.1 456C207.1 442.7 197.3 432 183.1 432C170.7 432 159.1 442.7 159.1 456C159.1 469.3 170.7 480 183.1 480zM518.6 368L555.3 404.7C561.6 410.9 561.6 421.1 555.3 427.3C549.1 433.6 538.9 433.6 532.7 427.3L496 390.6L459.3 427.3C453.1 433.6 442.9 433.6 436.7 427.3C430.4 421.1 430.4 410.9 436.7 404.7L473.4 368L436.7 331.3C430.4 325.1 430.4 314.9 436.7 308.7C442.9 302.4 453.1 302.4 459.3 308.7L496 345.4L532.7 308.7C538.9 302.4 549.1 302.4 555.3 308.7C561.6 314.9 561.6 325.1 555.3 331.3L518.6 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 256C434.1 256 384 306.1 384 368C384 429.9 434.1 480 496 480C557.9 480 608 429.9 608 368C608 306.1 557.9 256 496 256z"],
    "cart-flatbed": [640, 512, ["dolly-flatbed"], "f474", "M256 320h288c35.35 0 64-28.65 64-64V96c0-35.35-28.65-63.1-64-63.1H256c-35.35 0-64 28.65-64 63.1V256C192 291.3 220.7 320 256 320zM368 64h64v82.11l-23.12-15.42c-5.375-3.594-12.38-3.594-17.75 0L368 146.1V64zM224 96c0-17.64 14.36-32 32-32h80v112c0 5.906 3.25 11.33 8.453 14.11c5.188 2.781 11.52 2.469 16.42-.7969L400 163.2l39.13 26.08C441.8 191.1 444.9 192 448 192c2.594 0 5.188-.625 7.547-1.891C460.8 187.3 464 181.9 464 176V64H544c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H256C238.4 288 224 273.6 224 256V96zM624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-boxes": [640, 512, ["dolly-flatbed-alt"], "f475", "M448 160h64c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32h-64c-17.67 0-32 14.33-32 32v64C416 145.7 430.3 160 448 160zM448 64h64v64h-64V64zM224 320h128c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32H224C206.3 32 192 46.33 192 64v224C192 305.7 206.3 320 224 320zM224 64h128v224H224V64zM448 320h128c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32h-128c-17.67 0-32 14.33-32 32v64C416 305.7 430.3 320 448 320zM448 224h128v64h-128V224zM624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-empty": [640, 512, ["dolly-flatbed-empty"], "f476", "M624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-suitcase": [640, 512, ["luggage-cart"], "f59d", "M624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.86 51.24c7.027 22.4 26.86 40 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.72 74.93 63.1c23.17-3.818 43.01-21.44 50.04-43.85C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480zM256 320h256c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64h-32V48C480 21.53 458.5 0 432 0h-96C309.5 0 288 21.53 288 48V64H256C220.7 64 192 92.65 192 128v128C192 291.3 220.7 320 256 320zM512 96c17.64 0 32 14.36 32 32v128c0 17.64-14.36 32-32 32V96zM320 48C320 39.17 327.2 32 336 32h96C440.8 32 448 39.17 448 48V64h-128V48zM288 96h192v192H288V96zM224 128c0-17.64 14.36-32 32-32v192C238.4 288 224 273.6 224 256V128z"],
    "cart-minus": [576, 512, [], "e0db", "M384 144C392.8 144 400 151.2 400 160C400 168.8 392.8 176 384 176H256C247.2 176 240 168.8 240 160C240 151.2 247.2 144 256 144H384zM0 16C0 7.164 7.164 0 16 0H80C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16V16zM487.8 256L541.8 64H107.3L150.1 256H487.8zM240 456C240 486.9 214.9 512 184 512C153.1 512 128 486.9 128 456C128 425.1 153.1 400 184 400C214.9 400 240 425.1 240 456zM184 432C170.7 432 160 442.7 160 456C160 469.3 170.7 480 184 480C197.3 480 208 469.3 208 456C208 442.7 197.3 432 184 432zM400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456zM456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480z"],
    "cart-plus": [576, 512, [], "f217", "M240 160C240 151.2 247.2 144 256 144H304V96C304 87.16 311.2 80 320 80C328.8 80 336 87.16 336 96V144H384C392.8 144 400 151.2 400 160C400 168.8 392.8 176 384 176H336V224C336 232.8 328.8 240 320 240C311.2 240 304 232.8 304 224V176H256C247.2 176 240 168.8 240 160zM80 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 0 16 0H80zM107.3 64L150.1 256H487.8L541.8 64H107.3zM128 456C128 425.1 153.1 400 184 400C214.9 400 240 425.1 240 456C240 486.9 214.9 512 184 512C153.1 512 128 486.9 128 456zM184 480C197.3 480 208 469.3 208 456C208 442.7 197.3 432 184 432C170.7 432 160 442.7 160 456C160 469.3 170.7 480 184 480zM512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456zM456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432z"],
    "cart-shopping": [576, 512, [128722, "shopping-cart"], "f07a", "M80 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 0 16 0H80zM107.3 64L150.1 256H487.8L541.8 64H107.3zM128 456C128 425.1 153.1 400 184 400C214.9 400 240 425.1 240 456C240 486.9 214.9 512 184 512C153.1 512 128 486.9 128 456zM184 480C197.3 480 208 469.3 208 456C208 442.7 197.3 432 184 432C170.7 432 160 442.7 160 456C160 469.3 170.7 480 184 480zM512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456zM456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M64 16C64 7.164 71.16 0 80 0H144C151.5 0 157.9 5.17 159.6 12.45L164 32H605.8C626.1 32 642.3 52.25 636.6 72.66L582.6 264.7C578.7 278.5 566.1 288 551.8 288H222.2L236.8 352H560C568.8 352 576 359.2 576 368C576 376.8 568.8 384 560 384H224C216.5 384 210.1 378.8 208.4 371.5L131.2 32H80C71.16 32 64 24.84 64 16zM605.8 64H171.3L214.1 256H551.8L605.8 64zM304 456C304 486.9 278.9 512 248 512C217.1 512 192 486.9 192 456C192 425.1 217.1 400 248 400C278.9 400 304 425.1 304 456zM248 432C234.7 432 224 442.7 224 456C224 469.3 234.7 480 248 480C261.3 480 272 469.3 272 456C272 442.7 261.3 432 248 432zM464 456C464 425.1 489.1 400 520 400C550.9 400 576 425.1 576 456C576 486.9 550.9 512 520 512C489.1 512 464 486.9 464 456zM520 480C533.3 480 544 469.3 544 456C544 442.7 533.3 432 520 432C506.7 432 496 442.7 496 456C496 469.3 506.7 480 520 480zM112 128C120.8 128 128 135.2 128 144C128 152.8 120.8 160 112 160H16C7.164 160 0 152.8 0 144C0 135.2 7.164 128 16 128H112zM128 192C136.8 192 144 199.2 144 208C144 216.8 136.8 224 128 224H16C7.164 224 0 216.8 0 208C0 199.2 7.164 192 16 192H128zM144 256C152.8 256 160 263.2 160 272C160 280.8 152.8 288 144 288H16C7.164 288 0 280.8 0 272C0 263.2 7.164 256 16 256H144z"],
    "cart-xmark": [576, 512, [], "e0dd", "M263.4 103.4C269.7 97.18 279.8 97.18 286.1 103.4L320 137.4L353.9 103.4C360.2 97.18 370.3 97.18 376.6 103.4C382.8 109.7 382.8 119.8 376.6 126.1L342.6 160L376.6 193.9C382.8 200.2 382.8 210.3 376.6 216.6C370.3 222.8 360.2 222.8 353.9 216.6L320 182.6L286.1 216.6C279.8 222.8 269.7 222.8 263.4 216.6C257.2 210.3 257.2 200.2 263.4 193.9L297.4 160L263.4 126.1C257.2 119.8 257.2 109.7 263.4 103.4zM80 0C87.47 0 93.95 5.17 95.6 12.45L100 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H158.2L172.8 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H160C152.5 384 146.1 378.8 144.4 371.5L67.23 32H16C7.164 32 0 24.84 0 16C0 7.164 7.164 0 16 0H80zM107.3 64L150.1 256H487.8L541.8 64H107.3zM128 456C128 425.1 153.1 400 184 400C214.9 400 240 425.1 240 456C240 486.9 214.9 512 184 512C153.1 512 128 486.9 128 456zM184 480C197.3 480 208 469.3 208 456C208 442.7 197.3 432 184 432C170.7 432 160 442.7 160 456C160 469.3 170.7 480 184 480zM512 456C512 486.9 486.9 512 456 512C425.1 512 400 486.9 400 456C400 425.1 425.1 400 456 400C486.9 400 512 425.1 512 456zM456 432C442.7 432 432 442.7 432 456C432 469.3 442.7 480 456 480C469.3 480 480 469.3 480 456C480 442.7 469.3 432 456 432z"],
    "cash-register": [512, 512, [], "f788", "M136 256C136 269.3 125.3 280 112 280C98.75 280 88 269.3 88 256C88 242.7 98.75 232 112 232C125.3 232 136 242.7 136 256zM184 256C184 242.7 194.7 232 208 232C221.3 232 232 242.7 232 256C232 269.3 221.3 280 208 280C194.7 280 184 269.3 184 256zM184 336C184 349.3 173.3 360 160 360C146.7 360 136 349.3 136 336C136 322.7 146.7 312 160 312C173.3 312 184 322.7 184 336zM280 256C280 242.7 290.7 232 304 232C317.3 232 328 242.7 328 256C328 269.3 317.3 280 304 280C290.7 280 280 269.3 280 256zM280 336C280 349.3 269.3 360 256 360C242.7 360 232 349.3 232 336C232 322.7 242.7 312 256 312C269.3 312 280 322.7 280 336zM376 256C376 242.7 386.7 232 400 232C413.3 232 424 242.7 424 256C424 269.3 413.3 280 400 280C386.7 280 376 269.3 376 256zM376 336C376 349.3 365.3 360 352 360C338.7 360 328 349.3 328 336C328 322.7 338.7 312 352 312C365.3 312 376 322.7 376 336zM272 0C298.5 0 320 21.49 320 48V80C320 106.5 298.5 128 272 128H192V160H424.5C456.3 160 483.3 183.4 487.8 214.9L511.4 379.5C511.8 382.5 512 385.5 512 388.5V448C512 483.3 483.3 512 448 512H64C28.65 512 0 483.3 0 448V388.5C0 385.5 .215 382.5 .6432 379.5L24.15 214.9C28.65 183.4 55.66 160 87.51 160H160V128H80C53.49 128 32 106.5 32 80V48C32 21.49 53.49 0 80 0L272 0zM272 32H80C71.16 32 64 39.16 64 48V80C64 88.84 71.16 96 80 96H272C280.8 96 288 88.84 288 80V48C288 39.16 280.8 32 272 32zM64 480H448C465.7 480 480 465.7 480 448V416H32V448C32 465.7 46.33 480 64 480zM424.5 192H87.51C71.58 192 58.08 203.7 55.83 219.5L32.32 384H479.7L456.2 219.5C453.9 203.7 440.4 192 424.5 192H424.5z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h512V416zM544 128H32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V128zM352 384h96c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v96C320 369.7 334.3 384 352 384zM352 256h96v96h-96V256zM176 400c53.02 0 96-42.98 96-96s-42.98-96-96-96s-96 42.98-96 96S122.1 400 176 400zM176 240c35.29 0 64 28.71 64 64c0 35.29-28.71 64-64 64s-64-28.71-64-64C112 268.7 140.7 240 176 240zM176 328c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C152 317.3 162.7 328 176 328z"],
    "cassette-tape": [576, 512, [128429], "f8ab", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM134.2 448l17.7-53.06C154.1 388.4 160.2 384 167.1 384h241.9c6.906 0 13 4.375 15.16 10.94L441.8 448H134.2zM544 416c0 17.64-14.36 32-32 32h-36.46l-21.07-63.19C447.9 365.2 429.6 352 408.9 352H167.1c-20.69 0-39 13.19-45.53 32.81L100.5 448H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM416 160H160C124.7 160 96 188.7 96 224s28.65 64 64 64h256c35.35 0 64-28.65 64-64S451.3 160 416 160zM160 256C142.4 256 128 241.6 128 224s14.36-32 32-32s32 14.36 32 32S177.6 256 160 256zM360.9 256H215.1C220.6 246.6 224 235.7 224 224S220.6 201.4 215.1 192h145.8C355.4 201.4 352 212.3 352 224S355.4 246.6 360.9 256zM416 256c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S433.6 256 416 256z"],
    "cassette-vhs": [576, 512, [128252, "vhs"], "f8ec", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h512V416zM544 128H32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V128zM124.8 400h326.4c4.828 0 9.406-2.188 12.45-5.938C484.8 367.8 496 336.7 496 304s-11.19-63.84-32.36-90.06C460.6 210.2 456 208 451.2 208H124.8c-4.828 0-9.406 2.188-12.45 5.938C91.19 240.2 80 271.3 80 304s11.19 63.84 32.36 90.06C115.4 397.8 119.1 400 124.8 400zM384 336c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32v-32h59.25C456.8 259.1 464 281.1 464 304s-7.156 44.88-20.75 64H384V336zM224 240h128v128H224V240zM132.8 240H192v32c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32v32H132.8C119.2 348.9 112 326.9 112 304S119.2 259.1 132.8 240z"],
    "castle": [640, 512, [], "e0de", "M128 40C128 17.91 145.9 0 168 0H192C214.1 0 232 17.91 232 40V64H264V40C264 17.91 281.9 0 304 0H336C358.1 0 376 17.91 376 40V64H408V40C408 17.91 425.9 0 448 0H472C494.1 0 512 17.91 512 40V224H544V200C544 177.9 561.9 160 584 160H600C622.1 160 640 177.9 640 200V432C640 476.2 604.2 512 560 512H80C35.82 512 0 476.2 0 432V200C0 177.9 17.91 160 40 160H56C78.09 160 96 177.9 96 200V224H128V40zM168 32C163.6 32 160 35.58 160 40V224H480V40C480 35.58 476.4 32 472 32H448C443.6 32 440 35.58 440 40V80C440 88.84 432.8 96 424 96H360C351.2 96 344 88.84 344 80V40C344 35.58 340.4 32 336 32H304C299.6 32 296 35.58 296 40V80C296 88.84 288.8 96 280 96H216C207.2 96 200 88.84 200 80V40C200 35.58 196.4 32 192 32H168zM80 256C71.16 256 64 248.8 64 240V200C64 195.6 60.42 192 56 192H40C35.58 192 32 195.6 32 200V432C32 458.5 53.49 480 80 480H224V400C224 346.1 266.1 304 320 304C373 304 416 346.1 416 400V480H560C586.5 480 608 458.5 608 432V200C608 195.6 604.4 192 600 192H584C579.6 192 576 195.6 576 200V240C576 248.8 568.8 256 560 256H80zM320 336C284.7 336 256 364.7 256 400V480H384V400C384 364.7 355.3 336 320 336z"],
    "cat": [576, 512, [128008], "f6be", "M544 0c-9.25 0-18.38 4.125-24.62 11.5L475.6 64h-23.25l-43.75-52.5c-9.119-10.79-24.61-14.94-38.63-8.309C358.6 8.584 352 20.88 352 33.5v126.5L336 160C232.1 160 141.9 218.5 96 304.3V176C96 131.9 60.13 96 16 96C7.125 96 0 103.1 0 112S7.125 128 16 128C42.5 128 64 149.5 64 176v256C64 476.2 99.82 512 144 512h207.3c18.32 0 33.12-15.11 32.71-33.43c-.7148-32.36-25.7-58.1-57.36-62.2L416 376.6V464c0 26.4 21.6 48 48 48s48-21.6 48-48V260.8c37.75-18 64-56.25 64-100.7V32C576 14.25 561.6 0 544 0zM480 464c0 8.836-7.164 16-16 16S448 472.8 448 464v-111.1c0-11.58-11.92-19.33-22.5-14.62l-122.2 54.37c-3.615-35.24-25.29-65.79-56.83-80.66c-9.281-4.377-20.28 .4883-22.77 10.45c-1.866 7.46 1.947 14.93 8.81 18.34c22.38 11.11 39.54 30.29 39.54 55.27L272 448H320c17.62 0 32 14.38 32 32l-208 0c-25.48 0-47.69-19.85-47.97-45.32C94.55 301.1 202.7 192 336 192l21.24 .0003C371.1 238.1 413.5 272 464 272c5.5 0 10.75-.8753 16-1.625V464zM544 160c0 44.13-35.88 80-80 80S384 204.1 384 160V32l53.38 64h53.25L544 32V160zM432 128C423.1 128 416 135.1 416 144S423.1 160 432 160S448 152.9 448 144S440.9 128 432 128zM480 144C480 152.9 487.1 160 496 160S512 152.9 512 144S504.9 128 496 128S480 135.1 480 144z"],
    "cat-space": [640, 512, [], "e001", "M576 32.75V32l-.5 .375C548.9 12.25 516 .0003 480 .0003s-68.88 12.25-95.5 32.37L384 32v.75c-38.63 29.12-64 75.13-64 127.3c0 .375 .125 .7498 .125 1.125C197.2 168.3 125.4 249.3 96 304.3V176C96 131.9 60.13 96 16 96C7.125 96 0 103.1 0 112S7.125 128 16 128C42.5 128 64 149.5 64 176v256C64 476.2 99.82 512 144 512h207.3c18.32 0 33.12-15.11 32.71-33.43c-.7148-32.36-25.7-58.1-57.36-62.2L416 376.6V464c0 26.4 21.6 48 48 48S512 490.4 512 464V316.8c74.5-15.25 128-80.75 128-156.7C640 107.9 614.6 61.88 576 32.75zM480 32c24.38 0 48.25 7.125 68.75 20.38L512 80h-64l-36.75-27.62C431.8 39.13 455.6 32 480 32zM544 96v64c0 35.38-28.62 64-64 64s-64-28.62-64-64V96l21.38 16h85.25L544 96zM479.1 464c0 8.836-7.149 16-15.99 16s-16.01-7.164-16.01-16L448 352c0-11.58-11.92-19.33-22.5-14.62l-122.2 54.37c-3.615-35.24-25.29-65.79-56.83-80.66c-9.281-4.377-20.28 .4883-22.77 10.45c-1.867 7.459 1.947 14.93 8.809 18.34C254.8 350.1 272 370.2 272 395.1V448H320c17.62 0 32 14.38 32 32H143.1c-25.48 0-47.69-19.85-47.96-45.32c-.7031-64.13 45.36-232.5 227.4-242.1C338.9 266.9 404.3 320 480 320L479.1 464zM480 288c-70.63-.125-127.9-57.38-128-128c0-32.13 12.38-61.25 32-83.75V160c0 53 43 96 96 96S576 213 576 160V76.25C595.6 98.75 608 127.9 608 160C607.9 230.6 550.6 287.9 480 288zM432 160c0 8.875 7.125 16 16 16s16-7.125 16-16S456.9 144 448 144c-4.25 0-8.375 1.625-11.38 4.625S432 155.8 432 160zM512 176c8.875 0 16-7.125 16-16S520.9 144 512 144S496 151.1 496 160c0 4.25 1.625 8.375 4.625 11.38S507.8 176 512 176zM176 80h32v32c0 8.844 7.149 16 15.99 16S240 120.8 240 112v-32h32c8.844 0 15.99-7.156 15.99-15.1S280.8 48 272 48h-32v-32c0-8.844-7.164-15.1-16.01-15.1S208 7.156 208 16v32h-32c-8.844 0-16.01 7.156-16.01 16S167.2 80 176 80z"],
    "cauldron": [448, 512, [], "f6bf", "M136 32C136 18.75 146.7 8 160 8C173.3 8 184 18.75 184 32C184 45.25 173.3 56 160 56C146.7 56 136 45.25 136 32zM320 80C320 106.5 298.5 128 272 128C245.5 128 224 106.5 224 80C224 53.49 245.5 32 272 32C298.5 32 320 53.49 320 80zM272 64C263.2 64 256 71.16 256 80C256 88.84 263.2 96 272 96C280.8 96 288 88.84 288 80C288 71.16 280.8 64 272 64zM16 192C7.164 192 0 184.8 0 176C0 167.2 7.164 160 16 160H432C440.8 160 448 167.2 448 176C448 184.8 440.8 192 432 192H392.8C417.8 228.1 448 283.9 448 334.4C448 371.8 436.1 403.8 416 429.9V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V461.8C341.7 494.6 283.4 512 224 512C164.6 512 106.3 494.6 64 461.8V496C64 504.8 56.84 512 48 512C39.16 512 32 504.8 32 496V429.9C11.93 403.8 0 371.8 0 334.4C0 283.9 30.22 228.1 55.17 192H16zM60.11 244.9C43.73 275 32 307.1 32 334.4C32 379.5 53.37 414.8 88.07 439.9C123.5 465.5 172.6 480 224 480C275.4 480 324.5 465.5 359.9 439.9C394.6 414.8 416 379.5 416 334.4C416 307.1 404.3 275 387.9 244.9C376 223 362.8 204.3 353.1 192H94.9C85.2 204.3 71.1 223 60.11 244.9H60.11z"],
    "cedi-sign": [320, 512, [], "e0df", "M176 0C184.8 0 192 7.164 192 16V64.04C193.3 64.01 194.7 64 195.1 64C240 64 280.7 78.24 313.5 102.3C320.6 107.5 322.1 117.6 316.9 124.7C311.7 131.8 301.6 133.3 294.5 128.1C267.1 107.1 233 95.1 195.1 95.1C194.7 95.1 193.3 96.02 192 96.05V415.1C193.3 415.1 194.7 416 195.1 416C233 416 267.1 404 294.5 383.9C301.6 378.7 311.7 380.2 316.9 387.3C322.1 394.4 320.6 404.5 313.5 409.7C280.7 433.8 240 448 195.1 448C194.7 448 193.3 447.1 192 447.1V496C192 504.8 184.8 512 176 512C167.2 512 160 504.8 160 496V444.8C69.17 428.2 0 350.3 0 256C0 161.7 69.17 83.77 160 67.23V16C160 7.164 167.2 0 176 0V0zM160 412.1V99.86C86.54 115.9 32 179.1 32 256C32 332 86.54 396.1 160 412.1V412.1z"],
    "cent-sign": [320, 512, [], "e3f5", "M176 .0003C184.8 .0003 192 7.164 192 16V64.04C193.3 64.01 194.7 64 195.1 64C240 64 280.7 78.24 313.5 102.3C320.6 107.5 322.1 117.6 316.9 124.7C311.7 131.8 301.6 133.3 294.5 128.1C267.1 107.1 233 96 195.1 96C105.1 96 31.1 167.1 31.1 256C31.1 344 105.1 416 195.1 416C233 416 267.1 404 294.5 383.9C301.6 378.7 311.7 380.2 316.9 387.3C322.1 394.4 320.6 404.5 313.5 409.7C280.7 433.8 240 448 195.1 448C194.7 448 193.3 447.1 192 447.1V496C192 504.8 184.8 512 176 512C167.2 512 160 504.8 160 496V444.8C69.17 428.2 0 350.3 0 256C0 161.7 69.17 83.77 160 67.23V16C160 7.164 167.2 0 176 0V.0003z"],
    "certificate": [512, 512, [], "f0a3", "M80.6 154.7L63.07 92.69C60.71 84.33 63.05 75.34 69.19 69.19C75.34 63.05 84.33 60.71 92.69 63.07L154.7 80.6L170.6 18.1C172.7 9.679 179.2 3.068 187.6 .8185C196-1.431 204.1 1.034 211 7.261L256 53.46L300.1 7.261C307 1.034 315.1-1.431 324.4 .8185C332.8 3.068 339.3 9.679 341.4 18.1L357.3 80.6L419.3 63.07C427.7 60.71 436.7 63.05 442.8 69.19C448.1 75.34 451.3 84.33 448.9 92.69L431.4 154.7L493.9 170.6C502.3 172.7 508.9 179.2 511.2 187.6C513.4 196 510.1 204.1 504.7 211L458.5 256L504.7 300.1C510.1 307 513.4 315.1 511.2 324.4C508.9 332.8 502.3 339.3 493.9 341.4L431.4 357.3L448.9 419.3C451.3 427.7 448.1 436.7 442.8 442.8C436.7 448.1 427.7 451.3 419.3 448.9L357.3 431.4L341.4 493.9C339.3 502.3 332.8 508.9 324.4 511.2C315.1 513.4 307 510.1 300.1 504.7L256 458.5L211 504.7C204.1 510.1 196 513.4 187.6 511.2C179.2 508.9 172.7 502.3 170.6 493.9L154.7 431.4L92.69 448.9C84.33 451.3 75.34 448.1 69.19 442.8C63.05 436.7 60.71 427.7 63.07 419.3L80.6 357.3L18.1 341.4C9.679 339.3 3.068 332.8 .8186 324.4C-1.431 315.1 1.034 307 7.261 300.1L53.46 256L7.261 211C1.034 204.1-1.431 196 .8186 187.6C3.068 179.2 9.679 172.7 18.1 170.6L80.6 154.7zM170.7 108.3C163.3 112.6 154.3 113.7 146 111.4L97.75 97.75L111.4 146C113.7 154.3 112.6 163.3 108.3 170.7C103.1 178.2 96.83 183.6 88.46 185.8L39.83 198.1L75.78 233.1C81.97 239.1 85.46 247.4 85.46 256C85.46 264.6 81.97 272.9 75.78 278.9L39.83 313.9L88.46 326.3C96.83 328.4 103.1 333.8 108.3 341.3C112.6 348.8 113.7 357.7 111.4 365.1L97.75 414.2L146 400.6C154.3 398.3 163.3 399.4 170.7 403.7C178.2 408 183.6 415.2 185.8 423.5L198.1 472.2L233.1 436.2C239.1 430 247.4 426.5 256 426.5C264.6 426.5 272.9 430 278.9 436.2L313.9 472.2L326.3 423.5C328.4 415.2 333.8 408 341.3 403.7C348.7 399.4 357.7 398.3 365.1 400.6L414.2 414.2L400.6 365.1C398.3 357.7 399.4 348.8 403.7 341.3C408 333.8 415.2 328.4 423.5 326.3L472.2 313.9L436.2 278.9C430 272.9 426.5 264.6 426.5 256C426.5 247.4 430 239.1 436.2 233.1L472.2 198.1L423.5 185.8C415.2 183.6 408 178.2 403.7 170.7C399.4 163.3 398.3 154.3 400.6 146L414.2 97.75L365.1 111.4C357.7 113.7 348.7 112.6 341.3 108.3C333.8 103.1 328.4 96.83 326.3 88.46L313.9 39.83L278.9 75.78C272.9 81.97 264.6 85.46 256 85.46C247.4 85.46 239.1 81.97 233.1 75.78L198.1 39.83L185.8 88.46C183.6 96.83 178.2 103.1 170.7 108.3V108.3z"],
    "chair": [448, 512, [129681], "f6c0", "M443.6 315.9L428.8 283.9C420.1 266.9 403.9 256 385.2 256h-1.212L384 112C384 50.25 333.8 0 272 0h-96C114.3 0 64 50.25 64 112L63.1 256H62.79C44.13 256 27.02 266.9 19.2 283.9L4.436 315.9c-6.883 14.95-5.697 32.13 3.156 45.98C13.43 371 22.13 377.4 32 380.9L31.1 496c0 8.836 7.164 16 16 16S64 504.8 64 496L63.1 384h320L384 496c0 8.836 7.166 16 16 16s16-7.164 16-16L416 380.9c9.873-3.512 18.57-9.91 24.41-19.05C449.3 348 450.4 330.8 443.6 315.9zM288 33.62C324.5 41.05 352 73.36 352 112V256h-64V33.62zM192 32h64v224H192V32zM96 112c0-38.64 27.53-70.95 64-78.38V256H96V112zM399.1 352H48.02c-11.74 0-19.38-12.17-14.53-22.7l14.76-32C50.86 291.6 56.56 288 62.79 288h322.4c6.223 0 11.93 3.648 14.53 9.297l14.76 31.99C419.4 339.9 411.6 352 399.1 352z"],
    "chair-office": [448, 512, [], "f6c1", "M48.02 240c8.844 0 15.99-7.156 15.99-16l.0091-80c0-8.844-7.154-16-15.1-16s-15.1 7.156-15.1 16V224C32.02 232.8 39.17 240 48.02 240zM396.8 283.9C388.1 266.9 371.9 256 353.2 256h-1.217l-.0091-176c0-44.13-35.89-80-79.99-80H176C131.9 0 96.01 35.88 96.01 80L96.01 256H94.79C76.13 256 59.02 266.9 51.2 283.9L36.44 315.9c-6.883 14.95-5.697 32.13 3.156 45.98C48.45 375.7 63.56 384 80.02 384H208v49.04C162.1 438 128 463.8 128 496c0 8.844 7.156 16 15.1 16c8.844 0 16-7.156 16-16c0-12.78 19.74-26.76 47.99-30.77V496c0 8.844 7.157 16 15.1 16c8.844 0 15.1-7.156 15.1-16v-30.77c28.26 4.012 47.99 17.98 47.99 30.77c0 8.844 7.156 16 16 16c8.842 0 15.1-7.156 15.1-16c0-32.21-34.09-57.99-79.99-62.96V384h127.1c16.46 0 31.58-8.277 40.44-22.14c8.85-13.84 10.03-31.03 3.156-45.96L396.8 283.9zM176 32h95.99c26.47 0 47.1 21.53 47.1 48V256H128L128 80C128 53.53 149.5 32 176 32zM381.4 344.6C378.5 349.2 373.5 352 367.1 352H80.02c-5.484 0-10.52-2.756-13.47-7.369c-2.957-4.625-3.352-10.36-1.062-15.33l14.76-32C82.86 291.6 88.56 288 94.79 288h258.4c6.223 0 11.93 3.648 14.53 9.297l14.76 31.99C384.8 334.3 384.4 340 381.4 344.6zM399.1 128c-8.844 0-15.1 7.156-15.1 16L383.1 224c0 8.844 7.144 16 15.99 16s15.1-7.156 15.1-16V144C415.1 135.2 408.8 128 399.1 128z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M560 448H416v-48c0-26.47-21.53-48-48-48h-96C245.5 352 224 373.5 224 400V448H16C7.156 448 0 455.2 0 464S7.156 480 16 480h544c8.844 0 16-7.156 16-16S568.8 448 560 448zM384 448H256v-48C256 391.2 263.2 384 272 384h96c8.828 0 16 7.188 16 16V448zM45.32 383.8C55.35 385.4 64 377.7 64 368v-288C64 71.16 71.16 64 80 64h416C504.8 64 512 71.16 512 80v288c0 8.836 7.164 16 16 16s16-7.164 16-16v-288C544 53.49 522.5 32 496 32h-416C53.49 32 32 53.49 32 80v287.2C32 375.1 37.46 382.5 45.32 383.8z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 160c35.29 0 64 28.71 64 64S195.3 288 160 288S96 259.3 96 224S124.7 160 160 160zM192 352H128c-70.69 0-128 57.31-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM32 480c0-52.94 43.07-96 96-96h64c52.94 0 96 43.06 96 96H32zM592 0h-384C181.5 0 160 21.53 160 48v32C160 88.84 167.2 96 176 96S192 88.84 192 80v-32C192 39.19 199.2 32 208 32h384C600.8 32 608 39.19 608 48v320c0 8.812-7.172 16-16 16H576v-48C576 309.5 554.5 288 528 288h-96C405.5 288 384 309.5 384 336V384h-32c-8.844 0-16 7.156-16 16S343.2 416 352 416h240C618.5 416 640 394.5 640 368v-320C640 21.53 618.5 0 592 0zM544 384h-128v-48c0-8.812 7.172-16 16-16h96c8.828 0 16 7.188 16 16V384z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M208 480h-64v-130.1c62.91-8.131 112-61.9 112-128.1c0-35.09-13.27-130.1-33.02-215.6C222.1 2.562 218.9 0 215.2 0H40.81C37.09 0 33.86 2.562 33.02 6.188C13.27 91.69 0 186.7 0 221.8c0 66.16 49.09 119.9 112 128.1V480h-64C39.16 480 32 487.2 32 496C32 504.8 39.16 512 48 512h160c8.836 0 16-7.164 16-16C224 487.2 216.8 480 208 480zM195.1 32c7.057 32.58 13.06 65.88 17.75 96H42.29c4.688-30.13 10.69-63.42 17.75-96H195.1zM32 221.8C32 209.1 34.1 186.9 37.66 160h180.7C221.9 186.9 224 209.1 224 221.8c0 51.53-39.66 94.34-90.29 97.46c-7.01 .4316-4.297 .4375-11.41 0C71.66 316.2 32 273.3 32 221.8z"],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", "M638.1 435.1c-3.135-8.381-12.65-12.7-21.26-9.652l-64.4 22.82l-37.47-96.24c58.29-29.48 86.96-97.36 63.52-160.1c-11.57-30.95-52.69-107.1-98.24-177.3c-8.084-12.47-23.7-17.72-37.7-12.75l-60.2 21.33c-9.654 3.421-13.78 14.81-8.551 23.62c3.827 6.451 11.86 9.586 18.93 7.08l59.98-21.25c18.42 28.47 36.08 57.98 51.33 84.94L379.4 162.1c-5.39 1.91-9.364 6.533-10.44 12.15l-.0722 .3756c-2.335 12.15 9.407 22.25 21.07 18.11l130.8-46.36c13 24.27 22.92 44.63 27.43 56.68c18.27 48.88-5.188 103.2-53.41 123.6c-6.781 2.873-4.137 1.93-11.12 3.938c-43.12 12.42-88.71-5.457-112.4-41.45c-5.915-8.969-18.73-9.828-25.76-1.708c-4.742 5.474-5.377 13.5-1.359 19.52c30.22 45.32 86.22 68.13 140.6 56.19l37.45 96.18l-60.28 21.36c-8.607 3.051-13.04 12.32-9.912 20.7c3.133 8.383 12.65 12.71 21.26 9.652l155.9-55.24C637.7 452.7 642.1 443.5 638.1 435.1zM330.5 49.32L196.6 1.861C182.6-3.078 167 2.045 158.9 14.47C113.4 84.76 72.19 160.1 60.61 191.1c-23.44 62.7 5.236 130.6 63.52 160.1L86.67 448.3l-64.4-22.82c-8.607-3.049-18.13 1.271-21.26 9.652c-3.133 8.385 1.307 17.65 9.914 20.7l155.9 55.24c8.607 3.053 18.13-1.27 21.26-9.652c3.133-8.381-1.305-17.65-9.912-20.7l-60.28-21.36l37.45-96.18c64.23 14.12 131.2-19.96 154.7-82.77c11.53-30.83 30.19-114.3 41.69-196.4C353.8 68.88 344.8 54.41 330.5 49.32zM278.8 269.3c-18.27 48.88-72.09 75.79-122.5 61.27C149.3 328.6 151.1 329.5 145.2 326.6C96.97 306.2 73.51 251.9 91.79 203c4.502-12.05 14.42-32.41 27.43-56.68l176 62.38C289.2 235.4 283.3 257.3 278.8 269.3zM302.1 176.8L135.1 117.6C150.3 90.62 167.1 61.11 186.4 32.64l132.4 46.93C314.1 112.9 308.2 146.6 302.1 176.8z"],
    "charging-station": [576, 512, [], "f5e7", "M152 192H232C238.1 192 243.6 195.4 246.3 200.8C249 206.3 248.4 212.8 244.8 217.6L172.8 313.6C167.5 320.7 157.5 322.1 150.4 316.8C143.3 311.5 141.9 301.5 147.2 294.4L200 224H120C113.9 224 108.4 220.6 105.7 215.2C102.1 209.7 103.6 203.2 107.2 198.4L179.2 102.4C184.5 95.33 194.5 93.9 201.6 99.2C208.7 104.5 210.1 114.5 204.8 121.6L152 192zM96 0H256C291.3 0 320 28.65 320 64V256H336C380.2 256 416 291.8 416 336V384C416 401.7 430.3 416 448 416C465.7 416 480 401.7 480 384V270.4C443.5 262.1 416 230.7 416 192V144C416 135.2 423.2 128 432 128H448V80C448 71.16 455.2 64 464 64C472.8 64 480 71.16 480 80V128H512V80C512 71.16 519.2 64 528 64C536.8 64 544 71.16 544 80V128H560C568.8 128 576 135.2 576 144V192C576 230.7 548.5 262.1 512 270.4V384C512 419.3 483.3 448 448 448C412.7 448 384 419.3 384 384V336C384 309.5 362.5 288 336 288H320V480H336C344.8 480 352 487.2 352 496C352 504.8 344.8 512 336 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H32V64C32 28.65 60.65 0 96 0zM256 32H96C78.33 32 64 46.33 64 64V480H288V64C288 46.33 273.7 32 256 32zM448 160V192C448 218.5 469.5 240 496 240C522.5 240 544 218.5 544 192V160H448z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM320 192L359.6 152.4C372.7 139.3 394.4 140.1 406.5 154.2L468.4 226.5C475.9 235.2 480 246.3 480 257.8V352C480 369.7 465.7 384 448 384H128C110.3 384 96 369.7 96 352V243.9C96 231.2 101.1 218.9 110.1 209.9L201.4 118.6C213.9 106.1 234.1 106.1 246.6 118.6L320 192zM224 141.3L132.7 232.6C129.7 235.6 128 239.6 128 243.9V352H448V257.8C448 253.9 446.6 250.2 444.1 247.3L382.2 175.1L342.6 214.6C336.6 220.6 328.5 223.1 320 223.1C311.5 223.1 303.4 220.6 297.4 214.6L224 141.3z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M16 32C24.84 32 32 39.16 32 48V400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32zM128 144C128 135.2 135.2 128 144 128H368C376.8 128 384 135.2 384 144C384 152.8 376.8 160 368 160H144C135.2 160 128 152.8 128 144zM304 224C312.8 224 320 231.2 320 240C320 248.8 312.8 256 304 256H144C135.2 256 128 248.8 128 240C128 231.2 135.2 224 144 224H304zM432 320C440.8 320 448 327.2 448 336C448 344.8 440.8 352 432 352H144C135.2 352 128 344.8 128 336C128 327.2 135.2 320 144 320H432z"],
    "chart-bullet": [512, 512, [], "e0e1", "M272 32C280.8 32 288 39.16 288 48V64H464C490.5 64 512 85.49 512 112V176C512 202.5 490.5 224 464 224H288V240C288 248.8 280.8 256 272 256C263.2 256 256 248.8 256 240V224H48C21.49 224 0 202.5 0 176V112C0 85.49 21.49 64 48 64H256V48C256 39.16 263.2 32 272 32zM160 192H256V96H160V192zM288 96V192H464C472.8 192 480 184.8 480 176V112C480 103.2 472.8 96 464 96H288zM128 96H48C39.16 96 32 103.2 32 112V176C32 184.8 39.16 192 48 192H128V96zM368 256C376.8 256 384 263.2 384 272V288H464C490.5 288 512 309.5 512 336V400C512 426.5 490.5 448 464 448H384V464C384 472.8 376.8 480 368 480C359.2 480 352 472.8 352 464V448H48C21.49 448 0 426.5 0 400V336C0 309.5 21.49 288 48 288H352V272C352 263.2 359.2 256 368 256zM352 416V320H224V416H352zM384 320V416H464C472.8 416 480 408.8 480 400V336C480 327.2 472.8 320 464 320H384zM192 320H48C39.16 320 32 327.2 32 336V400C32 408.8 39.16 416 48 416H192V320z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM320 96C320 96.27 319.1 96.53 319.1 96.8C338.2 100.5 352 116.6 352 136V216C352 235.4 338.2 251.5 319.1 255.2C319.1 255.5 320 255.7 320 256V304C320 312.8 312.8 320 304 320C295.2 320 288 312.8 288 304V256C288 255.7 288 255.5 288 255.2C269.8 251.5 256 235.4 256 216V136C256 116.6 269.8 100.5 288 96.8C288 96.53 288 96.27 288 96V48C288 39.16 295.2 32 304 32C312.8 32 320 39.16 320 48V96zM320 136C320 131.6 316.4 128 312 128H296C291.6 128 288 131.6 288 136V216C288 220.4 291.6 224 296 224H312C316.4 224 320 220.4 320 216V136zM176 64C184.8 64 192 71.16 192 80V128C192 128.3 191.1 128.5 191.1 128.8C210.2 132.5 224 148.6 224 168V280C224 299.4 210.2 315.5 191.1 319.2C191.1 319.5 192 319.7 192 320V368C192 376.8 184.8 384 176 384C167.2 384 160 376.8 160 368V320C160 319.7 160 319.5 160 319.2C141.8 315.5 128 299.4 128 280V168C128 148.6 141.8 132.5 160 128.8C160 128.5 160 128.3 160 128V80C160 71.16 167.2 64 176 64V64zM168 160C163.6 160 160 163.6 160 168V280C160 284.4 163.6 288 168 288H184C188.4 288 192 284.4 192 280V168C192 163.6 188.4 160 184 160H168zM416 144C416 135.2 423.2 128 432 128C440.8 128 448 135.2 448 144V192C448 192.3 447.1 192.5 447.1 192.8C466.2 196.5 480 212.6 480 232V280C480 299.4 466.2 315.5 447.1 319.2C447.1 319.5 448 319.7 448 320V368C448 376.8 440.8 384 432 384C423.2 384 416 376.8 416 368V320C416 319.7 416 319.5 416 319.2C397.8 315.5 384 299.4 384 280V232C384 212.6 397.8 196.5 416 192.8C416 192.5 416 192.3 416 192V144zM424 224C419.6 224 416 227.6 416 232V280C416 284.4 419.6 288 424 288H440C444.4 288 448 284.4 448 280V232C448 227.6 444.4 224 440 224H424z"],
    "chart-column": [512, 512, [], "e0e3", "M16 32C24.84 32 32 39.16 32 48V400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32zM144 256C152.8 256 160 263.2 160 272V368C160 376.8 152.8 384 144 384C135.2 384 128 376.8 128 368V272C128 263.2 135.2 256 144 256zM256 368C256 376.8 248.8 384 240 384C231.2 384 224 376.8 224 368V144C224 135.2 231.2 128 240 128C248.8 128 256 135.2 256 144V368zM336 192C344.8 192 352 199.2 352 208V368C352 376.8 344.8 384 336 384C327.2 384 320 376.8 320 368V208C320 199.2 327.2 192 336 192zM448 368C448 376.8 440.8 384 432 384C423.2 384 416 376.8 416 368V112C416 103.2 423.2 96 432 96C440.8 96 448 103.2 448 112V368z"],
    "chart-gantt": [512, 512, [], "e0e4", "M16 32C24.84 32 32 39.16 32 48V400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32zM128 144C128 135.2 135.2 128 144 128L272 128C280.8 128 288 135.2 288 144C288 152.8 280.8 160 272 160L144 160C135.2 160 128 152.8 128 144zM368 224C376.8 224 384 231.2 384 240C384 248.8 376.8 256 368 256H208C199.2 256 192 248.8 192 240C192 231.2 199.2 224 208 224H368zM464 320C472.8 320 480 327.2 480 336C480 344.8 472.8 352 464 352H368C359.2 352 352 344.8 352 336C352 327.2 359.2 320 368 320H464z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM331.3 299.3C325.1 305.6 314.9 305.6 308.7 299.3L223.1 214.6L123.3 315.3C117.1 321.6 106.9 321.6 100.7 315.3C94.44 309.1 94.44 298.9 100.7 292.7L212.7 180.7C218.9 174.4 229.1 174.4 235.3 180.7L320 265.4L452.7 132.7C458.9 126.4 469.1 126.4 475.3 132.7C481.6 138.9 481.6 149.1 475.3 155.3L331.3 299.3z"],
    "chart-line-down": [512, 512, [128201], "f64d", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM320 336C320 327.2 327.2 320 336 320H425.4L320 214.6L235.3 299.3C229.1 305.6 218.9 305.6 212.7 299.3L100.7 187.3C94.44 181.1 94.44 170.9 100.7 164.7C106.9 158.4 117.1 158.4 123.3 164.7L224 265.4L308.7 180.7C314.9 174.4 325.1 174.4 331.3 180.7L448 297.4V208C448 199.2 455.2 192 464 192C472.8 192 480 199.2 480 208V336C480 344.8 472.8 352 464 352H336C327.2 352 320 344.8 320 336L320 336z"],
    "chart-line-up": [512, 512, [], "e0e5", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM336 128H464C472.8 128 480 135.2 480 144V272C480 280.8 472.8 288 464 288C455.2 288 448 280.8 448 272V182.6L331.3 299.3C325.1 305.6 314.9 305.6 308.7 299.3L223.1 214.6L123.3 315.3C117.1 321.6 106.9 321.6 100.7 315.3C94.44 309.1 94.44 298.9 100.7 292.7L212.7 180.7C218.9 174.4 229.1 174.4 235.3 180.7L320 265.4L425.4 160H336C327.2 160 320 152.8 320 144C320 135.2 327.2 128 336 128L336 128z"],
    "chart-mixed": [512, 512, ["analytics"], "f643", "M507.8 37.24C513.8 43.78 513.3 53.89 506.8 59.84L330.8 219.8C324.4 225.6 314.7 225.4 308.7 219.3L190.4 100.1L25.41 220.9C18.26 226.1 8.258 224.6 3.061 217.4C-2.137 210.3-.5565 200.3 6.59 195.1L182.6 67.06C188.1 62.43 197.7 63.12 203.3 68.69L320.5 185.9L485.2 36.16C491.8 30.22 501.9 30.7 507.8 37.24H507.8zM112 368V432C112 458.5 90.51 480 64 480C37.49 480 16 458.5 16 432V368C16 341.5 37.49 319.1 64 319.1C90.51 319.1 112 341.5 112 368zM80 432V368C80 359.2 72.84 352 64 352C55.16 352 48 359.2 48 368V432C48 440.8 55.16 448 64 448C72.84 448 80 440.8 80 432zM144 271.1C144 245.5 165.5 223.1 192 223.1C218.5 223.1 240 245.5 240 271.1V432C240 458.5 218.5 480 192 480C165.5 480 144 458.5 144 432V271.1zM192 255.1C183.2 255.1 176 263.2 176 271.1V432C176 440.8 183.2 448 192 448C200.8 448 208 440.8 208 432V271.1C208 263.2 200.8 255.1 192 255.1zM368 336V432C368 458.5 346.5 480 320 480C293.5 480 272 458.5 272 432V336C272 309.5 293.5 287.1 320 287.1C346.5 287.1 368 309.5 368 336zM336 432V336C336 327.2 328.8 319.1 320 319.1C311.2 319.1 304 327.2 304 336V432C304 440.8 311.2 448 320 448C328.8 448 336 440.8 336 432zM400 271.1C400 245.5 421.5 223.1 448 223.1C474.5 223.1 496 245.5 496 271.1V432C496 458.5 474.5 480 448 480C421.5 480 400 458.5 400 432V271.1zM448 255.1C439.2 255.1 432 263.2 432 271.1V432C432 440.8 439.2 448 448 448C456.8 448 464 440.8 464 432V271.1C464 263.2 456.8 255.1 448 255.1z"],
    "chart-network": [640, 512, [], "f78a", "M160 64C160 28.65 188.7 0 224 0C259.3 0 288 28.65 288 64C288 83.36 279.4 100.7 265.8 112.5L304.3 196.5C314.4 193.6 325 192 336 192C367.7 192 396.2 205.1 416.6 226.2L517.4 153.7C513.9 145.8 512 137.1 512 128C512 92.65 540.7 64 576 64C611.3 64 640 92.65 640 128C640 163.3 611.3 192 576 192C561.4 192 547.9 187.1 537.2 178.9L435.3 252.2C443.4 267.7 448 285.3 448 304C448 319.4 444.9 334 439.3 347.3L531.1 402.4C542.6 391 558.5 384 576 384C611.3 384 640 412.7 640 448C640 483.3 611.3 512 576 512C540.7 512 512 483.3 512 448C512 441.7 512.9 435.6 514.6 429.8L422.8 374.8C402.3 399.9 371 416 336 416C279.6 416 232.9 374.3 225.1 320H125.1C118.9 347.6 93.82 368 64 368C28.65 368 0 339.3 0 304C0 268.7 28.65 240 64 240C93.82 240 118.9 260.4 125.1 288H225.1C229.8 255.3 248.7 227.1 275.3 209.9L237.1 126.7C232.9 127.5 228.5 128 224 128C188.7 128 160 99.35 160 64V64zM224 96C241.7 96 256 81.67 256 64C256 46.33 241.7 32 224 32C206.3 32 192 46.33 192 64C192 81.67 206.3 96 224 96zM576 160C593.7 160 608 145.7 608 128C608 110.3 593.7 96 576 96C558.3 96 544 110.3 544 128C544 145.7 558.3 160 576 160zM576 416C558.3 416 544 430.3 544 448C544 465.7 558.3 480 576 480C593.7 480 608 465.7 608 448C608 430.3 593.7 416 576 416zM64 336C81.67 336 96 321.7 96 304C96 286.3 81.67 272 64 272C46.33 272 32 286.3 32 304C32 321.7 46.33 336 64 336zM336 384C380.2 384 416 348.2 416 304C416 259.8 380.2 224 336 224C291.8 224 256 259.8 256 304C256 348.2 291.8 384 336 384z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M320 240C311.2 240 304 232.8 304 224V15.47C304 7.074 310.5 .0432 318.9 .0026L320 0C443.7 0 544 100.3 544 224L543.1 225.1C543.1 233.5 536.9 240 528.5 240H320zM336 32.66V208H511.3C503.6 114.7 429.3 40.35 336 32.66V32.66zM256 49.61V288L412.5 444.5C419.2 451.2 418.7 462.2 411 467.7C371.8 495.6 323.8 512 272 512C139.5 512 32 404.6 32 272C32 150.7 122.1 50.34 238.1 34.25C248.2 32.99 256 40.36 256 49.61V49.61zM233.4 310.6C227.4 304.6 224 296.5 224 288V69.56C132.3 91.22 64 173.7 64 272C64 386.9 157.1 480 272 480C309.6 480 344.9 470 375.3 452.6L233.4 310.6zM499.9 447.3C493.9 452.1 484.5 452.5 478.7 446.7L347.3 315.3C337.2 305.2 344.4 288 358.6 288H558.4C567.6 288 575 295.8 573.8 305C566.1 360.9 539.1 410.6 499.9 447.3V447.3zM538.4 320H397.3L489.6 412.3C513.1 386.6 530.2 354.1 538.4 320z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M256 17.68C256 8.059 263.4 0 273.1 0C405 0 512 106.1 512 238.9C512 248.6 503.9 256 494.3 256H272C263.2 256 256 248.8 256 240V17.68zM288 224H479.5C472.2 121.6 390.4 39.83 288 32.53V224zM224 288H445.3C463.8 288 478.6 303.7 474.8 321.8C451.9 430.5 355.5 512 240 512C107.5 512 0 404.5 0 272C0 156.5 81.53 60.12 190.2 37.18C208.3 33.36 224 48.2 224 66.7V288zM192 69.56C100.3 91.22 32 173.7 32 272C32 386.9 125.1 480 240 480C338.3 480 420.8 411.7 442.4 320H224C206.3 320 192 305.7 192 288V69.56z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M214.5 71.57C233.1 39.82 278.9 39.82 297.5 71.57L493.6 407.8C512.3 439.8 489.2 480 452.1 480H59.86C22.81 480-.2704 439.8 18.4 407.8L214.5 71.57zM269.8 87.69C263.6 77.11 248.4 77.11 242.2 87.69L181.3 191.1H330.7L269.8 87.69zM405.3 320L349.3 223.1H162.7L106.7 320H405.3zM88 352L46.04 423.9C39.81 434.6 47.51 448 59.86 448H452.1C464.5 448 472.2 434.6 465.1 423.9L424 352H88z"],
    "chart-radar": [512, 512, [], "e0e7", "M312 160C312 177.8 303.7 193.6 290.8 203.9L314.9 264.2C316.6 264.1 318.3 264 320 264C350.9 264 376 289.1 376 320C376 350.9 350.9 376 320 376C290.8 376 266.8 353.7 264.2 325.2L209.5 314.2C200.1 331.9 181.5 344 160 344C129.1 344 104 318.9 104 288C104 257.1 129.1 232 160 232C166.8 232 173.4 233.2 179.4 235.5L210.1 193.3C204.1 184 200 172.5 200 159.1C200 129.1 225.1 103.1 256 103.1C286.9 103.1 312 129.1 312 159.1L312 160zM285.2 276.1L261.1 215.8C259.4 215.9 257.7 216 256 216C249.2 216 242.6 214.8 236.6 212.5L205 254.7C210.9 262.7 214.8 272.3 215.8 282.8L270.5 293.8C274.1 286.9 279.2 280.9 285.2 276.1V276.1zM256 184C269.3 184 280 173.3 280 160C280 146.7 269.3 136 256 136C242.7 136 232 146.7 232 160C232 173.3 242.7 184 256 184zM320 296C306.7 296 296 306.7 296 320C296 333.3 306.7 344 320 344C333.3 344 344 333.3 344 320C344 306.7 333.3 296 320 296zM160 312C173.3 312 184 301.3 184 288C184 274.7 173.3 264 160 264C146.7 264 136 274.7 136 288C136 301.3 146.7 312 160 312zM357.5 32C374.7 32 390.5 41.15 399.1 56.01L500.6 232C509.2 246.9 509.2 265.1 500.6 279.1L399.1 455.1C390.5 470.8 374.7 480 357.5 480H154.5C137.3 480 121.5 470.8 112.9 455.1L11.37 279.1C2.803 265.1 2.803 246.9 11.37 232L112.9 56.01C121.5 41.15 137.3 32 154.5 32H357.5zM39.09 248C36.23 252.1 36.23 259 39.09 263.1L140.6 439.1C143.5 444.9 148.8 448 154.5 448H357.5C363.2 448 368.5 444.9 371.4 439.1L472.9 263.1C475.8 259 475.8 252.1 472.9 248L371.4 72C368.5 67.05 363.2 64 357.5 64H154.5C148.8 64 143.5 67.05 140.6 72L39.09 248z"],
    "chart-scatter": [512, 512, [], "f7ee", "M32 400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V400zM168 160C168 146.7 178.7 136 192 136C205.3 136 216 146.7 216 160C216 173.3 205.3 184 192 184C178.7 184 168 173.3 168 160zM312 256C312 269.3 301.3 280 288 280C274.7 280 264 269.3 264 256C264 242.7 274.7 232 288 232C301.3 232 312 242.7 312 256zM360 320C360 306.7 370.7 296 384 296C397.3 296 408 306.7 408 320C408 333.3 397.3 344 384 344C370.7 344 360 333.3 360 320zM440 128C440 141.3 429.3 152 416 152C402.7 152 392 141.3 392 128C392 114.7 402.7 104 416 104C429.3 104 440 114.7 440 128zM136 320C136 306.7 146.7 296 160 296C173.3 296 184 306.7 184 320C184 333.3 173.3 344 160 344C146.7 344 136 333.3 136 320z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M272 280.6L474.3 451.8C481.1 457.5 481.9 467.6 476.2 474.3C470.5 481.1 460.4 481.9 453.7 476.2L256 308.1L58.34 476.2C51.59 481.9 41.49 481.1 35.79 474.3C30.08 467.6 30.92 457.5 37.66 451.8L240 280.6V48C240 39.16 247.2 32 256 32C264.8 32 272 39.16 272 48V280.6zM360 64C360 50.75 370.7 40 384 40C397.3 40 408 50.75 408 64C408 77.25 397.3 88 384 88C370.7 88 360 77.25 360 64zM408 256C408 269.3 397.3 280 384 280C370.7 280 360 269.3 360 256C360 242.7 370.7 232 384 232C397.3 232 408 242.7 408 256zM456 160C456 146.7 466.7 136 480 136C493.3 136 504 146.7 504 160C504 173.3 493.3 184 480 184C466.7 184 456 173.3 456 160zM152 160C152 173.3 141.3 184 128 184C114.7 184 104 173.3 104 160C104 146.7 114.7 136 128 136C141.3 136 152 146.7 152 160zM8 64C8 50.75 18.75 40 32 40C45.25 40 56 50.75 56 64C56 77.25 45.25 88 32 88C18.75 88 8 77.25 8 64zM56 256C56 269.3 45.25 280 32 280C18.75 280 8 269.3 8 256C8 242.7 18.75 232 32 232C45.25 232 56 242.7 56 256zM232 448C232 434.7 242.7 424 256 424C269.3 424 280 434.7 280 448C280 461.3 269.3 472 256 472C242.7 472 232 461.3 232 448z"],
    "chart-scatter-bubble": [512, 512, [], "e0e9", "M16 32C24.84 32 32 39.16 32 48V400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32zM128 304C128 277.5 149.5 256 176 256C202.5 256 224 277.5 224 304C224 330.5 202.5 352 176 352C149.5 352 128 330.5 128 304zM176 323.2C186.6 323.2 195.2 314.6 195.2 304C195.2 293.4 186.6 284.8 176 284.8C165.4 284.8 156.8 293.4 156.8 304C156.8 314.6 165.4 323.2 176 323.2zM416 288C416 323.3 387.3 352 352 352C316.7 352 288 323.3 288 288C288 252.7 316.7 224 352 224C387.3 224 416 252.7 416 288zM352 256C334.3 256 320 270.3 320 288C320 305.7 334.3 320 352 320C369.7 320 384 305.7 384 288C384 270.3 369.7 256 352 256zM192 176C192 149.5 213.5 128 240 128C266.5 128 288 149.5 288 176C288 202.5 266.5 224 240 224C213.5 224 192 202.5 192 176zM240 195.2C250.6 195.2 259.2 186.6 259.2 176C259.2 165.4 250.6 156.8 240 156.8C229.4 156.8 220.8 165.4 220.8 176C220.8 186.6 229.4 195.2 240 195.2zM448 128C448 163.3 419.3 192 384 192C348.7 192 320 163.3 320 128C320 92.65 348.7 64 384 64C419.3 64 448 92.65 448 128zM384 96C366.3 96 352 110.3 352 128C352 145.7 366.3 160 384 160C401.7 160 416 145.7 416 128C416 110.3 401.7 96 384 96z"],
    "chart-simple": [448, 512, [], "e473", "M240 32C266.5 32 288 53.49 288 80V432C288 458.5 266.5 480 240 480H208C181.5 480 160 458.5 160 432V80C160 53.49 181.5 32 208 32H240zM240 64H208C199.2 64 192 71.16 192 80V432C192 440.8 199.2 448 208 448H240C248.8 448 256 440.8 256 432V80C256 71.16 248.8 64 240 64zM80 224C106.5 224 128 245.5 128 272V432C128 458.5 106.5 480 80 480H48C21.49 480 0 458.5 0 432V272C0 245.5 21.49 224 48 224H80zM80 256H48C39.16 256 32 263.2 32 272V432C32 440.8 39.16 448 48 448H80C88.84 448 96 440.8 96 432V272C96 263.2 88.84 256 80 256zM320 144C320 117.5 341.5 96 368 96H400C426.5 96 448 117.5 448 144V432C448 458.5 426.5 480 400 480H368C341.5 480 320 458.5 320 432V144zM352 144V432C352 440.8 359.2 448 368 448H400C408.8 448 416 440.8 416 432V144C416 135.2 408.8 128 400 128H368C359.2 128 352 135.2 352 144z"],
    "chart-simple-horizontal": [448, 512, [], "e474", "M448 272C448 298.5 426.5 320 400 320H48C21.49 320 0 298.5 0 272V240C0 213.5 21.49 192 48 192H400C426.5 192 448 213.5 448 240V272zM400 224H48C39.16 224 32 231.2 32 240V272C32 280.8 39.16 288 48 288H400C408.8 288 416 280.8 416 272V240C416 231.2 408.8 224 400 224zM256 432C256 458.5 234.5 480 208 480H48C21.49 480 0 458.5 0 432V400C0 373.5 21.49 352 48 352H208C234.5 352 256 373.5 256 400V432zM208 384H48C39.16 384 32 391.2 32 400V432C32 440.8 39.16 448 48 448H208C216.8 448 224 440.8 224 432V400C224 391.2 216.8 384 208 384zM48 160C21.49 160 0 138.5 0 112V80C0 53.49 21.49 32 48 32H336C362.5 32 384 53.49 384 80V112C384 138.5 362.5 160 336 160H48zM352 112V80C352 71.16 344.8 64 336 64H48C39.16 64 32 71.16 32 80V112C32 120.8 39.16 128 48 128H336C344.8 128 352 120.8 352 112z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M176 32C202.5 32 224 53.49 224 80V192C224 218.5 202.5 240 176 240H48C21.49 240 0 218.5 0 192V80C0 53.49 21.49 32 48 32H176zM176 64H48C39.16 64 32 71.16 32 80V192C32 200.8 39.16 208 48 208H176C184.8 208 192 200.8 192 192V80C192 71.16 184.8 64 176 64zM176 272C202.5 272 224 293.5 224 320V432C224 458.5 202.5 480 176 480H48C21.49 480 0 458.5 0 432V320C0 293.5 21.49 272 48 272H176zM176 304H48C39.16 304 32 311.2 32 320V432C32 440.8 39.16 448 48 448H176C184.8 448 192 440.8 192 432V320C192 311.2 184.8 304 176 304zM256 80C256 53.49 277.5 32 304 32H464C490.5 32 512 53.49 512 80V112C512 138.5 490.5 160 464 160H304C277.5 160 256 138.5 256 112V80zM288 80V112C288 120.8 295.2 128 304 128H464C472.8 128 480 120.8 480 112V80C480 71.16 472.8 64 464 64H304C295.2 64 288 71.16 288 80zM464 192C490.5 192 512 213.5 512 240V272C512 298.5 490.5 320 464 320H304C277.5 320 256 298.5 256 272V240C256 213.5 277.5 192 304 192H464zM464 224H304C295.2 224 288 231.2 288 240V272C288 280.8 295.2 288 304 288H464C472.8 288 480 280.8 480 272V240C480 231.2 472.8 224 464 224zM256 400C256 373.5 277.5 352 304 352H464C490.5 352 512 373.5 512 400V432C512 458.5 490.5 480 464 480H304C277.5 480 256 458.5 256 432V400zM288 400V432C288 440.8 295.2 448 304 448H464C472.8 448 480 440.8 480 432V400C480 391.2 472.8 384 464 384H304C295.2 384 288 391.2 288 400z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 160c35.29 0 64 28.71 64 64S195.3 288 160 288S96 259.3 96 224S124.7 160 160 160zM592 0h-384C181.5 0 160 21.53 160 48v32C160 88.84 167.2 96 176 96S192 88.84 192 80v-32C192 39.19 199.2 32 208 32h384C600.8 32 608 39.19 608 48v320c0 8.812-7.172 16-16 16H352c-8.844 0-16 7.156-16 16S343.2 416 352 416h240C618.5 416 640 394.5 640 368v-320C640 21.53 618.5 0 592 0zM192 352H128c-70.69 0-128 57.31-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM32 480c0-52.94 43.07-96 96-96h64c52.94 0 96 43.06 96 96H32zM315.3 164.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l80 80C375.8 270.4 379.9 272 384 272s8.188-1.562 11.31-4.688L496 166.6V224c0 8.844 7.156 16 16 16s16-7.156 16-16V128c0-8.844-7.156-16-16-16h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h57.38L384 233.4L315.3 164.7z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M16 32C24.84 32 32 39.16 32 48V400C32 426.5 53.49 448 80 448H496C504.8 448 512 455.2 512 464C512 472.8 504.8 480 496 480H80C35.82 480 0 444.2 0 400V48C0 39.16 7.164 32 16 32zM144 224C152.8 224 160 231.2 160 240V336C160 344.8 152.8 352 144 352C135.2 352 128 344.8 128 336V240C128 231.2 135.2 224 144 224zM256 240C256 248.8 248.8 256 240 256C231.2 256 224 248.8 224 240V144C224 135.2 231.2 128 240 128C248.8 128 256 135.2 256 144V240zM336 64C344.8 64 352 71.16 352 80V176C352 184.8 344.8 192 336 192C327.2 192 320 184.8 320 176V80C320 71.16 327.2 64 336 64zM448 336C448 344.8 440.8 352 432 352C423.2 352 416 344.8 416 336V80C416 71.16 423.2 64 432 64C440.8 64 448 71.16 448 80V336z"],
    "check": [448, 512, [10004, 10003], "f00c", "M443.3 100.7C449.6 106.9 449.6 117.1 443.3 123.3L171.3 395.3C165.1 401.6 154.9 401.6 148.7 395.3L4.686 251.3C-1.562 245.1-1.562 234.9 4.686 228.7C10.93 222.4 21.06 222.4 27.31 228.7L160 361.4L420.7 100.7C426.9 94.44 437.1 94.44 443.3 100.7H443.3z"],
    "check-double": [448, 512, [], "f560", "M171.3 235.3C165.1 241.6 154.9 241.6 148.7 235.3L68.69 155.3C62.44 149.1 62.44 138.9 68.69 132.7C74.93 126.4 85.06 126.4 91.31 132.7L160 201.4L308.7 52.69C314.9 46.44 325.1 46.44 331.3 52.69C337.6 58.93 337.6 69.06 331.3 75.31L171.3 235.3zM171.3 459.3C165.1 465.6 154.9 465.6 148.7 459.3L4.686 315.3C-1.562 309.1-1.562 298.9 4.686 292.7C10.93 286.4 21.06 286.4 27.31 292.7L160 425.4L420.7 164.7C426.9 158.4 437.1 158.4 443.3 164.7C449.6 170.9 449.6 181.1 443.3 187.3L171.3 459.3z"],
    "check-to-slot": [576, 512, ["vote-yea"], "f772", "M355.3 134.3L267.9 248.7l-49.34-43.5C211.9 199.3 201.8 199.1 196 206.6C190.2 213.2 190.8 223.3 197.4 229.2L259.6 284C262.6 286.6 266.3 288 270.2 288c.5313 0 1.206 .0187 1.737-.0125c4.406-.4375 8.294-2.737 10.98-6.269l97.78-128c5.375-7.031 4.031-17.06-3-22.44C370.7 125.9 360.7 127.2 355.3 134.3zM528 320c-8.844 0-16 7.156-16 16s7.156 16 16 16c8.812 0 16 7.172 16 16v64c0 8.828-7.188 16-16 16h-480C39.19 448 32 440.8 32 432v-64C32 359.2 39.19 352 48 352C56.84 352 64 344.8 64 336S56.84 320 48 320C21.53 320 0 341.5 0 368v64C0 458.5 21.53 480 48 480h480c26.47 0 48-21.53 48-48v-64C576 341.5 554.5 320 528 320zM80 416h416c8.836 0 16-7.164 16-16S504.8 384 496 384H480V80C480 53.49 458.5 32 432 32h-288C117.5 32 96 53.49 96 80V384H80C71.16 384 64 391.2 64 400S71.16 416 80 416zM128 80C128 71.16 135.2 64 144 64h288C440.8 64 448 71.16 448 80V384H128V80z"],
    "cheese": [512, 512, [], "f7ef", "M299.9 32.01L298.4 32c-7.125 .125-14.13 2.508-19.62 7.008L12.3 246.3C4.505 252.4 0 261.7 0 271.5v176.5C0 465.6 14.4 480 32 480h448c17.6 0 32-14.4 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM480 448H32V287.9h448V448zM52.12 255.9L298.8 64C400.4 69.62 480 153.8 480 255.9H52.12z"],
    "cheese-swiss": [512, 512, [129472], "f7f0", "M176 319.9c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S202.5 319.9 176 319.9zM187.4 379.3C184.4 382.3 180.3 384 176 384C167.1 384 160 376.8 160 367.9c0-8.75 7.125-16 16-16s16 7.25 16 16C192 372.1 190.4 376.3 187.4 379.3zM299.9 32.01L298.4 32c-7.125 .125-14.12 2.508-19.62 7.008L12.3 246.3C4.504 252.4 0 261.7 0 271.5v176.5C0 465.6 14.4 480 32 480h448c17.6 0 32-14.4 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM240 127.8c8.875 0 16 7.25 16 16c0 8.875-7.125 16-16 16s-16-7.125-16-16C224 135 231.1 127.8 240 127.8zM480 448H32V287.9h291c6.625 19.12 24.75 32 45 32s38.38-12.88 45-32H480V448zM352 271.9c0-8.875 7.125-16 16-16s16 7.125 16 16s-7.125 16-16 16S352 280.8 352 271.9zM413 255.9C406.4 236.8 388.3 223.9 368 223.9s-38.38 12.87-45 31.1H52.13l140.1-109C193.8 171 213 190.3 237.1 191.8s45.63-15.25 50-39c4.5-23.75-9.375-47.13-32.5-54.5L298.6 64C400.4 69.63 480 153.8 480 255.9H413z"],
    "cherries": [640, 512, [], "e0ec", "M532.2 224.3c-19.52 0-42.82 3.748-70.4 13.42c-36.15-148.4-164.5-237.7-173.9-237.7c-33.7 0-7.135 110.2-108.2 238.2c-28.25-10.07-52.05-13.96-71.92-13.96c-101.3 0-107.8 92.77-107.8 109.8c0 25.75 24.51 177.1 191.1 177.1c166.5 0 192-149.8 192-177.1c0-60.31-37.04-109.8-107.1-109.8c-14.55 0-31.21 2.081-50.16 7.144c21-30.87 51.75-89.18 72.74-186.8c34.06 28.62 102.5 96.3 129.1 190.9c-4.815-1.562-7.542-3.2-11.74-3.2c-6.875 0-13.28 4.537-15.33 11.47c-.4472 1.515-.6604 3.044-.6604 4.547c0 15.88 13.45 14.29 41.72 26.34l6.281 2.672L454.3 274.6c29.25-12.46 55.35-18.72 77.51-18.72c1.816 0 76.22-3.583 76.22 78.16C607.1 355.9 586.6 480 447.1 480c-39.31 0-56.87-10.43-64-10.43c-8.905 0-15.1 7.252-15.1 16.05c0 6.604 4.133 12.78 10.72 15.07c21.53 7.5 44.79 11.31 69.23 11.31c166.5 0 192.1-149.8 192.1-177.1C640 316.8 633.4 224.3 532.2 224.3zM275.8 255.9c1.816 0 76.21-3.585 76.21 78.16C352 355.9 330.6 480 192 480c-139.2 0-160-123.7-160-145.9c0-69.41 53.07-78.16 76.23-78.16c22.16 0 48.25 6.25 77.5 18.72l6.281 2.672L198.3 274.6C227.5 262.1 253.6 255.9 275.8 255.9z"],
    "chess": [512, 512, [], "f439", "M498.6 428.4L480 419.1V408c0-13.23-10.77-24-24-24h-112C330.8 384 320 394.8 320 408v11.06l-18.58 9.344C293.3 432.3 288 440.7 288 449.9V488c0 13.23 10.77 24 24 24h176c13.23 0 24-10.77 24-24v-38.13C512 440.8 506.8 432.3 498.6 428.4zM480 480h-160v-25.12l32-16.09V416h96v22.79l32 16.09V480zM56.88 224H48.97C40.1 224 33.55 229.4 32.23 237.3C30.55 247.3 38.3 256 48 256h16.01L64 284.5c-.0625 16.62-1.307 33.16-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.205 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.3 352c9.592 0 17.05-8.355 15.92-17.88C193.3 317.7 192.1 301.1 192 284.5L192 256h15.02c7.979 0 15.42-5.4 16.74-13.27C225.4 232.7 217.7 224 208 224H199.1l31.75-84.75c5.197-13.69 .5488-29.54-12.61-38.22C212.1 97.53 206.6 96 200.2 96H144V64h15.02c7.979 0 15.42-5.4 16.74-13.27C177.4 40.74 169.7 32 160 32h-16L144 16.97c0-7.979-5.4-15.42-13.27-16.74C120.7-1.449 112 6.303 112 16V32H96.86C88.88 32 81.55 37.4 80.23 45.26C78.55 55.26 86.31 64 96.01 64h16v32H55.77C49.42 96 43.03 97.53 37.73 101c-13.16 8.689-17.81 24.54-12.61 38.22L56.88 224zM201 128l-36 96H91.13l-36-96H201zM242.6 428.4L224 419.1V408C224 394.8 213.2 384 200 384h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208C245.2 512 256 501.2 256 488v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM496 160h-192C295.2 160 288 167.2 288 176V256c0 5.344 2.672 10.34 7.125 13.31L336 296.6V352c0 8.844 7.156 16 16 16s16-7.156 16-16V288c0-5.344-2.672-10.34-7.125-13.31L320 247.4V192h32v16C352 216.8 359.2 224 368 224S384 216.8 384 208V192h32v16C416 216.8 423.2 224 432 224S448 216.8 448 208V192h32v55.44l-40.88 27.25C434.7 277.7 432 282.7 432 288v64c0 8.844 7.156 16 16 16s16-7.156 16-16V296.6l40.88-27.25C509.3 266.3 512 261.3 512 256V176C512 167.2 504.8 160 496 160z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M64 372V400C64 408.8 71.16 416 80 416S96 408.8 96 400v-40.01c0-7.115-4.699-13.38-11.53-15.36l-11.53-3.354C53.15 335.5 32 317.4 32 284C32 231.4 86.32 136.9 130.8 96h58.41c20.15 18.54 42.11 48.19 60.34 79.84l-84.85 84.85c-6.25 6.25-6.25 16.38 0 22.62C167.8 286.4 171.9 288 176 288s8.188-1.562 11.31-4.688l77.83-77.83C278.8 234.3 288 262.6 288 284c0 33.45-21.15 51.52-40.94 57.27l-11.53 3.354C228.7 346.6 224 352.9 224 359.1V400c0 8.836 7.164 16 16 16s16-7.164 16-16v-28c33.88-9.854 64-40.68 64-88C320 217.4 253.6 105.6 201 64h-82C66.38 105.6 0 217.4 0 284C0 331.3 30.13 362.1 64 372zM112 32h96C216.9 32 224 24.88 224 16S216.9 0 208 0h-96C103.1 0 96 7.125 96 16S103.1 32 112 32zM272 448h-224C21.53 448 0 469.5 0 496C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.17 480 48 480h224c8.828 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C320 469.5 298.5 448 272 448z"],
    "chess-bishop-piece": [256, 512, ["chess-bishop-alt"], "f43b", "M242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM48 240C48 248.8 55.16 256 64 256h15.69l-15.38 76.88c-1.734 8.656 3.891 17.09 12.55 18.81C77.92 351.9 78.98 352 80.02 352c7.469 0 14.16-5.25 15.67-12.88l16-80C111.9 258.1 111.7 257 111.7 256h32.64c-.002 1.047-.2187 2.061-.0059 3.125l16 80C161.8 346.8 168.5 352 175.1 352c1.031 0 2.094-.0938 3.156-.3125c8.656-1.719 14.28-10.16 12.55-18.81L176.3 256H192c8.836 0 16-7.164 16-16c0-8.627-6.865-15.55-15.41-15.88c9.326-14.97 14.84-31.32 15.36-49.28c1.273-43.54-24.55-85.35-44.97-111.4C170.3 61.96 176 55.78 176 48C176 39.16 168.8 32 160 32H96C87.16 32 80 39.16 80 48c0 7.779 5.662 13.96 13.02 15.4c-20.42 26.09-46.25 67.9-44.97 111.4c.5234 17.96 6.035 34.3 15.36 49.28C54.87 224.4 48 231.4 48 240zM128 71.38c7.826 8.93 18.48 22.46 27.81 38.19L124.7 140.7c-6.25 6.25-6.25 16.38 0 22.62C127.8 166.4 131.9 168 136 168s8.188-1.562 11.31-4.688l22.94-22.94c3.719 10.98 6.059 22.31 5.717 33.6C175.4 193.1 167.6 209.5 152.2 224H103.8C88.41 209.5 80.61 193.1 80.03 173.1C78.8 133.3 110.6 91.25 128 71.38z"],
    "chess-board": [448, 512, [], "f43c", "M352 112H96C87.16 112 80 119.2 80 128v256c0 8.836 7.164 16 16 16h256c8.836 0 16-7.164 16-16V128C368 119.2 360.8 112 352 112zM144 368h-32v-32h32V368zM144 304h-32v-32h32V304zM144 240h-32v-32h32V240zM144 176h-32v-32h32V176zM208 368h-32v-32h32V368zM208 304h-32v-32h32V304zM208 240h-32v-32h32V240zM208 176h-32v-32h32V176zM272 368h-32v-32h32V368zM272 304h-32v-32h32V304zM272 240h-32v-32h32V240zM272 176h-32v-32h32V176zM336 368h-32v-32h32V368zM336 304h-32v-32h32V304zM336 240h-32v-32h32V240zM336 176h-32v-32h32V176zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM416 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V416z"],
    "chess-clock": [640, 512, [], "f43d", "M400 96h128C536.8 96 544 88.84 544 80S536.8 64 528 64h-128C391.2 64 384 71.16 384 80S391.2 96 400 96zM464 192C402.1 192 352 242.1 352 304s50.14 112 112 112S576 365.9 576 304S525.9 192 464 192zM520.6 360.6c-31.19 31.19-81.95 31.19-113.1 0s-31.19-81.95 0-113.1c27.32-27.32 69.63-30.7 100.7-10.17l-55.42 55.43c-6.252 6.254-6.253 16.37-.0013 22.63c6.254 6.254 16.37 6.254 22.63 0l55.43-55.42C551.3 290.9 547.9 333.3 520.6 360.6zM176 192C114.1 192 64 242.1 64 304S114.1 416 176 416S288 365.9 288 304S237.9 192 176 192zM176 384C131.9 384 96 348.1 96 304c0-38.63 27.53-70.95 64-78.38V304C160 312.8 167.2 320 176 320S192 312.8 192 304V225.6C228.5 233.1 256 265.4 256 304C256 348.1 220.1 384 176 384zM560 128H192V64h48c8.844 0 16.08-7.156 16.08-16S248.9 32 240.1 32H112.1c-8.844 0-16 7.156-16 16S103.2 64 112 64H160v64H80C35.82 128 0 163.8 0 208v192C0 444.2 35.82 480 80 480h480c44.18 0 80-35.82 80-80V207.1C640 163.8 604.2 128 560 128zM608 400c0 26.51-21.49 48-48 48h-480C53.49 448 32 426.5 32 400v-192C32 181.5 53.49 160 80 160h480C586.5 160 608 181.5 608 208V400z"],
    "chess-clock-flip": [640, 512, ["chess-clock-alt"], "f43e", "M256 80C256 71.16 248.8 64 240 64h-128C103.2 64 96 71.16 96 80S103.1 96 111.1 96h128C248.8 96 256 88.84 256 80zM463.9 192c-61.86 0-112 50.18-112 112S402.1 416 463.9 416s112-50.08 112-111.9S525.8 192 463.9 192zM464 384c-44.11 0-80-35.89-80-80c0-38.63 27.53-70.95 64-78.38V304c0 8.844 7.156 16 16 16S480 312.8 480 304V225.6C516.5 233.1 544 265.4 544 304C544 348.1 508.1 384 464 384zM0 207.1L0 400C0 444.2 35.82 480 80 480h480c44.18 0 80-35.82 80-80V207.1C640 163.8 604.2 128 560 128H480V64h48c8.844 0 15.96-7.156 15.96-16s-7.156-16-16-16h-127.1c-8.844 0-16 7.156-16 16S391.2 64 400 64H448v64H80C35.82 128 0 163.8 0 207.1zM32 208C32 181.5 53.49 160 80 160h480C586.5 160 608 181.5 608 208v192c0 26.51-21.49 48-48 48h-480C53.49 448 32 426.5 32 400V208zM176 192C114.1 192 63.94 242.1 63.94 304s50.14 112 112 112s112-50.12 112-111.1S237.9 192 176 192zM232.6 360.6c-31.19 31.19-81.95 31.19-113.1 0s-31.19-81.95 0-113.1C146.7 220.1 189.1 216.7 220.1 237.3L164.7 292.7C158.4 298.9 158.4 309.1 164.7 315.3c6.254 6.254 16.37 6.254 22.63 0L242.7 259.9C263.3 290.9 259.9 333.3 232.6 360.6z"],
    "chess-king": [448, 512, [9818], "f43f", "M367.1 448H79.97c-26.47 0-48.01 21.53-48.01 47.1C31.96 504.8 39.12 512 47.96 512S64 504.8 64 496C64 487.2 71.17 480 80 480h288c8.828 0 16 7.188 16 16c0 8.844 7.171 16 16.01 16s16-7.156 16-16C416 469.5 394.5 448 367.1 448zM423.2 180.2C414.2 167.6 399.7 160 384.2 160H240V96H288c8.844 0 15.99-7.157 15.99-16S296.8 64 288 64h-48V16c0-8.844-7.172-16-16.02-16S208 7.156 208 16V64H160C151.2 64 143.1 71.16 143.1 80S151.2 96 160 96h48v64H63.81C48.34 160 33.78 167.6 24.83 180.2C15.83 193 13.58 209.4 18.73 223.9l61.72 181.3c2.859 8.375 11.94 12.75 20.3 10c8.359-2.844 12.84-11.94 9.984-20.31L48.95 213.4C45.13 202.6 53.27 192 63.81 192h320.4c10.6 0 18.66 10.66 14.86 21.41l-64.28 181.3c-2.953 8.312 1.406 17.47 9.734 20.44c11.23 3.977 18.65-4.749 20.42-9.75l64.28-181.3C434.4 209.4 432.2 193 423.2 180.2z"],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", "M56.88 224H48.97C40.1 224 33.55 229.4 32.23 237.3C30.55 247.3 38.3 256 48 256h16.01L64 284.5c-.0625 16.62-1.307 33.16-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.205 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.3 352c9.592 0 17.05-8.355 15.92-17.88C193.3 317.7 192.1 301.1 192 284.5L192 256h15.02c7.979 0 15.42-5.4 16.74-13.27C225.4 232.7 217.7 224 208 224h-8.882l31.75-84.75c5.197-13.69 .5488-29.54-12.61-38.22C212.1 97.53 206.6 96 200.2 96h-56.23V64h15.02c7.979 0 15.42-5.4 16.74-13.27C177.4 40.74 169.7 32 160 32h-16L144 16.97c0-7.979-5.4-15.42-13.27-16.74C120.7-1.449 112 6.303 112 16V32H96.86C88.88 32 81.55 37.4 80.23 45.26C78.55 55.26 86.31 64 96.01 64h16v32H55.77C49.42 96 43.03 97.53 37.73 101c-13.16 8.689-17.81 24.54-12.61 38.22L56.88 224zM201 128l-36 96H91.13l-36-96H201zM242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480z"],
    "chess-knight": [384, 512, [9822], "f441", "M64 164C64 175 73 184 84 184S104 175 104 164S95 144 84 144S64 153 64 164zM35.5 301.6c38 16.88 36.75 16.5 40.38 17.75C28.77 351.3 32.06 387.4 32.06 400c0 8.836 7.102 16 15.94 16S64 408.8 64 400c0-39.61 11.33-43.32 80.63-84c14.12-7 23-21.5 23-37.25V216.5L151.5 226.1C145.1 228.9 141.1 233.8 140.6 239.8l-8 26.5C130.2 274.4 124.1 280.1 116.2 284.1L105 288.5C98.11 291.2 90.4 291 83.63 288L48.5 272.4C38.5 268 32 258 32 247V128c0-10.38 6.5-15 13.88-22.5L33.5 81C28.88 71.63 35.13 64 42.38 64H128c106 0 192 85.96 192 192v144c0 8.836 7.164 16 16 16s16-7.164 16-16V256c0-123.7-100.3-224-224-224H44.34C22.92 32 3.344 47.03 .4199 68.24C-.8652 77.57 .8359 86.92 5 95.25l2.625 5.5C2.625 109 0 118.4 0 128.1v119C0 270.6 13.88 292 35.5 301.6zM336 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h288c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C384 469.5 362.5 448 336 448z"],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", "M31.63 277.3l26.62 12c-10.76 11.61-19.88 26.13-23.74 44.05C32.43 342.1 40.24 352 50.14 352c7.393 0 13.8-5.125 15.42-12.34c10.53-47.06 79.07-59.02 79.07-89.41V207.5l-21.25 5c-4.125 2.125-7.125 6-8.25 10.5L109 243.4C107.1 249.6 102.5 254.6 96.5 257L88 260.4c-5.25 2.125-11.25 2-16.5-.25l-26.88-12C37 244.6 32 237 32 228.6V145.3c0-4.322 1.717-8.467 4.773-11.52l5.852-5.852L33.25 109C32.38 107.5 32 105.8 32 104C32 99.63 35.63 96 40 96h86.13C197.6 96 256 154.4 256 225.9v110.3C256 344.9 263.2 352 271.1 352S288 344.9 288 336.1V225.9C288 136.5 215.5 64 126.1 64H41.8C19.85 64 .6172 80.9 .0156 102.8C-.1797 110 1.461 116.9 4.5 123.3L4.875 124C1.625 130.6 0 137.9 0 145.3v83.38C0 249.6 12.38 268.8 31.63 277.3zM61.1 170.8c0 8.25 6.625 14.88 14.88 14.88s14.88-6.75 14.88-15c0-8.125-6.75-14.75-14.88-14.75C68.63 155.9 61.1 162.5 61.1 170.8zM306.6 428.4L288 419.1V408c0-13.23-10.77-24-24-24h-208C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-38.13C320 440.8 314.8 432.3 306.6 428.4zM288 480H32v-25.12l32-16.09V416h192v22.79l32 16.09V480z"],
    "chess-pawn": [320, 512, [9823], "f443", "M272 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h224c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C320 469.5 298.5 448 272 448zM80 208C71.16 208 64 215.2 64 224s7.156 16 16 16h19.97l-35.56 156.5C62.22 406 69.3 416 80 416c7.312 0 13.91-5.031 15.59-12.47L132.8 240h54.48l37.17 163.5C226.1 410.1 232.7 416 240 416c10.91 0 17.74-10.18 15.59-19.53L220 240H240C248.8 240 256 232.8 256 224s-7.156-16-16-16h-5.254C252.8 189.3 264 163.1 264 136C264 78.66 217.3 32 159.1 32S56 78.66 56 136c0 27.97 11.23 53.29 29.25 72H80zM160 64c39.69 0 72 32.31 72 72S199.7 208 160 208S88 175.7 88 136S120.3 64 160 64z"],
    "chess-pawn-piece": [256, 512, ["chess-pawn-alt"], "f444", "M242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM48 240C48 248.8 55.16 256 64 256h13.12l-12.9 77.38c-1.469 8.719 4.438 16.97 13.16 18.41C78.25 351.9 79.16 352 80.03 352c7.656 0 14.44-5.531 15.75-13.38L109.6 256h36.89l13.77 82.63C161.5 346.5 168.3 352 175.1 352c.875 0 1.781-.0625 2.656-.2187c8.719-1.438 14.62-9.688 13.16-18.41L178.9 256H192c8.838 0 16-7.164 16-16S200.8 224 192 224h-.3613c10.13-13.4 16.36-29.94 16.36-48.03C208 131.8 172.2 96 127.1 96C83.79 96 47.1 131.8 47.1 175.1c0 18.09 6.234 34.63 16.36 48.03H64C55.16 224 48 231.2 48 240zM128 128c26.47 0 48 21.53 48 48S154.5 224 128 224S80 202.5 80 176S101.5 128 128 128z"],
    "chess-queen": [512, 512, [9819], "f445", "M399.1 448H111.1c-26.47 0-48 21.53-48 47.1C63.98 504.8 71.14 512 79.98 512S96 504.8 96 496C96 487.2 103.2 480 112 480h288c8.812 0 16 7.188 16 16c0 8.844 7.153 16 15.1 16s16-7.156 16-16C447.1 469.5 426.5 448 399.1 448zM481.7 179.9l-23.84-13.41c-13.47-9.094-31.19-5.75-41.28 7.812c-5.938 7.969-15.84 11.94-25.56 10.06c-11.97-2.25-20.97-14.5-20.97-28.53C369.1 140.5 357.6 128 342.3 128h-33.91c-13 0-24.34 9.031-26.94 21.5C278.8 161.9 268.4 170.7 256 170.7S233.2 161.9 230.5 149.5C227.9 137 216.6 128 203.6 128H169.7C154.4 128 141.1 140.5 141.1 155.9c0 15.03-10.84 28.03-24.19 28.94C109.2 185.9 100.7 181.5 95.47 174.4C85.53 160.7 67.41 157.4 55.34 165.9L29.44 180.6C16.78 188.9 12.34 205.5 19.06 219l89.72 187.9c3.812 7.938 13.28 11.28 21.34 7.531c7.969-3.812 11.34-13.34 7.531-21.34L48.5 206.4l21.12-13.16c11.84 16.09 30.5 24.97 50.44 23.47C149 214.7 171.9 190.2 173.9 160h26.31C207.3 185.3 229.7 202.7 256 202.7c26.31 0 48.75-17.34 55.81-42.66h26.31c1.75 27.84 20.94 51 46.81 55.81c21.5 4.219 44.06-4.531 56.03-22.09l23.09 11.5l-89.72 187.9c-3.812 8-.4375 17.53 7.531 21.34C384.1 415.5 386.5 416 388.8 416c5.969 0 11.69-3.344 14.44-9.094l89.66-187.8C499.5 205.6 495.2 189 481.7 179.9zM256 112c30.93 0 56-25.07 56-56S286.9 0 256 0S199.1 25.07 199.1 56S225.1 112 256 112zM256 32c13.23 0 24 10.77 24 24c0 13.23-10.77 24-24 24S232 69.23 232 56C232 42.77 242.8 32 256 32z"],
    "chess-queen-piece": [256, 512, ["chess-queen-alt"], "f446", "M128 48c13.25 0 24-10.75 24-24S141.3 0 128 0S104 10.75 104 24S114.8 48 128 48zM242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM62.38 224H48C39.2 224 32 231.2 32 240C32 248.8 39.2 256 48 256H64v28.5c-.0625 16.64-1.307 33.17-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.207 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.4 352c9.592 0 17.05-8.359 15.91-17.88C193.3 317.7 192.1 301.1 192 284.5V256h16C216.8 256 224 248.8 224 240C224 231.2 216.8 224 208 224h-14.38l50.88-124.3c1.75-3.375 .625-7.5-2.5-9.5l-11.12-7.5C226.3 79.99 222.1 82.79 220.5 85c-12.76 16.89-40.25 8.504-40.25-14.75C180.3 66.34 176.8 64 173.1 64h-18.12c-2.75-.125-5.25 1.875-6 4.625C147.8 79 138.6 86.38 128 86.38S108.3 79 106.1 68.63C105.4 65.88 102.9 63.88 100.1 64H81.1C78.43 64 75.79 66.96 75.75 70.53C75.48 93.34 48.05 101.1 35.5 84.88c-1.057-1.41-5.088-5.299-10.38-2.125l-11.13 7.5c-3.125 2-4.25 6.125-2.5 9.5L62.38 224zM56.75 125.8c14.5-1 28.25-7.875 37.63-19c19.62 15.62 47.5 15.62 67.13 .125c12.19 14.47 28.33 18.48 37.75 19L159 224h-62L56.75 125.8z"],
    "chess-rook": [384, 512, [9820], "f447", "M336 32h-288C21.53 32 0 53.53 0 80V192c0 4.25 1.688 8.312 4.688 11.31l59.28 59.34c0 38.89 1.065 64.09-10.44 134.8c-1.438 8.719 4.5 16.94 13.22 18.34c8.5 1.469 16.94-4.469 18.34-13.22C96.1 329.5 96.05 303.5 95.94 256c0-4.25-1.688-8.312-4.688-11.31L32 185.4V80C32 71.19 39.19 64 48 64h64v64c0 8.836 7.164 16 16 16S144 136.8 144 128V64h96v64c0 8.836 7.164 16 16 16s16-7.164 16-16V64h64C344.8 64 352 71.19 352 80v105.4l-59.25 59.31C289.8 247.7 288.1 251.8 288.1 256c-.115 48.52-.9936 73.91 10.84 146.6c2.209 13.58 15.63 13.7 18.34 13.22c8.719-1.406 14.66-9.625 13.22-18.34c-11.47-70.51-10.44-96.19-10.44-134.8l59.28-59.34C382.3 200.3 384 196.3 384 192V80C384 53.53 362.5 32 336 32zM336 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h288c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C384 469.5 362.5 448 336 448zM224 320c8.844 0 16-7.156 16-16v-64C240 213.5 218.5 192 192 192S144 213.5 144 240v64C144 312.8 151.2 320 160 320H224zM176 240C176 231.2 183.2 224 192 224s16 7.188 16 16V288h-32V240z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M306.6 428.4L288 419.1V408c0-13.23-10.77-24-24-24h-208C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-38.13C320 440.8 314.8 432.3 306.6 428.4zM288 480H32v-25.12l32-16.09V416h192v22.79l32 16.09V480zM71.28 232.4l-7.25 102.4c-.625 8.812 6.031 16.47 14.84 17.09C79.25 352 79.63 352 80.03 352c8.312 0 15.34-6.438 15.94-14.88l8.25-116.8L68.56 183.9C65.63 181 64 177.1 64 172.9V96h48v32c0 8.836 7.164 16 16 16S144 136.8 144 128V96h32v32c0 8.836 7.164 16 16 16s16-7.164 16-16V96H256v76.75c0 4.281-1.625 8.25-4.656 11.28l-35.56 36.16l8.25 116.9c.625 8.844 9 15.62 17.09 14.84c8.812-.625 15.47-8.281 14.84-17.09l-7.25-102.6l25.34-25.75C283.1 197.6 288 185.6 288 172.8V88C288 74.78 277.2 64 264 64h-208C42.78 64 32 74.78 32 88v84.88c0 12.75 4.938 24.69 13.81 33.56L71.28 232.4zM144 224v32h32V224c0-8.838-7.164-16-16-16S144 215.2 144 224z"],
    "chestnut": [448, 512, [127792], "e3f6", "M302.9 99.43c-25.37-20.56-49.36-39.98-66.49-61.41C233.2 34.01 228.6 32 224 32S214.8 34.01 211.5 38.02C194.4 59.45 170.4 78.87 145.1 99.43C80.44 151.7 0 216.8 0 352C0 422.7 57.31 480 128 480h192c70.69 0 128-57.3 128-127.1C448 216.8 367.6 151.7 302.9 99.43zM165.5 124.1C186.7 106.9 206.9 90.48 224 72.38c17.09 18.11 37.4 34.57 58.83 51.94C345.2 174.8 415.1 232.1 415.1 352H32C32.01 232.1 102.8 174.8 165.5 124.1zM320 448H128c-41.67 0-76.86-26.84-90.11-64.01h372.2C396.9 421.2 361.7 448 320 448z"],
    "chevron-down": [448, 512, [], "f078", "M4.251 181.1C7.392 177.7 11.69 175.1 16 175.1c3.891 0 7.781 1.406 10.86 4.25l197.1 181.1l197.1-181.1c6.5-6 16.64-5.625 22.61 .9062c6 6.5 5.594 16.59-.8906 22.59l-208 192c-6.156 5.688-15.56 5.688-21.72 0l-208-192C-1.343 197.7-1.749 187.6 4.251 181.1z"],
    "chevron-left": [320, 512, [9001], "f053", "M234.8 36.25c3.438 3.141 5.156 7.438 5.156 11.75c0 3.891-1.406 7.781-4.25 10.86L53.77 256l181.1 197.1c6 6.5 5.625 16.64-.9062 22.61c-6.5 6-16.59 5.594-22.59-.8906l-192-208c-5.688-6.156-5.688-15.56 0-21.72l192-208C218.2 30.66 228.3 30.25 234.8 36.25z"],
    "chevron-right": [320, 512, [9002], "f054", "M85.14 475.8c-3.438-3.141-5.156-7.438-5.156-11.75c0-3.891 1.406-7.781 4.25-10.86l181.1-197.1L84.23 58.86c-6-6.5-5.625-16.64 .9062-22.61c6.5-6 16.59-5.594 22.59 .8906l192 208c5.688 6.156 5.688 15.56 0 21.72l-192 208C101.7 481.3 91.64 481.8 85.14 475.8z"],
    "chevron-up": [448, 512, [], "f077", "M443.8 330.8C440.6 334.3 436.3 336 432 336c-3.891 0-7.781-1.406-10.86-4.25L224 149.8l-197.1 181.1c-6.5 6-16.64 5.625-22.61-.9062c-6-6.5-5.594-16.59 .8906-22.59l208-192c6.156-5.688 15.56-5.688 21.72 0l208 192C449.3 314.3 449.8 324.3 443.8 330.8z"],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", "M421.1 244.2L224 426.2l-197.1-181.1C23.78 241.4 19.89 239.1 16 239.1c-4.312 0-8.609 1.719-11.75 5.156c-6 6.5-5.594 16.59 .8906 22.59l208 192c6.156 5.688 15.56 5.688 21.72 0l208-192c6.484-6 6.891-16.09 .8906-22.59C437.8 238.6 427.6 238.2 421.1 244.2zM213.1 267.8c6.156 5.688 15.56 5.688 21.72 0l208-192c6.484-6 6.891-16.09 .8906-22.59c-5.969-6.531-16.11-6.906-22.61-.9062L224 234.2L26.86 52.26C23.78 49.41 19.89 48.01 16 48.01c-4.312 0-8.609 1.719-11.75 5.156c-6 6.5-5.594 16.59 .8906 22.59L213.1 267.8z"],
    "chevrons-left": [448, 512, ["chevron-double-left"], "f323", "M235.8 453.1L53.8 256l181.1-197.1c2.844-3.078 4.25-6.969 4.25-10.86c0-4.312-1.719-8.609-5.156-11.75c-6.5-6-16.59-5.594-22.59 .8906l-192 208c-5.688 6.156-5.688 15.56 0 21.72l192 208c6 6.484 16.09 6.891 22.59 .8906C241.4 469.8 241.8 459.6 235.8 453.1zM212.2 245.1c-5.688 6.156-5.688 15.56 0 21.72l192 208c6 6.484 16.09 6.891 22.59 .8906c6.531-5.969 6.906-16.11 .9062-22.61l-181.1-197.1l181.1-197.1c2.844-3.078 4.25-6.969 4.25-10.86c0-4.312-1.719-8.609-5.156-11.75c-6.5-6-16.59-5.594-22.59 .8906L212.2 245.1z"],
    "chevrons-right": [448, 512, ["chevron-double-right"], "f324", "M212.2 58.86l181.1 197.1L212.2 453.1c-2.844 3.078-4.25 6.969-4.25 10.86c0 4.312 1.719 8.609 5.156 11.75c6.5 6 16.59 5.594 22.59-.8906l192-208c5.688-6.156 5.688-15.56 0-21.72l-192-208c-6-6.484-16.09-6.891-22.59-.8906C206.6 42.22 206.2 52.36 212.2 58.86zM235.8 266.9c5.688-6.156 5.688-15.56 0-21.72l-192-208c-6-6.484-16.09-6.891-22.59-.8906c-6.531 5.969-6.906 16.11-.9062 22.61l181.1 197.1L20.26 453.1c-2.844 3.078-4.25 6.969-4.25 10.86c0 4.312 1.719 8.609 5.156 11.75c6.5 6 16.59 5.594 22.59-.8906L235.8 266.9z"],
    "chevrons-up": [448, 512, ["chevron-double-up"], "f325", "M26.86 267.8l197.1-181.1l197.1 181.1C424.2 270.6 428.1 272 432 272c4.312 0 8.609-1.719 11.75-5.156c6-6.5 5.594-16.59-.8906-22.59l-208-192c-6.156-5.688-15.56-5.688-21.72 0l-208 192c-6.484 6-6.891 16.09-.8906 22.59C10.22 273.4 20.36 273.8 26.86 267.8zM234.9 244.2c-6.156-5.688-15.56-5.688-21.72 0l-208 192c-6.484 6-6.891 16.09-.8906 22.59c5.969 6.531 16.11 6.906 22.61 .9062l197.1-181.1l197.1 181.1c3.078 2.844 6.969 4.25 10.86 4.25c4.312 0 8.609-1.719 11.75-5.156c6-6.5 5.594-16.59-.8906-22.59L234.9 244.2z"],
    "child": [320, 512, [], "f1ae", "M224 64C224 99.35 195.3 128 159.1 128C124.7 128 95.1 99.35 95.1 64C95.1 28.65 124.7 0 159.1 0C195.3 0 224 28.65 224 64zM159.1 32C142.3 32 127.1 46.33 127.1 64C127.1 81.67 142.3 96 159.1 96C177.7 96 192 81.67 192 64C192 46.33 177.7 32 159.1 32zM29.64 312.4C25.02 319.9 15.17 322.3 7.637 317.6C.1046 313-2.257 303.2 2.363 295.6L46.62 223.5C70.8 184 113.7 159.1 160 159.1C206.3 159.1 249.2 184 273.4 223.5L317.6 295.6C322.3 303.2 319.9 313 312.4 317.6C304.8 322.3 294.1 319.9 290.4 312.4L246.1 240.2C244.2 237.1 242.2 234.2 239.1 231.3V496C239.1 504.8 232.8 512 223.1 512C215.2 512 207.1 504.8 207.1 496V384H112V496C112 504.8 104.8 512 96 512C87.17 512 80 504.8 80 496V231.3C77.82 234.2 75.79 237.1 73.9 240.2L29.64 312.4zM207.1 352V204.1C193.5 196.3 177 192 160 192C142.1 192 126.5 196.3 112 204.1V352H207.1z"],
    "child-dress": [320, 512, [], "e59c", "M95.1 64C95.1 28.65 124.7 0 159.1 0C195.3 0 223.1 28.65 223.1 64C223.1 99.35 195.3 128 159.1 128C124.7 128 95.1 99.35 95.1 64V64zM159.1 96C177.7 96 191.1 81.67 191.1 64C191.1 46.33 177.7 32 159.1 32C142.3 32 127.1 46.33 127.1 64C127.1 81.67 142.3 96 159.1 96zM96 400H71.1C67.02 400 62.33 397.7 59.3 393.7C56.27 389.8 55.25 384.6 56.55 379.8L98.02 225.8L28.57 313.9C23.1 320.8 13.03 322 6.095 316.6C-.8442 311.1-2.034 301 3.437 294.1L77.69 199.9C96.52 176 124.7 161.6 154.1 160.1C156.2 160 157.4 160 158.7 160H161.3C162.6 160 163.8 160 165 160.1C195.3 161.6 223.5 176 242.3 199.9L316.6 294.1C322 301 320.8 311.1 313.9 316.6C306.1 322 296.9 320.8 291.4 313.9L221.1 225.8L263.5 379.8C264.7 384.6 263.7 389.8 260.7 393.7C257.7 397.7 252.1 400 248 400H224V496C224 504.8 216.8 512 208 512C199.2 512 192 504.8 192 496V400H128V496C128 504.8 120.8 512 112 512C103.2 512 96 504.8 96 496L96 400zM135.5 209.8L92.87 368H227.1L184.5 209.8C181.9 199.9 173.2 192.8 163.2 192.1C162.1 192 161.1 192 160 192C158.9 192 157.9 192 156.8 192.1C146.8 192.8 138.1 199.9 135.5 209.8z"],
    "child-reaching": [384, 512, [], "e59d", "M256 64C256 99.35 227.3 128 191.1 128C156.7 128 127.1 99.35 127.1 64C127.1 28.65 156.7 0 191.1 0C227.3 0 256 28.65 256 64zM191.1 32C174.3 32 159.1 46.33 159.1 64C159.1 81.67 174.3 96 191.1 96C209.7 96 224 81.67 224 64C224 46.33 209.7 32 191.1 32zM112 188C84.19 173.2 60.59 150.6 44.48 122.2L34.09 103.9C29.73 96.21 32.42 86.45 40.11 82.09C47.79 77.72 57.56 80.42 61.92 88.1L72.31 106.4C96.73 149.4 142.4 176 191.9 176C240.7 176 285.1 150 310.6 107.8L322.2 87.94C326.6 80.3 336.4 77.73 344.1 82.18C351.7 86.63 354.3 96.43 349.8 104.1L338.2 123.9C322.2 151.4 299.1 173.3 272 187.9V496C272 504.8 264.8 512 256 512C247.2 512 240 504.8 240 496V384H144V496C144 504.8 136.8 512 128 512C119.2 512 112 504.8 112 496L112 188zM144 201.1V352H240V201C224.6 205.6 208.4 208 191.9 208C175.4 208 159.3 205.6 144 201.1H144z"],
    "child-rifle": [512, 512, [], "e4e0", "M207.1 64C207.1 99.35 179.3 128 143.1 128C108.6 128 79.99 99.35 79.99 64C79.99 28.65 108.6 .0003 143.1 .0003C179.3 .0003 207.1 28.65 207.1 64zM143.1 32C126.3 32 111.1 46.33 111.1 64C111.1 81.67 126.3 96 143.1 96C161.7 96 175.1 81.67 175.1 64C175.1 46.33 161.7 32 143.1 32zM480 208C480 199.2 487.2 192 496 192C504.8 192 512 199.2 512 208V292.5C512 299.4 507.6 305.5 501.1 307.6L448 325.3V352L451.2 368H496C504.8 368 512 375.2 512 384C512 392.8 504.8 400 496 400H457.6L476.2 492.9C478.2 502.8 470.6 512 460.5 512H368C359.2 512 352 504.8 352 496V400C334.3 400 320 385.7 320 368V224C320 206.3 334.3 192 352 192V160C352 142.3 366.3 128 384 128V32C375.2 32 368 24.84 368 16C368 7.164 375.2 0 384 0H400C408.8 0 416 7.164 416 16V128C433.7 128 448 142.3 448 160V288L480 280V208zM384 224H352V368H384V480H440.1L416 355.2V160H384V224zM111.1 384V496C111.1 504.8 104.8 512 95.1 512C87.16 512 79.1 504.8 79.1 496V243.3L37.64 312.4C33.02 319.9 23.17 322.3 15.63 317.6C8.101 313 5.739 303.2 10.36 295.6L70.13 198.2C84.68 174.5 110.5 160 138.3 160H149.7C177.5 160 203.3 174.5 217.9 198.2L277.6 295.6C282.3 303.2 279.9 313 272.4 317.6C264.8 322.3 254.1 319.9 250.4 312.4L207.1 243.3V496C207.1 504.8 200.8 512 191.1 512C183.2 512 175.1 504.8 175.1 496V384H111.1zM111.1 200V352H175.1V200L175.1 199.9C168.3 194.8 159.2 192 149.7 192H138.3C128.8 192 119.7 194.8 111.1 199.9L111.1 200z"],
    "children": [640, 512, [], "e4e1", "M224 64C224 99.35 195.3 128 160 128C124.7 128 96 99.35 96 64C96 28.65 124.7 0 160 0C195.3 0 224 28.65 224 64zM160 32C142.3 32 128 46.33 128 64C128 81.67 142.3 96 160 96C177.7 96 192 81.67 192 64C192 46.33 177.7 32 160 32zM544 64C544 99.35 515.3 128 480 128C444.7 128 416 99.35 416 64C416 28.65 444.7 0 480 0C515.3 0 544 28.65 544 64zM480 32C462.3 32 448 46.33 448 64C448 81.67 462.3 96 480 96C497.7 96 512 81.67 512 64C512 46.33 497.7 32 480 32V32zM432 512C423.2 512 416 504.8 416 496V243.3L373.6 312.4C369 319.9 359.2 322.3 351.6 317.6C344.1 313 341.7 303.2 346.4 295.6L403.2 203C419.6 176.3 448.7 160 480 160C511.4 160 540.5 176.3 556.8 203L613.6 295.6C618.3 303.2 615.9 313 608.4 317.6C600.8 322.3 590.1 319.9 586.4 312.4L544 243.3V496C544 504.8 536.8 512 528 512C519.2 512 512 504.8 512 496V384H448V496C448 504.8 440.8 512 432 512H432zM480 192C468.4 192 457.4 195.4 448 201.6V352H512V201.6C502.7 195.4 491.6 192 480 192zM96.01 400H72C67.02 400 62.33 397.7 59.3 393.7C56.27 389.8 55.26 384.6 56.55 379.8L94.57 238.6L45.34 312.8C40.45 320.2 30.52 322.2 23.16 317.3C15.8 312.4 13.79 302.5 18.67 295.2L79.78 203C96.56 177.8 124.2 161.1 154.3 160.2C155.7 160.1 157.2 160 158.7 160H161.4C162.8 160 164.3 160.1 165.7 160.2C195.8 161.1 223.4 177.8 240.2 203L301.3 295.2C306.2 302.5 304.2 312.4 296.9 317.3C289.5 322.2 279.6 320.2 274.7 312.8L225.4 238.6L263.5 379.8C264.7 384.6 263.7 389.8 260.7 393.7C257.7 397.7 252.1 400 248 400H224V496C224 504.8 216.8 512 208 512C199.2 512 192 504.8 192 496V400H128V496C128 504.8 120.8 512 112 512C103.2 512 96.01 504.8 96.01 496V400zM135.5 209.8L92.88 368H227.1L184.5 209.8C181.9 199.1 173.4 192.1 163.5 192.1C162.3 192 161.2 192 160 192C158.8 192 157.7 192 156.5 192.1C146.6 192.1 138.1 199.1 135.5 209.8V209.8z"],
    "chimney": [448, 512, [], "f78b", "M416 32H32C14.33 32 0 46.33 0 64v64c0 17.67 14.33 32 32 32l0 303.1c0 7.971 5.448 15.36 13.32 16.64C55.34 481.4 64 473.7 64 464V416h224v48C288 472.8 295.2 480 303.1 480S320 472.8 320 464V416h64v47.15c0 7.971 5.448 15.36 13.32 16.64C407.3 481.4 416 473.7 416 464V160c17.67 0 32-14.33 32-32V64C448 46.33 433.7 32 416 32zM128 256H64V160h64V256zM64 384V288h128v96H64zM384 384h-160V288h160V384zM384 256H160V160h224V256zM416 128H32V64h384V128z"],
    "chopsticks": [640, 512, [], "e3f7", "M637.7 102.9C639.9 109.1 640.5 117.4 639.6 124.8C638.8 132.1 636.4 139.2 632.7 145.6C628.1 151.1 624 157.5 618.1 161.1L176.7 505.8C171.4 509.8 164.9 512 158.2 512C152.1 512 146.2 510.2 141.2 506.8C136.1 503.3 132.3 498.5 130.1 492.8C127.8 487.1 127.4 480.9 128.8 475C130.2 469.1 133.3 463.7 137.8 459.6L548.1 78.56C553.6 73.51 559.1 69.64 566.1 67.19C573.1 64.74 581.4 63.76 588.8 64.32C596.2 64.75 603.4 66.67 609.1 69.97C616.6 73.27 622.4 77.88 627.2 83.52C632 89.17 635.6 95.76 637.7 102.9L637.7 102.9zM604.1 129.7C606.6 127.1 607.6 124.1 608 120.1C608.3 117.9 608 114.9 607.1 111.9C606.2 109 604.7 106.4 602.7 104.1C600.7 101.7 598.2 99.77 595.5 98.38C592.7 96.99 589.7 96.18 586.7 95.1C583.5 95.69 580.4 96.06 577.5 97.1C574.5 98.14 571.8 99.82 569.6 102L189.6 455.2L598.6 136.5C601.2 134.7 603.4 132.4 604.1 129.7zM415.8 50.46C416.4 57.85 415.5 65.28 413.2 72.31C410.9 79.34 407.1 85.82 402.2 91.36L52.7 501.6C49.89 504.9 46.4 507.5 42.49 509.3C38.57 511.1 34.32 511.1 30.02 512C23.11 512 16.41 509.7 11.07 505.3C5.11 500.4 1.243 493.4 .2568 485.7C-.7298 478 1.238 470.3 5.761 464L317.1 22.56C322.3 16.56 327.8 11.51 334.2 7.714C340.5 3.917 347.6 1.456 354.9 .4798C362.2-.5109 369.6 .0363 376.7 2.086C383.8 4.136 390.4 7.644 396 12.38C401.7 17.06 406.4 22.85 409.8 29.4C413.2 35.94 415.2 43.11 415.8 50.46H415.8zM382.7 62.43C383.8 59.48 384.2 56.35 383.1 53.24C383.8 50.12 382.9 47.08 381.5 44.3C380.1 41.52 378.1 39.06 375.7 37.06C373.4 35.18 370.7 33.78 367.8 32.95C364.1 32.12 361.1 31.88 359 32.22C356 32.6 353.2 33.59 350.6 35.14C347.1 36.68 345.8 38.74 344 41.18L55.46 449.1L378 70.4C380.1 68.09 381.7 65.38 382.7 62.43H382.7z"],
    "church": [640, 512, [9962], "f51d", "M336 48H376C384.8 48 392 55.16 392 64C392 72.84 384.8 80 376 80H336V119.4L451.5 196.4C469.3 208.3 480 228.3 480 249.7V480H576C593.7 480 608 465.7 608 448V378.1C608 367.3 602.5 357.1 593.4 351.2L512 298.6V260.5L610.8 324.4C628.1 336.2 640 356.4 640 378.1V448C640 483.3 611.3 512 576 512L64 512C28.65 512 0 483.3 0 448V378.1C0 356.4 11.01 336.2 29.23 324.4L128 260.5V298.6L46.62 351.2C37.5 357.1 32 367.3 32 378.1V448C32 465.7 46.33 480 64 480H160V249.7C160 228.3 170.7 208.3 188.5 196.4L304 119.4V80H264C255.2 80 248 72.84 248 64C248 55.16 255.2 48 264 48H304V16C304 7.164 311.2 0 320 0C328.8 0 336 7.164 336 16V48zM448 249.7C448 238.1 442.7 228.1 433.8 223.1L320 147.2L206.2 223.1C197.3 228.1 192 238.1 192 249.7V480H256V384C256 348.7 284.7 320 320 320C355.3 320 384 348.7 384 384V480H448V249.7zM320 352C302.3 352 288 366.3 288 384V480H352V384C352 366.3 337.7 352 320 352z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9898, 9899, 11044, 61708, 61915, 9679], "f111", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-0": [512, 512, [], "e0ed", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C203.1 128 160 171.1 160 224v64c0 52.94 43.06 96 96 96s96-43.06 96-96V224C352 171.1 308.9 128 256 128zM320 288c0 35.28-28.72 64-64 64s-64-28.72-64-64V224c0-35.28 28.72-64 64-64s64 28.72 64 64V288z"],
    "circle-1": [512, 512, [], "e0ee", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM320 352h-48V144c0-5.906-3.25-11.31-8.453-14.09c-5.172-2.812-11.5-2.5-16.42 .7813l-48 32C191.8 167.6 189.8 177.5 194.7 184.9c4.875 7.344 14.8 9.312 22.19 4.438L240 173.9V352H192c-8.844 0-16 7.156-16 16S183.2 384 192 384h128c8.844 0 16-7.156 16-16S328.8 352 320 352z"],
    "circle-2": [512, 512, [], "e0ef", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 352H218.5l87.27-76.5c34.63-30.38 38.64-81.88 9.172-117.2c-14.66-17.56-35.28-28.22-58.08-30c-22.95-2-44.84 5.5-62.02 20.56L177.6 163.9C170.1 169.8 170.3 179.8 176.1 186.5C181.9 193.2 192 193.8 198.7 188l17.27-15.09C226.6 163.6 240.2 159.3 254.4 160.2c14.12 1.125 26.91 7.719 36 18.62c18.27 21.91 15.77 53.81-5.688 72.66l-119.3 104.5c-5.016 4.406-6.781 11.44-4.422 17.66C163.4 379.9 169.3 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352z"],
    "circle-3": [512, 512, [], "e0f0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM272 224H251.3l79.16-67.84c5.094-4.375 6.922-11.44 4.594-17.72C332.7 132.2 326.7 128 320 128H176C167.2 128 160 135.2 160 144S167.2 160 176 160h100.8L197.6 227.8C192.5 232.2 190.7 239.3 193 245.6C195.3 251.8 201.3 256 208 256h64C298.5 256 320 277.5 320 304S298.5 352 272 352H217.5c-11.97 0-22.55-7.625-26.33-19c-2.797-8.344-11.8-12.94-20.25-10.12c-8.375 2.812-12.91 11.88-10.12 20.25C168.1 367.6 191.8 384 217.5 384H272c44.11 0 80-35.88 80-80S316.1 224 272 224z"],
    "circle-4": [512, 512, [], "e0f1", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 288H320V208C320 199.2 312.8 192 304 192S288 199.2 288 208V288H183.6l55.23-138.1c3.281-8.188-.7187-17.5-8.922-20.78C221.8 125.9 212.4 129.8 209.1 138.1l-64 160C143.2 303 143.8 308.6 146.8 312.1C149.7 317.4 154.7 320 160 320h128v48c0 8.844 7.156 16 16 16s16-7.156 16-16V320h16c8.844 0 16-7.156 16-16S344.8 288 336 288z"],
    "circle-5": [512, 512, [], "e0f2", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM285.9 233.5L204 223.6L220.4 160H320c8.844 0 16-7.156 16-16S328.8 128 320 128H208C200.7 128 194.3 132.9 192.5 140l-24 93.31C167.4 237.8 168.2 242.6 170.8 246.4C173.4 250.2 177.5 252.7 182.1 253.2l99.86 12C303.6 268 320 286.6 320 308.4C320 332.5 300.5 352 276.4 352H218.4c-12.36 0-23.28-7.875-27.2-19.59C188.4 324 179.3 319.4 170.9 322.3c-8.391 2.812-12.91 11.88-10.11 20.25C169.1 367.3 192.2 384 218.4 384h58.06C318.1 384 352 350.1 352 308.4C352 270.5 323.6 238.3 285.9 233.5z"],
    "circle-6": [512, 512, [], "e0f3", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM265.4 192.1l48.19-36.14c7.062-5.312 8.5-15.34 3.219-22.41C313.7 130.2 308.8 128 304 128c-3.344 0-6.719 1.031-9.594 3.188L204.8 198.4C163.2 229.6 160 277.7 160 288c0 52.94 43.06 96 96 96s96-43.06 96-96C352 238.3 313.9 197.8 265.4 192.1zM256 352c-35.35 0-64-28.65-64-64c0-35.35 28.65-64 64-64s64 28.65 64 64C320 323.3 291.3 352 256 352z"],
    "circle-7": [512, 512, [], "e0f4", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM335.9 128h-160c-8.844 0-16 7.156-16 16s7.156 16 16 16h132.4l-114.3 200.1c-4.375 7.688-1.688 17.44 5.969 21.84C202.6 383.3 205.3 384 208 384c5.531 0 10.94-2.906 13.91-8.062l127.9-224c2.812-4.969 2.781-11.03-.0625-15.97C346.9 131 341.6 128 335.9 128z"],
    "circle-8": [512, 512, [], "e0f5", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM315.7 249.9C328.2 236.9 336 219.4 336 200C336 160.3 303.7 128 264 128h-16C208.3 128 176 160.3 176 200c0 19.37 7.781 36.91 20.28 49.87C174.7 262.3 160 285.4 160 312C160 351.7 192.3 384 232 384h48C319.7 384 352 351.7 352 312C352 285.4 337.3 262.3 315.7 249.9zM248 160h16c22.06 0 40 17.94 40 40S286.1 240 264 240h-16C225.9 240 208 222.1 208 200S225.9 160 248 160zM280 352h-48C209.9 352 192 334.1 192 312S209.9 272 232 272h48C302.1 272 320 289.9 320 312S302.1 352 280 352z"],
    "circle-9": [512, 512, [], "e0f6", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C203.1 128 160 171.1 160 224c0 49.72 38.12 90.24 86.6 95.05l-48.19 36.14c-7.062 5.312-8.5 15.34-3.219 22.41C198.3 381.8 203.2 384 208 384c3.344 0 6.719-1.031 9.594-3.188l89.59-67.22C348.8 282.4 352 234.3 352 224C352 171.1 308.9 128 256 128zM256 288C220.7 288 192 259.3 192 224c0-35.35 28.65-64 64-64s64 28.65 64 64C320 259.3 291.3 288 256 288z"],
    "circle-a": [512, 512, [], "e0f7", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM270.3 120.8c-5.438-10.84-23.19-10.84-28.62 0l-112 224c-3.953 7.906-.75 17.52 7.156 21.47c7.906 3.922 17.52 .75 21.47-7.156l19.89-39.79C179.3 319.6 180.2 320 181.3 320h149.3c1.107 0 2.078-.4141 3.123-.6289l19.89 39.79C356.5 364.8 362.1 368 368 368c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L270.3 120.8zM193.9 288L256 163.8L318.1 288H193.9z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM329.4 320.5l35.67-50.39c5.094-7.219 3.406-17.2-3.812-22.31c-7.188-5.062-17.16-3.375-22.31 3.812l-31.89 45.06l-50.36-53.7l27.19-21.91C296.7 211.1 304 196.2 304 180.3C304 151.4 279.9 128 250.4 128H229.6C200.1 128 176 151.4 176 180.3c0 15.3 5.875 29.91 16.47 41.05l17.25 18.41L167.1 273.4C152.7 285.2 144 302.9 144 321.9C144 356.1 172.7 384 207.9 384h36.28c25.28 0 48.88-12.06 63.16-32.28l3.217-4.545l29.81 31.78C343.5 382.3 347.8 384 352 384c3.938 0 7.844-1.438 10.94-4.328c6.469-6.047 6.781-16.17 .7187-22.62L329.4 320.5zM208 180.3C208 169.1 217.7 160 229.6 160h20.75C262.3 160 272 169.1 272 180.3c0 6.031-2.844 11.72-8 15.75L234.7 219.6l-19-20.25C210.8 194.1 208 187.3 208 180.3zM281.2 333.2C281.2 333.3 281.2 333.2 281.2 333.2C272.9 344.1 259.1 352 244.2 352H207.9C190.3 352 176 338.5 176 321.9c0-9.031 4.219-17.52 11.81-23.42L231.7 263.1l56.5 60.24L281.2 333.2z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M340.7 260.7L272 329.4V144C272 135.2 264.8 128 256 128S240 135.2 240 144v185.4L171.3 260.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96C247.8 382.4 251.9 384 256 384s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62S346.9 254.4 340.7 260.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M336 160c-4.094 0-8.188 1.562-11.31 4.688L192 297.4V208C192 199.2 184.8 192 176 192S160 199.2 160 208v127.6c0 8.812 7.141 15.97 15.95 16l128 .375C312.8 352 319.1 344.9 320 336c.0313-8.812-7.109-16-15.95-16.03L214.9 319.7l132.4-132.4c6.25-6.25 6.25-16.38 0-22.62C344.2 161.6 340.1 160 336 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M336 192C327.2 192 320 199.2 320 208v89.38L187.3 164.7C184.2 161.6 180.1 160 176 160S167.8 161.6 164.7 164.7c-6.25 6.25-6.25 16.38 0 22.62l132.4 132.4L207.1 320C199.1 320 191.1 327.2 192 336C192 344.9 199.2 352 208 352l128-.375C344.9 351.6 352 344.4 352 335.6V208C352 199.2 344.8 192 336 192zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M368 240H182.6l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-96 96C129.6 247.8 128 251.9 128 256s1.562 8.188 4.688 11.31l96 96c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L182.6 272H368C376.8 272 384 264.8 384 256S376.8 240 368 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M283.3 148.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 240H144C135.2 240 128 247.2 128 256s7.156 16 16 16h185.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l96-96C382.4 264.2 384 260.1 384 256s-1.562-8.188-4.688-11.31L283.3 148.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M267.3 132.7C264.2 129.6 260.1 128 256 128S247.8 129.6 244.7 132.7l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L240 182.6V368c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l68.69 68.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M214.9 192.3L304 192C312.9 191.1 320 184.8 320 175.1C319.1 167.1 312.8 160 304 160L175.1 160.4C167.1 160.4 160 167.6 160 176.4V304C160 312.8 167.2 320 176 320S192 312.8 192 304V214.6l132.7 132.7C327.8 350.4 331.9 352 336 352s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L214.9 192.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M336 160.4L208 160C199.2 160 192 167.1 192 175.1C191.1 184.8 199.1 191.1 207.1 192l89.15 .2734l-132.4 132.4c-6.25 6.25-6.25 16.38 0 22.62C167.8 350.4 171.9 352 176 352s8.188-1.562 11.31-4.688L320 214.6V304c0 8.844 7.156 16 16 16S352 312.8 352 304V176.4C352 167.6 344.9 160.4 336 160.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-b": [512, 512, [], "e0fd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM331.8 249.9C344.2 236.9 352 219.4 352 200C352 160.2 319.8 128 280 128H192C174.3 128 160 142.3 160 160v192c0 17.67 14.33 32 32 32h104c39.77 0 72-32.24 72-72C368 285.3 353.3 262.3 331.8 249.9zM192 160h88C302.1 160 320 177.9 320 200S302.1 240 280 240H192V160zM296 352H192V272h104c22.06 0 40 17.94 40 40S318.1 352 296 352z"],
    "circle-bolt": [512, 512, [], "e0fe", "M333.4 122.7L301.8 224H362.5C374.4 224 384 233.6 384 245.5C384 251.6 381.4 257.4 376.9 261.5L212 410.7C208.3 414.1 203.3 416 198.2 416C184.3 416 174.4 402.5 178.6 389.3L210.2 288H148.9C137.4 288 128 278.6 128 267.1C128 261.2 130.5 255.6 134.8 251.6L299.9 101.4C303.7 97.91 308.6 96 313.8 96C327.7 96 337.6 109.5 333.4 122.7H333.4zM232 256C237.1 256 241.9 258.4 244.9 262.5C247.9 266.6 248.8 271.9 247.3 276.8L221.6 358.9L335.3 256H280C274.9 256 270.1 253.6 267.1 249.5C264.1 245.4 263.2 240.1 264.7 235.2L290.3 153.4L177.5 256H232zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", "M383.5 156.8C360.2 148.2 337.7 144.3 317.5 144C288 144.5 266.5 152.8 256 157.9C245.4 152.8 223.9 144.5 194.4 144c-20.25 0-42.95 4.32-65.87 12.74C118.4 160.5 112 170.6 112 181.4v151.4c0 7.328 3.438 14.03 9.445 18.4c4.016 2.9 8.729 4.395 13.55 4.395c2.271 0 4.564-.332 6.82-1.004c15.36-4.695 29.74-6.674 42.76-6.674c23.09 0 41.91 6.217 54.43 14.53c5.121 3.398 11.09 5.1 17.05 5.1c5.947 0 11.89-1.688 17-5.064c12.57-8.305 31.47-14.51 54.56-14.51c12.99 0 27.31 1.963 42.58 6.621c2.258 .6797 4.549 1.014 6.814 1.014c4.814 0 9.518-1.51 13.56-4.42C396.6 346.8 400 340.1 400 332.8V181.4C400 170.6 393.6 160.5 383.5 156.8zM240 326.9C223.6 319.8 204.5 315.9 184.6 315.9c-13.34 0-26.98 1.662-40.57 4.92V185.2C161.7 179.2 178.9 176 193.9 175.1C215.9 176.3 231.6 181.9 240 185.8V326.9zM368 320.8c-13.58-3.24-27.12-4.877-40.38-4.877c-20.25 0-39.6 3.922-55.62 11.18v-141.3c8.352-3.83 23.85-9.365 45.51-9.793C333.8 176.3 351.2 179.5 368 185.2V320.8zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M320 128H192C174.3 128 160 142.4 160 160v208c0 6.156 3.531 11.75 9.062 14.42c5.562 2.672 12.09 1.891 16.94-1.922L256 324.5l69.1 56.02C328.9 382.8 332.4 384 336 384c2.344 0 4.719-.5156 6.938-1.578C348.5 379.8 352 374.2 352 368V160C352 142.4 337.7 128 320 128zM320 334.7L265.1 291.5C263.1 289.2 259.5 288 256 288S248.9 289.2 245.1 291.5L192 334.7V160h128V334.7zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-c": [512, 512, [], "e101", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM324.7 188.1c6.281 6.25 16.42 6.203 22.64-.0469c6.234-6.266 6.203-16.41-.0469-22.64C297.2 115.6 215.7 115.6 165.6 165.5C141.4 189.6 128 221.8 128 256s13.33 66.36 37.59 90.55c25.05 24.92 57.94 37.39 90.83 37.39s65.78-12.47 90.83-37.39c6.25-6.234 6.281-16.38 .0469-22.64c-6.25-6.234-16.39-6.312-22.64-.0469c-37.63 37.47-98.84 37.45-136.5 .0156C170 305.7 160 281.6 160 256s10.02-49.73 28.23-67.86C225.9 150.7 287.1 150.7 324.7 188.1z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M208 96C216.8 96 224 103.2 224 112V128H288V112C288 103.2 295.2 96 304 96C312.8 96 320 103.2 320 112V128H336C362.5 128 384 149.5 384 176V336C384 362.5 362.5 384 336 384H176C149.5 384 128 362.5 128 336V176C128 149.5 149.5 128 176 128H192V112C192 103.2 199.2 96 208 96zM160 192H352V176C352 167.2 344.8 160 336 160H176C167.2 160 160 167.2 160 176V192zM160 224V336C160 344.8 167.2 352 176 352H336C344.8 352 352 344.8 352 336V224H160zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 224C238.3 224 224 238.3 224 256s14.33 32 32 32s32-14.33 32-32S273.7 224 256 224zM336 160h-20l-6.188-16.44C306.3 134.2 297.4 128 287.4 128H224.6c-10 0-19 6.188-22.5 15.56L196 160H176C149.5 160 128 181.5 128 208v96C128 330.5 149.5 352 176 352h160c26.51 0 48-21.49 48-48v-96C384 181.5 362.5 160 336 160zM352 304c0 8.822-7.178 16-16 16h-160C167.2 320 160 312.8 160 304v-96C160 199.2 167.2 192 176 192h42.22l11.93-32h51.66l12.04 32H336C344.8 192 352 199.2 352 208V304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M352 192H160C131.6 192 117.3 226.5 137.4 246.6l95.95 96c12.49 12.5 32.86 12.5 45.35 0l95.95-96C394.6 226.5 380.5 192 352 192zM256 320L160 224h192L256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M265.4 137.4l-96 95.95c-12.5 12.49-12.5 32.86 0 45.35l96 95.95C285.5 394.6 320 380.5 320 352V160C320 131.6 285.5 117.3 265.4 137.4zM288 352L192 256l96-96V352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M246.6 137.4C226.5 117.4 192 131.5 192 159.1V352c0 28.36 34.5 42.73 54.63 22.61l96-95.95c12.5-12.49 12.5-32.86 0-45.35L246.6 137.4zM224 352V160l96 96L224 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M278.7 169.4c-12.49-12.5-32.86-12.5-45.35 0l-95.95 96C117.4 285.5 131.5 320 159.1 320h192c28.36 0 42.73-34.5 22.61-54.63L278.7 169.4zM160 288l96-96l96 96H160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M235.3 331.3C229.1 337.6 218.9 337.6 212.7 331.3L148.7 267.3C142.4 261.1 142.4 250.9 148.7 244.7C154.9 238.4 165.1 238.4 171.3 244.7L224 297.4L340.7 180.7C346.9 174.4 357.1 174.4 363.3 180.7C369.6 186.9 369.6 197.1 363.3 203.3L235.3 331.3zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M356.7 212.7L256 313.4L155.3 212.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l112 112C247.8 350.4 251.9 352 256 352s8.188-1.562 11.31-4.688l112-112c6.25-6.25 6.25-16.38 0-22.62S362.9 206.4 356.7 212.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-left": [512, 512, ["chevron-circle-left"], "f137", "M299.3 132.7c-6.25-6.25-16.38-6.25-22.62 0l-112 112C161.6 247.8 160 251.9 160 256s1.562 8.188 4.688 11.31l112 112c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L198.6 256l100.7-100.7C305.6 149.1 305.6 138.9 299.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M235.3 132.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L313.4 256l-100.7 100.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l112-112C350.4 264.2 352 260.1 352 256s-1.562-8.188-4.688-11.31L235.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM267.3 164.7C264.2 161.6 260.1 160 256 160S247.8 161.6 244.7 164.7l-112 112c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L256 198.6l100.7 100.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 164.7z"],
    "circle-d": [512, 512, [], "e104", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128H176C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384H256c70.58 0 128-57.42 128-128S326.6 128 256 128zM256 352H192V160h64c52.94 0 96 43.06 96 96S308.9 352 256 352z"],
    "circle-dashed": [512, 512, [], "e105", "M18.79 232C9.302 232 1.826 223.8 3.353 214.5C9.834 174.7 25.46 138.1 47.1 106.7C53.53 99.03 64.6 98.54 71.31 105.3C77.13 111.1 77.57 120.3 72.83 127C54.11 153.6 41.02 184.4 35.27 217.7C33.87 225.8 27.02 232 18.79 232V232zM127 72.83C120.3 77.57 111.1 77.13 105.3 71.31C98.54 64.6 99.03 53.53 106.7 47.99C138.1 25.46 174.7 9.834 214.5 3.353C223.8 1.826 232 9.302 232 18.79C232 27.02 225.8 33.87 217.7 35.27C184.4 41.01 153.6 54.11 127 72.83H127zM280 493.2C280 484.1 286.2 478.1 294.3 476.7C327.6 470.1 358.4 457.9 384.1 439.2C391.7 434.4 400.9 434.9 406.8 440.7C413.5 447.4 412.1 458.5 405.3 464C373.9 486.5 337.3 502.2 297.5 508.6C288.2 510.2 280 502.7 280 493.2V493.2zM476.7 294.3C478.1 286.2 484.1 280 493.2 280C502.7 280 510.2 288.2 508.6 297.5C502.2 337.3 486.5 373.9 464 405.3C458.5 412.1 447.4 413.5 440.7 406.8C434.9 400.9 434.4 391.7 439.2 384.1C457.9 358.4 470.1 327.6 476.7 294.3V294.3zM127 439.2C153.6 457.9 184.4 470.1 217.7 476.7C225.8 478.1 232 484.1 232 493.2C232 502.7 223.8 510.2 214.5 508.6C174.7 502.2 138.1 486.5 106.7 464C99.03 458.5 98.54 447.4 105.3 440.7C111.1 434.9 120.3 434.4 127 439.2V439.2zM3.353 297.5C1.826 288.2 9.302 280 18.79 280C27.02 280 33.87 286.2 35.27 294.3C41.01 327.6 54.11 358.4 72.83 384.1C77.57 391.7 77.13 400.9 71.31 406.8C64.6 413.5 53.53 412.1 47.99 405.3C25.46 373.9 9.834 337.3 3.353 297.5V297.5zM384.1 72.83C358.4 54.11 327.6 41.01 294.3 35.27C286.2 33.87 280 27.02 280 18.79C280 9.302 288.2 1.826 297.5 3.353C337.3 9.834 373.9 25.46 405.3 47.99C412.1 53.53 413.5 64.6 406.8 71.31C400.9 77.13 391.7 77.57 384.1 72.83V72.83zM439.2 127C434.4 120.3 434.9 111.1 440.7 105.3C447.4 98.54 458.5 99.03 464 106.7C486.5 138.1 502.2 174.7 508.6 214.5C510.2 223.8 502.7 232 493.2 232C484.1 232 478.1 225.8 476.7 217.7C470.1 184.4 457.9 153.6 439.2 127H439.2z"],
    "circle-divide": [512, 512, [], "e106", "M232 160C232 146.7 242.7 136 256 136C269.3 136 280 146.7 280 160C280 173.3 269.3 184 256 184C242.7 184 232 173.3 232 160zM352 240C360.8 240 368 247.2 368 256C368 264.8 360.8 272 352 272H160C151.2 272 144 264.8 144 256C144 247.2 151.2 240 160 240H352zM280 352C280 365.3 269.3 376 256 376C242.7 376 232 365.3 232 352C232 338.7 242.7 328 256 328C269.3 328 280 338.7 280 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M272 143C285.5 144 298.6 147.7 311.6 151.3C313.2 151.7 314.7 152.1 316.2 152.6C324.8 154.9 329.8 163.8 327.4 172.3C325.1 180.8 316.2 185.8 307.7 183.4C305.3 182.8 302.9 182.1 300.5 181.4C292.1 179.2 285.4 176.1 277.7 175.8C258.5 173 241 175.5 228.4 180.9C215.5 186.5 209.8 194 208.6 200.4C206.8 210.1 210.7 216.9 218.8 222.1C229.5 228.9 245.3 233.4 264.7 238.9L264.9 238.1C282.7 244 303.8 250 319.3 260.6C338.3 273.7 347 294.5 342.9 317.2C338.9 338.8 323.9 353.2 305 360.8C295.1 364.8 283.9 367.1 272 367.8L272 392C272 400.8 264.8 408 256 408C247.2 408 240 400.8 240 392L240 366.1C231.9 364.9 218.2 360.9 207.6 357.7C200.7 355.6 193.8 353.4 186.1 351.2C178.6 348.4 174 339.4 176.8 330.1C179.6 322.6 188.6 318 197 320.8C203.6 322.1 210.3 325.1 216.9 327.1C228.2 330.5 239.6 333.7 245 334.5C264.8 337.5 281.5 335.8 293.1 331.2C304.2 326.7 309.8 319.9 311.4 311.4C313.3 300.9 309.9 293 301.2 287C289.2 278.8 274.4 274.8 260.2 270.9C257.9 270.2 255.6 269.6 253.3 268.1C236.2 264.1 216.3 258.5 201.6 249C193.5 243.9 185.9 236.9 181.1 227.4C176.2 217.6 174.9 206.6 177.1 194.6C180.9 173.9 197.2 159.5 215.7 151.5C223.2 148.3 231.3 145.9 239.1 144.5V120C239.1 111.2 247.2 104 255.1 104C264.8 104 272 111.2 272 120V143zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M272 121.6C277.9 122.6 290.1 125.2 296.1 126.5C304.7 128.8 309.7 137.6 307.5 146.1C305.2 154.7 296.4 159.7 287.9 157.5C283.9 156.4 270.2 153.7 265.8 153C252.9 151 242.1 152.6 234.9 155.9C227.7 159.2 224.1 163.4 224.4 166.1C223.7 171.1 224.3 173.2 224.9 174.4C225.5 175.8 226.8 177.5 229.8 179.5C236.6 184.1 246.9 187.3 260.8 191.5L261.4 191.7C273.7 195.4 289.3 200.1 300.9 208.5C307.1 213.1 312.9 219.1 316.5 227.3C320.1 235.6 320.8 244.8 319.2 254.5C316.1 271.1 304.6 283.9 289.9 290.2C284.3 292.6 278.3 294.2 272 295.1V304C272 312.8 264.8 320 256 320C247.2 320 240 312.8 240 304V294.4C230.6 292.6 216.4 287.8 207.6 284.7C205.8 284.1 204.2 283.6 202.9 283.2C194.6 280.4 190 271.3 192.8 262.9C195.6 254.6 204.7 250 213.1 252.8C214.1 253.5 217.1 254.2 219.2 254.9C228.7 258.1 239.9 261.9 246.3 262.1C259.6 265.1 270.3 263.8 277.3 260.8C283.8 258 286.7 254.1 287.6 249C288.4 244.4 287.8 241.7 287.1 240.1C286.4 238.4 284.9 236.5 282 234.4C275.5 229.6 265.3 226.3 251.6 222.1L249.5 221.5C237.7 217.9 222.9 213.5 211.9 206C205.6 201.8 199.7 196 195.9 188.1C192.1 180 191.2 171 192.8 161.5C195.7 144.8 207.6 133.2 221.7 126.8C227.3 124.2 233.5 122.4 240 121.3V112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112L272 121.6zM48 208C48 93.12 141.1 0 256 0C370.9 0 464 93.12 464 208C464 322.9 370.9 416 256 416C141.1 416 48 322.9 48 208zM256 384C353.2 384 432 305.2 432 208C432 110.8 353.2 32 256 32C158.8 32 80 110.8 80 208C80 305.2 158.8 384 256 384zM92.83 384H56C42.75 384 32 394.7 32 408V456C32 469.3 42.75 480 56 480H456C469.3 480 480 469.3 480 456V408C480 394.7 469.3 384 456 384H419.2C429.7 374.2 439.4 363.5 448 352H456C486.9 352 512 377.1 512 408V456C512 486.9 486.9 512 456 512H56C25.07 512 0 486.9 0 456V408C0 377.1 25.07 352 56 352H63.98C72.63 363.5 82.29 374.2 92.83 384z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M352 256C352 309 309 352 256 352C202.1 352 160 309 160 256C160 202.1 202.1 160 256 160C309 160 352 202.1 352 256zM256 192C220.7 192 192 220.7 192 256C192 291.3 220.7 320 256 320C291.3 320 320 291.3 320 256C320 220.7 291.3 192 256 192zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M348.7 224H320V152c0-22.06-17.94-40-40-40h-48C209.9 112 192 129.9 192 152V224H163.3C147.1 224 132.6 233.7 126.3 248.7c-6.188 14.95-2.812 32 8.562 43.48l92.81 96.11c15.12 15.12 41.25 15.33 56.75-.2031l92.5-95.8c11.47-11.48 14.88-28.59 8.688-43.59C379.4 233.7 364.9 224 348.7 224zM354.2 269.9l-92.5 95.8c-4.162 4.203-9.533 1.797-11.12 .2031l-92.69-96C152.1 265 155.9 256 163.3 256H224L223.1 152c0-4.406 3.594-8 8.001-8h48c4.406 0 7.999 3.594 7.999 8L288 256h60.69C355.1 256 359.9 264 354.2 269.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-down-left": [512, 512, [], "e107", "M340.9 137.2c-15.6-15.6-40.97-15.6-56.57 0L233.4 188.1L213.1 167.8C201.6 156.3 184.5 152.9 169.5 159.1C154.5 165.4 144.8 179.9 144.8 196.1l-2.33 133.1c-.0215 21.94 18.59 40.27 39.98 40.27l133.6-2.332c16.16-.0781 30.6-9.742 36.8-24.7c6.209-15 2.807-32.11-8.684-43.59l-20.29-20.29l50.91-50.91c15.6-15.6 15.6-40.96 0-56.57L340.9 137.2zM352.2 205.1l-73.54 73.54l42.91 42.91c5.258 5.258 1.205 13.66-5.656 13.66l-133.7 2.352c-2.254 .0039-7.754-2.094-7.725-8.008l2.332-133.1c.0176-8.199 9.131-10.47 13.67-5.93l42.91 42.91l73.54-73.54c3.115-3.113 8.197-3.115 11.31-.002l33.94 33.94C355.3 196.9 355.3 201.1 352.2 205.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-down-right": [512, 512, [], "e108", "M342.5 159.1c-15-6.211-32.11-2.805-43.6 8.684l-20.29 20.29L227.7 137.2c-15.6-15.6-40.97-15.6-56.57 0l-33.94 33.95c-15.6 15.6-15.6 40.97 0 56.57l50.91 50.91L167.8 298.9c-11.49 11.49-14.89 28.59-8.684 43.59c6.199 14.95 20.64 24.62 36.8 24.7l133.6 2.332c21.39 0 40.01-18.33 39.98-40.27l-2.33-133.1C367.2 179.9 357.5 165.4 342.5 159.1zM329.8 337.5l-133.4-2.34c-6.861 0-11.19-8.41-5.932-13.67l42.91-42.91L159.8 205.1c-3.115-3.113-3.115-8.197 0-11.31L193.8 159.8c3.115-3.113 8.197-3.111 11.31 .002l73.54 73.54l42.91-42.91c4.537-4.539 13.65-2.27 13.67 5.93l2.332 133.1C337.6 335.5 332.1 337.6 329.8 337.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-e": [512, 512, [], "e109", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 160C344.8 160 352 152.8 352 144S344.8 128 336 128h-160C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352H192V272h96c8.844 0 16-7.156 16-16S296.8 240 288 240H192V160H336z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 232C269.3 232 280 242.7 280 256C280 269.3 269.3 280 256 280C242.7 280 232 269.3 232 256C232 242.7 242.7 232 256 232zM352 280C338.7 280 328 269.3 328 256C328 242.7 338.7 232 352 232C365.3 232 376 242.7 376 256C376 269.3 365.3 280 352 280zM160 232C173.3 232 184 242.7 184 256C184 269.3 173.3 280 160 280C146.7 280 136 269.3 136 256C136 242.7 146.7 232 160 232zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M232 256C232 242.7 242.7 232 256 232C269.3 232 280 242.7 280 256C280 269.3 269.3 280 256 280C242.7 280 232 269.3 232 256zM280 160C280 173.3 269.3 184 256 184C242.7 184 232 173.3 232 160C232 146.7 242.7 136 256 136C269.3 136 280 146.7 280 160zM232 352C232 338.7 242.7 328 256 328C269.3 328 280 338.7 280 352C280 365.3 269.3 376 256 376C242.7 376 232 365.3 232 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M352 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V192C384 174.3 369.7 160 352 160zM352 320H160V245.3l89.3 41.21C251.4 287.5 253.7 288 256 288s4.578-.5 6.703-1.469L352 245.3V320zM352 210.1l-96 44.31L160 210.1V192h192V210.1zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 304c8.844 0 16-7.156 16-16V128c0-8.844-7.156-16-16-16S240 119.2 240 128v160C240 296.8 247.2 304 256 304zM256 344c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S269.3 344 256 344z"],
    "circle-exclamation-check": [640, 512, [], "e10d", "M256 480C322.3 480 381.9 451.2 422.1 405.3C428.9 398.7 438.1 398.2 445.6 404.1C452.1 409.1 452.7 420.1 446.8 426.7C399.1 479 331.8 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C364.9 0 457.1 68.05 494.9 163.9C498.1 172.1 494 181.4 485.8 184.6C477.5 187.8 468.3 183.7 465.1 175.4C432.7 91.49 351.3 32 255.1 32C132.3 32 31.1 132.3 31.1 256C31.1 379.7 132.3 480 255.1 480L256 480zM272 272C272 280.8 264.8 288 256 288C247.2 288 240 280.8 240 272V144C240 135.2 247.2 128 256 128C264.8 128 272 135.2 272 144V272zM232 352C232 338.7 242.7 328 256 328C269.3 328 280 338.7 280 352C280 365.3 269.3 376 256 376C242.7 376 232 365.3 232 352zM619.3 180.7C625.6 186.9 625.6 197.1 619.3 203.3L491.3 331.3C485.1 337.6 474.9 337.6 468.7 331.3L404.7 267.3C398.4 261.1 398.4 250.9 404.7 244.7C410.9 238.4 421.1 238.4 427.3 244.7L480 297.4L596.7 180.7C602.9 174.4 613.1 174.4 619.3 180.7H619.3z"],
    "circle-f": [512, 512, [], "e10e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 128h-160C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V288h112C312.8 288 320 280.8 320 272S312.8 256 304 256H192V160h144C344.8 160 352 152.8 352 144S344.8 128 336 128z"],
    "circle-g": [512, 512, [], "e10f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 256h-74.66c-8.844 0-16 7.156-16 16s7.156 16 16 16h53.59c-5.344 13.41-13.59 26.42-23.06 35.89c-36.25 36.25-99.5 36.25-135.8 0C169.1 305.8 160 281.6 160 256s9.1-49.75 28.12-67.89c36-36.05 94-37.64 131.8-3.672c6.594 5.891 16.72 5.375 22.59-1.25c5.906-6.578 5.344-16.69-1.219-22.59c-50.59-45.3-127.8-43.13-175.8 4.891c-49.91 49.91-49.91 131.1 0 181C189.7 370.7 221.8 384 256 384s66.34-13.31 90.5-37.48c18.28-18.28 32.56-45.39 37.25-70.78C383.9 274.8 384 272.1 384 272C384 263.2 376.8 256 368 256z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 128C327.2 128 320 135.2 320 144v96H192v-96C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368v-96h128v96c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C352 135.2 344.8 128 336 128z"],
    "circle-half": [512, 512, [], "e110", "M224.1 1.971C241.6-.2109 256 14.33 256 31.1V480C256 497.7 241.6 512.2 224.1 510C97.75 494.3 0 386.6 0 255.1C0 125.4 97.75 17.69 224.1 1.971V1.971zM224 34.26C115.5 49.77 32 143.2 32 255.1C32 368.8 115.5 462.2 224 477.7V34.26z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM240 479.4V32.56C123.8 40.77 32 137.7 32 256C32 374.3 123.8 471.2 240 479.4zM272 32.56V479.4C388.2 471.2 480 374.3 480 256C480 137.7 388.2 40.77 272 32.56V32.56z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 191L273.7 173C275.3 171.4 276.1 169.9 278.7 168.4C308.2 143.3 352.3 144.8 380.1 173C409.5 202.8 409.5 251.2 380.1 280.1L289.7 372.8C280.3 382.3 268.1 387 255.9 386.1C243.7 386.9 231.6 382.2 222.3 372.8L131.9 280.1C102.5 251.2 102.5 202.8 131.9 173C159.7 144.8 203.8 143.3 233.3 168.4C235 169.9 236.7 171.4 238.3 173L256 191zM266.9 350.3L357.3 258.5C374.4 241.2 374.4 212.8 357.3 195.5C340.5 178.4 313.4 178.4 296.5 195.5L256 236.6L215.5 195.5C198.6 178.4 171.5 178.4 154.7 195.5C137.6 212.8 137.6 241.2 154.7 258.5L245.1 350.3C248.2 353.5 252.1 354.1 255.1 354.1C259.9 354.1 263.8 353.5 266.9 350.3V350.3zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-i": [512, 512, [], "e111", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 144C352 135.2 344.8 128 336 128h-160C167.2 128 160 135.2 160 144S167.2 160 176 160h64.88C240.5 161.4 240 162.8 240 164.4v183.3C240 349.2 240.5 350.6 240.9 352H176C167.2 352 160 359.2 160 368S167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352h-64.88C271.5 350.6 272 349.2 272 347.6V164.4C272 162.8 271.5 161.4 271.1 160H336C344.8 160 352 152.8 352 144z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 184c13.25 0 24-10.74 24-24c0-13.25-10.75-24-24-24S232 146.7 232 160C232 173.3 242.7 184 256 184zM304 352h-32V240C272 231.2 264.8 224 256 224H224C215.2 224 208 231.2 208 240S215.2 256 224 256h16v96h-32C199.2 352 192 359.2 192 368C192 376.8 199.2 384 208 384h96c8.836 0 16-7.164 16-16C320 359.2 312.8 352 304 352z"],
    "circle-j": [512, 512, [], "e112", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM320 128c-8.844 0-16 7.156-16 16v149.3C304 325.7 275.3 352 240 352s-64-26.31-64-58.67V272C176 263.2 168.8 256 160 256S144 263.2 144 272v21.33C144 343.3 187.1 384 240 384s96-40.67 96-90.67V144C336 135.2 328.8 128 320 128z"],
    "circle-k": [512, 512, [], "e113", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM347.9 133.3c-5.922-6.609-16.05-7.094-22.59-1.188L192 252.1V144C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V295.1l41.4-37.26l89.8 119.7C326.3 381.8 331.1 384 336 384c3.344 0 6.703-1.047 9.578-3.203c7.078-5.297 8.516-15.33 3.203-22.39L257.3 236.4l89.43-80.49C353.3 149.1 353.8 139.9 347.9 133.3z"],
    "circle-l": [512, 512, [], "e114", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 352H192V144C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M360 192H288V163.3c0-16.25-9.688-30.75-24.69-36.97c-14.95-6.188-32-2.812-43.48 8.562l-96.11 92.81C108.6 242.8 108.4 268.1 123.9 284.5l95.8 92.5c11.48 11.47 28.59 14.88 43.59 8.688C278.3 379.4 288 364.9 288 348.7V320h72c22.06 0 40-17.94 40-40v-48C400 209.9 382.1 192 360 192zM368 280C368 284.4 364.4 288 360 288H256v60.69c0 6.414-8.047 11.26-13.86 5.471l-95.8-92.5c-4.205-4.164-1.797-9.531-.2031-11.12l96-92.69C246.1 152.1 256 155.9 256 163.3V224h104c4.406 0 8 3.594 8 8V280zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", "M127.7 283C116 283 105.8 274.7 103.5 263.2C101.1 251.8 107.2 240.1 117.1 235.5L338.5 141C348 137.1 358.7 139.1 365.8 146.3C372.9 153.4 375 164.1 371 173.5L276.5 394C272.6 403.1 263.6 409 253.7 409C252.1 409 250.5 408.9 248.8 408.5C237.3 406.2 229 395.1 229 384.2V283H127.7zM260.1 251V348.1L334.5 177.6L163.1 251H260.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-m": [512, 512, [], "e115", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM372.8 128.7c-6.609-2.047-13.91 .3594-17.92 6.094L256 276.1L157.1 134.8C153.1 129.1 145.8 126.6 139.2 128.7C132.5 130.8 128 137 128 144v224C128 376.8 135.2 384 144 384S160 376.8 160 368V194.8l82.89 118.4c6 8.562 20.22 8.562 26.22 0L352 194.8V368c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C384 137 379.5 130.8 372.8 128.7z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 320c35.35 0 64-28.65 64-64V160c0-35.35-28.65-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM224 160c0-17.64 14.36-32 32-32s32 14.36 32 32v96c0 17.64-14.36 32-32 32S224 273.6 224 256V160zM368 224C359.2 224 352 231.2 352 239.1V256c0 52.94-43.06 96-96 96S160 308.9 160 256L159.1 240c0-8.844-7.156-16-16-16S128 231.2 128 239.1V256c0 65.1 49.03 118.4 112 126.4V400c0 8.844 7.156 16 16 16s16-7.156 16-16v-17.62C334.1 374.4 384 321.1 384 256V239.1C384 231.2 376.8 224 368 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M256 320c35.35 0 64-28.65 64-64V160c0-35.35-28.65-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM224 160c0-17.64 14.36-32 32-32s32 14.36 32 32h-16C263.2 160 256 167.2 256 176S263.2 192 272 192H288v32h-16C263.2 224 256 231.2 256 240S263.2 256 272 256H288c0 17.64-14.36 32-32 32S224 273.6 224 256V160zM368 224C359.2 224 352 231.2 352 239.1V256c0 52.94-43.06 96-96 96S160 308.9 160 256V240C160 231.2 152.8 224 144 224S128 231.2 128 239.1V256c0 65.1 49.03 118.4 112 126.4V400c0 8.844 7.156 16 16 16s16-7.156 16-16v-17.62C334.1 374.4 384 321.1 384 256V239.1C384 231.2 376.8 224 368 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M352 240C360.8 240 368 247.2 368 256C368 264.8 360.8 272 352 272H160C151.2 272 144 264.8 144 256C144 247.2 151.2 240 160 240H352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-n": [512, 512, [], "e118", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 128c-8.844 0-16 7.156-16 16v180.8L172.1 133.6C167.8 128.5 160.7 126.6 154.5 129C148.2 131.3 144 137.3 144 144v224C144 376.8 151.2 384 160 384s16-7.156 16-16V187.3l163.9 191.2C342.1 382 347.4 384 352 384c1.859 0 3.734-.3281 5.547-1C363.8 380.7 368 374.7 368 368v-224C368 135.2 360.8 128 352 128z"],
    "circle-nodes": [512, 512, [], "e4e2", "M365.8 357.7C395.2 369.5 416 398.3 416 432C416 476.2 380.2 512 336 512C291.8 512 256 476.2 256 432C256 417.6 259.8 404.1 266.5 392.4L128.5 271.7C115 281.9 98.22 288 80 288C35.82 288 0 252.2 0 208C0 163.8 35.82 128 80 128C107.9 128 132.5 142.3 146.8 164L321.3 94.26C320.4 89.63 320 84.87 320 80C320 35.82 355.8 0 400 0C444.2 0 480 35.82 480 80C480 123.6 445.1 159.1 401.7 159.1L365.8 357.7zM376.2 121.7C383.2 125.7 391.3 127.1 400 127.1C402.6 127.1 405.2 127.8 407.6 127.4C430.5 123.7 448 103.9 448 80C448 53.49 426.5 32 400 32C373.5 32 352 53.49 352 80C352 80.65 352 81.3 352 81.95C352.5 93.32 356.9 103.7 363.9 111.7C367.4 115.6 371.5 119 376.2 121.7V121.7zM370.2 154.3C354.1 148.2 342.1 137.5 333.2 123.1L158.7 193.7C159.6 198.4 160 203.1 160 208C160 222.4 156.2 235.9 149.5 247.6L287.5 368.3C300.6 358.4 316.7 352.4 334.3 352L370.2 154.3zM121.7 231.8C125.7 224.8 128 216.7 128 208C128 181.5 106.5 160 80 160C53.49 160 32 181.5 32 208C32 234.5 53.49 256 80 256C88.55 256 96.58 253.8 103.5 249.8C110.1 246.2 115.6 241 119.8 234.8C120.5 233.8 121.1 232.8 121.7 231.8L121.7 231.8zM291.4 414.2C289.2 419.7 288 425.7 288 432C288 458.5 309.5 480 336 480C362.5 480 384 458.5 384 432C384 405.5 362.5 384 336 384C321.9 384 309.3 390.1 300.5 399.7C297.4 403.1 294.8 406.1 292.7 411.2C292.3 412.2 291.8 413.2 291.4 414.2L291.4 414.2z"],
    "circle-notch": [512, 512, [], "f1ce", "M207.4 20.36C209.8 28.88 204.8 37.69 196.3 40.04C101.5 66.19 32 152.1 32 255.1C32 379.7 132.3 479.1 256 479.1C379.7 479.1 480 379.7 480 255.1C480 152.1 410.5 66.19 315.7 40.04C307.2 37.69 302.2 28.88 304.6 20.36C306.9 11.85 315.7 6.847 324.3 9.198C432.5 39.07 512 138.2 512 255.1C512 397.4 397.4 511.1 256 511.1C114.6 511.1 0 397.4 0 255.1C0 138.2 79.51 39.07 187.7 9.198C196.3 6.847 205.1 11.85 207.4 20.36V20.36z"],
    "circle-o": [512, 512, [], "e119", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C185.4 128 128 185.4 128 256s57.42 128 128 128s128-57.42 128-128S326.6 128 256 128zM256 352c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96S308.9 352 256 352z"],
    "circle-p": [512, 512, [], "e11a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM272 128h-96C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V320h80c52.94 0 96-43.06 96-96S324.9 128 272 128zM272 288H192V160h80c35.28 0 64 28.7 64 64S307.3 288 272 288z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M288 320H208V368C208 376.8 200.8 384 192 384C183.2 384 176 376.8 176 368V152C176 138.7 186.7 128 200 128H288C341 128 384 170.1 384 224C384 277 341 320 288 320zM288 288C323.3 288 352 259.3 352 224C352 188.7 323.3 160 288 160H208V288H288zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M208 160C199.2 160 192 167.2 192 176v160C192 344.8 199.2 352 208 352S224 344.8 224 336v-160C224 167.2 216.8 160 208 160zM304 160C295.2 160 288 167.2 288 176v160c0 8.844 7.156 16 16 16s16-7.156 16-16v-160C320 167.2 312.8 160 304 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M369.5 276.3C369.5 276.3 369.5 276.3 369.5 276.3l-47.91-20.53c-15.17-6.328-32.97-1.859-43.25 10.75l-6.719 8.188C258.1 265.5 246.5 253.9 237.4 240.4l8.266-6.781c12.86-10.62 17.11-28.06 10.55-43.41L235.7 142.5c-7.141-16.52-25.06-25.5-42.58-21.52L148.9 131.2C131.9 135.1 120 149.1 120 167.5C120 291.3 220.7 392 344.5 392c17.45 0 32.39-11.88 36.31-28.88l10.2-44.28C395.1 301.3 385.1 283.5 369.5 276.3zM349.7 355.9C349.1 358.4 347 360 344.5 360C238.4 360 152 273.6 152 167.5c0-2.469 1.625-4.5 4.094-5.062l44.25-10.27C200.7 152 201.1 152 201.5 152c2.062 0 4.016 1.234 4.844 3.125l20.44 47.7c.9531 2.234 .3906 4.594-1.453 6.109L206.3 224.5C200.4 229.4 198.7 237.8 202.4 244.5c15 27.58 37.53 50.09 65.13 65.13c6.781 3.688 15.17 2 20.03-3.906l15.58-19.02c1.406-1.734 3.984-2.328 6.016-1.516l47.66 20.44c2.328 1.031 3.609 3.562 3.047 6L349.7 355.9zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M363.1 131.2l-44.19-10.25c-17.52-3.984-35.44 5-42.58 21.52L255.8 190.3c-6.562 15.34-2.312 32.78 10.55 43.41l8.266 6.781C265.5 253.9 253.9 265.5 240.4 274.7L233.7 266.5C223.4 253.9 205.6 249.4 190.4 255.8L142.5 276.3c-.0156 .0156 .0313-.0156 0 0c-16.47 7.172-25.55 25.06-21.54 42.56l10.2 44.28C135.1 380.1 150 392 167.5 392C291.3 392 392 291.3 392 167.5C392 149.1 380.1 135.1 363.1 131.2zM167.5 360c-2.5 0-4.562-1.625-5.125-4.062L152.1 311.7c-.5625-2.438 .7187-4.969 3.047-6l47.66-20.44C204.9 284.4 207.5 285 208.9 286.7l15.58 19.02c4.859 5.906 13.25 7.594 20.03 3.906c27.59-15.03 50.13-37.55 65.13-65.13c3.672-6.75 2.031-15.16-3.906-20.03l-18.98-15.56c-1.844-1.516-2.406-3.875-1.453-6.109l20.44-47.7C306.5 153.2 308.5 152 310.5 152c.375 0 .75 .0469 1.125 .1406l44.25 10.27C358.4 162.1 360 165 360 167.5C360 273.6 273.6 360 167.5 360zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone-hangup": [512, 512, ["phone-circle-down"], "e11d", "M414.8 225.7c-87.55-87.55-229.1-87.55-317.5 0C84.89 238 82.73 256.1 91.97 271.8l24.1 38.53c9.535 15.21 28.61 21.44 45.33 14.87c.0332-.0137-.0234 0 0 0l48.4-19.36C224.1 299.5 234.4 283.8 232.8 267.6L231.7 257.1c16.03-3.039 32.43-3.039 48.45-.0137l-1.051 10.64c-1.578 16.61 7.746 31.94 23.24 38.15l48.26 19.31c16.73 6.631 35.75 .3125 45.32-14.89l23.1-38.49C429.3 256.1 427.1 238 414.8 225.7zM392.8 254.8l-24.03 38.55c-.1992 .3301-.4316 .6309-.6973 .8926c-1.457 1.459-3.711 1.969-5.635 1.219l-48.18-19.28c-2.254-.9062-3.525-2.971-3.293-5.35l2.42-24.43c.752-7.646-4.033-14.75-11.4-16.93c-30.11-8.893-61.96-8.881-92.1 0C202.5 231.6 197.8 238.8 198.5 246.4l2.43 24.46c.2324 2.221-1.17 4.465-3.182 5.324L149.6 295.4C147.2 296.3 144.5 295.4 143.2 293.3L119.1 254.8C117.8 252.7 118.1 250.1 119.9 248.3c75.06-75.06 197.2-75.06 272.3 0C393.9 250 394.2 252.6 392.8 254.8zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M356.5 235.5C363.6 239.9 368 247.6 368 256C368 264.4 363.6 272.1 356.5 276.5L212.5 364.5C205.1 369 195.8 369.2 188.3 364.9C180.7 360.7 176 352.7 176 344V167.1C176 159.3 180.7 151.3 188.3 147.1C195.8 142.8 205.1 142.1 212.5 147.5L356.5 235.5zM208 182.3V329.7L328.7 255.1L208 182.3zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M240 352V272H160C151.2 272 144 264.8 144 256C144 247.2 151.2 240 160 240H240V160C240 151.2 247.2 144 256 144C264.8 144 272 151.2 272 160V240H352C360.8 240 368 247.2 368 256C368 264.8 360.8 272 352 272H272V352C272 360.8 264.8 368 256 368C247.2 368 240 360.8 240 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-q": [512, 512, [], "e11e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C185.4 128 128 185.4 128 256s57.41 128 128 128c29.52 0 56.4-10.45 78.08-27.3l22.61 22.61C359.8 382.4 363.9 384 368 384s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-22.61-22.61C373.6 312.4 384 285.5 384 256C384 185.4 326.6 128 256 128zM334.1 311.5l-34.77-34.77c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l34.77 34.77C295.8 345.3 276.7 352 256 352c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96C352 276.7 345.3 295.8 334.1 311.5z"],
    "circle-quarter": [512, 512, [], "e11f", "M224.1 1.971C241.6-.2109 255.1 14.33 255.1 31.1V223.1C255.1 241.7 241.7 255.1 223.1 255.1H31.1C14.33 255.1-.2112 241.6 1.972 224.1C16.39 108.2 108.2 16.39 224.1 1.971V1.971zM34.26 223.1H223.1V34.26C125.9 48.28 48.28 125.9 34.26 223.1V223.1z"],
    "circle-quarters": [512, 512, [], "e3f8", "M256-.002c-141.4 0-256 114.6-256 256C0 397.4 114.6 512 256 512c141.4 0 256-114.6 256-256C512 114.6 397.4-.002 256-.002zM256 32c56.1 0 107.4 20.62 146.7 54.7L256 233.4L109.3 86.7C148.6 52.62 199.9 32 256 32zM32 255.1c0-56.1 20.62-107.4 54.7-146.7L233.4 256l-146.7 146.7C52.62 363.4 32 312.1 32 255.1zM256 480c-56.1 0-107.4-20.62-146.7-54.7L256 278.6l146.7 146.7C363.4 459.4 312.1 480 256 480zM425.3 402.7L278.6 256l146.7-146.7c34.08 39.3 54.7 90.58 54.7 146.7C480 312.1 459.4 363.4 425.3 402.7z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM240 344c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S253.3 344 240 344zM285.6 128H226.4C189.8 128 160 157.8 160 194.4V204c0 8.844 7.156 16 16 16S192 212.8 192 204V194.4C192 175.4 207.4 160 226.4 160h59.25C304.6 160 320 175.4 320 194.4c0 12.48-6.781 24-17.06 29.72L242.5 254.3C231.1 260.7 224 272.7 224 285.8V304C224 312.8 231.2 320 240 320S256 312.8 256 304V285.8c0-1.453 .7813-2.797 1.438-3.172l60.41-30.22C338.9 240.7 352 218.5 352 194.4C352 157.8 322.2 128 285.6 128z"],
    "circle-r": [512, 512, [], "e120", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 208C368 163.9 332.1 128 288 128H176C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V288h70.35l77.5 90.41C343 382.1 347.5 384 352 384c3.688 0 7.406-1.266 10.41-3.859c6.719-5.75 7.5-15.84 1.75-22.55l-60.97-71.13C340.1 279.3 368 246.9 368 208zM288 256H192V160h96c26.47 0 48 21.53 48 48S314.5 256 288 256z"],
    "circle-radiation": [512, 512, [9762, "radiation-alt"], "f7ba", "M306.3 295.6c-4.672-7.531-14.53-9.812-22.05-5.094c-7.484 4.688-9.766 14.53-5.078 22.03l41.83 66.97c1.234 2.031 .0156 3.312-.6875 3.781c-38.89 22.09-90.39 21.81-128.4 .1562c-.5625-.375-2.266-1.75-.9219-3.875l41.84-67.13c4.672-7.5 2.391-17.38-5.109-22.03c-7.516-4.719-17.39-2.406-22.05 5.094l-41.8 67.06c-5.094 8.062-6.688 17.44-4.516 26.34c2.25 9.188 8.359 17.47 16.48 22.22C199.9 424.9 227.6 432 256 432c28.19 0 55.88-7.167 80.14-20.92c7.891-4.5 14.02-12.62 16.36-21.72c2.297-8.906 .8125-18.31-4.281-26.66L306.3 295.6zM211.1 263.2C211.7 254.4 205.3 248.4 195.4 247.8L116.5 250.5c-2-.5625-2.859-1.656-2.938-2.469c.2031-22.31 6.297-44.47 17.62-64.09c11.39-19.72 27.52-36.09 46.38-47.13c.6406-.3438 2.719-1.094 3.891 1.125l37.22 69.78C222.9 215.5 232.5 218.5 240.3 214.3c7.797-4.156 10.75-13.84 6.594-21.66L209.7 122.1c-4.422-8.438-11.69-14.5-20.45-17.06C180.2 103.2 169.1 104.4 161.7 109C137.8 123.1 117.6 143.4 103.5 167.9c-14.08 24.41-21.66 52-21.91 79.91C81.55 256.1 85.53 266.3 92.23 272.9C98.58 279.1 107.1 282.5 116.5 282.5l80.03-2.75C205.4 279.4 212.3 272 211.1 263.2zM408.5 167.9c-14.09-24.41-34.2-44.75-58.27-58.94c-7.891-4.562-17.97-5.75-27.02-3.25c-8.828 2.469-16.22 8.438-20.91 17l-37.17 69.91c-4.156 7.781-1.188 17.47 6.609 21.62c7.812 4.188 17.5 1.188 21.64-6.625l37.08-69.72c1.188-2.125 3.078-1.531 3.625-1.312c19.22 11.34 35.36 27.69 46.69 47.31c11.39 19.75 17.48 41.91 17.62 63.75c-.0469 .6875 .6094 2.938-2.922 2.781l-79.06-2.656c-8 .75-16.22 6.625-16.52 15.47c-.2969 8.812 6.609 16.22 15.45 16.53c0 0 79.95 2.688 80.44 2.688c8.953 0 17.28-3.25 23.55-9.25c6.844-6.531 10.98-15.97 11.06-25.47C430.3 220.1 422.7 192.5 408.5 167.9zM256 16C123.5 16 16 123.4 16 256s107.5 240 240 240s240-107.4 240-240S388.5 16 256 16zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM232 256c0 13.25 10.75 24 24 24S280 269.3 280 256c0-13.26-10.75-24-24-24S232 242.7 232 256z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M292.3 135c-11.48-11.47-28.59-14.88-43.59-8.688C233.7 132.6 224 147.1 224 163.3V192H152C129.9 192 112 209.9 112 232v48C112 302.1 129.9 320 152 320H224v28.69c0 16.25 9.688 30.75 24.69 36.97c14.95 6.188 32 2.812 43.48-8.562l96.11-92.81c15.12-15.12 15.33-41.25-.2031-56.75L292.3 135zM365.9 261.5l-96 92.69C265 359 256 356.1 256 348.7V288H152C147.6 288 144 284.4 144 280v-48C144 227.6 147.6 224 152 224H256V163.3c0-6.414 8.047-11.26 13.86-5.471l95.8 92.5C369.9 254.5 367.5 259.9 365.9 261.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-s": [512, 512, [], "e121", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM260.2 240.6C209.4 226.1 187.7 218.1 192.8 190.4c1.094-5.953 4.469-14.41 14.38-20.81c13.41-8.672 42.06-15.94 102.2-1.062c8.719 2.094 17.25-3.125 19.38-11.69c2.125-8.578-3.125-17.25-11.69-19.38c-57.16-14.11-99.94-12.39-127.2 5.25c-15.22 9.844-25.34 24.73-28.5 41.92C150.3 244.2 209 260 251.8 271.5c50.78 13.66 72.47 22.53 67.38 50.22c-1.938 10.55-6.969 17.78-15.81 22.77c-23.06 12.92-70.81 8.766-121.7-10.61c-8.188-3.094-17.5 .9844-20.62 9.266c-3.156 8.25 1 17.5 9.25 20.64c15.66 5.953 57.13 20.16 96.94 20.16c18.59 0 36.81-3.094 51.84-11.56c17.06-9.594 27.97-25.11 31.62-44.88C361.7 267.9 303 252.1 260.2 240.6z"],
    "circle-small": [320, 512, [], "e122", "M320 256C320 344.4 248.4 416 160 416C71.63 416 0 344.4 0 256C0 167.6 71.63 96 160 96C248.4 96 320 167.6 320 256zM160 128C89.31 128 32 185.3 32 256C32 326.7 89.31 384 160 384C230.7 384 288 326.7 288 256C288 185.3 230.7 128 160 128z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M347.1 288H164.6C148.2 288 140.1 307.9 151.8 319.4L243 410.6C246.4 414.1 251.1 416 256 416s9.594-2 13.09-5.375l91.03-91.25C371.8 307.9 363.5 288 347.1 288zM256 378.4L197.6 320h116.6L256 378.4zM269.1 101.4C265.6 97.1 260.9 95.1 256 95.1S246.4 97.87 243 101.4L151.8 192.6C140.1 204.1 148.2 224 164.6 224h182.6c16.38 0 24.62-19.88 13-31.38L269.1 101.4zM197.6 192L256 133.6L314.3 192H197.6zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M347.4 288H164.9c-16.38 0-24.62 19.88-13 31.38L243 410.6C246.5 414 251.1 416 256 416s9.719-1.875 13.09-5.375l91.16-91.25C371.9 307.9 363.8 288 347.4 288zM256 378.4L197.8 320h116.6L256 378.4zM267.3 100.8c-6.25-6.25-16.38-6.25-22.62 0l-96 96C142.6 203 142.8 212.9 148.9 219C155.1 225.1 165 225.3 171.3 219.3L256 134.6l84.75 84.63c6.25 6 16.12 5.875 22.25-.25s6.25-16 .25-22.25L267.3 100.8zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-sort-up": [512, 512, ["sort-circle-up"], "e032", "M164.6 223.1L347.1 224c16.38 0 24.62-19.88 13-31.38L269 101.4C265.5 97.1 260.9 95.1 256 95.1S246.3 97.87 242.9 101.4L151.8 192.6C140.1 204.1 148.2 223.1 164.6 223.1zM256 133.6L314.3 192H197.6L256 133.6zM340.8 292.8L256 377.4L171.3 292.8C165 286.8 155.1 286.9 149 293s-6.25 16-.25 22.25l96 96c6.25 6.25 16.25 6.25 22.5 0l96-96c6-6.25 5.875-16.12-.25-22.25S347 286.8 340.8 292.8zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-star": [512, 512, ["star-circle"], "e123", "M306.6 186.4L387.6 198.1C393.7 199 398.7 203.2 400.6 209C402.4 214.8 400.9 221.2 396.5 225.4L337.9 282.6L351.7 363.3C352.7 369.3 350.3 375.4 345.3 378.1C340.4 382.6 333.9 383 328.5 380.2L256 342.1L183.5 380.2C178.1 383 171.6 382.6 166.7 378.1C161.7 375.4 159.3 369.3 160.3 363.3L174.1 282.6L115.5 225.4C111.1 221.2 109.6 214.8 111.4 209C113.3 203.2 118.3 199 124.4 198.1L205.4 186.4L241.7 112.9C244.3 107.5 249.9 104 256 104C262.1 104 267.7 107.5 270.3 112.9L306.6 186.4zM218.3 216.8L161 225.1L202.5 265.6C206.3 269.2 207.1 274.5 207.1 279.7L197.3 336.8L248.6 309.8C253.2 307.4 258.8 307.4 263.4 309.8L314.7 336.8L304.9 279.7C304 274.5 305.7 269.2 309.5 265.6L350.1 225.1L293.7 216.8C288.5 216.1 283.1 212.8 281.6 208.1L255.1 156.2L230.4 208.1C228 212.8 223.5 216.1 218.3 216.8H218.3zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M320 160H192C174.4 160 160 174.4 160 192v128c0 17.6 14.4 32 32 32h128c17.6 0 32-14.4 32-32V192C352 174.4 337.6 160 320 160zM320 320H192V192h128V320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-t": [512, 512, [], "e124", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 160h-224C135.2 160 128 167.2 128 176S135.2 192 144 192h96v176c0 8.844 7.156 16 16 16s16-7.156 16-16V192h96C376.8 192 384 184.8 384 176S376.8 160 368 160z"],
    "circle-three-quarters": [512, 512, [], "e125", "M224.1 1.971C241.6-.2109 256 14.33 256 31.1V255.1H480C497.7 255.1 512.2 270.4 510 287.9C494.3 414.2 386.6 512 256 512C114.6 512 0 397.4 0 255.1C0 125.4 97.75 17.69 224.1 1.971V1.971zM224 287.1V34.26C115.5 49.77 32 143.2 32 255.1C32 379.7 132.3 480 256 480C368.8 480 462.2 396.5 477.7 287.1H224z"],
    "circle-trash": [512, 512, ["trash-circle"], "e126", "M201.4 144L212.7 132.7C215.7 129.7 219.8 128 223.1 128H288C292.2 128 296.3 129.7 299.3 132.7L310.6 144H352C360.8 144 368 151.2 368 160C368 168.8 360.8 176 352 176H349.9L337.1 354.1C336.9 370.9 322.9 384 306.1 384H205.9C189.1 384 175.1 370.9 174 354.1L162.1 176H159.1C151.2 176 143.1 168.8 143.1 160C143.1 151.2 151.2 144 159.1 144H201.4zM317.8 176H194.2L205.9 352H306.1L317.8 176zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-u": [512, 512, [], "e127", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 144c-8.844 0-16 7.156-16 16v129.8C336 332.9 300.1 368 256 368s-80-35.09-80-78.25V160c0-8.844-7.156-16-16-16S144 151.2 144 160v129.8C144 350.5 194.3 400 256 400s112-49.47 112-110.3V160C368 151.2 360.8 144 352 144z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M284.3 123.7C269.2 108.6 243 108.4 227.5 123.9l-92.5 95.8C123.6 231.2 120.2 248.3 126.3 263.3C132.6 278.3 147.1 288 163.3 288H192v72c0 22.06 17.94 40 40 40h48c22.06 0 40-17.94 40-40V288h28.69c16.25 0 30.75-9.688 36.97-24.69c6.188-14.95 2.812-32-8.562-43.48L284.3 123.7zM348.7 256H288l.0006 104c0 4.406-3.594 8-8.001 8h-48c-4.406 0-7.999-3.594-7.999-8L224 256H163.3C156.9 256 152.1 247.1 157.8 242.1l92.5-95.8c4.162-4.203 9.533-1.797 11.12-.2031l92.69 96C359 246.1 356.1 256 348.7 256zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-up-left": [512, 512, [], "e128", "M323.9 233.4l20.29-20.29c11.49-11.49 14.89-28.59 8.684-43.59c-6.199-14.95-20.64-24.62-36.8-24.7l-133.6-2.332c-21.39 0-40.01 18.33-39.98 40.27l2.33 133.1c.0117 16.23 9.701 30.73 24.68 36.97c15 6.211 32.11 2.805 43.6-8.688l20.29-20.28l50.91 50.91c15.6 15.6 40.97 15.6 56.57 0l33.94-33.94c15.6-15.6 15.6-40.97 0-56.57L323.9 233.4zM352.2 318.2L318.2 352.2c-3.115 3.117-8.197 3.117-11.31 0L233.4 278.6l-42.91 42.91c-4.537 4.535-13.65 2.27-13.67-5.934l-2.332-133.1c-.0293-5.918 5.471-8.012 7.725-8.008l133.4 2.34c6.861 0 11.19 8.41 5.932 13.67l-42.91 42.91l73.54 73.54C355.3 310 355.3 315.1 352.2 318.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-up-right": [512, 512, [], "e129", "M329.5 142.5l-133.6 2.332c-16.16 .0781-30.6 9.742-36.8 24.7c-6.209 15-2.807 32.1 8.684 43.59l20.29 20.29L137.2 284.3c-15.6 15.6-15.6 40.97 0 56.57l33.94 33.94c15.6 15.6 40.97 15.6 56.57 0l50.91-50.91l20.29 20.28c11.49 11.49 28.59 14.9 43.6 8.688c14.98-6.234 24.67-20.74 24.68-36.97l2.33-133.1C369.5 160.8 350.9 142.5 329.5 142.5zM335.2 315.6c-.0176 8.203-9.131 10.47-13.67 5.934l-42.91-42.91L205.1 352.2c-3.115 3.117-8.197 3.117-11.31 0L159.8 318.2c-3.115-3.117-3.115-8.201 0-11.31l73.54-73.54L190.5 190.5C185.2 185.2 189.3 176.8 196.1 176.8l133.7-2.352c2.254-.0039 7.754 2.09 7.725 8.008L335.2 315.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-47.24 0-91.04-14.78-127.2-39.84C132.9 390.9 173.8 352 224 352h64c50.25 0 91.14 38.94 95.21 88.16C347 465.2 303.2 480 256 480zM411.7 416.7C397.6 361.3 347.7 320 288 320H224c-59.73 0-109.6 41.3-123.7 96.72C58.27 375.1 32 319 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224C480 319 453.7 375.1 411.7 416.7zM256 128C211.8 128 176 163.8 176 208C176 252.2 211.8 288 256 288s80-35.82 80-80C336 163.8 300.2 128 256 128zM256 256C229.5 256 208 234.5 208 208S229.5 160 256 160s48 21.53 48 48S282.5 256 256 256z"],
    "circle-v": [512, 512, [], "e12a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM375.2 145.7c-7.938-3.969-17.5-.7187-21.47 7.156L256 348.2L158.3 152.8C154.3 144.1 144.8 141.7 136.8 145.7c-7.906 3.969-11.11 13.56-7.156 21.47l112 224C244.4 396.6 249.9 400 256 400s11.59-3.438 14.31-8.844l112-224C386.3 159.3 383.1 149.7 375.2 145.7z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M409.2 178.9c-4.266-2.984-9.719-3.703-14.64-1.922L320 204.1V192c0-17.67-14.33-32-32-32H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32V307.9l74.53 27.1C396.3 335.7 398.2 336 400 336c3.234 0 6.453-.9844 9.172-2.891C413.5 330.1 416 325.2 416 320V192C416 186.8 413.5 181.9 409.2 178.9zM288 320H160V192h128V320zM384 297.2L320 273.9V238.1l64-23.27V297.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-w": [512, 512, [], "e12c", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM388.4 144.6C380 142.1 371 147.1 368.6 155.6L320 325.8l-48.61-170.2c-3.938-13.69-26.84-13.69-30.78 0L192 325.8L143.4 155.6C140.1 147.1 132 142.1 123.6 144.6c-8.5 2.406-13.42 11.28-11 19.78l64 224c3.938 13.69 26.84 13.69 30.78 0L256 218.3l48.61 170.2C306.6 395.3 312.8 400 319.9 400s13.48-4.75 15.45-11.59l64-224C401.8 155.9 396.9 147 388.4 144.6z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M272 136c-8.836 0-16 7.162-16 16v208c0 8.836 7.164 16 16 16s16-7.164 16-16v-208C288 143.2 280.8 136 272 136zM208 200C199.2 200 192 207.2 192 216v80c0 8.836 7.164 16 16 16S224 304.8 224 296v-80C224 207.2 216.8 200 208 200zM144 160C135.2 160 128 167.2 128 176v160C128 344.8 135.2 352 144 352S160 344.8 160 336v-160C160 167.2 152.8 160 144 160zM400 224C391.2 224 384 231.2 384 240v32C384 280.8 391.2 288 400 288S416 280.8 416 272v-32C416 231.2 408.8 224 400 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 184c-8.836 0-16 7.162-16 16v112c0 8.836 7.164 16 16 16s16-7.164 16-16v-112C352 191.2 344.8 184 336 184z"],
    "circle-x": [512, 512, [], "e12e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM362.4 131.8c-6.688-5.75-16.8-4.938-22.55 1.75L256 231.4l-83.86-97.84C166.4 126.9 156.3 126.2 149.6 131.8c-6.719 5.75-7.5 15.88-1.734 22.56L234.9 256l-87.08 101.6c-5.766 6.688-4.984 16.81 1.734 22.56C152.6 382.8 156.3 384 160 384c4.5 0 8.984-1.906 12.14-5.594L256 280.6l83.86 97.84C343 382.1 347.5 384 352 384c3.688 0 7.391-1.281 10.41-3.844c6.719-5.75 7.5-15.88 1.734-22.56L277.1 256l87.08-101.6C369.9 147.7 369.1 137.6 362.4 131.8z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M180.7 180.7C186.9 174.4 197.1 174.4 203.3 180.7L256 233.4L308.7 180.7C314.9 174.4 325.1 174.4 331.3 180.7C337.6 186.9 337.6 197.1 331.3 203.3L278.6 256L331.3 308.7C337.6 314.9 337.6 325.1 331.3 331.3C325.1 337.6 314.9 337.6 308.7 331.3L256 278.6L203.3 331.3C197.1 337.6 186.9 337.6 180.7 331.3C174.4 325.1 174.4 314.9 180.7 308.7L233.4 256L180.7 203.3C174.4 197.1 174.4 186.9 180.7 180.7zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "circle-y": [512, 512, [], "e12f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM355.9 149.6L256 266.1L156.1 149.6C150.4 142.9 140.3 142.2 133.6 147.8c-6.719 5.75-7.5 15.88-1.734 22.56L240 296.6V384c0 8.844 7.156 16 16 16s16-7.156 16-16V296.6l108.1-126.2c5.766-6.688 4.984-16.81-1.734-22.56C371.7 142.2 361.6 142.9 355.9 149.6z"],
    "circle-z": [512, 512, [], "e130", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 352H194.8l169.4-197.6c4.062-4.75 5-11.41 2.375-17.09C363.9 131.6 358.3 128 352 128H160C151.2 128 144 135.2 144 144S151.2 160 160 160h157.2l-169.4 197.6c-4.062 4.75-5 11.41-2.375 17.09C148.1 380.4 153.8 384 160 384h192c8.844 0 16-7.156 16-16S360.8 352 352 352z"],
    "citrus": [512, 512, [], "e2f4", "M463.9 151.1c-4.469-7.703-14.38-10.25-21.84-5.828c-7.656 4.422-10.28 14.2-5.844 21.86C454.4 199.5 464 235.4 464 272c0 114.7-93.31 208-208 208s-208-93.31-208-208S141.3 64 256 64c12.42 0 24.66 1.463 36.76 3.621C289.9 76.65 288 86.05 288 96v16C288 120.8 295.2 128 304 128H384c53.02 0 96-42.98 96-96V16c0-8.836-7.164-16-16-16H384c-31.23 0-58.71 15.16-76.25 38.26C290.8 34.52 273.6 31.1 256 31.1c-132.3 0-240 107.7-240 239.1S123.7 512 256 512s240-107.7 240-240C496 229.8 484.9 188.3 463.9 151.1zM384 32h64c0 35.29-28.71 64-64 64h-64C320 60.71 348.7 32 384 32z"],
    "citrus-slice": [512, 512, [], "e2f5", "M425.1 4.688C422.1 1.688 418 0 413.8 0c-4.25 0-8.314 1.688-11.31 4.688L4.689 402.4C1.688 405.4 0 409.5 0 413.8s1.688 8.314 4.689 11.32C62.64 483 138.8 512 214.9 512c76.15 0 152.3-28.98 210.2-86.93C540.1 309.2 540.1 120.6 425.1 4.688zM367.4 344.8l-83.94-83.94C293.8 244.1 297.4 226.1 294.9 208h120.1C416.7 256.7 400.9 305.5 367.4 344.8zM250.8 250.8C236.2 265.2 213 266.7 195.8 256.6l60.91-60.91C267.2 213.1 265.7 235.8 250.8 250.8zM218.8 296c15.18 0 29.66-4.42 42.09-12.54l84.48 84.48c-36.38 31.09-82.06 48.17-130.4 48.17c-2.342 0-4.578-.5313-6.906-.6113V294.1C211.6 295.4 215.1 296 218.8 296zM283.1 176c-.8594-1.293-2.045-2.414-2.99-3.666l87.87-87.86C390.9 111.4 404.1 143.1 411.4 176H283.1zM172.3 280.1C173.6 281.1 174.7 282.2 176 283.1v128.1c-33.71-6.623-65.12-21.55-91.55-44.14L172.3 280.1zM402.5 402.4c-99.56 99.62-259.4 103.3-363.5 10.97l22.84-22.84c42.48 37.1 96.16 57.55 153.1 57.55c62.27 0 120.8-24.26 164.9-68.32c87.11-87.11 90.54-226.4 10.74-317.1l22.86-22.86C505.7 143 502.1 302.8 402.5 402.4z"],
    "city": [640, 512, [127961], "f64f", "M96 64H160V16C160 7.164 167.2 0 176 0C184.8 0 192 7.164 192 16V80C192 88.84 184.8 96 176 96H64C46.33 96 32 110.3 32 128V448C32 465.7 46.33 480 64 480H192C200.8 480 208 487.2 208 496C208 504.8 200.8 512 192 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64V16C64 7.164 71.16 0 80 0C88.84 0 96 7.164 96 16V64zM320 344C320 330.7 330.7 320 344 320H392C405.3 320 416 330.7 416 344V392C416 405.3 405.3 416 392 416H344C330.7 416 320 405.3 320 392V344zM384 384V352H352V384H384zM392 64C405.3 64 416 74.75 416 88V136C416 149.3 405.3 160 392 160H344C330.7 160 320 149.3 320 136V88C320 74.75 330.7 64 344 64H392zM384 128V96H352V128H384zM320 216C320 202.7 330.7 192 344 192H392C405.3 192 416 202.7 416 216V264C416 277.3 405.3 288 392 288H344C330.7 288 320 277.3 320 264V216zM384 256V224H352V256H384zM504 448C490.7 448 480 437.3 480 424V376C480 362.7 490.7 352 504 352H552C565.3 352 576 362.7 576 376V424C576 437.3 565.3 448 552 448H504zM512 384V416H544V384H512zM480 248C480 234.7 490.7 224 504 224H552C565.3 224 576 234.7 576 248V296C576 309.3 565.3 320 552 320H504C490.7 320 480 309.3 480 296V248zM544 288V256H512V288H544zM512 64V160H576C611.3 160 640 188.7 640 224V448C640 483.3 611.3 512 576 512H288C252.7 512 224 483.3 224 448V64C224 28.65 252.7 0 288 0H448C483.3 0 512 28.65 512 64zM480 192V64C480 46.33 465.7 32 448 32H288C270.3 32 256 46.33 256 64V448C256 465.7 270.3 480 288 480H576C593.7 480 608 465.7 608 448V224C608 206.3 593.7 192 576 192H480zM88 352C74.75 352 64 341.3 64 328V280C64 266.7 74.75 256 88 256H136C149.3 256 160 266.7 160 280V328C160 341.3 149.3 352 136 352H88zM96 288V320H128V288H96zM64 152C64 138.7 74.75 128 88 128H136C149.3 128 160 138.7 160 152V200C160 213.3 149.3 224 136 224H88C74.75 224 64 213.3 64 200V152zM128 192V160H96V192H128z"],
    "clapperboard": [512, 512, [], "e131", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM433.4 64l-96 96H230.6l96-96H433.4zM281.4 64l-96 96H78.63l96-96H281.4zM32 96c0-17.64 14.36-32 32-32h65.38l-96 96H32V96zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V192h448V416zM480 160h-97.38l87.17-87.17C476 78.67 480 86.82 480 96V160z"],
    "clapperboard-play": [512, 512, [], "e132", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM433.4 64l-96 96H230.6l96-96H433.4zM281.4 64l-96 96H78.63l96-96H281.4zM32 96c0-17.64 14.36-32 32-32h65.38l-96 96H32V96zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V192h448V416zM480 160h-97.38l87.17-87.17C476 78.67 480 86.82 480 96V160zM205.6 412.5C209.6 414.8 214.1 416 218.7 416c5.125 0 10.16-1.511 14.38-4.276l106.6-68.94C347.4 337.8 352 329.3 352 319.1c0-9.281-4.628-17.81-12.35-22.8L233 228.3c-8.312-5.422-18.75-5.763-27.47-.7783C197.2 232.3 192 241.3 192 251v137.9C192 398.7 197.2 407.7 205.6 412.5zM224 260.5L315.1 320L224 379.5V260.5z"],
    "clarinet": [640, 512, [], "f8ad", "M272 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1S296 269.2 296 255.1C296 242.7 285.3 231.1 272 231.1zM616 111.1c-4.75 0-9.375 1.375-13.25 3.1l-66 43.1L480 159.1V127.1h16c8.801 0 16-7.199 16-15.1C512 103.2 504.8 96 496 96h-256C231.2 96 224 103.2 224 111.1c0 8.801 7.199 15.1 16 15.1H256v31.1L101.3 159.1c-3.5 0-6.875 .5015-10.12 1.625L21.82 184.8C8.821 189.1 0 201.4 0 215.1v81.82c0 13.77 8.81 26 21.87 30.37l69.25 23.12c3.25 1.125 6.625 1.625 10.12 1.625l435.5 .0001l66 43.1c7.375 4.875 16.75 5.375 24.62 1.125C635.1 392.1 640 384.9 640 375.1V135.1C640 122.7 629.3 111.1 616 111.1zM384 127.1h64v31.1l-64 .0002V127.1zM288 127.1h64v31.1L288 159.1V127.1zM608 360.1l-61.63-41L101.3 319.1L32 296.1v-81.1l69.25-22.1h445.1L608 150.1V360.1zM368 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C392 242.7 381.3 231.1 368 231.1zM464 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C488 242.7 477.3 231.1 464 231.1z"],
    "claw-marks": [512, 512, [], "f6c2", "M427.3 404.7C424.3 401.7 420.3 400 416 400l-48 .0094L368 352c0-4.25-1.688-8.312-4.688-11.31l-96-96C264.3 241.7 260.3 240 256 240L208 240L208 192c0-4.25-1.688-8.312-4.688-11.31l-176-176C24.19 1.562 20.09 0 16 0C7.473 0 0 6.865 0 16c0 4.094 1.562 8.188 4.688 11.31L176 198.6V256c0 8.844 7.156 16 16 16h57.38L336 358.6V416c0 8.844 7.156 16 16 16h57.38l75.31 75.31C487.8 510.4 491.9 512 496 512c8.527 0 16-6.865 16-16c0-4.094-1.562-8.188-4.688-11.31L427.3 404.7zM240 38.63V96c0 8.844 7.156 16 16 16h57.38L368 166.6V224c0 8.844 7.156 16 16 16h57.38l43.31 43.31C487.8 286.4 491.9 288 496 288C504.5 288 512 281.1 512 272c0-4.094-1.562-8.188-4.688-11.31l-48-48C456.3 209.7 452.3 208 448 208l-48 .0122L400 160c0-4.25-1.688-8.312-4.688-11.31l-64-64C328.3 81.69 324.3 80 320 80l-48 .0141L272 32c0-4.25-1.688-8.312-4.688-11.31l-16-16C248.2 1.562 244.1 0 240 0C231.5 0 224 6.865 224 16c0 4.094 1.562 8.188 4.688 11.31L240 38.63zM171.3 372.7C168.3 369.7 164.3 368 160 368l-47.1 .0099L112 320c0-4.25-1.688-8.312-4.688-11.31l-80-80C24.19 225.6 20.09 224 16 224C7.473 224 0 230.9 0 240c0 4.094 1.562 8.188 4.688 11.31L80 326.6V384c0 8.844 7.156 16 16 16h57.38l107.3 107.3C263.8 510.4 267.9 512 272 512c8.527 0 16-6.865 16-16c0-4.094-1.562-8.188-4.688-11.31L171.3 372.7z"],
    "clipboard": [384, 512, [128203], "f328", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64z"],
    "clipboard-check": [384, 512, [], "f46c", "M320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM84.69 299.3l64 64C151.8 366.4 155.9 368 160 368s8.188-1.562 11.31-4.688l128-128c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L160 329.4L107.3 276.7c-6.25-6.25-16.38-6.25-22.62 0S78.44 293.1 84.69 299.3z"],
    "clipboard-list": [384, 512, [], "f46d", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM72 256c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C82.75 232 72 242.7 72 256zM96 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 338.7 109.3 328 96 328zM304 240h-128C167.2 240 160 247.2 160 256s7.156 16 16 16h128C312.8 272 320 264.8 320 256S312.8 240 304 240zM304 336h-128C167.2 336 160 343.2 160 352s7.156 16 16 16h128c8.844 0 16-7.156 16-16S312.8 336 304 336z"],
    "clipboard-list-check": [384, 512, [], "f737", "M304 336h-128C167.2 336 160 343.2 160 352s7.156 16 16 16h128c8.844 0 16-7.156 16-16S312.8 336 304 336zM304 240h-96C199.2 240 192 247.2 192 256s7.156 16 16 16h96C312.8 272 320 264.8 320 256S312.8 240 304 240zM96 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 338.7 109.3 328 96 328zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM68.25 229.2c-6 6.5-5.594 16.59 .9062 22.59l34.66 32C106.9 286.6 110.8 288 114.7 288c4.203 0 8.406-1.656 11.55-4.938l61.33-64c6.125-6.375 5.906-16.5-.4844-22.62c-6.359-6.094-16.48-5.906-22.61 .5L113.1 249.6L90.84 228.3C84.39 222.3 74.22 222.6 68.25 229.2z"],
    "clipboard-medical": [384, 512, [], "e133", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.34-28.65-64-64-64S128 28.66 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 336H160V384c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-48h48c8.836 0 16-7.164 16-16V288c0-8.836-7.164-16-16-16H224V224c0-8.836-7.164-16-16-16h-32C167.2 208 160 215.2 160 224v48H112C103.2 272 96 279.2 96 288v32C96 328.8 103.2 336 112 336z"],
    "clipboard-prescription": [384, 512, [], "f5e8", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM80 352c0 8.844 7.156 16 16 16s16-7.156 16-16V304h41.38l64 64l-36.69 36.69c-6.25 6.25-6.25 16.38 0 22.62C183.8 430.4 187.9 432 192 432s8.188-1.562 11.31-4.688L240 390.6l36.69 36.69C279.8 430.4 283.9 432 288 432s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L262.6 368l36.69-36.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 345.4l-44.68-44.68C221.1 292.4 240 268.5 240 240c0-35.28-28.7-64-64-64H96C87.16 176 80 183.2 80 192V352zM112 208h64c17.64 0 32 14.34 32 32s-14.36 32-32 32h-64V208z"],
    "clipboard-question": [384, 512, [], "e4e3", "M272 96C280.8 96 288 103.2 288 112C288 120.8 280.8 128 272 128H112C103.2 128 96 120.8 96 112C96 103.2 103.2 96 112 96H136.6C131.1 86.59 128 75.66 128 64C128 28.65 156.7 0 192 0C227.3 0 256 28.65 256 64C256 75.66 252.9 86.59 247.4 96H272zM192 32C174.3 32 160 46.33 160 64C160 81.67 174.3 96 192 96C209.7 96 224 81.67 224 64C224 46.33 209.7 32 192 32zM79.78 77.37C81.24 86.09 75.35 94.33 66.63 95.78L58.74 97.1C43.31 99.67 32 113 32 128.7V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V128.7C352 113 340.7 99.67 325.3 97.1L317.4 95.78C308.7 94.33 302.8 86.09 304.2 77.37C305.7 68.65 313.9 62.77 322.6 64.22L330.5 65.53C361.4 70.68 384 97.38 384 128.7V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V128.7C0 97.38 22.62 70.68 53.48 65.53L61.37 64.22C70.09 62.76 78.33 68.65 79.78 77.37zM104.7 233.8C111.2 209.2 133.4 192 158.9 192H216C251.5 192 280 221 280 256.3C280 280.3 266.6 302.5 245.1 313.4L208 332.3V352C208 360.8 200.8 368 192 368C183.2 368 176 360.8 176 352V322.5C176 316.5 179.4 311 184.7 308.3L230.5 284.9C241.2 279.5 248 268.3 248 256.3C248 238.5 233.6 224 216 224H158.9C147.1 224 138.4 231.4 135.7 241.9L135.5 242.6C133.2 251.1 124.5 256.3 115.9 254C107.4 251.8 102.3 243 104.5 234.5L104.7 233.8zM216 416C216 429.3 205.3 440 192 440C178.7 440 168 429.3 168 416C168 402.7 178.7 392 192 392C205.3 392 216 402.7 216 416z"],
    "clipboard-user": [384, 512, [], "f7f3", "M320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM80 416c0 8.836 7.164 16 16 16s16-7.164 16-16c0-26.51 21.49-48 48-48h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16c0-44.18-35.82-80-80-80H160C115.8 336 80 371.8 80 416zM256 240c0-35.35-28.65-64-64-64s-64 28.65-64 64s28.65 64 64 64S256 275.3 256 240zM160 240c0-17.64 14.36-32 32-32s32 14.36 32 32s-14.36 32-32 32S160 257.6 160 240z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V247.4L360.9 306.7C368.2 311.6 370.2 321.5 365.3 328.9C360.4 336.2 350.5 338.2 343.1 333.3L247.1 269.3C242.7 266.3 239.1 261.3 239.1 256L240 112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"],
    "clock-desk": [448, 512, [], "e134", "M224 96C232.8 96 240 103.2 240 112V217.4L283.3 260.7C289.6 266.9 289.6 277.1 283.3 283.3C277.1 289.6 266.9 289.6 260.7 283.3L212.7 235.3C209.7 232.3 207.1 228.2 207.1 224V112C207.1 103.2 215.2 96 223.1 96H224zM224 0C347.7 0 448 100.3 448 224V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V224C0 100.3 100.3 0 224 0zM224 32C117.1 32 32 117.1 32 224C32 330 117.1 416 224 416C330 416 416 330 416 224C416 117.1 330 32 224 32zM416 339.4C376.8 404.5 305.5 448 224 448C142.5 448 71.2 404.5 32 339.4V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V339.4z"],
    "clock-eight": [512, 512, [], "e345", "M272 256C272 261.3 269.3 266.3 264.9 269.3L168.9 333.3C161.5 338.2 151.6 336.2 146.7 328.9C141.8 321.5 143.8 311.6 151.1 306.7L240 247.4V112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-eight-thirty": [512, 512, [], "e346", "M240 285.9L168.9 333.3C161.5 338.2 151.6 336.2 146.7 328.9C141.8 321.5 143.8 311.6 151.1 306.7L247.1 242.7C252 239.4 258.3 239.1 263.5 241.9C268.8 244.7 272 250.1 272 256V400C272 408.8 264.8 416 255.1 416C247.2 416 239.1 408.8 239.1 400L240 285.9zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "clock-eleven": [512, 512, [], "e347", "M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256C272 263.1 267.4 269.3 260.6 271.3C253.9 273.4 246.6 270.7 242.7 264.9L178.7 168.9C173.8 161.5 175.8 151.6 183.1 146.7C190.5 141.8 200.4 143.8 205.3 151.1L239.1 203.2L240 112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M240 260.8L178.7 168.9C173.8 161.5 175.8 151.6 183.1 146.7C190.5 141.8 200.4 143.8 205.3 151.1L269.3 247.1C271.1 249.8 272 252.8 272 256V400C272 408.8 264.8 416 255.1 416C247.2 416 239.1 408.8 239.1 400L240 260.8zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "clock-five": [512, 512, [], "e349", "M272 251.2L333.3 343.1C338.2 350.5 336.2 360.4 328.9 365.3C321.5 370.2 311.6 368.2 306.7 360.9L242.7 264.9C240.9 262.2 240 259.2 240 255.1V111.1C240 103.2 247.2 95.1 256 95.1C264.8 95.1 272 103.2 272 111.1L272 251.2zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-five-thirty": [512, 512, [], "e34a", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V256C240 248.9 244.6 242.7 251.4 240.7C258.1 238.6 265.4 241.3 269.3 247.1L333.3 343.1C338.2 350.5 336.2 360.4 328.9 365.3C321.5 370.2 311.6 368.2 306.7 360.9L272 308.8L272 400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V256C240 250.1 243.2 244.7 248.5 241.9C253.7 239.1 259.1 239.4 264.9 242.7L360.9 306.7C368.2 311.6 370.2 321.5 365.3 328.9C360.4 336.2 350.5 338.2 343.1 333.3L272 285.9L272 400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-nine": [512, 512, [], "e34c", "M272 256C272 264.8 264.8 272 256 272H144C135.2 272 128 264.8 128 256C128 247.2 135.2 240 144 240H240V112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V272H144C135.2 272 128 264.8 128 256C128 247.2 135.2 240 144 240H256C264.8 240 272 247.2 272 256V400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-one": [512, 512, [], "e34e", "M272 203.2L306.7 151.1C311.6 143.8 321.5 141.8 328.9 146.7C336.2 151.6 338.2 161.5 333.3 168.9L269.3 264.9C265.4 270.7 258.1 273.4 251.4 271.3C244.6 269.3 239.1 263.1 239.1 256V112C239.1 103.2 247.2 96 255.1 96C264.8 96 272 103.2 272 112L272 203.2zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V256C240 252.8 240.9 249.8 242.7 247.1L306.7 151.1C311.6 143.8 321.5 141.8 328.9 146.7C336.2 151.6 338.2 161.5 333.3 168.9L272 260.8L272 400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-rotate-left": [512, 512, ["history"], "f1da", "M256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C172.2 512 97.87 471.8 51.19 409.6C45.88 402.5 47.31 392.5 54.37 387.2C61.44 381.9 71.47 383.3 76.78 390.4C117.7 444.8 182.7 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C166.7 32 89.51 84.3 53.55 160H144C152.8 160 160 167.2 160 176C160 184.8 152.8 192 144 192H16C7.164 192 0 184.8 0 176V48C0 39.16 7.164 32 16 32C24.84 32 32 39.16 32 48V131.1C75.66 53.29 159.6 0 256 0zM256 128C264.8 128 272 135.2 272 144V249.4L347.3 324.7C353.6 330.9 353.6 341.1 347.3 347.3C341.1 353.6 330.9 353.6 324.7 347.3L244.7 267.3C241.7 264.3 239.1 260.2 239.1 256V144C239.1 135.2 247.2 128 255.1 128H256z"],
    "clock-seven": [512, 512, [], "e350", "M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256C272 259.2 271.1 262.2 269.3 264.9L205.3 360.9C200.4 368.2 190.5 370.2 183.1 365.3C175.8 360.4 173.8 350.5 178.7 343.1L240 251.2L240 112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M240 308.8L205.3 360.9C200.4 368.2 190.5 370.2 183.1 365.3C175.8 360.4 173.8 350.5 178.7 343.1L242.7 247.1C246.6 241.3 253.9 238.6 260.6 240.7C267.4 242.7 272 248.9 272 255.1V400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400L240 308.8zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "clock-six": [512, 512, [], "e352", "M272 368C272 376.8 264.8 384 256 384C247.2 384 240 376.8 240 368V112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V368zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-six-thirty": [512, 512, [], "e353", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V256C240 247.2 247.2 240 256 240C264.8 240 272 247.2 272 256V400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-ten": [512, 512, [], "e354", "M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256C272 261.9 268.8 267.3 263.5 270.1C258.3 272.9 252 272.6 247.1 269.3L151.1 205.3C143.8 200.4 141.8 190.5 146.7 183.1C151.6 175.8 161.5 173.8 168.9 178.7L240 226.1L240 112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V264.6L151.1 205.3C143.8 200.4 141.8 190.5 146.7 183.1C151.6 175.8 161.5 173.8 168.9 178.7L264.9 242.7C269.3 245.7 272 250.6 272 255.1V400zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256z"],
    "clock-three": [512, 512, [], "e356", "M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V240H368C376.8 240 384 247.2 384 256C384 264.8 376.8 272 368 272H256C247.2 272 240 264.8 240 256V112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"],
    "clock-three-thirty": [512, 512, [], "e357", "M240 256C240 247.2 247.2 240 256 240H368C376.8 240 384 247.2 384 256C384 264.8 376.8 272 368 272H272V400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V256zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "clock-twelve": [512, 512, [], "e358", "M272 256C272 264.8 264.8 272 256 272C247.2 272 240 264.8 240 256V112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-twelve-thirty": [512, 512, [], "e359", "M272 400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400V144C240 135.2 247.2 128 256 128C264.8 128 272 135.2 272 144V400zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-two": [512, 512, [], "e35a", "M272 226.1L343.1 178.7C350.5 173.8 360.4 175.8 365.3 183.1C370.2 190.5 368.2 200.4 360.9 205.3L264.9 269.3C259.1 272.6 253.7 272.9 248.5 270.1C243.2 267.3 240 261.9 240 255.1V111.1C240 103.2 247.2 95.1 256 95.1C264.8 95.1 272 103.2 272 111.1L272 226.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "clock-two-thirty": [512, 512, [], "e35b", "M240 256C240 250.7 242.7 245.7 247.1 242.7L343.1 178.7C350.5 173.8 360.4 175.8 365.3 183.1C370.2 190.5 368.2 200.4 360.9 205.3L272 264.6V400C272 408.8 264.8 416 256 416C247.2 416 240 408.8 240 400L240 256zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "clone": [512, 512, [], "f24d", "M64 480H288C305.7 480 320 465.7 320 448V400C320 391.2 327.2 384 336 384C344.8 384 352 391.2 352 400V448C352 483.3 323.3 512 288 512H64C28.65 512 0 483.3 0 448V224C0 188.7 28.65 160 64 160H112C120.8 160 128 167.2 128 176C128 184.8 120.8 192 112 192H64C46.33 192 32 206.3 32 224V448C32 465.7 46.33 480 64 480zM160 64C160 28.65 188.7 0 224 0H448C483.3 0 512 28.65 512 64V288C512 323.3 483.3 352 448 352H224C188.7 352 160 323.3 160 288V64zM224 320H448C465.7 320 480 305.7 480 288V64C480 46.33 465.7 32 448 32H224C206.3 32 192 46.33 192 64V288C192 305.7 206.3 320 224 320z"],
    "closed-captioning": [576, 512, [], "f20a", "M248.9 210.7c6.25 6.25 16.37 6.25 22.62 0s6.25-16.38 0-22.62c-36.25-36.25-99.5-36.25-135.7 0c-37.42 37.44-37.42 98.31 0 135.8c18.12 18.13 42.23 28.12 67.87 28.12s49.75-9.1 67.87-28.12c6.25-6.25 6.25-16.38 0-22.62s-16.37-6.25-22.62 0c-24.19 24.19-66.31 24.19-90.5 0c-24.95-24.94-24.95-65.56 0-90.5C182.6 186.6 224.8 186.6 248.9 210.7zM440.9 210.7c6.25 6.25 16.37 6.25 22.62 0s6.25-16.38 0-22.62c-36.25-36.25-99.5-36.25-135.7 0c-37.42 37.44-37.42 98.31 0 135.8c18.12 18.13 42.23 28.12 67.87 28.12c25.64 0 49.75-9.1 67.87-28.12c6.25-6.25 6.25-16.38 0-22.62s-16.37-6.25-22.62 0c-24.19 24.19-66.31 24.19-90.5 0c-24.95-24.94-24.95-65.56 0-90.5C374.6 186.6 416.8 186.6 440.9 210.7zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M495.6 188.1c-36.25-36.25-99.5-36.25-135.8 0c-3.355 3.357-6.055 7.094-8.809 10.79l24.99 19.73c1.973-2.729 3.99-5.439 6.447-7.895c24.19-24.19 66.31-24.19 90.5 0c6.25 6.25 16.38 6.25 22.62 0S501.8 194.4 495.6 188.1zM544 64c17.64 0 32 14.36 32 32v280.5l32 25.26V95.1c0-35.35-28.65-64-64-64L139.6 32l40.53 32H544zM96 448c-17.64 0-32-14.36-32-32V135.4L32 110.2v305.8c0 35.35 28.65 64 64 64L500.4 480l-40.53-32H96zM153.9 206.4c-22.36 36.92-17.89 85.64 13.96 117.5c18.12 18.12 42.23 28.12 67.88 28.12c25.45 0 49.37-9.898 67.45-27.77l-25.62-20.22c-24.56 21.13-63.94 20.38-87.08-2.758C170.2 281 166.7 250.6 179.3 226.4L153.9 206.4zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "clothes-hanger": [640, 512, [], "e136", "M608.5 387.3l-267.3-168.8l32.06-21.38C400 179.2 416 149.3 416 117.2V96c0-52.94-43.06-96-96-96S224 43.06 224 96c0 8.844 7.156 16 16 16S256 104.8 256 96c0-35.28 28.72-64 64-64s64 28.72 64 64v21.19c0 21.44-10.66 41.34-28.5 53.25L30.09 387.4C11.25 399.9 0 420.1 0 444.4C0 481.7 30.31 512 67.56 512h504.9C609.7 512 640 481.7 640 444.4C640 421.1 628.2 399.8 608.5 387.3zM572.4 480H67.56C47.97 480 32 464 32 443.6c0-11.91 5.938-22.97 15.84-29.59l264.2-176.1l279.4 176.5C601.8 420.9 608 432.2 608 444.4C608 464 592 480 572.4 480z"],
    "cloud": [640, 512, [9729], "f0c2", "M464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96zM429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7V135.7z"],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M228.7 299.3C222.4 293.1 222.4 282.9 228.7 276.7C234.9 270.4 245.1 270.4 251.3 276.7L304 329.4V176C304 167.2 311.2 160 320 160C328.8 160 336 167.2 336 176V329.4L388.7 276.7C394.9 270.4 405.1 270.4 411.3 276.7C417.6 282.9 417.6 293.1 411.3 299.3L331.3 379.3C325.1 385.6 314.9 385.6 308.7 379.3L228.7 299.3zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-arrow-up": [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M308.7 164.7C314.9 158.4 325.1 158.4 331.3 164.7L411.3 244.7C417.6 250.9 417.6 261.1 411.3 267.3C405.1 273.6 394.9 273.6 388.7 267.3L336 214.6V368C336 376.8 328.8 384 320 384C311.2 384 304 376.8 304 368V214.6L251.3 267.3C245.1 273.6 234.9 273.6 228.7 267.3C222.4 261.1 222.4 250.9 228.7 244.7L308.7 164.7zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-bolt": [512, 512, [127785, "thunderstorm"], "f76c", "M415.8 112.3C411.8 67.38 373.9 32 328 32c-17.75 0-34.75 5.25-49.25 15.25c-33.6-44.05-94.5-61.9-151.1-33.58C87.9 33.56 64 75.55 64 120v.375C20.27 138.7-7.123 185.1 1.625 234.3C10.58 284.8 56.91 320 108.2 320H144C152.8 320 160 312.8 160 304C160 295.2 152.8 288 144 288H106C75 288 46.09 269.2 36.04 239.9C21.95 198.8 46.26 157.3 85.25 146.8l13.38-3.5L96.63 126C96.25 124 96 122 96 120C96 71.5 135.5 32 184 32c32.25 0 61.75 17.88 77.25 46.75l10.5 19.88l15.25-16.5c14.78-15.97 36.25-22.01 58.14-15.62c21.26 6.211 35.74 26.08 38.37 48.07c.7266 6.084 .6387 5.52-.2637 12.29l-2.5 20l23.5-2.375C405.4 144.3 406.8 144.1 408 144.1c39.75 0 72 32.25 72 72c0 38-29.75 68.88-67 71.5l-77.1 .2773C327.3 287.1 320 294.9 320 304c0 8.836 7.164 16 16 16h67.9c55.77 0 104.6-42.09 107.9-97.76C515.2 164.7 471.4 116.4 415.8 112.3zM320 352H227.3l88.78-101.5c5.844-6.656 5.156-16.75-1.5-22.56c-6.625-5.781-16.72-5.188-22.56 1.5l-112 128c-4.156 4.719-5.125 11.44-2.531 17.16S185.7 384 192 384h92.75l-88.78 101.5c-5.844 6.656-5.156 16.75 1.5 22.56C200.5 510.7 204.3 512 208 512c4.438 0 8.875-1.844 12.03-5.469l112-128c4.156-4.719 5.125-11.44 2.531-17.16S326.3 352 320 352z"],
    "cloud-bolt-moon": [576, 512, ["thunderstorm-moon"], "f76d", "M272 352H179.3l88.78-101.5c5.844-6.656 5.156-16.75-1.5-22.56c-6.625-5.812-16.75-5.188-22.56 1.5l-112 128c-4.156 4.719-5.125 11.44-2.531 17.16S137.7 384 144 384h92.75l-88.78 101.5c-5.844 6.656-5.156 16.75 1.5 22.56C152.5 510.7 156.3 512 160 512c4.438 0 8.875-1.844 12.03-5.469l112-128c4.156-4.719 5.125-11.44 2.531-17.16S278.3 352 272 352zM573.9 237.5c-3.625-7.75-11.5-12.62-19.88-12.62c-5.189 0-10.05 2.25-23.12 2.25c-54.38 0-98.63-44-98.63-98.25c0-35.13 19.12-67.88 50-85.25c8.25-4.625 12.5-13.62 11-22.88c-1.625-9.25-8.5-16.25-17.88-18C465.8 .875 455.8 0 446 0c-67.13 0-123.6 41.38-147.8 99.5c10.25 2.5 20 6.25 29 11.38C346.4 65.25 391.3 32.88 443.8 32c-27.25 24.38-43.5 59.63-43.5 96.75c0 70.75 57 128.5 127.6 130.1c-22.25 18.25-50.25 28.38-79.75 28.88c0 11-1.5 21.88-4.125 32c18.44 0 80.19-1.766 127.1-59C576.4 254.3 577.5 245.3 573.9 237.5zM351.3 197.3C345.1 158.3 312.5 128 272 128C263.4 128 255 129.4 246.8 132.3C227.1 109.4 198.6 96 168 96C111.5 96 65.25 141.3 64 197.6C26.25 210.9 0 246.9 0 288c0 46.47 33.31 85.41 77.28 94.16C87.01 384.1 96 376.3 96 366.4v-.5469c0-7.334-4.93-13.97-12.1-15.51c-26.36-5.676-47.86-26.55-51.37-54C28.18 262.3 51.05 231.5 84 225.3l.5-.0996c7.918-1.576 13.31-8.977 12.42-17C96.4 203.5 96.57 205.7 96.16 197.7C97.35 159 129.1 128 168.1 128c24.25 0 46.75 12.25 60.13 32.75l.2676 .4102C232.1 167.1 241.9 170.2 249.1 166.3c32.75-17.88 71.07 7.951 71.19 40.2l-.0508 3.258c-.1152 7.521 5.17 14.04 12.55 15.49C362.6 231.3 384.1 257.6 384.1 288c-.1094 30.99-22.34 56.96-51.67 62.78C325.1 352.2 320 358.9 320 366.4c0 9.924 8.986 17.74 18.72 15.81C382.7 373.4 416 334.5 416 288C416 246.8 389.4 210.4 351.3 197.3z"],
    "cloud-bolt-sun": [640, 512, ["thunderstorm-sun"], "f76e", "M496 352h-92.73l88.78-101.5c5.812-6.656 5.141-16.75-1.516-22.56c-6.641-5.844-16.73-5.219-22.58 1.5l-112 128c-4.125 4.719-5.125 11.44-2.516 17.16C356 380.3 361.7 384 368 384h92.73l-88.78 101.5c-5.812 6.656-5.141 16.75 1.516 22.56C376.5 510.7 380.3 512 384 512c4.453 0 8.875-1.844 12.05-5.469l112-128c4.125-4.719 5.125-11.44 2.516-17.16C507.1 355.7 502.3 352 496 352zM575.3 197.3C569.1 158.3 536.5 128 496 128c-8.625 0-17 1.375-25.25 4.25C451.1 109.4 422.6 96 392 96C335.5 96 289.3 141.3 288 197.6C250.3 210.9 224 246.9 224 288c0 46.47 33.31 85.41 77.28 94.16C311 384.1 320 376.3 320 366.4v-.5469c0-7.334-4.928-13.97-12.1-15.51c-26.36-5.674-47.86-26.55-51.37-54C252.2 262.3 275 231.5 308 225.3l.5-.0996c7.918-1.578 13.31-8.979 12.42-17c-.5215-4.684-.3516-2.469-.7598-10.41C321.4 159 353.1 128 392.1 128c24.25 0 46.75 12.25 60.13 32.75l.291 .4473c4.438 6.799 13.36 9.033 20.48 5.123l.3555-.1953c32.75-17.88 70.75 8.125 70.88 40.38l-.0508 3.258c-.1152 7.521 5.17 14.04 12.55 15.49C586.6 231.3 608.1 257.6 608.1 288c-.1094 30.99-22.34 56.96-51.67 62.78C549.1 352.2 544 358.9 544 366.4c0 9.922 8.986 17.74 18.72 15.8C606.7 373.4 640 334.5 640 288C640 246.8 613.4 210.4 575.3 197.3zM160.3 291.8c-3.5-5.375-9.875-8.125-16.38-6.875L87.88 296L99 240c1.25-6.375-1.375-12.75-6.75-16.38l-47.5-31.88L92.25 160c5.375-3.625 8-10.12 6.75-16.38l-11.12-56l56 11.12C150.4 100 156.8 97.25 160.3 91.88L192 44.38l31.75 47.5c3.625 5.375 10 8.125 16.5 6.875L319.6 83c8.625-1.75 14.25-10.12 12.62-18.75c-1.75-8.75-10.38-14.5-18.88-12.62L244.5 65.25l-39.25-58.5c-5.875-9-20.5-9-26.5 0l-39.13 58.5l-69-13.75C65.25 50.38 59.88 52.13 56.25 55.88c-3.875 3.875-5.5 9.25-4.5 14.5l13.75 69L7.125 178.5C2.75 181.5 0 186.4 0 191.8s2.75 10.38 7.125 13.38L65.5 244.3l-13.75 69c-1 5.25 .625 10.62 4.5 14.5c3.75 3.75 9 5.5 14.38 4.375L139.5 318.4l39.13 58.5C181.8 381.5 186.8 384 191.9 384c3.125 0 6.25-.875 8.875-2.75c7.375-4.875 9.375-14.88 4.5-22.12L160.3 291.8zM192 140c26.38 0 48 20 51.13 45.63C247.9 182 252.9 178.8 258.3 175.8c1.5-8.5 3.875-16.5 6.75-24.38C250.8 125.8 223.5 108 192 108c-46.25 0-83.75 37.63-83.75 83.75C108.3 238 145.8 275.6 192 275.6c.25 0 .625-.125 .875-.125c1.125-11.38 3.75-22.38 7.75-32.75C197.8 243.3 195 243.6 192.1 243.6c-28.5 0-51.75-23.25-51.75-51.75C140.3 163.3 163.5 140 192 140z"],
    "cloud-check": [640, 512, [], "e35c", "M299.3 363.3C293.1 369.6 282.9 369.6 276.7 363.3L212.7 299.3C206.4 293.1 206.4 282.9 212.7 276.7C218.9 270.4 229.1 270.4 235.3 276.7L288 329.4L404.7 212.7C410.9 206.4 421.1 206.4 427.3 212.7C433.6 218.9 433.6 229.1 427.3 235.3L299.3 363.3zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-drizzle": [512, 512, [], "f738", "M48 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S64 424.8 64 416v-40C64 367.3 56.75 360 48 360zM240 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S256 424.8 256 416v-40C256 367.3 248.8 360 240 360zM144 440c-8.75 0-16 7.25-16 16v40C128 504.8 135.3 512 144 512S160 504.8 160 496v-40C160 447.3 152.8 440 144 440zM432 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S448 424.8 448 416v-40C448 367.3 440.8 360 432 360zM336 440c-8.75 0-16 7.25-16 16v40c0 8.75 7.25 16 16 16s16-7.25 16-16v-40C352 447.3 344.8 440 336 440zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-exclamation": [640, 512, [], "e491", "M320 160C328.8 160 336 167.2 336 176V304C336 312.8 328.8 320 320 320C311.2 320 304 312.8 304 304V176C304 167.2 311.2 160 320 160zM344 384C344 397.3 333.3 408 320 408C306.7 408 296 397.3 296 384C296 370.7 306.7 360 320 360C333.3 360 344 370.7 344 384zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-fog": [640, 512, [127787, "fog"], "f74e", "M168 320h304C529.3 320 576 273.3 576 216c0-54.75-42.63-99.75-96.25-103.8C475.8 67.38 437.9 32 392 32c-17.75 0-34.75 5.25-49.25 15.25C320.3 17.75 285.5 0 248 0C181.8 0 128 53.75 128 120v.375c-38.25 16-64 53.5-64 95.63C64 273.3 110.8 320 168 320zM149.3 146.8c7.666-2.006 12.7-9.352 11.79-17.22C160.4 123.6 160 122.1 160 120C160 71.5 199.5 32 248 32c32.25 0 61.75 17.88 77.25 46.75c5.123 9.699 18.3 11.43 25.75 3.375c12.77-13.8 30.54-20.19 49.26-17.54c25.35 3.584 44.32 25.31 47.34 50.74c.6309 5.309 .5137 5.066-.3516 11.55c-1.268 10.14 7.193 19.02 17.36 17.99C470.2 144.3 469.8 144.1 472 144.1c39.75 0 72 32.25 72 72c0 39.63-32.25 72-72 72h-304c-39.75 0-72-32.38-72-72C96 183.8 117.9 155.3 149.3 146.8zM208 480h-128C71.2 480 64 487.2 64 496S71.2 512 80 512h128C216.8 512 224 504.8 224 496S216.8 480 208 480zM624 480h-320C295.2 480 288 487.2 288 496S295.2 512 304 512h320c8.801 0 16-7.199 16-16S632.8 480 624 480zM576 400C576 391.2 568.8 384 560 384h-544C7.201 384 0 391.2 0 399.1S7.201 416 16 416h544C568.8 416 576 408.8 576 400z"],
    "cloud-hail": [512, 512, [], "f739", "M56 464C42.75 464 32 474.8 32 488S42.75 512 56 512s24-10.75 24-24S69.25 464 56 464zM184 464C170.8 464 160 474.8 160 488S170.8 512 184 512s24-10.75 24-24S197.3 464 184 464zM248 368C234.8 368 224 378.8 224 392S234.8 416 248 416s24-10.75 24-24S261.3 368 248 368zM120 368C106.8 368 96 378.8 96 392S106.8 416 120 416s24-10.75 24-24S133.3 368 120 368zM376 368c-13.25 0-24 10.75-24 24S362.8 416 376 416s24-10.75 24-24S389.3 368 376 368zM312 464c-13.25 0-24 10.75-24 24S298.8 512 312 512s24-10.75 24-24S325.3 464 312 464zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M183.9 370.1c-7.625-4.375-17.38-1.875-21.75 6l-64 112c-4.375 7.625-1.75 17.5 6 21.75C106.6 511.3 109.3 512 112 512c5.5 0 10.88-2.875 13.88-8.125l64-112C194.3 384.3 191.6 374.5 183.9 370.1zM279.3 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C290.3 383.3 287.1 373.6 279.3 369.8zM216 464C202.8 464 192 474.8 192 488S202.8 512 216 512s24-10.75 24-24S229.3 464 216 464zM87.25 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C98.25 383.3 95.13 373.6 87.25 369.8zM24 464C10.75 464 0 474.8 0 488S10.75 512 24 512s24-10.75 24-24S37.25 464 24 464zM471.3 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C482.3 383.3 479.1 373.6 471.3 369.8zM375.9 370.1c-7.625-4.375-17.38-1.875-21.75 6l-64 112c-4.375 7.625-1.75 17.5 6 21.75C298.6 511.3 301.3 512 304 512c5.5 0 10.88-2.875 13.88-8.125l64-112C386.3 384.3 383.6 374.5 375.9 370.1zM408 464c-13.25 0-24 10.75-24 24S394.8 512 408 512s24-10.75 24-24S421.3 464 408 464zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-meatball": [576, 512, [], "f73b", "M80 352C53.5 352 32 373.5 32 400S53.5 448 80 448S128 426.5 128 400S106.5 352 80 352zM80 416C71.25 416 64 408.8 64 400S71.25 384 80 384S96 391.3 96 400S88.75 416 80 416zM378.5 293.5c-12.25-12.25-29.25-17.88-46.25-16.25c-21.88-26.62-66.75-26.62-88.5 0c-16.88-1.625-34 4-46.25 16.25s-18 29.25-16.25 46.25C167.9 350.8 160 366.8 160 384s7.875 33.25 21.25 44.25c-1.75 17 4 34 16.25 46.25S228 493.5 244 491.1C254.9 504.3 270.8 512 288 512s33.13-7.75 44-20.88c16.25 2.375 34.25-4.375 46.5-16.62s18-29.25 16.25-46.25C408.1 417.3 416 401.3 416 384s-7.875-33.25-21.25-44.25C396.5 322.8 390.8 305.8 378.5 293.5zM369.8 406.8l-12 6.125l4.125 12.88c3 9.5 .875 19.5-5.875 26.12c-4.875 4.875-11.38 7.625-18.38 7.625c-2 0-4.5-.75-7.875-1.75l-12.75-4l-6.25 12c-9.125 17.62-36.13 17.62-45.38 0l-6.125-12l-12.88 4c-3.125 1-5.75 1.75-7.75 1.75c-6.875 0-13.5-2.75-18.38-7.625c-6.75-6.625-9-16.62-6-26.12l4.125-12.88L206.5 406.8C197.8 402.1 192.3 393.4 192.3 384s5.5-18.12 14.25-22.75l11.88-6.125l-4.125-12.88c-3-9.5-.75-19.5 6-26.12c6.625-6.75 16.62-8.875 26.12-5.875l12.88 4l6.125-11.88c9.25-17.62 36.25-17.62 45.38 0L317 314.3l12.75-4c9.5-3 19.5-.875 26.25 5.875c6.75 6.625 8.875 16.62 5.875 26.12l-4.125 12.88l12 6.125C378.5 365.9 384 374.6 384 384S378.5 402.1 369.8 406.8zM544 216c0-54.75-42.63-99.75-96.25-103.8c-4-44.88-41.88-80.25-87.75-80.25c-17.75 0-34.75 5.253-49.25 15.25C288.3 17.75 253.5 0 216 0C149.8 0 96 53.75 96 120v.375C52.32 138.6 24.94 184.1 33.6 234.2C42.44 284.5 88.13 320 139.2 320H144C152.8 320 160 312.8 160 304C160 295.2 152.8 288 144 288H138.4C105.4 288 75.05 266.8 66.51 234.9C55.95 195.4 79.85 156.9 117.3 146.8C124.9 144.7 129.9 137.4 129 129.5c-.2441-2.102-1.178-9.225-.9043-14.3C130.6 68.93 169.1 32 216 32c32.25 0 61.75 17.88 77.25 46.75c5.125 9.701 18.3 11.43 25.75 3.375c12.77-13.8 30.54-20.19 49.26-17.54c25.35 3.586 44.32 25.32 47.34 50.74c.6309 5.307 .5137 5.064-.3516 11.55c-1.281 10.25 7.332 19.01 17.61 17.97c4.783-.4844 4.979-.6797 6.598-.7129c28.72-.5684 55.48 15.53 66.44 42.09C527.3 238 489.4 288.1 440 288.1C440 288.1 434.1 288 432 288C423.2 288 416 295.2 416 304c0 8.836 7.164 16 16 16c2.979 0 8 .125 8 .125C497.3 320 544 273.3 544 216zM496 352c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S522.5 352 496 352zM496 416c-8.75 0-16-7.25-16-16s7.25-16 16-16s16 7.25 16 16S504.8 416 496 416z"],
    "cloud-minus": [640, 512, [], "e35d", "M416 272C424.8 272 432 279.2 432 288C432 296.8 424.8 304 416 304H224C215.2 304 208 296.8 208 288C208 279.2 215.2 272 224 272H416zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-moon": [576, 512, [], "f6c3", "M351.5 313.6C347 272.3 311.9 240 269.4 240c-13.87 0-27.24 3.5-39.49 10.25C211.7 233.5 188.1 224 163.2 224c-53.74 0-97.46 42.56-99.21 96.06c-38.24 14.25-63.99 50.81-63.99 92.81C.1253 467.5 44.61 512 99.35 512h249.4c54.73 0 99.22-44.5 99.22-99.25C447.1 359 405 315.1 351.5 313.6zM348.8 480l-246.1 .0001c-36.29 0-67.88-27.72-69.59-63.97C30.64 383.1 52.54 354.5 84.48 347.4c8.746-3.671 13.15-12.1 11.1-20.5c-.125-1.125-.375-2.5-.375-3.75c0-37.13 30.12-67.25 67.23-67.25c19.99 0 38.99 9.25 51.98 25.25C220.8 288 230.9 289.1 237.7 283.5c15.27-12.38 35.36-15.27 53.99-6.324c15.92 7.649 26.03 23.85 27.98 41.41c.5401 4.873 .3968 4.374-.4299 10.37c-.4545 3.867 1.645 20.56 19.63 17.58c3.813-.632 7.667-1.152 11.53-1.064c36.4 .8253 65.69 30.75 65.69 67.23C416.1 449.8 385.9 480 348.8 480zM573.6 287.3c-4.125-8.625-12.38-14-21.88-14c-1.5 0-3 .125-4.5 .5c-7.75 1.5-15.5 2.125-23.25 2.125c-66.1 0-121.5-54.63-121.5-121.9c0-43.75 23.62-84.25 61.62-106c8.875-5.125 13.62-15 11.88-25.12s-9.375-17.88-19.5-19.75C444.1 1.125 433.2 0 421.5 0c-105.7 0-191.7 86.13-191.7 192c0 6.5 .375 12.75 1 19.25c1.957 .4414 3.75 1.242 5.664 1.781C244.1 210.4 253.9 209 262.9 208.5C262.2 203.1 261.7 197.7 261.7 192.1c0-88.25 71.62-160 159.7-160c3 0 5.875 .125 8.875 .125c-37.37 29-59.87 74-59.87 122c0 84.75 68.87 153.8 153.5 153.8c2.625 0 5.25-.125 7.75-.25c-19.63 18.88-43.79 31.62-69.84 38.43c5.447 9.289 9.502 19.41 12.54 30c37.33-10.69 70.89-32.35 96.05-63.43C576.5 305.6 577.7 295.8 573.6 287.3z"],
    "cloud-moon-rain": [576, 512, [], "f73c", "M266.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C216.3 511.3 219 512 221.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C276.6 432.3 273.9 422.5 266.3 418.1zM170.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C120.3 511.3 123 512 125.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C180.6 432.3 177.9 422.5 170.3 418.1zM74.25 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C24.25 511.3 27 512 29.75 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C84.63 432.3 81.88 422.5 74.25 418.1zM351.3 197.3C346 158.3 312.5 128 272 128c-8.625 0-17 1.375-25.25 4.25C227.1 109.3 198.6 96 168 96c-56.5 0-102.8 45.25-104 101.6C26.25 210.9 .0001 246.9 .0001 288c0 52.88 43.13 96 96 96h224c52.88 0 96-43.13 96-96c0-1.25-.25-2.625-.25-4C414 244.4 388.3 210 351.3 197.3zM320 352H98.29c-32.58 0-61.63-23.38-65.76-55.7C28.18 262.3 51.05 231.5 84 225.3L84.48 225.2C92.42 223.6 97.81 216.1 96.9 208.1C95.94 199.7 96.17 201.8 96.12 198.9C95.71 176.8 105.3 155.2 123.5 142.6c38.05-26.42 83.21-14.79 104.7 18.2l.2676 .4111c4.432 6.818 13.37 9.067 20.5 5.159l.3564-.1953c32.75-17.88 70.75 8.125 70.88 40.38l-.0503 3.258c-.1157 7.521 5.17 14.04 12.55 15.49C362.6 231.3 384.1 257.6 384.1 288C384 323.3 355.3 352 320 352zM362.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C312.3 511.3 315 512 317.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C372.6 432.3 369.9 422.5 362.3 418.1zM573.9 237.5c-3.625-7.75-11.5-12.62-19.88-12.62c-5.19 0-10.05 2.25-23.12 2.25c-54.38 0-98.63-44-98.63-98.25c0-35.13 19.13-67.88 50-85.25C490.5 39 494.8 30 493.3 20.75c-1.625-9.25-8.5-16.25-17.88-18C465.8 .875 455.8 0 446 0c-67.13 0-123.6 41.38-147.8 99.5c10.25 2.5 20 6.25 29 11.38C346.4 65.25 391.3 32.88 443.8 32c-27.25 24.38-43.5 59.63-43.5 96.75c0 70.75 57 128.5 127.6 130.1c-22.25 18.25-50.25 28.38-79.75 28.88c0 11-1.5 21.88-4.125 32c18.44 0 80.19-1.766 127.1-59C576.4 254.3 577.5 245.3 573.9 237.5z"],
    "cloud-music": [640, 512, [], "f8ae", "M372.8 177.1C393.7 169.3 416 184.7 416 207.1V319.1C416 346.5 390.9 368 360 368C329.1 368 304 346.5 304 320C304 293.5 329.1 272 360 272C368.6 272 376.7 273.7 384 276.6V207.1L288 243.1V352C288 378.5 262.9 400 232 400C201.1 400 176 378.5 176 352C176 325.5 201.1 304 232 304C240.6 304 248.7 305.7 256 308.6V243.1C256 229.7 264.3 217.8 276.8 213.1L372.8 177.1zM360 304C351.9 304 345.3 306.8 341.2 310.4C337.2 313.8 336 317.3 336 320C336 322.7 337.2 326.2 341.2 329.6C345.3 333.2 351.9 336 360 336C368.1 336 374.7 333.2 378.8 329.6C382.8 326.2 384 322.7 384 319.1C384 317.3 382.8 313.8 378.8 310.4C374.7 306.8 368.1 303.1 360 303.1V304zM232 336C223.9 336 217.3 338.8 213.2 342.4C209.2 345.8 208 349.3 208 352C208 354.7 209.2 358.2 213.2 361.6C217.3 365.2 223.9 368 232 368C240.1 368 246.7 365.2 250.8 361.6C254.8 358.2 256 354.7 256 352C256 349.3 254.8 345.8 250.8 342.4C246.7 338.8 240.1 336 232 336V336zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-plus": [640, 512, [], "e35e", "M304 384V304H224C215.2 304 208 296.8 208 288C208 279.2 215.2 272 224 272H304V192C304 183.2 311.2 176 320 176C328.8 176 336 183.2 336 192V272H416C424.8 272 432 279.2 432 288C432 296.8 424.8 304 416 304H336V384C336 392.8 328.8 400 320 400C311.2 400 304 392.8 304 384zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-question": [640, 512, [], "e492", "M232.7 201.8C239.2 177.2 261.4 160 286.9 160H344C379.5 160 408 189 408 224.3C408 248.3 394.6 270.5 373.1 281.4L336 300.3V320C336 328.8 328.8 336 320 336C311.2 336 304 328.8 304 320V290.5C304 284.5 307.4 279 312.7 276.3L358.5 252.9C369.2 247.5 376 236.3 376 224.3C376 206.5 361.6 192 344 192H286.9C275.1 192 266.4 199.4 263.7 209.9L263.5 210.6C261.2 219.1 252.5 224.3 243.9 222C235.4 219.8 230.3 211 232.5 202.5L232.7 201.8zM344 384C344 397.3 333.3 408 320 408C306.7 408 296 397.3 296 384C296 370.7 306.7 360 320 360C333.3 360 344 370.7 344 384zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288zM242.8 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C197.3 485.7 223.7 512 256 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C263.2 350.3 248.8 350.3 242.8 358.9zM256 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C282.7 468 270.7 480 256 480zM82.84 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C37.34 485.7 63.66 512 96 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C103.2 350.3 88.78 350.3 82.84 358.9zM96 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C122.7 468 110.7 480 96 480zM402.8 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C357.3 485.7 383.7 512 416 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C423.2 350.3 408.8 350.3 402.8 358.9zM416 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C442.7 468 430.7 480 416 480z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M414.7 304.2C407.2 258.8 367.6 224 320 224c-18.97 0-37.09 5.469-52.59 15.69C246.7 210.2 212.6 192 176 192C114.3 192 64 242.3 64 304c0 2.719 .0938 5.438 .3125 8.188C25.84 328.1 0 365.7 0 408C0 465.3 46.66 512 104 512h304c57.34 0 104-46.66 104-104C512 352.9 468.9 307.7 414.7 304.2zM408 480h-304C64.31 480 32 447.7 32 408c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 314.8 96 309.5 96 304C96 259.9 131.9 224 176 224c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 262.8 302.8 256 320 256c35.28 0 63.94 28.82 63.94 64.11C383.9 328.9 391.2 336 400 336h8c39.69 0 72 32.31 72 72S447.7 480 408 480zM256 172c4.5 0 9-1.906 12.16-5.594C341.3 81 447.6 32 560 32C568.8 32 576 24.98 576 16.13S568.8 0 560 0c-121.7 0-236.1 53.09-316.2 145.6C238.1 152.3 238.9 162.4 245.6 168.2C248.6 170.8 252.3 172 256 172zM560 96c-80.38 0-157.2 29.91-216.3 84.22c-6.531 5.969-6.938 16.09-.9687 22.59C345.9 206.3 350.2 208 354.5 208c3.875 0 7.75-1.406 10.81-4.219C418.5 154.9 487.7 128 560 128C568.8 128 576 120.8 576 112S568.8 96 560 96zM560 192c-42.91 0-84.59 12.19-120.6 35.22c-7.438 4.75-9.625 14.66-4.844 22.09C437.6 254.1 442.8 256.7 448 256.7c2.969 0 5.938-.8125 8.625-2.531C487.5 234.4 523.2 224 560 224C568.8 224 576 216.8 576 208S568.8 192 560 192z"],
    "cloud-showers": [512, 512, [], "f73f", "M112 368C103.3 368 96 375.3 96 384v80C96 472.8 103.3 480 112 480S128 472.8 128 464V384C128 375.3 120.8 368 112 368zM304 368c-8.75 0-16 7.25-16 16v80c0 8.75 7.25 16 16 16s16-7.25 16-16V384C320 375.3 312.8 368 304 368zM208 400C199.3 400 192 407.3 192 416v80C192 504.8 199.3 512 208 512S224 504.8 224 496V416C224 407.3 216.8 400 208 400zM400 400c-8.75 0-16 7.25-16 16v80c0 8.75 7.25 16 16 16s16-7.25 16-16V416C416 407.3 408.8 400 400 400zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0902 5.438 .309 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288zM439.2 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C363.1 511.5 365.6 512 367.1 512c5.875 0 11.51-3.25 14.32-8.844l64-128C450.3 367.3 447.1 357.7 439.2 353.7zM321.8 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C245.8 511.5 248.3 512 250.7 512c5.875 0 11.52-3.25 14.33-8.844l64-128C332.9 367.3 329.7 357.7 321.8 353.7zM204.5 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C128.5 511.5 130.9 512 133.3 512c5.875 0 11.52-3.25 14.33-8.844l64-128C215.6 367.3 212.4 357.7 204.5 353.7zM87.16 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C11.14 511.5 13.58 512 15.98 512c5.875 0 11.52-3.25 14.33-8.844l64-128C98.27 367.3 95.06 357.7 87.16 353.7z"],
    "cloud-showers-water": [576, 512, [], "e4e4", "M328.7 38.37C338.3 34.27 348.9 32 360 32C393.7 32 422.5 52.82 434.3 82.28H441.1C480.3 82.28 512 114 512 153.1C512 192.3 480.3 223.1 441.1 223.1H134.9C95.72 223.1 63.1 192.3 63.1 153.1C63.1 114 95.72 82.28 134.9 82.28H146.3C156.3 35.27 198 0 247.1 0C280.6 0 309.6 14.98 328.7 38.37V38.37zM160.2 114.3H134.9C113.4 114.3 95.1 131.7 95.1 153.1C95.1 174.6 113.4 191.1 134.9 191.1H441.1C462.6 191.1 480 174.6 480 153.1C480 131.7 462.6 114.3 441.1 114.3H422.5C415 114.3 408.5 109 406.9 101.7C402.2 80.14 382.1 64 360 64C349.9 64 340.6 67.11 332.8 72.41C329.2 74.92 324.7 75.81 320.3 74.86C316 73.9 312.3 71.2 310 67.38C297.4 46.17 274.4 32 247.1 32C209.8 32 178.6 61.74 176.1 99.31C175.6 107.7 168.6 114.3 160.2 114.3H160.2zM77.31 376.9C72.41 384.2 62.48 386.2 55.12 381.3C47.77 376.4 45.79 366.5 50.69 359.1L114.7 263.1C119.6 255.8 129.5 253.8 136.9 258.7C144.2 263.6 146.2 273.5 141.3 280.9L77.31 376.9zM250.1 458.8C259.9 452.1 268.2 444.8 276.1 436.9C282.6 430.4 293.3 430.4 299.8 436.9C307.8 444.8 315.1 452.1 325.8 458.8C342.3 470 363.1 479.1 383.1 479.1C404.9 479.1 425.6 470 442.2 458.8C451.9 452.1 460.2 444.8 468.1 436.9C474.6 430.4 485.3 430.4 491.8 436.9C499.8 444.8 507.1 452.1 517.8 458.8C530.6 467.5 545.9 475.4 561.9 478.6C569.6 480.1 576 486.4 576 494.2C576 504 567.1 512.1 558.3 510.4C535.2 506.5 514.7 495.4 499.8 485.2C491.8 479.8 485.1 474.4 479.1 469.1C474.8 474.4 468.1 479.8 460.2 485.2C441.5 497.9 414.3 511.1 383.1 511.1C353.7 511.1 326.4 497.9 307.8 485.2C299.8 479.8 293.1 474.4 287.1 469.1C282.8 474.4 276.1 479.8 268.2 485.2C249.5 497.9 222.3 511.1 191.1 511.1C161.7 511.1 134.4 497.9 115.8 485.2C107.8 479.8 101.1 474.4 95.96 469.1C90.82 474.4 84.12 479.8 76.19 485.2C61.25 495.4 40.81 506.5 17.69 510.4C8.015 512.1 0 504 0 494.2C0 486.4 6.421 480.1 14.13 478.6C30.07 475.4 45.38 467.5 58.16 458.8C67.94 452.1 76.16 444.8 84.07 436.9C90.64 430.4 101.3 430.4 107.8 436.9C115.8 444.8 124.1 452.2 133.8 458.8C150.3 470 171.1 479.1 191.1 479.1C212.9 479.1 233.6 470 250.1 458.8H250.1zM472.9 258.7C480.2 263.6 482.2 273.5 477.3 280.9L413.3 376.9C408.4 384.2 398.5 386.2 391.1 381.3C383.8 376.4 381.8 366.5 386.7 359.1L450.7 263.1C455.6 255.8 465.5 253.8 472.9 258.7zM189.3 376.9C184.4 384.2 174.5 386.2 167.1 381.3C159.8 376.4 157.8 366.5 162.7 359.1L226.7 263.1C231.6 255.8 241.5 253.8 248.9 258.7C256.2 263.6 258.2 273.5 253.3 280.9L189.3 376.9zM360.9 258.7C368.2 263.6 370.2 273.5 365.3 280.9L301.3 376.9C296.4 384.2 286.5 386.2 279.1 381.3C271.8 376.4 269.8 366.5 274.7 359.1L338.7 263.1C343.6 255.8 353.5 253.8 360.9 258.7z"],
    "cloud-slash": [640, 512, [], "e137", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.087 28.56C-.849 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.92 3.443L633.9 483.4zM640 352C640 374.6 634.1 395.9 623.8 414.3L598.3 394.2C604.5 381.4 608 367.1 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64C246.8 64 223.2 70.45 202.6 81.79L175.8 60.61C203.4 42.52 236.5 32 272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352V352zM101.3 164.9L129.5 187.1C128.8 191.9 128.4 196.7 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H459.9L500.4 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C96.71 188 98.46 176.2 101.3 164.9V164.9z"],
    "cloud-sleet": [576, 512, [], "f741", "M544 216c0-55.09-43.06-100.3-97.31-103.8C439.2 66.75 399.6 32 352 32c-18.97 0-37.09 5.469-52.59 15.69C278.7 18.22 244.6 0 208 0C146.3 0 96 50.25 96 112c0 2.719 .0902 5.438 .309 8.188C57.84 136.1 32 173.7 32 216C32 273.3 78.66 320 136 320h304C497.3 320 544 273.3 544 216zM64 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C128.6 122.8 128 117.5 128 112C128 67.88 163.9 32 208 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C318.6 70.81 334.8 64 352 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C479.7 144 512 176.3 512 216S479.7 288 440 288h-304C96.31 288 64 255.7 64 216zM119.2 353.7c-7.906-3.938-17.47-.7187-21.47 7.156l-64 128c-3.938 7.906-.75 17.5 7.156 21.47C43.16 511.5 45.59 512 48 512c5.844 0 11.5-3.25 14.31-8.844l64-128C130.3 367.3 127.1 357.7 119.2 353.7zM375.2 353.7c-7.875-3.938-17.5-.7187-21.47 7.156l-64 128c-3.938 7.906-.75 17.5 7.156 21.47C299.2 511.5 301.6 512 304 512c5.844 0 11.5-3.25 14.31-8.844l64-128C386.3 367.3 383.1 357.7 375.2 353.7zM519.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L480 388.3V368c0-8.844-7.156-16-16-16S448 359.2 448 368v20.3l-17.56-10.14C422.8 373.8 413 376.3 408.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L432 416l-17.59 10.16C406.8 430.6 404.2 440.3 408.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L448 443.7V464c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L495.1 416l17.59-10.16C521.2 401.4 523.8 391.7 519.4 384zM263.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L224 388.3V368C224 359.2 216.8 352 208 352S192 359.2 192 368v20.3l-17.56-10.14C166.8 373.8 157 376.3 152.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L176 416l-17.59 10.16C150.8 430.6 148.2 440.3 152.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L192 443.7V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-20.3l17.56 10.14C244.1 455.3 246.8 456 249.6 456c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L239.1 416l17.59-10.16C265.2 401.4 267.8 391.7 263.4 384z"],
    "cloud-snow": [512, 512, [127784], "f742", "M104 320h304C465.3 320 512 273.3 512 216c0-55.09-43.06-100.3-97.31-103.8C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320zM85.97 146.6c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288h-304C64.31 288 32 255.7 32 216C32 183.4 54.19 154.9 85.97 146.6zM503.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L464 388.3V368c0-8.844-7.156-16-16-16s-16 7.156-16 16v20.3l-17.56-10.14C406.8 373.8 397 376.3 392.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L416 416l-17.59 10.16C390.8 430.6 388.2 440.3 392.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L432 443.7V464c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L479.1 416l17.59-10.16C505.2 401.4 507.8 391.7 503.4 384zM119.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L80 388.3V368C80 359.2 72.84 352 64 352s-16 7.156-16 16v20.3l-17.56-10.14C22.81 373.8 13 376.3 8.594 384c-4.438 7.656-1.812 17.44 5.844 21.84L32.03 416l-17.59 10.16C6.781 430.6 4.156 440.3 8.594 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L48 443.7V464C48 472.8 55.16 480 64 480s16-7.156 16-16v-20.3l17.56 10.14C100.1 455.3 102.8 456 105.6 456c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L95.97 416l17.59-10.16C121.2 401.4 123.8 391.7 119.4 384zM312.1 416c-4.406-7.688-14.22-10.28-21.84-5.844l-17.56 10.14V400c0-8.844-7.156-16-16-16s-16 7.156-16 16v20.3L224 410.2C216.4 405.8 206.6 408.3 202.2 416c-4.438 7.656-1.812 17.44 5.844 21.84L225.6 448L208 458.2C200.3 462.6 197.7 472.3 202.2 480c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156l17.56-10.14V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L289.5 448l17.59-10.16C314.8 433.4 317.4 423.7 312.1 416z"],
    "cloud-sun": [640, 512, [9925], "f6c4", "M93.5 322.9L92.63 323l12.5-63.25C106.3 253.5 103.8 247 98.25 243.4l-53.5-35.75l53.5-35.88c5.5-3.5 8-10 6.875-16.38l-12.5-63.25l63.13 12.5c6.5 1.25 12.88-1.5 16.5-6.875L208 44.25l35.75 53.5c3.625 5.375 10 8.125 16.5 6.875l63.13-12.5L313.1 139.6c-1.715 8.658 3.906 17.07 12.56 18.79c8.674 1.729 17.1-3.91 18.81-12.59l14.02-71.03c1-5.125-.625-10.5-4.375-14.38C351.3 56.63 345.8 54.88 340.6 56L264.4 71.13L221.3 6.75c-6-9-20.5-9-26.5 0L151.5 71.25L75.38 56.13C70.13 55 64.75 56.75 61 60.5S55.63 69.75 56.63 74.88l15.12 76.25L7.125 194.3C2.75 197.3 0 202.3 0 207.5s2.75 10.25 7.125 13.25L71.63 264L56.5 340.3c-1 5.125 .625 10.5 4.375 14.38c3 3 7.125 4.625 11.38 4.625c1 0 2 0 3-.25l23.71-4.516C106.5 353 112 346.4 112 338.7C112 328.9 103.2 321.4 93.5 322.9zM543.8 304.3C539.8 259.4 501.1 224 456 224c-17.75 0-34.75 5.25-49.25 15.25C384.3 209.8 349.5 192 312 192C245.8 192 192 245.8 192 312v.375c-38.25 16-64 53.5-64 95.63C128 465.3 174.8 512 232 512h304c57.25 0 104-46.75 104-104C640 353.3 597.4 308.3 543.8 304.3zM536 480H234.4c-33.02 0-63.32-21.22-71.86-53.12c-10.56-39.45 13.34-78 50.74-88.13c7.666-2.006 12.7-9.352 11.78-17.22C224.4 315.6 224 314.1 224 312C224 263.5 263.5 224 312 224c32.25 0 61.75 17.88 77.25 46.75c5.125 9.701 18.3 11.43 25.75 3.375c12.65-13.83 30.66-20.21 49.36-17.52c26.78 3.848 46.38 27.58 47.62 54.6c.0938 2-.1504 3.324-.7305 7.672c-1.268 10.14 7.193 19.02 17.36 17.99c5.629-.5684 5.209-.7422 7.391-.7422c39.75 0 72 32.25 72 72C608 447.8 575.8 480 536 480zM163 284.8c2-11 5.25-21.62 9.625-31.88C159 242.3 150.3 226 150.3 207.5c0-31.75 25.88-57.75 57.75-57.75c18.5 0 34.75 8.875 45.38 22.38C263.6 167.8 274.3 164.5 285.3 162.5C269.8 135.9 241.1 117.8 208 117.8c-49.5 0-89.75 40.25-89.75 89.75C118.3 240.5 136.3 269.3 163 284.8z"],
    "cloud-sun-rain": [640, 512, [127782], "f743", "M306.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.814C237.7 502 242.4 512 253.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C305.7 437.4 306.3 434.7 306.3 432.1zM140.4 191.6C140.4 163.1 163.6 140 192 140c26.38 0 48 20 51.12 45.62C247.9 182 252.9 178.8 258.2 175.8C259.8 167.2 262.1 159.2 265 151.4C250.8 125.8 223.5 108 192 108c-46.25 0-83.75 37.62-83.75 83.75C108.2 238 145.8 275.6 192 275.6c.25 0 .625-.125 .875-.125c1.125-11.38 3.75-22.38 7.75-32.75C197.8 243.2 195 243.6 192.1 243.6C164 243.6 140.4 220.9 140.4 191.6zM160.2 291.8C157.3 287.2 152.3 284.6 146.1 284.6c-1.027 0-2.068 .0976-3.112 .2984L87.88 296L99 240c.2066-1.053 .3073-2.107 .3073-3.148c0-5.259-2.571-10.2-7.057-13.23L44.75 191.8L92.25 160c4.487-3.026 7.057-8.055 7.057-13.27c0-1.032-.1007-2.072-.3073-3.105L87.88 87.62l56 11.13c1.044 .2009 2.086 .2984 3.112 .2984c5.362 0 10.33-2.662 13.26-7.173L192 44.38l31.75 47.5c3.043 4.511 8.022 7.173 13.39 7.173c1.027 0 2.068-.0976 3.113-.2984L319.6 83c7.624-1.547 12.9-8.271 12.9-15.77c0-9.437-7.995-15.96-15.9-15.96c-1.077 0-2.166 .1151-3.253 .3549L244.5 65.25L205.2 6.75C202.3 2.25 197.2 0 192 0S181.8 2.25 178.8 6.75L139.6 65.25L70.62 51.5c-1.085-.2271-2.17-.337-3.24-.337c-4.233 0-8.241 1.719-11.13 4.712C53.12 59 51.46 63.1 51.46 67.33c0 1.012 .0952 2.03 .2884 3.044l13.75 69L7.125 178.5C2.75 181.5 0 186.4 0 191.8c0 5.375 2.75 10.37 7.125 13.37L65.5 244.2L51.75 313.2C51.56 314.3 51.46 315.3 51.46 316.3c0 8.95 7.405 16.17 15.94 16.17c1.063 0 2.143-.1099 3.228-.337l68.88-13.75l39.12 58.5C181.8 381.5 186.8 384 191.9 384c3.125 0 6.25-.875 8.875-2.75c4.65-3.074 7.164-8.186 7.164-13.36c0-3.032-.8627-6.086-2.664-8.764L160.2 291.8zM498.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.815C429.7 502 434.4 512 445.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C497.7 437.4 498.3 434.7 498.3 432.1zM575.3 197.2C569.1 158.2 536.5 128 496 128c-8.625 0-17 1.375-25.25 4.25C451.1 109.4 422.6 96 392 96C335.5 96 289.2 141.2 288 197.6C250.2 210.9 224 246.9 224 288c0 52.88 43.13 96 96 96h224c52.88 0 96-43.13 96-96C640 246.8 613.4 210.4 575.3 197.2zM544 352l-221.7 .0001c-11.82 0-66.29-9.652-66.29-64c0-30.62 21.75-56.1 51.1-62.75l.4991-.099c7.344-1.456 12.52-7.902 12.52-15.23c0-2.294-.2823-.9048-.8597-12.18C321.4 159 353.1 128 392.1 128c24.25 0 46.75 12.25 60.12 32.75l.2673 .4112c2.963 4.558 7.939 7.074 13.04 7.074c2.531 0 5.094-.6189 7.459-1.915l.3563-.1953c7.385-4.031 15.04-5.831 22.46-5.831c25.5 0 48.32 21.23 48.41 46.21c0 0-.052 3.42-.052 3.501c0 7.418 5.251 13.82 12.55 15.25C586.6 231.2 608.1 257.6 608.1 288C608 323.2 579.3 352 544 352zM594.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.63 64c-1.416 2.467-2.085 5.157-2.085 7.815C525.7 502 530.4 512 541.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C593.7 437.4 594.3 434.7 594.3 432.1zM402.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.815C333.7 502 338.4 512 349.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C401.7 437.4 402.3 434.7 402.3 432.1z"],
    "cloud-word": [640, 512, [], "e138", "M496 384H304C295.2 384 288 376.8 288 368C288 359.2 295.2 352 304 352H496C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384zM240 352C248.8 352 256 359.2 256 368C256 376.8 248.8 384 240 384H144C135.2 384 128 376.8 128 368C128 359.2 135.2 352 144 352H240zM128 304C128 295.2 135.2 288 144 288H336C344.8 288 352 295.2 352 304C352 312.8 344.8 320 336 320H144C135.2 320 128 312.8 128 304zM496 288C504.8 288 512 295.2 512 304C512 312.8 504.8 320 496 320H400C391.2 320 384 312.8 384 304C384 295.2 391.2 288 400 288H496zM464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96zM429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7V135.7z"],
    "cloud-xmark": [640, 512, [], "e35f", "M244.7 212.7C250.9 206.4 261.1 206.4 267.3 212.7L320 265.4L372.7 212.7C378.9 206.4 389.1 206.4 395.3 212.7C401.6 218.9 401.6 229.1 395.3 235.3L342.6 288L395.3 340.7C401.6 346.9 401.6 357.1 395.3 363.3C389.1 369.6 378.9 369.6 372.7 363.3L320 310.6L267.3 363.3C261.1 369.6 250.9 369.6 244.7 363.3C238.4 357.1 238.4 346.9 244.7 340.7L297.4 288L244.7 235.3C238.4 229.1 238.4 218.9 244.7 212.7zM272 32C331.5 32 384.1 61.55 416 106.8C430.5 99.87 446.8 96 464 96C525.9 96 576 146.1 576 208C576 218.7 574.5 228.1 571.7 238.8C612.3 260.2 640 302.9 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.15 219.9 96.17 200.1C100.3 106.6 177.4 32 272 32zM272 64C194.6 64 131.5 125 128.1 201.5C127.6 214.6 119.1 225.1 106.8 230.3C63.18 245.7 32 287.2 32 336C32 397.9 82.14 448 144 448H512C565 448 608 405 608 352C608 315.2 587.3 283.2 556.8 267.1C543.4 259.1 536.8 244.5 540.9 229.1C542.9 223 544 215.7 544 208C544 163.8 508.2 128 464 128C451.7 128 440.1 130.8 429.7 135.7C415.7 142.4 398.8 137.9 389.8 125.2C363.7 88.12 320.7 64 272 64V64z"],
    "clouds": [640, 512, [], "f744", "M543.7 304.4C539.8 259.4 501.1 224 456 224c-17.92 0-34.85 5.273-49.22 15.12C384.2 209.6 349.3 192 311.9 192C245.7 192 192 245.1 192 312.2c0 .1016-.002-.0977 0 0C153.6 328.2 128 365.9 128 408c0 57.35 46.65 104 104 104h303.1c57.35 0 104-46.6 104-103.9C640 353.4 597.5 308.3 543.7 304.4zM536 480H234.9c-33.32 0-64.09-21.36-72.5-53.6c-10.24-39.28 13.62-77.56 50.87-87.65c7.695-2.014 12.69-9.41 11.77-17.31c-.8887-7.646-1.211-6.404-.918-13.17c1.34-30.84 18.11-59.68 45.58-73.76c46.55-23.87 97.39-5.072 119.6 36.24c8.369 15.84 21.93 7.512 24.6 4.621c9.115-9.861 21.16-16.89 34.46-18.77c38.57-5.449 67.2 28.68 62.7 64.32l-.084 .668c-1.117 8.852 6.303 16.44 15.18 15.51c40.06-4.172 77.84 24.05 81.58 64.16C611.7 443.1 578 480 536 480zM168 272c0-8.837-7.163-16-16-16H97.22C65.61 256 36.87 233.7 32.59 202.4C27.96 168.5 50.92 138.2 83.75 132.8c7.088-1.182 12.51-6.955 13.25-14.1C101.1 69.27 142.8 32 192 32c39.5 0 75.5 25 89.63 62.25c3.232 8.621 13.11 12.79 21.5 9c11.03-4.934 22.47-7.439 34.18-7.239c20.63 .3545 39.9 10.86 53.92 25.1C409.9 142.2 415.9 159.9 415.9 176c0 8.837 7.312 16 16.15 16c8.837 0 16-7.163 16-16c0-61.75-50.25-112-112-112c-10.5 0-20.88 1.5-31 4.5C283 27 239.4 0 192 0C130.3 0 78.25 43.88 66.88 103.8C24.08 116.7-4.692 158.2 .6339 204.8C6.132 252.9 49.28 288 97.71 288h54.29C160.8 288 168 280.8 168 272z"],
    "clouds-moon": [640, 512, [], "f745", "M446.5 321.2c-6.99-37.04-39.49-65.16-78.53-65.16c-12.03 0-23.75 2.701-34.42 7.88C315.7 239.2 286.8 224 255.9 224c-52.95 0-96.02 43.08-96.02 96.04c0 1.809 .0645 3.641 .1934 5.508c-37.93 13.16-64.21 49.07-64.21 90.42C95.9 468.9 138.1 512 191.9 512h240.1c52.88 0 95.95-43.07 95.95-95.96C527.1 368.1 492.5 328.2 446.5 321.2zM432 480H194.2c-32.89 0-62.1-23.84-65.87-56.51c-3.941-34.19 19.38-64.5 52.33-70.31c8.951-1.629 14.92-10.37 13.01-19.26c-1.125-5.004-1.752-9.629-1.752-13.88C191.9 284.6 220.7 256 255.9 256c24.63 0 47.27 14.51 57.77 37.02c4.322 9.344 16.27 12.15 24.29 5.699c12.89-10.31 29.38-13.37 44.93-8.248c20.1 6.619 32.94 26.38 32.94 47.54c0 7.596 6.158 14.04 13.75 14.04c32.17 0 61.02 22.75 65.59 54.58C500.9 446.1 470.4 480 432 480zM95.1 320c-36.73 0-66.4-31.21-63.85-68.47C34.48 217.6 64.28 192 98.31 192h15.45c7.547 0 14.04-5.344 15.49-12.75C135.2 149.5 161.7 128 191.1 128c30.25 0 56.76 21.5 62.76 51.25C256.2 186.7 262.7 192 270.2 192H288c24.61 0 45.8 14.16 56.5 34.61c7.619-1.641 15.47-2.604 23.43-2.604c3.559 0 6.931 .4824 10.42 .8105C365.3 187.3 329.9 160 288 160H282.5c-13.25-37.75-49.5-64-90.49-64c-40.1 0-77.26 26.25-90.51 64H98.87c-50.79 0-94.94 38.26-98.61 88.92c-3.715 51.21 33.24 94.44 81.69 101.7C88.79 339.1 97.57 328.9 107.7 320H95.1zM636.6 248.1c-5.094-8.406-14.5-12.69-24.2-10.75c-31 5.812-62.52-2.281-86.56-22.25c-23.78-19.72-37.42-48.63-37.42-79.38c0-37.13 20.2-71.59 52.61-89.88c8.672-4.781 13.23-14.19 11.61-23.97c-1.625-9.812-9-17.25-18.56-18.97C524.1 .9687 513.7 0 503.1 0c-82.51 0-151.2 58.92-166.1 137.9c10.75 4.516 20.81 10.49 29.92 17.72C373.7 85.86 433.8 31.35 505.1 32c-30.45 25.5-48.63 63.41-48.63 103.7c0 40.28 17.86 78.22 49 104c24.98 20.69 55.66 32 88.2 31.44c-20.97 18.28-46.95 29.75-75.05 32.91l-21.61 2.352c12.4 7.453 23.36 16.88 32.58 27.89c41.26-6.492 78.48-27.14 105.1-59.71C640.1 266.9 641.7 256.5 636.6 248.1z"],
    "clouds-sun": [640, 512, [], "f746", "M138.3 314.2l-45.7 9.05L105.1 260c1.125-6.25-1.375-12.75-6.875-16.5l-53.5-35.75l53.5-35.88c5.5-3.625 8-10.12 6.875-16.5l-12.5-63.13l63.13 12.5c6.5 1.25 12.88-1.5 16.5-6.875L208 44.38L243.8 98c3.625 5.25 10 8.125 16.5 6.75l63.13-12.5L316.1 128.9c-2.22 11.21 8.23 20.79 19.21 17.61c5.348-1.551 9.426-5.895 10.64-11.33L359.4 75c1-5.25-.625-10.62-4.375-14.38c-3.75-3.875-9-5.5-14.38-4.375l-76.25 15l-43.13-64.5c-6-9-20.5-9-26.5 0L151.5 71.25L75.25 56.13C69.1 55 64.75 56.75 60.88 60.5C57.13 64.25 55.5 69.75 56.5 74.88l15.12 76.38l-64.5 43.13C2.75 197.4 0 202.4 0 207.8C0 213 2.75 218 7.125 221l64.5 43.25L56.5 340.4c-1 5.375 .625 10.75 4.375 14.38c3.875 3.75 9.25 5.5 14.38 4.5l69.24-12.46c8.692-1.564 14.63-9.665 13.51-18.43C156.8 318.8 147.8 312.3 138.3 314.2zM208 149.8c28.75 0 52.5 21.25 56.88 48.88c2.375-.875 4.875-1.875 7.375-2.375c5-9 11.12-17.12 18-24.5C276.3 140 244.8 117.8 208 117.8c-49.5 0-89.75 40.38-89.75 90c0 39.5 25.62 72.63 61 84.75c.0685-.3065 3.758-16.02 10.62-30.12c-23-7.625-39.75-29.12-39.75-54.63C150.3 175.8 176.1 149.8 208 149.8zM550.4 164.8h-.5c-16.62-40.63-55.25-69.13-99.38-69.13c-46.38 0-86.25 30.12-101.5 74.13c-13.47 4.734-25.26 12.88-34.94 23.21c14.01 1.117 27.62 4.273 40.35 9.789c2.13-1.027 4.307-1.964 6.538-2.772c8.45-3.06 14.97-9.89 17.85-18.41c10.6-31.45 38.53-53.95 71.58-53.95c31.98 0 59.02 20.86 70.37 50.54c4.546 11.89 16.65 18.66 29.37 18.59c.0861-.0005-.0862 0 0 0c31.88 0 57.75 27.5 57.75 61.5c.1094 29.77-19.62 54.55-45.93 60.26c8.922 7.551 16.84 16.14 23.44 25.78C617.4 330.1 640 296.9 640 258.3C640 206.8 599.8 164.8 550.4 164.8zM494.6 321.2c-6.99-37.04-39.58-65.14-78.61-65.14c-12.02 0-23.64 2.684-34.31 7.863C363.8 239.2 335 224 304.1 224c-52.93 0-95.1 43.08-95.1 96.04c0 1.809 .0645 3.645 .1934 5.512c-37.91 13.16-64.19 49.07-64.19 90.42C144.1 468.9 187.2 512 240.1 512h239.1C532.1 512 576 468.1 576 416.1C576 368.1 540.6 328.2 494.6 321.2zM480.1 480l-237.7 .0001c-32.89 0-62.1-23.84-65.86-56.51c-3.941-34.19 19.37-64.5 52.31-70.31c11.08-2.018 15.14-9.321 13.52-16.86c-1.15-5.342-2.267-10.24-2.267-16.29C240.1 284.6 268.9 256 304.1 256c24.62 0 47.25 14.51 57.75 37.02c5.332 11.53 14.39 13.65 24.37 5.629c12.89-10.32 29.3-13.3 44.84-8.172c20.08 6.627 32.91 26.39 32.91 47.54c0 7.581 6.146 14.04 13.73 14.04c32.16 0 61.02 22.75 65.59 54.59C548.1 446.1 518.5 480 480.1 480z"],
    "clover": [512, 512, [], "e139", "M497.6 255.7c9.156-13.56 14.09-29.75 14.09-46.78C511.7 164.3 477.2 128 434.9 128c-20.88 0-50.38 14.66-86.41 35.53C369.3 127.5 384 98 384 77.13C384 34.59 347.7 0 303.1 0c-17.06 0-33.69 5.156-47.34 14.44C242.2 5.281 225.1 .3438 208.9 .3438C164.3 .3438 128 34.78 128 77.13C128 98 142.7 127.5 163.5 163.5C127.5 142.7 97.1 128 77.13 128C34.59 128 0 164.3 0 208.9C0 226 5.156 242.6 14.44 256.3C5.281 269.8 .3438 286 .3438 303.1C.3438 347.7 34.78 384 77.13 384c20.87 0 50.38-14.66 86.41-35.53C142.7 384.5 128 414 128 434.9C128 477.4 164.3 512 208.9 512c17.06 0 33.69-5.156 47.34-14.44c13.56 9.156 29.75 14.09 46.78 14.09C347.7 511.7 384 477.2 384 434.9c0-20.88-14.66-50.38-35.53-86.41C384.5 369.3 413.1 384 434.9 384C477.4 384 512 347.7 512 303.1C512 286 506.8 269.4 497.6 255.7zM434.9 352c-18.34 0-65.03-27.88-92.94-44.53c-11.91-7.125-22.53-13.44-30.5-17.62c-6.219-3.312-13.84-2.094-18.75 2.844c-4.969 4.969-6.125 12.56-2.844 18.75c4.188 7.969 10.5 18.59 17.62 30.5C324.1 369.8 352 416.5 352 434.9c0 24.69-21.97 44.78-48.94 44.78c-13.66 0-26.31-5.031-35.63-14.12c-6.25-6.125-16.22-6.031-22.47 .0938C235.8 474.8 222.6 480 208.9 480C181.1 480 160 459.8 160 434.9c0-18.34 27.88-65.03 44.53-92.94c7.125-11.91 13.44-22.53 17.62-30.5c3.281-6.188 2.125-13.78-2.844-18.75C216.3 289.6 212.2 288 208 288C205.5 288 202.9 288.6 200.6 289.8c-7.969 4.188-18.59 10.5-30.5 17.62C142.2 324.1 95.47 352 77.13 352c-24.69 0-44.78-21.97-44.78-48.94c0-13.66 5.031-26.31 14.12-35.63c6.125-6.25 6.062-16.25-.0938-22.47C37.25 235.8 32 222.6 32 208.9C32 181.1 52.25 160 77.13 160c18.34 0 65.03 27.88 92.94 44.53c11.91 7.125 22.53 13.44 30.5 17.62c6.156 3.25 13.81 2.062 18.75-2.844c4.969-4.969 6.125-12.56 2.844-18.75c-4.188-7.969-10.5-18.59-17.62-30.5C187.9 142.2 160 95.47 160 77.13c0-24.69 21.97-44.78 48.94-44.78c13.66 0 26.31 5.031 35.63 14.12c6.281 6.188 16.25 6.094 22.47-.0938C276.3 37.25 289.4 32 303.1 32C330 32 352 52.25 352 77.13c0 18.34-27.88 65.03-44.53 92.94c-7.125 11.91-13.44 22.53-17.62 30.5c-.0918 .1719-.0098 .373-.0938 .5469c-1.301 2.689-1.736 5.568-1.441 8.479c.0625 .623 .207 1.139 .3418 1.75c.627 2.904 1.779 5.717 4.037 7.975c2.254 2.254 5.059 3.406 7.957 4.035c.6172 .1387 1.135 .2773 1.764 .3418C302.9 223.7 303.5 224 304 224c2.385 0 4.699-.6914 6.891-1.752c.1738-.084 .375 0 .5469-.0918c7.969-4.188 18.59-10.5 30.5-17.62C369.8 187.9 416.5 160 434.9 160c24.69 0 44.78 21.97 44.78 48.94c0 13.66-5.031 26.31-14.12 35.63c-6.125 6.25-6.062 16.25 .0938 22.47C474.8 276.3 480 289.4 480 303.1C480 330 459.8 352 434.9 352z"],
    "club": [512, 512, [9827], "f327", "M389.8 160.7C397.2 161.4 404.4 162.8 411.4 164.7C469.4 180.2 512 233.1 512 295.1C512 371.1 451.1 432 376 432C336.6 432 301.1 415.2 276.3 388.5C274.8 386.9 273.4 385.3 272 383.6V480H336C344.8 480 352 487.2 352 496C352 504.8 344.8 512 336 512H176C167.2 512 160 504.8 160 496C160 487.2 167.2 480 176 480H240V383.6C238.6 385.3 237.2 386.9 235.7 388.5C210.9 415.2 175.4 432 136 432C60.89 432 0 371.1 0 296C0 233.1 42.64 180.2 100.6 164.7C107.6 162.8 114.8 161.4 122.2 160.7C120.9 153.5 120.2 146.2 120 138.7C120 137.8 120 136.9 120 136C120 60.89 180.9 0 256 0C331.1 0 392 60.89 392 136C392 136.9 391.1 137.8 391.1 138.7C391.8 146.2 391.1 153.5 389.8 160.7V160.7zM360 135.1C360 78.56 313.4 31.1 256 31.1C198.6 31.1 152 78.56 152 135.1C152 142.5 152.6 148.8 153.7 154.9C155.3 163.7 153.2 172.8 147.8 179.9C142.4 187.1 134.3 191.6 125.4 192.5C72.98 197.8 31.1 242.1 31.1 295.1C31.1 353.4 78.56 400 135.1 400C175.7 400 210.2 377.8 227.8 344.1C233.4 334.6 244.2 328.1 255.1 328.1C267.8 328.1 278.6 334.6 284.2 344.1C301.8 377.8 336.3 400 376 400C433.4 400 480 353.4 480 295.1C480 242.1 439 197.8 386.6 192.5C377.7 191.6 369.6 187.1 364.2 179.9C358.8 172.8 356.7 163.7 358.3 154.9C359.4 148.8 360 142.5 360 135.1L360 135.1z"],
    "coconut": [512, 512, [], "e2f6", "M437.4 67.21l-39.86-39.89C379.1 8.799 353 0 322.9 0c-63.45 0-145.3 38.98-214.6 108.3c-102.2 102.2-138.5 231.8-80.99 289.3l39.89 39.89C116.9 487.2 182 512 247.2 512s130.2-24.85 179.9-74.54l10.36-10.36C536.8 327.7 536.8 166.6 437.4 67.21zM32.75 334.9C30.92 318.6 32.84 299.3 38.72 278.3c13.84-49.43 46.59-101.8 92.22-147.4C191.1 69.91 265.5 32 322.9 32c22.61 0 40.11 6.037 52.01 17.94c.002 .002-.002-.002 0 0c38.55 38.55 14.77 148.2-80.99 244c-61.03 61.03-134.6 98.94-191.1 98.94C61.86 392.9 37.81 374.6 32.75 334.9zM434.1 267.3l38.01 38.25c-9.361 34.62-27.04 66.47-52.07 93.25l-42.97-42.2c-6.312-6.172-16.44-6.109-22.62 .2187c-6.188 6.297-6.094 16.42 .1875 22.62l42.7 41.93c-27.41 25.16-60.01 42.7-95.39 51.62l-36.03-36.26c-6.219-6.234-16.34-6.328-22.62-.0625c-6.25 6.219-6.281 16.36-.0625 22.62l19.82 19.95C257.7 479.6 252.5 480 247.2 480c-54.44 0-105.8-19.62-146.3-55.19c.3887 .002 .7402 .0781 1.131 .0781c63.45 0 145.2-38.94 214.6-108.3c70.05-70.05 108.6-152.7 107.7-216.4C460.2 140.9 480 192.4 480 247.2c0 6.717-.3867 13.37-.9727 19.98l-22.28-22.42c-6.188-6.234-16.31-6.344-22.62-.0625C427.9 250.9 427.8 261 434.1 267.3zM257.3 257.1C310 204.3 344.1 147.3 344 111.9c-.0313-15.08-5.969-24.12-10.94-29.06c-33.78-33.67-114.1 15.83-174.4 76.11C105.1 211.7 71.94 268.7 72 304.1c.0313 15.08 5.969 24.12 10.94 29.06C90.53 340.8 100.5 344.1 112 344.1C151.8 344.1 210.6 303.8 257.3 257.1zM105.5 310.5C104.6 309.6 104 307.2 104 304.1C103.1 281.7 130.5 232.4 181.3 181.5c56.94-56.98 105.3-77.75 122.1-77.75c3 0 5.094 .5938 6.219 1.703C311.4 106.4 312 108.8 312 111.9c.0313 22.44-26.5 71.73-77.31 122.6C168.1 301.1 113.2 318.1 105.5 310.5z"],
    "code": [640, 512, [], "f121", "M415.2 21.06L255.2 501.1C252.4 509.4 243.3 513.1 234.9 511.2C226.6 508.4 222 499.3 224.8 490.9L384.8 10.94C387.6 2.554 396.7-1.977 405.1 .8175C413.4 3.612 417.1 12.67 415.2 21.06L415.2 21.06zM170.6 139.9L40.08 256L170.6 372C177.2 377.9 177.8 388 171.1 394.6C166.1 401.2 155.1 401.8 149.4 395.9L5.371 267.1C1.955 264.9 .0003 260.6 0 256C-.0003 251.4 1.954 247.1 5.37 244L149.4 116C155.1 110.2 166.1 110.8 171.1 117.4C177.8 123.1 177.2 134.1 170.6 139.9L170.6 139.9zM490.6 116L634.6 244C638 247.1 640 251.4 640 255.1C640 260.6 638 264.9 634.6 267.1L490.6 395.9C484 401.8 473.9 401.2 468 394.6C462.2 388 462.8 377.9 469.4 372L599.9 255.1L469.4 139.9C462.8 134.1 462.2 123.1 468 117.4C473.9 110.8 484 110.2 490.6 116H490.6z"],
    "code-branch": [448, 512, [], "f126", "M160 80C160 118.7 132.5 150.1 96 158.4V273.6C116.3 252.9 144.7 240 176 240H272C316.2 240 352 204.2 352 160V158.4C315.5 150.1 288 118.7 288 80C288 35.82 323.8 0 368 0C412.2 0 448 35.82 448 80C448 118.7 420.5 150.1 384 158.4V160C384 221.9 333.9 272 272 272H176C131.8 272 96 307.8 96 352V353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80V80zM80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128zM368 128C394.5 128 416 106.5 416 80C416 53.49 394.5 32 368 32C341.5 32 320 53.49 320 80C320 106.5 341.5 128 368 128zM80 480C106.5 480 128 458.5 128 432C128 405.5 106.5 384 80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480z"],
    "code-commit": [640, 512, [], "f386", "M447 272C439.1 335.1 385.3 384 320 384C254.7 384 200.9 335.1 192.1 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H192.1C200.9 176.9 254.7 128 320 128C385.3 128 439.1 176.9 447 240H624C632.8 240 640 247.2 640 256C640 264.8 632.8 272 624 272H447zM320 352C373 352 416 309 416 256C416 202.1 373 160 320 160C266.1 160 224 202.1 224 256C224 309 266.1 352 320 352z"],
    "code-compare": [512, 512, [], "e13a", "M322.8 484.2C329.3 490.1 329.8 500.2 323.8 506.8C317.9 513.3 307.8 513.8 301.2 507.8L213.2 427.8C209.9 424.8 208 420.5 208 416C208 411.5 209.9 407.2 213.2 404.2L301.2 324.2C307.8 318.2 317.9 318.7 323.8 325.2C329.8 331.8 329.3 341.9 322.8 347.8L265.4 400H336C380.2 400 416 364.2 416 320V158.4C379.5 150.1 352 118.7 352 80C352 35.82 387.8 0 432 0C476.2 0 512 35.82 512 80C512 118.7 484.5 150.1 448 158.4V320C448 381.9 397.9 432 336 432H265.4L322.8 484.2zM384 80C384 106.5 405.5 128 432 128C458.5 128 480 106.5 480 80C480 53.49 458.5 32 432 32C405.5 32 384 53.49 384 80zM189.2 27.84C182.7 21.9 182.2 11.78 188.2 5.237C194.1-1.301 204.2-1.783 210.8 4.161L298.8 84.16C302.1 87.19 304 91.49 304 96C304 100.5 302.1 104.8 298.8 107.8L210.8 187.8C204.2 193.8 194.1 193.3 188.2 186.8C182.2 180.2 182.7 170.1 189.2 164.2L246.6 112H176C131.8 112 96 147.8 96 192V353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V192C64 130.1 114.1 80 176 80H246.6L189.2 27.84zM128 432C128 405.5 106.5 384 80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480C106.5 480 128 458.5 128 432z"],
    "code-fork": [448, 512, [], "e13b", "M160 80C160 118.7 132.5 150.1 96 158.4V192C96 218.5 117.5 240 144 240H304C330.5 240 352 218.5 352 192V158.4C315.5 150.1 288 118.7 288 80C288 35.82 323.8 0 368 0C412.2 0 448 35.82 448 80C448 118.7 420.5 150.1 384 158.4V192C384 236.2 348.2 272 304 272H240V353.6C276.5 361 304 393.3 304 432C304 476.2 268.2 512 224 512C179.8 512 144 476.2 144 432C144 393.3 171.5 361 208 353.6V272H144C99.82 272 64 236.2 64 192V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80V80zM80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128zM224 384C197.5 384 176 405.5 176 432C176 458.5 197.5 480 224 480C250.5 480 272 458.5 272 432C272 405.5 250.5 384 224 384zM368 32C341.5 32 320 53.49 320 80C320 106.5 341.5 128 368 128C394.5 128 416 106.5 416 80C416 53.49 394.5 32 368 32z"],
    "code-merge": [448, 512, [], "f387", "M208 256H289.6C297 219.5 329.3 192 368 192C412.2 192 448 227.8 448 272C448 316.2 412.2 352 368 352C329.3 352 297 324.5 289.6 288H208C162.8 288 122.4 267.1 96 234.5V353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80C160 118.4 132.1 150.5 96.89 158.2C103.9 213.4 150.1 256 208 256zM80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128zM320 272C320 298.5 341.5 320 368 320C394.5 320 416 298.5 416 272C416 245.5 394.5 224 368 224C341.5 224 320 245.5 320 272zM80 480C106.5 480 128 458.5 128 432C128 405.5 106.5 384 80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480z"],
    "code-pull-request": [512, 512, [], "e13c", "M323.8 5.237C329.8 11.78 329.3 21.9 322.8 27.84L265.4 80H336C397.9 80 448 130.1 448 192V353.6C484.5 361 512 393.3 512 432C512 476.2 476.2 512 432 512C387.8 512 352 476.2 352 432C352 393.3 379.5 361 416 353.6V192C416 147.8 380.2 112 336 112H265.4L322.8 164.2C329.3 170.1 329.8 180.2 323.8 186.8C317.9 193.3 307.8 193.8 301.2 187.8L213.2 107.8C209.9 104.8 208 100.5 208 96C208 91.49 209.9 87.19 213.2 84.16L301.2 4.161C307.8-1.783 317.9-1.301 323.8 5.237V5.237zM432 384C405.5 384 384 405.5 384 432C384 458.5 405.5 480 432 480C458.5 480 480 458.5 480 432C480 405.5 458.5 384 432 384zM96 353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80C160 118.7 132.5 150.1 96 158.4V353.6zM80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32zM80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480C106.5 480 128 458.5 128 432C128 405.5 106.5 384 80 384z"],
    "code-pull-request-closed": [448, 512, [], "e3f9", "M160 80C160 118.7 132.5 150.1 96 158.4V353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80V80zM80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32zM80 480C106.5 480 128 458.5 128 432C128 405.5 106.5 384 80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480zM352 208C352 199.2 359.2 192 368 192C376.8 192 384 199.2 384 208V353.6C420.5 361 448 393.3 448 432C448 476.2 412.2 512 368 512C323.8 512 288 476.2 288 432C288 393.3 315.5 361 352 353.6V208zM368 480C394.5 480 416 458.5 416 432C416 405.5 394.5 384 368 384C341.5 384 320 405.5 320 432C320 458.5 341.5 480 368 480zM300.7 12.69C306.9 6.438 317.1 6.438 323.3 12.69L368 57.37L412.7 12.69C418.9 6.438 429.1 6.438 435.3 12.69C441.6 18.93 441.6 29.07 435.3 35.31L390.6 80L435.3 124.7C441.6 130.9 441.6 141.1 435.3 147.3C429.1 153.6 418.9 153.6 412.7 147.3L368 102.6L323.3 147.3C317.1 153.6 306.9 153.6 300.7 147.3C294.4 141.1 294.4 130.9 300.7 124.7L345.4 80L300.7 35.31C294.4 29.07 294.4 18.94 300.7 12.69V12.69z"],
    "code-pull-request-draft": [448, 512, [], "e3fa", "M96 353.6C132.5 361 160 393.3 160 432C160 476.2 124.2 512 80 512C35.82 512 0 476.2 0 432C0 393.3 27.48 361 64 353.6V158.4C27.48 150.1 0 118.7 0 80C0 35.82 35.82 0 80 0C124.2 0 160 35.82 160 80C160 118.7 132.5 150.1 96 158.4V353.6zM80 32C53.49 32 32 53.49 32 80C32 106.5 53.49 128 80 128C106.5 128 128 106.5 128 80C128 53.49 106.5 32 80 32zM80 384C53.49 384 32 405.5 32 432C32 458.5 53.49 480 80 480C106.5 480 128 458.5 128 432C128 405.5 106.5 384 80 384zM288 432C288 387.8 323.8 352 368 352C412.2 352 448 387.8 448 432C448 476.2 412.2 512 368 512C323.8 512 288 476.2 288 432zM368 480C394.5 480 416 458.5 416 432C416 405.5 394.5 384 368 384C341.5 384 320 405.5 320 432C320 458.5 341.5 480 368 480zM400 64C400 81.67 385.7 96 368 96C350.3 96 336 81.67 336 64C336 46.33 350.3 32 368 32C385.7 32 400 46.33 400 64zM336 224C336 206.3 350.3 192 368 192C385.7 192 400 206.3 400 224C400 241.7 385.7 256 368 256C350.3 256 336 241.7 336 224z"],
    "code-simple": [576, 512, [], "e13d", "M38.63 256L203.3 420.7C209.6 426.9 209.6 437.1 203.3 443.3C197.1 449.6 186.9 449.6 180.7 443.3L4.686 267.3C-1.562 261.1-1.562 250.9 4.686 244.7L180.7 68.69C186.9 62.44 197.1 62.44 203.3 68.69C209.6 74.94 209.6 85.07 203.3 91.31L38.63 256zM372.7 91.31C366.4 85.07 366.4 74.94 372.7 68.69C378.9 62.44 389.1 62.44 395.3 68.69L571.3 244.7C577.6 250.9 577.6 261.1 571.3 267.3L395.3 443.3C389.1 449.6 378.9 449.6 372.7 443.3C366.4 437.1 366.4 426.9 372.7 420.7L537.4 255.1L372.7 91.31z"],
    "coffee-bean": [448, 512, [], "e13e", "M287.2 32c-67.49 0-138.6 37.66-193.7 92.7C-82.77 300.7 19.86 480 160.9 480c67.49 0 138.9-37.67 193.1-92.71C531.3 210.1 427.4 32 287.2 32zM115.9 147.3C168.2 95.15 232.2 64 287.3 64c.19 0 .3799 .0004 .5698 .0011c30.08 .1162 58.71 13.46 80.34 34.31l.7481 .7228c-18.84 61.79-60.51 131.5-153.8 149c-80.5 15.12-137.1 60.78-165.1 132.6C12.43 334.4 32.1 231.1 115.9 147.3zM332.2 364.7C279.9 416.9 215.9 448 160.8 448c-47.12 0-62.83-16.11-87.01-40.27C96.57 337.8 146.9 293.4 221.1 279.5c82.92-15.6 142.1-68.62 172.1-154C448.1 189.4 396.1 300.8 332.2 364.7z"],
    "coffee-beans": [512, 512, [], "e13f", "M0 351.6c.1465 214 256.2 213.4 256 .7194C255.9 138.3-.1504 139 0 351.6zM125.3 480l-.4609-.0059c-24.97-.3301-49.55-13.53-64.42-33.2C41.03 421.2 32.02 384.6 32 351.6C31.95 282.6 68.38 228.7 100.4 224c-19.94 49.28-15.71 100.8 13.63 142.9C139 402.7 142.8 442.5 125.3 480zM160.5 476.9c13.99-42.28 7.5-88.26-19.98-127.7C114.8 312.3 113.3 267.2 135.8 222.7C223.8 225.3 223.1 349.2 224 352.4C224 397.5 206.9 458.4 160.5 476.9zM452.5 59.92c-152.6-152.5-320.5 16.64-168.1 168.2C436.1 380.6 604 211.4 452.5 59.92zM304.6 206.1c-32.15-32.14-64.26-86.81-46.89-130.7c20.91 39.37 57.93 67.88 104.1 77.93c43.18 9.352 76.28 40.62 93.18 87.11C395.2 297.5 306.8 209.2 304.6 206.1zM477.3 217.1c-21.98-48.28-61.45-82.21-110.7-92.91c-41.98-9.113-72.73-34.96-87.99-73.23c.1035-.0996 .207-.2012 .3086-.3008c16.67-16.22 42.25-22.1 66.04-18.77c31.03 5.51 62.99 25.63 86.5 49.14C480.7 130.2 495 192.6 477.3 217.1z"],
    "coffee-pot": [512, 512, [], "e002", "M431.5 177.6l41.49-124.6C476.4 42.7 468.7 32 457.8 32H80C35.82 32 0 67.82 0 112v96C0 216.8 7.199 224 16 224S32 216.8 32 208v-96C32 85.49 53.49 64 80 64h26.62l38.13 114.1C95.38 217.9 64 277.8 64 344.6c0 51.48 18.64 84.76 49.62 117.7C124.3 473.8 139.5 480 155.1 480l265.8 0c15.53 0 30.66-6.274 41.32-17.57C493.3 429.5 512 396.2 512 344.6C512 278.4 481.4 217.9 431.5 177.6zM140.4 64h295.3l-32 96H172.4L140.4 64zM178.5 192h219.8c21 16.88 54.63 42.13 72.5 96H105.4C123.5 234 158.3 208.4 178.5 192zM439 440.5C434.3 445.4 427.6 448.1 420.9 448H155.1c-6.875 .125-13.38-2.625-18.12-7.625C107.1 408.8 96 382.8 96 344.6C96.13 336.4 96.75 328.1 97.88 320h380.3C479.4 328.1 480 336.4 480 344.6C480 382.8 468.9 408.8 439 440.5z"],
    "coffin": [448, 512, [9904], "f6c6", "M402.7 112.8L303.9 13.5C295.1 4.75 283.6 0 271.4 0H176.6C164.4 0 152.9 4.75 144.1 13.5L45.35 112.8c-11.25 11.38-15.88 28-12 43.63l79.88 320.8C118.2 497.6 136.6 512 157.7 512h132.5c21.13 0 39.51-14.38 44.51-34.88l79.89-320.8C418.5 140.8 413.9 124.1 402.7 112.8zM303.8 469.4C302.3 475.6 296.6 480 290.3 480H157.7c-6.375 0-12-4.375-13.5-10.62L64.35 148.6C63.23 143.9 64.6 138.8 68.1 135.3l98.64-99.13C169.5 33.5 172.1 32 176.6 32h94.76c3.75 0 7.125 1.5 9.75 4l98.76 99.25c3.502 3.5 4.877 8.625 3.752 13.38L303.8 469.4z"],
    "coffin-cross": [384, 512, [], "e051", "M370.7 112.8L271.9 13.5C263.1 4.75 251.6 0 239.4 0H144.6C132.4 0 120.9 4.75 112.1 13.5L13.35 112.8c-11.25 11.38-15.88 28-12 43.63l79.88 320.8C86.24 497.6 104.6 512 125.7 512h132.5c21.13 0 39.51-14.38 44.51-34.88l79.89-320.8C386.5 140.8 381.9 124.1 370.7 112.8zM271.8 469.4C270.3 475.6 264.6 480 258.3 480H125.7c-6.375 0-12-4.375-13.5-10.62L32.35 148.6C31.23 143.9 32.6 138.8 36.1 135.3l98.64-99.13C137.5 33.5 140.1 32 144.6 32h94.76c3.75 0 7.125 1.5 9.75 4l98.76 99.25c3.502 3.5 4.877 8.625 3.752 13.38L271.8 469.4zM272 176h-64v-64c0-8.844-7.155-16-15.1-16S176 103.2 176 112v64h-64C103.2 176 96 183.2 96 192s7.156 16 16 16h64v128c0 8.844 7.155 16 15.1 16S208 344.8 208 336v-128h64C280.8 208 288 200.8 288 192S280.8 176 272 176z"],
    "coin": [512, 512, [129689], "f85c", "M428.1 242.3C418.1 252.2 403.2 260.4 386.2 267C352.1 280.2 306.1 288 255.1 288C205.9 288 159.9 280.2 125.8 267C108.8 260.4 93.92 252.2 83.04 242.3C72.15 232.3 63.1 219.4 63.1 204C63.1 188.6 72.15 175.7 83.04 165.7C93.92 155.8 108.8 147.6 125.8 140.1C159.9 127.8 205.9 120 255.1 120C306.1 120 352.1 127.8 386.2 140.1C403.2 147.6 418.1 155.8 428.1 165.7C439.8 175.7 448 188.6 448 204C448 219.4 439.8 232.3 428.1 242.3V242.3zM137.3 170.8C122.5 176.6 111.6 183 104.6 189.3C97.7 195.7 96 200.6 96 204C96 207.4 97.7 212.3 104.6 218.7C111.6 224.1 122.5 231.4 137.3 237.2C166.9 248.6 208.9 256 256 256C303.1 256 345.1 248.6 374.7 237.2C389.5 231.4 400.4 224.1 407.4 218.7C414.3 212.3 416 207.4 416 204C416 200.6 414.3 195.7 407.4 189.3C400.4 183 389.5 176.6 374.7 170.8C345.1 159.4 303.1 152 256 152C208.9 152 166.9 159.4 137.3 170.8zM0 208C0 128.5 114.6 64 256 64C397.4 64 512 128.5 512 208V320C512 390.7 397.4 448 256 448C114.6 448 0 390.7 0 320V208zM421.3 281.9C463 258.5 480 231.1 480 208C480 184.9 463 157.5 421.3 134.1C380.6 111.2 322.2 95.1 256 95.1C189.8 95.1 131.4 111.2 90.67 134.1C48.96 157.5 32 184.9 32 207.1C32 231.1 48.96 258.5 90.67 281.9C131.4 304.8 189.8 319.1 256 319.1C322.2 319.1 380.6 304.8 421.3 281.9V281.9zM176 409.2C196 412.7 217.5 414.1 240 415.7V351.7C217.8 350.1 196.3 348.6 176 344.8V409.2zM144 337.5C126.8 332.8 110.8 327.1 96 320.4V385.1C110.2 391.7 126.3 397.4 144 402.1V337.5zM32 320C32 332.9 40.51 349.9 64 366.8V303.2C51.78 295.5 41.03 286.9 32 277.8V320zM272 351.7V415.7C294.5 414.1 315.1 412.7 336 409.2V344.8C315.7 348.6 294.2 350.1 272 351.7V351.7zM480 277.8C470.1 286.9 460.2 295.5 448 303.2V366.8C471.5 349.9 480 332.9 480 320V277.8zM368 402.1C385.7 397.4 401.8 391.7 416 385.1V320.4C401.3 327.1 385.2 332.8 368 337.5V402.1z"],
    "coin-blank": [512, 512, [], "e3fb", "M512 208V320C512 390.7 397.4 448 256 448C114.6 448 0 390.7 0 320V208C0 128.5 114.6 64 256 64C397.4 64 512 128.5 512 208zM90.67 281.9C131.4 304.8 189.8 320 256 320C322.2 320 380.6 304.8 421.3 281.9C463 258.5 480 231.1 480 208C480 184.9 463 157.5 421.3 134.1C380.6 111.2 322.2 96 256 96C189.8 96 131.4 111.2 90.67 134.1C48.96 157.5 32 184.9 32 207.1C32 231.1 48.96 258.5 90.67 281.9V281.9zM240 351.7C217.8 350.1 196.3 348.6 176 344.8V409.2C196 412.7 217.5 414.1 240 415.7V351.7zM96 385.1C110.2 391.7 126.3 397.4 144 402.1V337.5C126.8 332.8 110.8 327.1 96 320.4V385.1zM64 303.2C51.78 295.5 41.03 286.9 32 277.8V320C32 332.9 40.51 349.9 64 366.8V303.2zM336 409.2V344.8C315.7 348.6 294.2 350.1 272 351.7V415.7C294.5 414.1 315.1 412.7 336 409.2V409.2zM448 366.8C471.5 349.9 480 332.9 480 320V277.8C470.1 286.9 460.2 295.5 448 303.2V366.8zM416 320.4C401.3 327.1 385.2 332.8 368 337.5V402.1C385.7 397.4 401.8 391.7 416 385.1V320.4z"],
    "coin-front": [512, 512, [], "e3fc", "M272 336C272 344.8 264.8 352 256 352C247.2 352 240 344.8 240 336V176C240 167.2 247.2 160 256 160C264.8 160 272 167.2 272 176V336zM64 256C64 149.1 149.1 64 256 64C362 64 448 149.1 448 256C448 362 362 448 256 448C149.1 448 64 362 64 256zM256 416C344.4 416 416 344.4 416 256C416 167.6 344.4 96 256 96C167.6 96 96 167.6 96 256C96 344.4 167.6 416 256 416zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "coin-vertical": [384, 512, [], "e3fd", "M178.3 83.04C188.2 93.92 196.4 108.8 203 125.8C216.2 159.9 224 205.9 224 256C224 306.1 216.2 352.1 203 386.2C196.4 403.2 188.2 418.1 178.3 428.1C168.3 439.8 155.4 448 140 448C124.6 448 111.7 439.8 101.7 428.1C91.78 418.1 83.56 403.2 76.99 386.2C63.81 352.1 56 306.1 56 256C56 205.9 63.81 159.9 76.99 125.8C83.56 108.8 91.78 93.92 101.7 83.04C111.7 72.15 124.6 64 140 64C155.4 64 168.3 72.15 178.3 83.04V83.04zM106.8 374.7C112.6 389.5 119 400.4 125.3 407.4C131.7 414.3 136.6 416 140 416C143.4 416 148.3 414.3 154.7 407.4C160.1 400.4 167.4 389.5 173.2 374.7C184.6 345.1 192 303.1 192 256C192 208.9 184.6 166.9 173.2 137.3C167.4 122.5 160.1 111.6 154.7 104.6C148.3 97.7 143.4 95.1 140 95.1C136.6 95.1 131.7 97.7 125.3 104.6C119 111.6 112.6 122.5 106.8 137.3C95.41 166.9 88 208.9 88 256C88 303.1 95.41 345.1 106.8 374.7V374.7zM144 512C64.47 512 0 397.4 0 256C0 114.6 64.47 0 144 0H256C326.7 0 384 114.6 384 256C384 397.4 326.7 512 256 512H144zM217.9 90.67C194.5 48.96 167.1 32 144 32C120.9 32 93.53 48.96 70.07 90.67C47.17 131.4 32 189.8 32 256C32 322.2 47.17 380.6 70.07 421.3C93.53 463 120.9 480 144 480C167.1 480 194.5 463 217.9 421.3C240.8 380.6 256 322.2 256 256C256 189.8 240.8 131.4 217.9 90.67V90.67zM345.2 336C348.7 315.1 350.1 294.5 351.7 272H287.7C286.1 294.2 284.6 315.7 280.8 336H345.2zM273.5 368C268.8 385.2 263.1 401.3 256.4 416H321.1C327.7 401.8 333.4 385.7 338.1 368H273.5zM256 480C268.9 480 285.9 471.5 302.8 448H239.3C231.5 460.2 222.9 470.1 213.8 480H256zM287.7 240H351.7C350.1 217.5 348.7 196 345.2 176H280.8C284.6 196.3 286.1 217.8 287.7 240V240zM213.8 32C222.9 41.03 231.5 51.78 239.3 64H302.8C285.9 40.51 268.9 32 256 32H213.8zM338.1 144C333.4 126.3 327.7 110.2 321.1 96H256.4C263.1 110.8 268.8 126.8 273.5 144H338.1z"],
    "coins": [512, 512, [], "f51e", "M168.3 92.78C169.6 93.97 171.2 95.17 172.9 96.36C157.5 96.95 142.5 98.24 128 100.2V80C128 64.75 136.6 52.28 147.4 42.96C158.3 33.58 173.1 25.87 190.1 19.71C224.1 7.338 270 0 320 0C369.1 0 415.9 7.338 449.9 19.71C466.9 25.87 481.7 33.58 492.6 42.96C503.4 52.28 512 64.75 512 80V184V184V297.9C512 313.3 503.8 326.1 492.9 335.9C481.1 345.7 467.1 353.8 450.1 360.3C439.8 364.2 428.3 367.7 416 370.6V337.6C424.2 335.4 431.8 333 438.8 330.4C453.6 324.7 464.5 318.4 471.5 312.1C478.4 305.9 480 301 480 297.9V231.7C471.3 237.3 461.2 242.2 450.1 246.4C439.8 250.3 428.3 253.8 416 256.7V223.7C424.2 221.5 431.8 219.1 438.8 216.5C453.6 210.8 464.5 204.4 471.5 198.2C478.4 191.1 480 187.1 480 184V126.1C471.2 131.6 461 136.3 449.9 140.3C432.6 146.6 412.3 151.6 389.9 154.9C388.1 152.1 386.2 151.2 384.3 149.5C374.2 140.4 362.6 133 350.5 127C385.2 124.7 415.9 118.6 438.1 110.2C453.9 104.8 464.8 98.72 471.7 92.78C478.7 86.79 480 82.42 480 80C480 77.58 478.7 73.21 471.7 67.22C464.8 61.28 453.9 55.2 438.1 49.78C409.3 38.99 367.2 32 320 32C272.8 32 230.7 38.99 201 49.78C186.1 55.2 175.2 61.28 168.3 67.22C161.3 73.21 159.1 77.58 159.1 80C159.1 82.42 161.3 86.79 168.3 92.78L168.3 92.78zM0 208C0 192.7 8.552 180.3 19.4 170.1C30.3 161.6 45.14 153.9 62.08 147.7C96.1 135.3 142 128 192 128C241.1 128 287.9 135.3 321.9 147.7C338.9 153.9 353.7 161.6 364.6 170.1C375.4 180.3 384 192.7 384 208V425.9C384 441.3 375.8 454.1 364.9 463.9C353.1 473.7 339.1 481.8 322.1 488.3C288.1 501.3 242 508.1 192 508.1C141.1 508.1 95.95 501.3 61.85 488.3C44.86 481.8 30.01 473.7 19.12 463.9C8.241 454.1 .0003 441.3 .0003 425.9L0 208zM40.26 220.8C47.17 226.7 58.11 232.8 73.02 238.2C102.7 249 144.8 256 192 256C239.2 256 281.3 249 310.1 238.2C325.9 232.8 336.8 226.7 343.7 220.8C350.7 214.8 352 210.4 352 208C352 205.6 350.7 201.2 343.7 195.2C336.8 189.3 325.9 183.2 310.1 177.8C281.3 166.1 239.2 160 192 160C144.8 160 102.7 166.1 73.02 177.8C58.11 183.2 47.17 189.3 40.26 195.2C33.3 201.2 32 205.6 32 208C32 210.4 33.3 214.8 40.26 220.8V220.8zM321.9 268.3C287.9 280.7 241.1 288 192 288C142 288 96.1 280.7 62.08 268.3C50.98 264.3 40.78 259.5 32 254.1V312C32 315.1 33.61 319.1 40.54 326.2C47.46 332.4 58.39 338.8 73.25 344.5C102.9 355.7 144.8 363 192 363C239.2 363 281.1 355.7 310.8 344.5C325.6 338.8 336.5 332.4 343.5 326.2C350.4 319.1 352 315.1 352 312V254.1C343.2 259.5 333 264.3 321.9 268.3zM40.54 440.1C47.46 446.4 58.39 452.7 73.25 458.4C102.9 469.6 144.8 476.1 192 476.1C239.2 476.1 281.1 469.6 310.8 458.4C325.6 452.7 336.5 446.4 343.5 440.1C350.4 433.9 352 429 352 425.9V359.7C343.3 365.3 333.2 370.2 322.1 374.4C288.1 387.4 242 395 192 395C141.1 395 95.95 387.4 61.85 374.4C50.84 370.2 40.72 365.3 31.1 359.7V425.9C31.1 429 33.61 433.9 40.54 440.1H40.54z"],
    "colon": [128, 512, [], "3a", "M64 192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C.0008 163.3 28.66 192 64 192zM64 96c17.64 0 32 14.36 32 32s-14.36 32-32 32S32 145.6 32 128S46.36 96 64 96zM64 320c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64s64-28.65 64-64C128 348.7 99.35 320 64 320zM64 416c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S81.64 416 64 416z"],
    "colon-sign": [320, 512, [], "e140", "M213.1 64.72C228.7 66.04 243.7 69.15 258.1 73.84L272.4 12.36C274.4 3.759 283-1.59 291.6 .4181C300.2 2.426 305.6 11.03 303.6 19.64L287.1 86.43C296.9 91.09 305.4 96.4 313.5 102.3C320.6 107.5 322.1 117.6 316.9 124.7C311.7 131.8 301.6 133.3 294.5 128.1C290 124.8 285.3 121.7 280.4 118.8L211.3 415.3C242.4 412.5 270.9 401.2 294.5 383.9C301.6 378.7 311.7 380.2 316.9 387.3C322.1 394.4 320.6 404.5 313.5 409.7C282.6 432.4 244.7 446.3 203.7 447.9L191.6 499.6C189.6 508.2 180.1 513.6 172.4 511.6C163.8 509.6 158.4 500.1 160.4 492.4L171.1 446.5C155.6 444.5 140.7 440.8 126.5 435.6L111.6 499.6C109.6 508.2 100.1 513.6 92.36 511.6C83.76 509.6 78.41 500.1 80.42 492.4L96.91 421.7C39.01 388.4 0 326.8 0 256C0 154.9 79.64 72.47 180.2 64.61L192.4 12.36C194.4 3.759 203-1.59 211.6 .4181C220.2 2.426 225.6 11.03 223.6 19.64L213.1 64.72zM172.5 97.62C92.83 108.7 32 175.7 32 256C32 311.2 60.73 360.1 104.6 388.9L172.5 97.62zM178.4 415.1L250.8 105.1C236.6 100.2 221.4 97.17 205.7 96.28L133.9 404.1C147.9 409.7 162.8 413.5 178.4 415.1V415.1z"],
    "columns-3": [640, 512, [], "e361", "M0 96C0 60.65 28.65 32 64 32H576C611.3 32 640 60.65 640 96V416C640 451.3 611.3 480 576 480H64C28.65 480 0 451.3 0 416V96zM448 448H576C593.7 448 608 433.7 608 416V96C608 78.33 593.7 64 576 64H448V448zM416 64H224V448H416V64zM192 448V64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H192z"],
    "comet": [512, 512, [], "e003", "M504.8 7.279c-6.375-6.375-15.75-8.875-24.5-6.25c-32.25 9.875-108.9 33.63-167.4 58.88c-1.166-3.83-3.572-20.44-20.12-27.5c-8.5-3.625-18.25-3.125-26.38 1.25c-43.25 22.5-150 81.13-208.4 139.5c-77.38 77.38-77.38 203.4 0 280.8c77.63 77.5 203.4 77.5 281 0c58.25-58.25 116.9-165 139.5-208.3c4.25-8.125 4.625-17.75 1.125-26.38c-6.754-16.4-23.03-18.63-27.5-20.12c25-58.13 49-134.9 58.88-167.3C513.7 23.15 511.2 13.65 504.8 7.279zM407.7 219.4l42.38 11.38c0 0-78.63 145.4-133.8 200.5c-64.88 64.88-170.8 65-235.6 0s-64.88-170.8 0-235.6c55.13-55 199.3-134.1 199.3-134.1l12.62 43c0 0 61.45-30.92 183.6-68.63C441.3 149.6 407.7 219.4 407.7 219.4zM221.7 173.8c-2.5-5.125-7.875-8.502-13.75-8.502c-5.75 0-11.12 3.377-13.75 8.502l-31.25 63.5L93.09 247.6c-5.748 .875-10.5 4.875-12.37 10.38c-1.75 5.625-.25 11.62 4 15.75l50.5 49.38l-12 69.63c-.75 4.5 .5 9 3.5 12.5c2.875 3.5 7.125 5.5 11.62 5.5c2.5 0 5-.625 7.125-1.875l62.51-32.73l62.61 32.73c5.123 2.75 11.37 2.375 16.12-1.125c4.625-3.375 7-9.25 6-15l-11.88-69.63l50.5-49.38c4.25-4.125 5.75-10.12 3.875-15.75c-1.75-5.5-6.625-9.5-12.38-10.38L252.1 237.3L221.7 173.8zM246.5 311.8l9 53l-47.5-25l-47.37 25l9.125-53l-38.5-37.5l52.1-7.75l23.75-48.13l23.75 48.13l53.12 7.75L246.5 311.8z"],
    "comma": [192, 512, [], "2c", "M156.4 327.4c-8.773-24.27-33.94-39.39-58.1-39.39c-.002 0 .0039 0 0 0c-9.959 .002-19.91 2.39-28.8 7.544c-15.66 9.051-26.41 24.44-29.45 42.25l-22.57 131.7c-2.986 17.32 6.9 34.29 23.49 40.31C44.12 511.3 48.34 511.1 52.51 511.1c12.67 0 24.82-6.604 31.51-18.03l67.69-115.4C160.8 363 162.5 344.4 156.4 327.4zM124.1 362.4l-67.71 115.4c-.793 1.355-2.105 1.98-4.18 1.98c-.4004 0-.8262-.0234-1.283-.0684c-2.016-.7305-3.221-2.746-2.861-4.822l22.57-131.7c1.434-8.383 6.508-15.65 13.96-19.96C88.29 321.1 92.59 320 97.36 320c12.71 0 25.13 7.857 28.91 18.31C129.2 346.3 128.4 355.1 124.1 362.4z"],
    "command": [448, 512, [], "e142", "M368 320H320V192h48C412.2 192 448 156.2 448 112C448 67.82 412.2 32 368 32S288 67.82 288 112V160H160V112C160 67.82 124.2 32 80 32S0 67.82 0 112C0 156.2 35.82 192 80 192H128v128H80C35.82 320 0 355.8 0 400C0 444.2 35.82 480 80 480S160 444.2 160 400V352h128v48c0 44.18 35.82 80 80 80s80-35.82 80-80C448 355.8 412.2 320 368 320zM320 112C320 85.53 341.5 64 368 64S416 85.53 416 112S394.5 160 368 160H320V112zM128 400C128 426.5 106.5 448 80 448S32 426.5 32 400S53.53 352 80 352H128V400zM128 160H80C53.53 160 32 138.5 32 112S53.53 64 80 64S128 85.53 128 112V160zM288 320H160V192h128V320zM368 448c-26.47 0-48-21.53-48-48V352h48c26.47 0 48 21.53 48 48S394.5 448 368 448z"],
    "comment": [512, 512, [61669, 128489], "f075", "M256 64c123.5 0 223.1 79 223.1 176S379.5 416 256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.62l.1287-.3388c4.283-11.27 1.79-23.1-6.429-32.82C47.51 313.1 32.06 277.6 32.06 240C32.06 143 132.6 64 256 64zM256 32C114.7 32 .0272 125.1 .0272 240c0 47.63 19.92 91.25 52.91 126.2c-14.87 39.5-45.87 72.88-46.37 73.25c-6.624 7-8.374 17.25-4.625 26C5.817 474.2 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32z"],
    "comment-arrow-down": [512, 512, [], "e143", "M324.7 228.7L272 281.4V144C272 135.2 264.8 128 256 128S240 135.2 240 144v137.4L187.3 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l80 80C247.8 334.4 251.9 336 256 336s8.188-1.562 11.31-4.688l80-80c6.25-6.25 6.25-16.38 0-22.62S330.9 222.4 324.7 228.7zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-arrow-up": [512, 512, [], "e144", "M267.3 132.7C264.2 129.6 260.1 128 256 128S247.8 129.6 244.7 132.7l-80 80c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L240 182.6V320c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l52.69 52.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 132.7zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3379c4.283-11.27 1.791-24-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM326.1 145.2C324.2 144.4 322.1 144 320 144H192C183.2 144 176 151.2 176 160S183.2 176 192 176h89.38L164.7 292.7c-6.25 6.25-6.25 16.38 0 22.62C167.8 318.4 171.9 320 176 320s8.188-1.562 11.31-4.688L304 198.6V288c0 8.844 7.156 16 16 16s16-7.156 16-16V160c0-2.082-.4219-4.154-1.23-6.109C333.1 149.1 330 146.9 326.1 145.2z"],
    "comment-captions": [512, 512, [], "e146", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.625 26C5.817 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.91 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM224 240C224 231.2 216.8 224 208 224h-128C71.16 224 64 231.2 64 240S71.16 256 80 256h128C216.8 256 224 248.8 224 240zM304 288h-96C199.2 288 192 295.2 192 304S199.2 320 208 320h96c8.844 0 16-7.156 16-16S312.8 288 304 288zM144 288h-32C103.2 288 96 295.2 96 304S103.2 320 112 320h32C152.8 320 160 312.8 160 304S152.8 288 144 288zM400 288h-32C359.2 288 352 295.2 352 304s7.156 16 16 16h32c8.844 0 16-7.156 16-16S408.8 288 400 288zM432 224h-160C263.2 224 256 231.2 256 240S263.2 256 272 256h160C440.8 256 448 248.8 448 240S440.8 224 432 224z"],
    "comment-check": [512, 512, [], "f4ac", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.372 17.25-4.624 26C5.817 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM324.7 175.3L229.3 270.7L187.3 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l53.33 53.34c3 3 7.062 4.688 11.31 4.688s8.312-1.688 11.31-4.688l106.7-106.7c6.25-6.25 6.25-16.38 0-22.62S330.9 169.1 324.7 175.3z"],
    "comment-code": [512, 512, [], "e147", "M256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3379c4.283-11.27 1.791-24-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM223.3 156.7c-6.25-6.25-16.38-6.25-22.62 0l-72 72c-6.25 6.25-6.25 16.38 0 22.62l72 72C203.8 326.4 207.9 328 212 328s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L162.6 240l60.69-60.69C229.6 173.1 229.6 162.9 223.3 156.7zM311.3 156.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L349.4 240l-60.69 60.69c-6.25 6.25-6.25 16.38 0 22.62C291.8 326.4 295.9 328 300 328s8.188-1.562 11.31-4.688l72-72c6.25-6.25 6.25-16.38 0-22.62L311.3 156.7z"],
    "comment-dollar": [512, 512, [], "f651", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.9 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.372 17.25-4.624 26C5.818 474.3 14.4 480 24.02 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.14 14.25 92.89 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM260.2 224.5L252.9 222.5C218.8 212.1 214.3 206.4 216.5 194.2c3-16.64 28.03-20.52 51.47-17.05c6.562 .9687 14.53 3.047 25.06 6.516c8.375 2.766 17.47-1.812 20.19-10.2c2.781-8.391-1.781-17.44-10.19-20.2c-12.31-4.047-22.59-6.57-31-7.82V128c0-8.844-7.156-16-16-16s-16 7.156-16 16v16.8c-29.75 3.514-50.58 19.29-55.03 43.71C176.7 234.4 222.3 247.2 244.3 253.3L251.8 255.4c38.22 10.41 46.41 16.08 43.81 30.38c-3 16.64-27.97 20.61-51.53 17.03C236.2 301.7 230.6 300.1 205.1 291.5C196.8 288.6 187.7 293.2 184.9 301.6c-2.812 8.375 1.688 17.45 10.06 20.28c29.34 9.969 36.57 11.45 45.09 12.67V352c0 8.844 7.156 16 16 16s16-7.156 16-16v-16.8c29.72-3.51 50.59-19.29 55.03-43.72C335.5 245 290.2 232.7 260.2 224.5z"],
    "comment-dots": [512, 512, [62075, 128172, "commenting"], "f4ad", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM256 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 226.7 269.3 216 256 216zM384 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C408 226.7 397.3 216 384 216zM128 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 253.3 152 240C152 226.7 141.3 216 128 216z"],
    "comment-exclamation": [512, 512, [], "f4af", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM255.1 287.1C264.8 287.1 272 280.8 272 272V128c0-8.844-7.156-16-16-16S240 119.2 240 128v144C240 280.8 247.1 287.1 255.1 287.1zM256 312c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 322.7 269.3 312 256 312z"],
    "comment-image": [512, 512, [], "e148", "M160 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S136 146.7 136 160C136 173.3 146.7 184 160 184zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM313.6 155.2c-11.61-14.22-36.39-14.25-47.97 0L207.1 227.1L199.2 218.8c-11.47-11.94-33.27-11.94-44.73 0L104 271.2c-8.453 8.844-10.44 21.5-5.047 32.28C103.1 313.5 114.8 320 126.4 320h259.2c11.3 0 21.59-5.906 26.86-15.44c5.609-10.16 4.469-22.53-2.875-31.53L313.6 155.2zM131.1 288L176.1 241l20.44 21.22c3.188 3.312 7.562 5 12.19 4.906c4.578-.2187 8.859-2.344 11.75-5.906l68.28-85.84l91.75 112.6L131.1 288z"],
    "comment-lines": [512, 512, [], "f4b0", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM272 272h-128c-8.801 0-16 7.199-16 15.1C127.1 296.8 135.2 304 144 304h128c8.801 0 15.1-7.204 15.1-16C287.1 279.2 280.8 272 272 272zM368 176h-224c-8.801 0-16 7.199-16 15.1C127.1 200.8 135.2 208 144 208h224c8.801 0 15.1-7.204 15.1-16C383.1 183.2 376.8 176 368 176z"],
    "comment-medical": [512, 512, [], "f7f5", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25C397.4 447.1 512 354.9 512 239.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 208H288V160c0-8.838-7.164-16-16-16h-32C231.2 144 224 151.2 224 160v48H176C167.2 208 160 215.2 160 223.1V256c0 8.836 7.164 15.1 16 15.1H224v48C224 328.8 231.2 336 240 336h32c8.836 0 16-7.166 16-16v-48h48C344.8 271.1 352 264.8 352 256V223.1C352 215.2 344.8 208 336 208z"],
    "comment-middle": [512, 512, [], "e149", "M256 0C114.6 0 0 93.09 0 208c0 95.99 80.08 176.5 188.8 200.5l48.89 93.39C241.2 508.6 248.6 512 256 512s14.76-3.361 18.28-10.08l48.89-93.39C431.9 384.5 512 303.1 512 208C512 93.09 397.4 0 256 0zM316.3 377.3l-14.55 3.209L256 467.8l-45.72-87.34L195.7 377.3C99.33 356 32 286.4 32 208C32 110.1 132.5 32 256 32s224 78.95 224 176C480 286.4 412.7 356 316.3 377.3z"],
    "comment-middle-top": [512, 512, [], "e14a", "M323.2 103.5l-48.89-93.39C270.8 3.361 263.4 0 256 0S241.2 3.361 237.7 10.08l-48.89 93.39C80.08 127.5 0 208 0 304c0 114.9 114.6 208 256 208s256-93.09 256-208C512 208 431.9 127.5 323.2 103.5zM256 480c-123.5 0-224-78.95-224-176c0-78.4 67.33-148 163.7-169.3L210.3 131.5L256 44.17l45.72 87.34l14.55 3.209C412.7 155.1 480 225.6 480 304C480 401 379.5 480 256 480z"],
    "comment-minus": [512, 512, [], "f4b1", "M256 32C114.7 32 .0281 125.1 .0281 240c0 47.63 19.92 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.621 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.24 0-56.24-4.25-83.23-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.99 16.25-58.55 35.29-102.7 39.66c12-15.12 29.75-40.5 40.74-69.63l.1328-.3398c4.281-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 224h-160C167.2 224 160 231.2 160 240c0 8.834 7.156 15.1 16 15.1h160c8.84 0 16-7.16 16-15.1S344.8 224 336 224z"],
    "comment-music": [512, 512, [], "f8b0", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.94 91.25 52.93 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.844 474.3 14.35 480 23.97 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.18 14.25 92.92 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM338.3 124.8c-8.625-6-19.62-7.438-29.5-3.688l-96 36C200.3 161.8 192 173.8 192 187.1v73.72C184.7 257.8 176.6 256 168 256C137.1 256 112 277.5 112 304S137.1 352 168 352S224 330.5 224 304V187.1l96-35.97v77.72C312.7 225.8 304.6 224 296 224C265.1 224 240 245.5 240 272s25.12 48 56 48S352 298.5 352 272V151.1C352 140.6 346.8 130.8 338.3 124.8zM168 320C155.2 320 144 312.5 144 304S155.2 288 168 288S192 295.5 192 304S180.8 320 168 320zM296 288c-12.78 0-24-7.469-24-16S283.2 256 296 256S320 263.5 320 272S308.8 288 296 288z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM345.5 141.1c-7.617-7.559-17.5-12.83-28.23-13.78c-13.24-1.172-25.9 3.414-35.16 12.59L157.9 264.1c-2.234 2.215-3.754 5.039-4.375 8.113l-12.25 60.79c-2.234 11.11 7.633 20.91 18.83 18.68l61.25-12.15c3.094-.6133 5.938-2.125 8.172-4.344l123.1-122.2c7.617-7.555 12.92-17.37 13.87-28.02c1.168-13.14-3.457-25.7-12.71-34.88L345.5 141.1zM210.3 309.3L177.3 315.9l6.594-32.71l86.88-86.23l26.38 26.18L210.3 309.3zM331.1 189.4l-11.3 11.22l-26.38-26.18l11.31-11.22c4.688-4.645 12.28-4.652 16.97 .0039l9.41 9.336C335.8 177.2 335.8 184.8 331.1 189.4z"],
    "comment-plus": [512, 512, [], "f4b2", "M256 32C114.7 32 .0281 125.1 .0281 240c0 47.63 19.92 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.621 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.24 0-56.24-4.25-83.23-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.99 16.25-58.55 35.29-102.7 39.66c12-15.12 29.75-40.5 40.74-69.63l.1328-.3398c4.281-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 224h-64V159.1C272 151.2 264.8 144 256 144S240 151.2 240 159.1V224h-64C167.2 224 160 231.2 160 240c0 8.834 7.156 15.1 16 15.1h64v64C240 328.8 247.2 336 256 336c8.836 0 16-7.16 16-15.1V255.1h64c8.84 0 16-7.16 16-15.1S344.8 224 336 224z"],
    "comment-question": [512, 512, [], "e14b", "M278.1 128H229.7C200.1 128 176 152.1 176 181.6c0 8.844 7.156 16 16 16s16-7.156 16-16C208 169.7 217.7 160 229.7 160h48.47C292.4 160 304 171.6 304 185.9c0 9.875-5.469 18.75-14.53 23.27L248.6 230.3C243.3 233.1 240 238.6 240 244.5V272C240 280.8 247.2 288 256 288s16-7.156 16-16V254.3l32-16.61c19.75-9.875 32-29.76 32-51.82C336 153.9 310 128 278.1 128zM256 312c-11.04 0-20 8.953-20 20C236 343 244.1 352 256 352s20-8.955 20-20C276 320.1 267 312 256 312zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-quote": [512, 512, [], "e14c", "M183.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c8.627 0 16.7-2.111 24-5.596V256c0 26.47-21.53 48-48 48c-8.844 0-16 7.156-16 16s7.156 15.1 15.1 15.1C204.1 335.1 240 300.1 240 256L239.1 199.1C239.1 169.1 214.9 143.1 183.1 143.1zM184 224C170.8 224 160 213.2 160 200C160 186.8 170.8 176 184 176c13.23 0 24 10.77 24 24C208 213.2 197.2 224 184 224zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM327.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c8.627 0 16.7-2.111 24-5.596V256c0 26.47-21.53 48-48 48C295.2 304 288 311.2 288 320s7.156 15.1 15.1 15.1C348.1 335.1 384 300.1 384 256l-.0001-56C383.1 169.1 358.9 143.1 327.1 143.1zM328 224c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24C341.2 176 352 186.8 352 200C352 213.2 341.2 224 328 224z"],
    "comment-slash": [640, 512, [], "f4b3", "M320 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C111.5 313.1 96.06 277.6 96.06 240c0-23.41 5.969-45.72 16.58-66.18L87.29 153.8c-14.77 26.29-23.26 55.41-23.26 86.2c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C69.82 474.3 78.38 480 88 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c40.5 0 78.68-7.852 112.7-21.46l-29.49-23.28C377.5 411.4 349.5 416 320 416zM320 64c123.5 0 223.1 79 223.1 176c0 31.9-11.04 61.77-30.02 87.6l24.99 19.73C562.3 315.1 576 279.3 576 240c0-114.9-114.6-207.1-255.1-207.1c-51.04 0-98.47 12.28-138.4 33.2l27.81 21.96C242.1 72.5 279.8 64 320 64zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.938-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "comment-smile": [512, 512, [], "f4b4", "M192 216c13.25 0 24-10.75 24-24S205.3 168 192 168S168 178.8 168 192S178.8 216 192 216zM320 216c13.25 0 24-10.75 24-24S333.3 168 320 168S296 178.8 296 192S306.8 216 320 216zM331.8 285.3C313 307.4 285.4 320 256 320S199 307.4 180.3 285.4C174.5 278.8 164.4 278 157.8 283.6c-6.875 5.75-7.5 15.75-1.875 22.62c24.88 29 61.36 45.75 100.1 45.75s75.27-16.75 100.3-45.87c5.75-6.75 4.875-16.88-1.875-22.62C347.8 277.8 337.6 278.6 331.8 285.3zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M256 32C114.6 32 .0137 125.1 .0137 240c0 47.63 19.89 91.25 52.89 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.784 474.3 14.34 480 23.97 480c61.5 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.25-4.25-83.25-12.75l-15.12-4.875l-13 9.25c-23 16.25-58.5 35.25-102.6 39.63c11.1-15.12 29.75-40.5 40.75-69.63l7.125-18.75l-13.62-14.62C47.38 313.8 32.13 277.6 32.13 240c0-97 100.5-176 224-176s224 79 224 176S379.5 416 256 416zM132.4 224.6l-4.109-1.188C111.3 218.4 111.7 216.3 112.2 213.5C112.1 209 122.4 206.9 133.7 208.6c4.172 .6719 8.766 2.109 13.14 3.609c8.359 2.891 17.47-1.578 20.33-9.922c2.875-8.344-1.562-17.45-9.922-20.33C151 179.8 144.5 177.9 138.6 177C108.1 172.3 84.69 184.7 80.64 208.1c-5.703 33 26.48 42.45 38.61 46.02l4.328 1.25c21.12 6.031 20.8 7.922 20.25 11.08c-.7813 4.516-10.2 6.688-21.61 4.906c-5.672-.8438-11.88-3.203-17.5-5.234L101.3 264.9c-8.391-3-17.48 1.422-20.42 9.734C77.97 283 82.33 292.1 90.66 295.1l3.203 1.156C101.1 298.8 109.3 301.8 117.4 303c4.359 .6719 8.578 1.016 12.61 1.016c24.28 0 41.91-12.06 45.38-32.11C181.1 238.5 149.4 229.5 132.4 224.6zM388.4 224.6l-4.109-1.188c-16.94-4.984-16.56-7.141-16.09-9.875c.7813-4.531 10.3-6.688 21.48-4.938c4.172 .6719 8.766 2.109 13.14 3.609c8.312 2.891 17.45-1.578 20.33-9.922c2.875-8.344-1.562-17.45-9.922-20.33c-6.156-2.125-12.66-4.031-18.58-4.969C364 172.3 340.7 184.7 336.6 208.1c-5.703 33 26.48 42.45 38.61 46.02l4.328 1.25c21.12 6.031 20.8 7.922 20.25 11.08c-.7656 4.516-10.23 6.688-21.61 4.906c-5.672-.8438-11.88-3.203-17.5-5.234l-3.375-1.203c-8.359-3-17.5 1.422-20.42 9.734c-2.953 8.344 1.406 17.48 9.734 20.42l3.203 1.156c7.219 2.594 15.39 5.531 23.52 6.766c4.359 .6719 8.578 1.016 12.61 1.016c24.28 0 41.91-12.06 45.38-32.11C437.1 238.5 405.4 229.5 388.4 224.6zM309.1 176.8C302.5 174.6 295.3 176.9 291.2 182.4L256 229.3L220.8 182.4C216.7 176.9 209.5 174.6 202.9 176.8C196.4 178.1 192 185.1 192 192v96c0 8.844 7.156 16 16 16S224 296.8 224 288V240l19.19 25.59c6.031 8.062 19.59 8.062 25.62 0L288 240V288c0 8.844 7.156 16 16 16S320 296.8 320 288V192C320 185.1 315.6 178.1 309.1 176.8z"],
    "comment-text": [512, 512, [], "e14d", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM320 160H192C183.2 160 176 167.2 176 176S183.2 192 192 192h48v112C240 312.8 247.2 320 256 320s16-7.156 16-16V192H320c8.844 0 16-7.156 16-16S328.8 160 320 160z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM331.3 164.7c-6.25-6.25-16.38-6.25-22.62 0L256 217.4L203.3 164.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L233.4 240L180.7 292.7c-6.25 6.25-6.25 16.38 0 22.62c6.242 6.246 16.37 6.254 22.62 0L256 262.6l52.69 52.69c6.242 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L278.6 240l52.69-52.69C337.6 181.1 337.6 170.9 331.3 164.7z"],
    "comments": [640, 512, [61670, 128490], "f086", "M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4z"],
    "comments-dollar": [640, 512, [], "f653", "M212.4 160.6L206.8 159C179.7 151 180.5 146.3 181.6 139.8c1.891-10.91 19.22-13.41 34.81-10.91c5.812 .9062 12.22 2.906 18.3 5.031c8.375 2.875 17.47-1.531 20.36-9.875c2.906-8.344-1.516-17.47-9.859-20.38c-8.471-2.934-15.2-4.709-21.25-5.832V88c0-8.838-7.138-16-15.98-16c-8.836 0-16.02 7.162-16.02 16v9.275C169.4 101 153.6 114.2 150.1 134.4C143.3 173.7 181.5 184.9 197.8 189.7l5.781 1.688c28.67 8.188 32.33 11.81 30.77 20.81c-1.891 10.94-19.31 13.34-34.84 10.91C192.2 221.1 183.1 218.7 175.1 215.8L170.6 214.3C162.3 211.3 153.2 215.7 150.2 224C147.3 232.3 151.7 241.5 159.1 244.4l4.279 1.531c8.588 3.086 18.22 6.355 27.72 8.119V264c0 8.836 7.188 16 16.02 16c8.838 0 15.98-7.164 15.98-16V254.3c22.4-3.824 38.41-16.58 41.89-36.66C272.7 177.9 234.1 167.1 212.4 160.6zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320z"],
    "comments-question": [640, 512, [], "e14e", "M208 224C196.1 224 188 232.1 188 244c0 11.04 8.955 20 20 20s20-8.955 20-20C228 232.1 219 224 208 224zM224.6 80H188.2C163.8 80 144 99.84 144 124.2c0 8.844 7.156 16 16 16s16-7.156 16-16C176 117.5 181.5 112 188.2 112h36.36C233.1 112 240 118.9 240 127.4c0 5.875-3.266 11.16-8.734 13.89L200.6 157.2C195.3 159.1 192 165.4 192 171.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V181.1l21.78-11.31C261.1 161.8 272 145.5 272 127.4C272 101.3 250.7 80 224.6 80zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4z"],
    "comments-question-check": [640, 512, [], "e14f", "M208 224C196.1 224 188 232.1 188 244c0 11.04 8.955 20 20 20s20-8.955 20-20C228 232.1 219 224 208 224zM224.6 80H188.2C163.8 80 144 99.84 144 124.2c0 8.844 7.156 16 16 16s16-7.156 16-16C176 117.5 181.5 112 188.2 112h36.36C233.1 112 240 118.9 240 127.4c0 5.875-3.266 11.16-8.734 13.89L200.6 157.2C195.3 159.1 192 165.4 192 171.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V181.1l21.78-11.31C261.1 161.8 272 145.5 272 127.4C272 101.3 250.7 80 224.6 80zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4zM388.7 338c-6.25 6.25-6.25 16.38 0 22.62L426 398c3 3 7.062 4.688 11.31 4.688S445.6 401 448.6 398l82.67-82.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-71.36 71.38l-26.02-26.03C405.1 331.8 394.9 331.8 388.7 338z"],
    "compact-disc": [512, 512, [128192, 128440, 128191], "f51f", "M256 232C242.8 232 232 242.8 232 256S242.8 280 256 280S280 269.3 280 256S269.2 232 256 232zM272 96c0-8.844-7.156-15.91-16-15.91c-97.05 0-176 78.88-176 175.9c0 8.844 7.156 16 16 16S112 264.8 112 256c0-79.41 64.59-144 144-144C264.8 112 272 104.8 272 96zM256 159.1c-53.02 0-96 43-96 96s42.98 95.1 96 95.1s96-43 96-95.1S309 159.1 256 159.1zM256 320c-35.33 0-64-28.75-64-64s28.67-64 64-64s64 28.75 64 64S291.3 320 256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "compass": [512, 512, [129517], "f14e", "M232 256C232 242.7 242.7 232 256 232C269.3 232 280 242.7 280 256C280 269.3 269.3 280 256 280C242.7 280 232 269.3 232 256zM348.6 122.9C373.6 114.6 397.4 138.4 389.1 163.4L340.2 309.9C335.5 324.2 324.2 335.5 309.9 340.2L163.4 389.1C138.4 397.4 114.6 373.6 122.9 348.6L171.8 202.1C176.5 187.8 187.8 176.5 202.1 171.8L348.6 122.9zM358.7 153.3L212.2 202.1C207.5 203.7 203.7 207.5 202.1 212.2L153.3 358.7L299.8 309.9C304.5 308.3 308.3 304.5 309.9 299.8L358.7 153.3zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M298.3 182.2C285.5 188.5 271.2 192 255.1 192C240.8 192 226.5 188.5 213.7 182.2L142.2 307.4C176.1 325.6 214.8 336 255.1 336C344.8 336 422.4 287.8 463.9 215.1C468.3 208.3 478.1 205.7 485.8 210.2C493.4 214.6 496 224.4 491.6 232C444.6 313.3 356.7 368 255.1 368C209 368 164.9 356.1 126.3 335.2L29.89 503.9C25.51 511.6 15.73 514.3 8.06 509.9C.3882 505.5-2.277 495.7 2.107 488.1L99.15 318.2C67.07 295.6 40.13 266.1 20.4 232C15.97 224.4 18.59 214.6 26.24 210.2C33.88 205.7 43.67 208.3 48.1 215.1C65.01 245.2 87.91 270.6 115.1 290.3L187.6 163.4C170.5 146.1 159.1 122.3 159.1 96C159.1 42.98 202.1 0 255.1 0C309 0 352 42.98 352 96C352 122.3 341.5 146.1 324.4 163.4L372.7 248.1C377.1 255.7 374.5 265.5 366.8 269.9C359.1 274.3 349.3 271.6 344.1 263.9L298.3 182.2zM255.1 32C220.7 32 191.1 60.65 191.1 96C191.1 131.3 220.7 160 255.1 160C291.3 160 320 131.3 320 96C320 60.65 291.3 32 255.1 32zM408.1 375.9C404.6 368.3 407.2 358.5 414.9 354.1C422.6 349.7 432.4 352.4 436.7 360.1L509.9 488.1C514.3 495.7 511.6 505.5 503.9 509.9C496.3 514.3 486.5 511.6 482.1 503.9L408.1 375.9z"],
    "compass-slash": [640, 512, [], "f5e9", "M633.9 483.4C640.9 488.9 642 498.1 636.6 505.9C631.1 512.9 621 514 614.1 508.6L6.086 28.56C-.8493 23.08-2.033 13.02 3.443 6.086C8.918-.8493 18.98-2.033 25.91 3.443L633.9 483.4zM448.8 439.3L474.9 459.8C431.9 492.6 378.2 512 319.1 512C178.6 512 63.1 397.4 63.1 256C63.1 219.2 71.76 184.2 85.74 152.6L111.8 173.2C101.6 198.8 95.1 226.7 95.1 256C95.1 379.7 196.3 480 319.1 480C367.1 480 412.4 464.9 448.8 439.3V439.3zM576 256C576 292.8 568.2 327.8 554.3 359.4L528.2 338.8C538.4 313.2 544 285.3 544 256C544 132.3 443.7 32 319.1 32C272 32 227.6 47.07 191.2 72.74L165.1 52.17C208.1 19.43 261.8 .0006 319.1 .0006C461.4 .0006 576 114.6 576 256V256zM186.9 348.6L217.6 256.7L244.3 277.8L217.3 358.7L308.4 328.3L338.4 352.1L227.4 389.1C202.4 397.4 178.6 373.6 186.9 348.6H186.9zM412.6 122.9C437.6 114.6 461.4 138.4 453.1 163.4L422.4 255.3L395.7 234.2L422.7 153.3L331.6 183.7L301.6 159.9L412.6 122.9z"],
    "compress": [448, 512, [], "f066", "M144 320h-128C7.156 320 0 327.2 0 336S7.156 352 16 352H128v112C128 472.8 135.2 480 144 480S160 472.8 160 464v-128C160 327.2 152.8 320 144 320zM304 192h128C440.8 192 448 184.8 448 176S440.8 160 432 160H320V48C320 39.16 312.8 32 304 32S288 39.16 288 48v128C288 184.8 295.2 192 304 192zM432 320h-128c-8.844 0-16 7.156-16 16v128c0 8.844 7.156 16 16 16s16-7.156 16-16V352h112c8.844 0 16-7.156 16-16S440.8 320 432 320zM144 32C135.2 32 128 39.16 128 48V160H16C7.156 160 0 167.2 0 176S7.156 192 16 192h128C152.8 192 160 184.8 160 176v-128C160 39.16 152.8 32 144 32z"],
    "compress-wide": [512, 512, [], "f326", "M368 224h128C504.8 224 512 216.8 512 208S504.8 192 496 192H384V80C384 71.16 376.8 64 368 64S352 71.16 352 80v128C352 216.8 359.2 224 368 224zM144 288h-128C7.156 288 0 295.2 0 304S7.156 320 16 320H128v112C128 440.8 135.2 448 144 448S160 440.8 160 432v-128C160 295.2 152.8 288 144 288zM496 288h-128C359.2 288 352 295.2 352 304v128c0 8.844 7.156 16 16 16s16-7.156 16-16V320h112c8.844 0 16-7.156 16-16S504.8 288 496 288zM144 64C135.2 64 128 71.16 128 80V192H16C7.156 192 0 199.2 0 208S7.156 224 16 224h128C152.8 224 160 216.8 160 208v-128C160 71.16 152.8 64 144 64z"],
    "computer": [640, 512, [], "e4e5", "M0 320V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V320C448 355.3 419.3 384 384 384H286.2L307.5 448H368C376.8 448 384 455.2 384 464C384 472.8 376.8 480 368 480H80C71.16 480 64 472.8 64 464C64 455.2 71.16 448 80 448H140.5L161.8 384H64C28.65 384 0 355.3 0 320H0zM384 64H64C46.33 64 32 78.33 32 96V320C32 337.7 46.33 352 64 352H384C401.7 352 416 337.7 416 320V96C416 78.33 401.7 64 384 64zM273.8 448L252.5 384H195.5L174.2 448H273.8zM536 336C536 322.7 546.7 312 560 312C573.3 312 584 322.7 584 336C584 349.3 573.3 360 560 360C546.7 360 536 349.3 536 336zM480 80C480 53.49 501.5 32 528 32H592C618.5 32 640 53.49 640 80V432C640 458.5 618.5 480 592 480H528C501.5 480 480 458.5 480 432V80zM512 80V128H608V80C608 71.16 600.8 64 592 64H528C519.2 64 512 71.16 512 80zM512 160V192H608V160H512zM528 448H592C600.8 448 608 440.8 608 432V224H512V432C512 440.8 519.2 448 528 448z"],
    "computer-classic": [448, 512, [], "f8b1", "M384 0H64C28.8 0 0 28.8 0 64v320c0 23.63 12.95 44.04 32 55.12V480c0 17.66 14.34 32 32 32h320c17.66 0 32-14.34 32-32v-40.88C435 428 448 407.6 448 384V64C448 28.8 419.2 0 384 0zM384 480H64v-32h320V480zM416 384c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V384zM319.1 64h-192c-35.35 0-64 28.65-64 64L64 192c0 35.35 28.65 64 63.1 64h192C355.3 256 384 227.3 384 192l0-64C383.1 92.65 355.3 64 319.1 64zM352 192c0 17.64-14.36 32-32 32H128C110.4 224 96 209.6 96 192V128c0-17.64 14.36-32 32-32h192c17.64 0 32 14.36 32 32V192zM96 312c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C120 322.7 109.3 312 96 312zM368 320h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S376.8 320 368 320z"],
    "computer-mouse": [384, 512, [128433, "mouse"], "f8cc", "M224 0H160C71.63 0 0 71.62 0 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM32 160c.125-70.62 57.38-127.9 128-128h16v160H32V160zM352 352c-.125 70.63-57.38 127.9-128 128H160c-70.63-.125-127.9-57.38-128-128V224h320V352zM352 192h-144V32H224c70.63 .125 127.9 57.38 128 128V192z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M224 0H160c-88.38 0-160 71.63-160 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM352 352c-.125 70.63-57.38 127.9-128 128H160c-70.63-.125-127.9-57.38-128-128V160c.125-70.63 57.38-127.9 128-128h64c70.63 .125 127.9 57.38 128 128V352zM192 95.1c-8.844 0-16 7.156-16 16v64C176 184.8 183.2 192 192 192s16-7.156 16-16v-64C208 103.2 200.8 95.1 192 95.1z"],
    "computer-speaker": [640, 512, [], "f8b2", "M480 192c26.5 0 48-21.5 48-48S506.5 96 480 96s-48 21.5-48 48S453.5 192 480 192zM480 128c8.875 0 16 7.125 16 16S488.9 160 480 160s-16-7.125-16-16S471.1 128 480 128zM480 224c-53 0-96 43-96 96s43 96 96 96s96-43 96-96S533 224 480 224zM480 384c-35.38 0-64-28.62-64-64s28.62-64 64-64s64 28.62 64 64S515.4 384 480 384zM480 296c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S493.3 296 480 296zM576 32h-192c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM608 416c0 17.67-14.33 32-32 32h-192c-17.67 0-32-14.33-32-32V96c0-17.67 14.33-32 32-32h192c17.67 0 32 14.33 32 32V416zM48 64h224C280.8 64 288 56.84 288 48S280.8 32 272 32H47.1c-26.47 0-48 21.53-48 48L0 336C0 362.5 21.53 384 48 384h224C280.8 384 288 376.8 288 368S280.8 352 272 352h-224C39.17 352 32 344.8 32 336v-256C32 71.19 39.17 64 48 64zM272 448h-160C103.2 448 96 455.2 96 464S103.2 480 112 480h160C280.8 480 288 472.8 288 464S280.8 448 272 448z"],
    "container-storage": [640, 512, [], "f4b7", "M368 416c8.844 0 16-7.156 16-16v-288C384 103.2 376.8 96 368 96S352 103.2 352 112v288C352 408.8 359.2 416 368 416zM464 416c8.844 0 16-7.156 16-16v-288C480 103.2 472.8 96 464 96S448 103.2 448 112v288C448 408.8 455.2 416 464 416zM272 416C280.8 416 288 408.8 288 400v-288C288 103.2 280.8 96 272 96S256 103.2 256 112v288C256 408.8 263.2 416 272 416zM624 448H608V64h16C632.8 64 640 56.84 640 48S632.8 32 624 32h-608C7.156 32 0 39.16 0 48S7.156 64 16 64H32v384H16C7.156 448 0 455.2 0 464S7.156 480 16 480h608c8.844 0 16-7.156 16-16S632.8 448 624 448zM576 448H64V64h512V448zM176 416C184.8 416 192 408.8 192 400v-288C192 103.2 184.8 96 176 96S160 103.2 160 112v288C160 408.8 167.2 416 176 416z"],
    "conveyor-belt": [640, 512, [], "f46e", "M544 320h-448c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM192 288h256c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v160C128 259.3 156.7 288 192 288zM272 32h96v70.13l-40.84-20.44c-4.5-2.25-9.812-2.25-14.31 0L272 102.1V32zM160 64c0-17.64 14.36-32 32-32h48v96c0 5.531 2.875 10.69 7.594 13.62c4.656 2.812 10.59 3.156 15.56 .6875L320 113.9l56.84 28.44C379.1 143.4 381.6 144 384 144c2.938 0 5.844-.8125 8.406-2.375C397.1 138.7 400 133.5 400 128V32H448c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H192C174.4 256 160 241.6 160 224V64zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M128 288h160c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64H128C92.65 0 64 28.65 64 64v160C64 259.3 92.65 288 128 288zM96 64c0-17.64 14.36-32 32-32h160c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H128C110.4 256 96 241.6 96 224V64zM448 288h64c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64h-64c-35.35 0-64 28.65-64 64v96C384 259.3 412.7 288 448 288zM416 128c0-17.64 14.36-32 32-32h64c17.64 0 32 14.36 32 32v96c0 17.64-14.36 32-32 32h-64c-17.64 0-32-14.36-32-32V128zM544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "conveyor-belt-empty": [640, 512, [], "e150", "M544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "cookie": [512, 512, [127850], "f563", "M191.1 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S205.2 328 191.1 328zM183.1 192c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S183.1 205.3 183.1 192zM287.1 232c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S301.2 232 287.1 232zM343.1 128c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S343.1 141.3 343.1 128zM351.1 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.2 328 351.1 328zM494.5 254.8l-11.37-71.48c-4.102-25.9-16.29-49.8-34.8-68.32l-51.33-51.33c-18.51-18.52-42.3-30.7-68.2-34.8L256.9 17.53C250.5 16.47 244 16 237.6 16c-19.45 0-38.67 4.573-56.13 13.48L116.7 62.53c-23.32 11.84-42.3 30.82-54.26 54.14L29.51 181.2C17.56 204.7 13.43 231.2 17.53 257.2l11.37 71.48C32.1 354.6 45.18 378.5 63.7 397.1l51.33 51.33c18.51 18.52 42.3 30.61 68.2 34.72l71.84 11.37C261.5 495.5 267.1 496 274.4 496c19.45 0 38.67-4.573 56.13-13.48l64.8-33.05c23.32-11.84 42.3-30.82 54.26-54.14l32.81-64.57C494.4 307.3 498.6 280.8 494.5 254.8zM453.9 316.3l-32.76 64.47c-8.959 17.48-22.88 31.38-40.32 40.23l-64.81 33.05C303.2 460.5 288.8 464 274.4 464c-4.996 0-9.631-.3613-14.33-1.131l-71.83-11.37c-19.24-3.047-36.73-11.98-50.58-25.83l-51.33-51.33c-13.83-13.83-22.76-31.37-25.83-50.72l-11.36-71.44C46.08 232.8 49.18 213.3 58.12 195.7l32.76-64.47c8.959-17.48 22.88-31.38 40.32-40.23l64.81-33.05C208.8 51.45 223.2 48 237.6 48c4.996 0 9.631 .3613 14.33 1.129l71.83 11.37c19.24 3.047 36.73 11.98 50.58 25.83l51.33 51.33c13.83 13.83 22.76 31.37 25.83 50.72l11.36 71.44C465.9 279.2 462.8 298.7 453.9 316.3z"],
    "cookie-bite": [512, 512, [], "f564", "M184 192c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S184 205.3 184 192zM288 232c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S301.3 232 288 232zM192 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S205.3 328 192 328zM352 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.3 328 352 328zM494.6 255.9c-65.63-.8203-118.6-54.14-118.6-119.9c-65.74 0-119.1-52.97-119.8-118.6C250 16.47 243.7 16 237.5 16c-19.34 0-38.54 4.573-56 13.48L116.7 62.41C93.35 74.36 74.36 93.35 62.41 116.7L29.6 181.2C17.64 204.7 13.42 231.2 17.53 257.2l11.37 71.48c4.102 25.9 16.29 49.8 34.81 68.32l51.36 51.39c18.52 18.4 42.27 30.64 68.18 34.75l71.84 11.37C261.5 495.5 268 496 274.5 496c19.34 0 38.71-4.573 56.17-13.48l64.81-33.05c23.32-11.84 42.31-30.82 54.14-54.14l32.93-64.57C494.3 307.7 498.5 281.4 494.6 255.9zM454 316.2l-32.96 64.63c-8.703 17.15-22.94 31.38-40.14 40.12l-64.81 33.05C303.3 460.5 288.9 464 274.5 464c-5.004 0-9.811-.3711-14.45-1.131l-71.83-11.37c-19.23-3.045-36.75-11.96-50.56-25.68l-51.36-51.47c-13.83-13.83-22.76-31.36-25.83-50.72l-11.36-71.44C46.08 232.8 49.18 213.3 58.12 195.7l32.76-64.47C99.84 113.8 113.8 99.83 131.2 90.93l64.85-32.95c9.895-5.047 20.71-8.256 31.72-9.453c12.9 58.74 60.05 104.1 119.1 116.6c11.65 59 57.88 106.2 116.6 119.2C462.2 295.4 459.1 306.3 454 316.2z"],
    "copy": [512, 512, [], "f0c5", "M272 416C263.2 416 256 423.2 256 432V448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192c0-17.67 14.33-32 32-32h112C184.8 160 192 152.8 192 144C192 135.2 184.8 128 176 128H63.99c-35.35 0-64 28.65-64 64l.0098 256C0 483.3 28.65 512 64 512h160c35.35 0 64-28.65 64-64v-16C288 423.2 280.8 416 272 416zM502.6 86.63l-77.25-77.25C419.4 3.371 411.2 0 402.7 0H288C252.7 0 224 28.65 224 64v256c0 35.35 28.65 64 64 64h160c35.35 0 64-28.65 64-64V109.3C512 100.8 508.6 92.63 502.6 86.63zM416 45.25L466.7 96H416V45.25zM480 320c0 17.67-14.33 32-32 32h-160c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h96l.0026 64c0 17.67 14.33 32 32 32H480V320z"],
    "copyright": [512, 512, [169], "f1f9", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM323.9 188.1c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62c-48.31-48.38-132.7-48.38-181 0C141.3 189.7 128 221.8 128 256s13.31 66.34 37.5 90.5C189.7 370.7 221.8 384 256 384s66.34-13.31 90.5-37.5c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0c-36.25 36.25-99.5 36.25-135.8 0C169.1 305.8 160 281.7 160 256s9.1-49.75 28.12-67.88C224.4 151.9 287.6 151.9 323.9 188.1z"],
    "corn": [512, 512, [127805], "f6c7", "M446 0c-12.88 0-25.25 3.75-35.63 10.62c-15.38-4.123-28.13-1.498-34.88 .5c-10.38 3-19.88 8.375-27.63 15.88c-6.25-.375-17.62-.375-30.5 5.125c-10 4.5-18.5 11.12-25 19.25c-10.5 .5-20.75 3.625-29.75 9C254.4 64.96 247.5 71.64 242.1 79.28c8.021 11.7 14.73 23.34 20.2 34.82c.0234 .0098-.0234-.0078 0 0c.875-10.5 6.801-20.61 16.68-26.24c15.88-9.373 30.88-1.498 31.38-1.373c1.875-10.38 8.752-20.12 19.5-24.88c13.5-5.75 25.5-1.375 31.62 2.625c3.252-10.62 11.75-19.25 23-22.5c3-.875 18.62-5 32.13 8.123C422.4 38.1 433.5 31.1 446 31.1c.5 0 33.88-1 33.88 37.87c-.5 12.88-8 23.62-18.5 28.1c7.5 8.25 11 20.38 7.5 32.12c-3.5 11.25-12.38 19.5-22.75 22.75c5.875 9.125 7.25 20.87 2.375 31.62c-4.75 10.75-14.38 17.38-25.12 19.25c4.875 9.625 4.5 21.5-1.375 31.38c-4.5 7.898-11.92 13.09-20.19 15.36c10.52 5.207 21.08 11.43 31.7 18.79c6.52-5.135 12.24-11.16 16.37-18.4c5.25-8.873 8.252-18.75 8.877-28.87c8-6.375 14.62-14.75 19-24.37c4.375-9.875 6.25-20.62 5.625-31c7.375-7.623 13-16.87 16.12-26.1c3.252-11.25 3.502-23.12 .75-34.5C528.3 65.25 504.6 0 446 0zM446.9 322.5c-69.92-70.92-158.4-66.87-161.3-66.87c-10.75 0-21.38 1.125-31.88 2.5c1.5-10.5 2.5-20.1 2.5-31.87c0-2.887 4.672-89.69-66.75-161.1L168.4 43.1c-9-9.125-24.5-4.375-27 8.123L117.6 170.9L36.99 251.5c-20 20.12-34 46.12-36.5 74.5c-3.125 34.87 9 68.25 33.5 92.62L96.11 480.8l.375-.25c27.38 25.5 64.75 36.87 103.3 28.88c22.88-4.75 43.5-17.25 60-33.75l81.25-81.37l118.9-23.75c12.5-2.5 17.12-17.1 8.125-26.1L446.9 322.5zM56.61 277.2l90.5-90.5l19.75-98.99c48.38 48.25 65.38 115.4 52.5 177.6c-35.5 10.75-68 30.12-94.88 57.12l-70.5 70.37C24.11 359.9 24.73 308.1 56.61 277.2zM325.2 364.9l-90.5 90.5c-16.38 16.38-37.88 24.62-59.38 24.62c-21.5 0-43-8.248-59.38-24.62l-39.63-39.62l70.75-70.62c38.25-38.25 88.38-57.5 138.5-57.5s100.4 19.25 138.6 57.5L325.2 364.9z"],
    "corner": [448, 512, [], "e3fe", "M432 384c-8.844 0-16-7.156-16-16V192H16C7.156 192 0 184.8 0 176S7.156 160 16 160h416C440.8 160 448 167.2 448 176v192C448 376.8 440.8 384 432 384z"],
    "couch": [640, 512, [], "f4b8", "M576 224c-35.35 0-64 28.65-64 64h-384c0-35.35-28.65-64-64-64s-64 28.65-64 64v160c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32h384c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V288C640 252.7 611.3 224 576 224zM96 448H32V288c0-17.64 14.36-32 32-32s32 14.36 32 32V448zM511.1 416h-384L128 320h384L511.1 416zM608 448h-64V288c0-17.64 14.36-32 32-32s32 14.36 32 32V448zM80 192C88.84 192 96 184.8 96 176v-32C96 99.88 131.9 64 176 64h288C508.1 64 544 99.88 544 144v32C544 184.8 551.2 192 560 192S576 184.8 576 176v-32C576 82.25 525.8 32 464 32h-288C114.3 32 64 82.25 64 144v32C64 184.8 71.16 192 80 192z"],
    "cow": [640, 512, [128004], "f6c8", "M633.1 279.6L624 265.5V210.6c0-19.38-15.75-35.12-35.13-35.12c-9 0-14.25 2.875-23.62 7.625l-56.5-79.42C490.6 78.83 461.8 64 431 64H112C67.88 64 32 99.88 32 144v88.88C13 244 0 264.4 0 288v32c35.38 0 64-28.62 64-64V144c0-23.88 17.62-43.62 40.5-47.25C99.25 106 96 116.6 96 128L96 416c0 17.62 14.38 32 32 32h48C193.6 448 208 433.6 208 416v-51.63c7.25 3 15.62 5 24 6.875L232.1 392c0 8.875 7.25 16 16 16c8.875 0 16-7.125 16-16L264 375.2C266.8 375.4 269.2 376 272 376s5.25-.625 8-.75L280.1 392c0 8.875 7.25 16 16 16c8.875 0 16-7.125 16-16L312 371.2c8.375-1.875 16.75-3.875 24-6.875V416c0 17.62 14.38 32 32 32h48C433.6 448 448 433.6 448 416V272L480 288L480 330c0 12.25 3.5 24.38 10.25 34.75l35.38 54.87C537.1 437.2 556.8 448 577.8 448C612.1 448 640 420.2 640 385.9V298.2C640 291.6 637.9 285.1 633.1 279.6zM212.8 96h118.5c17.5 0 27.13 19.75 15.88 32.75C307 175.2 289.2 176 272 176H271c-17.25 0-33.88-.375-74.12-47.25C185.6 115.8 195.2 96 212.8 96zM208.6 330.2C211.6 297.6 238.8 272 272 272s60.38 25.62 63.38 58.25C321.2 335.9 277.1 357.9 208.6 330.2zM608 385.9C608 402.5 594.5 416 577.8 416c-10.25 0-19.62-5.125-25.25-13.75l-35.38-54.87C513.8 342.2 512 336.2 512 329.1v-51.84c0-6.06-3.424-11.6-8.845-14.31l-64-31.1C428.5 226.5 416 234.2 416 246.1V416h-48v-80c0-30.88-25.5-96-96-96c-70.88 0-95.1 64.5-95.1 96L176 416H128V128c0-17.62 14.38-32 32-32h4.25C156.6 114.1 159.6 134.6 172.6 149.8C214.9 198.8 239.8 208 271 208c32.88 0 58.13-9.25 100.4-58.25c13-15.13 16-35.63 8.375-53.75H431c20.38 0 39.75 9.875 51.63 26.25l78.63 110.4C565.8 215.5 580.3 208 584 208c4.25 0 8 3.375 8 8.125v59.63L608 298.2V385.9zM568 304c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S576.9 304 568 304z"],
    "cowbell": [448, 512, [], "f8b3", "M447.3 456.1l-53.34-320C390.1 112.9 370.2 96 346.6 96h-26.65l.0011-48c0-26.47-21.53-48-48-48H176.1C149.7 0 128.1 21.53 128.1 48L128.1 96H101.3C77.77 96 57.87 112.9 54.01 136.1l-53.34 320C-4.211 485.3 18.31 512 48.02 512h351.9C429.4 512 452.3 485.6 447.3 456.1zM160 48c0-8.812 7.168-16 15.1-16h96c8.828 0 16.01 7.188 16.01 16V96H160V48zM399.1 480H48.02c-12.59 0-16.92-11.82-15.79-18.62l53.34-320C86.85 133.6 93.49 128 101.3 128h245.3c7.859 0 14.5 5.625 15.78 13.38l53.34 320C416.9 468.2 412.7 480 399.1 480z"],
    "cowbell-circle-plus": [576, 512, ["cowbell-more"], "f8b4", "M432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM432 480C370.2 480 320 429.8 320 368S370.2 256 432 256C493.8 256 544 306.2 544 368S493.8 480 432 480zM496 352H448V304C448 295.2 440.8 288 432 288S416 295.2 416 304V352h-48c-8.836 0-15.1 7.164-15.1 16S359.2 384 368 384H416v48c0 8.836 7.165 16 16 16S448 440.8 448 432V384h48c8.836 0 16-7.164 16-16S504.8 352 496 352zM288 480H48.02c-12.59 0-16.92-11.82-15.79-18.62l53.34-320C86.85 133.6 93.49 128 101.3 128h245.3c7.82 0 14.49 5.652 15.78 13.37l6.213 37.27C369.9 186.3 376.6 192 384.4 192c9.885 0 17.4-8.877 15.78-18.63l-6.213-37.27C390.1 112.1 370.1 96 346.6 96h-26.65L320 48C320 21.49 298.5 0 272 0H176.1c-26.51 0-48 21.49-48 48L128.1 96h-26.72C77.77 96 57.87 112.9 54.01 136.1l-53.34 320C-4.211 485.3 18.31 512 48.02 512h239.1C296.8 512 304 504.8 304 496S296.8 480 288 480zM160 48C160 39.19 167.2 32 176 32h96c8.828 0 16.01 7.188 16.01 16V96H160V48z"],
    "crab": [512, 512, [129408], "e3ff", "M512 157.2V112C512 50.25 461.8 0 400 0h-64c-6.875 0-13 4.406-15.19 10.94c-2.156 6.531 .0625 13.73 5.594 17.86l64 48c7.062 5.297 17.09 3.938 22.41-3.203c5.281-7.062 3.844-17.09-3.219-22.39L384 32h16c38.63 0 70.97 27.53 78.41 64H384c-9.094 0-17.78-3.891-23.84-10.66c-5.906-6.609-16-7.156-22.59-1.281c-6.594 5.891-7.156 16.02-1.281 22.59C348.4 120.2 365.8 128 383.1 128H480v29.17c0 5.797-3.156 11.16-8.25 13.98l-85.52 47.52c-18.82-14.17-41.47-23.17-66.23-25.51L320 144C320 135.2 312.8 128 304 128S288 135.2 288 144V192H224.1L224 144C224 135.2 216.8 128 208 128S192 135.2 192 144l.001 49.17C167.2 195.5 144.6 204.5 125.8 218.7L40.25 171.2C35.16 168.3 32 162.1 32 157.2V128h96c18.22 0 35.59-7.781 47.72-21.34c5.875-6.578 5.312-16.7-1.281-22.59C167.8 78.19 157.8 78.73 151.8 85.34C145.8 92.11 137.1 96 128 96H33.59C41.03 59.53 73.38 32 112 32H128L102.4 51.2c-7.062 5.297-8.5 15.33-3.219 22.39c5.344 7.109 15.38 8.484 22.41 3.203l64-48c5.531-4.125 7.75-11.33 5.594-17.86C189 4.406 182.9 0 176 0h-64C50.25 0 0 50.25 0 112v45.17c0 17.42 9.469 33.5 24.69 41.95L101.9 242.1C94.66 251.2 88.14 261.1 83.5 272H51.78L23.16 257.7c-7.906-3.891-17.5-.7656-21.47 7.156C-2.25 272.8 .9375 282.4 8.844 286.3l32 16C43.06 303.4 45.53 304 48 304h27.07c-.9277 6.297-1.908 12.58-1.908 19.14c0 2.91 .9768 5.617 1.649 8.4l-15.88 5.291c-2.344 .7813-4.5 2.109-6.25 3.859l-32 32c-6.25 6.25-6.25 16.38 0 22.62C23.81 398.4 27.91 400 32 400s8.188-1.562 11.31-4.688l29.34-29.33l21.14-7.049l30.71 30.71l-33.56 11.19c-2.344 .7813-4.5 2.109-6.25 3.859l-32 32c-6.25 6.25-6.25 16.38 0 22.62C55.81 462.4 59.91 464 64 464s8.188-1.562 11.31-4.688l29.34-29.33l45.14-15.05l16.84 16.84l-30.85 18.51C130.9 453.2 128 458.4 128 464v32C128 504.8 135.2 512 144 512S160 504.8 160 496v-22.94L201.8 448h108.5L352 473.1V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-32c0-5.625-2.938-10.83-7.781-13.72l-30.85-18.51l16.84-16.84l45.13 15.05l29.34 29.33C439.8 462.4 443.9 464 448 464s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-32-32c-1.75-1.75-3.906-3.078-6.25-3.859l-33.56-11.19l30.71-30.71l21.14 7.049l29.34 29.33C471.8 398.4 475.9 400 480 400s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-32-32c-1.75-1.75-3.906-3.078-6.25-3.859l-15.88-5.291c.6719-2.783 1.668-5.49 1.668-8.4c0-6.555-1-12.84-1.928-19.14H464c2.469 0 4.938-.5781 7.156-1.688l32-16c7.906-3.953 11.09-13.56 7.156-21.47c-3.969-7.922-13.53-11.08-21.47-7.156L460.2 272H428.5c-4.641-10.95-11.16-20.76-18.45-29.95l77.26-42.93C502.5 190.7 512 174.6 512 157.2zM405.5 326.4l-88.29 88.29C316.4 415.5 315.2 416 313.1 416H198c-1.203 0-2.381-.4883-3.232-1.34l-88.29-88.29c-.8633-.8633-1.34-2.014-1.34-3.234C105.1 268.5 149.6 224 204.3 224h103.4c54.66 0 99.14 44.47 99.14 99.14C406.9 324.4 406.4 325.5 405.5 326.4z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M336.4 126.4l15.58 8.703l15.63-8.701c54.78-30.58 67.04-3.746 67.66-2.871C446.8 140.4 449.8 171.4 446.2 192h32.15C488.6 121.3 449.7 43.84 352 98.39c-24.04-13.42-44.48-18.79-61.55-18.29c8.387 9.725 14.44 21.88 19.34 34.9C317.4 117.2 325.9 120.5 336.4 126.4zM432 287.1c-8.875 0-16 7.123-16 15.1s7.125 16 16 16S448 312.9 448 303.1S440.9 287.1 432 287.1zM65.82 192C62.16 171.4 65.17 140.4 76.73 123.5c.625-.873 12.88-27.7 67.66 2.871l15.58 8.703l15.63-8.701c54.78-30.58 67.04-3.746 67.66-2.871C254.8 140.4 257.8 171.4 254.2 192l32.11 .0003C296.6 121.3 257.7 43.75 160 98.3C62.29 43.75 23.43 121.3 33.71 192L65.82 192zM368 64c4.094 0 8.188-1.562 11.31-4.688l32-32c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-32 32c-6.25 6.25-6.25 16.38 0 22.62C359.8 62.44 363.9 64 368 64zM176 64c4.094 0 8.188-1.562 11.31-4.688l32-32c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-32 32c-6.25 6.25-6.25 16.38 0 22.62C167.8 62.44 171.9 64 176 64zM80 287.1c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S96 312.9 96 303.1S88.88 287.1 80 287.1zM432 447.1c8.875 0 16-7.125 16-16s-7.125-16-16-16S416 423.1 416 431.1S423.1 447.1 432 447.1zM472 224H40C17.91 224 0 241.9 0 264v208C0 494.1 17.91 512 40 512h432c22.09 0 40-17.91 40-40v-208C512 241.9 494.1 224 472 224zM480 464c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464V384h448V464zM480 352H32V272C32 263.2 39.16 256 48 256h416C472.8 256 480 263.2 480 272V352zM80 447.1c8.875 0 16-7.126 16-16s-7.125-16-16-16S64 423.1 64 431.1S71.13 447.1 80 447.1z"],
    "crate-empty": [512, 512, [], "e151", "M432 287.1c-8.875 0-16 7.123-16 15.1s7.125 16 16 16S448 312.9 448 303.1S440.9 287.1 432 287.1zM80 287.1c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S96 312.9 96 303.1S88.88 287.1 80 287.1zM432 447.1c8.875 0 16-7.125 16-16s-7.125-16-16-16S416 423.1 416 431.1S423.1 447.1 432 447.1zM472 224H40C17.91 224 0 241.9 0 264v208C0 494.1 17.91 512 40 512h432c22.09 0 40-17.91 40-40v-208C512 241.9 494.1 224 472 224zM480 464c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464V384h448V464zM480 352H32V272C32 263.2 39.16 256 48 256h416C472.8 256 480 263.2 480 272V352zM80 447.1c8.875 0 16-7.126 16-16s-7.125-16-16-16S64 423.1 64 431.1S71.13 447.1 80 447.1z"],
    "credit-card": [576, 512, [62083, 128179, "credit-card-alt"], "f09d", "M96 368C96 359.2 103.2 352 112 352H176C184.8 352 192 359.2 192 368C192 376.8 184.8 384 176 384H112C103.2 384 96 376.8 96 368zM224 368C224 359.2 231.2 352 240 352H368C376.8 352 384 359.2 384 368C384 376.8 376.8 384 368 384H240C231.2 384 224 376.8 224 368zM0 96C0 60.65 28.65 32 64 32H512C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96zM32 96V128H544V96C544 78.33 529.7 64 512 64H64C46.33 64 32 78.33 32 96zM32 224H544V160H32V224zM32 256V416C32 433.7 46.33 448 64 448H512C529.7 448 544 433.7 544 416V256H32z"],
    "credit-card-blank": [576, 512, [], "f389", "M96 368C96 359.2 103.2 352 112 352H176C184.8 352 192 359.2 192 368C192 376.8 184.8 384 176 384H112C103.2 384 96 376.8 96 368zM224 368C224 359.2 231.2 352 240 352H368C376.8 352 384 359.2 384 368C384 376.8 376.8 384 368 384H240C231.2 384 224 376.8 224 368zM0 96C0 60.65 28.65 32 64 32H512C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96zM32 96V416C32 433.7 46.33 448 64 448H512C529.7 448 544 433.7 544 416V96C544 78.33 529.7 64 512 64H64C46.33 64 32 78.33 32 96z"],
    "credit-card-front": [576, 512, [], "f38a", "M96 304C96 295.2 103.2 288 112 288H464C472.8 288 480 295.2 480 304C480 312.8 472.8 320 464 320H112C103.2 320 96 312.8 96 304zM96 368C96 359.2 103.2 352 112 352H176C184.8 352 192 359.2 192 368C192 376.8 184.8 384 176 384H112C103.2 384 96 376.8 96 368zM368 352C376.8 352 384 359.2 384 368C384 376.8 376.8 384 368 384H240C231.2 384 224 376.8 224 368C224 359.2 231.2 352 240 352H368zM360 152C360 129.9 377.9 112 400 112H464C486.1 112 504 129.9 504 152V200C504 222.1 486.1 240 464 240H400C377.9 240 360 222.1 360 200V152zM392 152V200C392 204.4 395.6 208 400 208H464C468.4 208 472 204.4 472 200V152C472 147.6 468.4 144 464 144H400C395.6 144 392 147.6 392 152zM512 32C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H512zM512 64H64C46.33 64 32 78.33 32 96V416C32 433.7 46.33 448 64 448H512C529.7 448 544 433.7 544 416V96C544 78.33 529.7 64 512 64z"],
    "cricket-bat-ball": [512, 512, [127951, "cricket"], "f449", "M416 236.5c0-12.35-4.711-24.7-14.13-34.12l-34.82-34.83l140.3-140.3C510.4 24.18 512 20.09 512 16C512 7.473 505.1 0 496 0c-4.094 0-8.185 1.561-11.31 4.686l-140.3 140.3L309.6 110.2c-9.439-9.441-21.81-14.17-34.17-14.17c-12.34 0-24.67 4.705-34.09 14.12c-246.7 246.7-241.4 235.5-241.4 256.7C-.0004 473.9 112.2 512 145.1 512c9.84 0 19.59-4.166 27.13-11.71l229.7-229.6C411.3 261.2 416 248.9 416 236.5zM149.6 477.7c-1.627 1.627-3.252 2.273-3.252 2.369c0 .0059-.0126-.0019 0 0c-41.13-2.845-114.3-40.23-114.3-113.2c0-1.085 .7056-2.82 2.32-4.438L192 204.7V288c0 17.67 14.33 32 32 32h83.25L149.6 477.7zM379.2 248L339.3 288L224 287.1L224 172.7l40-39.99c3.062-3.064 7.135-4.752 11.46-4.752c4.354 0 8.453 1.703 11.54 4.793l92.23 92.24C383.4 229.2 384 234 384 236.5C384 240.9 382.3 244.9 379.2 248zM431.1 352c-44.25 0-80 35.75-80 79.1S387.7 512 431.1 512c44.25 0 80-35.75 80-79.1S476.2 352 431.1 352zM431.1 480c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S458.4 480 431.1 480z"],
    "croissant": [512, 512, [129360], "f7f6", "M508.1 175.6c-11.5-30.25-29.88-56.49-52.38-78.12c.375-3.999 .25-8.124-.25-12.12c-2.125-15.87-10.38-30.37-23.13-40.12c-38.63-29.25-85.63-45.12-134-45.24c-19.75 .125-39.38 2.1-58.25 8.374C229.9 2.656 215.2-2.968 196.2 1.781c-95.88 23.87-170.6 98.61-194.5 194.4c-3.75 15.37-1.375 31.5 6.625 44.99c-17.75 65.62-5.125 135.1 36.88 191.1c9.75 12.75 24.25 21.12 40.13 23.25c9.125 1.125 9.125 0 11.38-.25c21.75 22.75 48.25 41.24 78.88 52.87c42.5 16.12 87-19.1 79.5-65.24l-14.5-87.24c8.875-8.374 15-19.37 17.5-31.37c9.875-2.625 19-7.874 26.25-15.12l24.75-24.75c7.25-7.374 12.5-16.37 15.25-26.37c12-2.375 22.88-8.499 31.25-17.37l87.25 14.5C488.4 262.7 524.1 218 508.1 175.6zM298.4 32.03c41.38 .125 81.63 13.62 114.6 38.75c13.88 10.62 13.38 28.75 5 39.5l-84 106.1c-1.625 1.1-9.25 9.374-10 6.999l-56-181.1c-.75-2.375-2.25-4.374-3.375-6.749C275.7 33.28 286.1 32.15 298.4 32.03zM35.24 265.1C37.49 266.2 39.86 267.2 42.36 268.1l182 55.99c2.25 .625-5.125 8.374-7.125 9.874l-107 83.99c-14 10.1-31.5 5.374-39.5-4.999C38.61 370.9 25.74 317.2 35.24 265.1zM186.1 478.1c-21-7.999-40.38-19.87-57-34.1l82-64.37l11.63 69.37C226.1 468.1 206.5 485.6 186.1 478.1zM286.5 261.7l-24.75 24.75C257.7 290.5 247.4 297.6 233.7 293.5L51.74 237.5C37.61 233.1 29.24 218.4 32.86 204c21-84.36 86.75-150.2 171.1-171.1C218.4 29.28 233.1 37.65 237.5 51.77l56 181.1C296.5 243.6 293.9 254.4 286.5 261.7zM448.1 223.6l-69.38-11.62l64.38-81.99c15.13 16.62 27 35.1 35 56.99C485.6 206.8 468.9 227 448.1 223.6z"],
    "crop": [512, 512, [], "f125", "M416 384H496C504.8 384 512 391.2 512 400C512 408.8 504.8 416 496 416H416V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V150.6L150.6 384H352V416H144C117.5 416 96 394.5 96 368V128H16C7.164 128 0 120.8 0 112C0 103.2 7.164 96 16 96H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V361.4L361.4 128H160V96H393.4L484.7 4.686C490.9-1.562 501.1-1.562 507.3 4.686C513.6 10.93 513.6 21.07 507.3 27.31L416 118.6V384z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M128 368C128 376.8 135.2 384 144 384H352V416H144C117.5 416 96 394.5 96 368V128H16C7.164 128 0 120.8 0 112C0 103.2 7.164 96 16 96H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V368zM384 144C384 135.2 376.8 128 368 128H160V96H368C394.5 96 416 117.5 416 144V384H496C504.8 384 512 391.2 512 400C512 408.8 504.8 416 496 416H416V496C416 504.8 408.8 512 400 512C391.2 512 384 504.8 384 496V144z"],
    "cross": [384, 512, [128327, 10013], "f654", "M351.1 128h-96V32c0-17.62-14.37-32-31.1-32H160C142.4 0 127.1 14.38 127.1 32v96h-96C14.37 128-.0008 142.4-.0008 160v64c0 17.62 14.38 32 32 32h96v224c0 17.62 14.38 32 32 32h64c17.62 0 31.1-14.38 31.1-32V256h96c17.62 0 31.1-14.38 31.1-32V160C383.1 142.4 369.6 128 351.1 128zM352 224h-112C231.2 224 224 231.2 224 240V480H160V240C160 231.2 152.8 224 144 224H32V160h112C152.8 160 160 152.8 160 144V32h64v112C224 152.8 231.2 160 240 160H352V224z"],
    "crosshairs": [512, 512, [], "f05b", "M232 256C232 242.7 242.7 232 256 232C269.3 232 280 242.7 280 256C280 269.3 269.3 280 256 280C242.7 280 232 269.3 232 256zM256 0C264.8 0 272 7.164 272 16V48.61C374.1 56.37 455.6 137.9 463.4 240H496C504.8 240 512 247.2 512 256C512 264.8 504.8 272 496 272H463.4C455.6 374.1 374.1 455.6 272 463.4V496C272 504.8 264.8 512 256 512C247.2 512 240 504.8 240 496V463.4C137.9 455.6 56.37 374.1 48.61 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H48.61C56.37 137.9 137.9 56.37 240 48.61V16C240 7.164 247.2 0 256 0V0zM240 431.3V384C240 375.2 247.2 368 256 368C264.8 368 272 375.2 272 384V431.3C356.4 423.7 423.7 356.4 431.3 272H384C375.2 272 368 264.8 368 256C368 247.2 375.2 240 384 240H431.3C423.7 155.6 356.4 88.33 272 80.72V128C272 136.8 264.8 144 256 144C247.2 144 240 136.8 240 128V80.72C155.6 88.33 88.33 155.6 80.72 240H128C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272H80.72C88.33 356.4 155.6 423.7 240 431.3z"],
    "crow": [640, 512, [], "f520", "M440 96C440 109.3 429.3 120 416 120C402.7 120 392 109.3 392 96C392 82.75 402.7 72 416 72C429.3 72 440 82.75 440 96zM3.299 409.7C-2.075 402.7-.7434 392.7 6.272 387.3L320 146.1V96C320 42.98 362.1 0 416 0C444.4 0 469.1 12.36 487.6 31.1H560C604.2 31.1 640 67.82 640 111.1L512 143.1V192C512 270.8 464.5 338.5 396.6 368.1L446.8 489.9C450.2 498.1 446.3 507.4 438.1 510.8C429.9 514.2 420.6 510.3 417.2 502.1L366.3 378.4C351.4 382.1 335.1 384 320 384H307.2L350.8 489.9C354.2 498.1 350.3 507.4 342.1 510.8C333.9 514.2 324.6 510.3 321.2 502.1L272.6 384H63.2L25.73 412.7C18.71 418.1 8.672 416.7 3.298 409.7H3.299zM506.5 63.1C510.1 74.01 512 84.78 512 96V111L601.9 88.54C593.7 73.9 577.1 63.1 560 63.1H506.5zM205.9 315.2C268 302.1 313.6 249.1 319.4 187.8L132.7 330.8L205.9 315.2zM480 192V96C480 60.65 451.3 32 416 32C380.7 32 352 60.65 352 96L352 174.4C352 257.5 293.8 329.3 212.5 346.5L186.8 352H320C408.4 352 480 280.4 480 192V192z"],
    "crown": [576, 512, [128081], "f521", "M544 96c-17.67 0-32 14.33-32 32c0 7.559 3.008 14.21 7.391 19.69l-104.5 83.58c-5.955 4.764-12.99 7.019-19.94 7.019c-11.61 0-22.98-6.296-28.68-17.7L302.2 92.33C312.6 87.07 320 76.51 320 64c0-17.67-14.33-32-32-32S256 46.33 256 64c0 12.51 7.367 23.07 17.83 28.33L209.7 220.6C204 231.1 192.6 238.3 181 238.3c-6.945 0-13.98-2.255-19.94-7.019L56.61 147.7C60.99 142.2 64 135.6 64 128c0-17.67-14.33-32-32-32S0 110.3 0 128c0 17.67 14.33 32 32 32c1.99 0 3.721-.7852 5.611-1.133l48.83 268.6C91.98 457.9 118.5 480 149.4 480h277.2c30.93 0 57.43-22.12 62.97-52.55l48.83-268.6C540.3 159.2 542 160 544 160c17.67 0 32-14.33 32-32C576 110.3 561.7 96 544 96zM458.1 421.7C455.3 436.9 442.1 448 426.6 448H149.4c-15.47 0-28.71-11.05-31.48-26.28L78.78 206.4l62.32 49.86c11.31 9.049 25.49 14.03 39.93 14.03c24.43 0 46.39-13.56 57.3-35.39L288 135.6l49.67 99.35c10.91 21.83 32.87 35.39 57.3 35.39c14.44 0 28.62-4.984 39.93-14.03l62.32-49.86L458.1 421.7z"],
    "crutch": [512, 512, [], "f7f7", "M507.3 196.7l-192-192c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l192 192C487.8 222.4 491.9 224 496 224s8.188-1.562 11.31-4.688C513.6 213.1 513.6 202.9 507.3 196.7zM404.7 212.7L336 281.4L230.6 176l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L162.4 199C151.2 210.2 143.7 224.3 140.5 239.9l-27.25 136.3l-108.6 108.6c-6.25 6.25-6.25 16.37 0 22.62C7.813 510.4 11.91 512 16 512s8.188-1.562 11.31-4.687l108.6-108.6l136.3-27.25c15.56-3.156 29.69-10.72 40.84-21.88l114.3-114.3c6.25-6.25 6.25-16.38 0-22.62S410.9 206.4 404.7 212.7zM290.4 327c-6.688 6.688-15.19 11.25-24.5 13.12l-117.5 23.47l23.47-117.4C173.8 236.8 178.3 228.3 185 221.6L208 198.6L313.4 304L290.4 327z"],
    "crutches": [640, 512, [], "f7f8", "M224 16C224 6.861 216.5 0 208 0C203.9 0 199.8 1.562 196.7 4.688l-192 192C1.562 199.8 0 203.9 0 208C0 217.1 7.473 224 16 224c4.094 0 8.188-1.562 11.31-4.688l192-192C222.4 24.19 224 20.09 224 16zM224 80C214.9 80 208 87.47 208 96c0 4.094 1.562 8.188 4.688 11.31l48 48C263.8 158.4 267.9 160 272 160C281.1 160 288 152.5 288 144c0-4.094-1.562-8.188-4.688-11.31l-48-48C232.2 81.56 228.1 80 224 80zM208 352C217.1 352 224 344.5 224 336c0-4.094-1.562-8.188-4.688-11.31l-112-112C104.2 209.6 100.1 208 96 208C86.86 208 80 215.5 80 224c0 4.094 1.562 8.188 4.688 11.31l112 112C199.8 350.4 203.9 352 208 352zM427.3 404.7C424.2 401.6 420.1 400 416 400c-9.139 0-16 7.473-16 16c0 4.094 1.562 8.188 4.688 11.31l79.1 80C487.8 510.4 491.9 512 496 512c9.139 0 16-7.473 16-16c0-4.094-1.563-8.187-4.688-11.31L427.3 404.7zM640 208c0-4.094-1.562-8.188-4.688-11.31l-192-192C440.2 1.562 436.1 0 432 0C422.9 0 416 7.473 416 16c0 4.094 1.562 8.188 4.688 11.31l192 192C615.8 222.4 619.9 224 624 224C633.1 224 640 216.5 640 208zM544 208c-4.094 0-8.188 1.562-11.31 4.688L464 281.4L358.6 176l68.69-68.69C430.4 104.2 432 100.1 432 96c0-9.139-7.473-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L290.4 199C279.2 210.2 271.7 224.3 268.5 239.9l-27.25 136.3L132.7 484.7C129.6 487.8 128 491.9 128 496C128 505.1 135.5 512 144 512c4.094 0 8.184-1.562 11.31-4.687l108.6-108.6l136.3-27.25c15.56-3.156 29.69-10.72 40.84-21.88l114.3-114.3C558.4 232.2 560 228.1 560 224C560 214.9 552.5 208 544 208zM418.4 327c-6.688 6.688-15.19 11.25-24.5 13.12l-117.5 23.47l23.47-117.4C301.8 236.8 306.3 228.3 313 221.6L336 198.6L441.4 304L418.4 327z"],
    "cruzeiro-sign": [384, 512, [], "e152", "M160 436.7V240C160 231.2 167.2 224 176 224C184.8 224 192 231.2 192 240V255.1C205.4 245.1 221.1 240 240 240C265.2 240 288.9 251.9 304 272L308.8 278.4C314.1 285.5 312.7 295.5 305.6 300.8C298.5 306.1 288.5 304.7 283.2 297.6L278.4 291.2C269.3 279.1 255.1 272 240 272C213.5 272 192 293.5 192 320V445.1C202.9 447 214.2 448 225.7 448C275.3 448 320.6 429.5 354.8 399.1C361.4 393.2 371.5 393.8 377.4 400.4C383.3 407 382.7 417.1 376.1 423C336.1 458.4 283.4 480 225.7 480C101.2 480 0 379.8 0 256C0 132.2 101.2 32 225.7 32C283.4 32 336.1 53.55 376.1 88.1C382.7 94.87 383.3 104.1 377.4 111.6C371.5 118.2 361.4 118.8 354.8 112.9C320.6 82.5 275.3 63.1 225.7 63.1C118.6 63.1 32 150.1 32 255.1C32 339.1 85.31 410 160 436.7V436.7z"],
    "crystal-ball": [448, 512, [], "e362", "M288 304c8.844 0 16-7.156 16-16V240H352c8.844 0 16-7.156 16-16S360.8 208 352 208h-48V160c0-8.844-7.156-16-16-16S272 151.2 272 160v48H224C215.2 208 208 215.2 208 224S215.2 240 224 240h48V288C272 296.8 279.2 304 288 304zM70.01 364.3c6.982-5.447 8.234-15.53 2.756-22.48C46.15 307.8 32.06 266.9 32.06 223.5c0-106.1 86.29-192.4 192.4-192.4c106.1 0 192.4 86.28 192.4 192.4c0 43.39-14.09 84.31-40.71 118.4c-5.479 6.951-4.227 17.03 2.756 22.48c2.881 2.285 6.387 3.383 8.986 3.383c4.76 0 9.455-2.098 12.62-6.168C431.6 321.8 448 274.1 448 223.5C448 99.78 347.3 0 223.6 0C99.82 0 0 99.74 0 223.5c0 50.59 16.44 98.37 47.53 138.1C53.01 368.6 63.09 369.8 70.01 364.3zM144 192C152.8 192 160 184.8 160 176V160h16C184.8 160 192 152.8 192 144S184.8 128 176 128H160V112C160 103.2 152.8 96 144 96S128 103.2 128 112V128H112C103.2 128 96 135.2 96 144S103.2 160 112 160H128v16C128 184.8 135.2 192 144 192zM374 390.9c-3.006-4.414-8.016-7.105-13.34-7.105H88.17c-5.354 0-10.36 2.691-13.34 7.137l-64.13 96.18c-3.289 4.916-3.602 11.24-.7832 16.47C12.71 508.8 18.13 512 24.05 512h400.8c5.918 0 11.33-3.256 14.12-8.453c2.818-5.229 2.504-11.55-.7832-16.47L374 390.9zM54.01 479.9l42.74-64.12h255.4l42.74 64.12H54.01z"],
    "cube": [512, 512, [], "f1b2", "M239.5 5.018C250.1 1.106 261.9 1.106 272.5 5.018L480.5 81.28C499.4 88.22 512 106.2 512 126.4V385.7C512 405.8 499.4 423.8 480.5 430.7L272.5 506.1C261.9 510.9 250.1 510.9 239.5 506.1L31.48 430.7C12.57 423.8 0 405.8 0 385.7V126.4C0 106.2 12.57 88.22 31.48 81.28L239.5 5.018zM261.5 35.06C257.1 33.76 254 33.76 250.5 35.06L44.14 110.7L256 193.1L467.9 110.7L261.5 35.06zM42.49 400.7L240 473.1V222L32 140.3V385.7C32 392.4 36.19 398.4 42.49 400.7V400.7zM272 473.1L469.5 400.7C475.8 398.4 480 392.4 480 385.7V140.3L272 222V473.1z"],
    "cubes": [576, 512, [], "f1b3", "M440 84.99V212.8L440.1 212.9L544.1 249.1C563.2 256.8 576 274.9 576 295.2V421.4C576 440.8 564.3 458.3 546.4 465.7L442.4 508.8C430.6 513.6 417.4 513.6 405.6 508.8L288 460.1L170.4 508.8C158.6 513.6 145.4 513.6 133.6 508.8L29.65 465.7C11.7 458.3 0 440.8 0 421.4V295.2C0 274.9 12.76 256.8 31.87 249.1L135.9 212.9L136 212.8V84.99C136 64.7 148.8 46.6 167.9 39.78L271.9 2.669C282.3-1.054 293.7-1.054 304.1 2.669L408.1 39.78C427.2 46.6 440 64.7 440 84.99H440zM293.4 32.81C289.9 31.57 286.1 31.57 282.6 32.81L178.6 69.92C176.3 70.75 174.2 72.1 172.6 73.79L287.1 118L403.4 73.79C401.8 72.1 399.7 70.75 397.4 69.92L293.4 32.81zM168.1 212.9L271.1 249.9V146.2L167.1 106.3V212.8L168.1 212.9zM304 249.9L407.9 212.9L408 212.8V106.3L304 146.2V249.9zM159.1 348.6V478.4L271.1 432.1V308.2L159.1 348.6zM41.88 436.2L127.1 471.8V348.1L31.1 308.9V421.4C31.1 427.8 35.9 433.7 41.88 436.2V436.2zM416 348.6L304 308.2V432.1L416 478.4V348.6zM448 471.8L534.1 436.2C540.1 433.7 544 427.8 544 421.4V308.9L448 348.1V471.8zM157.4 243C153.9 241.8 150.1 241.8 146.6 243L44.55 279.4L144.4 320.2L258.5 279.1L157.4 243zM317.5 279.1L431.6 320.2L531.4 279.4L429.4 243C425.9 241.8 422.1 241.8 418.6 243L317.5 279.1z"],
    "cubes-stacked": [448, 512, [], "e4e6", "M288 32C305.7 32 320 46.33 320 64V128C320 145.7 305.7 160 288 160H224C206.3 160 192 145.7 192 128V64C192 46.33 206.3 32 224 32H288zM288 64H224V128H288V64zM70.96 250.7C62.12 235.4 67.37 215.8 82.67 206.1L138.1 174.1C153.4 166.1 172.1 171.4 181.8 186.7L213.8 242.1C222.6 257.4 217.4 276.1 202.1 285.8L146.7 317.8C131.4 326.6 111.8 321.4 102.1 306.1L70.96 250.7zM130.7 290.1L186.1 258.1L154.1 202.7L98.67 234.7L130.7 290.1zM256 224C256 206.3 270.3 192 288 192H352C369.7 192 384 206.3 384 224V288C384 305.7 369.7 320 352 320H288C270.3 320 256 305.7 256 288V224zM288 224V288H352V224H288zM320 384C320 366.3 334.3 352 352 352H416C433.7 352 448 366.3 448 384V448C448 465.7 433.7 480 416 480H352C334.3 480 320 465.7 320 448V384zM416 448V384H352V448H416zM256 352C273.7 352 288 366.3 288 384V448C288 465.7 273.7 480 256 480H192C174.3 480 160 465.7 160 448V384C160 366.3 174.3 352 192 352H256zM256 384H192V448H256V384zM0 384C0 366.3 14.33 352 32 352H96C113.7 352 128 366.3 128 384V448C128 465.7 113.7 480 96 480H32C14.33 480 0 465.7 0 448V384zM32 448H96V384H32V448z"],
    "cucumber": [512, 512, [129362], "e401", "M474.7 37.48C449.7 12.49 416.9 0 384.2 0s-65.56 12.49-90.54 37.48L169.2 161.8C166.3 160.9 163.3 159.1 160.1 159.1c-17.68 0-32.01 14.33-32.01 32c0 3.242 .9496 6.189 1.846 9.139L37.51 293.5c-50.02 50-50.02 131 0 181C62.49 499.5 95.29 512 128.1 512c31.01 0 61.83-11.59 86.24-33.98c3.132 1.023 6.321 1.979 9.795 1.979c17.68 0 32.01-14.33 32.01-32c0-3.242-.9496-6.191-1.846-9.139l184.8-184.7c2.95 .8965 5.899 1.844 9.142 1.844c17.68 0 32.01-14.33 32.01-32c0-3.475-.9535-6.662-1.977-9.795C524.3 163.1 523.4 86.13 474.7 37.48zM452.1 195.9l-256.1 256C177.8 470 153.7 480 128.1 480c-25.66 0-49.77-9.982-67.9-28.11c-37.45-37.43-37.45-98.34 0-135.8l256.1-256C334.4 41.98 358.5 32 384.2 32c25.67 0 49.78 9.979 67.9 28.1C489.5 97.54 489.5 158.4 452.1 195.9zM160.1 299.1c-11.04 0-20.01 8.969-20.01 20s8.972 20 20.01 20s20.01-8.969 20.01-20S171.1 299.1 160.1 299.1zM320.1 235.1c-11.04 0-20.01 8.969-20.01 20s8.972 20 20.01 20c11.04 0 20.01-8.969 20.01-20S331.2 235.1 320.1 235.1zM352.1 107.1c-11.04 0-20.01 8.969-20.01 20s8.972 20 20.01 20c11.04 0 20.01-8.969 20.01-20S363.2 107.1 352.1 107.1z"],
    "cup-straw": [384, 512, [129380], "e363", "M367.1 127.1L212.5 128l23.1-96h35.49c8.799 0 16.04-7.199 16.04-16S280.8 0 271.1 0l-35.5-.0003c-14.75 0-27.53 10-31.03 24.25L179.5 128L15.1 127.1C7.201 127.1 0 135.2 0 143.1C0 152.8 7.199 160 15.1 160h16.24c0 .5195-.209 .9883-.1582 1.516l29.23 307C63.69 493.3 84.23 512 109.1 512h165.8c24.86 0 45.41-18.67 47.78-43.45l29.23-307C351.1 160.1 351.8 160.5 351.8 160h16.19c8.799 0 16.03-7.201 16.03-16C383.1 135.2 376.8 127.1 367.1 127.1zM290.8 465.5C290 473.8 283.2 480 274.9 480H109.1c-8.281 0-15.14-6.234-15.94-14.48L64.07 160h255.9L290.8 465.5z"],
    "cup-straw-swoosh": [384, 512, [], "e364", "M367.1 127.1L212.5 128l23.1-96h35.49c8.799 0 16.04-7.199 16.04-16S280.8 0 271.1 0l-35.5-.0003c-14.75 0-27.53 10-31.03 24.25L179.5 128L15.1 127.1C7.201 127.1 0 135.2 0 143.1C0 152.8 7.199 160 15.1 160h16.24c0 .5195-.209 .9883-.1582 1.516l29.23 307C63.69 493.3 84.23 512 109.1 512h165.8c24.86 0 45.41-18.67 47.78-43.45l29.23-307C351.1 160.1 351.8 160.5 351.8 160h16.19c8.799 0 16.03-7.201 16.03-16C383.1 135.2 376.8 127.1 367.1 127.1zM319.9 160l-7.641 80.24c-46.95 1.242-92.38 26.53-125.1 70.17C159.3 347.5 122.7 368 84.13 368L64.07 160H319.9zM290.8 465.5C290 473.8 283.2 480 274.9 480H109.1c-8.281 0-15.14-6.234-15.94-14.48l-6.256-65.7c47.23-.9668 92.1-26.34 125.9-70.22c26.25-34.99 60.29-54.94 96.43-57.15L290.8 465.5z"],
    "cup-togo": [448, 512, ["coffee-togo"], "f6c5", "M432 96h-17.79l-21.08-63.22C386.6 13.19 368.3 0 347.6 0H100.4C79.72 0 61.44 13.19 54.84 32.81L33.79 96H16C7.156 96 0 103.2 0 112S7.156 128 16 128h416C440.8 128 448 120.8 448 112S440.8 96 432 96zM67.54 96l17.65-53.03C87.41 36.41 93.5 32 100.4 32h247.2c6.906 0 13 4.406 15.19 10.94L380.5 96H67.54zM385.6 160.1c-8.625-1.156-16.62 5.531-17.5 14.31L363.1 224H84.87L79.91 174.4C79.03 165.6 71 158.9 62.41 160.1c-8.781 .875-15.22 8.719-14.31 17.5l29.12 291.2C79.66 493.4 100.2 512 124.1 512h198.1c24.78 0 45.31-18.59 47.75-43.22l29.12-291.2C400.8 168.8 394.4 160.1 385.6 160.1zM338.1 465.6C338.1 473.8 331.3 480 323 480H124.1c-8.25 0-15.09-6.188-15.94-14.41L104.1 416h239.9L338.1 465.6zM347.1 384H100.9L88.07 256h271.9L347.1 384z"],
    "cupcake": [448, 512, [129473], "e402", "M376.5 322.4C378.3 323.6 379.9 325 381.1 326.7C382.3 328.5 383.2 330.4 383.7 332.5C384.1 334.5 384.2 336.7 383.8 338.8L360.9 476.4C359.2 486.3 354.1 495.4 346.4 501.9C338.7 508.4 328.9 512 318.8 512H129.2C119.1 512 109.4 508.5 101.7 501.1C93.95 495.5 88.79 486.5 87.1 476.5L64.16 338.8C63.82 336.7 63.88 334.6 64.36 332.5C64.83 330.5 65.71 328.5 66.93 326.8C68.15 325.1 69.7 323.7 71.48 322.5C73.27 321.4 75.25 320.7 77.33 320.3C79.4 319.1 81.52 320.1 83.57 320.5C85.62 321 87.55 321.9 89.26 323.1C90.97 324.3 92.43 325.9 93.54 327.7C94.65 329.4 95.4 331.4 95.74 333.5L118.7 471.1C119.1 473.6 120.4 475.9 122.3 477.5C124.2 479.1 126.7 480 129.2 480H161.9L144.2 337.1C143.7 333.8 144.9 329.5 147.5 326.2C150.1 322.8 153.9 320.6 158.1 320.1C162.3 319.6 166.6 320.8 169.9 323.4C173.3 325.1 175.5 329.8 176 334L194.1 480H253.9L272.1 333.9C272.4 331.8 273.1 329.8 274.1 327.1C275.1 326.2 276.5 324.6 278.2 323.3C279.8 321.1 281.7 321 283.8 320.5C285.8 319.9 287.9 319.8 290 320C292.1 320.3 294.1 320.9 295.9 321.1C297.8 323 299.4 324.4 300.7 326.1C301.9 327.7 302.9 329.6 303.5 331.7C304 333.7 304.2 335.8 303.9 337.9L286.1 479.9H318.8C321.3 479.9 323.8 479 325.7 477.4C327.6 475.7 328.9 473.5 329.3 470.1L352.3 333.4C352.1 329.2 355.3 325.5 358.7 322.1C362.2 320.5 366.5 319.5 370.7 320.2C372.7 320.6 374.7 321.3 376.5 322.4L376.5 322.4zM447.4 196.1C449.2 211.8 446.6 227.6 439.7 241.8C432.8 255.9 422 267.8 408.6 276C395.1 284.2 379.6 288.4 363.9 288H84.13C65.89 288.3 48.07 282.6 33.4 271.7C18.74 260.9 8.033 245.5 2.944 228C-2.648 207.7-.2571 186 9.626 167.4C19.51 148.8 36.14 134.7 56.1 128L95.46 117.2C98.4 100.3 107.2 85.05 120.3 74.02C133.4 62.99 149.1 56.93 167.1 56.9H200.4C203.9 56.94 207.3 55.94 210.1 54.02C212.1 52.11 215.2 49.37 216.4 46.18C217.8 43.02 218.2 39.53 217.5 36.16C216.8 32.8 215.1 29.71 212.7 27.33C210.4 25.09 208.9 22.24 208.3 19.13C207.7 16.02 207.1 12.8 209.2 9.873C210.4 6.946 212.5 4.445 215.1 2.687C217.7 .9296 220.8-.0057 223.1 0C256.1 .089 288.7 12.75 312.6 35.4C336.6 58.06 351 88.1 352.1 121.9L378.1 125.8C397.1 128.5 416.1 138.4 429.1 153.6C439.1 165.7 445.5 180.5 447.4 196.1H447.4zM414.2 219.6C416.2 212.8 416.7 205.7 415.7 198.6C414.7 191.6 412.2 184.9 408.3 178.9C404.4 172.1 399.2 167.1 393.2 164.2C387.1 160.5 380.3 158.1 373.3 157.2L285.6 143.8C283.5 143.5 281.4 142.8 279.6 141.7C277.7 140.7 276.1 139.2 274.9 137.5C273.6 135.8 272.7 133.9 272.2 131.8C271.6 129.8 271.5 127.6 271.9 125.5C272.2 123.4 272.9 121.4 274.1 119.6C275.2 117.7 276.6 116.2 278.4 114.9C280.1 113.7 282.1 112.8 284.1 112.3C286.2 111.9 288.4 111.8 290.5 112.2L320.7 116.8C318.2 97.8 310.1 79.94 297.5 65.46C284.9 50.99 268.3 40.54 249.8 35.42C250.3 43.28 249 51.17 245.1 58.43C242.3 67.51 236 75.27 227.9 80.7C219.8 86.13 210.2 88.97 200.4 88.86H167.1C156.3 88.91 145.9 93.23 138.3 100.9C130.6 108.6 126.3 118.9 126.3 129.8C126.3 130.1 126.1 130.4 126.1 130.8C125.1 131.9 125.8 132.1 125.4 134C125.2 134.1 124.9 135.9 124.5 136.8C124 137.7 123.4 138.5 122.8 139.3C122.2 140.1 121.5 140.9 120.8 141.6C120 142.2 119.2 142.8 118.4 143.3C117.4 143.9 116.4 144.4 115.4 144.7C115 144.9 114.8 145.2 114.4 145.2L65.41 158.6C53.38 162.9 43.43 171.6 37.57 182.9C31.71 194.2 30.37 207.4 33.82 219.6C37.07 230.4 43.75 239.7 52.84 246.3C61.93 252.9 72.92 256.3 84.13 255.1H363.9C375.1 256.3 386 252.9 395.1 246.4C404.2 239.8 410.9 230.5 414.2 219.8L414.2 219.6z"],
    "curling-stone": [576, 512, [129356, "curling"], "f44a", "M480 224V208C480 181.5 458.5 160 432 160H191.1L192 112C192 85.53 213.5 64 240 64h160C408.8 64 416 56.84 416 48S408.8 32 400 32h-160C195.9 32 160 67.88 160 112V160H144C117.5 160 96 181.5 96 208L95.1 224c-53.02 0-96 42.98-96 96v64c0 53.02 42.98 96 96 96h384c53.02 0 96-42.98 96-96v-64C576 266.1 533 224 480 224zM128 208C128 199.2 135.2 192 144 192h288C440.8 192 448 199.2 448 208V224H128V208zM96 256h384c35.29 0 64 28.71 64 64v16H32V320C32 284.7 60.71 256 96 256zM480 448H96c-35.29 0-64-28.71-64-64v-16h512V384C544 419.3 515.3 448 480 448z"],
    "custard": [576, 512, [127854], "e403", "M571.3 420.7C574.3 423.7 576 427.8 576 432C576 436.2 574.3 440.3 571.3 443.3C568.3 446.3 564.2 448 560 448H16C11.76 448 7.687 446.3 4.686 443.3C1.686 440.3 0 436.2 0 432C0 427.8 1.686 423.7 4.686 420.7C7.687 417.7 11.76 416 16 416H560C564.2 416 568.3 417.7 571.3 420.7zM66.5 360.5C64.24 356.9 63.49 352.6 64.42 348.5L117.9 112C120.9 98.28 128.6 86.03 139.6 77.3C150.7 68.56 164.3 63.87 178.4 64H397.6C411.7 63.87 425.3 68.56 436.4 77.3C447.4 86.03 455.1 98.28 458.2 112L511.7 348.4C512.2 350.4 512.2 352.5 511.9 354.6C511.5 356.7 510.8 358.7 509.6 360.5C508.5 362.2 507.1 363.8 505.3 365C503.6 366.2 501.7 367.1 499.6 367.6C498.5 367.8 497.3 367.1 496.1 367.1C492.5 367.1 488.1 366.7 486.1 364.5C483.3 362.2 481.3 359 480.5 355.5L450.7 223.7L447.3 221.5C433.1 212.6 416.7 207.9 399.9 207.9C383.2 207.9 366.7 212.6 352.5 221.5C333.2 233.6 310.9 240 288.1 240C265.3 240 242.1 233.6 223.6 221.5C209.4 212.7 193 207.9 176.3 207.9C159.5 207.9 143.1 212.7 128.9 221.5L125.5 223.7L95.68 355.5C95.22 357.6 94.35 359.5 93.13 361.2C91.91 362.1 90.37 364.4 88.59 365.5C86.8 366.7 84.81 367.4 82.74 367.8C80.66 368.1 78.53 368.1 76.48 367.6C72.35 366.6 68.76 364.1 66.5 360.5H66.5zM134.4 183.7C151.8 177.2 170.4 174.9 188.8 176.7C207.2 178.6 224.1 184.7 240.7 194.5C254.9 203.1 271.3 207.7 288 207.7C304.7 207.7 321.1 203.1 335.4 194.5C351.1 184.7 368.8 178.6 387.2 176.8C405.7 174.9 424.2 177.2 441.6 183.7L426.1 119C425.4 112.5 421.6 106.6 416.3 102.4C410.1 98.23 404.4 95.97 397.6 96H178.4C171.6 95.97 165 98.22 159.7 102.4C154.4 106.6 150.6 112.4 149.1 119L134.4 183.7z"],
    "d": [384, 512, [100], "44", "M160 480L16 480C7.156 480 0 472.8 0 464v-416C0 39.16 7.156 32 16 32L160 32.01c123.5 0 224 100.5 224 223.1S283.5 480 160 480zM32 448h128c105.9 0 192-86.13 192-192s-86.13-192-192-192H32V448z"],
    "dagger": [384, 512, [], "f6cb", "M320 128h-112V16C208 7.156 200.8 0 192 0S176 7.156 176 16V128H64C28.7 128 0 156.7 0 192L0 208C0 216.8 7.156 224 16 224S32 216.8 32 208V192c0-17.66 14.36-32 32-32h48v240c0 3.156 .9375 6.25 2.688 8.875l64.04 96C181.7 509.3 186.7 512 191.1 512s10.39-2.688 13.35-7.125l63.96-96C271.1 406.3 272 403.2 272 400V160H320c17.64 0 32 14.34 32 32v16C352 216.8 359.2 224 368 224S384 216.8 384 208L383.1 192C383.1 156.7 355.3 128 320 128zM240 395.2l-48 72l-48-72V160h96V395.2z"],
    "dash": [512, 512, ["minus-large"], "e404", "M512 256c0 8.832-7.166 16-16 16h-480C7.166 272 0 264.8 0 256c0-8.834 7.166-16 16-16h480C504.8 240 512 247.2 512 256z"],
    "database": [448, 512, [], "f1c0", "M224 512C100.3 512 0 476.2 0 432V80C0 35.82 100.3 0 224 0C347.7 0 448 35.82 448 80V432C448 476.2 347.7 512 224 512zM416 80.45C415.7 79.69 414.4 77.27 409.8 73.31C402.4 67.11 389.9 60.09 371.6 53.57C335.4 40.62 283.2 32 224 32C164.8 32 112.6 40.62 76.37 53.57C58.1 60.09 45.59 67.11 38.25 73.31C33.55 77.27 32.29 79.69 32 80.45V182.1C46.47 192.7 69.9 202.8 100.9 210.4C135.5 218.9 177.1 224 224 224C270 224 312.5 218.9 347.1 210.4C378.1 202.8 401.5 192.7 416 182.1V80.45zM416 219.5C398.8 228.4 377.9 235.8 354.8 241.5C317.3 250.7 272.2 256 224 256C175.8 256 130.7 250.7 93.22 241.5C70.11 235.8 49.18 228.4 32 219.5V310.1C46.47 320.7 69.9 330.8 100.9 338.4C135.5 346.9 177.1 352 224 352C270 352 312.5 346.9 347.1 338.4C378.1 330.8 401.5 320.7 416 310.1V219.5zM38.25 438.7C45.59 444.9 58.1 451.9 76.37 458.4C112.6 471.4 164.8 480 224 480C283.2 480 335.4 471.4 371.6 458.4C389.9 451.9 402.4 444.9 409.8 438.7C414.4 434.7 415.7 432.3 416 431.6V347.5C398.8 356.4 377.9 363.8 354.8 369.5C317.3 378.7 272.2 384 224 384C175.8 384 130.7 378.7 93.22 369.5C70.11 363.8 49.18 356.4 32 347.5V431.6C32.29 432.3 33.55 434.7 38.25 438.7zM416 431.4C416.1 431.3 416.1 431.3 416.1 431.3L416 431.4zM31.96 431.4C31.94 431.3 31.93 431.3 31.92 431.3L31.96 431.4zM31.96 80.56C31.93 80.65 31.92 80.7 31.92 80.7L31.96 80.56zM416.1 80.7C416.1 80.7 416.1 80.65 416 80.56z"],
    "deer": [512, 512, [129420], "f78e", "M399.1 159.1C391.2 159.1 384 167.3 384 176S391.3 192 400 192s15.1-7.25 15.1-16S408.7 159.1 399.1 159.1zM488.8 133.2l-92-25.75l11.12-5.624c12.5-6.321 23.16-15.76 30.94-27.41l13.57-20.31C457.3 46.83 455.3 36.91 448 32c-7.371-4.949-17.36-2.945-22.26 4.463l-13.34 20.12c-4.719 7.117-11.17 12.85-18.8 16.68L351 94.63l-33.75-9.5l8.266-10.39C332.3 66.22 336 55.63 336 44.75V16C336 7.199 328.8 0 320 0s-15.94 7.197-15.94 15.1L304 44.75c0 3.633-1.234 7.159-3.5 9.1l-16.75 21l-16.12-4.498c-6.958-1.942-11.76-8.278-11.76-15.5L256 15.1C256 7.197 248.7 0 239.9 0s-16 7.199-16 16v39.75c0 21.51 14.3 40.41 35 46.25l78.88 22.25L304 192H96C42.98 192 0 234.1 0 288c0 17.67 14.33 32 31.1 32L32 347.6l-11.88 31.75c-4.625 12.25-5.375 25.5-2.25 38l19.44 61.2C43.64 498.5 62.15 512 83.06 512h15.68c31.19 0 54.1-29.29 46.59-59.56l-12.08-48.69L152.6 352H256v112c0 26.51 21.49 47.1 47.1 47.1L336 512c26.51 0 48-21.49 48-48V320l32-64h48C490.5 256 512 234.5 512 208V164.1C512 149.7 502.4 137.2 488.8 133.2zM480.1 208c0 8.75-7.375 16-16.12 16h-67.75L352 312.4V464c0 8.836-7.164 16-16 16h-32c-8.836 0-16-7.221-16-16.06V320H130.4l-30.62 81.75l12.51 56.82C116 468.1 108.3 480 97.21 480H83.08c-6.971 0-13.14-4.514-15.25-11.16l-19.08-60.09c-1.375-6-.875-12.25 1.375-18.12l14-37.25V288H32c0-35.25 28.75-64 64-64h227.8l33.75-67.38c6.869-13.71 22.5-20.63 37.27-16.49l73.6 20.62c6.951 1.947 11.76 8.283 11.76 15.5V208z"],
    "deer-rudolph": [576, 512, [], "f78f", "M431.1 159.1C423.2 159.1 416 167.2 416 175.1S423.3 192 432 192s15.1-7.25 15.1-16S440.7 159.1 431.1 159.1zM544 96c-17.67 0-32 14.33-32 32c0 1.053 .5127 1.957 .6123 2.984l-83.86-23.48l11.12-5.624c12.5-6.32 23.16-15.76 30.94-27.41l13.57-20.31C489.3 46.83 487.3 36.91 480 32c-7.371-4.949-17.36-2.945-22.26 4.463l-13.34 20.12c-4.719 7.117-11.17 12.85-18.8 16.68L383 94.63l-33.75-9.5l8.266-10.39C364.3 66.22 368 55.63 368 44.75V16C368 7.199 360.8 0 352 0s-16 7.199-16 16v28.75c0 3.633-1.234 7.16-3.5 9.999l-16.75 21l-16.12-4.498c-6.959-1.941-11.76-8.277-11.76-15.5V16c0-8.801-7.199-16-16-16s-16 7.199-16 16v39.75c0 21.51 14.3 40.41 35 46.25l78.88 22.25L336 192H128C74.98 192 32 234.1 32 288c0 17.67 14.33 32 32 32v27.56l-11.88 31.75c-4.625 12.25-5.375 25.5-2.25 38l19.44 61.2C75.64 498.5 94.15 512 115.1 512h15.68c31.2 0 54.1-29.29 46.59-59.56l-12.08-48.69L184.6 352H288v112c0 26.51 21.49 47.1 47.1 47.1L368 512c26.51 0 48-21.49 48-48V320l32-64h48C522.5 256 544 234.5 544 208V164.1c0-1.486-.4863-2.817-.6855-4.255C543.6 159.9 543.7 160 544 160c17.67 0 32-14.33 32-32C576 110.3 561.7 96 544 96zM512.1 208c0 8.75-7.375 16-16.12 16h-67.75L384 312.4V464c0 8.836-7.164 16-16 16h-32c-8.836 0-16-7.164-16-16V320H162.4l-30.62 81.75l12.51 56.82C148 468.1 140.3 480 129.2 480H115.1c-6.971 0-13.14-4.514-15.25-11.16l-19.08-60.09c-1.375-6-.875-12.25 1.375-18.12l14-37.25V288H64c0-35.25 28.75-64 64-64h227.8l33.75-67.38c6.869-13.71 22.5-20.63 37.27-16.49l73.6 20.62c6.951 1.947 11.76 8.283 11.76 15.5V208z"],
    "delete-left": [576, 512, [9003, "backspace"], "f55a", "M427.3 203.3L374.6 256L427.3 308.7C433.6 314.9 433.6 325.1 427.3 331.3C421.1 337.6 410.9 337.6 404.7 331.3L351.1 278.6L299.3 331.3C293.1 337.6 282.9 337.6 276.7 331.3C270.4 325.1 270.4 314.9 276.7 308.7L329.4 256L276.7 203.3C270.4 197.1 270.4 186.9 276.7 180.7C282.9 174.4 293.1 174.4 299.3 180.7L351.1 233.4L404.7 180.7C410.9 174.4 421.1 174.4 427.3 180.7C433.6 186.9 433.6 197.1 427.3 203.3zM512 64C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H205.3C188.3 448 172 441.3 160 429.3L9.372 278.6C3.371 272.6 0 264.5 0 256C0 247.5 3.372 239.4 9.372 233.4L160 82.75C172 70.74 188.3 64 205.3 64L512 64zM544 128C544 110.3 529.7 96 512 96H205.3C196.8 96 188.6 99.37 182.6 105.4L31.1 256L182.6 406.6C188.6 412.6 196.8 416 205.3 416H512C529.7 416 544 401.7 544 384V128z"],
    "delete-right": [576, 512, [], "e154", "M148.7 180.7C154.9 174.4 165.1 174.4 171.3 180.7L224 233.4L276.7 180.7C282.9 174.4 293.1 174.4 299.3 180.7C305.6 186.9 305.6 197.1 299.3 203.3L246.6 256L299.3 308.7C305.6 314.9 305.6 325.1 299.3 331.3C293.1 337.6 282.9 337.6 276.7 331.3L224 278.6L171.3 331.3C165.1 337.6 154.9 337.6 148.7 331.3C142.4 325.1 142.4 314.9 148.7 308.7L201.4 256L148.7 203.3C142.4 197.1 142.4 186.9 148.7 180.7zM370.7 64C387.7 64 403.1 70.74 416 82.75L566.6 233.4C572.6 239.4 576 247.5 576 256C576 264.5 572.6 272.6 566.6 278.6L416 429.3C403.1 441.3 387.7 448 370.7 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64L370.7 64zM32 384C32 401.7 46.33 416 64 416H370.7C379.2 416 387.4 412.6 393.4 406.6L544 256L393.4 105.4C387.4 99.37 379.2 96 370.7 96H64C46.33 96 32 110.3 32 128V384z"],
    "democrat": [640, 512, [], "f747", "M639.2 250.9C617.9 186.1 558.3 144 490.8 144H269.8L225.4 97.09C235.1 71.99 233.9 42.4 218.2 18.61C210.7 7.254 198.1 .4453 184.4 .4453c-10.84 0-21.03 4.215-28.69 11.88L141.7 26.34L126.8 11.45C119.4 4.066 109.6 0 99.17 0c-13.27 0-25.5 6.648-32.7 17.78c-15.75 23.95-15.79 54.78-1.439 78.7l-52.98 70.55c-13.76 18.33-15.9 42.44-5.578 62.9l12.71 25.2c10.22 20.27 30.67 32.86 53.37 32.86h27.12c14.92 0 29-5.41 40.02-15.31l20.38 53.23V452c0 33.09 26.91 60 59.99 60h23.1C277.1 512 304.1 485.1 304.1 452V416h127.1v36c0 33.09 26.91 60 59.99 60h23.99c33.08 0 59.99-26.91 59.99-60l.002-211.1c0-12.55-2.461-24.7-7.021-35.98c17.97 14.58 32.15 33.95 39.85 57.04C611.1 267.8 617.3 272 624 272c1.672 0 3.375-.25 5.062-.8125C637.4 268.4 641.1 259.3 639.2 250.9zM544 452c0 15.4-12.6 28-27.1 28h-23.99c-15.4 0-27.1-12.6-27.1-28V384H272.1v68c0 15.4-12.6 28-27.1 28H220.1c-15.4 0-27.1-12.6-27.1-28l-.0433-100h351.1L544 452zM544 312l-.0102 7.999H192L152.8 217.5L119.5 247.8C114.2 253 107.1 255.1 99.67 255.1H72.55c-10.49 0-20.08-5.906-24.8-15.27L35.04 215.5C30.27 206.1 31.28 194.7 37.64 186.3l65.32-86.99C104.5 97.29 106.7 96.09 108.5 94.55c-3.502-1.969-6.998-3.719-9.842-6.562C84.36 73.66 82.61 51.46 93.33 35.17C94.67 33.09 96.91 32 99.17 32c1.783 0 3.586 .6758 4.984 2.074L141.7 71.59l36.63-36.64C179.1 33.26 182.2 32.45 184.4 32.45c2.768 0 5.51 1.312 7.16 3.816c13.23 20.01 11.04 47.14-6.561 64.64L256.1 176h223.1c35.34 0 63.99 28.66 63.99 64L544 312zM288.1 232H272.1L272 215.1C272 207.2 264.9 200 256.1 200s-15.1 7.156-15.1 16v16H224.1c-8.844 0-15.1 7.156-15.1 16s7.154 16 15.1 16l15.96-.0001L240.1 280c0 8.844 7.156 16 15.1 16s15.1-7.156 15.1-16v-16h15.1c8.842 0 15.97-7.156 15.97-16S296.9 232 288.1 232zM400 232h-15.1v-16c0-8.844-7.154-16-15.1-16c-8.842 0-15.1 7.156-15.1 16v16h-15.1c-8.842 0-15.1 7.156-15.1 16s7.129 15.1 15.97 15.1L352 264v16c0 8.844 7.132 15.1 15.97 15.1c8.844 0 16.02-7.156 16.02-15.1v-16l15.98-.0001c8.842 0 16.02-7.156 16.02-15.1S408.9 232 400 232zM512 232h-15.1v-16c0-8.844-7.156-16-15.1-16s-16.01 7.156-16.01 15.1L464 232h-15.1c-8.842 0-16.02 7.156-16.02 15.1S439.2 264 448 264h15.1v16c0 8.844 7.156 16 15.1 16s15.1-7.156 15.1-16l-.0127-16L512 264c8.844 0 15.1-7.156 15.1-16S520.9 232 512 232z"],
    "desktop": [576, 512, [61704, 128421, "desktop-alt"], "f390", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h512V352zM544 256H32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V256z"],
    "desktop-arrow-down": [576, 512, [], "e155", "M208 112c-4.094 0-8.188 1.562-11.31 4.688c-6.25 6.25-6.25 16.38 0 22.62l80 80c6.25 6.25 16.38 6.25 22.62 0l80-80c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L304 169.4V16C304 7.156 296.8 0 288 0S272 7.156 272 16v153.4L219.3 116.7C216.2 113.6 212.1 112 208 112zM512 0h-144C359.2 0 352 7.162 352 16C352 24.84 359.2 32 368 32H512c17.67 0 32 14.33 32 32v192H32V64c0-17.67 14.33-32 32-32h144C216.8 32 224 24.84 224 16C224 7.162 216.8 0 208 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h512V352z"],
    "dharmachakra": [512, 512, [9784], "f655", "M496 240h-32.81c-3.477-45.32-21.46-86.58-49.41-119.2l23.24-23.24c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-23.24 23.24C358.6 70.26 317.3 52.29 272 48.81V16C272 7.156 264.8 0 256 0S240 7.156 240 16v32.81C194.7 52.29 153.4 70.26 120.9 98.21L97.61 74.97c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L98.22 120.8C70.27 153.4 52.29 194.7 48.81 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h32.81c3.477 45.32 21.46 86.58 49.41 119.2l-23.24 23.24c-6.25 6.25-6.25 16.38 0 22.62c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l23.24-23.24C153.4 441.7 194.7 459.7 240 463.2V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-32.81c45.32-3.473 86.56-21.45 119.1-49.4l23.24 23.24c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L413.8 391.2C441.7 358.6 459.7 317.3 463.2 272H496C504.8 272 512 264.8 512 256S504.8 240 496 240zM431.2 240h-80.81c-2.459-14.53-8.078-27.91-16.3-39.46l57.08-57.09C413.4 170.1 427.9 203.5 431.2 240zM256 320c-35.3 0-64-28.72-64-64s28.7-64 64-64s64 28.72 64 64S291.3 320 256 320zM368.5 120.8l-57.08 57.09C299.9 169.7 286.5 164.1 272 161.6V80.81C308.5 84.13 341.9 98.58 368.5 120.8zM240 80.81v80.8C225.5 164.1 212.1 169.7 200.5 177.9L143.5 120.8C170.1 98.58 203.5 84.13 240 80.81zM120.8 143.5l57.08 57.09C169.7 212.1 164.1 225.5 161.6 240H80.81C84.12 203.5 98.59 170.1 120.8 143.5zM80.81 272h80.81c2.459 14.53 8.078 27.91 16.3 39.46l-57.08 57.09C98.59 341.9 84.12 308.5 80.81 272zM143.5 391.2l57.08-57.09C212.1 342.3 225.5 347.9 240 350.4v80.8C203.5 427.9 170.1 413.4 143.5 391.2zM272 431.2v-80.8c14.53-2.461 27.92-8.078 39.46-16.3l57.08 57.09C341.9 413.4 308.5 427.9 272 431.2zM391.2 368.5l-57.08-57.09C342.3 299.9 347.9 286.5 350.4 272h80.81C427.9 308.5 413.4 341.9 391.2 368.5z"],
    "diagram-cells": [512, 512, [], "e475", "M64 224C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V160C512 195.3 483.3 224 448 224H64zM480 160V96C480 78.33 465.7 64 448 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H448C465.7 192 480 177.7 480 160zM512 416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H448C483.3 288 512 316.7 512 352V416zM448 448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320H64C46.33 320 32 334.3 32 352V416C32 433.7 46.33 448 64 448H448z"],
    "diagram-lean-canvas": [640, 512, [], "e156", "M0 96C0 60.65 28.65 32 64 32H576C611.3 32 640 60.65 640 96V416C640 451.3 611.3 480 576 480H64C28.65 480 0 451.3 0 416V96zM512 320H608V96C608 78.33 593.7 64 576 64H512V320zM480 64H384V192H480V64zM352 64H288V320H352V64zM256 64H160V192H256V64zM128 64H64C46.33 64 32 78.33 32 96V320H128V64zM32 352V416C32 433.7 46.33 448 64 448H304V352H32zM336 448H576C593.7 448 608 433.7 608 416V352H336V448zM256 224H160V320H256V224zM384 224V320H480V224H384z"],
    "diagram-nested": [448, 512, [], "e157", "M112 320C112 346.5 133.5 368 160 368H256V336C256 309.5 277.5 288 304 288H400C426.5 288 448 309.5 448 336V432C448 458.5 426.5 480 400 480H304C277.5 480 256 458.5 256 432V400H160C115.8 400 80 364.2 80 320V224H48C21.49 224 0 202.5 0 176V80C0 53.49 21.49 32 48 32H144C170.5 32 192 53.49 192 80V176C192 202.5 170.5 224 144 224H112V320zM144 64H48C39.16 64 32 71.16 32 80V176C32 184.8 39.16 192 48 192H144C152.8 192 160 184.8 160 176V80C160 71.16 152.8 64 144 64zM288 432C288 440.8 295.2 448 304 448H400C408.8 448 416 440.8 416 432V336C416 327.2 408.8 320 400 320H304C295.2 320 288 327.2 288 336V432z"],
    "diagram-next": [512, 512, [], "e476", "M272 329.4L308.7 292.7C314.9 286.4 325.1 286.4 331.3 292.7C337.6 298.9 337.6 309.1 331.3 315.3L267.3 379.3C261.1 385.6 250.9 385.6 244.7 379.3L180.7 315.3C174.4 309.1 174.4 298.9 180.7 292.7C186.9 286.4 197.1 286.4 203.3 292.7L240 329.4V224H64C28.65 224 .0003 195.3 .0003 160V96C.0003 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V160C512 195.3 483.3 224 448 224H272L272 329.4zM480 160V96C480 78.33 465.7 64 448 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H448C465.7 192 480 177.7 480 160zM64 480C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H112C120.8 288 128 295.2 128 304C128 312.8 120.8 320 112 320H64C46.33 320 32 334.3 32 352V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320H400C391.2 320 384 312.8 384 304C384 295.2 391.2 288 400 288H448C483.3 288 512 316.7 512 352V416C512 451.3 483.3 480 448 480H64z"],
    "diagram-predecessor": [512, 512, [], "e477", "M512 416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H448C483.3 288 512 316.7 512 352V416zM448 320H64C46.33 320 32 334.3 32 352V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320zM192 112C200.8 112 208 119.2 208 128C208 136.8 200.8 144 192 144H96C87.16 144 80 136.8 80 128C80 119.2 87.16 112 96 112H192zM279.4 64C284.9 73.41 288 84.34 288 96V160C288 195.3 259.3 224 224 224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H368C403.3 32 432 60.65 432 96V185.4L468.7 148.7C474.9 142.4 485.1 142.4 491.3 148.7C497.6 154.9 497.6 165.1 491.3 171.3L427.3 235.3C421.1 241.6 410.9 241.6 404.7 235.3L340.7 171.3C334.4 165.1 334.4 154.9 340.7 148.7C346.9 142.4 357.1 142.4 363.3 148.7L400 185.4V96C400 78.33 385.7 64 368 64H279.4zM224 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H224C241.7 192 256 177.7 256 160V96C256 78.33 241.7 64 224 64z"],
    "diagram-previous": [512, 512, [], "e478", "M272 288H448C483.3 288 512 316.7 512 352V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H240V182.6L203.3 219.3C197.1 225.6 186.9 225.6 180.7 219.3C174.4 213.1 174.4 202.9 180.7 196.7L244.7 132.7C250.9 126.4 261.1 126.4 267.3 132.7L331.3 196.7C337.6 202.9 337.6 213.1 331.3 219.3C325.1 225.6 314.9 225.6 308.7 219.3L272 182.6L272 288zM448 320H64C46.33 320 32 334.3 32 352V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320zM448 32C483.3 32 512 60.65 512 96V160C512 195.3 483.3 224 448 224H400C391.2 224 384 216.8 384 208C384 199.2 391.2 192 400 192H448C465.7 192 480 177.7 480 160V96C480 78.33 465.7 64 448 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H112C120.8 192 128 199.2 128 208C128 216.8 120.8 224 112 224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H448z"],
    "diagram-project": [576, 512, ["project-diagram"], "f542", "M183.8 197.1L256 293.4C263.3 289.9 271.4 288 280 288H360C390.9 288 416 313.1 416 344V424C416 454.9 390.9 480 360 480H280C249.1 480 224 454.9 224 424V344C224 333.3 226.1 323.4 232.2 314.9L159.1 218.6C152.7 222.1 144.6 224 136 224H56C25.07 224 0 198.9 0 168V88C0 57.07 25.07 32 56 32H136C166.9 32 192 57.07 192 88V112H384V88C384 57.07 409.1 32 440 32H520C550.9 32 576 57.07 576 88V168C576 198.9 550.9 224 520 224H440C409.1 224 384 198.9 384 168V144H192V168C192 178.7 189 188.6 183.8 197.1V197.1zM136 64H56C42.75 64 32 74.75 32 88V168C32 181.3 42.75 192 56 192H136C149.3 192 160 181.3 160 168V88C160 74.75 149.3 64 136 64zM440 192H520C533.3 192 544 181.3 544 168V88C544 74.75 533.3 64 520 64H440C426.7 64 416 74.75 416 88V168C416 181.3 426.7 192 440 192zM360 320H280C266.7 320 256 330.7 256 344V424C256 437.3 266.7 448 280 448H360C373.3 448 384 437.3 384 424V344C384 330.7 373.3 320 360 320z"],
    "diagram-sankey": [576, 512, [], "e158", "M354.1 64C348.5 64 343.3 66.95 340.4 71.77L263 200.7C254.4 215.2 238.7 224 221.9 224H16C7.164 224 0 216.8 0 208C0 199.2 7.164 192 16 192H221.9C227.5 192 232.7 189.1 235.6 184.2L312.1 55.3C321.6 40.85 337.3 32 354.1 32H560C568.8 32 576 39.16 576 48C576 56.84 568.8 64 560 64H354.1zM201.7 320L276.2 440.4C279.1 445.1 284.3 448 289.8 448H560C568.8 448 576 455.2 576 464C576 472.8 568.8 480 560 480H289.8C273.2 480 257.8 471.4 249 457.3L164 320H16C7.164 320 .0003 312.8 .0003 304C.0003 295.2 7.164 288 16 288H180.9L181.6 287.6L181.9 288H560C568.8 288 576 295.2 576 304C576 312.8 568.8 320 560 320H201.7z"],
    "diagram-subtask": [512, 512, [], "e479", "M144 320C144 346.5 165.5 368 192 368H224V352C224 316.7 252.7 288 288 288H448C483.3 288 512 316.7 512 352V416C512 451.3 483.3 480 448 480H288C252.7 480 224 451.3 224 416V400H192C147.8 400 112 364.2 112 320V224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V160C512 195.3 483.3 224 448 224H144V320zM448 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H448C465.7 192 480 177.7 480 160V96C480 78.33 465.7 64 448 64zM448 320H288C270.3 320 256 334.3 256 352V416C256 433.7 270.3 448 288 448H448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320z"],
    "diagram-successor": [512, 512, [], "e47a", "M416 368C424.8 368 432 375.2 432 384C432 392.8 424.8 400 416 400H96C87.16 400 80 392.8 80 384C80 375.2 87.16 368 96 368H416zM512 416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V352C0 316.7 28.65 288 64 288H448C483.3 288 512 316.7 512 352V416zM448 320H64C46.33 320 32 334.3 32 352V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V352C480 334.3 465.7 320 448 320zM279.4 64C284.9 73.41 288 84.34 288 96V160C288 195.3 259.3 224 224 224H64C28.65 224 0 195.3 0 160V96C0 60.65 28.65 32 64 32H368C403.3 32 432 60.65 432 96V185.4L468.7 148.7C474.9 142.4 485.1 142.4 491.3 148.7C497.6 154.9 497.6 165.1 491.3 171.3L427.3 235.3C421.1 241.6 410.9 241.6 404.7 235.3L340.7 171.3C334.4 165.1 334.4 154.9 340.7 148.7C346.9 142.4 357.1 142.4 363.3 148.7L400 185.4V96C400 78.33 385.7 64 368 64H279.4zM224 64H64C46.33 64 32 78.33 32 96V160C32 177.7 46.33 192 64 192H224C241.7 192 256 177.7 256 160V96C256 78.33 241.7 64 224 64z"],
    "diagram-venn": [640, 512, [], "e15a", "M0 256C0 132.3 100.3 32 224 32C258.4 32 290.9 39.73 320 53.56C349.1 39.73 381.6 32 416 32C539.7 32 640 132.3 640 256C640 379.7 539.7 480 416 480C381.6 480 349.1 472.3 320 458.4C290.9 472.3 258.4 480 224 480C100.3 480 0 379.7 0 256zM224 448C245.5 448 266.1 444.5 285.4 437.1C228.8 397.3 192 330.1 192 256C192 181 228.8 114.7 285.4 74.02C266.1 67.52 245.5 64 224 64C117.1 64 32 149.1 32 256C32 362 117.1 448 224 448V448zM405.1 192H234.9C229.5 207.2 226 223.3 224.7 240H415.3C413.1 223.3 410.5 207.2 405.1 192zM234.9 320H405.1C410.5 304.8 413.1 288.7 415.3 272H224.7C226 288.7 229.5 304.8 234.9 320zM320 422.3C349.1 405.5 373.5 381.1 390.3 352H249.7C266.5 381.1 290.9 405.5 320 422.3H320zM390.3 160C373.5 130.9 349.1 106.5 320 89.69C290.9 106.5 266.5 130.9 249.7 160H390.3zM416 64C394.5 64 373.9 67.52 354.6 74.02C411.2 114.7 448 181 448 256C448 330.1 411.2 397.3 354.6 437.1C373.9 444.5 394.5 448 416 448C522 448 608 362 608 256C608 149.1 522 64 416 64z"],
    "dial": [576, 512, ["dial-med-high"], "e15b", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM401.1 401.1C338.7 463.6 237.3 463.6 174.9 401.1C112.4 338.7 112.4 237.3 174.9 174.9C237.3 112.4 338.7 112.4 401.1 174.9C463.6 237.3 463.6 338.7 401.1 401.1zM276.7 299.3C270.4 293.1 270.4 282.9 276.7 276.7L366.5 186.9C316.3 147.8 243.6 151.3 197.5 197.5C147.5 247.5 147.5 328.5 197.5 378.5C247.5 428.5 328.5 428.5 378.5 378.5C424.7 332.4 428.2 259.7 389.1 209.5L299.3 299.3C293.1 305.6 282.9 305.6 276.7 299.3L276.7 299.3zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-high": [576, 512, [], "e15c", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM288 448C199.6 448 128 376.4 128 288C128 199.6 199.6 128 288 128C376.4 128 448 199.6 448 288C448 376.4 376.4 448 288 448zM272 288C272 279.2 279.2 272 288 272H415C407.1 208.9 353.3 160 288 160C217.3 160 160 217.3 160 288C160 358.7 217.3 416 288 416C353.3 416 407.1 367.1 415 304H288C279.2 304 272 296.8 272 288zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-low": [576, 512, [], "e15d", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM288 128C376.4 128 448 199.6 448 288C448 376.4 376.4 448 288 448C199.6 448 128 376.4 128 288C128 199.6 199.6 128 288 128zM416 288C416 217.3 358.7 160 288 160C222.7 160 168.9 208.9 160.1 272H288C296.8 272 304 279.2 304 288C304 296.8 296.8 304 288 304H160.1C168.9 367.1 222.7 416 288 416C358.7 416 416 358.7 416 288V288zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-max": [576, 512, [], "e15e", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM174.9 401.1C112.4 338.7 112.4 237.3 174.9 174.9C237.3 112.4 338.7 112.4 401.1 174.9C463.6 237.3 463.6 338.7 401.1 401.1C338.7 463.6 237.3 463.6 174.9 401.1zM378.5 378.5L378.9 378.1L378.1 378.9L378.5 378.5zM299.3 276.7L389.1 366.5C428.2 316.3 424.7 243.6 378.5 197.5C328.5 147.5 247.5 147.5 197.5 197.5C147.5 247.5 147.5 328.5 197.5 378.5C243.6 424.7 316.3 428.2 366.5 389.1L276.7 299.3C270.4 293.1 270.4 282.9 276.7 276.7C282.9 270.4 293.1 270.4 299.3 276.7zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-med": [576, 512, [], "e15f", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM448 288C448 376.4 376.4 448 288 448C199.6 448 128 376.4 128 288C128 199.6 199.6 128 288 128C376.4 128 448 199.6 448 288zM288 304C279.2 304 272 296.8 272 288V160.1C208.9 168.9 160 222.7 160 288C160 358.7 217.3 416 288 416C358.7 416 416 358.7 416 288C416 222.7 367.1 168.9 304 160.1V288C304 296.8 296.8 304 288 304zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-med-low": [576, 512, [], "e160", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM401.1 174.9C463.6 237.3 463.6 338.7 401.1 401.1C338.7 463.6 237.3 463.6 174.9 401.1C112.4 338.7 112.4 237.3 174.9 174.9C237.3 112.4 338.7 112.4 401.1 174.9V174.9zM378.5 378.5C428.5 328.5 428.5 247.5 378.5 197.5C332.4 151.3 259.7 147.8 209.5 186.9L299.3 276.7C305.6 282.9 305.6 293.1 299.3 299.3C293.1 305.6 282.9 305.6 276.7 299.3L186.9 209.5C147.8 259.7 151.3 332.4 197.5 378.5C247.5 428.5 328.5 428.5 378.5 378.5L378.5 378.5zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-min": [576, 512, [], "e161", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM174.9 174.9C237.3 112.4 338.7 112.4 401.1 174.9C463.6 237.3 463.6 338.7 401.1 401.1C338.7 463.6 237.3 463.6 174.9 401.1C112.4 338.7 112.4 237.3 174.9 174.9V174.9zM299.3 276.7C305.6 282.9 305.6 293.1 299.3 299.3L209.5 389.1C259.7 428.2 332.4 424.7 378.5 378.5C428.5 328.5 428.5 247.5 378.5 197.5C328.5 147.5 247.5 147.5 197.5 197.5C151.3 243.6 147.8 316.3 186.9 366.5L276.7 276.7C282.9 270.4 293.1 270.4 299.3 276.7L299.3 276.7zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "dial-off": [576, 512, [], "e162", "M264 32C264 18.75 274.7 8 288 8C301.3 8 312 18.75 312 32C312 45.25 301.3 56 288 56C274.7 56 264 45.25 264 32zM128 288C128 199.6 199.6 128 288 128C376.4 128 448 199.6 448 288C448 376.4 376.4 448 288 448C199.6 448 128 376.4 128 288zM288 272C296.8 272 304 279.2 304 288V415C367.1 407.1 416 353.3 416 288C416 217.3 358.7 160 288 160C217.3 160 160 217.3 160 288C160 353.3 208.9 407.1 272 415V288C272 279.2 279.2 272 288 272zM568 288C568 301.3 557.3 312 544 312C530.7 312 520 301.3 520 288C520 274.7 530.7 264 544 264C557.3 264 568 274.7 568 288zM8 288C8 274.7 18.75 264 32 264C45.25 264 56 274.7 56 288C56 301.3 45.25 312 32 312C18.75 312 8 301.3 8 288zM120 96C120 109.3 109.3 120 96 120C82.75 120 72 109.3 72 96C72 82.75 82.75 72 96 72C109.3 72 120 82.75 120 96zM456 96C456 82.75 466.7 72 480 72C493.3 72 504 82.75 504 96C504 109.3 493.3 120 480 120C466.7 120 456 109.3 456 96zM120 480C120 493.3 109.3 504 96 504C82.75 504 72 493.3 72 480C72 466.7 82.75 456 96 456C109.3 456 120 466.7 120 480zM456 480C456 466.7 466.7 456 480 456C493.3 456 504 466.7 504 480C504 493.3 493.3 504 480 504C466.7 504 456 493.3 456 480z"],
    "diamond": [512, 512, [9830], "f219", "M500.3 227.7C515.9 243.3 515.9 268.7 500.3 284.3L284.3 500.3C268.7 515.9 243.3 515.9 227.7 500.3L11.72 284.3C-3.905 268.7-3.905 243.3 11.72 227.7L227.7 11.72C243.3-3.905 268.7-3.905 284.3 11.72L500.3 227.7zM34.34 250.3C31.22 253.5 31.22 258.5 34.34 261.7L250.3 477.7C253.5 480.8 258.5 480.8 261.7 477.7L477.7 261.7C480.8 258.5 480.8 253.5 477.7 250.3L261.7 34.34C258.5 31.22 253.5 31.22 250.3 34.34L34.34 250.3z"],
    "diamond-exclamation": [512, 512, [], "e405", "M256 303.1c8.832 0 16-7.168 16-16v-144c0-8.832-7.168-16-16-16s-16 7.168-16 16v144C240 296.8 247.2 303.1 256 303.1zM497.7 222.6l-208.2-209.1c-19.01-18.02-50.05-18.02-68.06 0L14.27 222.6c-19.04 17.98-19.04 49.03 0 67.01l208.2 208.1c18.02 19.04 49.05 19.04 67.07 0l208.2-208.1C516.8 271.6 516.8 240.6 497.7 222.6zM475.7 266.4l-.3203 .2871L475.1 267l-208.2 208.1l-.3203 .3203l-.2871 .3203c-5.408 5.664-15.2 5.664-20.61 0l-.2891-.3203l-.3203-.3203L36.9 267L36.58 266.7L36.26 266.4c-5.664-5.377-5.664-15.17 0-20.54l.3848-.3516L36.99 245.1l207.1-209c5.152-5.088 16.13-5.951 23.13 .416l207.8 208.7l.3203 .3516l.3516 .3203C481.4 251.2 481.4 261 475.7 266.4zM256 327.1c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S269.2 327.1 256 327.1z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M497.1 222.1l-208.1-208.1c-9.354-9.355-21.63-14.03-33.89-14.03S231.5 4.674 222.1 14.03L14.03 222.1C4.677 231.5 .0006 243.7 .0004 255.1C.0001 268.3 4.676 280.5 14.03 289.9l208.1 208.1C231.5 507.3 243.7 511.1 256 511.1s24.52-4.679 33.87-14.03l208.1-208.1c9.353-9.356 14.03-21.61 14.03-33.87C511.1 243.7 507.3 231.5 497.1 222.1zM475.3 267.2l-208.1 208.1C263.2 479.4 258.5 480 256 480s-7.191-.6055-11.24-4.66L36.66 267.3c-6.201-6.203-6.201-16.29-.002-22.49l208.1-208.1C248.8 32.61 253.5 32 256 32s7.191 .6055 11.24 4.66l208.1 208.1C481.5 250.1 481.5 261 475.3 267.2zM315.3 148.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L345.4 224H240C213.5 224 192 245.5 192 272v64C192 344.8 199.2 352 208 352S224 344.8 224 336l-.0002-64C223.1 263.2 231.2 256 240 256h105.4l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C295.8 334.4 299.9 336 304 336s8.188-1.562 11.31-4.688l80-80c6.25-6.25 6.25-16.38 0-22.62L315.3 148.7z"],
    "dice": [640, 512, [127922], "f522", "M224 296c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 296 224 296zM128 200c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1S152 237.3 152 224S141.3 200 128 200zM224 200c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 200 224 200zM479.1 376c13.25 0 23.1-10.75 23.1-23.1s-10.75-23.1-23.1-23.1s-23.1 10.75-23.1 23.1S466.7 376 479.1 376zM224 104c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 104 224 104zM575.1 192l-102.7-.0001c3.59 10.21 5.848 20.92 5.848 31.1h96.87c17.62 0 31.1 14.37 31.1 31.1v191.1c0 17.62-14.37 31.1-31.1 31.1h-191.1c-17.62 0-31.1-14.37-31.1-31.1v-56.74L320 423.2v24.84C320 483.4 348.6 512 383.1 512h191.1c35.37 0 63.1-28.62 63.1-63.1v-191.1C639.1 220.6 611.4 192 575.1 192zM320 200c-13.25 0-23.1 10.75-23.1 23.1S306.8 248 320 248s23.1-10.75 23.1-23.1S333.2 200 320 200zM447.1 224c0-17.15-6.691-33.43-18.84-45.83L270.1 19.08C257.4 6.695 241.1 0 223.1 0S190.6 6.695 178.2 18.85L19.07 177.9C6.695 190.6-.0011 206.8-.0011 223.1c0 17.15 6.696 33.48 18.85 45.87l159.1 159.1c12.63 12.38 28.9 19.07 46.06 19.07s33.43-6.693 45.83-18.85l159.1-159.1C441.3 257.4 447.1 241.2 447.1 224zM406.2 247.3l-158.9 158.9c-6.275 6.148-14.56 9.662-23.34 9.662c-8.785 0-17.07-3.514-23.34-9.662L41.79 247.3C35.64 241.1 32.13 232.8 32.13 224c0-8.785 3.516-17.07 9.664-23.34L200.7 41.79c6.275-6.148 14.56-9.662 23.34-9.662c8.785 0 17.07 3.514 23.34 9.662l158.9 158.9c6.15 6.275 9.664 14.56 9.664 23.34C415.9 232.8 412.4 241.1 406.2 247.3z"],
    "dice-d10": [512, 512, [], "f6cd", "M512 282.6c0-7.59-2.683-15.19-8.118-21.32l-224.1-250.6C273.5 3.5 264.8 0 256 0S238.5 3.5 232.2 10.62L8.151 261.3C2.671 267.4 0 274.1 0 282.5C0 291.4 3.662 300.2 10.8 306.5l224.1 197.5C240.9 509.4 248.5 512 256 512c7.5 0 15.12-2.615 21.12-7.99l224.1-197.5C508.4 300.2 512 291.4 512 282.6zM256 298L180.2 247.4l75.87-177l75.87 177L256 298zM148.8 239.8L47.79 265L221 71.12L148.8 239.8zM363.3 239.8L291 71.12L464.5 265L363.3 239.8zM49.04 297.6L157.3 270.5l82.75 55.25v140.3L49.04 297.6zM272 465.9v-140.1l82.75-55.25l108.1 27.12L272 465.9z"],
    "dice-d12": [512, 512, [], "f6ce", "M505.3 178.5l-47.73-95.39c-6.125-12.37-16.25-22.5-28.62-28.62l-95.39-47.73C324.6 2.25 314.9 0 304.9 0H207.1c-10 0-19.75 2.25-28.62 6.75L83.11 54.48C70.73 60.61 60.61 70.73 54.48 83.11l-47.73 95.39C2.25 187.4 0 197.1 0 207.1v97.77c0 10 2.25 19.75 6.75 28.62l47.73 95.4c6.125 12.37 16.25 22.5 28.62 28.62l95.4 47.73C187.4 509.6 197.1 512 207.1 512h97.75c10 0 19.75-2.25 28.62-6.75l95.4-47.73c12.37-6.125 22.5-16.25 28.62-28.62l47.73-95.38C509.6 324.6 512 314.9 512 304.9V207.1C512 197.1 509.8 187.4 505.3 178.5zM475.8 190.9l-95.63 109.2L272 246.1V140.2l157-42.87L475.8 190.9zM308.8 480h-105.5l-55.37-152L256 273.9L364.1 328L308.8 480zM199.5 32h113l82.75 41.38L256 111.4l-139.2-38L199.5 32zM83 97.38L240 140.2v105.9l-108.1 54L36.25 190.9L83 97.38zM32 312.5V234.6l81.96 93.83l48.42 132.9l-74.5-37.25L32 312.5zM424.1 424.1l-74.5 37.25l48.42-132.9L480 234.6V312.5L424.1 424.1z"],
    "dice-d20": [512, 512, [], "f6cf", "M463.9 116.1l-192-111.9C267 1.438 261.5 0 255.1 0S245 1.438 240.1 4.25l-192 111.9C38.12 121.1 32 132.7 32 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C245 510.6 250.5 512 256 512s11-1.438 15.88-4.25l192-111.9C473.9 390 480 379.3 480 367.5V144.5C480 132.7 473.9 121.1 463.9 116.1zM256 57.6l94.75 118.4H161.2L256 57.6zM156.6 207.1h198.8L256 369.5L156.6 207.1zM224.9 380l-137-17.13l44.5-133.3L224.9 380zM379.6 229.6l44.5 133.3l-137 17.13L379.6 229.6zM386.9 169.9l-92.25-115.1l138 80.76L386.9 169.9zM125.1 169.9L79 135.2l138.5-80.76L125.1 169.9zM109.1 197.9L64 333.3l.25-169.1L109.1 197.9zM240 414.1v56.38L117.4 398.8L240 414.1zM395.6 398.6L272 470.9v-56.76L395.6 398.6zM402.9 197.9L448 163.1l-.25 168.8L402.9 197.9zM256.2 480L256.2 480L256.2 480z"],
    "dice-d4": [512, 512, [], "f6d0", "M512 309.1c0-7.05-2.318-14.15-7.127-20.07l-224-277.1C274.5 3.1 265.2 0 256 0C246.8 0 237.5 3.1 231.1 11.88l-224 277.1C2.318 294.9 0 302 0 309.1c0 9.625 4.319 19.15 12.62 25.43l224 170.1C242.4 509.9 249.1 512 256 512c6.875 0 13.62-2.135 19.37-6.51l224-170.1C507.7 328.2 512 318.7 512 309.1zM32.01 309.1L240 51.75v416L32.01 309.1zM271.1 467.9v-416l207.1 257.3L271.1 467.9z"],
    "dice-d6": [448, 512, [], "f6d1", "M431.9 116.1l-192-111.9C235 1.438 229.5 0 224 0S213 1.438 208.1 4.25l-192 111.9C6.125 121.1 0 132.7 0 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C213 510.6 218.5 512 224 512s11-1.438 15.88-4.25l192-111.9C441.9 390 448 379.3 448 367.5V144.5C448 132.7 441.9 121.1 431.9 116.1zM224 32.1l175.8 102.9L224 237.5l-176.1-102.8L224 32.1zM32.25 162.6L208 265.1v205.4L32 367.5L32.25 162.6zM240 470.9V265.1L416 162.5l-.25 205.8L240 470.9z"],
    "dice-d8": [512, 512, [], "f6d2", "M512 256c0-8.643-3.305-17.32-9.868-23.88l-222.2-222.3C273.3 3.26 264.6 0 256 0S238.7 3.26 232.1 9.887L9.868 232.1C3.305 238.7 0 247.4 0 256s3.305 17.27 9.868 23.84l222.2 222.3C238.7 508.7 247.2 512 256 512s17.26-3.26 23.89-9.887l222.2-222.3C508.7 273.4 512 264.7 512 256zM239.1 464.9L61.23 285.9l178.8 76.64V464.9zM239.1 327.8L43.72 243.7L239.1 47.26V327.8zM272 464.9v-102.3l178.8-76.64L272 464.9zM272 327.8v-280.6L468.3 243.7L272 327.8z"],
    "dice-five": [448, 512, [9860], "f523", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-four": [448, 512, [9859], "f524", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-one": [448, 512, [9856], "f525", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232z"],
    "dice-six": [448, 512, [9861], "f526", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM128 232C114.8 232 104 242.8 104 256c0 13.25 10.75 24 24 24S152 269.2 152 256C152 242.8 141.2 232 128 232zM320 232c-13.25 0-24 10.75-24 24c0 13.25 10.75 24 24 24S344 269.2 344 256C344 242.8 333.2 232 320 232zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-three": [448, 512, [9858], "f527", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-two": [448, 512, [9857], "f528", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M539.3 144h-62.42C483.9 132.2 488 118.3 488 104c0-39.7-28.42-72-63.36-72C394.1 32 373.2 41.84 320 128.9C266.8 41.84 245.9 32 215.4 32C180.4 32 152 64.3 152 104c0 14.34 4.072 28.19 11.16 40H96c-53.02 0-96 48.47-96 128S42.98 416 96 416l144-30.86V464c0 5.531 2.875 10.69 7.594 13.62c4.688 2.844 10.59 3.156 15.56 .6875L320 449.9l56.84 28.44C379.1 479.4 381.6 480 384 480c2.938 0 5.844-.8125 8.406-2.375C397.1 474.7 400 469.5 400 464v-78.48L539.3 416C594.9 416 640 351.5 640 272C640 192.5 594.9 144 539.3 144zM240 352.4l-146.8 31.46C63.7 381.2 32 335.1 32 272c0-56.52 26.32-96 64-96h144V352.4zM215.4 144C198.1 144 184 126.1 184 104S198.1 64 215.4 64c14.05 0 27.44 .1953 76.38 80H215.4zM368 438.1l-40.84-20.44c-4.5-2.25-9.812-2.25-14.31 0L272 438.1V176h96V438.1zM348.3 144c48.95-79.8 62.34-80 76.38-80C441.9 64 456 81.95 456 104S441.9 144 424.6 144H348.3zM542.2 383.9L400 352.8V176h139.3C580.4 176 608 214.6 608 272C608 331.1 578.2 381.3 542.2 383.9z"],
    "disc-drive": [512, 512, [], "f8b5", "M256 224C238.4 224 224 238.4 224 256s14.38 32 32 32c17.62 0 32-14.38 32-32S273.6 224 256 224zM496 448H480V96c0-35.35-28.65-64-64-64H96C60.65 32 32 60.65 32 96v352H15.1C7.2 448 0 455.2 0 464S7.2 480 15.1 480h480c8.8 0 16-7.2 16-16S504.8 448 496 448zM448 448H64V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V448zM256 96C167.6 96 96 167.6 96 256s71.62 160 160 160s160-71.63 160-160S344.4 96 256 96zM256 384c-70.75 0-128-57.25-128-128s57.25-128 128-128s128 57.25 128 128C383.9 326.6 326.6 383.9 256 384z"],
    "disease": [512, 512, [], "f7fa", "M159.1 200c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C183.1 210.8 173.2 200 159.1 200zM287.1 296c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C311.1 306.8 301.2 296 287.1 296zM463.9 184.1l-62.88-21.25c-13-4.375-22.5-13.63-25.38-24.5l-15-56.26c-6.25-23.38-25.62-41.38-51.63-48.13C280.2 27.31 250.1 34.94 230.6 54.94L187.4 99.19C178.1 108.6 163.9 113.7 149.2 112.4L81.86 107.2c-31.38-2.5-60.5 12.13-74.25 37C-4.012 165.3-2.262 189.8 12.36 209.6L48.49 258.3c6.875 9.127 7.875 20 3 29.88l-26.75 52.88c-10.62 21.25-8.25 45.25 6.5 64.38c17.88 23 49.25 33.63 80.13 27l65.63-14.12c14.5-3.127 29.62-.125 40.63 8l50.88 38c14 10.25 31 15.75 48.38 15.62c12 0 23.75-2.5 34.75-7.5c23.38-10.62 38.5-31 40.25-54.38l4.375-57.38c.875-10.88 8.375-21 20-26.88l58.13-29.5c24.88-12.62 39.23-36.23 37.48-61.61C509.1 216.6 491.6 194.5 463.9 184.1zM459.9 275.8l-58.13 29.5c-21.75 11-35.75 30.75-37.38 53.01l-4.375 57.38c-1.25 16.63-15.5 24.88-21.62 27.63c-16.75 7.625-36.63 5.875-50.75-4.627l-51-38c-13.62-10.13-31-15.63-48.5-15.63c-6 0-12 .625-17.88 2L104.6 401.2c-23 5-40.13-5.125-48-15.38c-4.125-5.375-10.12-16.5-3.125-30.38l26.5-52.88c10.5-20.63 8.25-44.38-5.75-63.38L38.11 190.5c-9.75-13-5.75-24.88-2.5-30.75c7.75-14 25.38-21.88 43.75-20.63l67.38 5.25c24.25 1.875 47.75-6.625 63.5-22.75l43.25-44.25c11.38-11.63 30-16.13 47.5-11.63c14.75 3.875 25.5 13.5 28.75 25.63l15 56.13c5.75 21.25 23 38.75 46.13 46.5l62.75 21.38c15.62 5.25 25.38 16.38 26.38 29.75C480.9 257.5 473.4 268.1 459.9 275.8zM303.1 192c-8.875 0-15.1 7.122-15.1 15.1c0 8.875 7.125 15.1 15.1 15.1s15.1-7.124 15.1-15.1C319.1 199.1 312.9 192 303.1 192z"],
    "display": [576, 512, [], "e163", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM348.1 480H227.9l19.2-64h81.79L348.1 480zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352z"],
    "display-arrow-down": [576, 512, [], "e164", "M208 176c-4.094 0-8.188 1.562-11.31 4.688c-6.25 6.25-6.25 16.38 0 22.62l80 80c6.25 6.25 16.38 6.25 22.62 0l80-80c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L304 233.4V16C304 7.156 296.8 0 288 0S272 7.156 272 16v217.4L219.3 180.7C216.2 177.6 212.1 176 208 176zM512 0h-144C359.2 0 352 7.162 352 16C352 24.84 359.2 32 368 32H512c17.67 0 32 14.33 32 32v288c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h144C216.8 32 224 24.84 224 16C224 7.162 216.8 0 208 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9z"],
    "display-code": [576, 512, ["desktop-code"], "e165", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352zM235.3 132.7c-6.25-6.25-16.38-6.25-22.62 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62l64 64C215.8 286.4 219.9 288 224 288s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L182.6 208l52.69-52.69C241.6 149.1 241.6 138.9 235.3 132.7zM363.3 132.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L393.4 208l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C343.8 286.4 347.9 288 352 288s8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62L363.3 132.7z"],
    "display-medical": [576, 512, ["desktop-medical"], "e166", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352zM368 176H320V128c0-8.838-7.164-16-16-16h-32C263.2 112 256 119.2 256 128v48H208C199.2 176 192 183.2 192 191.1V224c0 8.836 7.164 15.1 16 15.1H256v48C256 296.8 263.2 304 272 304h32c8.836 0 16-7.165 16-16v-48h48C376.8 239.1 384 232.8 384 224V191.1C384 183.2 376.8 176 368 176z"],
    "display-slash": [640, 512, ["desktop-slash"], "e2fa", "M544 32c17.64 0 32 14.36 32 32v288c0 1.273-.582 2.357-.7266 3.592l27.49 21.7C606.1 369.5 608 360.1 608 352V64c0-35.35-28.65-64-64-64H124.9l40.53 32H544zM464 480h-50.49l-18.96-63.22L353 384H96c-17.64 0-32-14.36-32-32V155.8L32 130.6V352c0 35.35 28.65 64 64 64h149.7l-19.2 64H176C167.2 480 160 487.2 160 496S167.2 512 176 512h288c8.836 0 16-7.164 16-16S472.8 480 464 480zM259.9 480l19.2-64h81.79l19.2 64H259.9zM633.9 483.4L25.92 3.42c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "distribute-spacing-horizontal": [448, 512, [], "e365", "M432 0C440.8 0 448 7.164 448 16V496C448 504.8 440.8 512 432 512C423.2 512 416 504.8 416 496V16C416 7.164 423.2 0 432 0zM320 368C320 394.5 298.5 416 272 416H176C149.5 416 128 394.5 128 368V144C128 117.5 149.5 96 176 96H272C298.5 96 320 117.5 320 144V368zM288 368V144C288 135.2 280.8 128 272 128H176C167.2 128 160 135.2 160 144V368C160 376.8 167.2 384 176 384H272C280.8 384 288 376.8 288 368zM32 496C32 504.8 24.84 512 16 512C7.164 512 0 504.8 0 496V16C0 7.164 7.164 0 16 0C24.84 0 32 7.164 32 16V496z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M512 464C512 472.8 504.8 480 496 480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H496C504.8 448 512 455.2 512 464zM144 352C117.5 352 96 330.5 96 304V208C96 181.5 117.5 160 144 160H368C394.5 160 416 181.5 416 208V304C416 330.5 394.5 352 368 352H144zM144 320H368C376.8 320 384 312.8 384 304V208C384 199.2 376.8 192 368 192H144C135.2 192 128 199.2 128 208V304C128 312.8 135.2 320 144 320zM16 64C7.164 64 0 56.84 0 48C0 39.16 7.164 32 16 32H496C504.8 32 512 39.16 512 48C512 56.84 504.8 64 496 64H16z"],
    "ditto": [320, 512, [], "22", "M63.99 32C45.53 32 27.06 39.64 14.89 54.93C2.692 70.21-2.372 90.22 1.044 109.9l25.21 145.2C29.55 274.1 45.44 288 63.99 288S98.43 274.1 101.7 255l25.24-145.2c3.389-19.6-1.678-39.61-13.88-54.9C100.9 39.64 82.46 32 63.99 32zM70.2 249.6C69.57 253.2 66.9 256 63.99 256S58.42 253.2 57.78 249.5l-25.21-145.2c-1.844-10.59 .8301-21.33 7.357-29.51C45.42 67.96 54.19 64 63.99 64s18.57 3.957 24.09 10.89C94.59 83.04 97.27 93.79 95.44 104.3L70.2 249.6zM305.1 54.93C292.9 39.64 274.5 32 255.1 32s-36.93 7.643-49.1 22.93c-12.2 15.29-17.27 35.3-13.85 54.93l25.21 145.2C221.6 274.1 237.4 288 255.1 288s34.44-13.89 37.74-32.99l25.24-145.2C322.4 90.22 317.3 70.21 305.1 54.93zM262.2 249.6C261.6 253.2 258.9 256 255.1 256s-5.572-2.766-6.211-6.465l-25.21-145.2c-1.844-10.59 .8301-21.33 7.357-29.51C237.4 67.96 246.2 64 255.1 64s18.57 3.957 24.09 10.89c6.506 8.152 9.188 18.9 7.361 29.46L262.2 249.6z"],
    "divide": [448, 512, [10135, 247], "f529", "M432 240h-416C7.156 240 0 247.2 0 256s7.156 16 16 16h416C440.8 272 448 264.8 448 256S440.8 240 432 240zM224 192c35.35 0 64-28.65 64-64s-28.65-64-64-64S160 92.65 160 128S188.7 192 224 192zM224 96c17.64 0 32 14.36 32 32s-14.36 32-32 32S192 145.6 192 128S206.4 96 224 96zM224 320c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S259.3 320 224 320zM224 416c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S241.6 416 224 416z"],
    "dna": [448, 512, [129516], "f471", "M318.8 305.2L297.4 289.6c-7.188-5.219-17.19-3.625-22.34 3.531c-5.203 7.141-3.625 17.16 3.531 22.34l21.42 15.58C308.7 337.4 316.5 344.5 324 352H123.1c7.473-7.488 15.33-14.63 24-20.94l170.8-124.3C379.7 162.6 416 91.23 416 16C416 7.156 408.8 0 400 0S384 7.156 384 16c0 5.375-.5352 10.68-.959 16H64.96C64.54 26.68 64 21.38 64 16C64 7.156 56.84 0 48 0S32 7.156 32 16c0 75.23 36.33 146.6 97.17 190.8L196.8 256L129.2 305.2C68.33 349.4 32 420.8 32 496c0 8.844 7.277 15.1 16.12 15.1S64 504.8 64 496c0-5.375 .5352-10.68 .959-16h318.1C383.5 485.3 384 490.6 384 496c0 8.844 7.156 16 16 16s16-7.156 16-16C416 420.8 379.7 349.4 318.8 305.2zM378.2 64c-5.553 22.81-15.05 44.45-27.88 64H97.66C84.83 108.5 75.33 86.81 69.78 64H378.2zM147.1 180.9C139.3 174.6 131.5 167.5 123.1 160h200c-7.473 7.488-15.33 14.63-24 20.94L224 236.2L147.1 180.9zM69.78 448c5.553-22.81 15.05-44.45 27.88-64h252.7c12.83 19.55 22.33 41.19 27.88 64H69.78z"],
    "do-not-enter": [512, 512, [], "f5ec", "M80 240C80 217.9 97.91 200 120 200H392C414.1 200 432 217.9 432 240V272C432 294.1 414.1 312 392 312H120C97.91 312 80 294.1 80 272V240zM112 272C112 276.4 115.6 280 120 280H392C396.4 280 400 276.4 400 272V240C400 235.6 396.4 232 392 232H120C115.6 232 112 235.6 112 240V272zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"],
    "dog": [576, 512, [128021], "f6d3", "M416 112C416 103.2 423.2 96 432 96C440.8 96 448 103.2 448 112C448 120.8 440.8 128 432 128C423.2 128 416 120.8 416 112zM45.62 159.3C54.52 169.7 67.65 176 81.97 176H306.7L331.9 24.81C334.2 10.49 346.6 0 361.2 0C370.5 0 379.3 4.4 384.9 11.88L400 32H444.1C456.8 32 469.1 37.06 478.1 46.06L496 64H528C554.5 64 576 85.49 576 112V128C576 181 533 224 480 224H437.3L432 255.1V456C432 486.9 406.9 512 376 512H360C329.1 512 304 486.9 304 456V375.3C293.7 378.6 283 381 272 382.4C264.1 383.5 256.1 384 248 384C239.9 384 231.9 383.5 224 382.4C212.1 381 202.3 378.6 192 375.3V456C192 486.9 166.9 512 136 512H120C89.07 512 64 486.9 64 456V208C64 207.3 64.02 206.6 64.06 205.1C63.35 205.8 62.64 205.6 61.94 205.5C34.07 198.3 11.59 176.3 4.359 147.4L.4781 131.9C-1.665 123.3 3.547 114.6 12.12 112.5C20.69 110.3 29.38 115.5 31.52 124.1L35.4 139.6C35.75 141 36.16 142.4 36.62 143.7C38.64 149.6 41.72 154.8 45.62 159.3H45.62zM336 331.5V456C336 469.3 346.7 480 360 480H376C389.3 480 400 469.3 400 456V261.9L307.7 208H96V456C96 469.3 106.7 480 120 480H136C149.3 480 160 469.3 160 456V331.5L201.7 344.8C216.3 349.5 231.8 352 248 352C264.2 352 279.7 349.5 294.3 344.8L336 331.5zM410.2 192H480C515.3 192 544 163.3 544 128V112C544 103.2 536.8 96 528 96H482.7L455.4 68.69C452.4 65.69 448.4 64 444.1 64H384L362.5 35.39L337.1 188.1L404.3 227.3L410.2 192z"],
    "dog-leashed": [576, 512, [129454], "f6d4", "M416 112C416 103.2 423.2 96 432 96C440.8 96 448 103.2 448 112C448 120.8 440.8 128 432 128C423.2 128 416 120.8 416 112zM67.42 6.116C72.88-.8328 82.94-2.04 89.89 3.42L306.1 174L331.9 24.81C334.2 10.49 346.6 .0008 361.2 .0008C370.5 .0008 379.3 4.401 384.9 11.88L400 32H444.1C456.8 32 469.1 37.06 478.1 46.06L496 64H528C554.5 64 576 85.49 576 112V128C576 181 533 224 480 224H437.3L432 256V456C432 486.9 406.9 512 376 512H360C329.1 512 304 486.9 304 456V375.3C293.7 378.6 283 381 272 382.5C264.1 383.5 256.1 384 248 384C239.9 384 231.9 383.5 224 382.5C212.1 381 202.3 378.6 192 375.3V456C192 486.9 166.9 512 136 512H120C89.07 512 64 486.9 64 456V208C64 207.3 64.02 206.6 64.06 205.1C63.35 205.8 62.64 205.6 61.94 205.5C34.07 198.3 11.59 176.3 4.359 147.4L.4781 131.9C-1.665 123.3 3.547 114.6 12.12 112.5C20.69 110.3 29.38 115.5 31.52 124.1L35.4 139.6C35.75 141 36.16 142.4 36.62 143.7C38.64 149.6 41.72 154.8 45.62 159.3C54.52 169.7 67.65 176 81.97 176H257.7L70.11 28.58C63.17 23.12 61.96 13.06 67.42 6.116V6.116zM336 331.5V456C336 469.3 346.7 480 360 480H376C389.3 480 400 469.3 400 456V261.9L307.7 208H288V346.7C290.1 346.1 292.2 345.5 294.3 344.8L336 331.5zM256 208H96V456C96 469.3 106.7 480 120 480H136C149.3 480 160 469.3 160 456V331.5L201.7 344.8C216.3 349.5 231.8 352 247.1 352C250.7 352 253.4 351.9 256 351.8V208zM410.2 192H480C515.3 192 544 163.3 544 128V112C544 103.2 536.8 96 528 96H482.7L455.4 68.69C452.4 65.69 448.4 64 444.1 64H384L362.5 35.39L337.1 188.1L404.3 227.3L410.2 192z"],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", "M176 64.78C207.7 67.45 237.9 73.82 259.8 79.15C268.4 81.24 273.6 89.89 271.5 98.48C269.5 107.1 260.8 112.3 252.2 110.2C219.2 102.2 170.2 92.71 127.9 96.25C106.8 98.02 88.75 102.9 75.32 111.7C62.43 120.2 53.01 132.6 49.36 151.9C46.56 166.7 48.33 177.5 52.35 185.7C56.46 194.2 63.66 201.6 74.26 208.4C96.21 222.4 128.3 230.9 164.1 240.3L165.7 240.7C199.4 249.5 236.3 259.2 262.9 276.2C276.9 285.1 288.1 296.5 296.4 311.8C303.1 327.3 305.9 345.2 302.1 365.5C295.6 399.8 271.4 422.9 239.4 435.4C220.8 442.7 199.2 446.6 176 447.4V496C176 504.8 168.8 512 160 512C151.2 512 144 504.8 144 496V446.5C137.8 445.1 131.5 445.3 125.1 444.3L125 444.3C98.79 440.4 59.31 431.4 25.67 416.9C17.55 413.4 13.81 403.1 17.31 395.9C20.81 387.8 30.22 384 38.33 387.5C68.67 400.6 105.3 409 129.7 412.7C168.6 418.2 202.8 415.4 227.7 405.6C252.2 396 266.7 380.3 270.6 359.6C273.4 344.8 271.7 334.1 267.6 325.8C263.5 317.4 256.3 309.9 245.7 303.2C223.8 289.2 191.7 280.6 155.9 271.2L154.3 270.8C120.6 262 83.71 252.3 57.06 235.4C43.14 226.5 31.01 215 23.57 199.7C16.05 184.2 14.07 166.3 17.91 146C23.2 118 37.72 98.08 57.81 84.94C77.36 72.16 101.3 66.38 125.2 64.37C131.4 63.85 137.7 63.58 144 63.51V16C144 7.164 151.2 0 160 0C168.8 0 176 7.164 176 16V64.78z"],
    "dolly": [576, 512, ["dolly-box"], "f472", "M575 330.5c-3.078-8.312-12.25-12.52-20.55-9.484l-223.9 82.5C319 373.4 290.1 352 256 352c-5.018 0-9.889 .5918-14.65 1.477L141.8 54.7C130.9 21.98 100.4 0 65.88 0H15.1C7.155 0 0 7.157 0 16S7.156 32 16 32h49.88c20.69 0 38.98 13.19 45.55 32.83l100.2 300.6C190.2 379.8 176 404.2 176 432C176 476.2 211.8 512 256 512c42.91 0 77.64-33.87 79.63-76.29l229.9-84.7C573.8 347.1 578.1 338.8 575 330.5zM256 480c-26.47 0-48-21.53-48-48s21.54-47.1 48-47.1S304 405.5 304 432S282.5 480 256 480zM286.7 302.7c6.545 19.64 24.84 32.83 45.53 32.83c5.154 0 10.26-.832 15.18-2.471l131.3-43.76c12.16-4.055 22.02-12.6 27.75-24.07c5.734-11.47 6.658-24.48 2.605-36.64l-43.76-131.3c-6.545-19.64-24.84-32.83-45.53-32.83c-5.154 0-10.26 .832-15.18 2.471L273.3 110.7c-12.16 4.055-22.02 12.6-27.75 24.07C239.8 146.2 238.9 159.3 242.9 171.4L286.7 302.7zM274.2 149.1c1.939-3.879 5.139-6.654 9.252-8.025l131.3-43.76c1.654-.5508 3.359-.8301 5.068-.8301c6.895 0 12.99 4.4 15.18 10.95l43.76 131.3c1.371 4.115 1.072 8.34-.8672 12.22c-1.939 3.879-5.139 6.654-9.252 8.025l-131.3 43.76c-1.656 .5527-3.361 .832-5.07 .832c-6.895 0-12.99-4.4-15.18-10.95L273.3 161.3C271.9 157.2 272.2 152.1 274.2 149.1z"],
    "dolly-empty": [576, 512, [], "f473", "M575 330.5c-3.078-8.312-12.25-12.52-20.55-9.484l-223.9 82.5C319 373.4 290.1 352 256 352c-5.018 0-9.889 .5918-14.65 1.477L141.8 54.7C130.9 21.98 100.4 0 65.88 0H15.1C7.155 0 0 7.157 0 16S7.156 32 16 32h49.88c20.69 0 38.98 13.19 45.55 32.83l100.2 300.6C190.2 379.8 176 404.2 176 432C176 476.2 211.8 512 256 512c42.91 0 77.64-33.87 79.63-76.29l229.9-84.7C573.8 347.1 578.1 338.8 575 330.5zM256 480c-26.47 0-48-21.53-48-48s21.53-47.1 47.1-47.1S304 405.5 304 432S282.5 480 256 480z"],
    "dolphin": [512, 512, [], "e168", "M436.9 136.9l-9.347-7.969c9.409-21.31 24.88-46.75 46.14-75.87c8.659-11.97 8.347-27.28-.719-38.97c-8.409-10.84-21.38-15.81-35.51-13.62c-41.95 6.594-82.28 19.12-120 37.31c-35.86-25.09-63.78-37.82-107.5-37.82L201.6 .0062c-82.1 0-153.4 55.94-167.3 132.1C29.9 157.1 31.4 181.5 38.75 205.5L21.21 217.2C3.673 228.9-4.048 250.3 2.079 270.4c6.158 20.41 24.13 33.59 45.77 33.59H399.1c8.847 0 16.01-7.156 16.01-15.1c0-8.844-7.159-15.1-16.01-15.1H47.84c-11 0-14.38-8.312-15.13-10.84C31.09 255.8 31.9 248.5 38.97 243.8l38.54-25.66L72.82 206.2C64.1 183.8 61.72 161.1 65.79 138.7c11.03-60.81 69.43-106.7 135.8-106.7h8.315c38.58 0 60.99 11.53 96.72 37.37l7.94 5.75l8.722-4.469c37.2-18.1 77.31-31.97 119.1-38.53c3.783-.5937 4.72 .875 5.408 2.156c-26.45 36.25-44.77 67.78-54.39 93.75L389.6 138.5l26.79 22.94c22.26 18.72 63.65 53.53 63.65 126.6c0 70.59-57.43 127.1-128 127.1H296.6l-31.17-48.06c-7.44-9.969-19.69-15.94-32.79-15.94H171.9c-10.91 0-20.6 5.812-25.29 15.19c-4.376 8.75-3.407 19.09 2.501 26.94l28.38 37.87l-28.35 37.81c-5.908 7.906-6.877 18.25-2.47 26.1C151.3 506.2 161.1 512 172 512H232.7c13.1 0 25.29-5.969 33.35-16.81l30.56-47.19h55.31C440.2 448 512 376.2 512 288C512 200 461.3 157.4 436.9 136.9zM239.8 476.9c-1.407 1.844-4.22 3.062-7.159 3.062H181.5l35.98-47.1l-35.98-47.1l51.19-.0008c2.938 0 5.707 1.22 6.489 2.188l29.67 45.81L239.8 476.9zM127.9 152c0 13.26 10.75 24 24.01 24c13.26 0 24.01-10.75 24.01-24c0-13.26-10.75-23.1-24.01-23.1C138.6 128 127.9 138.7 127.9 152z"],
    "dong-sign": [384, 512, [], "e169", "M320 48V64H336C344.8 64 352 71.16 352 80C352 88.84 344.8 96 336 96H320V400C320 408.8 312.8 416 304 416C295.2 416 288 408.8 288 400V372.7C264.5 399.2 230.2 416 192 416C121.3 416 64 358.7 64 288C64 217.3 121.3 160 192 160C230.2 160 264.5 176.8 288 203.3V96H208C199.2 96 192 88.84 192 80C192 71.16 199.2 64 208 64H288V48C288 39.16 295.2 32 304 32C312.8 32 320 39.16 320 48V48zM288 288C288 234.1 245 192 192 192C138.1 192 96 234.1 96 288C96 341 138.1 384 192 384C245 384 288 341 288 288zM368 448C376.8 448 384 455.2 384 464C384 472.8 376.8 480 368 480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H368z"],
    "donut": [512, 512, [127849, "doughnut"], "e406", "M512 208V304C512 392.4 397.4 464 256 464C114.6 464 0 392.4 0 304V208C0 119.6 114.6 48 256 48C397.4 48 512 119.6 512 208zM479.9 281.6C478.3 282.4 477.2 283.4 475.5 284.1C462.2 289.2 450.1 298.6 443.5 310.8C433.7 323.4 420.9 333.4 406.3 339.9C391.6 346.3 375.6 348.1 359.6 347.6C341.8 347.4 324.2 350.9 307.8 357.8C274.5 371.4 237.3 371.4 204.1 357.8C187.7 350.9 170 347.4 152.2 347.6C136.3 348.1 120.2 346.3 105.6 339.9C90.93 333.4 78.13 323.4 68.35 310.8C60.9 298.6 49.66 289.2 36.35 284.1C34.72 283.4 33.54 282.4 32 281.6V304C32 373.4 134.6 432 256 432C377.4 432 480 373.4 480 304L479.9 281.6zM480 207.8C480 148.6 404.8 97.25 306.1 83.65L283.3 107.3C280.3 110.3 276.2 112 272 112C267.8 112 263.7 110.3 260.7 107.3C257.7 104.3 255.1 100.2 255.1 96C255.1 91.75 257.7 87.68 260.7 84.67L265.1 80.29C262 80.19 259.2 80 256 80C134.6 80 32 138.6 32 208C32 208 32 235.6 32 240.1C32 242.3 36 248.1 49.38 254.7C69.27 262.6 85.94 276.1 96.74 295.5C103.9 302.8 112.7 308.3 122.3 311.8C131.9 315.2 142.2 316.5 152.4 315.5C174.6 315.3 196.7 319.6 217.2 328.3C242.2 338.3 270.1 338.3 295.1 328.3C315.6 319.6 337.6 315.3 359.8 315.5C370 316.5 380.3 315.2 389.9 311.8C399.6 308.3 408.3 302.8 415.5 295.5C415.8 294.9 416.4 294.4 416.7 293.8C415.3 293.1 413.1 292.2 412.8 291.2L380.8 259.2C378.5 256.1 377.4 252.3 377.6 248.5C377.9 244.6 379.6 241 382.3 238.3C385 235.6 388.6 233.9 392.5 233.6C396.3 233.4 400.1 234.5 403.2 236.8L435.2 268.8C435.7 269.4 436.2 270.1 436.7 270.8C444.6 264.3 453.4 258.9 462.8 254.8C476 248.1 480 242.3 480 240.1C480 235.6 480 207.8 480 207.8zM427.3 164.7C428.8 166.2 429.1 167.9 430.8 169.9C431.6 171.8 432 173.9 432 176C432 178.1 431.6 180.2 430.8 182.1C429.1 184.1 428.8 185.8 427.3 187.3C425.8 188.8 424.1 189.1 422.1 190.8C420.2 191.6 418.1 192 416 192C413.9 192 411.8 191.6 409.9 190.8C407.9 189.1 406.2 188.8 404.7 187.3L372.7 155.3C369.7 152.3 367.1 148.2 367.1 144C367.1 139.8 369.7 135.7 372.7 132.7C375.7 129.7 379.8 127.1 384 127.1C388.2 127.1 392.3 129.7 395.3 132.7L427.3 164.7zM187.3 276.7C190.3 279.7 192 283.8 192 288C192 292.2 190.3 296.3 187.3 299.3C184.3 302.3 180.2 304 176 304C171.8 304 167.7 302.3 164.7 299.3L132.7 267.3C129.7 264.3 127.1 260.2 127.1 256C127.1 251.8 129.7 247.7 132.7 244.7C135.7 241.7 139.8 239.1 144 239.1C148.2 239.1 152.3 241.7 155.3 244.7L187.3 276.7zM320 255.1C324.2 255.1 328.3 257.7 331.3 260.7C334.3 263.7 336 267.8 336 272C336 276.2 334.3 280.3 331.3 283.3L299.3 315.3C296.3 318.3 292.2 320 288 320C283.8 320 279.7 318.3 276.7 315.3C273.7 312.3 271.1 308.2 271.1 304C271.1 299.8 273.7 295.7 276.7 292.7L308.7 260.7C311.7 257.7 315.8 255.1 320 255.1zM107.3 196.7C110.3 199.7 112 203.8 112 208C112 212.2 110.3 216.3 107.3 219.3C104.3 222.3 100.2 224 96 224H64C59.76 224 55.69 222.3 52.69 219.3C49.69 216.3 48 212.2 48 208C48 203.8 49.69 199.7 52.69 196.7C55.69 193.7 59.76 192 64 192H96C100.2 192 104.3 193.7 107.3 196.7zM128 176C123.8 176 119.7 174.3 116.7 171.3C113.7 168.3 111.1 164.2 111.1 160C111.1 155.8 113.7 151.7 116.7 148.7L148.7 116.7C151.7 113.7 155.8 111.1 160 111.1C164.2 111.1 168.3 113.7 171.3 116.7C174.3 119.7 176 123.8 176 128C176 132.2 174.3 136.3 171.3 139.3L139.3 171.3C136.3 174.3 132.2 176 128 176zM336 192C336 219.4 301.6 240 256 240C210.4 240 176 219.4 176 192C176 164.6 210.4 144 256 144C301.6 144 336 164.6 336 192zM304 192C304 182.9 283.4 176 256 176C228.6 176 208 182.9 208 192C208 201.1 228.6 208 256 208C283.4 208 304 201.1 304 192z"],
    "door-closed": [576, 512, [128682], "f52a", "M560 480H480V80C480 35.88 444.1 0 400 0h-224C131.9 0 96 35.88 96 80V480H16C7.164 480 0 487.2 0 496C0 504.8 7.164 512 16 512h544c8.836 0 16-7.164 16-16C576 487.2 568.8 480 560 480zM448 480H128V80C128 53.53 149.5 32 176 32h224C426.5 32 448 53.53 448 80V480zM384 232c-13.25 0-24 10.75-24 24S370.7 280 384 280S408 269.3 408 256S397.3 232 384 232z"],
    "door-open": [576, 512, [], "f52b", "M232 224c-13.25 0-24 14.33-24 31.1S218.7 288 232 288S256 273.7 256 256S245.3 224 232 224zM260.4 1.443l-160 40C78.1 46.79 64 65.1 64 88.03V480H16C7.164 480 0 487.2 0 496C0 504.8 7.164 512 16 512H288c17.67 0 32-14.33 32-32V49.15c0-10.14-2.611-20.34-8.523-28.59C299.4 3.707 279.3-3.279 260.4 1.443zM288 480H96V88.04c0-7.373 5-13.75 12.12-15.53l160-40C272.9 31.22 277.9 32.38 281.8 35.41C285.8 38.47 288 43.07 288 48.04V480zM560 480H512V144c0-44.18-35.82-79.1-79.1-79.1H368c-8.836 0-16 7.162-16 15.1s7.164 16 16 16h64c26.51 0 48 21.49 48 48V480c0 17.67 14.33 32 32 32h48c8.836 0 16-7.164 16-15.1C576 487.2 568.8 480 560 480z"],
    "dove": [512, 512, [128330], "f4ba", "M248 159.3c-4.97 0-9.862-2.313-12.99-6.626C220.6 132.6 208.5 111.2 199.2 88.71c-3.001 6.907-5.798 13.94-7.986 20.41C188.3 117.5 179.2 121.9 170.9 119.1C162.5 116.3 158 107.2 160.8 98.81c7.377-21.69 19.65-46.75 27.44-59.29C191.7 34.14 197.1 31.39 204.1 32.11c6.283 .9063 11.44 5.407 13.16 11.53c9.08 32.35 23.79 62.72 43.7 90.32c5.173 7.188 3.563 17.19-3.61 22.35C254.6 158.4 251.3 159.3 248 159.3zM359.1 159.1c0 13.13 10.88 24 24.01 24s24.01-10.88 24.01-24c0-13.31-10.88-24-24.01-24S359.1 146.7 359.1 159.1zM512 63.97l-32 95.95l.002 128.2c0 88.37-71.62 159.9-160 159.9l-53.17 .1683l-63.89 54.75C200.4 505.2 191.2 512.6 177.7 511.1c-105.5-4.358-154.6-55.85-174.6-86.64c-7.013-10.78-1.653-25.19 10.83-28.31l128.6-32.18C41.64 283.2 31.32 195.1 31.94 153.1C32.45 112.1 41.76 75.1 57.76 41.09c5.826-12.38 23.7-11.86 29.21 .6633c57.44 130.6 185.3 155.4 200.1 158.2v-40.39c0-52.79 42.8-95.59 95.6-95.59c.1426 0 .2924 .0163 .435 .0163L512 63.97zM467.6 95.93h-83.64l-.3653 .0371c-35.09 .2031-63.65 28.84-63.65 64.09v78.13C299.1 235.8 156.3 226.2 74.15 87.05C67.65 108.6 64.15 130.7 63.9 153.4c-1.625 122.9 100.9 188.3 148.5 227l-170.8 42.75c21.51 24.5 62.76 53.75 137.4 56.88c.7502 0 76.02-63.88 76.02-63.88h64.89c70.64 0 128-57.51 128-128V154.7L467.6 95.93z"],
    "down": [384, 512, ["arrow-alt-down"], "f354", "M112 64v176H32c-17.69 0-32 14.36-32 31.1C0 280.3 3.252 288.5 9.375 294.6l160 176C175.6 476.9 183.8 480 192 480s16.38-3.125 22.62-9.375l160-176C380.7 288.5 384 280.3 384 271.1C384 254.4 369.7 240 352 240h-80V64c0-17.67-14.33-32-32-32h-96C126.3 32 112 46.33 112 64zM240 64v208l110.9 1.1L192 447.9L32 272H144V64H240z"],
    "down-from-dotted-line": [448, 512, [], "e407", "M364.1 334.6L253.9 458.6C237.1 476.5 210 476.5 194.1 458.6L83.92 334.6C60.99 308.8 79.3 268 113.8 268H160V164C160 141.1 177.9 124 200 124H248C270.1 124 288 141.1 288 164V268H334.2C368.7 268 387 308.8 364.1 334.6V334.6zM113.8 300C106.9 300 103.2 308.2 107.8 313.4L218 437.3C221.2 440.9 226.8 440.9 229.1 437.3L340.2 313.4C344.8 308.2 341.1 300 334.2 300H256V164C256 159.6 252.4 156 248 156H200C195.6 156 192 159.6 192 164V300H113.8zM56 60.04C56 73.29 45.25 84.04 32 84.04C18.75 84.04 8 73.29 8 60.04C8 46.78 18.75 36.04 32 36.04C45.25 36.04 56 46.78 56 60.04zM392 60.04C392 46.79 402.7 36.04 416 36.04C429.3 36.04 440 46.79 440 60.04C440 73.3 429.3 84.04 416 84.04C402.7 84.04 392 73.3 392 60.04zM344 60.04C344 73.3 333.3 84.04 320 84.04C306.7 84.04 296 73.3 296 60.04C296 46.79 306.7 36.04 320 36.04C333.3 36.04 344 46.79 344 60.04zM200 60.04C200 46.79 210.7 36.04 224 36.04C237.3 36.04 248 46.79 248 60.04C248 73.3 237.3 84.04 224 84.04C210.7 84.04 200 73.3 200 60.04zM152 60.04C152 73.3 141.3 84.04 128 84.04C114.7 84.04 104 73.3 104 60.04C104 46.79 114.7 36.04 128 36.04C141.3 36.04 152 46.79 152 60.04z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M314.4 272H256V156.8C256 132.1 235.9 112 211.2 112H172.8C148.1 112 128 132.1 128 156.8V272H69.59c-15 0-28.53 8.906-34.53 22.75c-5.938 13.8-3.125 29.78 7.062 40.55l122.5 133.2C171.5 475.8 181.5 480 192 480s20.47-4.188 27.5-11.66l122.2-132.9c10.34-10.92 13.16-26.91 7.219-40.77C342.9 280.9 329.4 272 314.4 272zM318.3 313.6l-122.2 132.9c-1.75 1.812-6.594 1.656-8.031 .1562L65.53 313.5C64 311.8 63.56 309.5 64.44 307.4C65.34 305.3 67.38 304 69.59 304H160V156.8C160 149.8 165.8 144 172.8 144h38.38C218.3 144 224 149.8 224 156.8V304h90.41c2.219 0 4.25 1.344 5.156 3.375C320.4 309.5 320 311.8 318.3 313.6zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "down-left": [384, 512, [], "e16a", "M358.6 157.3l-67.88-67.88C284.5 83.13 276.3 80 268.1 80s-16.38 3.125-22.63 9.375L119.1 215.7L57.21 153.8C50.8 147.4 42.22 144 33.5 144c-4.316 0-8.668 .8359-12.81 2.551C8.158 151.7 0 163.9 0 177.5v236.1c0 9.254 3.75 17.63 9.812 23.7C15.88 444.3 24.25 448 33.51 448h236.1c13.56 0 25.77-8.156 30.96-20.69c5.184-12.52 2.314-26.94-7.268-36.52l-61.92-61.92l126.4-126.4C371.1 190 371.1 169.8 358.6 157.3zM335.1 179.9l-148.1 148.1l84.54 84.55c.4297 .4297 .5605 1.09 .3281 1.648C271.7 415.6 271.1 416 270.5 416H33.51L32 414.5V177.5C32 176.9 32.36 176.4 32.94 176.1l1.645 .332l84.54 84.54l148.1-148.1L335.1 179.9z"],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", "M304 240h111.1c13 0 24.59-7.766 29.56-19.77s2.25-25.69-6.938-34.86l-44.67-44.67l97.39-97.39c6.248-6.25 6.248-16.38 0-22.62c-6.248-6.25-16.38-6.25-22.62 0l-97.38 97.38L326.6 73.39c-6.156-6.125-14.28-9.375-22.59-9.375c-4.125 0-8.312 .8125-12.28 2.453C279.8 71.45 272 83.05 272 96.03V208C272 225.7 286.3 240 304 240zM304 96.03l112 111.1c0 0 .0938 0 0 0L304 208V96.03zM208 272H96.03c-13 0-24.59 7.766-29.56 19.77s-2.25 25.69 6.938 34.86l44.67 44.67l-97.39 97.39c-6.248 6.25-6.248 16.38 0 22.62c6.248 6.25 16.38 6.25 22.62 0l97.38-97.38l44.68 44.68c6.156 6.125 14.28 9.375 22.59 9.375c4.125 0 8.312-.8125 12.28-2.453C232.3 440.5 240 428.1 240 415.1V304C240 286.3 225.7 272 208 272zM208 415.1L95.95 304c0 0-.0938 0 0 0L208 304V415.1z"],
    "down-long": [320, 512, ["long-arrow-alt-down"], "f309", "M136 0h47.1c22.06 0 39.1 17.97 39.1 40.03l.0012 280.3l39.1 .1514c15.91 0 30.31 9.438 36.65 24c6.375 14.62 3.5 31.56-7.343 43.22l-103.1 112.1c-7.533 8.158-18.42 12.24-29.31 12.23c-10.89-.002-21.78-4.08-29.34-12.23l-103.1-112.1c-10.84-11.66-13.72-28.59-7.343-43.22c6.343-14.56 20.75-24 36.65-24l39.1-.1514l.0008-280.3C96 17.97 113.9 0 136 0zM160 480.6c1.312 0 3.781-.3438 5.844-2.562l104-112.1c4.7-5.109 1.142-13.47-5.875-13.47h-71.1l-.0002-312.5C191.1 35.59 188.4 32 183.1 32H136C131.6 32 128 35.59 128 40.03l.0002 312.5H56c-7.022 0-10.57 8.363-5.875 13.47l103.1 112.1C156.2 480.2 158.7 480.6 160 480.6z"],
    "down-right": [384, 512, [], "e16b", "M25.37 202.5l126.4 126.4l-61.92 61.92c-9.582 9.578-12.45 24-7.268 36.52C87.74 439.8 99.95 448 113.5 448h236.1c9.258 0 17.63-3.75 23.7-9.812c6.062-6.066 9.812-14.44 9.812-23.7V177.5c0-13.57-8.158-25.77-20.69-30.96C359.2 144.8 354.8 144 350.5 144c-8.723 0-17.3 3.406-23.71 9.816l-61.92 61.92L138.5 89.38C132.3 83.13 124.1 80 115.9 80S99.5 83.13 93.25 89.38L25.37 157.3C12.88 169.8 12.87 190 25.37 202.5zM115.9 112l148.1 148.1l84.54-84.54l1.645-.332c.5781 .2422 .9375 .7773 .9375 1.402v236.1L350.5 416H113.5c-.625 0-1.164-.3594-1.398-.9297c-.2324-.5586-.1016-1.219 .3281-1.648l84.54-84.55L48 179.9L115.9 112z"],
    "down-to-bracket": [448, 512, [], "e4e7", "M201.4 374.6L73.38 246.6C64.22 237.5 61.47 223.7 66.44 211.8C71.38 199.8 83.06 192 96 192H160V48C160 21.49 181.5 0 208 0H240C266.5 0 288 21.49 288 48V192H352C364.9 192 376.6 199.8 381.6 211.8C386.5 223.7 383.8 237.5 374.6 246.6L246.6 374.6C240.4 380.9 232.2 384 224 384C215.8 384 207.6 380.9 201.4 374.6V374.6zM224 351.1L352 223.1L256 224V48C256 39.18 248.8 32 240 32H208C199.2 32 192 39.18 192 48V224H96L224 351.1zM368 512H80C35.87 512 0 476.1 0 432V336C0 327.2 7.156 320 16 320C24.84 320 32 327.2 32 336V432C32 458.5 53.53 480 80 480H368C394.5 480 416 458.5 416 432V336C416 327.2 423.2 320 432 320C440.8 320 448 327.2 448 336V432C448 476.1 412.1 512 368 512z"],
    "down-to-dotted-line": [448, 512, [], "e408", "M364.1 246.6L253.9 370.6C237.1 388.5 210 388.5 194.1 370.6L83.92 246.6C60.99 220.8 79.3 180 113.8 180H160V76.04C160 53.95 177.9 36.04 200 36.04H248C270.1 36.04 288 53.95 288 76.04V180H334.2C368.7 180 387 220.8 364.1 246.6zM113.8 212C106.9 212 103.3 220.2 107.8 225.4L218 349.3C221.2 352.9 226.8 352.9 229.1 349.3L340.2 225.4C344.8 220.2 341.1 212 334.2 212H256V76.04C256 71.62 252.4 68.04 248 68.04H200C195.6 68.04 192 71.62 192 76.04V212H113.8zM392 448C392 434.8 402.7 424 416 424C429.3 424 440 434.8 440 448C440 461.3 429.3 472 416 472C402.7 472 392 461.3 392 448zM56 448C56 461.3 45.25 472 32 472C18.75 472 8 461.3 8 448C8 434.7 18.75 424 32 424C45.25 424 56 434.7 56 448zM104 448C104 434.7 114.7 424 128 424C141.3 424 152 434.7 152 448C152 461.3 141.3 472 128 472C114.7 472 104 461.3 104 448zM248 448C248 461.3 237.3 472 224 472C210.7 472 200 461.3 200 448C200 434.7 210.7 424 224 424C237.3 424 248 434.7 248 448zM296 448C296 434.7 306.7 424 320 424C333.3 424 344 434.7 344 448C344 461.3 333.3 472 320 472C306.7 472 296 461.3 296 448z"],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", "M164.7 388.5C171.5 395.8 181.5 400 192 400s20.47-4.188 27.5-11.66l122.2-132.9c10.34-10.92 13.16-26.91 7.219-40.77C342.9 200.9 329.4 192 314.4 192L256 192.1V76.83C256 52.11 235.9 32 211.2 32H172.8C148.1 32 128 52.11 128 76.83v115.3L69.59 192c-15 0-28.53 8.906-34.53 22.75C29.13 228.5 31.94 244.5 42.13 255.3L164.7 388.5zM64.44 227.4C65.34 225.3 67.38 224 69.59 224H160V76.83C160 69.75 165.8 64 172.8 64h38.38C218.3 64 224 69.75 224 76.83V224h90.41c2.219 0 4.25 1.344 5.156 3.375C320.4 229.5 320 231.8 318.3 233.6l-122.2 132.9c-1.75 1.812-6.594 1.656-8.031 .1562L65.53 233.5C64 231.8 63.56 229.5 64.44 227.4zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "download": [512, 512, [], "f019", "M245.4 379.1C248.4 382.7 252.2 384 256 384s7.594-1.344 10.62-4.047l144-128c6.594-5.859 7.219-15.98 1.344-22.58c-5.875-6.625-16.06-7.234-22.59-1.328L272 332.4V16C272 7.156 264.8 0 256 0S240 7.156 240 16v316.4L122.6 228C116.1 222.1 105.9 222.8 100 229.4C94.16 235.1 94.78 246.1 101.4 251.1L245.4 379.1zM448 320h-48c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H448c17.67 0 32 14.33 32 32v64c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32v-64c0-17.67 14.33-32 32-32h48C120.8 352 128 344.8 128 336C128 327.2 120.8 320 112 320H64c-35.35 0-64 28.65-64 64v64c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64v-64C512 348.7 483.3 320 448 320zM440 416c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S440 429.3 440 416z"],
    "dragon": [640, 512, [128009], "f6d5", "M535.6 251.8c-37.84-21.48-55.67-33.55-55.67-51.42L479.1 192h16.95l28.6 21.99C533.8 220.5 543.1 224 554.8 224h29.25c21.04 0 39.93-14.15 45.93-34.41l7.398-25.2c5.859-19.78 1.898-41.45-10.62-57.89l-56.86-74.85C554.9 11.84 531 0 506.1 0h-168.8C323.7 0 311.6 8.572 307.1 21.38C302.6 34.2 306.7 48.46 317.3 56.96l18.1 14.53l-11.66 4.814C311.7 81.27 303.8