<?php echo RecaptchaV3::initJs(); ?>

<meta name="description" content="We\'re available around the clock. Let us know how we can help!" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="position-relative py-lg-5 pt-5" style="background-image: url(<?php echo e(asset('asset/images/auth.svg')); ?>);" data-jarallax data-img-position="0% 100%" data-speed="0.5">
    <div class="container position-relative zindex-2 pt-5 pb-2 pb-md-0 py-6">
        <div class="row justify-content-center pt-3 mt-3">
            <div class="col-xl-6 col-lg-7 col-md-8 col-sm-10 text-center">
                <h1 class="mb-4"><?php echo e(__('Contact Support')); ?></h1>
                <p><?php echo e(__('We\'re available around the clock. Let us know how we can help!')); ?></p>
            </div>
        </div>
    </div>
</section>
<section class="position-relative bg-secondary pt-5">
    <div class="container position-relative zindex-2 pt-5">
        <div class="row">
            <!-- Contact links -->
            <div class="col-xl-4 col-lg-5 pb-4 pb-sm-5 mb-2 mb-sm-0">
                <h2 class="pb-3 mb-1 mb-lg-3"><?php echo e(__('Need a quick answer')); ?>?</h2>
                <p class="pb-3 mb-2 mb-lg-3 text-dark"><?php echo e(__('The '.$set->site_name.' Help Desk has')); ?>:</p>
                <ul class="list-unstyled">
                    <li class="d-flex align-items-center fs-sm mb-2">
                        <i class="bx bx-check fs-xl text-primary me-2"></i>
                        <?php echo e(__('Detailed guides and instructions')); ?>

                    </li>
                    <li class="d-flex align-items-center fs-sm mb-2">
                        <i class="bx bx-check fs-xl text-primary me-2"></i>
                        <?php echo e(__('Answers to common questions')); ?>

                    </li>
                </ul>
                <a href="<?php echo e(route('help.center')); ?>" class="btn btn-link px-0 mb-5 text-info">
                    <?php echo e(__('Search Help Center')); ?>

                    <i class="bx bx-right-arrow-alt fs-xl ms-2"></i>
                </a>
                <h2 class="pb-3 mb-1 mb-lg-3"><?php echo e(__('Reach us')); ?></h2>
                <ul class="list-unstyled">
                    <li class="d-flex align-items-center fs-sm mb-2">
                        <i class="bx bx-check fs-xl text-primary me-2"></i>
                        <a href="mailto:<?php echo e($set->email); ?>" class="nav-link d-inline-block px-0 pt-1 pb-2"><?php echo e($set->email); ?></a>
                    </li>
                    <li class="d-flex align-items-center fs-sm mb-2">
                        <i class="bx bx-check fs-xl text-primary me-2"></i>
                        <a href="tel:<?php echo e($set->mobile); ?>" class="nav-link d-inline-block px-0 pt-1 pb-2"><?php echo e($set->mobile); ?></a>
                    </li>
                </ul>
            </div>

            <!-- Contact form -->
            <div class="col-xl-6 col-lg-7 offset-xl-2">
                <div class="card border-light shadow-lg">
                    <div class="bg-dark position-absolute top-0 start-0 w-100 h-100 rounded-3 d-none d-dark-mode-block"></div>
                    <div class="card-body position-relative zindex-2">
                        <form class="row g-4" method="post" action="<?php echo e(route('contact-submit')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="col-6">
                                <label for="fn" class="form-label fs-base"><?php echo e(__('First name')); ?></label>
                                <input type="text" class="form-control form-control-lg" id="fn" value="<?php echo e(old('first_name')); ?>" name="first_name" required placeholder="<?php echo e(__('John')); ?>">
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-6">
                                <label for="fn" class="form-label fs-base"><?php echo e(__('last name')); ?></label>
                                <input type="text" class="form-control form-control-lg" id="fn" value="<?php echo e(old('last_name')); ?>" name="last_name" required placeholder="<?php echo e(__('Doe')); ?>">
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <label for="email" class="form-label fs-base"><?php echo e(__('Email address')); ?></label>
                                <input type="email" class="form-control form-control-lg" value="<?php echo e(old('email')); ?>" id="email" name="email" required placeholder="<?php echo e(__('mail@mail.com')); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <label for="phone" class="form-label fs-base"><?php echo e(__('Phone')); ?></label>
                                <input type="hidden" name="code" id="code" class="text-uppercase">
                                <input type="tel" name="phone" id="phone" value="<?php echo e(old('phone')); ?>" class="form-control form-control-lg" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <label for="subject" class="form-label fs-base"><?php echo e(__('Subject')); ?></label>
                                <input type="text" class="form-control form-control-lg" value="<?php echo e(old('subject')); ?>" id="subject" name="subject" required placeholder="<?php echo e(__('Subject')); ?>">
                                <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <label for="message" class="form-label fs-base"><?php echo e(__('Message')); ?></label>
                                <textarea class="form-control" id="message" name="message" rows="3" required placeholder="<?php echo e(__('Hi there, I would like to ...')); ?>"><?php echo e(old('message')); ?></textarea>
                                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php if($set->recaptcha==1): ?>
                            <?php echo RecaptchaV3::field('contact'); ?>

                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="form-text"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php endif; ?>
                            <div class="col-12 pt-2 pt-sm-3">
                                <button type="submit" class="btn btn-lg btn-info w-100 w-sm-auto"><?php echo e(__('Send Message')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="position-absolute bottom-0 start-0 w-100 bg-light" style="height: 8rem;"></div>
</section>
<?php echo $__env->make('partials.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('front/vendor/jquery/dist/jquery.min.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script>
    const phoneInputField = document.querySelector("#phone");
    const phoneInput = window.intlTelInput(phoneInputField, {
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
    });
    var old = "<?php echo e(old('code')); ?>";
    if (old.trim() != '') {
        phoneInput.setCountry(old)
    }
    $('#code').val(phoneInput.getSelectedCountryData().iso2);
    phoneInputField.addEventListener("countrychange", function() {
        $('#code').val(phoneInput.getSelectedCountryData().iso2);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alphawea/public_html/credisava.com/resources/views/front/contact.blade.php ENDPATH**/ ?>