<meta name="description" content="<?php echo e(Str::words(strip_tags($article->details), 25)); ?>" />
<meta property="og:type" content="website">
<meta property="og:title" content="<?php echo e($article->title); ?>">
<meta property="og:description" content="<?php echo e(strip_tags($article->details)); ?>">
<meta property="og:image" content="<?php echo e($article->image); ?>" />
<meta property="og:url" content="<?php echo e(route('blog.article', ['article' => $article->slug])); ?>">
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="position-relative py-lg-5 pt-5">
    <div class="container position-relative zindex-2 pt-5 pb-2 pb-md-0 py-6">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><i class="bx bx-home-alt fs-lg me-1"></i> <?php echo e(__('Home')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('blog')); ?>"><?php echo e(__('Newsroom')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('blog.category', ['category' => $article->category->id, 'slug' => Str::slug($article->category->name)])); ?>"><?php echo e($article->category->name); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Article')); ?></li>
            </ol>
        </nav>
        <div class="row justify-content-center pt-3 mt-3">
            <div class="col-12 text-left">
                <h1 class="mb-4 h2"><?php echo e($article->title); ?></h1>
                <p class="fs-sm pb-3 mb-3 text-dark"><i class="fal fa-calendar-alt"></i> <?php echo e(Carbon\Carbon::create($article->updated_at)->format('M j, Y')); ?></p>
            </div>
        </div>
        <div class="row align-items-center">
            <div class="col-md-6 text-start mb-3">
                <p class="fs-sm mb-0"><span class="badge bg-faded-primary text-primary fs-base"><?php echo e($article->category->name); ?></span> <span class="dot"></span><?php echo e(estimateReadingTime($article->details)); ?> <?php echo e(__('read')); ?></p>
            </div>

            <div class="col-md-6 text-md-end">
                <!-- Icons -->
                <ul class="d-inline list-unstyled list-inline list-social">
                    <li class="list-inline-item list-social-item me-3">
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('blog.article', ['article' => $article->slug])); ?>" class="btn btn-icon btn-secondary btn-facebook btn-sm">
                            <i class="fab fa-facebook"></i>
                        </a>
                    </li>
                    <li class="list-inline-item list-social-item me-3">
                        <a href="https://twitter.com/intent/tweet?text=<?php echo e(route('blog.article', ['article' => $article->slug])); ?>" class="btn btn-icon btn-secondary btn-facebook btn-sm">
                            <i class="fab fa-twitter"></i>
                        </a>
                    </li>
                    <li class="list-inline-item list-social-item me-3">
                        <a href="https://wa.me/?text=<?php echo e(route('blog.article', ['article' => $article->slug])); ?>" class="btn btn-icon btn-secondary btn-facebook btn-sm">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </li>
                    <li class="list-inline-item list-social-item me-3">
                        <a href="mailto:?body=<?php echo e(route('blog.article', ['article' => $article->slug])); ?>" class="btn btn-icon btn-secondary btn-facebook btn-sm">
                            <i class="fal fa-envelope"></i>
                        </a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</section>
<section class="container mb-5 pt-4 pb-2 py-mg-4">
    <div class="row gy-4">

        <!-- Content -->
        <div class="col-lg-8">
            <div class="mb-5 text-center">
                <img class="rounded" src="<?php echo e(url('/').'/storage/app/'.$article->image); ?>" alt="<?php echo e($article->name); ?>">
            </div>
            <p class="text-start"><?php echo $article->details; ?></p>
        </div>

        <!-- Sharing -->
        <div class="col-lg-4 position-relative">
            <div class="sticky-top ms-xl-5 ms-lg-4 ps-xxl-4" style="top: 105px !important;">
                <form class="input-group mb-4" action="<?php echo e(route('blog.search')); ?>" method="post" autocomplete="off">
                    <?php echo csrf_field(); ?>
                    <input type="text" name="term" placeholder="Search the blog..." class="form-control rounded pe-5">
                    <i class="bx bx-search position-absolute top-50 end-0 translate-middle-y me-3 fs-lg zindex-5"></i>
                </form>

                <!-- Categories -->
                <div class="card card-body mb-4 border">
                    <h3 class="h5"><?php echo e(__('Categories')); ?></h3>
                    <ul class="nav flex-column fs-sm">
                        <li class="nav-item mb-1">
                            <a href="<?php echo e(route('blog')); ?>" class="nav-link py-1 px-0 active"><?php echo e(__('All topics')); ?></a>
                        </li>
                        <?php $__currentLoopData = getCat(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item mb-1">
                            <a href="<?php echo e(route('blog.category', ['category' => $val->id, 'slug' => Str::slug($val->name)])); ?>" class="nav-link py-1 px-0"><?php echo e($val->name); ?>(<?php echo e($val->articles->count()); ?>)</a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <!-- Popular posts -->
                <div class="card card-body border-0 position-relative mb-4">
                    <span class="position-absolute top-0 start-0 w-100 h-100 bg-gradient-primary opacity-10 rounded-3"></span>
                    <div class="position-relative zindex-2">
                        <h3 class="h5"><?php echo e(__('Popular posts')); ?></h3>
                        <ul class="list-unstyled mb-0">
                            <?php $__currentLoopData = getPopularBlog(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="border-bottom pb-3 mb-3 cursor-pointer <?php if($loop->last == $val->id): ?>border-bottom-0 <?php endif; ?>" data-href="<?php echo e(route('blog.article', ['article' => $val->slug])); ?>">
                                <h4 class="h6 mb-2"><?php echo e(Str::words($val->title, 10)); ?></h4>
                                <div class="d-flex align-items-center text-muted pt-1">
                                    <div class="fs-xs border-end pe-3 me-3"><?php echo e($val->created_at->format('M j, Y')); ?></div>
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="bg-secondary pb-5">
    <div class="container pt-2 pt-lg-4 pt-xl-5">
        <h2 class="h3 mb-4 pb-lg-3 pt-lg-1 pb-1 text-left"><?php echo e(__('Related articles')); ?></h2>
        <div class="row mb-6">
            <?php $__currentLoopData = getRelatedBlog(3, $article->cat_id, $article->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-md-6 col-lg-4 d-flex cursor-pointer" data-href="<?php echo e(route('blog.article', ['article' => $val->slug])); ?>">
                <article class="card border-0 h-100 mx-1">
                    <div class="position-relative">
                        <img src="<?php echo e(url('/').'/storage/app/'.$val->image); ?>" class="card-img-top" alt="<?php echo e($val->title); ?>">
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <span class="badge fs-sm text-nav bg-secondary text-decoration-none"><?php echo e($val->category->name); ?></span>
                        </div>
                        <h4><?php echo e(Str::words($val->title, 10)); ?></h3>
                            <p class="mb-0 text-dark fs-sm"><?php echo e(Str::words(strip_tags(html_entity_decode(trim($val->details))), 20)); ?></p>
                    </div>
                    <div class="card-footer">
                        <p class="fs-sm text-uppercase text-muted mb-0 ms-auto">
                            <time datetime="2019-05-02"><?php echo e($val->created_at->format('M j, Y')); ?></time>
                            <span class="dot"></span> <?php echo e(estimateReadingTime($val->details)); ?> <?php echo e(__('read')); ?>

                        </p>
                    </div>
                </article>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('front/vendor/jquery/dist/jquery.min.js')); ?>"></script>
<script>
    $('div[data-href]').on("click", function() {
        window.location.href = $(this).data('href');
    });    
    $('li[data-href]').on("click", function() {
        window.location.href = $(this).data('href');
    });
    $('h6[data-href]').on("click", function() {
        window.location.href = $(this).data('href');
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alphawea/public_html/credisava.com/resources/views/front/blog/article.blade.php ENDPATH**/ ?>