<meta name="description" content="<?php echo e($topic->description); ?>" />
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="position-relative py-lg-5 pt-5" style="background-image: url(<?php echo e(asset('asset/images/auth.svg')); ?>);" data-jarallax data-img-position="0% 100%" data-speed="0.5">
    <div class="container position-relative zindex-2 pt-5 pb-2 pb-md-0 py-6">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><i class="bx bx-home-alt fs-lg me-1"></i> <?php echo e(__('Home')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('help.center')); ?>"><?php echo e(__('Help Center')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($topic->name); ?></li>
            </ol>
        </nav>
        <div class="row justify-content-center pt-3 mt-3">
            <div class="col-xl-6 col-lg-7 col-md-8 col-sm-10 text-center">
                <h1 class="mb-4"><?php echo e($topic->name); ?></h1>
                <p class="fs-lg pb-3 mb-3"><?php echo e($topic->description); ?></p>
            </div>
        </div>
    </div>
</section>
<section class="container py-5 my-2 my-md-4 my-lg-5">
    <?php if($topic->faq->count()>0): ?>
    <div class="row pb-6">
        <div class="col-12 col-md-12">
            <div class="list-group list-group-flush">
                <?php $__currentLoopData = $topic->faq; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="list-group-item d-flex align-items-center cursor-pointer" data-href="<?php echo e(route('help.article', ['article' => $val->slug])); ?>">
                    <div class="me-auto">
                        <p class="fw-semibold mb-1 text-dark"><?php echo e($val->question); ?></p>
                        <p class="fs-sm mb-0"><?php echo e(Str::words(strip_tags($val->answer), 25)); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="row justify-content-center">
        <div class="col-12 col-xl-11">
            <h3 class="text-center mb-1">
                <?php echo e(__('No article found under this topic')); ?>

            </h3>
        </div>
    </div>
    <?php endif; ?>
</section>
<?php echo $__env->make('partials.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('front/vendor/jquery/dist/jquery.min.js')); ?>"></script>
<script>
    $('div[data-href]').on("click", function() {
        window.location.href = $(this).data('href');
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alphawea/public_html/credisava.com/resources/views/front/helpcenter/topic.blade.php ENDPATH**/ ?>